(ns vincit.dbwalk.action.writer
  "Utility for applying operations to the database.
   The input is a Loom digraph where the edges between nodes are towards
   the node with the foreign key. This allows correct insertion/deletion ordering by always handling
   nodes (rows) with no incoming edges, pushing the generated primary key to its children
   and repeating until the graph is empty. Each node must have a db operation (see v.d.a.operations) as an attr."

  (:require [vincit.dbwalk.graph :as graph]
            [vincit.dbwalk.action.operations :as ops]
            [vincit.dbwalk.utils :as utils]))

(defn- extract-primary-key [configuration data-source table entity]
  (get entity (utils/primary-key-column configuration data-source table)))

(defn apply-op-for-single-entity [configuration input-graph entity]
  (let [{:keys [data-source table insert-data]} (graph/get-data-for-node input-graph entity)
        operation (graph/operation input-graph entity)
        updated-entity (ops/apply-operation! configuration data-source operation table insert-data)
        primary-key (extract-primary-key configuration data-source table updated-entity)]
    (graph/update-key-to-children! input-graph entity primary-key)
    (graph/remove-node input-graph entity)))

(defn apply-operations [configuration input-graph]
  (when-let [first-level-data (seq (graph/root-items input-graph))]
    (run! #(apply-op-for-single-entity configuration input-graph %) first-level-data)
    (recur configuration input-graph)))

