(ns vincit.dbwalk.utils
  (:require [vincit.dbwalk.query-parser :as query]
            [schema.core :as s]
            [clojure.walk :as walk]))


(defn- merge-if-query [primary secondary]
  (if (and (map? primary)
           (contains? primary :query))
    (merge secondary primary)
    primary))

(s/defn with-datasource :- query/QueryTree
  "Merges the given data-source map with all queries in the query-tree,
                        not overwriting existing definitions"
  [data-source query-tree]
  (walk/postwalk #(merge-if-query % data-source) query-tree))

(defn first-datasource
  "Takes a random datasource from configuration.
  This is a helper function that can simplify writing your own API when only one datasource is used."
  [config]
  (first (keys (:dbwalk/relations config))))

(defn default-datasource
  "Returns a DatasourceDesctiption with the given database-id and default :type."

  [db-id]
  {:data-source db-id
   :type        :dbwalk/source-sql})
