(ns vincit.dbwalk.api.filters.configuration
  (:require [vincit.dbwalk.relations :as r]
            [vincit.dbwalk.crawler :refer [Configuration DataSourceDescription]]
            [schema.core :as s]))

(def NamespacedKeyword
  (s/pred #(and (keyword? %)
                (not (nil? (namespace %))))))

(s/defn single-filter [rel-name :- NamespacedKeyword]
  (fn [r]
    (let [table-name (keyword (namespace rel-name))
          column-name (keyword (name rel-name))]
      (not
        (or
          (and (= (r/source-table r) table-name)
               (= (r/source-property r) column-name))
          (and (= (r/target-table r) table-name)
               (= (r/target-property r) column-name)))))))


(s/defn filter-relations
  "Removes Relations from a Datasource"
  [configuration :- Configuration
   data-source :- DataSourceDescription
   filters :- [NamespacedKeyword]]
  (let [filter-fns (map single-filter filters)
        relations (get-in configuration [:dbwalk/relations data-source])
        filtered-relations (filter (apply every-pred filter-fns) relations)]
    (assoc-in configuration [:dbwalk/relations data-source] filtered-relations)))

