(ns vincit.dbwalk.query-parser
  "Simple getters for parsing the query tree."
  (:require [schema.core :as s]
            [vincit.dbwalk.relations :as relation]))



(s/defschema QueryTree
  "Format for nested database queries."
  {(s/required-key :data-source) s/Keyword
   (s/required-key :type) s/Keyword
   (s/required-key :query) (s/pred map?)
   (s/optional-key :eager) [(s/recursive #'QueryTree)]})

(s/defn query [node :- QueryTree]
  (:query node))

(s/defn from [node :- QueryTree]
  (first (:from (query node))))

(s/defn data-source-and-type [node :- QueryTree]
  (select-keys node [:data-source :type]))

(s/defn children [node :- QueryTree]
  (get node :eager []))

(s/defn selected [node :- QueryTree]
  (:select (query node)))


(defmulti compare-target-with-query "Compares a QueryTree node to Relation's target"
          (fn [query-tree relation]
            (:type query-tree)))

(defmethod compare-target-with-query :dbwalk/source-sql [query-tree relation]
  (and
    (= (relation/to-data-source relation) (data-source-and-type query-tree))
    (= (relation/target-table relation) (from query-tree))))


(defmulti compare-source-with-query "Compares a QueryTree node to Relation's source"
          (fn [query-tree relation]
            (:type query-tree)))

(defmethod compare-source-with-query :dbwalk/source-sql [query-tree relation]
  (and
    (= (relation/from-data-source relation) (data-source-and-type query-tree))
    (= (relation/source-table relation) (from query-tree))))
