(ns vincit.dbwalk.output.flat
  "Flat output, where rows are grouped by table and the structure of the data is ignored."
  (:require [vincit.dbwalk.relations :as relation]
            [loom.graph :as lg]
            [vincit.dbwalk.entity-node :as en]))


(defn- extract-data [m]
  (into {} (for [[k v] m] [k (apply hash-set (map en/data v))])))

(defn dump [graph]
  (->> (lg/nodes graph)
       (group-by #(relation/target-table (en/join %)))
       (extract-data)))



