(ns vincit.dbwalk.output.map
  "The default output, where everything that was read from the DB is returned as a deep map."
  (:require [vincit.dbwalk.entity-node :as en]
            [vincit.dbwalk.graph :as graph]
            [vincit.dbwalk.relations :as relation]))

(defn- get-relation-name [graph from to]
  (relation/created-attribute-name (graph/relation-for-link graph from to)))

(defn- hierarchy-dump-graph-from-node
  "Recursively dump subgraph starting from node."
  [graph start-node]
  (if-let [children (seq (loom.graph/successors graph start-node))]
    (->> children
         (graph/to-insertion-order graph)
         (map #(hash-map
                (get-relation-name graph start-node %)
                [(hierarchy-dump-graph-from-node graph %)]))
         (apply merge-with #(vec (concat %1 %2)))
         (hash-map :data)
         (apply merge start-node))
    start-node))

(defn to-map
  "Returns the graph as a list of root entities, where each entity
  is merged with { tablename -> seq of eagerly fetched items for each :eager query. }"
  [graph]
  (en/data-only
    (->> (graph/find-root-items graph)
         (graph/to-insertion-order graph)
         (map (partial hierarchy-dump-graph-from-node graph))
         (vec))))
