/*
 * Decompiled with CFR 0.152.
 */
package vimclojure.nailgun;

import java.io.IOException;
import java.io.InputStream;

public class ThreadLocalInputStream
extends InputStream {
    private InheritableThreadLocal streams = new InheritableThreadLocal();
    private InputStream defaultInputStream = null;

    ThreadLocalInputStream(InputStream defaultInputStream) {
        this.defaultInputStream = defaultInputStream;
        this.init(null);
    }

    public void init(InputStream streamForCurrentThread) {
        this.streams.set(streamForCurrentThread);
    }

    public InputStream getInputStream() {
        InputStream result = (InputStream)this.streams.get();
        return result == null ? this.defaultInputStream : result;
    }

    @Override
    public int available() throws IOException {
        return this.getInputStream().available();
    }

    @Override
    public void close() throws IOException {
        this.getInputStream().close();
    }

    @Override
    public void mark(int readlimit) {
        this.getInputStream().mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.getInputStream().markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.getInputStream().read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.getInputStream().read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.getInputStream().read(b, off, len);
    }

    @Override
    public void reset() throws IOException {
        this.getInputStream().reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.getInputStream().skip(n);
    }
}

