/*
 * Decompiled with CFR 0.152.
 */
package vimclojure.nailgun;

import clojure.lang.RT;
import clojure.lang.Symbol;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import vimclojure.nailgun.Alias;
import vimclojure.nailgun.AliasManager;
import vimclojure.nailgun.NGSecurityManager;
import vimclojure.nailgun.NGSession;
import vimclojure.nailgun.NGSessionPool;
import vimclojure.nailgun.NailStats;
import vimclojure.nailgun.ThreadLocalInputStream;
import vimclojure.nailgun.ThreadLocalPrintStream;
import vimclojure.nailgun.builtins.DefaultNail;

public class NGServer
implements Runnable {
    private InetAddress addr = null;
    private int port = 0;
    private ServerSocket serversocket;
    private boolean shutdown = false;
    private boolean running = false;
    private AliasManager aliasManager;
    private boolean allowNailsByClassName = true;
    private Class defaultNailClass = null;
    private NGSessionPool sessionPool = null;
    public final PrintStream out = System.out;
    public final PrintStream err = System.err;
    public final InputStream in = System.in;
    private Map allNailStats = null;
    private SecurityManager originalSecurityManager = null;

    public NGServer(InetAddress addr, int port) {
        this.init(addr, port);
    }

    public NGServer() {
        this.init(null, 2113);
    }

    private void init(InetAddress addr, int port) {
        this.addr = addr;
        this.port = port;
        this.aliasManager = new AliasManager();
        this.allNailStats = new HashMap();
        this.sessionPool = new NGSessionPool(this, 10);
    }

    public void setAllowNailsByClassName(boolean allowNailsByClassName) {
        this.allowNailsByClassName = allowNailsByClassName;
    }

    public boolean allowsNailsByClassName() {
        return this.allowNailsByClassName;
    }

    public void setDefaultNailClass(Class defaultNailClass) {
        this.defaultNailClass = defaultNailClass;
    }

    public Class getDefaultNailClass() {
        return this.defaultNailClass == null ? DefaultNail.class : this.defaultNailClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NailStats getOrCreateStatsFor(Class nailClass) {
        NailStats result = null;
        Map map = this.allNailStats;
        synchronized (map) {
            result = (NailStats)this.allNailStats.get(nailClass);
            if (result == null) {
                result = new NailStats(nailClass);
                this.allNailStats.put(nailClass, result);
            }
        }
        return result;
    }

    void nailStarted(Class nailClass) {
        NailStats stats = this.getOrCreateStatsFor(nailClass);
        stats.nailStarted();
    }

    void nailFinished(Class nailClass) {
        NailStats stats = (NailStats)this.allNailStats.get(nailClass);
        stats.nailFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getNailStats() {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        Map map = this.allNailStats;
        synchronized (map) {
            for (Class nailclass : this.allNailStats.keySet()) {
                result.put(nailclass.getName(), ((NailStats)this.allNailStats.get(nailclass)).clone());
            }
        }
        return result;
    }

    public AliasManager getAliasManager() {
        return this.aliasManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean exitVM) {
        NGServer nGServer = this;
        synchronized (nGServer) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        try {
            this.serversocket.close();
        }
        catch (Throwable toDiscard) {
            // empty catch block
        }
        this.sessionPool.shutdown();
        Class[] argTypes = new Class[]{NGServer.class};
        Object[] argValues = new Object[]{this};
        for (Alias alias : this.getAliasManager().getAliases()) {
            this.getOrCreateStatsFor(alias.getAliasedClass());
        }
        Map map = this.allNailStats;
        synchronized (map) {
            for (NailStats ns : this.allNailStats.values()) {
                Class nailClass = ns.getNailClass();
                try {
                    Method nailShutdown = nailClass.getMethod("nailShutdown", argTypes);
                    nailShutdown.invoke(null, argValues);
                }
                catch (Throwable toDiscard) {}
            }
        }
        System.setIn(this.in);
        System.setOut(this.out);
        System.setErr(this.err);
        System.setSecurityManager(this.originalSecurityManager);
        if (exitVM) {
            System.exit(0);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPort() {
        return this.serversocket == null ? this.port : this.serversocket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        NGSession sessionOnDeck;
        block8: {
            this.running = true;
            sessionOnDeck = null;
            this.originalSecurityManager = System.getSecurityManager();
            System.setSecurityManager(new NGSecurityManager(this.originalSecurityManager));
            InputStream inputStream = System.in;
            synchronized (inputStream) {
                if (!(System.in instanceof ThreadLocalInputStream)) {
                    System.setIn(new ThreadLocalInputStream(this.in));
                    System.setOut(new ThreadLocalPrintStream(this.out));
                    System.setErr(new ThreadLocalPrintStream(this.err));
                }
            }
            try {
                this.serversocket = this.addr == null ? new ServerSocket(this.port) : new ServerSocket(this.port, 0, this.addr);
                while (!this.shutdown) {
                    sessionOnDeck = this.sessionPool.take();
                    Socket socket = this.serversocket.accept();
                    Thread.sleep(50L);
                    sessionOnDeck.run(socket);
                }
            }
            catch (Throwable t) {
                if (this.shutdown) break block8;
                t.printStackTrace();
            }
        }
        if (sessionOnDeck != null) {
            sessionOnDeck.shutdown();
        }
        this.running = false;
    }

    private static void usage() {
        System.err.println("Usage: java vimclojure.nailgun.NGServer");
        System.err.println("   or: java vimclojure.nailgun.NGServer port");
        System.err.println("   or: java vimclojure.nailgun.NGServer IPAddress");
        System.err.println("   or: java vimclojure.nailgun.NGServer IPAddress:port");
    }

    public static void main(String[] args) throws NumberFormatException, UnknownHostException {
        if (args.length > 1) {
            NGServer.usage();
            return;
        }
        InetAddress serverAddress = null;
        int port = 2113;
        if (args.length != 0) {
            String[] argParts = args[0].split(":");
            String addrPart = null;
            String portPart = null;
            if (argParts.length == 2) {
                addrPart = argParts[0];
                portPart = argParts[1];
            } else if (argParts[0].indexOf(46) >= 0) {
                addrPart = argParts[0];
            } else {
                portPart = argParts[0];
            }
            if (addrPart != null) {
                serverAddress = InetAddress.getByName(addrPart);
            }
            if (portPart != null) {
                port = Integer.parseInt(portPart);
            }
        }
        try {
            Class.forName("clojure.lang.IFn");
        }
        catch (ClassNotFoundException ignore) {
            System.err.println("ERROR: Could not find clojure.lang.IFn on the classpath!");
            System.err.println("ERROR: This most likely means that Clojure is not on the classpath!");
            System.err.println("ERROR: Please check your settings!");
            System.err.println("ERROR: Here is the classpath for your reference:");
            System.err.println(System.getProperty("java.class.path"));
            return;
        }
        NGServer server = new NGServer(serverAddress, port);
        Thread t = new Thread(server);
        t.setName("NGServer(" + serverAddress + ", " + port + ")");
        t.start();
        Runtime.getRuntime().addShutdownHook(new NGServerShutdowner(server));
        int runningPort = server.getPort();
        while (runningPort == 0) {
            try {
                Thread.sleep(50L);
            }
            catch (Throwable toIgnore) {
                // empty catch block
            }
            runningPort = server.getPort();
        }
        System.out.println("NGServer started on " + (serverAddress == null ? "all interfaces" : serverAddress.getHostAddress()) + ", port " + runningPort + ".");
    }

    static {
        try {
            RT.var((String)"clojure.core", (String)"require").invoke((Object)Symbol.create((String)"vimclojure.core"));
            RT.var((String)"vimclojure.core", (String)"init-server").invoke();
        }
        catch (Exception exc) {
            Exception e = exc;
            System.err.println("A crisis has arisen:");
            e.printStackTrace();
        }
    }

    private static class NGServerShutdowner
    extends Thread {
        private NGServer server = null;

        NGServerShutdowner(NGServer server) {
            this.server = server;
        }

        public void run() {
            this.server.shutdown(false);
            for (int count = 0; this.server.isRunning() && count < 50; ++count) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.server.isRunning()) {
                System.err.println("Unable to cleanly shutdown server.  Exiting JVM Anyway.");
            } else {
                System.out.println("NGServer shut down.");
            }
        }
    }
}

