/*
 * Decompiled with CFR 0.152.
 */
package vimclojure.nailgun;

import java.io.DataInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.tools.ant.ExitException;
import vimclojure.nailgun.Alias;
import vimclojure.nailgun.LongUtils;
import vimclojure.nailgun.NGContext;
import vimclojure.nailgun.NGInputStream;
import vimclojure.nailgun.NGOutputStream;
import vimclojure.nailgun.NGSecurityManager;
import vimclojure.nailgun.NGServer;
import vimclojure.nailgun.NGSessionPool;
import vimclojure.nailgun.ThreadLocalInputStream;
import vimclojure.nailgun.ThreadLocalPrintStream;

class NGSession
extends Thread {
    private NGServer server = null;
    private NGSessionPool sessionPool = null;
    private Object lock = new Object();
    private Socket nextSocket = null;
    private boolean done = false;
    private long instanceNumber = 0L;
    private static Object sharedLock = new Object();
    private static long instanceCounter = 0L;
    private static Class[] mainSignature = new Class[1];
    private static Class[] nailMainSignature;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NGSession(NGSessionPool sessionPool, NGServer server) {
        this.sessionPool = sessionPool;
        this.server = server;
        Object object = sharedLock;
        synchronized (object) {
            this.instanceNumber = ++instanceCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.done = true;
        Object object = this.lock;
        synchronized (object) {
            this.nextSocket = null;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Socket socket) {
        Object object = this.lock;
        synchronized (object) {
            this.nextSocket = socket;
            this.lock.notify();
        }
        Thread.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket nextSocket() {
        Socket result = null;
        Object object = this.lock;
        synchronized (object) {
            result = this.nextSocket;
            while (!this.done && result == null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    this.done = true;
                }
                result = this.nextSocket;
            }
            this.nextSocket = null;
        }
        return result;
    }

    public void run() {
        this.updateThreadName(null);
        Socket socket = this.nextSocket();
        while (socket != null) {
            try {
                block23: {
                    byte[] lbuf = new byte[5];
                    DataInputStream sockin = new DataInputStream(socket.getInputStream());
                    OutputStream sockout = socket.getOutputStream();
                    ArrayList<String> remoteArgs = new ArrayList<String>();
                    Properties remoteEnv = new Properties();
                    String cwd = null;
                    String command = null;
                    while (command == null) {
                        sockin.readFully(lbuf);
                        long bytesToRead = LongUtils.fromArray(lbuf, 0);
                        char chunkType = (char)lbuf[4];
                        byte[] b = new byte[(int)bytesToRead];
                        sockin.readFully(b);
                        String line = new String(b, "US-ASCII");
                        switch (chunkType) {
                            case 'A': {
                                remoteArgs.add(line);
                                break;
                            }
                            case 'E': {
                                int equalsIndex = line.indexOf(61);
                                if (equalsIndex > 0) {
                                    remoteEnv.setProperty(line.substring(0, equalsIndex), line.substring(equalsIndex + 1));
                                }
                                String key = line.substring(0, equalsIndex);
                                break;
                            }
                            case 'C': {
                                command = line;
                                break;
                            }
                            case 'D': {
                                cwd = line;
                                break;
                            }
                        }
                    }
                    this.updateThreadName(socket.getInetAddress().getHostAddress() + ": " + command);
                    NGInputStream in = new NGInputStream(sockin);
                    PrintStream out = new PrintStream(new NGOutputStream(sockout, '1'));
                    PrintStream err = new PrintStream(new NGOutputStream(sockout, '2'));
                    PrintStream exit = new PrintStream(new NGOutputStream(sockout, 'X'));
                    ((ThreadLocalInputStream)System.in).init(in);
                    ((ThreadLocalPrintStream)System.out).init(out);
                    ((ThreadLocalPrintStream)System.err).init(err);
                    try {
                        Alias alias = this.server.getAliasManager().getAlias(command);
                        Class cmdclass = null;
                        cmdclass = alias != null ? alias.getAliasedClass() : (this.server.allowsNailsByClassName() ? Class.forName(command) : this.server.getDefaultNailClass());
                        Object[] methodArgs = new Object[1];
                        Method mainMethod = null;
                        String[] cmdlineArgs = remoteArgs.toArray(new String[remoteArgs.size()]);
                        try {
                            mainMethod = cmdclass.getMethod("nailMain", nailMainSignature);
                            NGContext context = new NGContext();
                            context.setArgs(cmdlineArgs);
                            context.in = in;
                            context.out = out;
                            context.err = err;
                            context.setCommand(command);
                            context.setExitStream(exit);
                            context.setNGServer(this.server);
                            context.setEnv(remoteEnv);
                            context.setInetAddress(socket.getInetAddress());
                            context.setPort(socket.getPort());
                            context.setWorkingDirectory(cwd);
                            methodArgs[0] = context;
                        }
                        catch (NoSuchMethodException toDiscard) {
                            // empty catch block
                        }
                        if (mainMethod == null) {
                            mainMethod = cmdclass.getMethod("main", mainSignature);
                            methodArgs[0] = cmdlineArgs;
                        }
                        if (mainMethod == null) break block23;
                        this.server.nailStarted(cmdclass);
                        NGSecurityManager.setExit(exit);
                        try {
                            mainMethod.invoke(null, methodArgs);
                        }
                        catch (InvocationTargetException ite) {
                            throw ite.getCause();
                        }
                        catch (Throwable t) {
                            throw t;
                        }
                        finally {
                            this.server.nailFinished(cmdclass);
                        }
                        exit.println(0);
                    }
                    catch (ExitException exitEx) {
                        exit.println(exitEx.getStatus());
                        this.server.out.println(Thread.currentThread().getName() + " exited with status " + exitEx.getStatus());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        exit.println(899);
                    }
                }
                socket.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ((ThreadLocalInputStream)System.in).init(null);
            ((ThreadLocalPrintStream)System.out).init(null);
            ((ThreadLocalPrintStream)System.err).init(null);
            this.updateThreadName(null);
            this.sessionPool.give(this);
            socket = this.nextSocket();
        }
    }

    private void updateThreadName(String detail) {
        this.setName("NGSession " + this.instanceNumber + ": " + (detail == null ? "(idle)" : detail));
    }

    static {
        NGSession.mainSignature[0] = String[].class;
        nailMainSignature = new Class[1];
        NGSession.nailMainSignature[0] = NGContext.class;
    }
}

