(ns s3-cljs.macros
  (:require cljs.analyzer))

(defmacro defn.s3 [name args & body]
  `(let [func-name# ~(str (:name (cljs.analyzer/resolve-var &env name)))]
     (defn ~name ~args
       (if s3-cljs.core/s3
         (do ~@body)
         (throw (str func-name# ": s3 is not initialized"))))))
