(ns ^:shared konserve.protocols)

(defprotocol IAsyncKeyValueStore
  (-get-in [this key-vec] "Returns the value stored described by key-vec or nil if the path is not resolvable.")
         (-get [this key] "Returns the value stored at key or nil if the path is not resolvable. Value is stored as JSON and not EDN.")
  (-assoc-in [this key-vec value] "Associates the key-vec to the value, any missing collections for the key-vec (nested maps and vectors) are newly created.")
         (-assoc [this key value] "Associates the key to the value. Value is stored as JSON and not EDN.")
  (-update-in [this key-vec up-fn] "Updates a position described by key-vec by applying up-fn and storing the result atomically. Returns a vector [old new] of the previous value and the result of applying up-fn (the newly stored value)." ))

;;;;;;;;;;;; This file autogenerated from src/cljx/konserve/protocols.cljx
