(ns gadjett.basic)

(defmacro dbg[x]
  (when *assert*
    `(let [x# ~x]
       (println (str '~x ": ") x#)
       x#)))

(defmacro dbgdef [x]
  (when *assert*
    (let [y (gensym "yyy")]
      `(let [x# ~x]
         (def ~y x#)
         (println (str "(" '~y ")  " '~x  " => " x#))
         x#))))

(defn ns-unmap-all
  "Removes the mappings for all the symbols of the current namespace.
  Useful when the REPL doesn't let you require a namespace because a symbol already refers to ... "
  []
  (println (ns-name *ns*))
  (doseq [[s] (ns-refers (ns-name *ns*))]
    (ns-unmap (ns-name *ns*) s)))
