// Compiled by ClojureScript 1.9.227 {}
goog.provide('gadjett.linear');
goog.require('cljs.core');
gadjett.linear.highest_below_y = (function gadjett$linear$highest_below_y(m,v){
return cljs.core.second.call(null,cljs.core.last.call(null,cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,cljs.core.second,cljs.core.filter.call(null,(function (p__13459){
var vec__13460 = p__13459;
var x = cljs.core.nth.call(null,vec__13460,(0),null);
var y = cljs.core.nth.call(null,vec__13460,(1),null);
return (y <= v);
}),m)))));
});
gadjett.linear.lowest_above_y = (function gadjett$linear$lowest_above_y(m,v){
return cljs.core.second.call(null,cljs.core.first.call(null,cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,cljs.core.second,cljs.core.filter.call(null,(function (p__13467){
var vec__13468 = p__13467;
var x = cljs.core.nth.call(null,vec__13468,(0),null);
var y = cljs.core.nth.call(null,vec__13468,(1),null);
return (y >= v);
}),m)))));
});
gadjett.linear.highest_below_x = (function gadjett$linear$highest_below_x(m,v){
return cljs.core.second.call(null,cljs.core.last.call(null,cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__13475){
var vec__13476 = p__13475;
var x = cljs.core.nth.call(null,vec__13476,(0),null);
var y = cljs.core.nth.call(null,vec__13476,(1),null);
return (x <= v);
}),m)))));
});
gadjett.linear.lowest_above_x = (function gadjett$linear$lowest_above_x(m,v){
return cljs.core.second.call(null,cljs.core.first.call(null,cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__13483){
var vec__13484 = p__13483;
var x = cljs.core.nth.call(null,vec__13484,(0),null);
var y = cljs.core.nth.call(null,vec__13484,(1),null);
return (x >= v);
}),m)))));
});
gadjett.linear.find_keys_with_values_in = (function gadjett$linear$find_keys_with_values_in(m,s){
return cljs.core.filter.call(null,cljs.core.comp.call(null,s,m),cljs.core.keys.call(null,m));
});
gadjett.linear.find_keys_with_value = (function gadjett$linear$find_keys_with_value(m,v){
return gadjett.linear.find_keys_with_values_in.call(null,m,cljs.core.PersistentHashSet.fromArray([v], true));
});
gadjett.linear.linear_y = (function gadjett$linear$linear_y(x,x1,y1,x2,y2){
return (y1 + (((y2 - y1) * (x - x1)) / (x2 - x1)));
});
gadjett.linear.log_x_linear_y = (function gadjett$linear$log_x_linear_y(x,x1,y1,x2,y2){
return (y1 + (((y2 - y1) * (Math.log(x) - Math.log(x1))) / (Math.log(x2) - Math.log(x1))));
});
gadjett.linear.linear_y_func = (function gadjett$linear$linear_y_func(p__13487){
var map__13491 = p__13487;
var map__13491__$1 = ((((!((map__13491 == null)))?((((map__13491.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13491.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13491):map__13491);
var axes = map__13491__$1;
var x = cljs.core.get.call(null,map__13491__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.call(null,map__13491__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var G__13493 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__13493)){
return gadjett.linear.linear_y;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__13493)){
return gadjett.linear.log_x_linear_y;
} else {
return gadjett.linear.linear_y;

}
}
});
gadjett.linear.interpolate_linear_y = (function gadjett$linear$interpolate_linear_y(var_args){
var args__8122__auto__ = [];
var len__8115__auto___13506 = arguments.length;
var i__8116__auto___13507 = (0);
while(true){
if((i__8116__auto___13507 < len__8115__auto___13506)){
args__8122__auto__.push((arguments[i__8116__auto___13507]));

var G__13508 = (i__8116__auto___13507 + (1));
i__8116__auto___13507 = G__13508;
continue;
} else {
}
break;
}

var argseq__8123__auto__ = ((((2) < args__8122__auto__.length))?(new cljs.core.IndexedSeq(args__8122__auto__.slice((2)),(0),null)):null);
return gadjett.linear.interpolate_linear_y.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8123__auto__);
});

gadjett.linear.interpolate_linear_y.cljs$core$IFn$_invoke$arity$variadic = (function (m,x,p__13497){
var map__13498 = p__13497;
var map__13498__$1 = ((((!((map__13498 == null)))?((((map__13498.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13498.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13498):map__13498);
var interpolate_QMARK_ = cljs.core.get.call(null,map__13498__$1,new cljs.core.Keyword(null,"interpolate?","interpolate?",-423156286),cljs.core.constantly.call(null,true));
var axes = cljs.core.get.call(null,map__13498__$1,new cljs.core.Keyword(null,"axes","axes",1970866440),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"linear","linear",872268697)], null));
var or__6932__auto__ = cljs.core.get.call(null,m,x);
if(cljs.core.truth_(or__6932__auto__)){
return or__6932__auto__;
} else {
var vec__13500 = cljs.core.last.call(null,cljs.core.sort.call(null,gadjett.linear.highest_below_x.call(null,m,x)));
var x_below = cljs.core.nth.call(null,vec__13500,(0),null);
var y_below = cljs.core.nth.call(null,vec__13500,(1),null);
var vec__13503 = cljs.core.first.call(null,cljs.core.sort.call(null,gadjett.linear.lowest_above_x.call(null,m,x)));
var x_above = cljs.core.nth.call(null,vec__13503,(0),null);
var y_above = cljs.core.nth.call(null,vec__13503,(1),null);
if(cljs.core.truth_((function (){var and__6920__auto__ = x_below;
if(cljs.core.truth_(and__6920__auto__)){
var and__6920__auto____$1 = x_above;
if(cljs.core.truth_(and__6920__auto____$1)){
return interpolate_QMARK_.call(null,x_below,x_above);
} else {
return and__6920__auto____$1;
}
} else {
return and__6920__auto__;
}
})())){
return gadjett.linear.linear_y_func.call(null,axes).call(null,x,x_below,y_below,x_above,y_above);
} else {
return null;
}
}
});

gadjett.linear.interpolate_linear_y.cljs$lang$maxFixedArity = (2);

gadjett.linear.interpolate_linear_y.cljs$lang$applyTo = (function (seq13494){
var G__13495 = cljs.core.first.call(null,seq13494);
var seq13494__$1 = cljs.core.next.call(null,seq13494);
var G__13496 = cljs.core.first.call(null,seq13494__$1);
var seq13494__$2 = cljs.core.next.call(null,seq13494__$1);
return gadjett.linear.interpolate_linear_y.cljs$core$IFn$_invoke$arity$variadic(G__13495,G__13496,seq13494__$2);
});

gadjett.linear.linear_x = (function gadjett$linear$linear_x(y,x1,y1,x2,y2){
return (x1 + (((x2 - x1) * (y - y1)) / (y2 - y1)));
});
gadjett.linear.linear_x_func = (function gadjett$linear$linear_x_func(p__13509){
var map__13513 = p__13509;
var map__13513__$1 = ((((!((map__13513 == null)))?((((map__13513.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13513.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13513):map__13513);
var axes = map__13513__$1;
var x = cljs.core.get.call(null,map__13513__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.call(null,map__13513__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var G__13515 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__13515)){
return gadjett.linear.linear_x;
} else {
return gadjett.linear.linear_x;

}
});
gadjett.linear.below_and_above_y = (function gadjett$linear$below_and_above_y(y,p__13516,p__13517){
var vec__13524 = p__13516;
var x1 = cljs.core.nth.call(null,vec__13524,(0),null);
var y1 = cljs.core.nth.call(null,vec__13524,(1),null);
var vec__13527 = p__13517;
var x2 = cljs.core.nth.call(null,vec__13527,(0),null);
var y2 = cljs.core.nth.call(null,vec__13527,(1),null);
if((((y1 < y)) && ((y < y2))) || (((y1 > y)) && ((y > y2)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x1,y1], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x2,y2], null)], null);
} else {
return null;
}
});
gadjett.linear.find_below_and_above_y = (function gadjett$linear$find_below_and_above_y(m,y){
var $ = cljs.core.map.call(null,cljs.core.vec,m);
var $__$1 = cljs.core.sort_by.call(null,cljs.core.first,$);
var $__$2 = cljs.core.map.call(null,cljs.core.partial.call(null,gadjett.linear.below_and_above_y,y),$__$1,cljs.core.rest.call(null,$__$1));
return cljs.core.remove.call(null,cljs.core.nil_QMARK_,$__$2);
});
gadjett.linear.calc_interpolated_values = (function gadjett$linear$calc_interpolated_values(m,y,interpolate_QMARK_,axes){
var $ = (function (p__13540){
var vec__13541 = p__13540;
var vec__13544 = cljs.core.nth.call(null,vec__13541,(0),null);
var x_below = cljs.core.nth.call(null,vec__13544,(0),null);
var y_below = cljs.core.nth.call(null,vec__13544,(1),null);
var vec__13547 = cljs.core.nth.call(null,vec__13541,(1),null);
var x_above = cljs.core.nth.call(null,vec__13547,(0),null);
var y_above = cljs.core.nth.call(null,vec__13547,(1),null);
if(cljs.core.truth_((function (){var and__6920__auto__ = y_below;
if(cljs.core.truth_(and__6920__auto__)){
var and__6920__auto____$1 = y_above;
if(cljs.core.truth_(and__6920__auto____$1)){
return interpolate_QMARK_.call(null,y_below,y_above);
} else {
return and__6920__auto____$1;
}
} else {
return and__6920__auto__;
}
})())){
return gadjett.linear.linear_x_func.call(null,axes).call(null,y,x_below,y_below,x_above,y_above);
} else {
return null;
}
});
return cljs.core.keep.call(null,$,gadjett.linear.find_below_and_above_y.call(null,m,y));
});
gadjett.linear.min_coll = (function gadjett$linear$min_coll(coll){
if(cljs.core.empty_QMARK_.call(null,coll)){
return null;
} else {
return cljs.core.apply.call(null,cljs.core.min,coll);
}
});
/**
 * Returns the interpolated x for a given y acording to the select-func thats passed
 * 
 * - `:interpolate?` -  a predicate for deciding eather to calc th interpolation or not.
 * -   `:axes` -  a map that defines what are the axes scales
 * -   `:select-func` - what functionality to use if there are multiple interpolated values
 * 
 * ~~~klipse
 *   (interpolate-linear-x {10 30 20 50 70 60} 32)
 * ~~~
 *   
 */
gadjett.linear.interpolate_linear_x = (function gadjett$linear$interpolate_linear_x(var_args){
var args__8122__auto__ = [];
var len__8115__auto___13556 = arguments.length;
var i__8116__auto___13557 = (0);
while(true){
if((i__8116__auto___13557 < len__8115__auto___13556)){
args__8122__auto__.push((arguments[i__8116__auto___13557]));

var G__13558 = (i__8116__auto___13557 + (1));
i__8116__auto___13557 = G__13558;
continue;
} else {
}
break;
}

var argseq__8123__auto__ = ((((2) < args__8122__auto__.length))?(new cljs.core.IndexedSeq(args__8122__auto__.slice((2)),(0),null)):null);
return gadjett.linear.interpolate_linear_x.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8123__auto__);
});

gadjett.linear.interpolate_linear_x.cljs$core$IFn$_invoke$arity$variadic = (function (m,y,p__13553){
var map__13554 = p__13553;
var map__13554__$1 = ((((!((map__13554 == null)))?((((map__13554.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13554.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13554):map__13554);
var interpolate_QMARK_ = cljs.core.get.call(null,map__13554__$1,new cljs.core.Keyword(null,"interpolate?","interpolate?",-423156286),cljs.core.constantly.call(null,true));
var axes = cljs.core.get.call(null,map__13554__$1,new cljs.core.Keyword(null,"axes","axes",1970866440),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"linear","linear",872268697)], null));
var select_func = cljs.core.get.call(null,map__13554__$1,new cljs.core.Keyword(null,"select-func","select-func",-1706031810),gadjett.linear.min_coll);
var values = gadjett.linear.find_keys_with_value.call(null,m,y);
var interpolated_values = gadjett.linear.calc_interpolated_values.call(null,m,y,interpolate_QMARK_,axes);
return select_func.call(null,cljs.core.concat.call(null,values,interpolated_values));
});

gadjett.linear.interpolate_linear_x.cljs$lang$maxFixedArity = (2);

gadjett.linear.interpolate_linear_x.cljs$lang$applyTo = (function (seq13550){
var G__13551 = cljs.core.first.call(null,seq13550);
var seq13550__$1 = cljs.core.next.call(null,seq13550);
var G__13552 = cljs.core.first.call(null,seq13550__$1);
var seq13550__$2 = cljs.core.next.call(null,seq13550__$1);
return gadjett.linear.interpolate_linear_x.cljs$core$IFn$_invoke$arity$variadic(G__13551,G__13552,seq13550__$2);
});

gadjett.linear.linear_equation = (function gadjett$linear$linear_equation(x1,y1,x2,y2){
var a = ((y1 - y2) / (x1 - x2));
var b = (y1 - (a * x1));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
});
gadjett.linear.log_x_linear_equation = (function gadjett$linear$log_x_linear_equation(x1,y1,x2,y2){
var a = ((y1 - y2) / (Math.log(x1) - Math.log(x2)));
var b = (y1 - (a * Math.log(x1)));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
});
gadjett.linear.linear_equation_func = (function gadjett$linear$linear_equation_func(p__13559){
var map__13563 = p__13559;
var map__13563__$1 = ((((!((map__13563 == null)))?((((map__13563.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13563.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13563):map__13563);
var axes = map__13563__$1;
var x = cljs.core.get.call(null,map__13563__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.call(null,map__13563__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var G__13565 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__13565)){
return gadjett.linear.linear_equation;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__13565)){
return gadjett.linear.log_x_linear_equation;
} else {
return gadjett.linear.linear_equation;

}
}
});
gadjett.linear.intersection_point = (function gadjett$linear$intersection_point(a1,b1,a2,b2){
var x = ((b2 - b1) / (a1 - a2));
var y = ((a1 * x) + b1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
});
gadjett.linear.log_x_intersection_point = (function gadjett$linear$log_x_intersection_point(a1,b1,a2,b2){
var x = ((b2 - b1) / (a1 - a2));
var y = ((a1 * x) + b1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [Math.exp(x),y], null);
});
gadjett.linear.intersection_point_func = (function gadjett$linear$intersection_point_func(p__13566){
var map__13570 = p__13566;
var map__13570__$1 = ((((!((map__13570 == null)))?((((map__13570.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13570.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13570):map__13570);
var axes = map__13570__$1;
var x = cljs.core.get.call(null,map__13570__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.call(null,map__13570__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var G__13572 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__13572)){
return gadjett.linear.intersection_point;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__13572)){
return gadjett.linear.log_x_intersection_point;
} else {
return gadjett.linear.intersection_point;

}
}
});
gadjett.linear.intersection_point_from_2_lines_points = (function gadjett$linear$intersection_point_from_2_lines_points(var_args){
var args__8122__auto__ = [];
var len__8115__auto___13596 = arguments.length;
var i__8116__auto___13597 = (0);
while(true){
if((i__8116__auto___13597 < len__8115__auto___13596)){
args__8122__auto__.push((arguments[i__8116__auto___13597]));

var G__13598 = (i__8116__auto___13597 + (1));
i__8116__auto___13597 = G__13598;
continue;
} else {
}
break;
}

var argseq__8123__auto__ = ((((2) < args__8122__auto__.length))?(new cljs.core.IndexedSeq(args__8122__auto__.slice((2)),(0),null)):null);
return gadjett.linear.intersection_point_from_2_lines_points.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8123__auto__);
});

gadjett.linear.intersection_point_from_2_lines_points.cljs$core$IFn$_invoke$arity$variadic = (function (p__13576,p__13577,p__13578){
var vec__13579 = p__13576;
var ax1 = cljs.core.nth.call(null,vec__13579,(0),null);
var ay1 = cljs.core.nth.call(null,vec__13579,(1),null);
var ax2 = cljs.core.nth.call(null,vec__13579,(2),null);
var ay2 = cljs.core.nth.call(null,vec__13579,(3),null);
var vec__13582 = p__13577;
var bx1 = cljs.core.nth.call(null,vec__13582,(0),null);
var by1 = cljs.core.nth.call(null,vec__13582,(1),null);
var bx2 = cljs.core.nth.call(null,vec__13582,(2),null);
var by2 = cljs.core.nth.call(null,vec__13582,(3),null);
var map__13585 = p__13578;
var map__13585__$1 = ((((!((map__13585 == null)))?((((map__13585.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13585.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13585):map__13585);
var axes = cljs.core.get.call(null,map__13585__$1,new cljs.core.Keyword(null,"axes","axes",1970866440),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"linear","linear",872268697)], null));
var vec__13587 = gadjett.linear.linear_equation_func.call(null,axes).call(null,ax1,ay1,ax2,ay2);
var a1 = cljs.core.nth.call(null,vec__13587,(0),null);
var b1 = cljs.core.nth.call(null,vec__13587,(1),null);
var vec__13590 = gadjett.linear.linear_equation_func.call(null,axes).call(null,bx1,by1,bx2,by2);
var a2 = cljs.core.nth.call(null,vec__13590,(0),null);
var b2 = cljs.core.nth.call(null,vec__13590,(1),null);
var vec__13593 = gadjett.linear.intersection_point_func.call(null,axes).call(null,a1,b1,a2,b2);
var x = cljs.core.nth.call(null,vec__13593,(0),null);
var y = cljs.core.nth.call(null,vec__13593,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
});

gadjett.linear.intersection_point_from_2_lines_points.cljs$lang$maxFixedArity = (2);

gadjett.linear.intersection_point_from_2_lines_points.cljs$lang$applyTo = (function (seq13573){
var G__13574 = cljs.core.first.call(null,seq13573);
var seq13573__$1 = cljs.core.next.call(null,seq13573);
var G__13575 = cljs.core.first.call(null,seq13573__$1);
var seq13573__$2 = cljs.core.next.call(null,seq13573__$1);
return gadjett.linear.intersection_point_from_2_lines_points.cljs$core$IFn$_invoke$arity$variadic(G__13574,G__13575,seq13573__$2);
});


//# sourceMappingURL=linear.js.map