// Compiled by ClojureScript 1.9.227 {}
goog.provide('gadjett.collections');
goog.require('cljs.core');
goog.require('clojure.zip');
goog.require('cljs.spec');
goog.require('cljs.spec.test');
goog.require('cljs.spec.impl.gen');
goog.require('clojure.set');
goog.require('clojure.string');
gadjett.collections.isNaN = isNaN;
cljs.spec.def_impl.call(null,new cljs.core.Keyword("gadjett.collections","number","gadjett.collections/number",1630126874),cljs.core.list(new cljs.core.Symbol("s","double-in","s/double-in",-303226784,null),new cljs.core.Keyword(null,"infinite?","infinite?",-2017886608),false,new cljs.core.Keyword(null,"NaN?","NaN?",-1917767651),false),cljs.spec.double_in.call(null,new cljs.core.Keyword(null,"infinite?","infinite?",-2017886608),false,new cljs.core.Keyword(null,"NaN?","NaN?",-1917767651),false));
cljs.spec.def_impl.call(null,new cljs.core.Keyword("gadjett.collections","not-nan-number","gadjett.collections/not-nan-number",491458217),cljs.core.list(new cljs.core.Symbol("cljs.spec","and","cljs.spec/and",-7296553,null),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null),cljs.core.list(new cljs.core.Symbol("s","double-in","s/double-in",-303226784,null),new cljs.core.Keyword(null,"NaN?","NaN?",-1917767651),false)),cljs.spec.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null),cljs.core.list(new cljs.core.Symbol("s","double-in","s/double-in",-303226784,null),new cljs.core.Keyword(null,"NaN?","NaN?",-1917767651),false)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.number_QMARK_,cljs.spec.double_in.call(null,new cljs.core.Keyword(null,"NaN?","NaN?",-1917767651),false)], null),null));
cljs.spec.def_impl.call(null,new cljs.core.Keyword("gadjett.collections","map","gadjett.collections/map",-1917712911),cljs.core.list(new cljs.core.Symbol("cljs.spec","every-kv","cljs.spec/every-kv",1657959642,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.every_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec","tuple","cljs.spec/tuple",500419708,null),new cljs.core.Symbol(null,"any?","any?",-318999933,null),new cljs.core.Symbol(null,"any?","any?",-318999933,null)),cljs.spec.tuple_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.any_QMARK_,cljs.core.any_QMARK_], null)),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"into","into",-150836029),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("cljs.spec","kfn","cljs.spec/kfn",293196937),(function (i__12028__auto__,v__12029__auto__){
return cljs.core.nth.call(null,v__12029__auto__,(0));
}),new cljs.core.Keyword("cljs.spec","kind-form","cljs.spec/kind-form",997489303),null], null),null));
cljs.spec.def_impl.call(null,new cljs.core.Keyword("gadjett.collections","predicate","gadjett.collections/predicate",850745368),cljs.core.list(new cljs.core.Symbol("cljs.spec","with-gen","cljs.spec/with-gen",-53488124,null),new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol("cljs.spec","gen","cljs.spec/gen",-2101972796,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null),null,new cljs.core.Symbol("cljs.core","string?","cljs.core/string?",-2072921719,null),null], null), null)))),cljs.spec.with_gen.call(null,cljs.core.fn_QMARK_,(function (){
return cljs.spec.gen.call(null,cljs.core.PersistentHashSet.fromArray([cljs.core.string_QMARK_,cljs.core.int_QMARK_], true));
})));
gadjett.collections.infinity = Infinity;
/**
 * Absolute value of a number
 * 
 * ~~~klipse
 *   (map abs (range -5 5))
 * ~~~
 */
gadjett.collections.abs = (function gadjett$collections$abs(x){
var x__7265__auto__ = x;
var y__7266__auto__ = (- x);
return ((x__7265__auto__ > y__7266__auto__) ? x__7265__auto__ : y__7266__auto__);
});
gadjett.collections.scale = (function gadjett$collections$scale(x,y){
if(((x === (0))) || ((y === (0)))){
return (1);
} else {
return gadjett.collections.abs.call(null,x);
}
});
gadjett.collections.almost_EQ_ = (function gadjett$collections$almost_EQ_(var_args){
var args13169 = [];
var len__8115__auto___13172 = arguments.length;
var i__8116__auto___13173 = (0);
while(true){
if((i__8116__auto___13173 < len__8115__auto___13172)){
args13169.push((arguments[i__8116__auto___13173]));

var G__13174 = (i__8116__auto___13173 + (1));
i__8116__auto___13173 = G__13174;
continue;
} else {
}
break;
}

var G__13171 = args13169.length;
switch (G__13171) {
case 2:
return gadjett.collections.almost_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return gadjett.collections.almost_EQ_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13169.length)].join('')));

}
});

gadjett.collections.almost_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return gadjett.collections.almost_EQ_.call(null,x,y,1.0E-5);
});

gadjett.collections.almost_EQ_.cljs$core$IFn$_invoke$arity$3 = (function (x,y,epsilon){
return (cljs.core._EQ_.call(null,x,y)) || ((gadjett.collections.abs.call(null,(x - y)) <= (gadjett.collections.scale.call(null,x,y) * epsilon)));
});

gadjett.collections.almost_EQ_.cljs$lang$maxFixedArity = 3;

gadjett.collections._EQ_set = (function gadjett$collections$_EQ_set(a,b){
return cljs.core._EQ_.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,a),cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,b));
});
cljs.spec.def_impl.call(null,new cljs.core.Keyword("gadjett.collections","list-of-keys","gadjett.collections/list-of-keys",-954883513),new cljs.core.Symbol("cljs.core","seqable?","cljs.core/seqable?",-745394886,null),cljs.core.seqable_QMARK_);
cljs.spec.def_impl.call(null,new cljs.core.Symbol("gadjett.collections","=without-keys?","gadjett.collections/=without-keys?",416652629,null),cljs.core.list(new cljs.core.Symbol("cljs.spec","fspec","cljs.spec/fspec",982220571,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"b","b",1482224470),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.Keyword("gadjett.collections","list-of-keys","gadjett.collections/list-of-keys",-954883513)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"fn","fn",-1175266204),cljs.core.list(new cljs.core.Symbol("cljs.spec","and","cljs.spec/and",-7296553,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__13176#","p1__13176#",807602729,null)], null),cljs.core.list(new cljs.core.Symbol("gadjett.collections","=set","gadjett.collections/=set",357456586,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13176#","p1__13176#",807602729,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.Symbol("cljs.core","keys","cljs.core/keys",-927561820,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","concat","cljs.core/concat",-1133584918,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13176#","p1__13176#",807602729,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"b","b",1482224470),new cljs.core.Symbol("cljs.core","keys","cljs.core/keys",-927561820,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13176#","p1__13176#",807602729,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.Symbol("cljs.core","keys","cljs.core/keys",-927561820,null))))))),cljs.spec.fspec_impl.call(null,cljs.spec.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"b","b",1482224470),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.Keyword("gadjett.collections","list-of-keys","gadjett.collections/list-of-keys",-954883513)),cljs.spec.cat_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.Keyword(null,"b","b",1482224470),new cljs.core.Keyword(null,"keys","keys",1068423698)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map_QMARK_,cljs.core.map_QMARK_,new cljs.core.Keyword("gadjett.collections","list-of-keys","gadjett.collections/list-of-keys",-954883513)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword("gadjett.collections","list-of-keys","gadjett.collections/list-of-keys",-954883513)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"b","b",1482224470),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.Keyword("gadjett.collections","list-of-keys","gadjett.collections/list-of-keys",-954883513)),cljs.spec.spec_impl.call(null,new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),cljs.core.map_QMARK_,null,null),new cljs.core.Symbol("cljs.core","map?","cljs.core/map?",-1390345523,null),cljs.spec.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec","and","cljs.spec/and",-7296553,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__13176#","p1__13176#",807602729,null)], null),cljs.core.list(new cljs.core.Symbol("gadjett.collections","=set","gadjett.collections/=set",357456586,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13176#","p1__13176#",807602729,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.Symbol("cljs.core","keys","cljs.core/keys",-927561820,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","concat","cljs.core/concat",-1133584918,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13176#","p1__13176#",807602729,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"b","b",1482224470),new cljs.core.Symbol("cljs.core","keys","cljs.core/keys",-927561820,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13176#","p1__13176#",807602729,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.Symbol("cljs.core","keys","cljs.core/keys",-927561820,null)))))),cljs.spec.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("gadjett.collections","=set","gadjett.collections/=set",357456586,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.Symbol("cljs.core","keys","cljs.core/keys",-927561820,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","concat","cljs.core/concat",-1133584918,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"b","b",1482224470),new cljs.core.Symbol("cljs.core","keys","cljs.core/keys",-927561820,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.Symbol("cljs.core","keys","cljs.core/keys",-927561820,null)))))], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (p1__13176_SHARP_){
return gadjett.collections._EQ_set.call(null,cljs.core.keys.call(null,new cljs.core.Keyword(null,"a","a",-2123407586).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(p1__13176_SHARP_))),cljs.core.concat.call(null,cljs.core.keys.call(null,new cljs.core.Keyword(null,"b","b",1482224470).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(p1__13176_SHARP_))),cljs.core.keys.call(null,new cljs.core.Keyword(null,"keys","keys",1068423698).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(p1__13176_SHARP_)))));
})], null),null),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec","and","cljs.spec/and",-7296553,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__13176#","p1__13176#",807602729,null)], null),cljs.core.list(new cljs.core.Symbol("gadjett.collections","=set","gadjett.collections/=set",357456586,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13176#","p1__13176#",807602729,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.Symbol("cljs.core","keys","cljs.core/keys",-927561820,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","concat","cljs.core/concat",-1133584918,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13176#","p1__13176#",807602729,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"b","b",1482224470),new cljs.core.Symbol("cljs.core","keys","cljs.core/keys",-927561820,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13176#","p1__13176#",807602729,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.Symbol("cljs.core","keys","cljs.core/keys",-927561820,null)))))),null));
/**
 * Compare two maps exclusing some keys
 * 
 * ~~~klipse
 *   (=without-keys? {:a 1 :b 2 :c 3} {:a 1 :b 5} #{:b :c})
 * ~~~
 *   
 */
gadjett.collections._EQ_without_keys_QMARK_ = (function gadjett$collections$_EQ_without_keys_QMARK_(obj_a,obj_b,keys_list){
return cljs.core.apply.call(null,cljs.core._EQ_,cljs.core.map.call(null,(function (p1__13177_SHARP_){
return cljs.core.apply.call(null,cljs.core.dissoc,p1__13177_SHARP_,keys_list);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [obj_a,obj_b], null)));
});
/**
 * Converts a 2d vec to a hash-map.
 * 
 * ~~~klipse
 * (vec->map [[:a 1] [:b 2]])
 * ~~~
 * 
 */
gadjett.collections.vec__GT_map = (function gadjett$collections$vec__GT_map(vec){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,vec);
});
/**
 * Maps the values of a `2D` vector where each element of the vector is a key-value pair.
 * `f` is a `1-ary` function that receives the key.
 * 
 * ~~~klipse
 *   (map-2d-vec inc [[:a 1] [:b 2]])
 * ~~~
 */
gadjett.collections.map_2d_vec = (function gadjett$collections$map_2d_vec(f,m){
return cljs.core.map.call(null,(function (p__13182){
var vec__13183 = p__13182;
var k = cljs.core.nth.call(null,vec__13183,(0),null);
var id = cljs.core.nth.call(null,vec__13183,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,f.call(null,id)], null);
}),m);
});
/**
 * Maps the values of a `2D` vector where each element of the vector is a key-value pair.
 * `fk` is a `1-ary` function that receives the key.
 * `fv` is a `1-ary` function that receives the value.
 * 
 * ~~~klipse
 *  (map-2d-vec-kv name inc [[:a 1] [:b 2]])
 * ~~~
 */
gadjett.collections.map_2d_vec_kv = (function gadjett$collections$map_2d_vec_kv(fk,fv,m){
return cljs.core.map.call(null,(function (p__13190){
var vec__13191 = p__13190;
var k = cljs.core.nth.call(null,vec__13191,(0),null);
var id = cljs.core.nth.call(null,vec__13191,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk.call(null,k),fv.call(null,id)], null);
}),m);
});
/**
 * Returns a map with the same keys as `m` and with the values transformed by `f`. `f` is a `1-ary` function that receives the key.
 * 
 * ~~~klipse
 *   (map-object inc {:a 1 :b 2 :c 3})
 * ~~~
 *   
 */
gadjett.collections.map_object = (function gadjett$collections$map_object(f,m){
return gadjett.collections.vec__GT_map.call(null,gadjett.collections.map_2d_vec.call(null,f,m));
});
/**
 * Returns a map with the same keys as `m` and with the values transformed by `f`. `f` must be a `2-ary` function that receives the key and the value as arguments.
 * 
 * ~~~klipse
 *   (map-object-with-key list {:a 1 :b 2 :c 3})
 * ~~~
 *   
 */
gadjett.collections.map_object_with_key = (function gadjett$collections$map_object_with_key(f,m){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__13198){
var vec__13199 = p__13198;
var a = cljs.core.nth.call(null,vec__13199,(0),null);
var b = cljs.core.nth.call(null,vec__13199,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,f.call(null,a,b)], null);
}),m));
});
/**
 * Returns a map with the keys mapped by `fk` and the values mapped by `fv`.
 * 
 * ~~~klipse
 *  (map-object-kv name inc {:a 1 :b 2 :c 3})
 * ~~~
 */
gadjett.collections.map_object_kv = (function gadjett$collections$map_object_kv(fk,fv,m){
return gadjett.collections.vec__GT_map.call(null,gadjett.collections.map_2d_vec_kv.call(null,fk,fv,m));
});
/**
 * Turns a hash map inside out.
 *   See:  [here](http://stackoverflow.com/a/23653784/813665)
 * 
 * ~~~klipse
 *   (map-reverse-hierarchy {:monday {:banana 2 :apple 3} 
 *                        :tuesday {:banana 5 :orange 2}})
 * ~~~
 */
gadjett.collections.map_reverse_hierarchy = (function gadjett$collections$map_reverse_hierarchy(m){
var or__6932__auto__ = cljs.core.apply.call(null,cljs.core.merge_with,cljs.core.conj,(function (){var iter__7786__auto__ = (function gadjett$collections$map_reverse_hierarchy_$_iter__13310(s__13311){
return (new cljs.core.LazySeq(null,(function (){
var s__13311__$1 = s__13311;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__13311__$1);
if(temp__6753__auto__){
var xs__7309__auto__ = temp__6753__auto__;
var vec__13331 = cljs.core.first.call(null,xs__7309__auto__);
var k1 = cljs.core.nth.call(null,vec__13331,(0),null);
var v1 = cljs.core.nth.call(null,vec__13331,(1),null);
var iterys__7782__auto__ = ((function (s__13311__$1,vec__13331,k1,v1,xs__7309__auto__,temp__6753__auto__){
return (function gadjett$collections$map_reverse_hierarchy_$_iter__13310_$_iter__13312(s__13313){
return (new cljs.core.LazySeq(null,((function (s__13311__$1,vec__13331,k1,v1,xs__7309__auto__,temp__6753__auto__){
return (function (){
var s__13313__$1 = s__13313;
while(true){
var temp__6753__auto____$1 = cljs.core.seq.call(null,s__13313__$1);
if(temp__6753__auto____$1){
var s__13313__$2 = temp__6753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__13313__$2)){
var c__7784__auto__ = cljs.core.chunk_first.call(null,s__13313__$2);
var size__7785__auto__ = cljs.core.count.call(null,c__7784__auto__);
var b__13315 = cljs.core.chunk_buffer.call(null,size__7785__auto__);
if((function (){var i__13314 = (0);
while(true){
if((i__13314 < size__7785__auto__)){
var vec__13340 = cljs.core._nth.call(null,c__7784__auto__,i__13314);
var k2 = cljs.core.nth.call(null,vec__13340,(0),null);
var v2 = cljs.core.nth.call(null,vec__13340,(1),null);
cljs.core.chunk_append.call(null,b__13315,cljs.core.PersistentArrayMap.fromArray([k2,cljs.core.PersistentArrayMap.fromArray([k1,v2], true, false)], true, false));

var G__13346 = (i__13314 + (1));
i__13314 = G__13346;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13315),gadjett$collections$map_reverse_hierarchy_$_iter__13310_$_iter__13312.call(null,cljs.core.chunk_rest.call(null,s__13313__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13315),null);
}
} else {
var vec__13343 = cljs.core.first.call(null,s__13313__$2);
var k2 = cljs.core.nth.call(null,vec__13343,(0),null);
var v2 = cljs.core.nth.call(null,vec__13343,(1),null);
return cljs.core.cons.call(null,cljs.core.PersistentArrayMap.fromArray([k2,cljs.core.PersistentArrayMap.fromArray([k1,v2], true, false)], true, false),gadjett$collections$map_reverse_hierarchy_$_iter__13310_$_iter__13312.call(null,cljs.core.rest.call(null,s__13313__$2)));
}
} else {
return null;
}
break;
}
});})(s__13311__$1,vec__13331,k1,v1,xs__7309__auto__,temp__6753__auto__))
,null,null));
});})(s__13311__$1,vec__13331,k1,v1,xs__7309__auto__,temp__6753__auto__))
;
var fs__7783__auto__ = cljs.core.seq.call(null,iterys__7782__auto__.call(null,v1));
if(fs__7783__auto__){
return cljs.core.concat.call(null,fs__7783__auto__,gadjett$collections$map_reverse_hierarchy_$_iter__13310.call(null,cljs.core.rest.call(null,s__13311__$1)));
} else {
var G__13347 = cljs.core.rest.call(null,s__13311__$1);
s__13311__$1 = G__13347;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7786__auto__.call(null,m);
})());
if(cljs.core.truth_(or__6932__auto__)){
return or__6932__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
/**
 * Calculates the mean (a.k.a average) of a sequence of numbers.
 * 
 * ~~~klipse
 *   (mean [1 2 10 -1 12.3])
 * ~~~
 *   
 */
gadjett.collections.mean = (function gadjett$collections$mean(x){
if(cljs.core.empty_QMARK_.call(null,x)){
return (0);
} else {
return (cljs.core.apply.call(null,cljs.core._PLUS_,x) / cljs.core.count.call(null,x));
}
});
cljs.spec.def_impl.call(null,new cljs.core.Symbol("gadjett.collections","mean","gadjett.collections/mean",1068732288,null),cljs.core.list(new cljs.core.Symbol("cljs.spec","fspec","cljs.spec/fspec",982220571,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.list(new cljs.core.Symbol("cljs.spec","coll-of","cljs.spec/coll-of",-1298051753,null),new cljs.core.Keyword("gadjett.collections","number","gadjett.collections/number",1630126874))),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null),new cljs.core.Keyword(null,"fn","fn",-1175266204),cljs.core.list(new cljs.core.Symbol("cljs.spec","and","cljs.spec/and",-7296553,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__13348#","p1__13348#",-2016403601,null)], null),cljs.core.list(new cljs.core.Symbol("gadjett.collections","almost=","gadjett.collections/almost=",67180027,null),cljs.core.list(new cljs.core.Symbol("cljs.core","*","cljs.core/*",-857794892,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13348#","p1__13348#",-2016403601,null),new cljs.core.Keyword(null,"ret","ret",-468222814)),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13348#","p1__13348#",-2016403601,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","apply","cljs.core/apply",1757277831,null),new cljs.core.Symbol("cljs.core","+","cljs.core/+",-342754435,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13348#","p1__13348#",-2016403601,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"x","x",2099068185))))))),cljs.spec.fspec_impl.call(null,cljs.spec.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.list(new cljs.core.Symbol("cljs.spec","coll-of","cljs.spec/coll-of",-1298051753,null),new cljs.core.Keyword("gadjett.collections","number","gadjett.collections/number",1630126874))),cljs.spec.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.every_impl.call(null,new cljs.core.Keyword("gadjett.collections","number","gadjett.collections/number",1630126874),new cljs.core.Keyword("gadjett.collections","number","gadjett.collections/number",1630126874),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("cljs.spec","conform-all","cljs.spec/conform-all",-1945029907),true,new cljs.core.Keyword("cljs.spec","kind-form","cljs.spec/kind-form",997489303),null], null),null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec","coll-of","cljs.spec/coll-of",-1298051753,null),new cljs.core.Keyword("gadjett.collections","number","gadjett.collections/number",1630126874))], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.list(new cljs.core.Symbol("cljs.spec","coll-of","cljs.spec/coll-of",-1298051753,null),new cljs.core.Keyword("gadjett.collections","number","gadjett.collections/number",1630126874))),cljs.spec.spec_impl.call(null,new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null),cljs.core.number_QMARK_,null,null),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null),cljs.spec.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec","and","cljs.spec/and",-7296553,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__13348#","p1__13348#",-2016403601,null)], null),cljs.core.list(new cljs.core.Symbol("gadjett.collections","almost=","gadjett.collections/almost=",67180027,null),cljs.core.list(new cljs.core.Symbol("cljs.core","*","cljs.core/*",-857794892,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13348#","p1__13348#",-2016403601,null),new cljs.core.Keyword(null,"ret","ret",-468222814)),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13348#","p1__13348#",-2016403601,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","apply","cljs.core/apply",1757277831,null),new cljs.core.Symbol("cljs.core","+","cljs.core/+",-342754435,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13348#","p1__13348#",-2016403601,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"x","x",2099068185)))))),cljs.spec.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("gadjett.collections","almost=","gadjett.collections/almost=",67180027,null),cljs.core.list(new cljs.core.Symbol("cljs.core","*","cljs.core/*",-857794892,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword(null,"ret","ret",-468222814)),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","apply","cljs.core/apply",1757277831,null),new cljs.core.Symbol("cljs.core","+","cljs.core/+",-342754435,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"x","x",2099068185)))))], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (p1__13348_SHARP_){
return gadjett.collections.almost_EQ_.call(null,(new cljs.core.Keyword(null,"ret","ret",-468222814).cljs$core$IFn$_invoke$arity$1(p1__13348_SHARP_) * cljs.core.count.call(null,new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(p1__13348_SHARP_)))),cljs.core.apply.call(null,cljs.core._PLUS_,new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(p1__13348_SHARP_))));
})], null),null),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec","and","cljs.spec/and",-7296553,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__13348#","p1__13348#",-2016403601,null)], null),cljs.core.list(new cljs.core.Symbol("gadjett.collections","almost=","gadjett.collections/almost=",67180027,null),cljs.core.list(new cljs.core.Symbol("cljs.core","*","cljs.core/*",-857794892,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13348#","p1__13348#",-2016403601,null),new cljs.core.Keyword(null,"ret","ret",-468222814)),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13348#","p1__13348#",-2016403601,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))),cljs.core.list(new cljs.core.Symbol("cljs.core","apply","cljs.core/apply",1757277831,null),new cljs.core.Symbol("cljs.core","+","cljs.core/+",-342754435,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13348#","p1__13348#",-2016403601,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"x","x",2099068185)))))),null));
/**
 * Converts a sequence into a map where the keys are the indexes of the elements in the sequence.
 * 
 *   ~~~klipse
 *   (sequence->map [10 20 30])
 *   ~~~
 *   
 */
gadjett.collections.sequence__GT_map = (function gadjett$collections$sequence__GT_map(s){
return cljs.core.zipmap.call(null,cljs.core.range.call(null,cljs.core.count.call(null,s)),s);
});
gadjett.collections.range_with_end = (function gadjett$collections$range_with_end(var_args){
var args13349 = [];
var len__8115__auto___13352 = arguments.length;
var i__8116__auto___13353 = (0);
while(true){
if((i__8116__auto___13353 < len__8115__auto___13352)){
args13349.push((arguments[i__8116__auto___13353]));

var G__13354 = (i__8116__auto___13353 + (1));
i__8116__auto___13353 = G__13354;
continue;
} else {
}
break;
}

var G__13351 = args13349.length;
switch (G__13351) {
case 1:
return gadjett.collections.range_with_end.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return gadjett.collections.range_with_end.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return gadjett.collections.range_with_end.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13349.length)].join('')));

}
});

gadjett.collections.range_with_end.cljs$core$IFn$_invoke$arity$1 = (function (end){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [end,cljs.core.range.call(null,end)], null);
});

gadjett.collections.range_with_end.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [end,cljs.core.range.call(null,start,end)], null);
});

gadjett.collections.range_with_end.cljs$core$IFn$_invoke$arity$3 = (function (start,end,steps){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [end,cljs.core.range.call(null,start,end,steps)], null);
});

gadjett.collections.range_with_end.cljs$lang$maxFixedArity = 3;

/**
 * Like `range` but including the `end`.
 * 
 * ~~~klipse
 *   (range-till-end 10)
 * ~~~
 * 
 * ~~~klipse
 * (range-till-end 10 18)
 * ~~~
 * 
 * ~~~klipse
 * (range-till-end 10 100 5)
 * ~~~
 * 
 *   
 */
gadjett.collections.range_till_end = (function gadjett$collections$range_till_end(var_args){
var args__8122__auto__ = [];
var len__8115__auto___13359 = arguments.length;
var i__8116__auto___13360 = (0);
while(true){
if((i__8116__auto___13360 < len__8115__auto___13359)){
args__8122__auto__.push((arguments[i__8116__auto___13360]));

var G__13361 = (i__8116__auto___13360 + (1));
i__8116__auto___13360 = G__13361;
continue;
} else {
}
break;
}

var argseq__8123__auto__ = ((((0) < args__8122__auto__.length))?(new cljs.core.IndexedSeq(args__8122__auto__.slice((0)),(0),null)):null);
return gadjett.collections.range_till_end.cljs$core$IFn$_invoke$arity$variadic(argseq__8123__auto__);
});

gadjett.collections.range_till_end.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var map__13357 = cljs.spec.conform.call(null,new cljs.core.Keyword("gadjett.collections","range-till-end","gadjett.collections/range-till-end",1169083328),args);
var map__13357__$1 = ((((!((map__13357 == null)))?((((map__13357.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13357.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13357):map__13357);
var start = cljs.core.get.call(null,map__13357__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var end = cljs.core.get.call(null,map__13357__$1,new cljs.core.Keyword(null,"end","end",-268185958));
var steps = cljs.core.get.call(null,map__13357__$1,new cljs.core.Keyword(null,"steps","steps",-128433302));
return cljs.core.range.call(null,start,(steps + end),steps);
});

gadjett.collections.range_till_end.cljs$lang$maxFixedArity = (0);

gadjett.collections.range_till_end.cljs$lang$applyTo = (function (seq13356){
return gadjett.collections.range_till_end.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq13356));
});

cljs.spec.def_impl.call(null,new cljs.core.Keyword("gadjett.collections","non-neg-int","gadjett.collections/non-neg-int",1761250766),cljs.core.list(new cljs.core.Symbol("cljs.spec","and","cljs.spec/and",-7296553,null),new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__13362#","p1__13362#",-1207153311,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core",">=","cljs.core/>=",350096541,null),new cljs.core.Symbol(null,"p1__13362#","p1__13362#",-1207153311,null),(0)))),cljs.spec.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","int?","cljs.core/int?",50730120,null),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core",">=","cljs.core/>=",350096541,null),new cljs.core.Symbol(null,"%","%",-950237169,null),(0)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.int_QMARK_,(function (p1__13362_SHARP_){
return (p1__13362_SHARP_ >= (0));
})], null),null));
cljs.spec.def_impl.call(null,new cljs.core.Keyword("gadjett.collections","range-till-end","gadjett.collections/range-till-end",1169083328),cljs.core.list(new cljs.core.Symbol("cljs.spec","and","cljs.spec/and",-7296553,null),cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"start","start",-355208981),cljs.core.list(new cljs.core.Symbol("cljs.spec","?","cljs.spec/?",-1542560017,null),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null)),new cljs.core.Keyword(null,"end","end",-268185958),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null),new cljs.core.Keyword(null,"steps","steps",-128433302),cljs.core.list(new cljs.core.Symbol("cljs.spec","?","cljs.spec/?",-1542560017,null),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null)))),cljs.spec.and_spec_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"start","start",-355208981),cljs.core.list(new cljs.core.Symbol("cljs.spec","?","cljs.spec/?",-1542560017,null),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null)),new cljs.core.Keyword(null,"end","end",-268185958),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null),new cljs.core.Keyword(null,"steps","steps",-128433302),cljs.core.list(new cljs.core.Symbol("cljs.spec","?","cljs.spec/?",-1542560017,null),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null)))], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.cat_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"start","start",-355208981),new cljs.core.Keyword(null,"end","end",-268185958),new cljs.core.Keyword(null,"steps","steps",-128433302)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.maybe_impl.call(null,cljs.core.number_QMARK_,new cljs.core.Symbol(null,"number?","number?",-1747282210,null)),cljs.core.number_QMARK_,cljs.spec.maybe_impl.call(null,cljs.core.number_QMARK_,new cljs.core.Symbol(null,"number?","number?",-1747282210,null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec","?","cljs.spec/?",-1542560017,null),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null)),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null),cljs.core.list(new cljs.core.Symbol("cljs.spec","?","cljs.spec/?",-1542560017,null),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null))], null))], null),null));
cljs.spec.conform.call(null,cljs.spec.or_spec_impl.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"empty","empty",767870958),new cljs.core.Keyword(null,"one","one",935007904),new cljs.core.Keyword(null,"two","two",627606869),new cljs.core.Keyword(null,"three","three",-1651831795)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null)),cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"end","end",-268185958),new cljs.core.Keyword("gadjett.collections","not-nan-number","gadjett.collections/not-nan-number",491458217)),cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"start","start",-355208981),new cljs.core.Keyword("gadjett.collections","not-nan-number","gadjett.collections/not-nan-number",491458217),new cljs.core.Keyword(null,"end","end",-268185958),new cljs.core.Keyword("gadjett.collections","not-nan-number","gadjett.collections/not-nan-number",491458217)),cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"start","start",-355208981),new cljs.core.Keyword("gadjett.collections","not-nan-number","gadjett.collections/not-nan-number",491458217),new cljs.core.Keyword(null,"end","end",-268185958),new cljs.core.Keyword("gadjett.collections","not-nan-number","gadjett.collections/not-nan-number",491458217),new cljs.core.Keyword(null,"step","step",1288888124),new cljs.core.Keyword("gadjett.collections","not-nan-number","gadjett.collections/not-nan-number",491458217))], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.cat_impl.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.PersistentVector.EMPTY,cljs.core.PersistentVector.EMPTY),cljs.spec.cat_impl.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"end","end",-268185958)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("gadjett.collections","not-nan-number","gadjett.collections/not-nan-number",491458217)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("gadjett.collections","not-nan-number","gadjett.collections/not-nan-number",491458217)], null)),cljs.spec.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"start","start",-355208981),new cljs.core.Keyword(null,"end","end",-268185958)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("gadjett.collections","not-nan-number","gadjett.collections/not-nan-number",491458217),new cljs.core.Keyword("gadjett.collections","not-nan-number","gadjett.collections/not-nan-number",491458217)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("gadjett.collections","not-nan-number","gadjett.collections/not-nan-number",491458217),new cljs.core.Keyword("gadjett.collections","not-nan-number","gadjett.collections/not-nan-number",491458217)], null)),cljs.spec.cat_impl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"start","start",-355208981),new cljs.core.Keyword(null,"end","end",-268185958),new cljs.core.Keyword(null,"step","step",1288888124)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("gadjett.collections","not-nan-number","gadjett.collections/not-nan-number",491458217),new cljs.core.Keyword("gadjett.collections","not-nan-number","gadjett.collections/not-nan-number",491458217),new cljs.core.Keyword("gadjett.collections","not-nan-number","gadjett.collections/not-nan-number",491458217)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("gadjett.collections","not-nan-number","gadjett.collections/not-nan-number",491458217),new cljs.core.Keyword("gadjett.collections","not-nan-number","gadjett.collections/not-nan-number",491458217),new cljs.core.Keyword("gadjett.collections","not-nan-number","gadjett.collections/not-nan-number",491458217)], null))], null),null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(2)], null));
cljs.spec.def_impl.call(null,new cljs.core.Symbol("gadjett.collections","range-till-end","gadjett.collections/range-till-end",-1485352441,null),cljs.core.list(new cljs.core.Symbol("cljs.spec","fspec","cljs.spec/fspec",982220571,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("gadjett.collections","range-till-end","gadjett.collections/range-till-end",1169083328),new cljs.core.Keyword(null,"ret","ret",-468222814),cljs.core.list(new cljs.core.Symbol("cljs.spec","coll-of","cljs.spec/coll-of",-1298051753,null),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null)),new cljs.core.Keyword(null,"fn","fn",-1175266204),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null),new cljs.core.Symbol(null,"ret","ret",1172308713,null)], null)], null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"steps","steps",1512098225,null)], null),new cljs.core.Keyword(null,"or","or",235744169),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"start","start",1285322546,null),(0),new cljs.core.Symbol(null,"steps","steps",1512098225,null),(1)], null)], null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),cljs.core.list(new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),new cljs.core.Symbol(null,"ret","ret",1172308713,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),cljs.core.list(new cljs.core.Symbol("cljs.core","-","cljs.core/-",187040141,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"start","start",1285322546,null)),new cljs.core.Symbol("cljs.core","int","cljs.core/int",20935062,null),cljs.core.list(new cljs.core.Symbol("cljs.core","/","cljs.core//",-696756880,null),new cljs.core.Symbol(null,"steps","steps",1512098225,null)),new cljs.core.Symbol("cljs.core","inc","cljs.core/inc",-879172610,null)))))),cljs.spec.fspec_impl.call(null,cljs.spec.spec_impl.call(null,new cljs.core.Keyword("gadjett.collections","range-till-end","gadjett.collections/range-till-end",1169083328),new cljs.core.Keyword("gadjett.collections","range-till-end","gadjett.collections/range-till-end",1169083328),null,null),new cljs.core.Keyword("gadjett.collections","range-till-end","gadjett.collections/range-till-end",1169083328),cljs.spec.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec","coll-of","cljs.spec/coll-of",-1298051753,null),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null)),cljs.spec.every_impl.call(null,new cljs.core.Symbol(null,"number?","number?",-1747282210,null),cljs.core.number_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("cljs.spec","conform-all","cljs.spec/conform-all",-1945029907),true,new cljs.core.Keyword("cljs.spec","kind-form","cljs.spec/kind-form",997489303),null], null),null),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec","coll-of","cljs.spec/coll-of",-1298051753,null),new cljs.core.Symbol("cljs.core","number?","cljs.core/number?",-811857295,null)),cljs.spec.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null),new cljs.core.Symbol(null,"ret","ret",1172308713,null)], null)], null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"steps","steps",1512098225,null)], null),new cljs.core.Keyword(null,"or","or",235744169),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"start","start",1285322546,null),(0),new cljs.core.Symbol(null,"steps","steps",1512098225,null),(1)], null)], null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),cljs.core.list(new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),new cljs.core.Symbol(null,"ret","ret",1172308713,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),cljs.core.list(new cljs.core.Symbol("cljs.core","-","cljs.core/-",187040141,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"start","start",1285322546,null)),new cljs.core.Symbol("cljs.core","int","cljs.core/int",20935062,null),cljs.core.list(new cljs.core.Symbol("cljs.core","/","cljs.core//",-696756880,null),new cljs.core.Symbol(null,"steps","steps",1512098225,null)),new cljs.core.Symbol("cljs.core","inc","cljs.core/inc",-879172610,null))))),(function (p__13363){
var map__13364 = p__13363;
var map__13364__$1 = ((((!((map__13364 == null)))?((((map__13364.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13364.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13364):map__13364);
var args = cljs.core.get.call(null,map__13364__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var ret = cljs.core.get.call(null,map__13364__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var map__13366 = args;
var map__13366__$1 = ((((!((map__13366 == null)))?((((map__13366.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13366.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13366):map__13366);
var start = cljs.core.get.call(null,map__13366__$1,new cljs.core.Keyword(null,"start","start",-355208981),(0));
var end = cljs.core.get.call(null,map__13366__$1,new cljs.core.Keyword(null,"end","end",-268185958));
var steps = cljs.core.get.call(null,map__13366__$1,new cljs.core.Keyword(null,"steps","steps",-128433302),(1));
return cljs.core._EQ_.call(null,cljs.core.count.call(null,ret),((((end - start) | (0)) / steps) + (1)));
}),null,null),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null),new cljs.core.Symbol(null,"ret","ret",1172308713,null)], null)], null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"steps","steps",1512098225,null)], null),new cljs.core.Keyword(null,"or","or",235744169),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"start","start",1285322546,null),(0),new cljs.core.Symbol(null,"steps","steps",1512098225,null),(1)], null)], null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),cljs.core.list(new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),new cljs.core.Symbol(null,"ret","ret",1172308713,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),cljs.core.list(new cljs.core.Symbol("cljs.core","-","cljs.core/-",187040141,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"start","start",1285322546,null)),new cljs.core.Symbol("cljs.core","int","cljs.core/int",20935062,null),cljs.core.list(new cljs.core.Symbol("cljs.core","/","cljs.core//",-696756880,null),new cljs.core.Symbol(null,"steps","steps",1512098225,null)),new cljs.core.Symbol("cljs.core","inc","cljs.core/inc",-879172610,null))))),null));
/**
 * Appends an element to a list popping out the first element.
 * 
 * ~~~klipse
 *   (-> (repeat 3 nil)
 *    (append-cyclic 1)
 *    (append-cyclic 2)
 *    (append-cyclic 3)
 *    (append-cyclic 4))
 * ~~~
 *   
 */
gadjett.collections.append_cyclic = (function gadjett$collections$append_cyclic(lst,a){
if(cljs.core.seq.call(null,lst)){
return cljs.core.concat.call(null,cljs.core.rest.call(null,lst),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a], null));
} else {
return lst;
}
});
cljs.spec.def_impl.call(null,new cljs.core.Symbol("gadjett.collections","append-cyclic","gadjett.collections/append-cyclic",-1217919913,null),cljs.core.list(new cljs.core.Symbol("cljs.spec","fspec","cljs.spec/fspec",982220571,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"coll","coll",1647737163),cljs.core.list(new cljs.core.Symbol("cljs.spec","coll-of","cljs.spec/coll-of",-1298051753,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),new cljs.core.Keyword(null,"elem","elem",618631056),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),new cljs.core.Keyword(null,"ret","ret",-468222814),cljs.core.list(new cljs.core.Symbol("cljs.spec","coll-of","cljs.spec/coll-of",-1298051753,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),new cljs.core.Keyword(null,"fn","fn",-1175266204),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__13368#","p1__13368#",629729289,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),cljs.core.list(new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13368#","p1__13368#",629729289,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"coll","coll",1647737163))),cljs.core.list(new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13368#","p1__13368#",629729289,null),new cljs.core.Keyword(null,"ret","ret",-468222814)))))),cljs.spec.fspec_impl.call(null,cljs.spec.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"coll","coll",1647737163),cljs.core.list(new cljs.core.Symbol("cljs.spec","coll-of","cljs.spec/coll-of",-1298051753,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),new cljs.core.Keyword(null,"elem","elem",618631056),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"elem","elem",618631056)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.every_impl.call(null,new cljs.core.Symbol(null,"any?","any?",-318999933,null),cljs.core.any_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("cljs.spec","conform-all","cljs.spec/conform-all",-1945029907),true,new cljs.core.Keyword("cljs.spec","kind-form","cljs.spec/kind-form",997489303),null], null),null),cljs.core.any_QMARK_], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("cljs.spec","coll-of","cljs.spec/coll-of",-1298051753,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"coll","coll",1647737163),cljs.core.list(new cljs.core.Symbol("cljs.spec","coll-of","cljs.spec/coll-of",-1298051753,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),new cljs.core.Keyword(null,"elem","elem",618631056),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec","coll-of","cljs.spec/coll-of",-1298051753,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.every_impl.call(null,new cljs.core.Symbol(null,"any?","any?",-318999933,null),cljs.core.any_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("cljs.spec","conform-all","cljs.spec/conform-all",-1945029907),true,new cljs.core.Keyword("cljs.spec","kind-form","cljs.spec/kind-form",997489303),null], null),null),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec","coll-of","cljs.spec/coll-of",-1298051753,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),cljs.core.list(new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"coll","coll",1647737163))),cljs.core.list(new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword(null,"ret","ret",-468222814))))),(function (p1__13368_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"coll","coll",1647737163).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(p1__13368_SHARP_))),cljs.core.count.call(null,new cljs.core.Keyword(null,"ret","ret",-468222814).cljs$core$IFn$_invoke$arity$1(p1__13368_SHARP_)));
}),null,null),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),cljs.core.list(new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"coll","coll",1647737163))),cljs.core.list(new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword(null,"ret","ret",-468222814))))),null));
/**
 * Assoc a key-value pair to a map popping out an element of the map.
 *   If the key already exists, no element is popped out.
 *   If `n` is supplied, no elmement is popped out if the map has less than `n` entries.
 * 
 * ~~~klipse
 *   (-> {:a 1 :b 2 :c 3}
 *    (assoc-cyclic :d 4)
 *    (assoc-cyclic :e 5)
 *    (assoc-cyclic :f 6)
 *    (assoc-cyclic :g 7))
 * ~~~
 *   
 */
gadjett.collections.assoc_cyclic = (function gadjett$collections$assoc_cyclic(var_args){
var args13369 = [];
var len__8115__auto___13372 = arguments.length;
var i__8116__auto___13373 = (0);
while(true){
if((i__8116__auto___13373 < len__8115__auto___13372)){
args13369.push((arguments[i__8116__auto___13373]));

var G__13374 = (i__8116__auto___13373 + (1));
i__8116__auto___13373 = G__13374;
continue;
} else {
}
break;
}

var G__13371 = args13369.length;
switch (G__13371) {
case 3:
return gadjett.collections.assoc_cyclic.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return gadjett.collections.assoc_cyclic.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13369.length)].join('')));

}
});

gadjett.collections.assoc_cyclic.cljs$core$IFn$_invoke$arity$3 = (function (coll,k,v){
if(cljs.core.contains_QMARK_.call(null,coll,k)){
return cljs.core.assoc.call(null,coll,k,v);
} else {
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,gadjett.collections.append_cyclic.call(null,coll,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null)));
}
});

gadjett.collections.assoc_cyclic.cljs$core$IFn$_invoke$arity$4 = (function (coll,k,v,n){
if((cljs.core.count.call(null,coll) < n)){
return cljs.core.assoc.call(null,coll,k,v);
} else {
return gadjett.collections.assoc_cyclic.call(null,coll,k,v);
}
});

gadjett.collections.assoc_cyclic.cljs$lang$maxFixedArity = 4;

/**
 * Returns a couple of the `max` and the `min` of a sequence.
 * 
 * ~~~klipse
 *   (max-and-min (range 5))
 * ~~~
 *   
 */
gadjett.collections.max_and_min = (function gadjett$collections$max_and_min(x){
if(cljs.core.empty_QMARK_.call(null,x)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
} else {
return cljs.core.juxt.call(null,(function (p1__13376_SHARP_){
return cljs.core.apply.call(null,cljs.core.max,p1__13376_SHARP_);
}),(function (p1__13377_SHARP_){
return cljs.core.apply.call(null,cljs.core.min,p1__13377_SHARP_);
})).call(null,x);
}
});
/**
 * Removes entries with `nil` values.
 * 
 * ~~~klipse
 *   (compactize-map {:a 1 :b nil :c 3})
 * ~~~
 *   
 */
gadjett.collections.compactize_map = (function gadjett$collections$compactize_map(m){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.remove.call(null,cljs.core.comp.call(null,cljs.core.nil_QMARK_,cljs.core.second),m));
});
/**
 * Run a function on the values of a map and keep only the (key, value) pairs for which the function returns true
 *   
 * ~~~klipse
 *   (filter-map even? {:a 1 :b 2 :c 3})
 * ~~~
 *   
 */
gadjett.collections.filter_map = (function gadjett$collections$filter_map(f,m){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,cljs.core.comp.call(null,f,cljs.core.val),m));
});
/**
 * Returns the nearest number to `x` of a sorted set
 * 
 * ~~~klipse
 *   (nearest-of-ss (apply sorted-set (range 5)) 1.2)
 * ~~~
 *   
 */
gadjett.collections.nearest_of_ss = (function gadjett$collections$nearest_of_ss(ss,x){
var greater = cljs.core.first.call(null,cljs.core.subseq.call(null,ss,cljs.core._GT__EQ_,x));
var smaller = cljs.core.first.call(null,cljs.core.rsubseq.call(null,ss,cljs.core._LT__EQ_,x));
return cljs.core.apply.call(null,cljs.core.min_key,((function (greater,smaller){
return (function (p1__13378_SHARP_){
return gadjett.collections.abs.call(null,(p1__13378_SHARP_ - x));
});})(greater,smaller))
,cljs.core.remove.call(null,cljs.core.nil_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [greater,smaller], null)));
});
/**
 * Maps each element of `b` to its nearest element in `a`.
 *   If `a` is empty, returns `b`.
 * 
 * ~~~klipse
 *   (nearest-of-seq (range 5) [1.2 3.4 4])
 * ~~~
 *   
 */
gadjett.collections.nearest_of_seq = (function gadjett$collections$nearest_of_seq(a,b){
if(cljs.core.empty_QMARK_.call(null,a)){
return b;
} else {
return cljs.core.map.call(null,cljs.core.partial.call(null,gadjett.collections.nearest_of_ss,cljs.core.apply.call(null,cljs.core.sorted_set,a)),b);
}
});
/**
 * Returns a map whose keys are the elements of `lst` and values are mapped by `f`.
 * 
 * ~~~klipse
 *   (map-to-object inc (range 5))
 * ~~~
 *   
 */
gadjett.collections.map_to_object = (function gadjett$collections$map_to_object(f,lst){
return cljs.core.zipmap.call(null,lst,cljs.core.map.call(null,f,lst));
});
/**
 * 
 *   Takes a seq, and returns a map where the keys are the result of applying f to the elements in the seq.
 *   The result of f should be unique for each element in the seq, otherwise you will loose some data.
 *   If it is not unique, consider using [group-by](https://clojuredocs.org/clojure.core/group-by).
 * 
 * ~~~klipse
 *   (mapify inc (range 5) )
 * ~~~
 *   
 */
gadjett.collections.mapify = (function gadjett$collections$mapify(f,s){
return cljs.core.zipmap.call(null,cljs.core.map.call(null,f,s),s);
});
/**
 * Maps a sequence to a sequence of maps with index and value
 * 
 * ~~~klipse
 *    (map-with-index [10 20 30] :idx :val)
 * ~~~
 *   
 */
gadjett.collections.map_with_index = (function gadjett$collections$map_with_index(s,idx_key,val_key){
return cljs.core.map_indexed.call(null,(function (i,v){
return cljs.core.PersistentArrayMap.fromArray([idx_key,i,val_key,v], true, false);
}),s);
});
/**
 * Dissociates an entry from a nested associative structure returning a new nested structure. `keys` is a sequence of keys. Any empty maps that result will not be present in the new structure. See [assoc-in](https://clojuredocs.org/clojure.core/assoc-in)
 * 
 * ~~~klipse
 *   (dissoc-in {:a 1 :b 2} [:b])
 * ~~~
 * 
 * ~~~klipse
 *   (dissoc-in {:a {:b 2 :B 3} :c 3} [:a :b])
 * ~~~
 * 
 * ~~~klipse
 *   (dissoc-in {:a {:b 2} :c 3} [:a :b])
 * ~~~
 *   
 */
gadjett.collections.dissoc_in = (function gadjett$collections$dissoc_in(m,p__13379){
var vec__13383 = p__13379;
var seq__13384 = cljs.core.seq.call(null,vec__13383);
var first__13385 = cljs.core.first.call(null,seq__13384);
var seq__13384__$1 = cljs.core.next.call(null,seq__13384);
var k = first__13385;
var ks = seq__13384__$1;
var keys = vec__13383;
if(ks){
var temp__6751__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(temp__6751__auto__)){
var nextmap = temp__6751__auto__;
var newmap = gadjett$collections$dissoc_in.call(null,nextmap,ks);
if(cljs.core.seq.call(null,newmap)){
return cljs.core.assoc.call(null,m,k,newmap);
} else {
return cljs.core.dissoc.call(null,m,k);
}
} else {
return m;
}
} else {
return cljs.core.dissoc.call(null,m,k);
}
});
/**
 * Receives a collection of lengths and returns a list of start and end positions. Options:
 *   * `max-val`: (default `infinity`) - max value for `end`
 *   * `first-val`: (default 0) - first value of `start`
 * 
 * ~~~klipse
 *   (positions '(10 10 20) :first-val 100 :max-val 137)
 * ~~~
 * 
 *   
 */
gadjett.collections.positions = (function gadjett$collections$positions(var_args){
var args__8122__auto__ = [];
var len__8115__auto___13393 = arguments.length;
var i__8116__auto___13394 = (0);
while(true){
if((i__8116__auto___13394 < len__8115__auto___13393)){
args__8122__auto__.push((arguments[i__8116__auto___13394]));

var G__13395 = (i__8116__auto___13394 + (1));
i__8116__auto___13394 = G__13395;
continue;
} else {
}
break;
}

var argseq__8123__auto__ = ((((1) < args__8122__auto__.length))?(new cljs.core.IndexedSeq(args__8122__auto__.slice((1)),(0),null)):null);
return gadjett.collections.positions.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8123__auto__);
});

gadjett.collections.positions.cljs$core$IFn$_invoke$arity$variadic = (function (coll_of_lengths,p__13390){
var map__13391 = p__13390;
var map__13391__$1 = ((((!((map__13391 == null)))?((((map__13391.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13391.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13391):map__13391);
var max_val = cljs.core.get.call(null,map__13391__$1,new cljs.core.Keyword(null,"max-val","max-val",-1492247884),gadjett.collections.infinity);
var first_val = cljs.core.get.call(null,map__13391__$1,new cljs.core.Keyword(null,"first-val","first-val",1849924874),(0));
var end_pos = cljs.core.rest.call(null,cljs.core.reductions.call(null,cljs.core._PLUS_,first_val,coll_of_lengths));
var start_pos = cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [first_val], null),end_pos);
return cljs.core.map.call(null,((function (end_pos,start_pos,map__13391,map__13391__$1,max_val,first_val){
return (function (p1__13386_SHARP_,p2__13387_SHARP_){
var x__7858__auto__ = (function (){var x__7272__auto__ = max_val;
var y__7273__auto__ = p1__13386_SHARP_;
return ((x__7272__auto__ < y__7273__auto__) ? x__7272__auto__ : y__7273__auto__);
})();
return cljs.core._conj.call(null,(function (){var x__7858__auto____$1 = (function (){var x__7272__auto__ = max_val;
var y__7273__auto__ = p2__13387_SHARP_;
return ((x__7272__auto__ < y__7273__auto__) ? x__7272__auto__ : y__7273__auto__);
})();
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__7858__auto____$1);
})(),x__7858__auto__);
});})(end_pos,start_pos,map__13391,map__13391__$1,max_val,first_val))
,start_pos,end_pos);
});

gadjett.collections.positions.cljs$lang$maxFixedArity = (1);

gadjett.collections.positions.cljs$lang$applyTo = (function (seq13388){
var G__13389 = cljs.core.first.call(null,seq13388);
var seq13388__$1 = cljs.core.next.call(null,seq13388);
return gadjett.collections.positions.cljs$core$IFn$_invoke$arity$variadic(G__13389,seq13388__$1);
});

/**
 * Splits a collection to items where the separator is a repetition of at least n elements that satisfy `pred`.
 * 
 *   Inspired by: [this question](http://stackoverflow.com/a/23555616/813665).
 * 
 * ~~~klipse
 *   (split-by-predicate (shuffle (range 30)) even? 2)
 * ~~~
 *   
 */
gadjett.collections.split_by_predicate = (function gadjett$collections$split_by_predicate(coll,pred,n){
var part = cljs.core.partition_by.call(null,pred,coll);
var ppart = cljs.core.partition_by.call(null,((function (part){
return (function (x){
return ((cljs.core.count.call(null,x) >= n)) && (cljs.core.every_QMARK_.call(null,pred,x));
});})(part))
,part);
return cljs.core.map.call(null,((function (part,ppart){
return (function (p1__13396_SHARP_){
return cljs.core.apply.call(null,cljs.core.concat,p1__13396_SHARP_);
});})(part,ppart))
,ppart);
});
/**
 * 
 *   Optimized version of `split-by-predicate` where we assume that the data is from a signal that we can sample.
 * 
 *   Instead of checking each element, we check 1 over `n` elements.
 * 
 *  We return the positions where the data splits.
 * 
 * ~~~klipse
 *   (let [data (map Math/sin (range 0 6.28 0.001))]
 *  (split-by-predicate-positions data #(<= -0.01 % 0.01) 2 10))
 * ~~~
 * 
 *   The following assertion holds:
 * 
 * ~~~clojure
 *   (= (split-by-predicate coll pred n)
 *   (map #(apply subsequence data %) (split-by-predicate-positions coll pred n 1)))
 * ~~~
 * 
 *   Here is an example:
 * 
 * ~~~klipse
 *   (let [data (map Math/sin (range 0 6.28 0.01))]
 *  (= (split-by-predicate data #(<= -0.01 % 0.01) 2)
 *     (map #(apply subsequence data %) (split-by-predicate-positions data #(<= -0.01 % 0.01) 2 1))))
 * ~~~
 *   
 */
gadjett.collections.split_by_predicate_positions = (function gadjett$collections$split_by_predicate_positions(coll,pred,n,d){
var lengths = cljs.core.map.call(null,(function (p1__13397_SHARP_){
return (d * p1__13397_SHARP_);
}),cljs.core.map.call(null,cljs.core.count,gadjett.collections.split_by_predicate.call(null,cljs.core.take_nth.call(null,d,coll),pred,(n / d))));
var pos = gadjett.collections.positions.call(null,lengths,new cljs.core.Keyword(null,"max-val","max-val",-1492247884),cljs.core.count.call(null,coll));
return pos;
});
/**
 * Checks if `m1` is a submap of `m2`.
 *   Map `m1` is a submap of `m2` if all key/value pairs in `m1` exist in `m2`.
 * 
 * ~~~klipse
 *   (submap? {:a 1} {:a 1 :b 2})
 * ~~~
 * 
 * ~~~klipse
 *   (submap? {:a 1} {:a 1 :b 2 :c nil})
 * ~~~
 *   
 */
gadjett.collections.submap_QMARK_ = (function gadjett$collections$submap_QMARK_(m1,m2){
return cljs.core._EQ_.call(null,m1,cljs.core.select_keys.call(null,m2,cljs.core.keys.call(null,m1)));
});
/**
 * 
 *   Returns a lazy subsequence of `coll`, starting at `start, ending at `end` (not included).
 * 
 * ~~~klipse
 *   (subsequence (range) 10 20)
 * ~~~
 *   
 */
gadjett.collections.subsequence = (function gadjett$collections$subsequence(coll,start,end){
return cljs.core.take.call(null,(end - start),cljs.core.drop.call(null,start,coll));
});
/**
 * Returns the index of an element in a sequence or `-1` if not present.
 * 
 *   ~~~klipse
 *   (index-of (range 100) 18)
 *   ~~~
 *   
 */
gadjett.collections.index_of = (function gadjett$collections$index_of(s,element){
var or__6932__auto__ = cljs.core.ffirst.call(null,cljs.core.filter.call(null,(function (p1__13398_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.second.call(null,p1__13398_SHARP_),element);
}),cljs.core.map_indexed.call(null,(function (p1__13399_SHARP_,p2__13400_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__13399_SHARP_,p2__13400_SHARP_],null));
}),s)));
if(cljs.core.truth_(or__6932__auto__)){
return or__6932__auto__;
} else {
return (-1);
}
});
gadjett.collections.flatten_keys_STAR_ = (function gadjett$collections$flatten_keys_STAR_(a,ks,m){
if(cljs.core.map_QMARK_.call(null,m)){
if(cljs.core.seq.call(null,m)){
return cljs.core.reduce.call(null,cljs.core.into,cljs.core.map.call(null,(function (p__13405){
var vec__13406 = p__13405;
var k = cljs.core.nth.call(null,vec__13406,(0),null);
var v = cljs.core.nth.call(null,vec__13406,(1),null);
return gadjett$collections$flatten_keys_STAR_.call(null,a,cljs.core.conj.call(null,ks,k),v);
}),cljs.core.seq.call(null,m)));
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
} else {
return cljs.core.assoc.call(null,a,ks,m);
}
});
/**
 * 
 * Flatten the keys of a nested map.
 * Thanks to [Jay Fields](http://blog.jayfields.com/2010/09/clojure-flatten-keys.html)
 * 
 * ~~~klipse
 * (flatten-keys {:a {:b 1} :c {:d 2 :e 4 :f {:g 8}}})
 * ~~~
 */
gadjett.collections.flatten_keys = (function gadjett$collections$flatten_keys(m){
return gadjett.collections.flatten_keys_STAR_.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentVector.EMPTY,m);
});
/**
 * 
 *   Unflattend the keys of a map that has been `flatten-keys`ed.
 * 
 * ~~~klipse
 * (unflatten-keys {[:a :b] 1, [:c :d] 2, [:c :e] 4, [:c :f :g] 8})
 * ~~~
 */
gadjett.collections.unflatten_keys = (function gadjett$collections$unflatten_keys(m){
return cljs.core.reduce_kv.call(null,(function (a,b,c){
return cljs.core.assoc_in.call(null,a,b,c);
}),cljs.core.PersistentArrayMap.EMPTY,m);
});
/**
 * Creates a map with n leaves which are nested values of m.
 *   The following assertion holds:
 * 
 * ~~~clojure
 *    (>= n (count (flatten-keys (take-from-map n m)))))))
 * ~~~
 * 
 * ~~~klipse
 *   (take-from-map 3 {:a {:b 1}, :c {:e 4, :d 2, :f {:g 8}}})
 * ~~~
 *   
 */
gadjett.collections.take_from_map = (function gadjett$collections$take_from_map(n,m){
return gadjett.collections.unflatten_keys.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.take.call(null,n,gadjett.collections.flatten_keys.call(null,m))));
});
gadjett.collections.deep_merge_STAR_ = (function gadjett$collections$deep_merge_STAR_(var_args){
var args__8122__auto__ = [];
var len__8115__auto___13410 = arguments.length;
var i__8116__auto___13411 = (0);
while(true){
if((i__8116__auto___13411 < len__8115__auto___13410)){
args__8122__auto__.push((arguments[i__8116__auto___13411]));

var G__13412 = (i__8116__auto___13411 + (1));
i__8116__auto___13411 = G__13412;
continue;
} else {
}
break;
}

var argseq__8123__auto__ = ((((0) < args__8122__auto__.length))?(new cljs.core.IndexedSeq(args__8122__auto__.slice((0)),(0),null)):null);
return gadjett.collections.deep_merge_STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__8123__auto__);
});

gadjett.collections.deep_merge_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
var f = (function (old,new$){
if((cljs.core.map_QMARK_.call(null,old)) && (cljs.core.map_QMARK_.call(null,new$))){
return cljs.core.merge_with.call(null,gadjett.collections.deep_merge_STAR_,old,new$);
} else {
return new$;
}
});
if(cljs.core.every_QMARK_.call(null,cljs.core.map_QMARK_,maps)){
return cljs.core.apply.call(null,cljs.core.merge_with,f,maps);
} else {
return cljs.core.last.call(null,maps);
}
});

gadjett.collections.deep_merge_STAR_.cljs$lang$maxFixedArity = (0);

gadjett.collections.deep_merge_STAR_.cljs$lang$applyTo = (function (seq13409){
return gadjett.collections.deep_merge_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq13409));
});

/**
 *  Deep merges maps.
 * 
 * ~~~klipse
 * (deep-merge {} {:a {:b 1}, :c {:e 4, :d 2, :f {:g 8}}} {:a {:b 1}, :c {:e 4, :d 2000, :f {:g 9000}}})
 * ~~~
 */
gadjett.collections.deep_merge = (function gadjett$collections$deep_merge(var_args){
var args__8122__auto__ = [];
var len__8115__auto___13414 = arguments.length;
var i__8116__auto___13415 = (0);
while(true){
if((i__8116__auto___13415 < len__8115__auto___13414)){
args__8122__auto__.push((arguments[i__8116__auto___13415]));

var G__13416 = (i__8116__auto___13415 + (1));
i__8116__auto___13415 = G__13416;
continue;
} else {
}
break;
}

var argseq__8123__auto__ = ((((0) < args__8122__auto__.length))?(new cljs.core.IndexedSeq(args__8122__auto__.slice((0)),(0),null)):null);
return gadjett.collections.deep_merge.cljs$core$IFn$_invoke$arity$variadic(argseq__8123__auto__);
});

gadjett.collections.deep_merge.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
var maps__$1 = cljs.core.filter.call(null,cljs.core.identity,maps);
if(cljs.core.every_QMARK_.call(null,cljs.core.map_QMARK_,maps__$1)){
} else {
throw (new Error("Assert failed: (every? map? maps)"));
}

return cljs.core.apply.call(null,cljs.core.merge_with,gadjett.collections.deep_merge_STAR_,maps__$1);
});

gadjett.collections.deep_merge.cljs$lang$maxFixedArity = (0);

gadjett.collections.deep_merge.cljs$lang$applyTo = (function (seq13413){
return gadjett.collections.deep_merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq13413));
});

gadjett.collections.deep_merge_with_STAR_ = (function gadjett$collections$deep_merge_with_STAR_(var_args){
var args__8122__auto__ = [];
var len__8115__auto___13419 = arguments.length;
var i__8116__auto___13420 = (0);
while(true){
if((i__8116__auto___13420 < len__8115__auto___13419)){
args__8122__auto__.push((arguments[i__8116__auto___13420]));

var G__13421 = (i__8116__auto___13420 + (1));
i__8116__auto___13420 = G__13421;
continue;
} else {
}
break;
}

var argseq__8123__auto__ = ((((1) < args__8122__auto__.length))?(new cljs.core.IndexedSeq(args__8122__auto__.slice((1)),(0),null)):null);
return gadjett.collections.deep_merge_with_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8123__auto__);
});

gadjett.collections.deep_merge_with_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (g,maps){
var f = (function (old,new$){
if((cljs.core.map_QMARK_.call(null,old)) && (cljs.core.map_QMARK_.call(null,new$))){
return cljs.core.merge_with.call(null,cljs.core.partial.call(null,gadjett.collections.deep_merge_with_STAR_,g),old,new$);
} else {
return g.call(null,old,new$);
}
});
if(cljs.core.every_QMARK_.call(null,cljs.core.map_QMARK_,maps)){
return cljs.core.apply.call(null,cljs.core.merge_with,f,maps);
} else {
return cljs.core.apply.call(null,g,maps);
}
});

gadjett.collections.deep_merge_with_STAR_.cljs$lang$maxFixedArity = (1);

gadjett.collections.deep_merge_with_STAR_.cljs$lang$applyTo = (function (seq13417){
var G__13418 = cljs.core.first.call(null,seq13417);
var seq13417__$1 = cljs.core.next.call(null,seq13417);
return gadjett.collections.deep_merge_with_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__13418,seq13417__$1);
});

/**
 * Like merge-with but deep.
 * ~~~klipse
 * (deep-merge-with concat
 *               {:x {:b 1
 *                    :a 1}}
 *               {:x {:a [3 4]}})
 * ~~~
 */
gadjett.collections.deep_merge_with = (function gadjett$collections$deep_merge_with(var_args){
var args__8122__auto__ = [];
var len__8115__auto___13424 = arguments.length;
var i__8116__auto___13425 = (0);
while(true){
if((i__8116__auto___13425 < len__8115__auto___13424)){
args__8122__auto__.push((arguments[i__8116__auto___13425]));

var G__13426 = (i__8116__auto___13425 + (1));
i__8116__auto___13425 = G__13426;
continue;
} else {
}
break;
}

var argseq__8123__auto__ = ((((1) < args__8122__auto__.length))?(new cljs.core.IndexedSeq(args__8122__auto__.slice((1)),(0),null)):null);
return gadjett.collections.deep_merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8123__auto__);
});

gadjett.collections.deep_merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (g,maps){
var maps__$1 = cljs.core.filter.call(null,cljs.core.identity,maps);
if(cljs.core.every_QMARK_.call(null,cljs.core.map_QMARK_,maps__$1)){
} else {
throw (new Error("Assert failed: (every? map? maps)"));
}

return cljs.core.apply.call(null,cljs.core.merge_with,cljs.core.partial.call(null,gadjett.collections.deep_merge_with_STAR_,g),maps__$1);
});

gadjett.collections.deep_merge_with.cljs$lang$maxFixedArity = (1);

gadjett.collections.deep_merge_with.cljs$lang$applyTo = (function (seq13422){
var G__13423 = cljs.core.first.call(null,seq13422);
var seq13422__$1 = cljs.core.next.call(null,seq13422);
return gadjett.collections.deep_merge_with.cljs$core$IFn$_invoke$arity$variadic(G__13423,seq13422__$1);
});

/**
 * Returns all branches and leaves off a nested map object.
 * 
 * ~~~klipse
 * (branches-and-leaves {:a {:b 1 :c {:d 2}} :e 3})
 * ~~~
 *   
 */
gadjett.collections.branches_and_leaves = (function gadjett$collections$branches_and_leaves(m){
var $ = cljs.core.tree_seq.call(null,cljs.core.coll_QMARK_,(function (p1__13427_SHARP_){
if(cljs.core.map_QMARK_.call(null,p1__13427_SHARP_)){
return cljs.core.vals.call(null,p1__13427_SHARP_);
} else {
return p1__13427_SHARP_;
}
}),m);
var $__$1 = cljs.core.group_by.call(null,cljs.core.coll_QMARK_,$);
var $__$2 = cljs.core.assoc.call(null,$__$1,true,(function (){var or__6932__auto__ = cljs.core.get.call(null,$__$1,true);
if(cljs.core.truth_(or__6932__auto__)){
return or__6932__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})());
var $__$3 = cljs.core.assoc.call(null,$__$2,false,(function (){var or__6932__auto__ = cljs.core.get.call(null,$__$2,false);
if(cljs.core.truth_(or__6932__auto__)){
return or__6932__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})());
return clojure.set.rename_keys.call(null,$__$3,new cljs.core.PersistentArrayMap(null, 2, [true,new cljs.core.Keyword(null,"branches","branches",-1240337268),false,new cljs.core.Keyword(null,"leaves","leaves",-2143630574)], null));
});
/**
 * Filters branches of a (nested) map `m` according to a predicate `m`.
 * 
 * ~~~klipse
 * (filter-branches {:x {:id 19 :b 1 :c {:id 2}} :e 3} :id)
 * ~~~
 *   
 */
gadjett.collections.filter_branches = (function gadjett$collections$filter_branches(m,p){
return cljs.core.filter.call(null,p,new cljs.core.Keyword(null,"branches","branches",-1240337268).cljs$core$IFn$_invoke$arity$1(gadjett.collections.branches_and_leaves.call(null,m)));
});
/**
 * Checks if index `idx` is in range of vector `v`. More efficient than `(get v idx)`
 * 
 * ~~~klipse
 *  (map #(out-of-bound? [1 2 3] %) [-1 0 1 2 3 4])
 * ~~~
 *   
 */
gadjett.collections.out_of_bound_QMARK_ = (function gadjett$collections$out_of_bound_QMARK_(v,idx){
return ((cljs.core.count.call(null,v) <= idx)) || (((0) > idx));
});
/**
 * Splits a collection between two items according to predicate `pred` - which means split the sequence on breaking point.
 * 
 *   See: [here](http://stackoverflow.com/questions/23207490/partition-a-seq-by-a-windowing-predicate-in-clojure)
 * 
 *   For instance, split each time the series stop being ascending:
 * 
 * ~~~klipse
 * (partition-between > [1 2 4 9 8 7 6 5 1 2 4 5 11])
 * ~~~
 */
gadjett.collections.partition_between = (function gadjett$collections$partition_between(pred,coll){
var switch$ = cljs.core.reductions.call(null,cljs.core.not_EQ_,true,cljs.core.map.call(null,pred,coll,cljs.core.rest.call(null,coll)));
return cljs.core.map.call(null,cljs.core.partial.call(null,cljs.core.map,cljs.core.first),cljs.core.partition_by.call(null,cljs.core.second,cljs.core.map.call(null,cljs.core.list,coll,switch$)));
});
/**
 * Ensure `s` is a collection: if `s` is a collection returns it; otherwise returns (s)
 * 
 * ~~~klipse
 * (collify 1)
 * ~~~
 * 
 * ~~~klipse
 * (collify [1 2 3])
 * ~~~
 *   
 */
gadjett.collections.collify = (function gadjett$collections$collify(s){
if(cljs.core.coll_QMARK_.call(null,s)){
return s;
} else {
var x__7858__auto__ = s;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__7858__auto__);
}
});
/**
 * A zipper for `edn`.
 * 
 * ~~~klipse
 *   (edn-zip {:a {:b 1}, :c {:e 4, :d 2, :f {:g 8}}})
 * ~~~
 *   
 */
gadjett.collections.edn_zip = (function gadjett$collections$edn_zip(root){
return clojure.zip.zipper.call(null,(function (p1__13428_SHARP_){
return (cljs.core.vector_QMARK_.call(null,p1__13428_SHARP_)) || (cljs.core.map_QMARK_.call(null,p1__13428_SHARP_)) || (cljs.core.seq_QMARK_.call(null,p1__13428_SHARP_));
}),(function (node){
if(cljs.core.vector_QMARK_.call(null,node)){
return cljs.core.vec.call(null,node);
} else {
if(cljs.core.map_QMARK_.call(null,node)){
return cljs.core.vec.call(null,node);
} else {
if(cljs.core.seq_QMARK_.call(null,node)){
return cljs.core.seq.call(null,node);
} else {
return null;
}
}
}
}),(function (node,children){
return cljs.core.with_meta.call(null,((cljs.core.vector_QMARK_.call(null,node))?cljs.core.vec.call(null,children):((cljs.core.map_QMARK_.call(null,node))?cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,children):((cljs.core.seq_QMARK_.call(null,node))?children:null))),cljs.core.meta.call(null,node));
}),root);
});
gadjett.collections.loc_my_replace = (function gadjett$collections$loc_my_replace(smap,loc){
var temp__6751__auto__ = cljs.core.find.call(null,smap,clojure.zip.node.call(null,loc));
if(cljs.core.truth_(temp__6751__auto__)){
var vec__13435 = temp__6751__auto__;
var _ = cljs.core.nth.call(null,vec__13435,(0),null);
var vec__13438 = cljs.core.nth.call(null,vec__13435,(1),null);
var seq__13439 = cljs.core.seq.call(null,vec__13438);
var first__13440 = cljs.core.first.call(null,seq__13439);
var seq__13439__$1 = cljs.core.next.call(null,seq__13439);
var replacement = first__13440;
var values = seq__13439__$1;
var $ = loc;
var $__$1 = clojure.zip.replace.call(null,$,replacement);
return cljs.core.reduce.call(null,((function ($,$__$1,vec__13435,_,vec__13438,seq__13439,first__13440,seq__13439__$1,replacement,values,temp__6751__auto__){
return (function (agg,v){
return clojure.zip.insert_right.call(null,agg,v);
});})($,$__$1,vec__13435,_,vec__13438,seq__13439,first__13440,seq__13439__$1,replacement,values,temp__6751__auto__))
,$__$1,cljs.core.reverse.call(null,values));
} else {
return loc;
}
});
/**
 * Recursively transforms `form` by replacing keys in `smap` with their
 *   values, spliced. The values in `smap` must be sequences. Like clojure.walk/prewalk-replace but supports list in values.
 * 
 * ~~~klipse
 * (my-replace '{go (go gadjett)} '(go (<! (timeout 100)) (go (<! timeout 0))))
 * ~~~
 *   
 */
gadjett.collections.my_replace = (function gadjett$collections$my_replace(smap,form){
if(cljs.core.every_QMARK_.call(null,cljs.core.seq_QMARK_,cljs.core.vals.call(null,smap))){
} else {
throw (new Error("Assert failed: (every? seq? (vals smap))"));
}

var loc = gadjett.collections.edn_zip.call(null,form);
while(true){
if(cljs.core.truth_(clojure.zip.end_QMARK_.call(null,loc))){
return clojure.zip.root.call(null,loc);
} else {
var G__13441 = clojure.zip.next.call(null,gadjett.collections.loc_my_replace.call(null,smap,loc));
loc = G__13441;
continue;
}
break;
}
});
gadjett.collections.comment_QMARK_ = (function gadjett$collections$comment_QMARK_(s){
return cljs.core.re_matches.call(null,/\s*;.*/,s);
});
/**
 * Removes comment lines from the end.
 * 
 * ~~~klipse
 *   ; we use (char 10) for end-of-line due to technical issues with string manipulation with `codox`
 *   (let [lines (clojure.string/join (char 10) ["aa", "  ", "bb" "; this comment should not appear"])]
 *   (remove-ending-comments lines))
 * ~~~
 *   
 */
gadjett.collections.remove_ending_comments = (function gadjett$collections$remove_ending_comments(s){
return clojure.string.join.call(null,"\n",cljs.core.reverse.call(null,cljs.core.drop_while.call(null,gadjett.collections.comment_QMARK_,cljs.core.reverse.call(null,clojure.string.split_lines.call(null,s)))));
});
/**
 * Removes blank lines from the begining and from the end (not from the middle)
 * 
 * ~~~klipse
 *   ; we use (char 10) for end-of-line due to technical issues with string manipulation with `codox`
 *   (let [lines (clojure.string/join (char 10) ["  ", "aa", "  ", "bb", " 	  "])]
 *   (fix-blank-lines lines))
 * ~~~
 *   
 */
gadjett.collections.fix_blank_lines = (function gadjett$collections$fix_blank_lines(s){
return clojure.string.join.call(null,"\n",cljs.core.reverse.call(null,cljs.core.drop_while.call(null,clojure.string.blank_QMARK_,cljs.core.reverse.call(null,cljs.core.drop_while.call(null,clojure.string.blank_QMARK_,clojure.string.split_lines.call(null,s))))));
});
/**
 * Removes blank lines.
 * ~~~klipse
 *   ; we use (char 10) for end-of-line due to technical issues with string manipulation with `codox`
 *   (let [lines (clojure.string/join (char 10) ["  ", "aa", "  ", "bb", " 	  "])]
 *   (remove-blank-lines lines))
 * ~~~
 *   
 */
gadjett.collections.remove_blank_lines = (function gadjett$collections$remove_blank_lines(s){
return clojure.string.join.call(null,"\n",cljs.core.remove.call(null,clojure.string.blank_QMARK_,clojure.string.split_lines.call(null,s)));
});
/**
 * 
 * (clojurescript only)
 * 
 * Compacts an expression by taking only the first `max-elements-in-coll` from collections and first `max-chars-in-str` from strings. Functions are displayed as "lambda()".
 * 
 * It works recursively. It is useful for logging and reporting.
 * 
 * Default settings:
 * 
 * - `max-elements-in-coll` 10
 * - `max-chars-in-str` 20
 * 
 * ~~~klipse
 * (compact {:infinite-list (range)
 *        :long-str "a very very very very long string - too long to be true"
 *                                                    :long-map (zipmap (range 100) (range 100))
 *                                                      :function #(+ 1 2)})
 * ~~~
 *                
 */
gadjett.collections.compact = (function gadjett$collections$compact(var_args){
var args__8122__auto__ = [];
var len__8115__auto___13449 = arguments.length;
var i__8116__auto___13450 = (0);
while(true){
if((i__8116__auto___13450 < len__8115__auto___13449)){
args__8122__auto__.push((arguments[i__8116__auto___13450]));

var G__13451 = (i__8116__auto___13450 + (1));
i__8116__auto___13450 = G__13451;
continue;
} else {
}
break;
}

var argseq__8123__auto__ = ((((1) < args__8122__auto__.length))?(new cljs.core.IndexedSeq(args__8122__auto__.slice((1)),(0),null)):null);
return gadjett.collections.compact.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8123__auto__);
});

gadjett.collections.compact.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__13446){
var map__13447 = p__13446;
var map__13447__$1 = ((((!((map__13447 == null)))?((((map__13447.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13447.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13447):map__13447);
var args = map__13447__$1;
var max_elements_in_coll = cljs.core.get.call(null,map__13447__$1,new cljs.core.Keyword(null,"max-elements-in-coll","max-elements-in-coll",-2076494525),(10));
var max_chars_in_str = cljs.core.get.call(null,map__13447__$1,new cljs.core.Keyword(null,"max-chars-in-str","max-chars-in-str",-182482200),(20));
if(cljs.core._EQ_.call(null,x,true)){
return x;
} else {
if(cljs.core._EQ_.call(null,x,false)){
return x;
} else {
if((x == null)){
return x;
} else {
if((x instanceof cljs.core.Keyword)){
return x;
} else {
if(typeof x === 'number'){
return x;
} else {
if(typeof x === 'string'){
return cljs.core.subs.call(null,x,(0),max_chars_in_str);
} else {
if(cljs.core.map_QMARK_.call(null,x)){
return gadjett.collections.take_from_map.call(null,max_elements_in_coll,gadjett.collections.map_object.call(null,((function (map__13447,map__13447__$1,args,max_elements_in_coll,max_chars_in_str){
return (function (p1__13442_SHARP_){
return gadjett.collections.compact.call(null,p1__13442_SHARP_,args);
});})(map__13447,map__13447__$1,args,max_elements_in_coll,max_chars_in_str))
,x));
} else {
if(cljs.core.seqable_QMARK_.call(null,x)){
return cljs.core.take.call(null,max_elements_in_coll,cljs.core.map.call(null,((function (map__13447,map__13447__$1,args,max_elements_in_coll,max_chars_in_str){
return (function (p1__13443_SHARP_){
return gadjett.collections.compact.call(null,p1__13443_SHARP_,args);
});})(map__13447,map__13447__$1,args,max_elements_in_coll,max_chars_in_str))
,x));
} else {
if(cljs.core.array_QMARK_.call(null,x)){
return [cljs.core.str("***["),cljs.core.str(cljs.core.type.call(null,x)),cljs.core.str("]***")].join('');
} else {
if(cljs.core._EQ_.call(null,Function,cljs.core.type.call(null,x))){
return "lambda()";
} else {
if((x instanceof Object)){
return [cljs.core.str("***["),cljs.core.str(cljs.core.subs.call(null,[cljs.core.str(cljs.core.type.call(null,x))].join(''),(0),(15))),cljs.core.str("]***")].join('');
} else {
return [cljs.core.str("***["),cljs.core.str(cljs.core.type.call(null,x)),cljs.core.str("]***")].join('');

}
}
}
}
}
}
}
}
}
}
}
});

gadjett.collections.compact.cljs$lang$maxFixedArity = (1);

gadjett.collections.compact.cljs$lang$applyTo = (function (seq13444){
var G__13445 = cljs.core.first.call(null,seq13444);
var seq13444__$1 = cljs.core.next.call(null,seq13444);
return gadjett.collections.compact.cljs$core$IFn$_invoke$arity$variadic(G__13445,seq13444__$1);
});

cljs.spec.def_impl.call(null,new cljs.core.Symbol("gadjett.collections","filter-map","gadjett.collections/filter-map",949316786,null),cljs.core.list(new cljs.core.Symbol("cljs.spec","fspec","cljs.spec/fspec",982220571,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"fn","fn",-1175266204),new cljs.core.Keyword("gadjett.collections","predicate","gadjett.collections/predicate",850745368),new cljs.core.Keyword(null,"m","m",1632677161),new cljs.core.Keyword("gadjett.collections","map","gadjett.collections/map",-1917712911)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("gadjett.collections","map","gadjett.collections/map",-1917712911),new cljs.core.Keyword(null,"fn","fn",-1175266204),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__13452#","p1__13452#",-655022915,null)], null),cljs.core.list(new cljs.core.Symbol("gadjett.collections","submap?","gadjett.collections/submap?",389285456,null),cljs.core.list(new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol(null,"p1__13452#","p1__13452#",-655022915,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"p1__13452#","p1__13452#",-655022915,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"m","m",1632677161))))),cljs.spec.fspec_impl.call(null,cljs.spec.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"fn","fn",-1175266204),new cljs.core.Keyword("gadjett.collections","predicate","gadjett.collections/predicate",850745368),new cljs.core.Keyword(null,"m","m",1632677161),new cljs.core.Keyword("gadjett.collections","map","gadjett.collections/map",-1917712911)),cljs.spec.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fn","fn",-1175266204),new cljs.core.Keyword(null,"m","m",1632677161)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("gadjett.collections","predicate","gadjett.collections/predicate",850745368),new cljs.core.Keyword("gadjett.collections","map","gadjett.collections/map",-1917712911)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("gadjett.collections","predicate","gadjett.collections/predicate",850745368),new cljs.core.Keyword("gadjett.collections","map","gadjett.collections/map",-1917712911)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec","cat","cljs.spec/cat",850003863,null),new cljs.core.Keyword(null,"fn","fn",-1175266204),new cljs.core.Keyword("gadjett.collections","predicate","gadjett.collections/predicate",850745368),new cljs.core.Keyword(null,"m","m",1632677161),new cljs.core.Keyword("gadjett.collections","map","gadjett.collections/map",-1917712911)),cljs.spec.spec_impl.call(null,new cljs.core.Keyword("gadjett.collections","map","gadjett.collections/map",-1917712911),new cljs.core.Keyword("gadjett.collections","map","gadjett.collections/map",-1917712911),null,null),new cljs.core.Keyword("gadjett.collections","map","gadjett.collections/map",-1917712911),cljs.spec.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("gadjett.collections","submap?","gadjett.collections/submap?",389285456,null),cljs.core.list(new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol(null,"%","%",-950237169,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"m","m",1632677161)))),(function (p1__13452_SHARP_){
return gadjett.collections.submap_QMARK_.call(null,new cljs.core.Keyword(null,"ret","ret",-468222814).cljs$core$IFn$_invoke$arity$1(p1__13452_SHARP_),new cljs.core.Keyword(null,"m","m",1632677161).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(p1__13452_SHARP_)));
}),null,null),cljs.core.list(new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"%","%",-950237169,null)], null),cljs.core.list(new cljs.core.Symbol("gadjett.collections","submap?","gadjett.collections/submap?",389285456,null),cljs.core.list(new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol(null,"%","%",-950237169,null)),cljs.core.list(new cljs.core.Symbol("cljs.core","->","cljs.core/->",1488366311,null),new cljs.core.Symbol(null,"%","%",-950237169,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"m","m",1632677161)))),null));

//# sourceMappingURL=collections.js.map