// Compiled by ClojureScript 1.9.227 {}
goog.provide('gadjett.linear');
goog.require('cljs.core');
gadjett.linear.highest_below_y = (function gadjett$linear$highest_below_y(m,v){
return cljs.core.second.call(null,cljs.core.last.call(null,cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,cljs.core.second,cljs.core.filter.call(null,(function (p__7938){
var vec__7939 = p__7938;
var x = cljs.core.nth.call(null,vec__7939,(0),null);
var y = cljs.core.nth.call(null,vec__7939,(1),null);
return (y <= v);
}),m)))));
});
gadjett.linear.lowest_above_y = (function gadjett$linear$lowest_above_y(m,v){
return cljs.core.second.call(null,cljs.core.first.call(null,cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,cljs.core.second,cljs.core.filter.call(null,(function (p__7946){
var vec__7947 = p__7946;
var x = cljs.core.nth.call(null,vec__7947,(0),null);
var y = cljs.core.nth.call(null,vec__7947,(1),null);
return (y >= v);
}),m)))));
});
gadjett.linear.highest_below_x = (function gadjett$linear$highest_below_x(m,v){
return cljs.core.second.call(null,cljs.core.last.call(null,cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__7954){
var vec__7955 = p__7954;
var x = cljs.core.nth.call(null,vec__7955,(0),null);
var y = cljs.core.nth.call(null,vec__7955,(1),null);
return (x <= v);
}),m)))));
});
gadjett.linear.lowest_above_x = (function gadjett$linear$lowest_above_x(m,v){
return cljs.core.second.call(null,cljs.core.first.call(null,cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__7962){
var vec__7963 = p__7962;
var x = cljs.core.nth.call(null,vec__7963,(0),null);
var y = cljs.core.nth.call(null,vec__7963,(1),null);
return (x >= v);
}),m)))));
});
gadjett.linear.find_keys_with_values_in = (function gadjett$linear$find_keys_with_values_in(m,s){
return cljs.core.filter.call(null,cljs.core.comp.call(null,s,m),cljs.core.keys.call(null,m));
});
gadjett.linear.find_keys_with_value = (function gadjett$linear$find_keys_with_value(m,v){
return gadjett.linear.find_keys_with_values_in.call(null,m,cljs.core.PersistentHashSet.fromArray([v], true));
});
gadjett.linear.linear_y = (function gadjett$linear$linear_y(x,x1,y1,x2,y2){
return (y1 + (((y2 - y1) * (x - x1)) / (x2 - x1)));
});
gadjett.linear.log_x_linear_y = (function gadjett$linear$log_x_linear_y(x,x1,y1,x2,y2){
return (y1 + (((y2 - y1) * (Math.log(x) - Math.log(x1))) / (Math.log(x2) - Math.log(x1))));
});
gadjett.linear.linear_y_func = (function gadjett$linear$linear_y_func(p__7966){
var map__7970 = p__7966;
var map__7970__$1 = ((((!((map__7970 == null)))?((((map__7970.cljs$lang$protocol_mask$partition0$ & (64))) || (map__7970.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7970):map__7970);
var axes = map__7970__$1;
var x = cljs.core.get.call(null,map__7970__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.call(null,map__7970__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var G__7972 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__7972)){
return gadjett.linear.linear_y;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__7972)){
return gadjett.linear.log_x_linear_y;
} else {
return gadjett.linear.linear_y;

}
}
});
gadjett.linear.interpolate_linear_y = (function gadjett$linear$interpolate_linear_y(var_args){
var args__7484__auto__ = [];
var len__7477__auto___7985 = arguments.length;
var i__7478__auto___7986 = (0);
while(true){
if((i__7478__auto___7986 < len__7477__auto___7985)){
args__7484__auto__.push((arguments[i__7478__auto___7986]));

var G__7987 = (i__7478__auto___7986 + (1));
i__7478__auto___7986 = G__7987;
continue;
} else {
}
break;
}

var argseq__7485__auto__ = ((((2) < args__7484__auto__.length))?(new cljs.core.IndexedSeq(args__7484__auto__.slice((2)),(0),null)):null);
return gadjett.linear.interpolate_linear_y.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7485__auto__);
});

gadjett.linear.interpolate_linear_y.cljs$core$IFn$_invoke$arity$variadic = (function (m,x,p__7976){
var map__7977 = p__7976;
var map__7977__$1 = ((((!((map__7977 == null)))?((((map__7977.cljs$lang$protocol_mask$partition0$ & (64))) || (map__7977.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7977):map__7977);
var interpolate_QMARK_ = cljs.core.get.call(null,map__7977__$1,new cljs.core.Keyword(null,"interpolate?","interpolate?",-423156286),cljs.core.constantly.call(null,true));
var axes = cljs.core.get.call(null,map__7977__$1,new cljs.core.Keyword(null,"axes","axes",1970866440),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"linear","linear",872268697)], null));
var or__6402__auto__ = cljs.core.get.call(null,m,x);
if(cljs.core.truth_(or__6402__auto__)){
return or__6402__auto__;
} else {
var vec__7979 = cljs.core.last.call(null,cljs.core.sort.call(null,gadjett.linear.highest_below_x.call(null,m,x)));
var x_below = cljs.core.nth.call(null,vec__7979,(0),null);
var y_below = cljs.core.nth.call(null,vec__7979,(1),null);
var vec__7982 = cljs.core.first.call(null,cljs.core.sort.call(null,gadjett.linear.lowest_above_x.call(null,m,x)));
var x_above = cljs.core.nth.call(null,vec__7982,(0),null);
var y_above = cljs.core.nth.call(null,vec__7982,(1),null);
if(cljs.core.truth_((function (){var and__6390__auto__ = x_below;
if(cljs.core.truth_(and__6390__auto__)){
var and__6390__auto____$1 = x_above;
if(cljs.core.truth_(and__6390__auto____$1)){
return interpolate_QMARK_.call(null,x_below,x_above);
} else {
return and__6390__auto____$1;
}
} else {
return and__6390__auto__;
}
})())){
return gadjett.linear.linear_y_func.call(null,axes).call(null,x,x_below,y_below,x_above,y_above);
} else {
return null;
}
}
});

gadjett.linear.interpolate_linear_y.cljs$lang$maxFixedArity = (2);

gadjett.linear.interpolate_linear_y.cljs$lang$applyTo = (function (seq7973){
var G__7974 = cljs.core.first.call(null,seq7973);
var seq7973__$1 = cljs.core.next.call(null,seq7973);
var G__7975 = cljs.core.first.call(null,seq7973__$1);
var seq7973__$2 = cljs.core.next.call(null,seq7973__$1);
return gadjett.linear.interpolate_linear_y.cljs$core$IFn$_invoke$arity$variadic(G__7974,G__7975,seq7973__$2);
});

gadjett.linear.linear_x = (function gadjett$linear$linear_x(y,x1,y1,x2,y2){
return (x1 + (((x2 - x1) * (y - y1)) / (y2 - y1)));
});
gadjett.linear.linear_x_func = (function gadjett$linear$linear_x_func(p__7988){
var map__7992 = p__7988;
var map__7992__$1 = ((((!((map__7992 == null)))?((((map__7992.cljs$lang$protocol_mask$partition0$ & (64))) || (map__7992.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7992):map__7992);
var axes = map__7992__$1;
var x = cljs.core.get.call(null,map__7992__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.call(null,map__7992__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var G__7994 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__7994)){
return gadjett.linear.linear_x;
} else {
return gadjett.linear.linear_x;

}
});
gadjett.linear.below_and_above_y = (function gadjett$linear$below_and_above_y(y,p__7995,p__7996){
var vec__8003 = p__7995;
var x1 = cljs.core.nth.call(null,vec__8003,(0),null);
var y1 = cljs.core.nth.call(null,vec__8003,(1),null);
var vec__8006 = p__7996;
var x2 = cljs.core.nth.call(null,vec__8006,(0),null);
var y2 = cljs.core.nth.call(null,vec__8006,(1),null);
if((((y1 < y)) && ((y < y2))) || (((y1 > y)) && ((y > y2)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x1,y1], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x2,y2], null)], null);
} else {
return null;
}
});
gadjett.linear.find_below_and_above_y = (function gadjett$linear$find_below_and_above_y(m,y){
var $ = cljs.core.map.call(null,cljs.core.vec,m);
var $__$1 = cljs.core.sort_by.call(null,cljs.core.first,$);
var $__$2 = cljs.core.map.call(null,cljs.core.partial.call(null,gadjett.linear.below_and_above_y,y),$__$1,cljs.core.rest.call(null,$__$1));
return cljs.core.remove.call(null,cljs.core.nil_QMARK_,$__$2);
});
gadjett.linear.calc_interpolated_values = (function gadjett$linear$calc_interpolated_values(m,y,interpolate_QMARK_,axes){
var $ = (function (p__8019){
var vec__8020 = p__8019;
var vec__8023 = cljs.core.nth.call(null,vec__8020,(0),null);
var x_below = cljs.core.nth.call(null,vec__8023,(0),null);
var y_below = cljs.core.nth.call(null,vec__8023,(1),null);
var vec__8026 = cljs.core.nth.call(null,vec__8020,(1),null);
var x_above = cljs.core.nth.call(null,vec__8026,(0),null);
var y_above = cljs.core.nth.call(null,vec__8026,(1),null);
if(cljs.core.truth_((function (){var and__6390__auto__ = y_below;
if(cljs.core.truth_(and__6390__auto__)){
var and__6390__auto____$1 = y_above;
if(cljs.core.truth_(and__6390__auto____$1)){
return interpolate_QMARK_.call(null,y_below,y_above);
} else {
return and__6390__auto____$1;
}
} else {
return and__6390__auto__;
}
})())){
return gadjett.linear.linear_x_func.call(null,axes).call(null,y,x_below,y_below,x_above,y_above);
} else {
return null;
}
});
return cljs.core.keep.call(null,$,gadjett.linear.find_below_and_above_y.call(null,m,y));
});
gadjett.linear.min_coll = (function gadjett$linear$min_coll(coll){
if(cljs.core.empty_QMARK_.call(null,coll)){
return null;
} else {
return cljs.core.apply.call(null,cljs.core.min,coll);
}
});
/**
 * Returns the interpolated x for a given y acording to the select-func thats passed
 * 
 * - `:interpolate?` -  a predicate for deciding eather to calc th interpolation or not.
 * -   `:axes` -  a map that defines what are the axes scales
 * -   `:select-func` - what functionality to use if there are multiple interpolated values
 * 
 * ~~~klipse
 *   (interpolate-linear-x {10 30 20 50 70 60} 32)
 * ~~~
 *   
 */
gadjett.linear.interpolate_linear_x = (function gadjett$linear$interpolate_linear_x(var_args){
var args__7484__auto__ = [];
var len__7477__auto___8035 = arguments.length;
var i__7478__auto___8036 = (0);
while(true){
if((i__7478__auto___8036 < len__7477__auto___8035)){
args__7484__auto__.push((arguments[i__7478__auto___8036]));

var G__8037 = (i__7478__auto___8036 + (1));
i__7478__auto___8036 = G__8037;
continue;
} else {
}
break;
}

var argseq__7485__auto__ = ((((2) < args__7484__auto__.length))?(new cljs.core.IndexedSeq(args__7484__auto__.slice((2)),(0),null)):null);
return gadjett.linear.interpolate_linear_x.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7485__auto__);
});

gadjett.linear.interpolate_linear_x.cljs$core$IFn$_invoke$arity$variadic = (function (m,y,p__8032){
var map__8033 = p__8032;
var map__8033__$1 = ((((!((map__8033 == null)))?((((map__8033.cljs$lang$protocol_mask$partition0$ & (64))) || (map__8033.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8033):map__8033);
var interpolate_QMARK_ = cljs.core.get.call(null,map__8033__$1,new cljs.core.Keyword(null,"interpolate?","interpolate?",-423156286),cljs.core.constantly.call(null,true));
var axes = cljs.core.get.call(null,map__8033__$1,new cljs.core.Keyword(null,"axes","axes",1970866440),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"linear","linear",872268697)], null));
var select_func = cljs.core.get.call(null,map__8033__$1,new cljs.core.Keyword(null,"select-func","select-func",-1706031810),gadjett.linear.min_coll);
var values = gadjett.linear.find_keys_with_value.call(null,m,y);
var interpolated_values = gadjett.linear.calc_interpolated_values.call(null,m,y,interpolate_QMARK_,axes);
return select_func.call(null,cljs.core.concat.call(null,values,interpolated_values));
});

gadjett.linear.interpolate_linear_x.cljs$lang$maxFixedArity = (2);

gadjett.linear.interpolate_linear_x.cljs$lang$applyTo = (function (seq8029){
var G__8030 = cljs.core.first.call(null,seq8029);
var seq8029__$1 = cljs.core.next.call(null,seq8029);
var G__8031 = cljs.core.first.call(null,seq8029__$1);
var seq8029__$2 = cljs.core.next.call(null,seq8029__$1);
return gadjett.linear.interpolate_linear_x.cljs$core$IFn$_invoke$arity$variadic(G__8030,G__8031,seq8029__$2);
});

gadjett.linear.linear_equation = (function gadjett$linear$linear_equation(x1,y1,x2,y2){
var a = ((y1 - y2) / (x1 - x2));
var b = (y1 - (a * x1));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
});
gadjett.linear.log_x_linear_equation = (function gadjett$linear$log_x_linear_equation(x1,y1,x2,y2){
var a = ((y1 - y2) / (Math.log(x1) - Math.log(x2)));
var b = (y1 - (a * Math.log(x1)));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
});
gadjett.linear.linear_equation_func = (function gadjett$linear$linear_equation_func(p__8038){
var map__8042 = p__8038;
var map__8042__$1 = ((((!((map__8042 == null)))?((((map__8042.cljs$lang$protocol_mask$partition0$ & (64))) || (map__8042.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8042):map__8042);
var axes = map__8042__$1;
var x = cljs.core.get.call(null,map__8042__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.call(null,map__8042__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var G__8044 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__8044)){
return gadjett.linear.linear_equation;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__8044)){
return gadjett.linear.log_x_linear_equation;
} else {
return gadjett.linear.linear_equation;

}
}
});
gadjett.linear.intersection_point = (function gadjett$linear$intersection_point(a1,b1,a2,b2){
var x = ((b2 - b1) / (a1 - a2));
var y = ((a1 * x) + b1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
});
gadjett.linear.log_x_intersection_point = (function gadjett$linear$log_x_intersection_point(a1,b1,a2,b2){
var x = ((b2 - b1) / (a1 - a2));
var y = ((a1 * x) + b1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [Math.exp(x),y], null);
});
gadjett.linear.intersection_point_func = (function gadjett$linear$intersection_point_func(p__8045){
var map__8049 = p__8045;
var map__8049__$1 = ((((!((map__8049 == null)))?((((map__8049.cljs$lang$protocol_mask$partition0$ & (64))) || (map__8049.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8049):map__8049);
var axes = map__8049__$1;
var x = cljs.core.get.call(null,map__8049__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.call(null,map__8049__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var G__8051 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__8051)){
return gadjett.linear.intersection_point;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__8051)){
return gadjett.linear.log_x_intersection_point;
} else {
return gadjett.linear.intersection_point;

}
}
});
gadjett.linear.intersection_point_from_2_lines_points = (function gadjett$linear$intersection_point_from_2_lines_points(var_args){
var args__7484__auto__ = [];
var len__7477__auto___8075 = arguments.length;
var i__7478__auto___8076 = (0);
while(true){
if((i__7478__auto___8076 < len__7477__auto___8075)){
args__7484__auto__.push((arguments[i__7478__auto___8076]));

var G__8077 = (i__7478__auto___8076 + (1));
i__7478__auto___8076 = G__8077;
continue;
} else {
}
break;
}

var argseq__7485__auto__ = ((((2) < args__7484__auto__.length))?(new cljs.core.IndexedSeq(args__7484__auto__.slice((2)),(0),null)):null);
return gadjett.linear.intersection_point_from_2_lines_points.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7485__auto__);
});

gadjett.linear.intersection_point_from_2_lines_points.cljs$core$IFn$_invoke$arity$variadic = (function (p__8055,p__8056,p__8057){
var vec__8058 = p__8055;
var ax1 = cljs.core.nth.call(null,vec__8058,(0),null);
var ay1 = cljs.core.nth.call(null,vec__8058,(1),null);
var ax2 = cljs.core.nth.call(null,vec__8058,(2),null);
var ay2 = cljs.core.nth.call(null,vec__8058,(3),null);
var vec__8061 = p__8056;
var bx1 = cljs.core.nth.call(null,vec__8061,(0),null);
var by1 = cljs.core.nth.call(null,vec__8061,(1),null);
var bx2 = cljs.core.nth.call(null,vec__8061,(2),null);
var by2 = cljs.core.nth.call(null,vec__8061,(3),null);
var map__8064 = p__8057;
var map__8064__$1 = ((((!((map__8064 == null)))?((((map__8064.cljs$lang$protocol_mask$partition0$ & (64))) || (map__8064.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8064):map__8064);
var axes = cljs.core.get.call(null,map__8064__$1,new cljs.core.Keyword(null,"axes","axes",1970866440),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"linear","linear",872268697)], null));
var vec__8066 = gadjett.linear.linear_equation_func.call(null,axes).call(null,ax1,ay1,ax2,ay2);
var a1 = cljs.core.nth.call(null,vec__8066,(0),null);
var b1 = cljs.core.nth.call(null,vec__8066,(1),null);
var vec__8069 = gadjett.linear.linear_equation_func.call(null,axes).call(null,bx1,by1,bx2,by2);
var a2 = cljs.core.nth.call(null,vec__8069,(0),null);
var b2 = cljs.core.nth.call(null,vec__8069,(1),null);
var vec__8072 = gadjett.linear.intersection_point_func.call(null,axes).call(null,a1,b1,a2,b2);
var x = cljs.core.nth.call(null,vec__8072,(0),null);
var y = cljs.core.nth.call(null,vec__8072,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
});

gadjett.linear.intersection_point_from_2_lines_points.cljs$lang$maxFixedArity = (2);

gadjett.linear.intersection_point_from_2_lines_points.cljs$lang$applyTo = (function (seq8052){
var G__8053 = cljs.core.first.call(null,seq8052);
var seq8052__$1 = cljs.core.next.call(null,seq8052);
var G__8054 = cljs.core.first.call(null,seq8052__$1);
var seq8052__$2 = cljs.core.next.call(null,seq8052__$1);
return gadjett.linear.intersection_point_from_2_lines_points.cljs$core$IFn$_invoke$arity$variadic(G__8053,G__8054,seq8052__$2);
});


//# sourceMappingURL=linear.js.map