// Compiled by ClojureScript 1.9.227 {}
goog.provide('gadjett.linear');
goog.require('cljs.core');
gadjett.linear.highest_below_y = (function gadjett$linear$highest_below_y(m,v){
return cljs.core.second.call(null,cljs.core.last.call(null,cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,cljs.core.second,cljs.core.filter.call(null,(function (p__48188){
var vec__48189 = p__48188;
var x = cljs.core.nth.call(null,vec__48189,(0),null);
var y = cljs.core.nth.call(null,vec__48189,(1),null);
return (y <= v);
}),m)))));
});
gadjett.linear.lowest_above_y = (function gadjett$linear$lowest_above_y(m,v){
return cljs.core.second.call(null,cljs.core.first.call(null,cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,cljs.core.second,cljs.core.filter.call(null,(function (p__48196){
var vec__48197 = p__48196;
var x = cljs.core.nth.call(null,vec__48197,(0),null);
var y = cljs.core.nth.call(null,vec__48197,(1),null);
return (y >= v);
}),m)))));
});
gadjett.linear.highest_below_x = (function gadjett$linear$highest_below_x(m,v){
return cljs.core.second.call(null,cljs.core.last.call(null,cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__48204){
var vec__48205 = p__48204;
var x = cljs.core.nth.call(null,vec__48205,(0),null);
var y = cljs.core.nth.call(null,vec__48205,(1),null);
return (x <= v);
}),m)))));
});
gadjett.linear.lowest_above_x = (function gadjett$linear$lowest_above_x(m,v){
return cljs.core.second.call(null,cljs.core.first.call(null,cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__48212){
var vec__48213 = p__48212;
var x = cljs.core.nth.call(null,vec__48213,(0),null);
var y = cljs.core.nth.call(null,vec__48213,(1),null);
return (x >= v);
}),m)))));
});
gadjett.linear.find_keys_with_values_in = (function gadjett$linear$find_keys_with_values_in(m,s){
return cljs.core.filter.call(null,cljs.core.comp.call(null,s,m),cljs.core.keys.call(null,m));
});
gadjett.linear.find_keys_with_value = (function gadjett$linear$find_keys_with_value(m,v){
return gadjett.linear.find_keys_with_values_in.call(null,m,cljs.core.PersistentHashSet.fromArray([v], true));
});
gadjett.linear.linear_y = (function gadjett$linear$linear_y(x,x1,y1,x2,y2){
return (y1 + (((y2 - y1) * (x - x1)) / (x2 - x1)));
});
gadjett.linear.log_x_linear_y = (function gadjett$linear$log_x_linear_y(x,x1,y1,x2,y2){
return (y1 + (((y2 - y1) * (Math.log(x) - Math.log(x1))) / (Math.log(x2) - Math.log(x1))));
});
gadjett.linear.linear_y_func = (function gadjett$linear$linear_y_func(p__48216){
var map__48220 = p__48216;
var map__48220__$1 = ((((!((map__48220 == null)))?((((map__48220.cljs$lang$protocol_mask$partition0$ & (64))) || (map__48220.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48220):map__48220);
var axes = map__48220__$1;
var x = cljs.core.get.call(null,map__48220__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.call(null,map__48220__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var G__48222 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__48222)){
return gadjett.linear.linear_y;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__48222)){
return gadjett.linear.log_x_linear_y;
} else {
return gadjett.linear.linear_y;

}
}
});
gadjett.linear.interpolate_linear_y = (function gadjett$linear$interpolate_linear_y(var_args){
var args__25827__auto__ = [];
var len__25820__auto___48235 = arguments.length;
var i__25821__auto___48236 = (0);
while(true){
if((i__25821__auto___48236 < len__25820__auto___48235)){
args__25827__auto__.push((arguments[i__25821__auto___48236]));

var G__48237 = (i__25821__auto___48236 + (1));
i__25821__auto___48236 = G__48237;
continue;
} else {
}
break;
}

var argseq__25828__auto__ = ((((2) < args__25827__auto__.length))?(new cljs.core.IndexedSeq(args__25827__auto__.slice((2)),(0),null)):null);
return gadjett.linear.interpolate_linear_y.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__25828__auto__);
});

gadjett.linear.interpolate_linear_y.cljs$core$IFn$_invoke$arity$variadic = (function (m,x,p__48226){
var map__48227 = p__48226;
var map__48227__$1 = ((((!((map__48227 == null)))?((((map__48227.cljs$lang$protocol_mask$partition0$ & (64))) || (map__48227.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48227):map__48227);
var interpolate_QMARK_ = cljs.core.get.call(null,map__48227__$1,new cljs.core.Keyword(null,"interpolate?","interpolate?",-423156286),cljs.core.constantly.call(null,true));
var axes = cljs.core.get.call(null,map__48227__$1,new cljs.core.Keyword(null,"axes","axes",1970866440),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"linear","linear",872268697)], null));
var or__24745__auto__ = cljs.core.get.call(null,m,x);
if(cljs.core.truth_(or__24745__auto__)){
return or__24745__auto__;
} else {
var vec__48229 = cljs.core.last.call(null,cljs.core.sort.call(null,gadjett.linear.highest_below_x.call(null,m,x)));
var x_below = cljs.core.nth.call(null,vec__48229,(0),null);
var y_below = cljs.core.nth.call(null,vec__48229,(1),null);
var vec__48232 = cljs.core.first.call(null,cljs.core.sort.call(null,gadjett.linear.lowest_above_x.call(null,m,x)));
var x_above = cljs.core.nth.call(null,vec__48232,(0),null);
var y_above = cljs.core.nth.call(null,vec__48232,(1),null);
if(cljs.core.truth_((function (){var and__24733__auto__ = x_below;
if(cljs.core.truth_(and__24733__auto__)){
var and__24733__auto____$1 = x_above;
if(cljs.core.truth_(and__24733__auto____$1)){
return interpolate_QMARK_.call(null,x_below,x_above);
} else {
return and__24733__auto____$1;
}
} else {
return and__24733__auto__;
}
})())){
return gadjett.linear.linear_y_func.call(null,axes).call(null,x,x_below,y_below,x_above,y_above);
} else {
return null;
}
}
});

gadjett.linear.interpolate_linear_y.cljs$lang$maxFixedArity = (2);

gadjett.linear.interpolate_linear_y.cljs$lang$applyTo = (function (seq48223){
var G__48224 = cljs.core.first.call(null,seq48223);
var seq48223__$1 = cljs.core.next.call(null,seq48223);
var G__48225 = cljs.core.first.call(null,seq48223__$1);
var seq48223__$2 = cljs.core.next.call(null,seq48223__$1);
return gadjett.linear.interpolate_linear_y.cljs$core$IFn$_invoke$arity$variadic(G__48224,G__48225,seq48223__$2);
});

gadjett.linear.linear_x = (function gadjett$linear$linear_x(y,x1,y1,x2,y2){
return (x1 + (((x2 - x1) * (y - y1)) / (y2 - y1)));
});
gadjett.linear.linear_x_func = (function gadjett$linear$linear_x_func(p__48238){
var map__48242 = p__48238;
var map__48242__$1 = ((((!((map__48242 == null)))?((((map__48242.cljs$lang$protocol_mask$partition0$ & (64))) || (map__48242.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48242):map__48242);
var axes = map__48242__$1;
var x = cljs.core.get.call(null,map__48242__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.call(null,map__48242__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var G__48244 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__48244)){
return gadjett.linear.linear_x;
} else {
return gadjett.linear.linear_x;

}
});
gadjett.linear.below_and_above_y = (function gadjett$linear$below_and_above_y(y,p__48245,p__48246){
var vec__48253 = p__48245;
var x1 = cljs.core.nth.call(null,vec__48253,(0),null);
var y1 = cljs.core.nth.call(null,vec__48253,(1),null);
var vec__48256 = p__48246;
var x2 = cljs.core.nth.call(null,vec__48256,(0),null);
var y2 = cljs.core.nth.call(null,vec__48256,(1),null);
if((((y1 < y)) && ((y < y2))) || (((y1 > y)) && ((y > y2)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x1,y1], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x2,y2], null)], null);
} else {
return null;
}
});
gadjett.linear.find_below_and_above_y = (function gadjett$linear$find_below_and_above_y(m,y){
var $ = cljs.core.map.call(null,cljs.core.vec,m);
var $__$1 = cljs.core.sort_by.call(null,cljs.core.first,$);
var $__$2 = cljs.core.map.call(null,cljs.core.partial.call(null,gadjett.linear.below_and_above_y,y),$__$1,cljs.core.rest.call(null,$__$1));
return cljs.core.remove.call(null,cljs.core.nil_QMARK_,$__$2);
});
gadjett.linear.calc_interpolated_values = (function gadjett$linear$calc_interpolated_values(m,y,interpolate_QMARK_,axes){
var $ = (function (p__48269){
var vec__48270 = p__48269;
var vec__48273 = cljs.core.nth.call(null,vec__48270,(0),null);
var x_below = cljs.core.nth.call(null,vec__48273,(0),null);
var y_below = cljs.core.nth.call(null,vec__48273,(1),null);
var vec__48276 = cljs.core.nth.call(null,vec__48270,(1),null);
var x_above = cljs.core.nth.call(null,vec__48276,(0),null);
var y_above = cljs.core.nth.call(null,vec__48276,(1),null);
if(cljs.core.truth_((function (){var and__24733__auto__ = y_below;
if(cljs.core.truth_(and__24733__auto__)){
var and__24733__auto____$1 = y_above;
if(cljs.core.truth_(and__24733__auto____$1)){
return interpolate_QMARK_.call(null,y_below,y_above);
} else {
return and__24733__auto____$1;
}
} else {
return and__24733__auto__;
}
})())){
return gadjett.linear.linear_x_func.call(null,axes).call(null,y,x_below,y_below,x_above,y_above);
} else {
return null;
}
});
return cljs.core.keep.call(null,$,gadjett.linear.find_below_and_above_y.call(null,m,y));
});
gadjett.linear.min_coll = (function gadjett$linear$min_coll(coll){
if(cljs.core.empty_QMARK_.call(null,coll)){
return null;
} else {
return cljs.core.apply.call(null,cljs.core.min,coll);
}
});
/**
 * Returns the interpolated x for a given y acording to the select-func thats passed
 * 
 * - `:interpolate?` -  a predicate for deciding eather to calc th interpolation or not.
 * -   `:axes` -  a map that defines what are the axes scales
 * -   `:select-func` - what functionality to use if there are multiple interpolated values
 * 
 * ~~~klipse
 *   (interpolate-linear-x {10 30 20 50 70 60} 32)
 * ~~~
 *   
 */
gadjett.linear.interpolate_linear_x = (function gadjett$linear$interpolate_linear_x(var_args){
var args__25827__auto__ = [];
var len__25820__auto___48285 = arguments.length;
var i__25821__auto___48286 = (0);
while(true){
if((i__25821__auto___48286 < len__25820__auto___48285)){
args__25827__auto__.push((arguments[i__25821__auto___48286]));

var G__48287 = (i__25821__auto___48286 + (1));
i__25821__auto___48286 = G__48287;
continue;
} else {
}
break;
}

var argseq__25828__auto__ = ((((2) < args__25827__auto__.length))?(new cljs.core.IndexedSeq(args__25827__auto__.slice((2)),(0),null)):null);
return gadjett.linear.interpolate_linear_x.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__25828__auto__);
});

gadjett.linear.interpolate_linear_x.cljs$core$IFn$_invoke$arity$variadic = (function (m,y,p__48282){
var map__48283 = p__48282;
var map__48283__$1 = ((((!((map__48283 == null)))?((((map__48283.cljs$lang$protocol_mask$partition0$ & (64))) || (map__48283.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48283):map__48283);
var interpolate_QMARK_ = cljs.core.get.call(null,map__48283__$1,new cljs.core.Keyword(null,"interpolate?","interpolate?",-423156286),cljs.core.constantly.call(null,true));
var axes = cljs.core.get.call(null,map__48283__$1,new cljs.core.Keyword(null,"axes","axes",1970866440),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"linear","linear",872268697)], null));
var select_func = cljs.core.get.call(null,map__48283__$1,new cljs.core.Keyword(null,"select-func","select-func",-1706031810),gadjett.linear.min_coll);
var values = gadjett.linear.find_keys_with_value.call(null,m,y);
var interpolated_values = gadjett.linear.calc_interpolated_values.call(null,m,y,interpolate_QMARK_,axes);
return select_func.call(null,cljs.core.concat.call(null,values,interpolated_values));
});

gadjett.linear.interpolate_linear_x.cljs$lang$maxFixedArity = (2);

gadjett.linear.interpolate_linear_x.cljs$lang$applyTo = (function (seq48279){
var G__48280 = cljs.core.first.call(null,seq48279);
var seq48279__$1 = cljs.core.next.call(null,seq48279);
var G__48281 = cljs.core.first.call(null,seq48279__$1);
var seq48279__$2 = cljs.core.next.call(null,seq48279__$1);
return gadjett.linear.interpolate_linear_x.cljs$core$IFn$_invoke$arity$variadic(G__48280,G__48281,seq48279__$2);
});

gadjett.linear.linear_equation = (function gadjett$linear$linear_equation(x1,y1,x2,y2){
var a = ((y1 - y2) / (x1 - x2));
var b = (y1 - (a * x1));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
});
gadjett.linear.log_x_linear_equation = (function gadjett$linear$log_x_linear_equation(x1,y1,x2,y2){
var a = ((y1 - y2) / (Math.log(x1) - Math.log(x2)));
var b = (y1 - (a * Math.log(x1)));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
});
gadjett.linear.linear_equation_func = (function gadjett$linear$linear_equation_func(p__48288){
var map__48292 = p__48288;
var map__48292__$1 = ((((!((map__48292 == null)))?((((map__48292.cljs$lang$protocol_mask$partition0$ & (64))) || (map__48292.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48292):map__48292);
var axes = map__48292__$1;
var x = cljs.core.get.call(null,map__48292__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.call(null,map__48292__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var G__48294 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__48294)){
return gadjett.linear.linear_equation;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__48294)){
return gadjett.linear.log_x_linear_equation;
} else {
return gadjett.linear.linear_equation;

}
}
});
gadjett.linear.intersection_point = (function gadjett$linear$intersection_point(a1,b1,a2,b2){
var x = ((b2 - b1) / (a1 - a2));
var y = ((a1 * x) + b1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
});
gadjett.linear.log_x_intersection_point = (function gadjett$linear$log_x_intersection_point(a1,b1,a2,b2){
var x = ((b2 - b1) / (a1 - a2));
var y = ((a1 * x) + b1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [Math.exp(x),y], null);
});
gadjett.linear.intersection_point_func = (function gadjett$linear$intersection_point_func(p__48295){
var map__48299 = p__48295;
var map__48299__$1 = ((((!((map__48299 == null)))?((((map__48299.cljs$lang$protocol_mask$partition0$ & (64))) || (map__48299.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48299):map__48299);
var axes = map__48299__$1;
var x = cljs.core.get.call(null,map__48299__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.call(null,map__48299__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var G__48301 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__48301)){
return gadjett.linear.intersection_point;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__48301)){
return gadjett.linear.log_x_intersection_point;
} else {
return gadjett.linear.intersection_point;

}
}
});
gadjett.linear.intersection_point_from_2_lines_points = (function gadjett$linear$intersection_point_from_2_lines_points(var_args){
var args__25827__auto__ = [];
var len__25820__auto___48325 = arguments.length;
var i__25821__auto___48326 = (0);
while(true){
if((i__25821__auto___48326 < len__25820__auto___48325)){
args__25827__auto__.push((arguments[i__25821__auto___48326]));

var G__48327 = (i__25821__auto___48326 + (1));
i__25821__auto___48326 = G__48327;
continue;
} else {
}
break;
}

var argseq__25828__auto__ = ((((2) < args__25827__auto__.length))?(new cljs.core.IndexedSeq(args__25827__auto__.slice((2)),(0),null)):null);
return gadjett.linear.intersection_point_from_2_lines_points.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__25828__auto__);
});

gadjett.linear.intersection_point_from_2_lines_points.cljs$core$IFn$_invoke$arity$variadic = (function (p__48305,p__48306,p__48307){
var vec__48308 = p__48305;
var ax1 = cljs.core.nth.call(null,vec__48308,(0),null);
var ay1 = cljs.core.nth.call(null,vec__48308,(1),null);
var ax2 = cljs.core.nth.call(null,vec__48308,(2),null);
var ay2 = cljs.core.nth.call(null,vec__48308,(3),null);
var vec__48311 = p__48306;
var bx1 = cljs.core.nth.call(null,vec__48311,(0),null);
var by1 = cljs.core.nth.call(null,vec__48311,(1),null);
var bx2 = cljs.core.nth.call(null,vec__48311,(2),null);
var by2 = cljs.core.nth.call(null,vec__48311,(3),null);
var map__48314 = p__48307;
var map__48314__$1 = ((((!((map__48314 == null)))?((((map__48314.cljs$lang$protocol_mask$partition0$ & (64))) || (map__48314.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48314):map__48314);
var axes = cljs.core.get.call(null,map__48314__$1,new cljs.core.Keyword(null,"axes","axes",1970866440),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"linear","linear",872268697)], null));
var vec__48316 = gadjett.linear.linear_equation_func.call(null,axes).call(null,ax1,ay1,ax2,ay2);
var a1 = cljs.core.nth.call(null,vec__48316,(0),null);
var b1 = cljs.core.nth.call(null,vec__48316,(1),null);
var vec__48319 = gadjett.linear.linear_equation_func.call(null,axes).call(null,bx1,by1,bx2,by2);
var a2 = cljs.core.nth.call(null,vec__48319,(0),null);
var b2 = cljs.core.nth.call(null,vec__48319,(1),null);
var vec__48322 = gadjett.linear.intersection_point_func.call(null,axes).call(null,a1,b1,a2,b2);
var x = cljs.core.nth.call(null,vec__48322,(0),null);
var y = cljs.core.nth.call(null,vec__48322,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
});

gadjett.linear.intersection_point_from_2_lines_points.cljs$lang$maxFixedArity = (2);

gadjett.linear.intersection_point_from_2_lines_points.cljs$lang$applyTo = (function (seq48302){
var G__48303 = cljs.core.first.call(null,seq48302);
var seq48302__$1 = cljs.core.next.call(null,seq48302);
var G__48304 = cljs.core.first.call(null,seq48302__$1);
var seq48302__$2 = cljs.core.next.call(null,seq48302__$1);
return gadjett.linear.intersection_point_from_2_lines_points.cljs$core$IFn$_invoke$arity$variadic(G__48303,G__48304,seq48302__$2);
});


//# sourceMappingURL=linear.js.map?rel=1473190054350