// Compiled by ClojureScript 1.7.228 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args20487 = [];
var len__19333__auto___20493 = arguments.length;
var i__19334__auto___20494 = (0);
while(true){
if((i__19334__auto___20494 < len__19333__auto___20493)){
args20487.push((arguments[i__19334__auto___20494]));

var G__20495 = (i__19334__auto___20494 + (1));
i__19334__auto___20494 = G__20495;
continue;
} else {
}
break;
}

var G__20489 = args20487.length;
switch (G__20489) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20487.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async20490 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20490 = (function (f,blockable,meta20491){
this.f = f;
this.blockable = blockable;
this.meta20491 = meta20491;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20490.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20492,meta20491__$1){
var self__ = this;
var _20492__$1 = this;
return (new cljs.core.async.t_cljs$core$async20490(self__.f,self__.blockable,meta20491__$1));
});

cljs.core.async.t_cljs$core$async20490.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20492){
var self__ = this;
var _20492__$1 = this;
return self__.meta20491;
});

cljs.core.async.t_cljs$core$async20490.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20490.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async20490.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async20490.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async20490.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta20491","meta20491",1188100399,null)], null);
});

cljs.core.async.t_cljs$core$async20490.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20490.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20490";

cljs.core.async.t_cljs$core$async20490.cljs$lang$ctorPrWriter = (function (this__18873__auto__,writer__18874__auto__,opt__18875__auto__){
return cljs.core._write.call(null,writer__18874__auto__,"cljs.core.async/t_cljs$core$async20490");
});

cljs.core.async.__GT_t_cljs$core$async20490 = (function cljs$core$async$__GT_t_cljs$core$async20490(f__$1,blockable__$1,meta20491){
return (new cljs.core.async.t_cljs$core$async20490(f__$1,blockable__$1,meta20491));
});

}

return (new cljs.core.async.t_cljs$core$async20490(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args20499 = [];
var len__19333__auto___20502 = arguments.length;
var i__19334__auto___20503 = (0);
while(true){
if((i__19334__auto___20503 < len__19333__auto___20502)){
args20499.push((arguments[i__19334__auto___20503]));

var G__20504 = (i__19334__auto___20503 + (1));
i__19334__auto___20503 = G__20504;
continue;
} else {
}
break;
}

var G__20501 = args20499.length;
switch (G__20501) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20499.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args20506 = [];
var len__19333__auto___20509 = arguments.length;
var i__19334__auto___20510 = (0);
while(true){
if((i__19334__auto___20510 < len__19333__auto___20509)){
args20506.push((arguments[i__19334__auto___20510]));

var G__20511 = (i__19334__auto___20510 + (1));
i__19334__auto___20510 = G__20511;
continue;
} else {
}
break;
}

var G__20508 = args20506.length;
switch (G__20508) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20506.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args20513 = [];
var len__19333__auto___20516 = arguments.length;
var i__19334__auto___20517 = (0);
while(true){
if((i__19334__auto___20517 < len__19333__auto___20516)){
args20513.push((arguments[i__19334__auto___20517]));

var G__20518 = (i__19334__auto___20517 + (1));
i__19334__auto___20517 = G__20518;
continue;
} else {
}
break;
}

var G__20515 = args20513.length;
switch (G__20515) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20513.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_20520 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_20520);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_20520,ret){
return (function (){
return fn1.call(null,val_20520);
});})(val_20520,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args20521 = [];
var len__19333__auto___20524 = arguments.length;
var i__19334__auto___20525 = (0);
while(true){
if((i__19334__auto___20525 < len__19333__auto___20524)){
args20521.push((arguments[i__19334__auto___20525]));

var G__20526 = (i__19334__auto___20525 + (1));
i__19334__auto___20525 = G__20526;
continue;
} else {
}
break;
}

var G__20523 = args20521.length;
switch (G__20523) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20521.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__19178__auto___20528 = n;
var x_20529 = (0);
while(true){
if((x_20529 < n__19178__auto___20528)){
(a[x_20529] = (0));

var G__20530 = (x_20529 + (1));
x_20529 = G__20530;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__20531 = (i + (1));
i = G__20531;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async20535 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20535 = (function (alt_flag,flag,meta20536){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta20536 = meta20536;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20535.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_20537,meta20536__$1){
var self__ = this;
var _20537__$1 = this;
return (new cljs.core.async.t_cljs$core$async20535(self__.alt_flag,self__.flag,meta20536__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async20535.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_20537){
var self__ = this;
var _20537__$1 = this;
return self__.meta20536;
});})(flag))
;

cljs.core.async.t_cljs$core$async20535.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20535.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async20535.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async20535.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async20535.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta20536","meta20536",1577314173,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async20535.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20535.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20535";

cljs.core.async.t_cljs$core$async20535.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__18873__auto__,writer__18874__auto__,opt__18875__auto__){
return cljs.core._write.call(null,writer__18874__auto__,"cljs.core.async/t_cljs$core$async20535");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async20535 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async20535(alt_flag__$1,flag__$1,meta20536){
return (new cljs.core.async.t_cljs$core$async20535(alt_flag__$1,flag__$1,meta20536));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async20535(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async20541 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20541 = (function (alt_handler,flag,cb,meta20542){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta20542 = meta20542;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20541.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20543,meta20542__$1){
var self__ = this;
var _20543__$1 = this;
return (new cljs.core.async.t_cljs$core$async20541(self__.alt_handler,self__.flag,self__.cb,meta20542__$1));
});

cljs.core.async.t_cljs$core$async20541.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20543){
var self__ = this;
var _20543__$1 = this;
return self__.meta20542;
});

cljs.core.async.t_cljs$core$async20541.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20541.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async20541.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async20541.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async20541.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta20542","meta20542",417297266,null)], null);
});

cljs.core.async.t_cljs$core$async20541.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20541.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20541";

cljs.core.async.t_cljs$core$async20541.cljs$lang$ctorPrWriter = (function (this__18873__auto__,writer__18874__auto__,opt__18875__auto__){
return cljs.core._write.call(null,writer__18874__auto__,"cljs.core.async/t_cljs$core$async20541");
});

cljs.core.async.__GT_t_cljs$core$async20541 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async20541(alt_handler__$1,flag__$1,cb__$1,meta20542){
return (new cljs.core.async.t_cljs$core$async20541(alt_handler__$1,flag__$1,cb__$1,meta20542));
});

}

return (new cljs.core.async.t_cljs$core$async20541(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20544_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20544_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20545_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20545_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__18275__auto__ = wport;
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return port;
}
})()], null));
} else {
var G__20546 = (i + (1));
i = G__20546;
continue;
}
} else {
return null;
}
break;
}
})();
var or__18275__auto__ = ret;
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__18263__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__18263__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__18263__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__19340__auto__ = [];
var len__19333__auto___20552 = arguments.length;
var i__19334__auto___20553 = (0);
while(true){
if((i__19334__auto___20553 < len__19333__auto___20552)){
args__19340__auto__.push((arguments[i__19334__auto___20553]));

var G__20554 = (i__19334__auto___20553 + (1));
i__19334__auto___20553 = G__20554;
continue;
} else {
}
break;
}

var argseq__19341__auto__ = ((((1) < args__19340__auto__.length))?(new cljs.core.IndexedSeq(args__19340__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19341__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__20549){
var map__20550 = p__20549;
var map__20550__$1 = ((((!((map__20550 == null)))?((((map__20550.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20550.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20550):map__20550);
var opts = map__20550__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq20547){
var G__20548 = cljs.core.first.call(null,seq20547);
var seq20547__$1 = cljs.core.next.call(null,seq20547);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20548,seq20547__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args20555 = [];
var len__19333__auto___20605 = arguments.length;
var i__19334__auto___20606 = (0);
while(true){
if((i__19334__auto___20606 < len__19333__auto___20605)){
args20555.push((arguments[i__19334__auto___20606]));

var G__20607 = (i__19334__auto___20606 + (1));
i__19334__auto___20606 = G__20607;
continue;
} else {
}
break;
}

var G__20557 = args20555.length;
switch (G__20557) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20555.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__20442__auto___20609 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto___20609){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto___20609){
return (function (state_20581){
var state_val_20582 = (state_20581[(1)]);
if((state_val_20582 === (7))){
var inst_20577 = (state_20581[(2)]);
var state_20581__$1 = state_20581;
var statearr_20583_20610 = state_20581__$1;
(statearr_20583_20610[(2)] = inst_20577);

(statearr_20583_20610[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20582 === (1))){
var state_20581__$1 = state_20581;
var statearr_20584_20611 = state_20581__$1;
(statearr_20584_20611[(2)] = null);

(statearr_20584_20611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20582 === (4))){
var inst_20560 = (state_20581[(7)]);
var inst_20560__$1 = (state_20581[(2)]);
var inst_20561 = (inst_20560__$1 == null);
var state_20581__$1 = (function (){var statearr_20585 = state_20581;
(statearr_20585[(7)] = inst_20560__$1);

return statearr_20585;
})();
if(cljs.core.truth_(inst_20561)){
var statearr_20586_20612 = state_20581__$1;
(statearr_20586_20612[(1)] = (5));

} else {
var statearr_20587_20613 = state_20581__$1;
(statearr_20587_20613[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20582 === (13))){
var state_20581__$1 = state_20581;
var statearr_20588_20614 = state_20581__$1;
(statearr_20588_20614[(2)] = null);

(statearr_20588_20614[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20582 === (6))){
var inst_20560 = (state_20581[(7)]);
var state_20581__$1 = state_20581;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20581__$1,(11),to,inst_20560);
} else {
if((state_val_20582 === (3))){
var inst_20579 = (state_20581[(2)]);
var state_20581__$1 = state_20581;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20581__$1,inst_20579);
} else {
if((state_val_20582 === (12))){
var state_20581__$1 = state_20581;
var statearr_20589_20615 = state_20581__$1;
(statearr_20589_20615[(2)] = null);

(statearr_20589_20615[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20582 === (2))){
var state_20581__$1 = state_20581;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20581__$1,(4),from);
} else {
if((state_val_20582 === (11))){
var inst_20570 = (state_20581[(2)]);
var state_20581__$1 = state_20581;
if(cljs.core.truth_(inst_20570)){
var statearr_20590_20616 = state_20581__$1;
(statearr_20590_20616[(1)] = (12));

} else {
var statearr_20591_20617 = state_20581__$1;
(statearr_20591_20617[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20582 === (9))){
var state_20581__$1 = state_20581;
var statearr_20592_20618 = state_20581__$1;
(statearr_20592_20618[(2)] = null);

(statearr_20592_20618[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20582 === (5))){
var state_20581__$1 = state_20581;
if(cljs.core.truth_(close_QMARK_)){
var statearr_20593_20619 = state_20581__$1;
(statearr_20593_20619[(1)] = (8));

} else {
var statearr_20594_20620 = state_20581__$1;
(statearr_20594_20620[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20582 === (14))){
var inst_20575 = (state_20581[(2)]);
var state_20581__$1 = state_20581;
var statearr_20595_20621 = state_20581__$1;
(statearr_20595_20621[(2)] = inst_20575);

(statearr_20595_20621[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20582 === (10))){
var inst_20567 = (state_20581[(2)]);
var state_20581__$1 = state_20581;
var statearr_20596_20622 = state_20581__$1;
(statearr_20596_20622[(2)] = inst_20567);

(statearr_20596_20622[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20582 === (8))){
var inst_20564 = cljs.core.async.close_BANG_.call(null,to);
var state_20581__$1 = state_20581;
var statearr_20597_20623 = state_20581__$1;
(statearr_20597_20623[(2)] = inst_20564);

(statearr_20597_20623[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto___20609))
;
return ((function (switch__20330__auto__,c__20442__auto___20609){
return (function() {
var cljs$core$async$state_machine__20331__auto__ = null;
var cljs$core$async$state_machine__20331__auto____0 = (function (){
var statearr_20601 = [null,null,null,null,null,null,null,null];
(statearr_20601[(0)] = cljs$core$async$state_machine__20331__auto__);

(statearr_20601[(1)] = (1));

return statearr_20601;
});
var cljs$core$async$state_machine__20331__auto____1 = (function (state_20581){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_20581);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e20602){if((e20602 instanceof Object)){
var ex__20334__auto__ = e20602;
var statearr_20603_20624 = state_20581;
(statearr_20603_20624[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20581);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20602;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20625 = state_20581;
state_20581 = G__20625;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$state_machine__20331__auto__ = function(state_20581){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20331__auto____1.call(this,state_20581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20331__auto____0;
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20331__auto____1;
return cljs$core$async$state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto___20609))
})();
var state__20444__auto__ = (function (){var statearr_20604 = f__20443__auto__.call(null);
(statearr_20604[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto___20609);

return statearr_20604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto___20609))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__20809){
var vec__20810 = p__20809;
var v = cljs.core.nth.call(null,vec__20810,(0),null);
var p = cljs.core.nth.call(null,vec__20810,(1),null);
var job = vec__20810;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__20442__auto___20992 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto___20992,res,vec__20810,v,p,job,jobs,results){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto___20992,res,vec__20810,v,p,job,jobs,results){
return (function (state_20815){
var state_val_20816 = (state_20815[(1)]);
if((state_val_20816 === (1))){
var state_20815__$1 = state_20815;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20815__$1,(2),res,v);
} else {
if((state_val_20816 === (2))){
var inst_20812 = (state_20815[(2)]);
var inst_20813 = cljs.core.async.close_BANG_.call(null,res);
var state_20815__$1 = (function (){var statearr_20817 = state_20815;
(statearr_20817[(7)] = inst_20812);

return statearr_20817;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20815__$1,inst_20813);
} else {
return null;
}
}
});})(c__20442__auto___20992,res,vec__20810,v,p,job,jobs,results))
;
return ((function (switch__20330__auto__,c__20442__auto___20992,res,vec__20810,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____0 = (function (){
var statearr_20821 = [null,null,null,null,null,null,null,null];
(statearr_20821[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__);

(statearr_20821[(1)] = (1));

return statearr_20821;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____1 = (function (state_20815){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_20815);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e20822){if((e20822 instanceof Object)){
var ex__20334__auto__ = e20822;
var statearr_20823_20993 = state_20815;
(statearr_20823_20993[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20815);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20822;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20994 = state_20815;
state_20815 = G__20994;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__ = function(state_20815){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____1.call(this,state_20815);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto___20992,res,vec__20810,v,p,job,jobs,results))
})();
var state__20444__auto__ = (function (){var statearr_20824 = f__20443__auto__.call(null);
(statearr_20824[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto___20992);

return statearr_20824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto___20992,res,vec__20810,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__20825){
var vec__20826 = p__20825;
var v = cljs.core.nth.call(null,vec__20826,(0),null);
var p = cljs.core.nth.call(null,vec__20826,(1),null);
var job = vec__20826;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__19178__auto___20995 = n;
var __20996 = (0);
while(true){
if((__20996 < n__19178__auto___20995)){
var G__20827_20997 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__20827_20997) {
case "compute":
var c__20442__auto___20999 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__20996,c__20442__auto___20999,G__20827_20997,n__19178__auto___20995,jobs,results,process,async){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (__20996,c__20442__auto___20999,G__20827_20997,n__19178__auto___20995,jobs,results,process,async){
return (function (state_20840){
var state_val_20841 = (state_20840[(1)]);
if((state_val_20841 === (1))){
var state_20840__$1 = state_20840;
var statearr_20842_21000 = state_20840__$1;
(statearr_20842_21000[(2)] = null);

(statearr_20842_21000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20841 === (2))){
var state_20840__$1 = state_20840;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20840__$1,(4),jobs);
} else {
if((state_val_20841 === (3))){
var inst_20838 = (state_20840[(2)]);
var state_20840__$1 = state_20840;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20840__$1,inst_20838);
} else {
if((state_val_20841 === (4))){
var inst_20830 = (state_20840[(2)]);
var inst_20831 = process.call(null,inst_20830);
var state_20840__$1 = state_20840;
if(cljs.core.truth_(inst_20831)){
var statearr_20843_21001 = state_20840__$1;
(statearr_20843_21001[(1)] = (5));

} else {
var statearr_20844_21002 = state_20840__$1;
(statearr_20844_21002[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20841 === (5))){
var state_20840__$1 = state_20840;
var statearr_20845_21003 = state_20840__$1;
(statearr_20845_21003[(2)] = null);

(statearr_20845_21003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20841 === (6))){
var state_20840__$1 = state_20840;
var statearr_20846_21004 = state_20840__$1;
(statearr_20846_21004[(2)] = null);

(statearr_20846_21004[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20841 === (7))){
var inst_20836 = (state_20840[(2)]);
var state_20840__$1 = state_20840;
var statearr_20847_21005 = state_20840__$1;
(statearr_20847_21005[(2)] = inst_20836);

(statearr_20847_21005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__20996,c__20442__auto___20999,G__20827_20997,n__19178__auto___20995,jobs,results,process,async))
;
return ((function (__20996,switch__20330__auto__,c__20442__auto___20999,G__20827_20997,n__19178__auto___20995,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____0 = (function (){
var statearr_20851 = [null,null,null,null,null,null,null];
(statearr_20851[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__);

(statearr_20851[(1)] = (1));

return statearr_20851;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____1 = (function (state_20840){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_20840);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e20852){if((e20852 instanceof Object)){
var ex__20334__auto__ = e20852;
var statearr_20853_21006 = state_20840;
(statearr_20853_21006[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20840);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20852;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21007 = state_20840;
state_20840 = G__21007;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__ = function(state_20840){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____1.call(this,state_20840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__;
})()
;})(__20996,switch__20330__auto__,c__20442__auto___20999,G__20827_20997,n__19178__auto___20995,jobs,results,process,async))
})();
var state__20444__auto__ = (function (){var statearr_20854 = f__20443__auto__.call(null);
(statearr_20854[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto___20999);

return statearr_20854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(__20996,c__20442__auto___20999,G__20827_20997,n__19178__auto___20995,jobs,results,process,async))
);


break;
case "async":
var c__20442__auto___21008 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__20996,c__20442__auto___21008,G__20827_20997,n__19178__auto___20995,jobs,results,process,async){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (__20996,c__20442__auto___21008,G__20827_20997,n__19178__auto___20995,jobs,results,process,async){
return (function (state_20867){
var state_val_20868 = (state_20867[(1)]);
if((state_val_20868 === (1))){
var state_20867__$1 = state_20867;
var statearr_20869_21009 = state_20867__$1;
(statearr_20869_21009[(2)] = null);

(statearr_20869_21009[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20868 === (2))){
var state_20867__$1 = state_20867;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20867__$1,(4),jobs);
} else {
if((state_val_20868 === (3))){
var inst_20865 = (state_20867[(2)]);
var state_20867__$1 = state_20867;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20867__$1,inst_20865);
} else {
if((state_val_20868 === (4))){
var inst_20857 = (state_20867[(2)]);
var inst_20858 = async.call(null,inst_20857);
var state_20867__$1 = state_20867;
if(cljs.core.truth_(inst_20858)){
var statearr_20870_21010 = state_20867__$1;
(statearr_20870_21010[(1)] = (5));

} else {
var statearr_20871_21011 = state_20867__$1;
(statearr_20871_21011[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20868 === (5))){
var state_20867__$1 = state_20867;
var statearr_20872_21012 = state_20867__$1;
(statearr_20872_21012[(2)] = null);

(statearr_20872_21012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20868 === (6))){
var state_20867__$1 = state_20867;
var statearr_20873_21013 = state_20867__$1;
(statearr_20873_21013[(2)] = null);

(statearr_20873_21013[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20868 === (7))){
var inst_20863 = (state_20867[(2)]);
var state_20867__$1 = state_20867;
var statearr_20874_21014 = state_20867__$1;
(statearr_20874_21014[(2)] = inst_20863);

(statearr_20874_21014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__20996,c__20442__auto___21008,G__20827_20997,n__19178__auto___20995,jobs,results,process,async))
;
return ((function (__20996,switch__20330__auto__,c__20442__auto___21008,G__20827_20997,n__19178__auto___20995,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____0 = (function (){
var statearr_20878 = [null,null,null,null,null,null,null];
(statearr_20878[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__);

(statearr_20878[(1)] = (1));

return statearr_20878;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____1 = (function (state_20867){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_20867);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e20879){if((e20879 instanceof Object)){
var ex__20334__auto__ = e20879;
var statearr_20880_21015 = state_20867;
(statearr_20880_21015[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20867);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20879;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21016 = state_20867;
state_20867 = G__21016;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__ = function(state_20867){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____1.call(this,state_20867);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__;
})()
;})(__20996,switch__20330__auto__,c__20442__auto___21008,G__20827_20997,n__19178__auto___20995,jobs,results,process,async))
})();
var state__20444__auto__ = (function (){var statearr_20881 = f__20443__auto__.call(null);
(statearr_20881[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto___21008);

return statearr_20881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(__20996,c__20442__auto___21008,G__20827_20997,n__19178__auto___20995,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__21017 = (__20996 + (1));
__20996 = G__21017;
continue;
} else {
}
break;
}

var c__20442__auto___21018 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto___21018,jobs,results,process,async){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto___21018,jobs,results,process,async){
return (function (state_20903){
var state_val_20904 = (state_20903[(1)]);
if((state_val_20904 === (1))){
var state_20903__$1 = state_20903;
var statearr_20905_21019 = state_20903__$1;
(statearr_20905_21019[(2)] = null);

(statearr_20905_21019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20904 === (2))){
var state_20903__$1 = state_20903;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20903__$1,(4),from);
} else {
if((state_val_20904 === (3))){
var inst_20901 = (state_20903[(2)]);
var state_20903__$1 = state_20903;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20903__$1,inst_20901);
} else {
if((state_val_20904 === (4))){
var inst_20884 = (state_20903[(7)]);
var inst_20884__$1 = (state_20903[(2)]);
var inst_20885 = (inst_20884__$1 == null);
var state_20903__$1 = (function (){var statearr_20906 = state_20903;
(statearr_20906[(7)] = inst_20884__$1);

return statearr_20906;
})();
if(cljs.core.truth_(inst_20885)){
var statearr_20907_21020 = state_20903__$1;
(statearr_20907_21020[(1)] = (5));

} else {
var statearr_20908_21021 = state_20903__$1;
(statearr_20908_21021[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20904 === (5))){
var inst_20887 = cljs.core.async.close_BANG_.call(null,jobs);
var state_20903__$1 = state_20903;
var statearr_20909_21022 = state_20903__$1;
(statearr_20909_21022[(2)] = inst_20887);

(statearr_20909_21022[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20904 === (6))){
var inst_20889 = (state_20903[(8)]);
var inst_20884 = (state_20903[(7)]);
var inst_20889__$1 = cljs.core.async.chan.call(null,(1));
var inst_20890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20891 = [inst_20884,inst_20889__$1];
var inst_20892 = (new cljs.core.PersistentVector(null,2,(5),inst_20890,inst_20891,null));
var state_20903__$1 = (function (){var statearr_20910 = state_20903;
(statearr_20910[(8)] = inst_20889__$1);

return statearr_20910;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20903__$1,(8),jobs,inst_20892);
} else {
if((state_val_20904 === (7))){
var inst_20899 = (state_20903[(2)]);
var state_20903__$1 = state_20903;
var statearr_20911_21023 = state_20903__$1;
(statearr_20911_21023[(2)] = inst_20899);

(statearr_20911_21023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20904 === (8))){
var inst_20889 = (state_20903[(8)]);
var inst_20894 = (state_20903[(2)]);
var state_20903__$1 = (function (){var statearr_20912 = state_20903;
(statearr_20912[(9)] = inst_20894);

return statearr_20912;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20903__$1,(9),results,inst_20889);
} else {
if((state_val_20904 === (9))){
var inst_20896 = (state_20903[(2)]);
var state_20903__$1 = (function (){var statearr_20913 = state_20903;
(statearr_20913[(10)] = inst_20896);

return statearr_20913;
})();
var statearr_20914_21024 = state_20903__$1;
(statearr_20914_21024[(2)] = null);

(statearr_20914_21024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__20442__auto___21018,jobs,results,process,async))
;
return ((function (switch__20330__auto__,c__20442__auto___21018,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____0 = (function (){
var statearr_20918 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20918[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__);

(statearr_20918[(1)] = (1));

return statearr_20918;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____1 = (function (state_20903){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_20903);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e20919){if((e20919 instanceof Object)){
var ex__20334__auto__ = e20919;
var statearr_20920_21025 = state_20903;
(statearr_20920_21025[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20903);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20919;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21026 = state_20903;
state_20903 = G__21026;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__ = function(state_20903){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____1.call(this,state_20903);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto___21018,jobs,results,process,async))
})();
var state__20444__auto__ = (function (){var statearr_20921 = f__20443__auto__.call(null);
(statearr_20921[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto___21018);

return statearr_20921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto___21018,jobs,results,process,async))
);


var c__20442__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto__,jobs,results,process,async){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto__,jobs,results,process,async){
return (function (state_20959){
var state_val_20960 = (state_20959[(1)]);
if((state_val_20960 === (7))){
var inst_20955 = (state_20959[(2)]);
var state_20959__$1 = state_20959;
var statearr_20961_21027 = state_20959__$1;
(statearr_20961_21027[(2)] = inst_20955);

(statearr_20961_21027[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20960 === (20))){
var state_20959__$1 = state_20959;
var statearr_20962_21028 = state_20959__$1;
(statearr_20962_21028[(2)] = null);

(statearr_20962_21028[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20960 === (1))){
var state_20959__$1 = state_20959;
var statearr_20963_21029 = state_20959__$1;
(statearr_20963_21029[(2)] = null);

(statearr_20963_21029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20960 === (4))){
var inst_20924 = (state_20959[(7)]);
var inst_20924__$1 = (state_20959[(2)]);
var inst_20925 = (inst_20924__$1 == null);
var state_20959__$1 = (function (){var statearr_20964 = state_20959;
(statearr_20964[(7)] = inst_20924__$1);

return statearr_20964;
})();
if(cljs.core.truth_(inst_20925)){
var statearr_20965_21030 = state_20959__$1;
(statearr_20965_21030[(1)] = (5));

} else {
var statearr_20966_21031 = state_20959__$1;
(statearr_20966_21031[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20960 === (15))){
var inst_20937 = (state_20959[(8)]);
var state_20959__$1 = state_20959;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20959__$1,(18),to,inst_20937);
} else {
if((state_val_20960 === (21))){
var inst_20950 = (state_20959[(2)]);
var state_20959__$1 = state_20959;
var statearr_20967_21032 = state_20959__$1;
(statearr_20967_21032[(2)] = inst_20950);

(statearr_20967_21032[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20960 === (13))){
var inst_20952 = (state_20959[(2)]);
var state_20959__$1 = (function (){var statearr_20968 = state_20959;
(statearr_20968[(9)] = inst_20952);

return statearr_20968;
})();
var statearr_20969_21033 = state_20959__$1;
(statearr_20969_21033[(2)] = null);

(statearr_20969_21033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20960 === (6))){
var inst_20924 = (state_20959[(7)]);
var state_20959__$1 = state_20959;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20959__$1,(11),inst_20924);
} else {
if((state_val_20960 === (17))){
var inst_20945 = (state_20959[(2)]);
var state_20959__$1 = state_20959;
if(cljs.core.truth_(inst_20945)){
var statearr_20970_21034 = state_20959__$1;
(statearr_20970_21034[(1)] = (19));

} else {
var statearr_20971_21035 = state_20959__$1;
(statearr_20971_21035[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20960 === (3))){
var inst_20957 = (state_20959[(2)]);
var state_20959__$1 = state_20959;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20959__$1,inst_20957);
} else {
if((state_val_20960 === (12))){
var inst_20934 = (state_20959[(10)]);
var state_20959__$1 = state_20959;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20959__$1,(14),inst_20934);
} else {
if((state_val_20960 === (2))){
var state_20959__$1 = state_20959;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20959__$1,(4),results);
} else {
if((state_val_20960 === (19))){
var state_20959__$1 = state_20959;
var statearr_20972_21036 = state_20959__$1;
(statearr_20972_21036[(2)] = null);

(statearr_20972_21036[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20960 === (11))){
var inst_20934 = (state_20959[(2)]);
var state_20959__$1 = (function (){var statearr_20973 = state_20959;
(statearr_20973[(10)] = inst_20934);

return statearr_20973;
})();
var statearr_20974_21037 = state_20959__$1;
(statearr_20974_21037[(2)] = null);

(statearr_20974_21037[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20960 === (9))){
var state_20959__$1 = state_20959;
var statearr_20975_21038 = state_20959__$1;
(statearr_20975_21038[(2)] = null);

(statearr_20975_21038[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20960 === (5))){
var state_20959__$1 = state_20959;
if(cljs.core.truth_(close_QMARK_)){
var statearr_20976_21039 = state_20959__$1;
(statearr_20976_21039[(1)] = (8));

} else {
var statearr_20977_21040 = state_20959__$1;
(statearr_20977_21040[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20960 === (14))){
var inst_20939 = (state_20959[(11)]);
var inst_20937 = (state_20959[(8)]);
var inst_20937__$1 = (state_20959[(2)]);
var inst_20938 = (inst_20937__$1 == null);
var inst_20939__$1 = cljs.core.not.call(null,inst_20938);
var state_20959__$1 = (function (){var statearr_20978 = state_20959;
(statearr_20978[(11)] = inst_20939__$1);

(statearr_20978[(8)] = inst_20937__$1);

return statearr_20978;
})();
if(inst_20939__$1){
var statearr_20979_21041 = state_20959__$1;
(statearr_20979_21041[(1)] = (15));

} else {
var statearr_20980_21042 = state_20959__$1;
(statearr_20980_21042[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20960 === (16))){
var inst_20939 = (state_20959[(11)]);
var state_20959__$1 = state_20959;
var statearr_20981_21043 = state_20959__$1;
(statearr_20981_21043[(2)] = inst_20939);

(statearr_20981_21043[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20960 === (10))){
var inst_20931 = (state_20959[(2)]);
var state_20959__$1 = state_20959;
var statearr_20982_21044 = state_20959__$1;
(statearr_20982_21044[(2)] = inst_20931);

(statearr_20982_21044[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20960 === (18))){
var inst_20942 = (state_20959[(2)]);
var state_20959__$1 = state_20959;
var statearr_20983_21045 = state_20959__$1;
(statearr_20983_21045[(2)] = inst_20942);

(statearr_20983_21045[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20960 === (8))){
var inst_20928 = cljs.core.async.close_BANG_.call(null,to);
var state_20959__$1 = state_20959;
var statearr_20984_21046 = state_20959__$1;
(statearr_20984_21046[(2)] = inst_20928);

(statearr_20984_21046[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto__,jobs,results,process,async))
;
return ((function (switch__20330__auto__,c__20442__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____0 = (function (){
var statearr_20988 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20988[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__);

(statearr_20988[(1)] = (1));

return statearr_20988;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____1 = (function (state_20959){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_20959);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e20989){if((e20989 instanceof Object)){
var ex__20334__auto__ = e20989;
var statearr_20990_21047 = state_20959;
(statearr_20990_21047[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20959);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20989;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21048 = state_20959;
state_20959 = G__21048;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__ = function(state_20959){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____1.call(this,state_20959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20331__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto__,jobs,results,process,async))
})();
var state__20444__auto__ = (function (){var statearr_20991 = f__20443__auto__.call(null);
(statearr_20991[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto__);

return statearr_20991;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto__,jobs,results,process,async))
);

return c__20442__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args21049 = [];
var len__19333__auto___21052 = arguments.length;
var i__19334__auto___21053 = (0);
while(true){
if((i__19334__auto___21053 < len__19333__auto___21052)){
args21049.push((arguments[i__19334__auto___21053]));

var G__21054 = (i__19334__auto___21053 + (1));
i__19334__auto___21053 = G__21054;
continue;
} else {
}
break;
}

var G__21051 = args21049.length;
switch (G__21051) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21049.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args21056 = [];
var len__19333__auto___21059 = arguments.length;
var i__19334__auto___21060 = (0);
while(true){
if((i__19334__auto___21060 < len__19333__auto___21059)){
args21056.push((arguments[i__19334__auto___21060]));

var G__21061 = (i__19334__auto___21060 + (1));
i__19334__auto___21060 = G__21061;
continue;
} else {
}
break;
}

var G__21058 = args21056.length;
switch (G__21058) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21056.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args21063 = [];
var len__19333__auto___21116 = arguments.length;
var i__19334__auto___21117 = (0);
while(true){
if((i__19334__auto___21117 < len__19333__auto___21116)){
args21063.push((arguments[i__19334__auto___21117]));

var G__21118 = (i__19334__auto___21117 + (1));
i__19334__auto___21117 = G__21118;
continue;
} else {
}
break;
}

var G__21065 = args21063.length;
switch (G__21065) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21063.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__20442__auto___21120 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto___21120,tc,fc){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto___21120,tc,fc){
return (function (state_21091){
var state_val_21092 = (state_21091[(1)]);
if((state_val_21092 === (7))){
var inst_21087 = (state_21091[(2)]);
var state_21091__$1 = state_21091;
var statearr_21093_21121 = state_21091__$1;
(statearr_21093_21121[(2)] = inst_21087);

(statearr_21093_21121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21092 === (1))){
var state_21091__$1 = state_21091;
var statearr_21094_21122 = state_21091__$1;
(statearr_21094_21122[(2)] = null);

(statearr_21094_21122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21092 === (4))){
var inst_21068 = (state_21091[(7)]);
var inst_21068__$1 = (state_21091[(2)]);
var inst_21069 = (inst_21068__$1 == null);
var state_21091__$1 = (function (){var statearr_21095 = state_21091;
(statearr_21095[(7)] = inst_21068__$1);

return statearr_21095;
})();
if(cljs.core.truth_(inst_21069)){
var statearr_21096_21123 = state_21091__$1;
(statearr_21096_21123[(1)] = (5));

} else {
var statearr_21097_21124 = state_21091__$1;
(statearr_21097_21124[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21092 === (13))){
var state_21091__$1 = state_21091;
var statearr_21098_21125 = state_21091__$1;
(statearr_21098_21125[(2)] = null);

(statearr_21098_21125[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21092 === (6))){
var inst_21068 = (state_21091[(7)]);
var inst_21074 = p.call(null,inst_21068);
var state_21091__$1 = state_21091;
if(cljs.core.truth_(inst_21074)){
var statearr_21099_21126 = state_21091__$1;
(statearr_21099_21126[(1)] = (9));

} else {
var statearr_21100_21127 = state_21091__$1;
(statearr_21100_21127[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21092 === (3))){
var inst_21089 = (state_21091[(2)]);
var state_21091__$1 = state_21091;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21091__$1,inst_21089);
} else {
if((state_val_21092 === (12))){
var state_21091__$1 = state_21091;
var statearr_21101_21128 = state_21091__$1;
(statearr_21101_21128[(2)] = null);

(statearr_21101_21128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21092 === (2))){
var state_21091__$1 = state_21091;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21091__$1,(4),ch);
} else {
if((state_val_21092 === (11))){
var inst_21068 = (state_21091[(7)]);
var inst_21078 = (state_21091[(2)]);
var state_21091__$1 = state_21091;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21091__$1,(8),inst_21078,inst_21068);
} else {
if((state_val_21092 === (9))){
var state_21091__$1 = state_21091;
var statearr_21102_21129 = state_21091__$1;
(statearr_21102_21129[(2)] = tc);

(statearr_21102_21129[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21092 === (5))){
var inst_21071 = cljs.core.async.close_BANG_.call(null,tc);
var inst_21072 = cljs.core.async.close_BANG_.call(null,fc);
var state_21091__$1 = (function (){var statearr_21103 = state_21091;
(statearr_21103[(8)] = inst_21071);

return statearr_21103;
})();
var statearr_21104_21130 = state_21091__$1;
(statearr_21104_21130[(2)] = inst_21072);

(statearr_21104_21130[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21092 === (14))){
var inst_21085 = (state_21091[(2)]);
var state_21091__$1 = state_21091;
var statearr_21105_21131 = state_21091__$1;
(statearr_21105_21131[(2)] = inst_21085);

(statearr_21105_21131[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21092 === (10))){
var state_21091__$1 = state_21091;
var statearr_21106_21132 = state_21091__$1;
(statearr_21106_21132[(2)] = fc);

(statearr_21106_21132[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21092 === (8))){
var inst_21080 = (state_21091[(2)]);
var state_21091__$1 = state_21091;
if(cljs.core.truth_(inst_21080)){
var statearr_21107_21133 = state_21091__$1;
(statearr_21107_21133[(1)] = (12));

} else {
var statearr_21108_21134 = state_21091__$1;
(statearr_21108_21134[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto___21120,tc,fc))
;
return ((function (switch__20330__auto__,c__20442__auto___21120,tc,fc){
return (function() {
var cljs$core$async$state_machine__20331__auto__ = null;
var cljs$core$async$state_machine__20331__auto____0 = (function (){
var statearr_21112 = [null,null,null,null,null,null,null,null,null];
(statearr_21112[(0)] = cljs$core$async$state_machine__20331__auto__);

(statearr_21112[(1)] = (1));

return statearr_21112;
});
var cljs$core$async$state_machine__20331__auto____1 = (function (state_21091){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_21091);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e21113){if((e21113 instanceof Object)){
var ex__20334__auto__ = e21113;
var statearr_21114_21135 = state_21091;
(statearr_21114_21135[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21091);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21113;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21136 = state_21091;
state_21091 = G__21136;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$state_machine__20331__auto__ = function(state_21091){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20331__auto____1.call(this,state_21091);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20331__auto____0;
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20331__auto____1;
return cljs$core$async$state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto___21120,tc,fc))
})();
var state__20444__auto__ = (function (){var statearr_21115 = f__20443__auto__.call(null);
(statearr_21115[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto___21120);

return statearr_21115;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto___21120,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__20442__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto__){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto__){
return (function (state_21200){
var state_val_21201 = (state_21200[(1)]);
if((state_val_21201 === (7))){
var inst_21196 = (state_21200[(2)]);
var state_21200__$1 = state_21200;
var statearr_21202_21223 = state_21200__$1;
(statearr_21202_21223[(2)] = inst_21196);

(statearr_21202_21223[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21201 === (1))){
var inst_21180 = init;
var state_21200__$1 = (function (){var statearr_21203 = state_21200;
(statearr_21203[(7)] = inst_21180);

return statearr_21203;
})();
var statearr_21204_21224 = state_21200__$1;
(statearr_21204_21224[(2)] = null);

(statearr_21204_21224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21201 === (4))){
var inst_21183 = (state_21200[(8)]);
var inst_21183__$1 = (state_21200[(2)]);
var inst_21184 = (inst_21183__$1 == null);
var state_21200__$1 = (function (){var statearr_21205 = state_21200;
(statearr_21205[(8)] = inst_21183__$1);

return statearr_21205;
})();
if(cljs.core.truth_(inst_21184)){
var statearr_21206_21225 = state_21200__$1;
(statearr_21206_21225[(1)] = (5));

} else {
var statearr_21207_21226 = state_21200__$1;
(statearr_21207_21226[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21201 === (6))){
var inst_21183 = (state_21200[(8)]);
var inst_21180 = (state_21200[(7)]);
var inst_21187 = (state_21200[(9)]);
var inst_21187__$1 = f.call(null,inst_21180,inst_21183);
var inst_21188 = cljs.core.reduced_QMARK_.call(null,inst_21187__$1);
var state_21200__$1 = (function (){var statearr_21208 = state_21200;
(statearr_21208[(9)] = inst_21187__$1);

return statearr_21208;
})();
if(inst_21188){
var statearr_21209_21227 = state_21200__$1;
(statearr_21209_21227[(1)] = (8));

} else {
var statearr_21210_21228 = state_21200__$1;
(statearr_21210_21228[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21201 === (3))){
var inst_21198 = (state_21200[(2)]);
var state_21200__$1 = state_21200;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21200__$1,inst_21198);
} else {
if((state_val_21201 === (2))){
var state_21200__$1 = state_21200;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21200__$1,(4),ch);
} else {
if((state_val_21201 === (9))){
var inst_21187 = (state_21200[(9)]);
var inst_21180 = inst_21187;
var state_21200__$1 = (function (){var statearr_21211 = state_21200;
(statearr_21211[(7)] = inst_21180);

return statearr_21211;
})();
var statearr_21212_21229 = state_21200__$1;
(statearr_21212_21229[(2)] = null);

(statearr_21212_21229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21201 === (5))){
var inst_21180 = (state_21200[(7)]);
var state_21200__$1 = state_21200;
var statearr_21213_21230 = state_21200__$1;
(statearr_21213_21230[(2)] = inst_21180);

(statearr_21213_21230[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21201 === (10))){
var inst_21194 = (state_21200[(2)]);
var state_21200__$1 = state_21200;
var statearr_21214_21231 = state_21200__$1;
(statearr_21214_21231[(2)] = inst_21194);

(statearr_21214_21231[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21201 === (8))){
var inst_21187 = (state_21200[(9)]);
var inst_21190 = cljs.core.deref.call(null,inst_21187);
var state_21200__$1 = state_21200;
var statearr_21215_21232 = state_21200__$1;
(statearr_21215_21232[(2)] = inst_21190);

(statearr_21215_21232[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto__))
;
return ((function (switch__20330__auto__,c__20442__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__20331__auto__ = null;
var cljs$core$async$reduce_$_state_machine__20331__auto____0 = (function (){
var statearr_21219 = [null,null,null,null,null,null,null,null,null,null];
(statearr_21219[(0)] = cljs$core$async$reduce_$_state_machine__20331__auto__);

(statearr_21219[(1)] = (1));

return statearr_21219;
});
var cljs$core$async$reduce_$_state_machine__20331__auto____1 = (function (state_21200){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_21200);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e21220){if((e21220 instanceof Object)){
var ex__20334__auto__ = e21220;
var statearr_21221_21233 = state_21200;
(statearr_21221_21233[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21200);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21220;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21234 = state_21200;
state_21200 = G__21234;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__20331__auto__ = function(state_21200){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__20331__auto____1.call(this,state_21200);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__20331__auto____0;
cljs$core$async$reduce_$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__20331__auto____1;
return cljs$core$async$reduce_$_state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto__))
})();
var state__20444__auto__ = (function (){var statearr_21222 = f__20443__auto__.call(null);
(statearr_21222[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto__);

return statearr_21222;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto__))
);

return c__20442__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args21235 = [];
var len__19333__auto___21287 = arguments.length;
var i__19334__auto___21288 = (0);
while(true){
if((i__19334__auto___21288 < len__19333__auto___21287)){
args21235.push((arguments[i__19334__auto___21288]));

var G__21289 = (i__19334__auto___21288 + (1));
i__19334__auto___21288 = G__21289;
continue;
} else {
}
break;
}

var G__21237 = args21235.length;
switch (G__21237) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21235.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__20442__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto__){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto__){
return (function (state_21262){
var state_val_21263 = (state_21262[(1)]);
if((state_val_21263 === (7))){
var inst_21244 = (state_21262[(2)]);
var state_21262__$1 = state_21262;
var statearr_21264_21291 = state_21262__$1;
(statearr_21264_21291[(2)] = inst_21244);

(statearr_21264_21291[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21263 === (1))){
var inst_21238 = cljs.core.seq.call(null,coll);
var inst_21239 = inst_21238;
var state_21262__$1 = (function (){var statearr_21265 = state_21262;
(statearr_21265[(7)] = inst_21239);

return statearr_21265;
})();
var statearr_21266_21292 = state_21262__$1;
(statearr_21266_21292[(2)] = null);

(statearr_21266_21292[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21263 === (4))){
var inst_21239 = (state_21262[(7)]);
var inst_21242 = cljs.core.first.call(null,inst_21239);
var state_21262__$1 = state_21262;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21262__$1,(7),ch,inst_21242);
} else {
if((state_val_21263 === (13))){
var inst_21256 = (state_21262[(2)]);
var state_21262__$1 = state_21262;
var statearr_21267_21293 = state_21262__$1;
(statearr_21267_21293[(2)] = inst_21256);

(statearr_21267_21293[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21263 === (6))){
var inst_21247 = (state_21262[(2)]);
var state_21262__$1 = state_21262;
if(cljs.core.truth_(inst_21247)){
var statearr_21268_21294 = state_21262__$1;
(statearr_21268_21294[(1)] = (8));

} else {
var statearr_21269_21295 = state_21262__$1;
(statearr_21269_21295[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21263 === (3))){
var inst_21260 = (state_21262[(2)]);
var state_21262__$1 = state_21262;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21262__$1,inst_21260);
} else {
if((state_val_21263 === (12))){
var state_21262__$1 = state_21262;
var statearr_21270_21296 = state_21262__$1;
(statearr_21270_21296[(2)] = null);

(statearr_21270_21296[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21263 === (2))){
var inst_21239 = (state_21262[(7)]);
var state_21262__$1 = state_21262;
if(cljs.core.truth_(inst_21239)){
var statearr_21271_21297 = state_21262__$1;
(statearr_21271_21297[(1)] = (4));

} else {
var statearr_21272_21298 = state_21262__$1;
(statearr_21272_21298[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21263 === (11))){
var inst_21253 = cljs.core.async.close_BANG_.call(null,ch);
var state_21262__$1 = state_21262;
var statearr_21273_21299 = state_21262__$1;
(statearr_21273_21299[(2)] = inst_21253);

(statearr_21273_21299[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21263 === (9))){
var state_21262__$1 = state_21262;
if(cljs.core.truth_(close_QMARK_)){
var statearr_21274_21300 = state_21262__$1;
(statearr_21274_21300[(1)] = (11));

} else {
var statearr_21275_21301 = state_21262__$1;
(statearr_21275_21301[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21263 === (5))){
var inst_21239 = (state_21262[(7)]);
var state_21262__$1 = state_21262;
var statearr_21276_21302 = state_21262__$1;
(statearr_21276_21302[(2)] = inst_21239);

(statearr_21276_21302[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21263 === (10))){
var inst_21258 = (state_21262[(2)]);
var state_21262__$1 = state_21262;
var statearr_21277_21303 = state_21262__$1;
(statearr_21277_21303[(2)] = inst_21258);

(statearr_21277_21303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21263 === (8))){
var inst_21239 = (state_21262[(7)]);
var inst_21249 = cljs.core.next.call(null,inst_21239);
var inst_21239__$1 = inst_21249;
var state_21262__$1 = (function (){var statearr_21278 = state_21262;
(statearr_21278[(7)] = inst_21239__$1);

return statearr_21278;
})();
var statearr_21279_21304 = state_21262__$1;
(statearr_21279_21304[(2)] = null);

(statearr_21279_21304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto__))
;
return ((function (switch__20330__auto__,c__20442__auto__){
return (function() {
var cljs$core$async$state_machine__20331__auto__ = null;
var cljs$core$async$state_machine__20331__auto____0 = (function (){
var statearr_21283 = [null,null,null,null,null,null,null,null];
(statearr_21283[(0)] = cljs$core$async$state_machine__20331__auto__);

(statearr_21283[(1)] = (1));

return statearr_21283;
});
var cljs$core$async$state_machine__20331__auto____1 = (function (state_21262){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_21262);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e21284){if((e21284 instanceof Object)){
var ex__20334__auto__ = e21284;
var statearr_21285_21305 = state_21262;
(statearr_21285_21305[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21262);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21284;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21306 = state_21262;
state_21262 = G__21306;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$state_machine__20331__auto__ = function(state_21262){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20331__auto____1.call(this,state_21262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20331__auto____0;
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20331__auto____1;
return cljs$core$async$state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto__))
})();
var state__20444__auto__ = (function (){var statearr_21286 = f__20443__auto__.call(null);
(statearr_21286[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto__);

return statearr_21286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto__))
);

return c__20442__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__18930__auto__ = (((_ == null))?null:_);
var m__18931__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__18930__auto__)]);
if(!((m__18931__auto__ == null))){
return m__18931__auto__.call(null,_);
} else {
var m__18931__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__18931__auto____$1 == null))){
return m__18931__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__18930__auto__ = (((m == null))?null:m);
var m__18931__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__18930__auto__)]);
if(!((m__18931__auto__ == null))){
return m__18931__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__18931__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__18931__auto____$1 == null))){
return m__18931__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__18930__auto__ = (((m == null))?null:m);
var m__18931__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__18930__auto__)]);
if(!((m__18931__auto__ == null))){
return m__18931__auto__.call(null,m,ch);
} else {
var m__18931__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__18931__auto____$1 == null))){
return m__18931__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__18930__auto__ = (((m == null))?null:m);
var m__18931__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__18930__auto__)]);
if(!((m__18931__auto__ == null))){
return m__18931__auto__.call(null,m);
} else {
var m__18931__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__18931__auto____$1 == null))){
return m__18931__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async21528 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21528 = (function (mult,ch,cs,meta21529){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta21529 = meta21529;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21528.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_21530,meta21529__$1){
var self__ = this;
var _21530__$1 = this;
return (new cljs.core.async.t_cljs$core$async21528(self__.mult,self__.ch,self__.cs,meta21529__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async21528.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_21530){
var self__ = this;
var _21530__$1 = this;
return self__.meta21529;
});})(cs))
;

cljs.core.async.t_cljs$core$async21528.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async21528.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async21528.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async21528.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21528.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21528.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21528.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta21529","meta21529",-1221519094,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async21528.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21528.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21528";

cljs.core.async.t_cljs$core$async21528.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__18873__auto__,writer__18874__auto__,opt__18875__auto__){
return cljs.core._write.call(null,writer__18874__auto__,"cljs.core.async/t_cljs$core$async21528");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async21528 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async21528(mult__$1,ch__$1,cs__$1,meta21529){
return (new cljs.core.async.t_cljs$core$async21528(mult__$1,ch__$1,cs__$1,meta21529));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async21528(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__20442__auto___21749 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto___21749,cs,m,dchan,dctr,done){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto___21749,cs,m,dchan,dctr,done){
return (function (state_21661){
var state_val_21662 = (state_21661[(1)]);
if((state_val_21662 === (7))){
var inst_21657 = (state_21661[(2)]);
var state_21661__$1 = state_21661;
var statearr_21663_21750 = state_21661__$1;
(statearr_21663_21750[(2)] = inst_21657);

(statearr_21663_21750[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (20))){
var inst_21562 = (state_21661[(7)]);
var inst_21572 = cljs.core.first.call(null,inst_21562);
var inst_21573 = cljs.core.nth.call(null,inst_21572,(0),null);
var inst_21574 = cljs.core.nth.call(null,inst_21572,(1),null);
var state_21661__$1 = (function (){var statearr_21664 = state_21661;
(statearr_21664[(8)] = inst_21573);

return statearr_21664;
})();
if(cljs.core.truth_(inst_21574)){
var statearr_21665_21751 = state_21661__$1;
(statearr_21665_21751[(1)] = (22));

} else {
var statearr_21666_21752 = state_21661__$1;
(statearr_21666_21752[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (27))){
var inst_21602 = (state_21661[(9)]);
var inst_21533 = (state_21661[(10)]);
var inst_21604 = (state_21661[(11)]);
var inst_21609 = (state_21661[(12)]);
var inst_21609__$1 = cljs.core._nth.call(null,inst_21602,inst_21604);
var inst_21610 = cljs.core.async.put_BANG_.call(null,inst_21609__$1,inst_21533,done);
var state_21661__$1 = (function (){var statearr_21667 = state_21661;
(statearr_21667[(12)] = inst_21609__$1);

return statearr_21667;
})();
if(cljs.core.truth_(inst_21610)){
var statearr_21668_21753 = state_21661__$1;
(statearr_21668_21753[(1)] = (30));

} else {
var statearr_21669_21754 = state_21661__$1;
(statearr_21669_21754[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (1))){
var state_21661__$1 = state_21661;
var statearr_21670_21755 = state_21661__$1;
(statearr_21670_21755[(2)] = null);

(statearr_21670_21755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (24))){
var inst_21562 = (state_21661[(7)]);
var inst_21579 = (state_21661[(2)]);
var inst_21580 = cljs.core.next.call(null,inst_21562);
var inst_21542 = inst_21580;
var inst_21543 = null;
var inst_21544 = (0);
var inst_21545 = (0);
var state_21661__$1 = (function (){var statearr_21671 = state_21661;
(statearr_21671[(13)] = inst_21542);

(statearr_21671[(14)] = inst_21543);

(statearr_21671[(15)] = inst_21545);

(statearr_21671[(16)] = inst_21579);

(statearr_21671[(17)] = inst_21544);

return statearr_21671;
})();
var statearr_21672_21756 = state_21661__$1;
(statearr_21672_21756[(2)] = null);

(statearr_21672_21756[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (39))){
var state_21661__$1 = state_21661;
var statearr_21676_21757 = state_21661__$1;
(statearr_21676_21757[(2)] = null);

(statearr_21676_21757[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (4))){
var inst_21533 = (state_21661[(10)]);
var inst_21533__$1 = (state_21661[(2)]);
var inst_21534 = (inst_21533__$1 == null);
var state_21661__$1 = (function (){var statearr_21677 = state_21661;
(statearr_21677[(10)] = inst_21533__$1);

return statearr_21677;
})();
if(cljs.core.truth_(inst_21534)){
var statearr_21678_21758 = state_21661__$1;
(statearr_21678_21758[(1)] = (5));

} else {
var statearr_21679_21759 = state_21661__$1;
(statearr_21679_21759[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (15))){
var inst_21542 = (state_21661[(13)]);
var inst_21543 = (state_21661[(14)]);
var inst_21545 = (state_21661[(15)]);
var inst_21544 = (state_21661[(17)]);
var inst_21558 = (state_21661[(2)]);
var inst_21559 = (inst_21545 + (1));
var tmp21673 = inst_21542;
var tmp21674 = inst_21543;
var tmp21675 = inst_21544;
var inst_21542__$1 = tmp21673;
var inst_21543__$1 = tmp21674;
var inst_21544__$1 = tmp21675;
var inst_21545__$1 = inst_21559;
var state_21661__$1 = (function (){var statearr_21680 = state_21661;
(statearr_21680[(13)] = inst_21542__$1);

(statearr_21680[(14)] = inst_21543__$1);

(statearr_21680[(18)] = inst_21558);

(statearr_21680[(15)] = inst_21545__$1);

(statearr_21680[(17)] = inst_21544__$1);

return statearr_21680;
})();
var statearr_21681_21760 = state_21661__$1;
(statearr_21681_21760[(2)] = null);

(statearr_21681_21760[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (21))){
var inst_21583 = (state_21661[(2)]);
var state_21661__$1 = state_21661;
var statearr_21685_21761 = state_21661__$1;
(statearr_21685_21761[(2)] = inst_21583);

(statearr_21685_21761[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (31))){
var inst_21609 = (state_21661[(12)]);
var inst_21613 = done.call(null,null);
var inst_21614 = cljs.core.async.untap_STAR_.call(null,m,inst_21609);
var state_21661__$1 = (function (){var statearr_21686 = state_21661;
(statearr_21686[(19)] = inst_21613);

return statearr_21686;
})();
var statearr_21687_21762 = state_21661__$1;
(statearr_21687_21762[(2)] = inst_21614);

(statearr_21687_21762[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (32))){
var inst_21602 = (state_21661[(9)]);
var inst_21603 = (state_21661[(20)]);
var inst_21604 = (state_21661[(11)]);
var inst_21601 = (state_21661[(21)]);
var inst_21616 = (state_21661[(2)]);
var inst_21617 = (inst_21604 + (1));
var tmp21682 = inst_21602;
var tmp21683 = inst_21603;
var tmp21684 = inst_21601;
var inst_21601__$1 = tmp21684;
var inst_21602__$1 = tmp21682;
var inst_21603__$1 = tmp21683;
var inst_21604__$1 = inst_21617;
var state_21661__$1 = (function (){var statearr_21688 = state_21661;
(statearr_21688[(9)] = inst_21602__$1);

(statearr_21688[(20)] = inst_21603__$1);

(statearr_21688[(11)] = inst_21604__$1);

(statearr_21688[(22)] = inst_21616);

(statearr_21688[(21)] = inst_21601__$1);

return statearr_21688;
})();
var statearr_21689_21763 = state_21661__$1;
(statearr_21689_21763[(2)] = null);

(statearr_21689_21763[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (40))){
var inst_21629 = (state_21661[(23)]);
var inst_21633 = done.call(null,null);
var inst_21634 = cljs.core.async.untap_STAR_.call(null,m,inst_21629);
var state_21661__$1 = (function (){var statearr_21690 = state_21661;
(statearr_21690[(24)] = inst_21633);

return statearr_21690;
})();
var statearr_21691_21764 = state_21661__$1;
(statearr_21691_21764[(2)] = inst_21634);

(statearr_21691_21764[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (33))){
var inst_21620 = (state_21661[(25)]);
var inst_21622 = cljs.core.chunked_seq_QMARK_.call(null,inst_21620);
var state_21661__$1 = state_21661;
if(inst_21622){
var statearr_21692_21765 = state_21661__$1;
(statearr_21692_21765[(1)] = (36));

} else {
var statearr_21693_21766 = state_21661__$1;
(statearr_21693_21766[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (13))){
var inst_21552 = (state_21661[(26)]);
var inst_21555 = cljs.core.async.close_BANG_.call(null,inst_21552);
var state_21661__$1 = state_21661;
var statearr_21694_21767 = state_21661__$1;
(statearr_21694_21767[(2)] = inst_21555);

(statearr_21694_21767[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (22))){
var inst_21573 = (state_21661[(8)]);
var inst_21576 = cljs.core.async.close_BANG_.call(null,inst_21573);
var state_21661__$1 = state_21661;
var statearr_21695_21768 = state_21661__$1;
(statearr_21695_21768[(2)] = inst_21576);

(statearr_21695_21768[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (36))){
var inst_21620 = (state_21661[(25)]);
var inst_21624 = cljs.core.chunk_first.call(null,inst_21620);
var inst_21625 = cljs.core.chunk_rest.call(null,inst_21620);
var inst_21626 = cljs.core.count.call(null,inst_21624);
var inst_21601 = inst_21625;
var inst_21602 = inst_21624;
var inst_21603 = inst_21626;
var inst_21604 = (0);
var state_21661__$1 = (function (){var statearr_21696 = state_21661;
(statearr_21696[(9)] = inst_21602);

(statearr_21696[(20)] = inst_21603);

(statearr_21696[(11)] = inst_21604);

(statearr_21696[(21)] = inst_21601);

return statearr_21696;
})();
var statearr_21697_21769 = state_21661__$1;
(statearr_21697_21769[(2)] = null);

(statearr_21697_21769[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (41))){
var inst_21620 = (state_21661[(25)]);
var inst_21636 = (state_21661[(2)]);
var inst_21637 = cljs.core.next.call(null,inst_21620);
var inst_21601 = inst_21637;
var inst_21602 = null;
var inst_21603 = (0);
var inst_21604 = (0);
var state_21661__$1 = (function (){var statearr_21698 = state_21661;
(statearr_21698[(27)] = inst_21636);

(statearr_21698[(9)] = inst_21602);

(statearr_21698[(20)] = inst_21603);

(statearr_21698[(11)] = inst_21604);

(statearr_21698[(21)] = inst_21601);

return statearr_21698;
})();
var statearr_21699_21770 = state_21661__$1;
(statearr_21699_21770[(2)] = null);

(statearr_21699_21770[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (43))){
var state_21661__$1 = state_21661;
var statearr_21700_21771 = state_21661__$1;
(statearr_21700_21771[(2)] = null);

(statearr_21700_21771[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (29))){
var inst_21645 = (state_21661[(2)]);
var state_21661__$1 = state_21661;
var statearr_21701_21772 = state_21661__$1;
(statearr_21701_21772[(2)] = inst_21645);

(statearr_21701_21772[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (44))){
var inst_21654 = (state_21661[(2)]);
var state_21661__$1 = (function (){var statearr_21702 = state_21661;
(statearr_21702[(28)] = inst_21654);

return statearr_21702;
})();
var statearr_21703_21773 = state_21661__$1;
(statearr_21703_21773[(2)] = null);

(statearr_21703_21773[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (6))){
var inst_21593 = (state_21661[(29)]);
var inst_21592 = cljs.core.deref.call(null,cs);
var inst_21593__$1 = cljs.core.keys.call(null,inst_21592);
var inst_21594 = cljs.core.count.call(null,inst_21593__$1);
var inst_21595 = cljs.core.reset_BANG_.call(null,dctr,inst_21594);
var inst_21600 = cljs.core.seq.call(null,inst_21593__$1);
var inst_21601 = inst_21600;
var inst_21602 = null;
var inst_21603 = (0);
var inst_21604 = (0);
var state_21661__$1 = (function (){var statearr_21704 = state_21661;
(statearr_21704[(9)] = inst_21602);

(statearr_21704[(20)] = inst_21603);

(statearr_21704[(11)] = inst_21604);

(statearr_21704[(30)] = inst_21595);

(statearr_21704[(29)] = inst_21593__$1);

(statearr_21704[(21)] = inst_21601);

return statearr_21704;
})();
var statearr_21705_21774 = state_21661__$1;
(statearr_21705_21774[(2)] = null);

(statearr_21705_21774[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (28))){
var inst_21620 = (state_21661[(25)]);
var inst_21601 = (state_21661[(21)]);
var inst_21620__$1 = cljs.core.seq.call(null,inst_21601);
var state_21661__$1 = (function (){var statearr_21706 = state_21661;
(statearr_21706[(25)] = inst_21620__$1);

return statearr_21706;
})();
if(inst_21620__$1){
var statearr_21707_21775 = state_21661__$1;
(statearr_21707_21775[(1)] = (33));

} else {
var statearr_21708_21776 = state_21661__$1;
(statearr_21708_21776[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (25))){
var inst_21603 = (state_21661[(20)]);
var inst_21604 = (state_21661[(11)]);
var inst_21606 = (inst_21604 < inst_21603);
var inst_21607 = inst_21606;
var state_21661__$1 = state_21661;
if(cljs.core.truth_(inst_21607)){
var statearr_21709_21777 = state_21661__$1;
(statearr_21709_21777[(1)] = (27));

} else {
var statearr_21710_21778 = state_21661__$1;
(statearr_21710_21778[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (34))){
var state_21661__$1 = state_21661;
var statearr_21711_21779 = state_21661__$1;
(statearr_21711_21779[(2)] = null);

(statearr_21711_21779[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (17))){
var state_21661__$1 = state_21661;
var statearr_21712_21780 = state_21661__$1;
(statearr_21712_21780[(2)] = null);

(statearr_21712_21780[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (3))){
var inst_21659 = (state_21661[(2)]);
var state_21661__$1 = state_21661;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21661__$1,inst_21659);
} else {
if((state_val_21662 === (12))){
var inst_21588 = (state_21661[(2)]);
var state_21661__$1 = state_21661;
var statearr_21713_21781 = state_21661__$1;
(statearr_21713_21781[(2)] = inst_21588);

(statearr_21713_21781[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (2))){
var state_21661__$1 = state_21661;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21661__$1,(4),ch);
} else {
if((state_val_21662 === (23))){
var state_21661__$1 = state_21661;
var statearr_21714_21782 = state_21661__$1;
(statearr_21714_21782[(2)] = null);

(statearr_21714_21782[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (35))){
var inst_21643 = (state_21661[(2)]);
var state_21661__$1 = state_21661;
var statearr_21715_21783 = state_21661__$1;
(statearr_21715_21783[(2)] = inst_21643);

(statearr_21715_21783[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (19))){
var inst_21562 = (state_21661[(7)]);
var inst_21566 = cljs.core.chunk_first.call(null,inst_21562);
var inst_21567 = cljs.core.chunk_rest.call(null,inst_21562);
var inst_21568 = cljs.core.count.call(null,inst_21566);
var inst_21542 = inst_21567;
var inst_21543 = inst_21566;
var inst_21544 = inst_21568;
var inst_21545 = (0);
var state_21661__$1 = (function (){var statearr_21716 = state_21661;
(statearr_21716[(13)] = inst_21542);

(statearr_21716[(14)] = inst_21543);

(statearr_21716[(15)] = inst_21545);

(statearr_21716[(17)] = inst_21544);

return statearr_21716;
})();
var statearr_21717_21784 = state_21661__$1;
(statearr_21717_21784[(2)] = null);

(statearr_21717_21784[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (11))){
var inst_21562 = (state_21661[(7)]);
var inst_21542 = (state_21661[(13)]);
var inst_21562__$1 = cljs.core.seq.call(null,inst_21542);
var state_21661__$1 = (function (){var statearr_21718 = state_21661;
(statearr_21718[(7)] = inst_21562__$1);

return statearr_21718;
})();
if(inst_21562__$1){
var statearr_21719_21785 = state_21661__$1;
(statearr_21719_21785[(1)] = (16));

} else {
var statearr_21720_21786 = state_21661__$1;
(statearr_21720_21786[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (9))){
var inst_21590 = (state_21661[(2)]);
var state_21661__$1 = state_21661;
var statearr_21721_21787 = state_21661__$1;
(statearr_21721_21787[(2)] = inst_21590);

(statearr_21721_21787[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (5))){
var inst_21540 = cljs.core.deref.call(null,cs);
var inst_21541 = cljs.core.seq.call(null,inst_21540);
var inst_21542 = inst_21541;
var inst_21543 = null;
var inst_21544 = (0);
var inst_21545 = (0);
var state_21661__$1 = (function (){var statearr_21722 = state_21661;
(statearr_21722[(13)] = inst_21542);

(statearr_21722[(14)] = inst_21543);

(statearr_21722[(15)] = inst_21545);

(statearr_21722[(17)] = inst_21544);

return statearr_21722;
})();
var statearr_21723_21788 = state_21661__$1;
(statearr_21723_21788[(2)] = null);

(statearr_21723_21788[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (14))){
var state_21661__$1 = state_21661;
var statearr_21724_21789 = state_21661__$1;
(statearr_21724_21789[(2)] = null);

(statearr_21724_21789[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (45))){
var inst_21651 = (state_21661[(2)]);
var state_21661__$1 = state_21661;
var statearr_21725_21790 = state_21661__$1;
(statearr_21725_21790[(2)] = inst_21651);

(statearr_21725_21790[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (26))){
var inst_21593 = (state_21661[(29)]);
var inst_21647 = (state_21661[(2)]);
var inst_21648 = cljs.core.seq.call(null,inst_21593);
var state_21661__$1 = (function (){var statearr_21726 = state_21661;
(statearr_21726[(31)] = inst_21647);

return statearr_21726;
})();
if(inst_21648){
var statearr_21727_21791 = state_21661__$1;
(statearr_21727_21791[(1)] = (42));

} else {
var statearr_21728_21792 = state_21661__$1;
(statearr_21728_21792[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (16))){
var inst_21562 = (state_21661[(7)]);
var inst_21564 = cljs.core.chunked_seq_QMARK_.call(null,inst_21562);
var state_21661__$1 = state_21661;
if(inst_21564){
var statearr_21729_21793 = state_21661__$1;
(statearr_21729_21793[(1)] = (19));

} else {
var statearr_21730_21794 = state_21661__$1;
(statearr_21730_21794[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (38))){
var inst_21640 = (state_21661[(2)]);
var state_21661__$1 = state_21661;
var statearr_21731_21795 = state_21661__$1;
(statearr_21731_21795[(2)] = inst_21640);

(statearr_21731_21795[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (30))){
var state_21661__$1 = state_21661;
var statearr_21732_21796 = state_21661__$1;
(statearr_21732_21796[(2)] = null);

(statearr_21732_21796[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (10))){
var inst_21543 = (state_21661[(14)]);
var inst_21545 = (state_21661[(15)]);
var inst_21551 = cljs.core._nth.call(null,inst_21543,inst_21545);
var inst_21552 = cljs.core.nth.call(null,inst_21551,(0),null);
var inst_21553 = cljs.core.nth.call(null,inst_21551,(1),null);
var state_21661__$1 = (function (){var statearr_21733 = state_21661;
(statearr_21733[(26)] = inst_21552);

return statearr_21733;
})();
if(cljs.core.truth_(inst_21553)){
var statearr_21734_21797 = state_21661__$1;
(statearr_21734_21797[(1)] = (13));

} else {
var statearr_21735_21798 = state_21661__$1;
(statearr_21735_21798[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (18))){
var inst_21586 = (state_21661[(2)]);
var state_21661__$1 = state_21661;
var statearr_21736_21799 = state_21661__$1;
(statearr_21736_21799[(2)] = inst_21586);

(statearr_21736_21799[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (42))){
var state_21661__$1 = state_21661;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21661__$1,(45),dchan);
} else {
if((state_val_21662 === (37))){
var inst_21620 = (state_21661[(25)]);
var inst_21629 = (state_21661[(23)]);
var inst_21533 = (state_21661[(10)]);
var inst_21629__$1 = cljs.core.first.call(null,inst_21620);
var inst_21630 = cljs.core.async.put_BANG_.call(null,inst_21629__$1,inst_21533,done);
var state_21661__$1 = (function (){var statearr_21737 = state_21661;
(statearr_21737[(23)] = inst_21629__$1);

return statearr_21737;
})();
if(cljs.core.truth_(inst_21630)){
var statearr_21738_21800 = state_21661__$1;
(statearr_21738_21800[(1)] = (39));

} else {
var statearr_21739_21801 = state_21661__$1;
(statearr_21739_21801[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21662 === (8))){
var inst_21545 = (state_21661[(15)]);
var inst_21544 = (state_21661[(17)]);
var inst_21547 = (inst_21545 < inst_21544);
var inst_21548 = inst_21547;
var state_21661__$1 = state_21661;
if(cljs.core.truth_(inst_21548)){
var statearr_21740_21802 = state_21661__$1;
(statearr_21740_21802[(1)] = (10));

} else {
var statearr_21741_21803 = state_21661__$1;
(statearr_21741_21803[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto___21749,cs,m,dchan,dctr,done))
;
return ((function (switch__20330__auto__,c__20442__auto___21749,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__20331__auto__ = null;
var cljs$core$async$mult_$_state_machine__20331__auto____0 = (function (){
var statearr_21745 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21745[(0)] = cljs$core$async$mult_$_state_machine__20331__auto__);

(statearr_21745[(1)] = (1));

return statearr_21745;
});
var cljs$core$async$mult_$_state_machine__20331__auto____1 = (function (state_21661){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_21661);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e21746){if((e21746 instanceof Object)){
var ex__20334__auto__ = e21746;
var statearr_21747_21804 = state_21661;
(statearr_21747_21804[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21661);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21746;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21805 = state_21661;
state_21661 = G__21805;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__20331__auto__ = function(state_21661){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__20331__auto____1.call(this,state_21661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__20331__auto____0;
cljs$core$async$mult_$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__20331__auto____1;
return cljs$core$async$mult_$_state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto___21749,cs,m,dchan,dctr,done))
})();
var state__20444__auto__ = (function (){var statearr_21748 = f__20443__auto__.call(null);
(statearr_21748[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto___21749);

return statearr_21748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto___21749,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args21806 = [];
var len__19333__auto___21809 = arguments.length;
var i__19334__auto___21810 = (0);
while(true){
if((i__19334__auto___21810 < len__19333__auto___21809)){
args21806.push((arguments[i__19334__auto___21810]));

var G__21811 = (i__19334__auto___21810 + (1));
i__19334__auto___21810 = G__21811;
continue;
} else {
}
break;
}

var G__21808 = args21806.length;
switch (G__21808) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21806.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__18930__auto__ = (((m == null))?null:m);
var m__18931__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__18930__auto__)]);
if(!((m__18931__auto__ == null))){
return m__18931__auto__.call(null,m,ch);
} else {
var m__18931__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__18931__auto____$1 == null))){
return m__18931__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__18930__auto__ = (((m == null))?null:m);
var m__18931__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__18930__auto__)]);
if(!((m__18931__auto__ == null))){
return m__18931__auto__.call(null,m,ch);
} else {
var m__18931__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__18931__auto____$1 == null))){
return m__18931__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__18930__auto__ = (((m == null))?null:m);
var m__18931__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__18930__auto__)]);
if(!((m__18931__auto__ == null))){
return m__18931__auto__.call(null,m);
} else {
var m__18931__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__18931__auto____$1 == null))){
return m__18931__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__18930__auto__ = (((m == null))?null:m);
var m__18931__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__18930__auto__)]);
if(!((m__18931__auto__ == null))){
return m__18931__auto__.call(null,m,state_map);
} else {
var m__18931__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__18931__auto____$1 == null))){
return m__18931__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__18930__auto__ = (((m == null))?null:m);
var m__18931__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__18930__auto__)]);
if(!((m__18931__auto__ == null))){
return m__18931__auto__.call(null,m,mode);
} else {
var m__18931__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__18931__auto____$1 == null))){
return m__18931__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__19340__auto__ = [];
var len__19333__auto___21823 = arguments.length;
var i__19334__auto___21824 = (0);
while(true){
if((i__19334__auto___21824 < len__19333__auto___21823)){
args__19340__auto__.push((arguments[i__19334__auto___21824]));

var G__21825 = (i__19334__auto___21824 + (1));
i__19334__auto___21824 = G__21825;
continue;
} else {
}
break;
}

var argseq__19341__auto__ = ((((3) < args__19340__auto__.length))?(new cljs.core.IndexedSeq(args__19340__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__19341__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__21817){
var map__21818 = p__21817;
var map__21818__$1 = ((((!((map__21818 == null)))?((((map__21818.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21818.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21818):map__21818);
var opts = map__21818__$1;
var statearr_21820_21826 = state;
(statearr_21820_21826[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__21818,map__21818__$1,opts){
return (function (val){
var statearr_21821_21827 = state;
(statearr_21821_21827[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__21818,map__21818__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_21822_21828 = state;
(statearr_21822_21828[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq21813){
var G__21814 = cljs.core.first.call(null,seq21813);
var seq21813__$1 = cljs.core.next.call(null,seq21813);
var G__21815 = cljs.core.first.call(null,seq21813__$1);
var seq21813__$2 = cljs.core.next.call(null,seq21813__$1);
var G__21816 = cljs.core.first.call(null,seq21813__$2);
var seq21813__$3 = cljs.core.next.call(null,seq21813__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21814,G__21815,G__21816,seq21813__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async21992 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21992 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta21993){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta21993 = meta21993;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21992.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_21994,meta21993__$1){
var self__ = this;
var _21994__$1 = this;
return (new cljs.core.async.t_cljs$core$async21992(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta21993__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21992.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_21994){
var self__ = this;
var _21994__$1 = this;
return self__.meta21993;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21992.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async21992.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21992.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async21992.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21992.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21992.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21992.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21992.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21992.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta21993","meta21993",-1652188266,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21992.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21992.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21992";

cljs.core.async.t_cljs$core$async21992.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__18873__auto__,writer__18874__auto__,opt__18875__auto__){
return cljs.core._write.call(null,writer__18874__auto__,"cljs.core.async/t_cljs$core$async21992");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async21992 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async21992(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta21993){
return (new cljs.core.async.t_cljs$core$async21992(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta21993));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async21992(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20442__auto___22155 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto___22155,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto___22155,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_22092){
var state_val_22093 = (state_22092[(1)]);
if((state_val_22093 === (7))){
var inst_22010 = (state_22092[(2)]);
var state_22092__$1 = state_22092;
var statearr_22094_22156 = state_22092__$1;
(statearr_22094_22156[(2)] = inst_22010);

(statearr_22094_22156[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (20))){
var inst_22022 = (state_22092[(7)]);
var state_22092__$1 = state_22092;
var statearr_22095_22157 = state_22092__$1;
(statearr_22095_22157[(2)] = inst_22022);

(statearr_22095_22157[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (27))){
var state_22092__$1 = state_22092;
var statearr_22096_22158 = state_22092__$1;
(statearr_22096_22158[(2)] = null);

(statearr_22096_22158[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (1))){
var inst_21998 = (state_22092[(8)]);
var inst_21998__$1 = calc_state.call(null);
var inst_22000 = (inst_21998__$1 == null);
var inst_22001 = cljs.core.not.call(null,inst_22000);
var state_22092__$1 = (function (){var statearr_22097 = state_22092;
(statearr_22097[(8)] = inst_21998__$1);

return statearr_22097;
})();
if(inst_22001){
var statearr_22098_22159 = state_22092__$1;
(statearr_22098_22159[(1)] = (2));

} else {
var statearr_22099_22160 = state_22092__$1;
(statearr_22099_22160[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (24))){
var inst_22066 = (state_22092[(9)]);
var inst_22052 = (state_22092[(10)]);
var inst_22045 = (state_22092[(11)]);
var inst_22066__$1 = inst_22045.call(null,inst_22052);
var state_22092__$1 = (function (){var statearr_22100 = state_22092;
(statearr_22100[(9)] = inst_22066__$1);

return statearr_22100;
})();
if(cljs.core.truth_(inst_22066__$1)){
var statearr_22101_22161 = state_22092__$1;
(statearr_22101_22161[(1)] = (29));

} else {
var statearr_22102_22162 = state_22092__$1;
(statearr_22102_22162[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (4))){
var inst_22013 = (state_22092[(2)]);
var state_22092__$1 = state_22092;
if(cljs.core.truth_(inst_22013)){
var statearr_22103_22163 = state_22092__$1;
(statearr_22103_22163[(1)] = (8));

} else {
var statearr_22104_22164 = state_22092__$1;
(statearr_22104_22164[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (15))){
var inst_22039 = (state_22092[(2)]);
var state_22092__$1 = state_22092;
if(cljs.core.truth_(inst_22039)){
var statearr_22105_22165 = state_22092__$1;
(statearr_22105_22165[(1)] = (19));

} else {
var statearr_22106_22166 = state_22092__$1;
(statearr_22106_22166[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (21))){
var inst_22044 = (state_22092[(12)]);
var inst_22044__$1 = (state_22092[(2)]);
var inst_22045 = cljs.core.get.call(null,inst_22044__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_22046 = cljs.core.get.call(null,inst_22044__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_22047 = cljs.core.get.call(null,inst_22044__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_22092__$1 = (function (){var statearr_22107 = state_22092;
(statearr_22107[(13)] = inst_22046);

(statearr_22107[(12)] = inst_22044__$1);

(statearr_22107[(11)] = inst_22045);

return statearr_22107;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_22092__$1,(22),inst_22047);
} else {
if((state_val_22093 === (31))){
var inst_22074 = (state_22092[(2)]);
var state_22092__$1 = state_22092;
if(cljs.core.truth_(inst_22074)){
var statearr_22108_22167 = state_22092__$1;
(statearr_22108_22167[(1)] = (32));

} else {
var statearr_22109_22168 = state_22092__$1;
(statearr_22109_22168[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (32))){
var inst_22051 = (state_22092[(14)]);
var state_22092__$1 = state_22092;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22092__$1,(35),out,inst_22051);
} else {
if((state_val_22093 === (33))){
var inst_22044 = (state_22092[(12)]);
var inst_22022 = inst_22044;
var state_22092__$1 = (function (){var statearr_22110 = state_22092;
(statearr_22110[(7)] = inst_22022);

return statearr_22110;
})();
var statearr_22111_22169 = state_22092__$1;
(statearr_22111_22169[(2)] = null);

(statearr_22111_22169[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (13))){
var inst_22022 = (state_22092[(7)]);
var inst_22029 = inst_22022.cljs$lang$protocol_mask$partition0$;
var inst_22030 = (inst_22029 & (64));
var inst_22031 = inst_22022.cljs$core$ISeq$;
var inst_22032 = (inst_22030) || (inst_22031);
var state_22092__$1 = state_22092;
if(cljs.core.truth_(inst_22032)){
var statearr_22112_22170 = state_22092__$1;
(statearr_22112_22170[(1)] = (16));

} else {
var statearr_22113_22171 = state_22092__$1;
(statearr_22113_22171[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (22))){
var inst_22052 = (state_22092[(10)]);
var inst_22051 = (state_22092[(14)]);
var inst_22050 = (state_22092[(2)]);
var inst_22051__$1 = cljs.core.nth.call(null,inst_22050,(0),null);
var inst_22052__$1 = cljs.core.nth.call(null,inst_22050,(1),null);
var inst_22053 = (inst_22051__$1 == null);
var inst_22054 = cljs.core._EQ_.call(null,inst_22052__$1,change);
var inst_22055 = (inst_22053) || (inst_22054);
var state_22092__$1 = (function (){var statearr_22114 = state_22092;
(statearr_22114[(10)] = inst_22052__$1);

(statearr_22114[(14)] = inst_22051__$1);

return statearr_22114;
})();
if(cljs.core.truth_(inst_22055)){
var statearr_22115_22172 = state_22092__$1;
(statearr_22115_22172[(1)] = (23));

} else {
var statearr_22116_22173 = state_22092__$1;
(statearr_22116_22173[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (36))){
var inst_22044 = (state_22092[(12)]);
var inst_22022 = inst_22044;
var state_22092__$1 = (function (){var statearr_22117 = state_22092;
(statearr_22117[(7)] = inst_22022);

return statearr_22117;
})();
var statearr_22118_22174 = state_22092__$1;
(statearr_22118_22174[(2)] = null);

(statearr_22118_22174[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (29))){
var inst_22066 = (state_22092[(9)]);
var state_22092__$1 = state_22092;
var statearr_22119_22175 = state_22092__$1;
(statearr_22119_22175[(2)] = inst_22066);

(statearr_22119_22175[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (6))){
var state_22092__$1 = state_22092;
var statearr_22120_22176 = state_22092__$1;
(statearr_22120_22176[(2)] = false);

(statearr_22120_22176[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (28))){
var inst_22062 = (state_22092[(2)]);
var inst_22063 = calc_state.call(null);
var inst_22022 = inst_22063;
var state_22092__$1 = (function (){var statearr_22121 = state_22092;
(statearr_22121[(15)] = inst_22062);

(statearr_22121[(7)] = inst_22022);

return statearr_22121;
})();
var statearr_22122_22177 = state_22092__$1;
(statearr_22122_22177[(2)] = null);

(statearr_22122_22177[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (25))){
var inst_22088 = (state_22092[(2)]);
var state_22092__$1 = state_22092;
var statearr_22123_22178 = state_22092__$1;
(statearr_22123_22178[(2)] = inst_22088);

(statearr_22123_22178[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (34))){
var inst_22086 = (state_22092[(2)]);
var state_22092__$1 = state_22092;
var statearr_22124_22179 = state_22092__$1;
(statearr_22124_22179[(2)] = inst_22086);

(statearr_22124_22179[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (17))){
var state_22092__$1 = state_22092;
var statearr_22125_22180 = state_22092__$1;
(statearr_22125_22180[(2)] = false);

(statearr_22125_22180[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (3))){
var state_22092__$1 = state_22092;
var statearr_22126_22181 = state_22092__$1;
(statearr_22126_22181[(2)] = false);

(statearr_22126_22181[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (12))){
var inst_22090 = (state_22092[(2)]);
var state_22092__$1 = state_22092;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22092__$1,inst_22090);
} else {
if((state_val_22093 === (2))){
var inst_21998 = (state_22092[(8)]);
var inst_22003 = inst_21998.cljs$lang$protocol_mask$partition0$;
var inst_22004 = (inst_22003 & (64));
var inst_22005 = inst_21998.cljs$core$ISeq$;
var inst_22006 = (inst_22004) || (inst_22005);
var state_22092__$1 = state_22092;
if(cljs.core.truth_(inst_22006)){
var statearr_22127_22182 = state_22092__$1;
(statearr_22127_22182[(1)] = (5));

} else {
var statearr_22128_22183 = state_22092__$1;
(statearr_22128_22183[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (23))){
var inst_22051 = (state_22092[(14)]);
var inst_22057 = (inst_22051 == null);
var state_22092__$1 = state_22092;
if(cljs.core.truth_(inst_22057)){
var statearr_22129_22184 = state_22092__$1;
(statearr_22129_22184[(1)] = (26));

} else {
var statearr_22130_22185 = state_22092__$1;
(statearr_22130_22185[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (35))){
var inst_22077 = (state_22092[(2)]);
var state_22092__$1 = state_22092;
if(cljs.core.truth_(inst_22077)){
var statearr_22131_22186 = state_22092__$1;
(statearr_22131_22186[(1)] = (36));

} else {
var statearr_22132_22187 = state_22092__$1;
(statearr_22132_22187[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (19))){
var inst_22022 = (state_22092[(7)]);
var inst_22041 = cljs.core.apply.call(null,cljs.core.hash_map,inst_22022);
var state_22092__$1 = state_22092;
var statearr_22133_22188 = state_22092__$1;
(statearr_22133_22188[(2)] = inst_22041);

(statearr_22133_22188[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (11))){
var inst_22022 = (state_22092[(7)]);
var inst_22026 = (inst_22022 == null);
var inst_22027 = cljs.core.not.call(null,inst_22026);
var state_22092__$1 = state_22092;
if(inst_22027){
var statearr_22134_22189 = state_22092__$1;
(statearr_22134_22189[(1)] = (13));

} else {
var statearr_22135_22190 = state_22092__$1;
(statearr_22135_22190[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (9))){
var inst_21998 = (state_22092[(8)]);
var state_22092__$1 = state_22092;
var statearr_22136_22191 = state_22092__$1;
(statearr_22136_22191[(2)] = inst_21998);

(statearr_22136_22191[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (5))){
var state_22092__$1 = state_22092;
var statearr_22137_22192 = state_22092__$1;
(statearr_22137_22192[(2)] = true);

(statearr_22137_22192[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (14))){
var state_22092__$1 = state_22092;
var statearr_22138_22193 = state_22092__$1;
(statearr_22138_22193[(2)] = false);

(statearr_22138_22193[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (26))){
var inst_22052 = (state_22092[(10)]);
var inst_22059 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_22052);
var state_22092__$1 = state_22092;
var statearr_22139_22194 = state_22092__$1;
(statearr_22139_22194[(2)] = inst_22059);

(statearr_22139_22194[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (16))){
var state_22092__$1 = state_22092;
var statearr_22140_22195 = state_22092__$1;
(statearr_22140_22195[(2)] = true);

(statearr_22140_22195[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (38))){
var inst_22082 = (state_22092[(2)]);
var state_22092__$1 = state_22092;
var statearr_22141_22196 = state_22092__$1;
(statearr_22141_22196[(2)] = inst_22082);

(statearr_22141_22196[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (30))){
var inst_22052 = (state_22092[(10)]);
var inst_22046 = (state_22092[(13)]);
var inst_22045 = (state_22092[(11)]);
var inst_22069 = cljs.core.empty_QMARK_.call(null,inst_22045);
var inst_22070 = inst_22046.call(null,inst_22052);
var inst_22071 = cljs.core.not.call(null,inst_22070);
var inst_22072 = (inst_22069) && (inst_22071);
var state_22092__$1 = state_22092;
var statearr_22142_22197 = state_22092__$1;
(statearr_22142_22197[(2)] = inst_22072);

(statearr_22142_22197[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (10))){
var inst_21998 = (state_22092[(8)]);
var inst_22018 = (state_22092[(2)]);
var inst_22019 = cljs.core.get.call(null,inst_22018,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_22020 = cljs.core.get.call(null,inst_22018,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_22021 = cljs.core.get.call(null,inst_22018,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_22022 = inst_21998;
var state_22092__$1 = (function (){var statearr_22143 = state_22092;
(statearr_22143[(16)] = inst_22019);

(statearr_22143[(7)] = inst_22022);

(statearr_22143[(17)] = inst_22020);

(statearr_22143[(18)] = inst_22021);

return statearr_22143;
})();
var statearr_22144_22198 = state_22092__$1;
(statearr_22144_22198[(2)] = null);

(statearr_22144_22198[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (18))){
var inst_22036 = (state_22092[(2)]);
var state_22092__$1 = state_22092;
var statearr_22145_22199 = state_22092__$1;
(statearr_22145_22199[(2)] = inst_22036);

(statearr_22145_22199[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (37))){
var state_22092__$1 = state_22092;
var statearr_22146_22200 = state_22092__$1;
(statearr_22146_22200[(2)] = null);

(statearr_22146_22200[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22093 === (8))){
var inst_21998 = (state_22092[(8)]);
var inst_22015 = cljs.core.apply.call(null,cljs.core.hash_map,inst_21998);
var state_22092__$1 = state_22092;
var statearr_22147_22201 = state_22092__$1;
(statearr_22147_22201[(2)] = inst_22015);

(statearr_22147_22201[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto___22155,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__20330__auto__,c__20442__auto___22155,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__20331__auto__ = null;
var cljs$core$async$mix_$_state_machine__20331__auto____0 = (function (){
var statearr_22151 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22151[(0)] = cljs$core$async$mix_$_state_machine__20331__auto__);

(statearr_22151[(1)] = (1));

return statearr_22151;
});
var cljs$core$async$mix_$_state_machine__20331__auto____1 = (function (state_22092){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_22092);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e22152){if((e22152 instanceof Object)){
var ex__20334__auto__ = e22152;
var statearr_22153_22202 = state_22092;
(statearr_22153_22202[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22092);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22152;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22203 = state_22092;
state_22092 = G__22203;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__20331__auto__ = function(state_22092){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__20331__auto____1.call(this,state_22092);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__20331__auto____0;
cljs$core$async$mix_$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__20331__auto____1;
return cljs$core$async$mix_$_state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto___22155,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__20444__auto__ = (function (){var statearr_22154 = f__20443__auto__.call(null);
(statearr_22154[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto___22155);

return statearr_22154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto___22155,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__18930__auto__ = (((p == null))?null:p);
var m__18931__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__18930__auto__)]);
if(!((m__18931__auto__ == null))){
return m__18931__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__18931__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__18931__auto____$1 == null))){
return m__18931__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__18930__auto__ = (((p == null))?null:p);
var m__18931__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__18930__auto__)]);
if(!((m__18931__auto__ == null))){
return m__18931__auto__.call(null,p,v,ch);
} else {
var m__18931__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__18931__auto____$1 == null))){
return m__18931__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args22204 = [];
var len__19333__auto___22207 = arguments.length;
var i__19334__auto___22208 = (0);
while(true){
if((i__19334__auto___22208 < len__19333__auto___22207)){
args22204.push((arguments[i__19334__auto___22208]));

var G__22209 = (i__19334__auto___22208 + (1));
i__19334__auto___22208 = G__22209;
continue;
} else {
}
break;
}

var G__22206 = args22204.length;
switch (G__22206) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22204.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__18930__auto__ = (((p == null))?null:p);
var m__18931__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__18930__auto__)]);
if(!((m__18931__auto__ == null))){
return m__18931__auto__.call(null,p);
} else {
var m__18931__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__18931__auto____$1 == null))){
return m__18931__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__18930__auto__ = (((p == null))?null:p);
var m__18931__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__18930__auto__)]);
if(!((m__18931__auto__ == null))){
return m__18931__auto__.call(null,p,v);
} else {
var m__18931__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__18931__auto____$1 == null))){
return m__18931__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args22212 = [];
var len__19333__auto___22337 = arguments.length;
var i__19334__auto___22338 = (0);
while(true){
if((i__19334__auto___22338 < len__19333__auto___22337)){
args22212.push((arguments[i__19334__auto___22338]));

var G__22339 = (i__19334__auto___22338 + (1));
i__19334__auto___22338 = G__22339;
continue;
} else {
}
break;
}

var G__22214 = args22212.length;
switch (G__22214) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22212.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__18275__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__18275__auto__,mults){
return (function (p1__22211_SHARP_){
if(cljs.core.truth_(p1__22211_SHARP_.call(null,topic))){
return p1__22211_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__22211_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__18275__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async22215 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22215 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta22216){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta22216 = meta22216;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22215.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_22217,meta22216__$1){
var self__ = this;
var _22217__$1 = this;
return (new cljs.core.async.t_cljs$core$async22215(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta22216__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22215.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_22217){
var self__ = this;
var _22217__$1 = this;
return self__.meta22216;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22215.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async22215.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22215.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async22215.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22215.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22215.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22215.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22215.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta22216","meta22216",1598317807,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22215.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22215.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22215";

cljs.core.async.t_cljs$core$async22215.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__18873__auto__,writer__18874__auto__,opt__18875__auto__){
return cljs.core._write.call(null,writer__18874__auto__,"cljs.core.async/t_cljs$core$async22215");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async22215 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async22215(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta22216){
return (new cljs.core.async.t_cljs$core$async22215(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta22216));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async22215(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20442__auto___22341 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto___22341,mults,ensure_mult,p){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto___22341,mults,ensure_mult,p){
return (function (state_22289){
var state_val_22290 = (state_22289[(1)]);
if((state_val_22290 === (7))){
var inst_22285 = (state_22289[(2)]);
var state_22289__$1 = state_22289;
var statearr_22291_22342 = state_22289__$1;
(statearr_22291_22342[(2)] = inst_22285);

(statearr_22291_22342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (20))){
var state_22289__$1 = state_22289;
var statearr_22292_22343 = state_22289__$1;
(statearr_22292_22343[(2)] = null);

(statearr_22292_22343[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (1))){
var state_22289__$1 = state_22289;
var statearr_22293_22344 = state_22289__$1;
(statearr_22293_22344[(2)] = null);

(statearr_22293_22344[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (24))){
var inst_22268 = (state_22289[(7)]);
var inst_22277 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_22268);
var state_22289__$1 = state_22289;
var statearr_22294_22345 = state_22289__$1;
(statearr_22294_22345[(2)] = inst_22277);

(statearr_22294_22345[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (4))){
var inst_22220 = (state_22289[(8)]);
var inst_22220__$1 = (state_22289[(2)]);
var inst_22221 = (inst_22220__$1 == null);
var state_22289__$1 = (function (){var statearr_22295 = state_22289;
(statearr_22295[(8)] = inst_22220__$1);

return statearr_22295;
})();
if(cljs.core.truth_(inst_22221)){
var statearr_22296_22346 = state_22289__$1;
(statearr_22296_22346[(1)] = (5));

} else {
var statearr_22297_22347 = state_22289__$1;
(statearr_22297_22347[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (15))){
var inst_22262 = (state_22289[(2)]);
var state_22289__$1 = state_22289;
var statearr_22298_22348 = state_22289__$1;
(statearr_22298_22348[(2)] = inst_22262);

(statearr_22298_22348[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (21))){
var inst_22282 = (state_22289[(2)]);
var state_22289__$1 = (function (){var statearr_22299 = state_22289;
(statearr_22299[(9)] = inst_22282);

return statearr_22299;
})();
var statearr_22300_22349 = state_22289__$1;
(statearr_22300_22349[(2)] = null);

(statearr_22300_22349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (13))){
var inst_22244 = (state_22289[(10)]);
var inst_22246 = cljs.core.chunked_seq_QMARK_.call(null,inst_22244);
var state_22289__$1 = state_22289;
if(inst_22246){
var statearr_22301_22350 = state_22289__$1;
(statearr_22301_22350[(1)] = (16));

} else {
var statearr_22302_22351 = state_22289__$1;
(statearr_22302_22351[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (22))){
var inst_22274 = (state_22289[(2)]);
var state_22289__$1 = state_22289;
if(cljs.core.truth_(inst_22274)){
var statearr_22303_22352 = state_22289__$1;
(statearr_22303_22352[(1)] = (23));

} else {
var statearr_22304_22353 = state_22289__$1;
(statearr_22304_22353[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (6))){
var inst_22268 = (state_22289[(7)]);
var inst_22270 = (state_22289[(11)]);
var inst_22220 = (state_22289[(8)]);
var inst_22268__$1 = topic_fn.call(null,inst_22220);
var inst_22269 = cljs.core.deref.call(null,mults);
var inst_22270__$1 = cljs.core.get.call(null,inst_22269,inst_22268__$1);
var state_22289__$1 = (function (){var statearr_22305 = state_22289;
(statearr_22305[(7)] = inst_22268__$1);

(statearr_22305[(11)] = inst_22270__$1);

return statearr_22305;
})();
if(cljs.core.truth_(inst_22270__$1)){
var statearr_22306_22354 = state_22289__$1;
(statearr_22306_22354[(1)] = (19));

} else {
var statearr_22307_22355 = state_22289__$1;
(statearr_22307_22355[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (25))){
var inst_22279 = (state_22289[(2)]);
var state_22289__$1 = state_22289;
var statearr_22308_22356 = state_22289__$1;
(statearr_22308_22356[(2)] = inst_22279);

(statearr_22308_22356[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (17))){
var inst_22244 = (state_22289[(10)]);
var inst_22253 = cljs.core.first.call(null,inst_22244);
var inst_22254 = cljs.core.async.muxch_STAR_.call(null,inst_22253);
var inst_22255 = cljs.core.async.close_BANG_.call(null,inst_22254);
var inst_22256 = cljs.core.next.call(null,inst_22244);
var inst_22230 = inst_22256;
var inst_22231 = null;
var inst_22232 = (0);
var inst_22233 = (0);
var state_22289__$1 = (function (){var statearr_22309 = state_22289;
(statearr_22309[(12)] = inst_22230);

(statearr_22309[(13)] = inst_22232);

(statearr_22309[(14)] = inst_22231);

(statearr_22309[(15)] = inst_22233);

(statearr_22309[(16)] = inst_22255);

return statearr_22309;
})();
var statearr_22310_22357 = state_22289__$1;
(statearr_22310_22357[(2)] = null);

(statearr_22310_22357[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (3))){
var inst_22287 = (state_22289[(2)]);
var state_22289__$1 = state_22289;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22289__$1,inst_22287);
} else {
if((state_val_22290 === (12))){
var inst_22264 = (state_22289[(2)]);
var state_22289__$1 = state_22289;
var statearr_22311_22358 = state_22289__$1;
(statearr_22311_22358[(2)] = inst_22264);

(statearr_22311_22358[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (2))){
var state_22289__$1 = state_22289;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22289__$1,(4),ch);
} else {
if((state_val_22290 === (23))){
var state_22289__$1 = state_22289;
var statearr_22312_22359 = state_22289__$1;
(statearr_22312_22359[(2)] = null);

(statearr_22312_22359[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (19))){
var inst_22270 = (state_22289[(11)]);
var inst_22220 = (state_22289[(8)]);
var inst_22272 = cljs.core.async.muxch_STAR_.call(null,inst_22270);
var state_22289__$1 = state_22289;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22289__$1,(22),inst_22272,inst_22220);
} else {
if((state_val_22290 === (11))){
var inst_22230 = (state_22289[(12)]);
var inst_22244 = (state_22289[(10)]);
var inst_22244__$1 = cljs.core.seq.call(null,inst_22230);
var state_22289__$1 = (function (){var statearr_22313 = state_22289;
(statearr_22313[(10)] = inst_22244__$1);

return statearr_22313;
})();
if(inst_22244__$1){
var statearr_22314_22360 = state_22289__$1;
(statearr_22314_22360[(1)] = (13));

} else {
var statearr_22315_22361 = state_22289__$1;
(statearr_22315_22361[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (9))){
var inst_22266 = (state_22289[(2)]);
var state_22289__$1 = state_22289;
var statearr_22316_22362 = state_22289__$1;
(statearr_22316_22362[(2)] = inst_22266);

(statearr_22316_22362[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (5))){
var inst_22227 = cljs.core.deref.call(null,mults);
var inst_22228 = cljs.core.vals.call(null,inst_22227);
var inst_22229 = cljs.core.seq.call(null,inst_22228);
var inst_22230 = inst_22229;
var inst_22231 = null;
var inst_22232 = (0);
var inst_22233 = (0);
var state_22289__$1 = (function (){var statearr_22317 = state_22289;
(statearr_22317[(12)] = inst_22230);

(statearr_22317[(13)] = inst_22232);

(statearr_22317[(14)] = inst_22231);

(statearr_22317[(15)] = inst_22233);

return statearr_22317;
})();
var statearr_22318_22363 = state_22289__$1;
(statearr_22318_22363[(2)] = null);

(statearr_22318_22363[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (14))){
var state_22289__$1 = state_22289;
var statearr_22322_22364 = state_22289__$1;
(statearr_22322_22364[(2)] = null);

(statearr_22322_22364[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (16))){
var inst_22244 = (state_22289[(10)]);
var inst_22248 = cljs.core.chunk_first.call(null,inst_22244);
var inst_22249 = cljs.core.chunk_rest.call(null,inst_22244);
var inst_22250 = cljs.core.count.call(null,inst_22248);
var inst_22230 = inst_22249;
var inst_22231 = inst_22248;
var inst_22232 = inst_22250;
var inst_22233 = (0);
var state_22289__$1 = (function (){var statearr_22323 = state_22289;
(statearr_22323[(12)] = inst_22230);

(statearr_22323[(13)] = inst_22232);

(statearr_22323[(14)] = inst_22231);

(statearr_22323[(15)] = inst_22233);

return statearr_22323;
})();
var statearr_22324_22365 = state_22289__$1;
(statearr_22324_22365[(2)] = null);

(statearr_22324_22365[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (10))){
var inst_22230 = (state_22289[(12)]);
var inst_22232 = (state_22289[(13)]);
var inst_22231 = (state_22289[(14)]);
var inst_22233 = (state_22289[(15)]);
var inst_22238 = cljs.core._nth.call(null,inst_22231,inst_22233);
var inst_22239 = cljs.core.async.muxch_STAR_.call(null,inst_22238);
var inst_22240 = cljs.core.async.close_BANG_.call(null,inst_22239);
var inst_22241 = (inst_22233 + (1));
var tmp22319 = inst_22230;
var tmp22320 = inst_22232;
var tmp22321 = inst_22231;
var inst_22230__$1 = tmp22319;
var inst_22231__$1 = tmp22321;
var inst_22232__$1 = tmp22320;
var inst_22233__$1 = inst_22241;
var state_22289__$1 = (function (){var statearr_22325 = state_22289;
(statearr_22325[(12)] = inst_22230__$1);

(statearr_22325[(13)] = inst_22232__$1);

(statearr_22325[(14)] = inst_22231__$1);

(statearr_22325[(15)] = inst_22233__$1);

(statearr_22325[(17)] = inst_22240);

return statearr_22325;
})();
var statearr_22326_22366 = state_22289__$1;
(statearr_22326_22366[(2)] = null);

(statearr_22326_22366[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (18))){
var inst_22259 = (state_22289[(2)]);
var state_22289__$1 = state_22289;
var statearr_22327_22367 = state_22289__$1;
(statearr_22327_22367[(2)] = inst_22259);

(statearr_22327_22367[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22290 === (8))){
var inst_22232 = (state_22289[(13)]);
var inst_22233 = (state_22289[(15)]);
var inst_22235 = (inst_22233 < inst_22232);
var inst_22236 = inst_22235;
var state_22289__$1 = state_22289;
if(cljs.core.truth_(inst_22236)){
var statearr_22328_22368 = state_22289__$1;
(statearr_22328_22368[(1)] = (10));

} else {
var statearr_22329_22369 = state_22289__$1;
(statearr_22329_22369[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto___22341,mults,ensure_mult,p))
;
return ((function (switch__20330__auto__,c__20442__auto___22341,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__20331__auto__ = null;
var cljs$core$async$state_machine__20331__auto____0 = (function (){
var statearr_22333 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22333[(0)] = cljs$core$async$state_machine__20331__auto__);

(statearr_22333[(1)] = (1));

return statearr_22333;
});
var cljs$core$async$state_machine__20331__auto____1 = (function (state_22289){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_22289);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e22334){if((e22334 instanceof Object)){
var ex__20334__auto__ = e22334;
var statearr_22335_22370 = state_22289;
(statearr_22335_22370[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22289);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22334;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22371 = state_22289;
state_22289 = G__22371;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$state_machine__20331__auto__ = function(state_22289){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20331__auto____1.call(this,state_22289);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20331__auto____0;
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20331__auto____1;
return cljs$core$async$state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto___22341,mults,ensure_mult,p))
})();
var state__20444__auto__ = (function (){var statearr_22336 = f__20443__auto__.call(null);
(statearr_22336[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto___22341);

return statearr_22336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto___22341,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args22372 = [];
var len__19333__auto___22375 = arguments.length;
var i__19334__auto___22376 = (0);
while(true){
if((i__19334__auto___22376 < len__19333__auto___22375)){
args22372.push((arguments[i__19334__auto___22376]));

var G__22377 = (i__19334__auto___22376 + (1));
i__19334__auto___22376 = G__22377;
continue;
} else {
}
break;
}

var G__22374 = args22372.length;
switch (G__22374) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22372.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args22379 = [];
var len__19333__auto___22382 = arguments.length;
var i__19334__auto___22383 = (0);
while(true){
if((i__19334__auto___22383 < len__19333__auto___22382)){
args22379.push((arguments[i__19334__auto___22383]));

var G__22384 = (i__19334__auto___22383 + (1));
i__19334__auto___22383 = G__22384;
continue;
} else {
}
break;
}

var G__22381 = args22379.length;
switch (G__22381) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22379.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args22386 = [];
var len__19333__auto___22457 = arguments.length;
var i__19334__auto___22458 = (0);
while(true){
if((i__19334__auto___22458 < len__19333__auto___22457)){
args22386.push((arguments[i__19334__auto___22458]));

var G__22459 = (i__19334__auto___22458 + (1));
i__19334__auto___22458 = G__22459;
continue;
} else {
}
break;
}

var G__22388 = args22386.length;
switch (G__22388) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22386.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__20442__auto___22461 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto___22461,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto___22461,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_22427){
var state_val_22428 = (state_22427[(1)]);
if((state_val_22428 === (7))){
var state_22427__$1 = state_22427;
var statearr_22429_22462 = state_22427__$1;
(statearr_22429_22462[(2)] = null);

(statearr_22429_22462[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22428 === (1))){
var state_22427__$1 = state_22427;
var statearr_22430_22463 = state_22427__$1;
(statearr_22430_22463[(2)] = null);

(statearr_22430_22463[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22428 === (4))){
var inst_22391 = (state_22427[(7)]);
var inst_22393 = (inst_22391 < cnt);
var state_22427__$1 = state_22427;
if(cljs.core.truth_(inst_22393)){
var statearr_22431_22464 = state_22427__$1;
(statearr_22431_22464[(1)] = (6));

} else {
var statearr_22432_22465 = state_22427__$1;
(statearr_22432_22465[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22428 === (15))){
var inst_22423 = (state_22427[(2)]);
var state_22427__$1 = state_22427;
var statearr_22433_22466 = state_22427__$1;
(statearr_22433_22466[(2)] = inst_22423);

(statearr_22433_22466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22428 === (13))){
var inst_22416 = cljs.core.async.close_BANG_.call(null,out);
var state_22427__$1 = state_22427;
var statearr_22434_22467 = state_22427__$1;
(statearr_22434_22467[(2)] = inst_22416);

(statearr_22434_22467[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22428 === (6))){
var state_22427__$1 = state_22427;
var statearr_22435_22468 = state_22427__$1;
(statearr_22435_22468[(2)] = null);

(statearr_22435_22468[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22428 === (3))){
var inst_22425 = (state_22427[(2)]);
var state_22427__$1 = state_22427;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22427__$1,inst_22425);
} else {
if((state_val_22428 === (12))){
var inst_22413 = (state_22427[(8)]);
var inst_22413__$1 = (state_22427[(2)]);
var inst_22414 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_22413__$1);
var state_22427__$1 = (function (){var statearr_22436 = state_22427;
(statearr_22436[(8)] = inst_22413__$1);

return statearr_22436;
})();
if(cljs.core.truth_(inst_22414)){
var statearr_22437_22469 = state_22427__$1;
(statearr_22437_22469[(1)] = (13));

} else {
var statearr_22438_22470 = state_22427__$1;
(statearr_22438_22470[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22428 === (2))){
var inst_22390 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_22391 = (0);
var state_22427__$1 = (function (){var statearr_22439 = state_22427;
(statearr_22439[(7)] = inst_22391);

(statearr_22439[(9)] = inst_22390);

return statearr_22439;
})();
var statearr_22440_22471 = state_22427__$1;
(statearr_22440_22471[(2)] = null);

(statearr_22440_22471[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22428 === (11))){
var inst_22391 = (state_22427[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_22427,(10),Object,null,(9));
var inst_22400 = chs__$1.call(null,inst_22391);
var inst_22401 = done.call(null,inst_22391);
var inst_22402 = cljs.core.async.take_BANG_.call(null,inst_22400,inst_22401);
var state_22427__$1 = state_22427;
var statearr_22441_22472 = state_22427__$1;
(statearr_22441_22472[(2)] = inst_22402);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22427__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22428 === (9))){
var inst_22391 = (state_22427[(7)]);
var inst_22404 = (state_22427[(2)]);
var inst_22405 = (inst_22391 + (1));
var inst_22391__$1 = inst_22405;
var state_22427__$1 = (function (){var statearr_22442 = state_22427;
(statearr_22442[(7)] = inst_22391__$1);

(statearr_22442[(10)] = inst_22404);

return statearr_22442;
})();
var statearr_22443_22473 = state_22427__$1;
(statearr_22443_22473[(2)] = null);

(statearr_22443_22473[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22428 === (5))){
var inst_22411 = (state_22427[(2)]);
var state_22427__$1 = (function (){var statearr_22444 = state_22427;
(statearr_22444[(11)] = inst_22411);

return statearr_22444;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22427__$1,(12),dchan);
} else {
if((state_val_22428 === (14))){
var inst_22413 = (state_22427[(8)]);
var inst_22418 = cljs.core.apply.call(null,f,inst_22413);
var state_22427__$1 = state_22427;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22427__$1,(16),out,inst_22418);
} else {
if((state_val_22428 === (16))){
var inst_22420 = (state_22427[(2)]);
var state_22427__$1 = (function (){var statearr_22445 = state_22427;
(statearr_22445[(12)] = inst_22420);

return statearr_22445;
})();
var statearr_22446_22474 = state_22427__$1;
(statearr_22446_22474[(2)] = null);

(statearr_22446_22474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22428 === (10))){
var inst_22395 = (state_22427[(2)]);
var inst_22396 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_22427__$1 = (function (){var statearr_22447 = state_22427;
(statearr_22447[(13)] = inst_22395);

return statearr_22447;
})();
var statearr_22448_22475 = state_22427__$1;
(statearr_22448_22475[(2)] = inst_22396);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22427__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22428 === (8))){
var inst_22409 = (state_22427[(2)]);
var state_22427__$1 = state_22427;
var statearr_22449_22476 = state_22427__$1;
(statearr_22449_22476[(2)] = inst_22409);

(statearr_22449_22476[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto___22461,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__20330__auto__,c__20442__auto___22461,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__20331__auto__ = null;
var cljs$core$async$state_machine__20331__auto____0 = (function (){
var statearr_22453 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22453[(0)] = cljs$core$async$state_machine__20331__auto__);

(statearr_22453[(1)] = (1));

return statearr_22453;
});
var cljs$core$async$state_machine__20331__auto____1 = (function (state_22427){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_22427);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e22454){if((e22454 instanceof Object)){
var ex__20334__auto__ = e22454;
var statearr_22455_22477 = state_22427;
(statearr_22455_22477[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22427);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22454;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22478 = state_22427;
state_22427 = G__22478;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$state_machine__20331__auto__ = function(state_22427){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20331__auto____1.call(this,state_22427);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20331__auto____0;
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20331__auto____1;
return cljs$core$async$state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto___22461,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__20444__auto__ = (function (){var statearr_22456 = f__20443__auto__.call(null);
(statearr_22456[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto___22461);

return statearr_22456;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto___22461,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args22480 = [];
var len__19333__auto___22536 = arguments.length;
var i__19334__auto___22537 = (0);
while(true){
if((i__19334__auto___22537 < len__19333__auto___22536)){
args22480.push((arguments[i__19334__auto___22537]));

var G__22538 = (i__19334__auto___22537 + (1));
i__19334__auto___22537 = G__22538;
continue;
} else {
}
break;
}

var G__22482 = args22480.length;
switch (G__22482) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22480.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20442__auto___22540 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto___22540,out){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto___22540,out){
return (function (state_22512){
var state_val_22513 = (state_22512[(1)]);
if((state_val_22513 === (7))){
var inst_22492 = (state_22512[(7)]);
var inst_22491 = (state_22512[(8)]);
var inst_22491__$1 = (state_22512[(2)]);
var inst_22492__$1 = cljs.core.nth.call(null,inst_22491__$1,(0),null);
var inst_22493 = cljs.core.nth.call(null,inst_22491__$1,(1),null);
var inst_22494 = (inst_22492__$1 == null);
var state_22512__$1 = (function (){var statearr_22514 = state_22512;
(statearr_22514[(7)] = inst_22492__$1);

(statearr_22514[(9)] = inst_22493);

(statearr_22514[(8)] = inst_22491__$1);

return statearr_22514;
})();
if(cljs.core.truth_(inst_22494)){
var statearr_22515_22541 = state_22512__$1;
(statearr_22515_22541[(1)] = (8));

} else {
var statearr_22516_22542 = state_22512__$1;
(statearr_22516_22542[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22513 === (1))){
var inst_22483 = cljs.core.vec.call(null,chs);
var inst_22484 = inst_22483;
var state_22512__$1 = (function (){var statearr_22517 = state_22512;
(statearr_22517[(10)] = inst_22484);

return statearr_22517;
})();
var statearr_22518_22543 = state_22512__$1;
(statearr_22518_22543[(2)] = null);

(statearr_22518_22543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22513 === (4))){
var inst_22484 = (state_22512[(10)]);
var state_22512__$1 = state_22512;
return cljs.core.async.ioc_alts_BANG_.call(null,state_22512__$1,(7),inst_22484);
} else {
if((state_val_22513 === (6))){
var inst_22508 = (state_22512[(2)]);
var state_22512__$1 = state_22512;
var statearr_22519_22544 = state_22512__$1;
(statearr_22519_22544[(2)] = inst_22508);

(statearr_22519_22544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22513 === (3))){
var inst_22510 = (state_22512[(2)]);
var state_22512__$1 = state_22512;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22512__$1,inst_22510);
} else {
if((state_val_22513 === (2))){
var inst_22484 = (state_22512[(10)]);
var inst_22486 = cljs.core.count.call(null,inst_22484);
var inst_22487 = (inst_22486 > (0));
var state_22512__$1 = state_22512;
if(cljs.core.truth_(inst_22487)){
var statearr_22521_22545 = state_22512__$1;
(statearr_22521_22545[(1)] = (4));

} else {
var statearr_22522_22546 = state_22512__$1;
(statearr_22522_22546[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22513 === (11))){
var inst_22484 = (state_22512[(10)]);
var inst_22501 = (state_22512[(2)]);
var tmp22520 = inst_22484;
var inst_22484__$1 = tmp22520;
var state_22512__$1 = (function (){var statearr_22523 = state_22512;
(statearr_22523[(11)] = inst_22501);

(statearr_22523[(10)] = inst_22484__$1);

return statearr_22523;
})();
var statearr_22524_22547 = state_22512__$1;
(statearr_22524_22547[(2)] = null);

(statearr_22524_22547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22513 === (9))){
var inst_22492 = (state_22512[(7)]);
var state_22512__$1 = state_22512;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22512__$1,(11),out,inst_22492);
} else {
if((state_val_22513 === (5))){
var inst_22506 = cljs.core.async.close_BANG_.call(null,out);
var state_22512__$1 = state_22512;
var statearr_22525_22548 = state_22512__$1;
(statearr_22525_22548[(2)] = inst_22506);

(statearr_22525_22548[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22513 === (10))){
var inst_22504 = (state_22512[(2)]);
var state_22512__$1 = state_22512;
var statearr_22526_22549 = state_22512__$1;
(statearr_22526_22549[(2)] = inst_22504);

(statearr_22526_22549[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22513 === (8))){
var inst_22492 = (state_22512[(7)]);
var inst_22493 = (state_22512[(9)]);
var inst_22491 = (state_22512[(8)]);
var inst_22484 = (state_22512[(10)]);
var inst_22496 = (function (){var cs = inst_22484;
var vec__22489 = inst_22491;
var v = inst_22492;
var c = inst_22493;
return ((function (cs,vec__22489,v,c,inst_22492,inst_22493,inst_22491,inst_22484,state_val_22513,c__20442__auto___22540,out){
return (function (p1__22479_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__22479_SHARP_);
});
;})(cs,vec__22489,v,c,inst_22492,inst_22493,inst_22491,inst_22484,state_val_22513,c__20442__auto___22540,out))
})();
var inst_22497 = cljs.core.filterv.call(null,inst_22496,inst_22484);
var inst_22484__$1 = inst_22497;
var state_22512__$1 = (function (){var statearr_22527 = state_22512;
(statearr_22527[(10)] = inst_22484__$1);

return statearr_22527;
})();
var statearr_22528_22550 = state_22512__$1;
(statearr_22528_22550[(2)] = null);

(statearr_22528_22550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto___22540,out))
;
return ((function (switch__20330__auto__,c__20442__auto___22540,out){
return (function() {
var cljs$core$async$state_machine__20331__auto__ = null;
var cljs$core$async$state_machine__20331__auto____0 = (function (){
var statearr_22532 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22532[(0)] = cljs$core$async$state_machine__20331__auto__);

(statearr_22532[(1)] = (1));

return statearr_22532;
});
var cljs$core$async$state_machine__20331__auto____1 = (function (state_22512){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_22512);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e22533){if((e22533 instanceof Object)){
var ex__20334__auto__ = e22533;
var statearr_22534_22551 = state_22512;
(statearr_22534_22551[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22512);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22533;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22552 = state_22512;
state_22512 = G__22552;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$state_machine__20331__auto__ = function(state_22512){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20331__auto____1.call(this,state_22512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20331__auto____0;
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20331__auto____1;
return cljs$core$async$state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto___22540,out))
})();
var state__20444__auto__ = (function (){var statearr_22535 = f__20443__auto__.call(null);
(statearr_22535[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto___22540);

return statearr_22535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto___22540,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args22553 = [];
var len__19333__auto___22602 = arguments.length;
var i__19334__auto___22603 = (0);
while(true){
if((i__19334__auto___22603 < len__19333__auto___22602)){
args22553.push((arguments[i__19334__auto___22603]));

var G__22604 = (i__19334__auto___22603 + (1));
i__19334__auto___22603 = G__22604;
continue;
} else {
}
break;
}

var G__22555 = args22553.length;
switch (G__22555) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22553.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20442__auto___22606 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto___22606,out){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto___22606,out){
return (function (state_22579){
var state_val_22580 = (state_22579[(1)]);
if((state_val_22580 === (7))){
var inst_22561 = (state_22579[(7)]);
var inst_22561__$1 = (state_22579[(2)]);
var inst_22562 = (inst_22561__$1 == null);
var inst_22563 = cljs.core.not.call(null,inst_22562);
var state_22579__$1 = (function (){var statearr_22581 = state_22579;
(statearr_22581[(7)] = inst_22561__$1);

return statearr_22581;
})();
if(inst_22563){
var statearr_22582_22607 = state_22579__$1;
(statearr_22582_22607[(1)] = (8));

} else {
var statearr_22583_22608 = state_22579__$1;
(statearr_22583_22608[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22580 === (1))){
var inst_22556 = (0);
var state_22579__$1 = (function (){var statearr_22584 = state_22579;
(statearr_22584[(8)] = inst_22556);

return statearr_22584;
})();
var statearr_22585_22609 = state_22579__$1;
(statearr_22585_22609[(2)] = null);

(statearr_22585_22609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22580 === (4))){
var state_22579__$1 = state_22579;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22579__$1,(7),ch);
} else {
if((state_val_22580 === (6))){
var inst_22574 = (state_22579[(2)]);
var state_22579__$1 = state_22579;
var statearr_22586_22610 = state_22579__$1;
(statearr_22586_22610[(2)] = inst_22574);

(statearr_22586_22610[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22580 === (3))){
var inst_22576 = (state_22579[(2)]);
var inst_22577 = cljs.core.async.close_BANG_.call(null,out);
var state_22579__$1 = (function (){var statearr_22587 = state_22579;
(statearr_22587[(9)] = inst_22576);

return statearr_22587;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22579__$1,inst_22577);
} else {
if((state_val_22580 === (2))){
var inst_22556 = (state_22579[(8)]);
var inst_22558 = (inst_22556 < n);
var state_22579__$1 = state_22579;
if(cljs.core.truth_(inst_22558)){
var statearr_22588_22611 = state_22579__$1;
(statearr_22588_22611[(1)] = (4));

} else {
var statearr_22589_22612 = state_22579__$1;
(statearr_22589_22612[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22580 === (11))){
var inst_22556 = (state_22579[(8)]);
var inst_22566 = (state_22579[(2)]);
var inst_22567 = (inst_22556 + (1));
var inst_22556__$1 = inst_22567;
var state_22579__$1 = (function (){var statearr_22590 = state_22579;
(statearr_22590[(8)] = inst_22556__$1);

(statearr_22590[(10)] = inst_22566);

return statearr_22590;
})();
var statearr_22591_22613 = state_22579__$1;
(statearr_22591_22613[(2)] = null);

(statearr_22591_22613[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22580 === (9))){
var state_22579__$1 = state_22579;
var statearr_22592_22614 = state_22579__$1;
(statearr_22592_22614[(2)] = null);

(statearr_22592_22614[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22580 === (5))){
var state_22579__$1 = state_22579;
var statearr_22593_22615 = state_22579__$1;
(statearr_22593_22615[(2)] = null);

(statearr_22593_22615[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22580 === (10))){
var inst_22571 = (state_22579[(2)]);
var state_22579__$1 = state_22579;
var statearr_22594_22616 = state_22579__$1;
(statearr_22594_22616[(2)] = inst_22571);

(statearr_22594_22616[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22580 === (8))){
var inst_22561 = (state_22579[(7)]);
var state_22579__$1 = state_22579;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22579__$1,(11),out,inst_22561);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto___22606,out))
;
return ((function (switch__20330__auto__,c__20442__auto___22606,out){
return (function() {
var cljs$core$async$state_machine__20331__auto__ = null;
var cljs$core$async$state_machine__20331__auto____0 = (function (){
var statearr_22598 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22598[(0)] = cljs$core$async$state_machine__20331__auto__);

(statearr_22598[(1)] = (1));

return statearr_22598;
});
var cljs$core$async$state_machine__20331__auto____1 = (function (state_22579){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_22579);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e22599){if((e22599 instanceof Object)){
var ex__20334__auto__ = e22599;
var statearr_22600_22617 = state_22579;
(statearr_22600_22617[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22579);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22599;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22618 = state_22579;
state_22579 = G__22618;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$state_machine__20331__auto__ = function(state_22579){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20331__auto____1.call(this,state_22579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20331__auto____0;
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20331__auto____1;
return cljs$core$async$state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto___22606,out))
})();
var state__20444__auto__ = (function (){var statearr_22601 = f__20443__auto__.call(null);
(statearr_22601[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto___22606);

return statearr_22601;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto___22606,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async22626 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22626 = (function (map_LT_,f,ch,meta22627){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta22627 = meta22627;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22626.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22628,meta22627__$1){
var self__ = this;
var _22628__$1 = this;
return (new cljs.core.async.t_cljs$core$async22626(self__.map_LT_,self__.f,self__.ch,meta22627__$1));
});

cljs.core.async.t_cljs$core$async22626.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22628){
var self__ = this;
var _22628__$1 = this;
return self__.meta22627;
});

cljs.core.async.t_cljs$core$async22626.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22626.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22626.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22626.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22626.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async22629 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22629 = (function (map_LT_,f,ch,meta22627,_,fn1,meta22630){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta22627 = meta22627;
this._ = _;
this.fn1 = fn1;
this.meta22630 = meta22630;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22629.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_22631,meta22630__$1){
var self__ = this;
var _22631__$1 = this;
return (new cljs.core.async.t_cljs$core$async22629(self__.map_LT_,self__.f,self__.ch,self__.meta22627,self__._,self__.fn1,meta22630__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async22629.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_22631){
var self__ = this;
var _22631__$1 = this;
return self__.meta22630;
});})(___$1))
;

cljs.core.async.t_cljs$core$async22629.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async22629.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async22629.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async22629.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__22619_SHARP_){
return f1.call(null,(((p1__22619_SHARP_ == null))?null:self__.f.call(null,p1__22619_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async22629.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22627","meta22627",-296063249,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async22626","cljs.core.async/t_cljs$core$async22626",766079367,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta22630","meta22630",18697873,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async22629.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22629.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22629";

cljs.core.async.t_cljs$core$async22629.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__18873__auto__,writer__18874__auto__,opt__18875__auto__){
return cljs.core._write.call(null,writer__18874__auto__,"cljs.core.async/t_cljs$core$async22629");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async22629 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async22629(map_LT___$1,f__$1,ch__$1,meta22627__$1,___$2,fn1__$1,meta22630){
return (new cljs.core.async.t_cljs$core$async22629(map_LT___$1,f__$1,ch__$1,meta22627__$1,___$2,fn1__$1,meta22630));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async22629(self__.map_LT_,self__.f,self__.ch,self__.meta22627,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__18263__auto__ = ret;
if(cljs.core.truth_(and__18263__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__18263__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async22626.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22626.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async22626.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22627","meta22627",-296063249,null)], null);
});

cljs.core.async.t_cljs$core$async22626.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22626.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22626";

cljs.core.async.t_cljs$core$async22626.cljs$lang$ctorPrWriter = (function (this__18873__auto__,writer__18874__auto__,opt__18875__auto__){
return cljs.core._write.call(null,writer__18874__auto__,"cljs.core.async/t_cljs$core$async22626");
});

cljs.core.async.__GT_t_cljs$core$async22626 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async22626(map_LT___$1,f__$1,ch__$1,meta22627){
return (new cljs.core.async.t_cljs$core$async22626(map_LT___$1,f__$1,ch__$1,meta22627));
});

}

return (new cljs.core.async.t_cljs$core$async22626(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async22635 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22635 = (function (map_GT_,f,ch,meta22636){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta22636 = meta22636;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22635.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22637,meta22636__$1){
var self__ = this;
var _22637__$1 = this;
return (new cljs.core.async.t_cljs$core$async22635(self__.map_GT_,self__.f,self__.ch,meta22636__$1));
});

cljs.core.async.t_cljs$core$async22635.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22637){
var self__ = this;
var _22637__$1 = this;
return self__.meta22636;
});

cljs.core.async.t_cljs$core$async22635.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22635.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22635.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22635.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async22635.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22635.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async22635.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22636","meta22636",-1444442676,null)], null);
});

cljs.core.async.t_cljs$core$async22635.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22635.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22635";

cljs.core.async.t_cljs$core$async22635.cljs$lang$ctorPrWriter = (function (this__18873__auto__,writer__18874__auto__,opt__18875__auto__){
return cljs.core._write.call(null,writer__18874__auto__,"cljs.core.async/t_cljs$core$async22635");
});

cljs.core.async.__GT_t_cljs$core$async22635 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async22635(map_GT___$1,f__$1,ch__$1,meta22636){
return (new cljs.core.async.t_cljs$core$async22635(map_GT___$1,f__$1,ch__$1,meta22636));
});

}

return (new cljs.core.async.t_cljs$core$async22635(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async22641 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22641 = (function (filter_GT_,p,ch,meta22642){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta22642 = meta22642;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22641.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22643,meta22642__$1){
var self__ = this;
var _22643__$1 = this;
return (new cljs.core.async.t_cljs$core$async22641(self__.filter_GT_,self__.p,self__.ch,meta22642__$1));
});

cljs.core.async.t_cljs$core$async22641.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22643){
var self__ = this;
var _22643__$1 = this;
return self__.meta22642;
});

cljs.core.async.t_cljs$core$async22641.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22641.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22641.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22641.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22641.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async22641.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22641.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async22641.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22642","meta22642",211548258,null)], null);
});

cljs.core.async.t_cljs$core$async22641.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22641.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22641";

cljs.core.async.t_cljs$core$async22641.cljs$lang$ctorPrWriter = (function (this__18873__auto__,writer__18874__auto__,opt__18875__auto__){
return cljs.core._write.call(null,writer__18874__auto__,"cljs.core.async/t_cljs$core$async22641");
});

cljs.core.async.__GT_t_cljs$core$async22641 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async22641(filter_GT___$1,p__$1,ch__$1,meta22642){
return (new cljs.core.async.t_cljs$core$async22641(filter_GT___$1,p__$1,ch__$1,meta22642));
});

}

return (new cljs.core.async.t_cljs$core$async22641(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args22644 = [];
var len__19333__auto___22688 = arguments.length;
var i__19334__auto___22689 = (0);
while(true){
if((i__19334__auto___22689 < len__19333__auto___22688)){
args22644.push((arguments[i__19334__auto___22689]));

var G__22690 = (i__19334__auto___22689 + (1));
i__19334__auto___22689 = G__22690;
continue;
} else {
}
break;
}

var G__22646 = args22644.length;
switch (G__22646) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22644.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20442__auto___22692 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto___22692,out){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto___22692,out){
return (function (state_22667){
var state_val_22668 = (state_22667[(1)]);
if((state_val_22668 === (7))){
var inst_22663 = (state_22667[(2)]);
var state_22667__$1 = state_22667;
var statearr_22669_22693 = state_22667__$1;
(statearr_22669_22693[(2)] = inst_22663);

(statearr_22669_22693[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22668 === (1))){
var state_22667__$1 = state_22667;
var statearr_22670_22694 = state_22667__$1;
(statearr_22670_22694[(2)] = null);

(statearr_22670_22694[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22668 === (4))){
var inst_22649 = (state_22667[(7)]);
var inst_22649__$1 = (state_22667[(2)]);
var inst_22650 = (inst_22649__$1 == null);
var state_22667__$1 = (function (){var statearr_22671 = state_22667;
(statearr_22671[(7)] = inst_22649__$1);

return statearr_22671;
})();
if(cljs.core.truth_(inst_22650)){
var statearr_22672_22695 = state_22667__$1;
(statearr_22672_22695[(1)] = (5));

} else {
var statearr_22673_22696 = state_22667__$1;
(statearr_22673_22696[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22668 === (6))){
var inst_22649 = (state_22667[(7)]);
var inst_22654 = p.call(null,inst_22649);
var state_22667__$1 = state_22667;
if(cljs.core.truth_(inst_22654)){
var statearr_22674_22697 = state_22667__$1;
(statearr_22674_22697[(1)] = (8));

} else {
var statearr_22675_22698 = state_22667__$1;
(statearr_22675_22698[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22668 === (3))){
var inst_22665 = (state_22667[(2)]);
var state_22667__$1 = state_22667;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22667__$1,inst_22665);
} else {
if((state_val_22668 === (2))){
var state_22667__$1 = state_22667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22667__$1,(4),ch);
} else {
if((state_val_22668 === (11))){
var inst_22657 = (state_22667[(2)]);
var state_22667__$1 = state_22667;
var statearr_22676_22699 = state_22667__$1;
(statearr_22676_22699[(2)] = inst_22657);

(statearr_22676_22699[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22668 === (9))){
var state_22667__$1 = state_22667;
var statearr_22677_22700 = state_22667__$1;
(statearr_22677_22700[(2)] = null);

(statearr_22677_22700[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22668 === (5))){
var inst_22652 = cljs.core.async.close_BANG_.call(null,out);
var state_22667__$1 = state_22667;
var statearr_22678_22701 = state_22667__$1;
(statearr_22678_22701[(2)] = inst_22652);

(statearr_22678_22701[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22668 === (10))){
var inst_22660 = (state_22667[(2)]);
var state_22667__$1 = (function (){var statearr_22679 = state_22667;
(statearr_22679[(8)] = inst_22660);

return statearr_22679;
})();
var statearr_22680_22702 = state_22667__$1;
(statearr_22680_22702[(2)] = null);

(statearr_22680_22702[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22668 === (8))){
var inst_22649 = (state_22667[(7)]);
var state_22667__$1 = state_22667;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22667__$1,(11),out,inst_22649);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto___22692,out))
;
return ((function (switch__20330__auto__,c__20442__auto___22692,out){
return (function() {
var cljs$core$async$state_machine__20331__auto__ = null;
var cljs$core$async$state_machine__20331__auto____0 = (function (){
var statearr_22684 = [null,null,null,null,null,null,null,null,null];
(statearr_22684[(0)] = cljs$core$async$state_machine__20331__auto__);

(statearr_22684[(1)] = (1));

return statearr_22684;
});
var cljs$core$async$state_machine__20331__auto____1 = (function (state_22667){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_22667);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e22685){if((e22685 instanceof Object)){
var ex__20334__auto__ = e22685;
var statearr_22686_22703 = state_22667;
(statearr_22686_22703[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22667);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22685;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22704 = state_22667;
state_22667 = G__22704;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$state_machine__20331__auto__ = function(state_22667){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20331__auto____1.call(this,state_22667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20331__auto____0;
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20331__auto____1;
return cljs$core$async$state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto___22692,out))
})();
var state__20444__auto__ = (function (){var statearr_22687 = f__20443__auto__.call(null);
(statearr_22687[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto___22692);

return statearr_22687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto___22692,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args22705 = [];
var len__19333__auto___22708 = arguments.length;
var i__19334__auto___22709 = (0);
while(true){
if((i__19334__auto___22709 < len__19333__auto___22708)){
args22705.push((arguments[i__19334__auto___22709]));

var G__22710 = (i__19334__auto___22709 + (1));
i__19334__auto___22709 = G__22710;
continue;
} else {
}
break;
}

var G__22707 = args22705.length;
switch (G__22707) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22705.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__20442__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto__){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto__){
return (function (state_22877){
var state_val_22878 = (state_22877[(1)]);
if((state_val_22878 === (7))){
var inst_22873 = (state_22877[(2)]);
var state_22877__$1 = state_22877;
var statearr_22879_22920 = state_22877__$1;
(statearr_22879_22920[(2)] = inst_22873);

(statearr_22879_22920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22878 === (20))){
var inst_22843 = (state_22877[(7)]);
var inst_22854 = (state_22877[(2)]);
var inst_22855 = cljs.core.next.call(null,inst_22843);
var inst_22829 = inst_22855;
var inst_22830 = null;
var inst_22831 = (0);
var inst_22832 = (0);
var state_22877__$1 = (function (){var statearr_22880 = state_22877;
(statearr_22880[(8)] = inst_22832);

(statearr_22880[(9)] = inst_22830);

(statearr_22880[(10)] = inst_22831);

(statearr_22880[(11)] = inst_22829);

(statearr_22880[(12)] = inst_22854);

return statearr_22880;
})();
var statearr_22881_22921 = state_22877__$1;
(statearr_22881_22921[(2)] = null);

(statearr_22881_22921[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22878 === (1))){
var state_22877__$1 = state_22877;
var statearr_22882_22922 = state_22877__$1;
(statearr_22882_22922[(2)] = null);

(statearr_22882_22922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22878 === (4))){
var inst_22818 = (state_22877[(13)]);
var inst_22818__$1 = (state_22877[(2)]);
var inst_22819 = (inst_22818__$1 == null);
var state_22877__$1 = (function (){var statearr_22883 = state_22877;
(statearr_22883[(13)] = inst_22818__$1);

return statearr_22883;
})();
if(cljs.core.truth_(inst_22819)){
var statearr_22884_22923 = state_22877__$1;
(statearr_22884_22923[(1)] = (5));

} else {
var statearr_22885_22924 = state_22877__$1;
(statearr_22885_22924[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22878 === (15))){
var state_22877__$1 = state_22877;
var statearr_22889_22925 = state_22877__$1;
(statearr_22889_22925[(2)] = null);

(statearr_22889_22925[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22878 === (21))){
var state_22877__$1 = state_22877;
var statearr_22890_22926 = state_22877__$1;
(statearr_22890_22926[(2)] = null);

(statearr_22890_22926[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22878 === (13))){
var inst_22832 = (state_22877[(8)]);
var inst_22830 = (state_22877[(9)]);
var inst_22831 = (state_22877[(10)]);
var inst_22829 = (state_22877[(11)]);
var inst_22839 = (state_22877[(2)]);
var inst_22840 = (inst_22832 + (1));
var tmp22886 = inst_22830;
var tmp22887 = inst_22831;
var tmp22888 = inst_22829;
var inst_22829__$1 = tmp22888;
var inst_22830__$1 = tmp22886;
var inst_22831__$1 = tmp22887;
var inst_22832__$1 = inst_22840;
var state_22877__$1 = (function (){var statearr_22891 = state_22877;
(statearr_22891[(8)] = inst_22832__$1);

(statearr_22891[(9)] = inst_22830__$1);

(statearr_22891[(10)] = inst_22831__$1);

(statearr_22891[(14)] = inst_22839);

(statearr_22891[(11)] = inst_22829__$1);

return statearr_22891;
})();
var statearr_22892_22927 = state_22877__$1;
(statearr_22892_22927[(2)] = null);

(statearr_22892_22927[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22878 === (22))){
var state_22877__$1 = state_22877;
var statearr_22893_22928 = state_22877__$1;
(statearr_22893_22928[(2)] = null);

(statearr_22893_22928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22878 === (6))){
var inst_22818 = (state_22877[(13)]);
var inst_22827 = f.call(null,inst_22818);
var inst_22828 = cljs.core.seq.call(null,inst_22827);
var inst_22829 = inst_22828;
var inst_22830 = null;
var inst_22831 = (0);
var inst_22832 = (0);
var state_22877__$1 = (function (){var statearr_22894 = state_22877;
(statearr_22894[(8)] = inst_22832);

(statearr_22894[(9)] = inst_22830);

(statearr_22894[(10)] = inst_22831);

(statearr_22894[(11)] = inst_22829);

return statearr_22894;
})();
var statearr_22895_22929 = state_22877__$1;
(statearr_22895_22929[(2)] = null);

(statearr_22895_22929[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22878 === (17))){
var inst_22843 = (state_22877[(7)]);
var inst_22847 = cljs.core.chunk_first.call(null,inst_22843);
var inst_22848 = cljs.core.chunk_rest.call(null,inst_22843);
var inst_22849 = cljs.core.count.call(null,inst_22847);
var inst_22829 = inst_22848;
var inst_22830 = inst_22847;
var inst_22831 = inst_22849;
var inst_22832 = (0);
var state_22877__$1 = (function (){var statearr_22896 = state_22877;
(statearr_22896[(8)] = inst_22832);

(statearr_22896[(9)] = inst_22830);

(statearr_22896[(10)] = inst_22831);

(statearr_22896[(11)] = inst_22829);

return statearr_22896;
})();
var statearr_22897_22930 = state_22877__$1;
(statearr_22897_22930[(2)] = null);

(statearr_22897_22930[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22878 === (3))){
var inst_22875 = (state_22877[(2)]);
var state_22877__$1 = state_22877;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22877__$1,inst_22875);
} else {
if((state_val_22878 === (12))){
var inst_22863 = (state_22877[(2)]);
var state_22877__$1 = state_22877;
var statearr_22898_22931 = state_22877__$1;
(statearr_22898_22931[(2)] = inst_22863);

(statearr_22898_22931[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22878 === (2))){
var state_22877__$1 = state_22877;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22877__$1,(4),in$);
} else {
if((state_val_22878 === (23))){
var inst_22871 = (state_22877[(2)]);
var state_22877__$1 = state_22877;
var statearr_22899_22932 = state_22877__$1;
(statearr_22899_22932[(2)] = inst_22871);

(statearr_22899_22932[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22878 === (19))){
var inst_22858 = (state_22877[(2)]);
var state_22877__$1 = state_22877;
var statearr_22900_22933 = state_22877__$1;
(statearr_22900_22933[(2)] = inst_22858);

(statearr_22900_22933[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22878 === (11))){
var inst_22843 = (state_22877[(7)]);
var inst_22829 = (state_22877[(11)]);
var inst_22843__$1 = cljs.core.seq.call(null,inst_22829);
var state_22877__$1 = (function (){var statearr_22901 = state_22877;
(statearr_22901[(7)] = inst_22843__$1);

return statearr_22901;
})();
if(inst_22843__$1){
var statearr_22902_22934 = state_22877__$1;
(statearr_22902_22934[(1)] = (14));

} else {
var statearr_22903_22935 = state_22877__$1;
(statearr_22903_22935[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22878 === (9))){
var inst_22865 = (state_22877[(2)]);
var inst_22866 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_22877__$1 = (function (){var statearr_22904 = state_22877;
(statearr_22904[(15)] = inst_22865);

return statearr_22904;
})();
if(cljs.core.truth_(inst_22866)){
var statearr_22905_22936 = state_22877__$1;
(statearr_22905_22936[(1)] = (21));

} else {
var statearr_22906_22937 = state_22877__$1;
(statearr_22906_22937[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22878 === (5))){
var inst_22821 = cljs.core.async.close_BANG_.call(null,out);
var state_22877__$1 = state_22877;
var statearr_22907_22938 = state_22877__$1;
(statearr_22907_22938[(2)] = inst_22821);

(statearr_22907_22938[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22878 === (14))){
var inst_22843 = (state_22877[(7)]);
var inst_22845 = cljs.core.chunked_seq_QMARK_.call(null,inst_22843);
var state_22877__$1 = state_22877;
if(inst_22845){
var statearr_22908_22939 = state_22877__$1;
(statearr_22908_22939[(1)] = (17));

} else {
var statearr_22909_22940 = state_22877__$1;
(statearr_22909_22940[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22878 === (16))){
var inst_22861 = (state_22877[(2)]);
var state_22877__$1 = state_22877;
var statearr_22910_22941 = state_22877__$1;
(statearr_22910_22941[(2)] = inst_22861);

(statearr_22910_22941[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22878 === (10))){
var inst_22832 = (state_22877[(8)]);
var inst_22830 = (state_22877[(9)]);
var inst_22837 = cljs.core._nth.call(null,inst_22830,inst_22832);
var state_22877__$1 = state_22877;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22877__$1,(13),out,inst_22837);
} else {
if((state_val_22878 === (18))){
var inst_22843 = (state_22877[(7)]);
var inst_22852 = cljs.core.first.call(null,inst_22843);
var state_22877__$1 = state_22877;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22877__$1,(20),out,inst_22852);
} else {
if((state_val_22878 === (8))){
var inst_22832 = (state_22877[(8)]);
var inst_22831 = (state_22877[(10)]);
var inst_22834 = (inst_22832 < inst_22831);
var inst_22835 = inst_22834;
var state_22877__$1 = state_22877;
if(cljs.core.truth_(inst_22835)){
var statearr_22911_22942 = state_22877__$1;
(statearr_22911_22942[(1)] = (10));

} else {
var statearr_22912_22943 = state_22877__$1;
(statearr_22912_22943[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto__))
;
return ((function (switch__20330__auto__,c__20442__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__20331__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__20331__auto____0 = (function (){
var statearr_22916 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22916[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__20331__auto__);

(statearr_22916[(1)] = (1));

return statearr_22916;
});
var cljs$core$async$mapcat_STAR__$_state_machine__20331__auto____1 = (function (state_22877){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_22877);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e22917){if((e22917 instanceof Object)){
var ex__20334__auto__ = e22917;
var statearr_22918_22944 = state_22877;
(statearr_22918_22944[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22877);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22917;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22945 = state_22877;
state_22877 = G__22945;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__20331__auto__ = function(state_22877){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__20331__auto____1.call(this,state_22877);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__20331__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__20331__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto__))
})();
var state__20444__auto__ = (function (){var statearr_22919 = f__20443__auto__.call(null);
(statearr_22919[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto__);

return statearr_22919;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto__))
);

return c__20442__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args22946 = [];
var len__19333__auto___22949 = arguments.length;
var i__19334__auto___22950 = (0);
while(true){
if((i__19334__auto___22950 < len__19333__auto___22949)){
args22946.push((arguments[i__19334__auto___22950]));

var G__22951 = (i__19334__auto___22950 + (1));
i__19334__auto___22950 = G__22951;
continue;
} else {
}
break;
}

var G__22948 = args22946.length;
switch (G__22948) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22946.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args22953 = [];
var len__19333__auto___22956 = arguments.length;
var i__19334__auto___22957 = (0);
while(true){
if((i__19334__auto___22957 < len__19333__auto___22956)){
args22953.push((arguments[i__19334__auto___22957]));

var G__22958 = (i__19334__auto___22957 + (1));
i__19334__auto___22957 = G__22958;
continue;
} else {
}
break;
}

var G__22955 = args22953.length;
switch (G__22955) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22953.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args22960 = [];
var len__19333__auto___23011 = arguments.length;
var i__19334__auto___23012 = (0);
while(true){
if((i__19334__auto___23012 < len__19333__auto___23011)){
args22960.push((arguments[i__19334__auto___23012]));

var G__23013 = (i__19334__auto___23012 + (1));
i__19334__auto___23012 = G__23013;
continue;
} else {
}
break;
}

var G__22962 = args22960.length;
switch (G__22962) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22960.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20442__auto___23015 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto___23015,out){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto___23015,out){
return (function (state_22986){
var state_val_22987 = (state_22986[(1)]);
if((state_val_22987 === (7))){
var inst_22981 = (state_22986[(2)]);
var state_22986__$1 = state_22986;
var statearr_22988_23016 = state_22986__$1;
(statearr_22988_23016[(2)] = inst_22981);

(statearr_22988_23016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22987 === (1))){
var inst_22963 = null;
var state_22986__$1 = (function (){var statearr_22989 = state_22986;
(statearr_22989[(7)] = inst_22963);

return statearr_22989;
})();
var statearr_22990_23017 = state_22986__$1;
(statearr_22990_23017[(2)] = null);

(statearr_22990_23017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22987 === (4))){
var inst_22966 = (state_22986[(8)]);
var inst_22966__$1 = (state_22986[(2)]);
var inst_22967 = (inst_22966__$1 == null);
var inst_22968 = cljs.core.not.call(null,inst_22967);
var state_22986__$1 = (function (){var statearr_22991 = state_22986;
(statearr_22991[(8)] = inst_22966__$1);

return statearr_22991;
})();
if(inst_22968){
var statearr_22992_23018 = state_22986__$1;
(statearr_22992_23018[(1)] = (5));

} else {
var statearr_22993_23019 = state_22986__$1;
(statearr_22993_23019[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22987 === (6))){
var state_22986__$1 = state_22986;
var statearr_22994_23020 = state_22986__$1;
(statearr_22994_23020[(2)] = null);

(statearr_22994_23020[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22987 === (3))){
var inst_22983 = (state_22986[(2)]);
var inst_22984 = cljs.core.async.close_BANG_.call(null,out);
var state_22986__$1 = (function (){var statearr_22995 = state_22986;
(statearr_22995[(9)] = inst_22983);

return statearr_22995;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22986__$1,inst_22984);
} else {
if((state_val_22987 === (2))){
var state_22986__$1 = state_22986;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22986__$1,(4),ch);
} else {
if((state_val_22987 === (11))){
var inst_22966 = (state_22986[(8)]);
var inst_22975 = (state_22986[(2)]);
var inst_22963 = inst_22966;
var state_22986__$1 = (function (){var statearr_22996 = state_22986;
(statearr_22996[(7)] = inst_22963);

(statearr_22996[(10)] = inst_22975);

return statearr_22996;
})();
var statearr_22997_23021 = state_22986__$1;
(statearr_22997_23021[(2)] = null);

(statearr_22997_23021[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22987 === (9))){
var inst_22966 = (state_22986[(8)]);
var state_22986__$1 = state_22986;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22986__$1,(11),out,inst_22966);
} else {
if((state_val_22987 === (5))){
var inst_22963 = (state_22986[(7)]);
var inst_22966 = (state_22986[(8)]);
var inst_22970 = cljs.core._EQ_.call(null,inst_22966,inst_22963);
var state_22986__$1 = state_22986;
if(inst_22970){
var statearr_22999_23022 = state_22986__$1;
(statearr_22999_23022[(1)] = (8));

} else {
var statearr_23000_23023 = state_22986__$1;
(statearr_23000_23023[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22987 === (10))){
var inst_22978 = (state_22986[(2)]);
var state_22986__$1 = state_22986;
var statearr_23001_23024 = state_22986__$1;
(statearr_23001_23024[(2)] = inst_22978);

(statearr_23001_23024[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22987 === (8))){
var inst_22963 = (state_22986[(7)]);
var tmp22998 = inst_22963;
var inst_22963__$1 = tmp22998;
var state_22986__$1 = (function (){var statearr_23002 = state_22986;
(statearr_23002[(7)] = inst_22963__$1);

return statearr_23002;
})();
var statearr_23003_23025 = state_22986__$1;
(statearr_23003_23025[(2)] = null);

(statearr_23003_23025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto___23015,out))
;
return ((function (switch__20330__auto__,c__20442__auto___23015,out){
return (function() {
var cljs$core$async$state_machine__20331__auto__ = null;
var cljs$core$async$state_machine__20331__auto____0 = (function (){
var statearr_23007 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23007[(0)] = cljs$core$async$state_machine__20331__auto__);

(statearr_23007[(1)] = (1));

return statearr_23007;
});
var cljs$core$async$state_machine__20331__auto____1 = (function (state_22986){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_22986);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e23008){if((e23008 instanceof Object)){
var ex__20334__auto__ = e23008;
var statearr_23009_23026 = state_22986;
(statearr_23009_23026[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22986);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23008;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23027 = state_22986;
state_22986 = G__23027;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$state_machine__20331__auto__ = function(state_22986){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20331__auto____1.call(this,state_22986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20331__auto____0;
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20331__auto____1;
return cljs$core$async$state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto___23015,out))
})();
var state__20444__auto__ = (function (){var statearr_23010 = f__20443__auto__.call(null);
(statearr_23010[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto___23015);

return statearr_23010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto___23015,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args23028 = [];
var len__19333__auto___23098 = arguments.length;
var i__19334__auto___23099 = (0);
while(true){
if((i__19334__auto___23099 < len__19333__auto___23098)){
args23028.push((arguments[i__19334__auto___23099]));

var G__23100 = (i__19334__auto___23099 + (1));
i__19334__auto___23099 = G__23100;
continue;
} else {
}
break;
}

var G__23030 = args23028.length;
switch (G__23030) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23028.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20442__auto___23102 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto___23102,out){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto___23102,out){
return (function (state_23068){
var state_val_23069 = (state_23068[(1)]);
if((state_val_23069 === (7))){
var inst_23064 = (state_23068[(2)]);
var state_23068__$1 = state_23068;
var statearr_23070_23103 = state_23068__$1;
(statearr_23070_23103[(2)] = inst_23064);

(statearr_23070_23103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23069 === (1))){
var inst_23031 = (new Array(n));
var inst_23032 = inst_23031;
var inst_23033 = (0);
var state_23068__$1 = (function (){var statearr_23071 = state_23068;
(statearr_23071[(7)] = inst_23033);

(statearr_23071[(8)] = inst_23032);

return statearr_23071;
})();
var statearr_23072_23104 = state_23068__$1;
(statearr_23072_23104[(2)] = null);

(statearr_23072_23104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23069 === (4))){
var inst_23036 = (state_23068[(9)]);
var inst_23036__$1 = (state_23068[(2)]);
var inst_23037 = (inst_23036__$1 == null);
var inst_23038 = cljs.core.not.call(null,inst_23037);
var state_23068__$1 = (function (){var statearr_23073 = state_23068;
(statearr_23073[(9)] = inst_23036__$1);

return statearr_23073;
})();
if(inst_23038){
var statearr_23074_23105 = state_23068__$1;
(statearr_23074_23105[(1)] = (5));

} else {
var statearr_23075_23106 = state_23068__$1;
(statearr_23075_23106[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23069 === (15))){
var inst_23058 = (state_23068[(2)]);
var state_23068__$1 = state_23068;
var statearr_23076_23107 = state_23068__$1;
(statearr_23076_23107[(2)] = inst_23058);

(statearr_23076_23107[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23069 === (13))){
var state_23068__$1 = state_23068;
var statearr_23077_23108 = state_23068__$1;
(statearr_23077_23108[(2)] = null);

(statearr_23077_23108[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23069 === (6))){
var inst_23033 = (state_23068[(7)]);
var inst_23054 = (inst_23033 > (0));
var state_23068__$1 = state_23068;
if(cljs.core.truth_(inst_23054)){
var statearr_23078_23109 = state_23068__$1;
(statearr_23078_23109[(1)] = (12));

} else {
var statearr_23079_23110 = state_23068__$1;
(statearr_23079_23110[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23069 === (3))){
var inst_23066 = (state_23068[(2)]);
var state_23068__$1 = state_23068;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23068__$1,inst_23066);
} else {
if((state_val_23069 === (12))){
var inst_23032 = (state_23068[(8)]);
var inst_23056 = cljs.core.vec.call(null,inst_23032);
var state_23068__$1 = state_23068;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23068__$1,(15),out,inst_23056);
} else {
if((state_val_23069 === (2))){
var state_23068__$1 = state_23068;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23068__$1,(4),ch);
} else {
if((state_val_23069 === (11))){
var inst_23048 = (state_23068[(2)]);
var inst_23049 = (new Array(n));
var inst_23032 = inst_23049;
var inst_23033 = (0);
var state_23068__$1 = (function (){var statearr_23080 = state_23068;
(statearr_23080[(7)] = inst_23033);

(statearr_23080[(8)] = inst_23032);

(statearr_23080[(10)] = inst_23048);

return statearr_23080;
})();
var statearr_23081_23111 = state_23068__$1;
(statearr_23081_23111[(2)] = null);

(statearr_23081_23111[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23069 === (9))){
var inst_23032 = (state_23068[(8)]);
var inst_23046 = cljs.core.vec.call(null,inst_23032);
var state_23068__$1 = state_23068;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23068__$1,(11),out,inst_23046);
} else {
if((state_val_23069 === (5))){
var inst_23033 = (state_23068[(7)]);
var inst_23041 = (state_23068[(11)]);
var inst_23032 = (state_23068[(8)]);
var inst_23036 = (state_23068[(9)]);
var inst_23040 = (inst_23032[inst_23033] = inst_23036);
var inst_23041__$1 = (inst_23033 + (1));
var inst_23042 = (inst_23041__$1 < n);
var state_23068__$1 = (function (){var statearr_23082 = state_23068;
(statearr_23082[(12)] = inst_23040);

(statearr_23082[(11)] = inst_23041__$1);

return statearr_23082;
})();
if(cljs.core.truth_(inst_23042)){
var statearr_23083_23112 = state_23068__$1;
(statearr_23083_23112[(1)] = (8));

} else {
var statearr_23084_23113 = state_23068__$1;
(statearr_23084_23113[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23069 === (14))){
var inst_23061 = (state_23068[(2)]);
var inst_23062 = cljs.core.async.close_BANG_.call(null,out);
var state_23068__$1 = (function (){var statearr_23086 = state_23068;
(statearr_23086[(13)] = inst_23061);

return statearr_23086;
})();
var statearr_23087_23114 = state_23068__$1;
(statearr_23087_23114[(2)] = inst_23062);

(statearr_23087_23114[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23069 === (10))){
var inst_23052 = (state_23068[(2)]);
var state_23068__$1 = state_23068;
var statearr_23088_23115 = state_23068__$1;
(statearr_23088_23115[(2)] = inst_23052);

(statearr_23088_23115[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23069 === (8))){
var inst_23041 = (state_23068[(11)]);
var inst_23032 = (state_23068[(8)]);
var tmp23085 = inst_23032;
var inst_23032__$1 = tmp23085;
var inst_23033 = inst_23041;
var state_23068__$1 = (function (){var statearr_23089 = state_23068;
(statearr_23089[(7)] = inst_23033);

(statearr_23089[(8)] = inst_23032__$1);

return statearr_23089;
})();
var statearr_23090_23116 = state_23068__$1;
(statearr_23090_23116[(2)] = null);

(statearr_23090_23116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto___23102,out))
;
return ((function (switch__20330__auto__,c__20442__auto___23102,out){
return (function() {
var cljs$core$async$state_machine__20331__auto__ = null;
var cljs$core$async$state_machine__20331__auto____0 = (function (){
var statearr_23094 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23094[(0)] = cljs$core$async$state_machine__20331__auto__);

(statearr_23094[(1)] = (1));

return statearr_23094;
});
var cljs$core$async$state_machine__20331__auto____1 = (function (state_23068){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_23068);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e23095){if((e23095 instanceof Object)){
var ex__20334__auto__ = e23095;
var statearr_23096_23117 = state_23068;
(statearr_23096_23117[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23068);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23095;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23118 = state_23068;
state_23068 = G__23118;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$state_machine__20331__auto__ = function(state_23068){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20331__auto____1.call(this,state_23068);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20331__auto____0;
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20331__auto____1;
return cljs$core$async$state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto___23102,out))
})();
var state__20444__auto__ = (function (){var statearr_23097 = f__20443__auto__.call(null);
(statearr_23097[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto___23102);

return statearr_23097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto___23102,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args23119 = [];
var len__19333__auto___23193 = arguments.length;
var i__19334__auto___23194 = (0);
while(true){
if((i__19334__auto___23194 < len__19333__auto___23193)){
args23119.push((arguments[i__19334__auto___23194]));

var G__23195 = (i__19334__auto___23194 + (1));
i__19334__auto___23194 = G__23195;
continue;
} else {
}
break;
}

var G__23121 = args23119.length;
switch (G__23121) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23119.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20442__auto___23197 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto___23197,out){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto___23197,out){
return (function (state_23163){
var state_val_23164 = (state_23163[(1)]);
if((state_val_23164 === (7))){
var inst_23159 = (state_23163[(2)]);
var state_23163__$1 = state_23163;
var statearr_23165_23198 = state_23163__$1;
(statearr_23165_23198[(2)] = inst_23159);

(statearr_23165_23198[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23164 === (1))){
var inst_23122 = [];
var inst_23123 = inst_23122;
var inst_23124 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_23163__$1 = (function (){var statearr_23166 = state_23163;
(statearr_23166[(7)] = inst_23124);

(statearr_23166[(8)] = inst_23123);

return statearr_23166;
})();
var statearr_23167_23199 = state_23163__$1;
(statearr_23167_23199[(2)] = null);

(statearr_23167_23199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23164 === (4))){
var inst_23127 = (state_23163[(9)]);
var inst_23127__$1 = (state_23163[(2)]);
var inst_23128 = (inst_23127__$1 == null);
var inst_23129 = cljs.core.not.call(null,inst_23128);
var state_23163__$1 = (function (){var statearr_23168 = state_23163;
(statearr_23168[(9)] = inst_23127__$1);

return statearr_23168;
})();
if(inst_23129){
var statearr_23169_23200 = state_23163__$1;
(statearr_23169_23200[(1)] = (5));

} else {
var statearr_23170_23201 = state_23163__$1;
(statearr_23170_23201[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23164 === (15))){
var inst_23153 = (state_23163[(2)]);
var state_23163__$1 = state_23163;
var statearr_23171_23202 = state_23163__$1;
(statearr_23171_23202[(2)] = inst_23153);

(statearr_23171_23202[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23164 === (13))){
var state_23163__$1 = state_23163;
var statearr_23172_23203 = state_23163__$1;
(statearr_23172_23203[(2)] = null);

(statearr_23172_23203[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23164 === (6))){
var inst_23123 = (state_23163[(8)]);
var inst_23148 = inst_23123.length;
var inst_23149 = (inst_23148 > (0));
var state_23163__$1 = state_23163;
if(cljs.core.truth_(inst_23149)){
var statearr_23173_23204 = state_23163__$1;
(statearr_23173_23204[(1)] = (12));

} else {
var statearr_23174_23205 = state_23163__$1;
(statearr_23174_23205[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23164 === (3))){
var inst_23161 = (state_23163[(2)]);
var state_23163__$1 = state_23163;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23163__$1,inst_23161);
} else {
if((state_val_23164 === (12))){
var inst_23123 = (state_23163[(8)]);
var inst_23151 = cljs.core.vec.call(null,inst_23123);
var state_23163__$1 = state_23163;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23163__$1,(15),out,inst_23151);
} else {
if((state_val_23164 === (2))){
var state_23163__$1 = state_23163;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23163__$1,(4),ch);
} else {
if((state_val_23164 === (11))){
var inst_23131 = (state_23163[(10)]);
var inst_23127 = (state_23163[(9)]);
var inst_23141 = (state_23163[(2)]);
var inst_23142 = [];
var inst_23143 = inst_23142.push(inst_23127);
var inst_23123 = inst_23142;
var inst_23124 = inst_23131;
var state_23163__$1 = (function (){var statearr_23175 = state_23163;
(statearr_23175[(7)] = inst_23124);

(statearr_23175[(8)] = inst_23123);

(statearr_23175[(11)] = inst_23141);

(statearr_23175[(12)] = inst_23143);

return statearr_23175;
})();
var statearr_23176_23206 = state_23163__$1;
(statearr_23176_23206[(2)] = null);

(statearr_23176_23206[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23164 === (9))){
var inst_23123 = (state_23163[(8)]);
var inst_23139 = cljs.core.vec.call(null,inst_23123);
var state_23163__$1 = state_23163;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23163__$1,(11),out,inst_23139);
} else {
if((state_val_23164 === (5))){
var inst_23124 = (state_23163[(7)]);
var inst_23131 = (state_23163[(10)]);
var inst_23127 = (state_23163[(9)]);
var inst_23131__$1 = f.call(null,inst_23127);
var inst_23132 = cljs.core._EQ_.call(null,inst_23131__$1,inst_23124);
var inst_23133 = cljs.core.keyword_identical_QMARK_.call(null,inst_23124,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_23134 = (inst_23132) || (inst_23133);
var state_23163__$1 = (function (){var statearr_23177 = state_23163;
(statearr_23177[(10)] = inst_23131__$1);

return statearr_23177;
})();
if(cljs.core.truth_(inst_23134)){
var statearr_23178_23207 = state_23163__$1;
(statearr_23178_23207[(1)] = (8));

} else {
var statearr_23179_23208 = state_23163__$1;
(statearr_23179_23208[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23164 === (14))){
var inst_23156 = (state_23163[(2)]);
var inst_23157 = cljs.core.async.close_BANG_.call(null,out);
var state_23163__$1 = (function (){var statearr_23181 = state_23163;
(statearr_23181[(13)] = inst_23156);

return statearr_23181;
})();
var statearr_23182_23209 = state_23163__$1;
(statearr_23182_23209[(2)] = inst_23157);

(statearr_23182_23209[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23164 === (10))){
var inst_23146 = (state_23163[(2)]);
var state_23163__$1 = state_23163;
var statearr_23183_23210 = state_23163__$1;
(statearr_23183_23210[(2)] = inst_23146);

(statearr_23183_23210[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23164 === (8))){
var inst_23123 = (state_23163[(8)]);
var inst_23131 = (state_23163[(10)]);
var inst_23127 = (state_23163[(9)]);
var inst_23136 = inst_23123.push(inst_23127);
var tmp23180 = inst_23123;
var inst_23123__$1 = tmp23180;
var inst_23124 = inst_23131;
var state_23163__$1 = (function (){var statearr_23184 = state_23163;
(statearr_23184[(7)] = inst_23124);

(statearr_23184[(14)] = inst_23136);

(statearr_23184[(8)] = inst_23123__$1);

return statearr_23184;
})();
var statearr_23185_23211 = state_23163__$1;
(statearr_23185_23211[(2)] = null);

(statearr_23185_23211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto___23197,out))
;
return ((function (switch__20330__auto__,c__20442__auto___23197,out){
return (function() {
var cljs$core$async$state_machine__20331__auto__ = null;
var cljs$core$async$state_machine__20331__auto____0 = (function (){
var statearr_23189 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23189[(0)] = cljs$core$async$state_machine__20331__auto__);

(statearr_23189[(1)] = (1));

return statearr_23189;
});
var cljs$core$async$state_machine__20331__auto____1 = (function (state_23163){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_23163);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e23190){if((e23190 instanceof Object)){
var ex__20334__auto__ = e23190;
var statearr_23191_23212 = state_23163;
(statearr_23191_23212[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23163);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23190;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23213 = state_23163;
state_23163 = G__23213;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
cljs$core$async$state_machine__20331__auto__ = function(state_23163){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20331__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20331__auto____1.call(this,state_23163);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20331__auto____0;
cljs$core$async$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20331__auto____1;
return cljs$core$async$state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto___23197,out))
})();
var state__20444__auto__ = (function (){var statearr_23192 = f__20443__auto__.call(null);
(statearr_23192[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto___23197);

return statearr_23192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto___23197,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map