// Compiled by ClojureScript 1.7.228 {}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
goog.require('clojure.string');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
cljs.compiler.ns_first_segments = (function cljs$compiler$ns_first_segments(){
var get_first_ns_segment = (function cljs$compiler$ns_first_segments_$_get_first_ns_segment(ns){
return cljs.core.first.call(null,clojure.string.split.call(null,[cljs.core.str(ns)].join(''),/\./));
});
return cljs.core.map.call(null,get_first_ns_segment,cljs.core.keys.call(null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_))));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__30190 = s;
var map__30190__$1 = ((((!((map__30190 == null)))?((((map__30190.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30190.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30190):map__30190);
var name = cljs.core.get.call(null,map__30190__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__30190__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__30193 = info;
var map__30194 = G__30193;
var map__30194__$1 = ((((!((map__30194 == null)))?((((map__30194.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30194.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30194):map__30194);
var shadow = cljs.core.get.call(null,map__30194__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__30193__$1 = G__30193;
while(true){
var d__$2 = d__$1;
var map__30196 = G__30193__$1;
var map__30196__$1 = ((((!((map__30196 == null)))?((((map__30196.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30196.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30196):map__30196);
var shadow__$1 = cljs.core.get.call(null,map__30196__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__30198 = (d__$2 + (1));
var G__30199 = shadow__$1;
d__$1 = G__30198;
G__30193__$1 = G__30199;
continue;
} else {
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.fromArray([[cljs.core.str(name)].join('')], true),cljs.compiler.ns_first_segments.call(null)))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine.call(null,cljs.core._hash.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s)),cljs.compiler.shadow_depth.call(null,s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__30200){
var map__30205 = p__30200;
var map__30205__$1 = ((((!((map__30205 == null)))?((((map__30205.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30205.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30205):map__30205);
var name_var = map__30205__$1;
var name = cljs.core.get.call(null,map__30205__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__30205__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace.call(null,[cljs.core.str(name)].join(''),"..","_DOT__DOT_");
var map__30207 = info;
var map__30207__$1 = ((((!((map__30207 == null)))?((((map__30207.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30207.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30207):map__30207);
var ns = cljs.core.get.call(null,map__30207__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.call(null,map__30207__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,"_$_",cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.call(null,cljs.compiler.munge.call(null,[cljs.core.str(clojure.string.replace.call(null,[cljs.core.str(ns)].join(''),".","$")),cljs.core.str("$"),cljs.core.str(scoped_name)].join('')));
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if(!((cljs.core.get.call(null,reserved,s) == null))){
return [cljs.core.str(s),cljs.core.str("$")].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var args30209 = [];
var len__19333__auto___30212 = arguments.length;
var i__19334__auto___30213 = (0);
while(true){
if((i__19334__auto___30213 < len__19333__auto___30212)){
args30209.push((arguments[i__19334__auto___30213]));

var G__30214 = (i__19334__auto___30213 + (1));
i__19334__auto___30213 = G__30214;
continue;
} else {
}
break;
}

var G__30211 = args30209.length;
switch (G__30211) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30209.length)].join('')));

}
});

cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.call(null,s,cljs.compiler.js_reserved);
});

cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_.call(null,s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if(!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null))){
return cljs.compiler.fn_self_name.call(null,s);
} else {
var depth = cljs.compiler.shadow_depth.call(null,s);
var code = cljs.compiler.hash_scope.call(null,s);
var renamed = cljs.core.get.call(null,cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?[cljs.core.str("self__."),cljs.core.str(name)].join(''):((!((renamed == null)))?renamed:name
));
var munged_name = cljs.compiler.munge.call(null,name__$1,reserved);
if((field === true) || ((depth === (0)))){
return munged_name;
} else {
return cljs.core.symbol.call(null,[cljs.core.str(munged_name),cljs.core.str("__$"),cljs.core.str(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace.call(null,[cljs.core.str(s)].join(''),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace.call(null,ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved.call(null,reserved);
var ss__$2 = cljs.core.map.call(null,rf,clojure.string.split.call(null,ss__$1,/\./));
var ss__$3 = clojure.string.join.call(null,".",ss__$2);
var ms = cljs.core.munge.call(null,ss__$3);
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ms);
} else {
return ms;
}
}
});

cljs.compiler.munge.cljs$lang$maxFixedArity = 2;
cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.call(null,",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__30217 = cp;
switch (G__30217) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if((((31) < cp)) && ((cp < (127)))){
return c;
} else {
return [cljs.core.str("\\u"),cljs.core.str(cp.toString((16)))].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__30223_30227 = cljs.core.seq.call(null,s);
var chunk__30224_30228 = null;
var count__30225_30229 = (0);
var i__30226_30230 = (0);
while(true){
if((i__30226_30230 < count__30225_30229)){
var c_30231 = cljs.core._nth.call(null,chunk__30224_30228,i__30226_30230);
sb.append(cljs.compiler.escape_char.call(null,c_30231));

var G__30232 = seq__30223_30227;
var G__30233 = chunk__30224_30228;
var G__30234 = count__30225_30229;
var G__30235 = (i__30226_30230 + (1));
seq__30223_30227 = G__30232;
chunk__30224_30228 = G__30233;
count__30225_30229 = G__30234;
i__30226_30230 = G__30235;
continue;
} else {
var temp__4425__auto___30236 = cljs.core.seq.call(null,seq__30223_30227);
if(temp__4425__auto___30236){
var seq__30223_30237__$1 = temp__4425__auto___30236;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30223_30237__$1)){
var c__19078__auto___30238 = cljs.core.chunk_first.call(null,seq__30223_30237__$1);
var G__30239 = cljs.core.chunk_rest.call(null,seq__30223_30237__$1);
var G__30240 = c__19078__auto___30238;
var G__30241 = cljs.core.count.call(null,c__19078__auto___30238);
var G__30242 = (0);
seq__30223_30227 = G__30239;
chunk__30224_30228 = G__30240;
count__30225_30229 = G__30241;
i__30226_30230 = G__30242;
continue;
} else {
var c_30243 = cljs.core.first.call(null,seq__30223_30237__$1);
sb.append(cljs.compiler.escape_char.call(null,c_30243));

var G__30244 = cljs.core.next.call(null,seq__30223_30237__$1);
var G__30245 = null;
var G__30246 = (0);
var G__30247 = (0);
seq__30223_30227 = G__30244;
chunk__30224_30228 = G__30245;
count__30225_30229 = G__30246;
i__30226_30230 = G__30247;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return [cljs.core.str("\""),cljs.core.str(x),cljs.core.str("\"")].join('');
});
if(typeof cljs.compiler.emit_STAR_ !== 'undefined'){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__19188__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__19189__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__19190__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__19191__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__19192__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__19192__auto__,method_table__19188__auto__,prefer_table__19189__auto__,method_cache__19190__auto__,cached_hierarchy__19191__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
var val__25654__auto__ = cljs.env._STAR_compiler_STAR_;
if((val__25654__auto__ == null)){
cljs.env._STAR_compiler_STAR_ = cljs.env.default_compiler_env.call(null);
} else {
}

try{if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__30253_30258 = ast;
var map__30253_30259__$1 = ((((!((map__30253_30258 == null)))?((((map__30253_30258.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30253_30258.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30253_30258):map__30253_30258);
var env_30260 = cljs.core.get.call(null,map__30253_30259__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_30260))){
var map__30255_30261 = env_30260;
var map__30255_30262__$1 = ((((!((map__30255_30261 == null)))?((((map__30255_30261.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30255_30261.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30255_30261):map__30255_30261);
var line_30263 = cljs.core.get.call(null,map__30255_30262__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_30264 = cljs.core.get.call(null,map__30255_30262__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,((function (map__30255_30261,map__30255_30262__$1,line_30263,column_30264,map__30253_30258,map__30253_30259__$1,env_30260,val__25654__auto__){
return (function (m){
var minfo = (function (){var G__30257 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
var G__30257__$1 = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast),new cljs.core.Keyword(null,"var","var",-769682797)))?cljs.core.assoc.call(null,G__30257,new cljs.core.Keyword(null,"name","name",1843675177),[cljs.core.str(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast)))].join('')):G__30257);
return G__30257__$1;
})();
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_30263 - (1))], null),cljs.core.fnil.call(null,((function (minfo,map__30255_30261,map__30255_30262__$1,line_30263,column_30264,map__30253_30258,map__30253_30259__$1,env_30260,val__25654__auto__){
return (function (line__$1){
return cljs.core.update_in.call(null,line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_30264)?(column_30264 - (1)):(0))], null),cljs.core.fnil.call(null,((function (minfo,map__30255_30261,map__30255_30262__$1,line_30263,column_30264,map__30253_30258,map__30253_30259__$1,env_30260,val__25654__auto__){
return (function (column__$1){
return cljs.core.conj.call(null,column__$1,minfo);
});})(minfo,map__30255_30261,map__30255_30262__$1,line_30263,column_30264,map__30253_30258,map__30253_30259__$1,env_30260,val__25654__auto__))
,cljs.core.PersistentVector.EMPTY));
});})(minfo,map__30255_30261,map__30255_30262__$1,line_30263,column_30264,map__30253_30258,map__30253_30259__$1,env_30260,val__25654__auto__))
,cljs.core.sorted_map.call(null)));
});})(map__30255_30261,map__30255_30262__$1,line_30263,column_30264,map__30253_30258,map__30253_30259__$1,env_30260,val__25654__auto__))
);
} else {
}
} else {
}

return cljs.compiler.emit_STAR_.call(null,ast);
}finally {if((val__25654__auto__ == null)){
cljs.env._STAR_compiler_STAR_ = null;
} else {
}
}});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var args__19340__auto__ = [];
var len__19333__auto___30271 = arguments.length;
var i__19334__auto___30272 = (0);
while(true){
if((i__19334__auto___30272 < len__19333__auto___30271)){
args__19340__auto__.push((arguments[i__19334__auto___30272]));

var G__30273 = (i__19334__auto___30272 + (1));
i__19334__auto___30272 = G__30273;
continue;
} else {
}
break;
}

var argseq__19341__auto__ = ((((0) < args__19340__auto__.length))?(new cljs.core.IndexedSeq(args__19340__auto__.slice((0)),(0))):null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(argseq__19341__auto__);
});

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var seq__30267_30274 = cljs.core.seq.call(null,xs);
var chunk__30268_30275 = null;
var count__30269_30276 = (0);
var i__30270_30277 = (0);
while(true){
if((i__30270_30277 < count__30269_30276)){
var x_30278 = cljs.core._nth.call(null,chunk__30268_30275,i__30270_30277);
if((x_30278 == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_.call(null,x_30278)){
cljs.compiler.emit.call(null,x_30278);
} else {
if(cljs.analyzer.cljs_seq_QMARK_.call(null,x_30278)){
cljs.core.apply.call(null,cljs.compiler.emits,x_30278);
} else {
if(goog.isFunction(x_30278)){
x_30278.call(null);
} else {
var s_30279 = cljs.core.print_str.call(null,x_30278);
if((cljs.compiler._STAR_source_map_data_STAR_ == null)){
} else {
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gen-col","gen-col",1901918303)], null),((function (seq__30267_30274,chunk__30268_30275,count__30269_30276,i__30270_30277,s_30279,x_30278){
return (function (p1__30265_SHARP_){
return (p1__30265_SHARP_ + cljs.core.count.call(null,s_30279));
});})(seq__30267_30274,chunk__30268_30275,count__30269_30276,i__30270_30277,s_30279,x_30278))
);
}

cljs.core.print.call(null,s_30279);

}
}
}
}

var G__30280 = seq__30267_30274;
var G__30281 = chunk__30268_30275;
var G__30282 = count__30269_30276;
var G__30283 = (i__30270_30277 + (1));
seq__30267_30274 = G__30280;
chunk__30268_30275 = G__30281;
count__30269_30276 = G__30282;
i__30270_30277 = G__30283;
continue;
} else {
var temp__4425__auto___30284 = cljs.core.seq.call(null,seq__30267_30274);
if(temp__4425__auto___30284){
var seq__30267_30285__$1 = temp__4425__auto___30284;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30267_30285__$1)){
var c__19078__auto___30286 = cljs.core.chunk_first.call(null,seq__30267_30285__$1);
var G__30287 = cljs.core.chunk_rest.call(null,seq__30267_30285__$1);
var G__30288 = c__19078__auto___30286;
var G__30289 = cljs.core.count.call(null,c__19078__auto___30286);
var G__30290 = (0);
seq__30267_30274 = G__30287;
chunk__30268_30275 = G__30288;
count__30269_30276 = G__30289;
i__30270_30277 = G__30290;
continue;
} else {
var x_30291 = cljs.core.first.call(null,seq__30267_30285__$1);
if((x_30291 == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_.call(null,x_30291)){
cljs.compiler.emit.call(null,x_30291);
} else {
if(cljs.analyzer.cljs_seq_QMARK_.call(null,x_30291)){
cljs.core.apply.call(null,cljs.compiler.emits,x_30291);
} else {
if(goog.isFunction(x_30291)){
x_30291.call(null);
} else {
var s_30292 = cljs.core.print_str.call(null,x_30291);
if((cljs.compiler._STAR_source_map_data_STAR_ == null)){
} else {
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gen-col","gen-col",1901918303)], null),((function (seq__30267_30274,chunk__30268_30275,count__30269_30276,i__30270_30277,s_30292,x_30291,seq__30267_30285__$1,temp__4425__auto___30284){
return (function (p1__30265_SHARP_){
return (p1__30265_SHARP_ + cljs.core.count.call(null,s_30292));
});})(seq__30267_30274,chunk__30268_30275,count__30269_30276,i__30270_30277,s_30292,x_30291,seq__30267_30285__$1,temp__4425__auto___30284))
);
}

cljs.core.print.call(null,s_30292);

}
}
}
}

var G__30293 = cljs.core.next.call(null,seq__30267_30285__$1);
var G__30294 = null;
var G__30295 = (0);
var G__30296 = (0);
seq__30267_30274 = G__30293;
chunk__30268_30275 = G__30294;
count__30269_30276 = G__30295;
i__30270_30277 = G__30296;
continue;
}
} else {
}
}
break;
}

return null;
});

cljs.compiler.emits.cljs$lang$maxFixedArity = (0);

cljs.compiler.emits.cljs$lang$applyTo = (function (seq30266){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq30266));
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var args__19340__auto__ = [];
var len__19333__auto___30301 = arguments.length;
var i__19334__auto___30302 = (0);
while(true){
if((i__19334__auto___30302 < len__19333__auto___30301)){
args__19340__auto__.push((arguments[i__19334__auto___30302]));

var G__30303 = (i__19334__auto___30302 + (1));
i__19334__auto___30302 = G__30303;
continue;
} else {
}
break;
}

var argseq__19341__auto__ = ((((0) < args__19340__auto__.length))?(new cljs.core.IndexedSeq(args__19340__auto__.slice((0)),(0))):null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(argseq__19341__auto__);
});

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
cljs.core.apply.call(null,cljs.compiler.emits,xs);

cljs.core.println.call(null);

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (p__30298){
var map__30299 = p__30298;
var map__30299__$1 = ((((!((map__30299 == null)))?((((map__30299.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30299.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30299):map__30299);
var m = map__30299__$1;
var gen_line = cljs.core.get.call(null,map__30299__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0));
}));
} else {
}

return null;
});

cljs.compiler.emitln.cljs$lang$maxFixedArity = (0);

cljs.compiler.emitln.cljs$lang$applyTo = (function (seq30297){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq30297));
});
cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__19249__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_30306_30308 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_30307_30309 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_30306_30308,_STAR_print_fn_STAR_30307_30309,sb__19249__auto__){
return (function (x__19250__auto__){
return sb__19249__auto__.append(x__19250__auto__);
});})(_STAR_print_newline_STAR_30306_30308,_STAR_print_fn_STAR_30307_30309,sb__19249__auto__))
;

try{cljs.compiler.emit.call(null,expr);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_30307_30309;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_30306_30308;
}
return [cljs.core.str(sb__19249__auto__)].join('');
});
if(typeof cljs.compiler.emit_constant !== 'undefined'){
} else {
cljs.compiler.emit_constant = (function (){var method_table__19188__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__19189__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__19190__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__19191__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__19192__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit-constant"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__19192__auto__,method_table__19188__auto__,prefer_table__19189__auto__,method_cache__19190__auto__,cached_hierarchy__19191__auto__));
})();
}
cljs.core._add_method.call(null,cljs.compiler.emit_constant,null,(function (x){
return cljs.compiler.emits.call(null,"null");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,Number,(function (x){
return cljs.compiler.emits.call(null,"(",x,")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,String,(function (x){
return cljs.compiler.emits.call(null,cljs.compiler.wrap_in_double_quotes.call(null,cljs.compiler.escape_string.call(null,x)));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,Boolean,(function (x){
return cljs.compiler.emits.call(null,(cljs.core.truth_(x)?"true":"false"));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,RegExp,(function (x){
if(cljs.core._EQ_.call(null,"",[cljs.core.str(x)].join(''))){
return cljs.compiler.emits.call(null,"(new RegExp(\"\"))");
} else {
var vec__30310 = cljs.core.re_find.call(null,/^(?:\(\?([idmsux]*)\))?(.*)/,[cljs.core.str(x)].join(''));
var _ = cljs.core.nth.call(null,vec__30310,(0),null);
var flags = cljs.core.nth.call(null,vec__30310,(1),null);
var pattern = cljs.core.nth.call(null,vec__30310,(2),null);
return cljs.compiler.emits.call(null,pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace.call(null,kw);
var name = cljs.core.name.call(null,kw);
cljs.compiler.emits.call(null,"new cljs.core.Keyword(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,(cljs.core.truth_(ns)?[cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(name)].join(''):name));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,kw));

return cljs.compiler.emits.call(null,")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace.call(null,sym);
var name = cljs.core.name.call(null,sym);
var symstr = ((!((ns == null)))?[cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
cljs.compiler.emits.call(null,"new cljs.core.Symbol(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,symstr);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,sym));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,null);

return cljs.compiler.emits.call(null,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant,cljs.core.Keyword,(function (x){
if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_))))){
var value = x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_keyword.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,cljs.core.Symbol,(function (x){
if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_))))){
var value = x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_symbol.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,Date,(function (date){
return cljs.compiler.emits.call(null,"new Date(",date.getTime(),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.call(null,"new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash.call(null,uuid_str),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"var","var",-769682797),(function (p__30312){
var map__30313 = p__30312;
var map__30313__$1 = ((((!((map__30313 == null)))?((((map__30313.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30313.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30313):map__30313);
var arg = map__30313__$1;
var info = cljs.core.get.call(null,map__30313__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.call(null,map__30313__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.call(null,map__30313__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.call(null,cljs.core.namespace.call(null,var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name.call(null,var_name)], null));
var or__18275__auto__ = js_module_name;
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(arg))){
return cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,arg));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__26382__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,(function (){var G__30315 = info__$1;
var G__30315__$1 = ((cljs.core.not_EQ_.call(null,form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null)))?cljs.compiler.munge.call(null,G__30315):G__30315);
return G__30315__$1;
})());

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"var-special","var-special",1131576802),(function (p__30316){
var map__30317 = p__30316;
var map__30317__$1 = ((((!((map__30317 == null)))?((((map__30317.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30317.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30317):map__30317);
var arg = map__30317__$1;
var env = cljs.core.get.call(null,map__30317__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.call(null,map__30317__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.call(null,map__30317__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.call(null,map__30317__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_.call(null,sym)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol("ana","ast?","ana/ast?",1470128118,null),new cljs.core.Symbol(null,"sym","sym",195671222,null))))].join('')));
}

if(cljs.analyzer.ast_QMARK_.call(null,meta)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol("ana","ast?","ana/ast?",1470128118,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null))))].join('')));
}

var map__30319 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__30319__$1 = ((((!((map__30319 == null)))?((((map__30319.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30319.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30319):map__30319);
var name = cljs.core.get.call(null,map__30319__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__26382__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"new cljs.core.Var(function(){return ",cljs.compiler.munge.call(null,name),";},",sym,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),(function (p__30321){
var map__30322 = p__30321;
var map__30322__$1 = ((((!((map__30322 == null)))?((((map__30322.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30322.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30322):map__30322);
var expr = cljs.core.get.call(null,map__30322__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.call(null,map__30322__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.call(null,map__30322__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__26382__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"cljs.core.with_meta(",expr,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.array_map_threshold = (8);
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
return (cljs.core.every_QMARK_.call(null,(function (p1__30324_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__30324_SHARP_),new cljs.core.Keyword(null,"constant","constant",-379609303));
}),keys)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,keys)),cljs.core.count.call(null,keys)));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__30325){
var map__30326 = p__30325;
var map__30326__$1 = ((((!((map__30326 == null)))?((((map__30326.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30326.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30326):map__30326);
var env = cljs.core.get.call(null,map__30326__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.call(null,map__30326__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__30326__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__26382__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if((cljs.core.count.call(null,keys) === (0))){
cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count.call(null,keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_(cljs.compiler.distinct_keys_QMARK_.call(null,keys))){
cljs.compiler.emits.call(null,"new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,keys),", [",cljs.compiler.comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"], null)");
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.fromArray([",cljs.compiler.comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"], true, false)");
}
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentHashMap.fromArrays([",cljs.compiler.comma_sep.call(null,keys),"],[",cljs.compiler.comma_sep.call(null,vals),"])");

}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"list","list",765357683),(function (p__30328){
var map__30329 = p__30328;
var map__30329__$1 = ((((!((map__30329 == null)))?((((map__30329.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30329.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30329):map__30329);
var items = cljs.core.get.call(null,map__30329__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__30329__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__26382__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.empty_QMARK_.call(null,items)){
cljs.compiler.emits.call(null,"cljs.core.List.EMPTY");
} else {
cljs.compiler.emits.call(null,"cljs.core.list(",cljs.compiler.comma_sep.call(null,items),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__30331){
var map__30332 = p__30331;
var map__30332__$1 = ((((!((map__30332 == null)))?((((map__30332.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30332.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30332):map__30332);
var items = cljs.core.get.call(null,map__30332__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__30332__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__26382__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.empty_QMARK_.call(null,items)){
cljs.compiler.emits.call(null,"cljs.core.PersistentVector.EMPTY");
} else {
var cnt_30334 = cljs.core.count.call(null,items);
if((cnt_30334 < (32))){
cljs.compiler.emits.call(null,"new cljs.core.PersistentVector(null, ",cnt_30334,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",cljs.compiler.comma_sep.call(null,items),"], null)");
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentVector.fromArray([",cljs.compiler.comma_sep.call(null,items),"], true)");
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
return (cljs.core.every_QMARK_.call(null,(function (p1__30335_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__30335_SHARP_),new cljs.core.Keyword(null,"constant","constant",-379609303));
}),items)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,items)),cljs.core.count.call(null,items)));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set","set",304602554),(function (p__30336){
var map__30337 = p__30336;
var map__30337__$1 = ((((!((map__30337 == null)))?((((map__30337.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30337.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30337):map__30337);
var items = cljs.core.get.call(null,map__30337__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__30337__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__26382__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.empty_QMARK_.call(null,items)){
cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_(cljs.compiler.distinct_constants_QMARK_.call(null,items))){
cljs.compiler.emits.call(null,"new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,items),", [",cljs.compiler.comma_sep.call(null,cljs.core.interleave.call(null,items,cljs.core.repeat.call(null,"null"))),"], null), null)");
} else {
cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.fromArray([",cljs.compiler.comma_sep.call(null,items),"], true)");

}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-value","js-value",-758336661),(function (p__30339){
var map__30340 = p__30339;
var map__30340__$1 = ((((!((map__30340 == null)))?((((map__30340.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30340.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30340):map__30340);
var items = cljs.core.get.call(null,map__30340__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var js_type = cljs.core.get.call(null,map__30340__$1,new cljs.core.Keyword(null,"js-type","js-type",539386702));
var env = cljs.core.get.call(null,map__30340__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__26382__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core._EQ_.call(null,js_type,new cljs.core.Keyword(null,"object","object",1474613949))){
cljs.compiler.emits.call(null,"{");

var temp__4425__auto___30350 = cljs.core.seq.call(null,items);
if(temp__4425__auto___30350){
var items_30351__$1 = temp__4425__auto___30350;
var vec__30342_30352 = items_30351__$1;
var vec__30343_30353 = cljs.core.nth.call(null,vec__30342_30352,(0),null);
var k_30354 = cljs.core.nth.call(null,vec__30343_30353,(0),null);
var v_30355 = cljs.core.nth.call(null,vec__30343_30353,(1),null);
var r_30356 = cljs.core.nthnext.call(null,vec__30342_30352,(1));
cljs.compiler.emits.call(null,"\"",cljs.core.name.call(null,k_30354),"\": ",v_30355);

var seq__30344_30357 = cljs.core.seq.call(null,r_30356);
var chunk__30345_30358 = null;
var count__30346_30359 = (0);
var i__30347_30360 = (0);
while(true){
if((i__30347_30360 < count__30346_30359)){
var vec__30348_30361 = cljs.core._nth.call(null,chunk__30345_30358,i__30347_30360);
var k_30362__$1 = cljs.core.nth.call(null,vec__30348_30361,(0),null);
var v_30363__$1 = cljs.core.nth.call(null,vec__30348_30361,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_30362__$1),"\": ",v_30363__$1);

var G__30364 = seq__30344_30357;
var G__30365 = chunk__30345_30358;
var G__30366 = count__30346_30359;
var G__30367 = (i__30347_30360 + (1));
seq__30344_30357 = G__30364;
chunk__30345_30358 = G__30365;
count__30346_30359 = G__30366;
i__30347_30360 = G__30367;
continue;
} else {
var temp__4425__auto___30368__$1 = cljs.core.seq.call(null,seq__30344_30357);
if(temp__4425__auto___30368__$1){
var seq__30344_30369__$1 = temp__4425__auto___30368__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30344_30369__$1)){
var c__19078__auto___30370 = cljs.core.chunk_first.call(null,seq__30344_30369__$1);
var G__30371 = cljs.core.chunk_rest.call(null,seq__30344_30369__$1);
var G__30372 = c__19078__auto___30370;
var G__30373 = cljs.core.count.call(null,c__19078__auto___30370);
var G__30374 = (0);
seq__30344_30357 = G__30371;
chunk__30345_30358 = G__30372;
count__30346_30359 = G__30373;
i__30347_30360 = G__30374;
continue;
} else {
var vec__30349_30375 = cljs.core.first.call(null,seq__30344_30369__$1);
var k_30376__$1 = cljs.core.nth.call(null,vec__30349_30375,(0),null);
var v_30377__$1 = cljs.core.nth.call(null,vec__30349_30375,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_30376__$1),"\": ",v_30377__$1);

var G__30378 = cljs.core.next.call(null,seq__30344_30369__$1);
var G__30379 = null;
var G__30380 = (0);
var G__30381 = (0);
seq__30344_30357 = G__30378;
chunk__30345_30358 = G__30379;
count__30346_30359 = G__30380;
i__30347_30360 = G__30381;
continue;
}
} else {
}
}
break;
}
} else {
}

cljs.compiler.emits.call(null,"}");
} else {
cljs.compiler.emits.call(null,"[",cljs.compiler.comma_sep.call(null,items),"]");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"constant","constant",-379609303),(function (p__30382){
var map__30383 = p__30382;
var map__30383__$1 = ((((!((map__30383 == null)))?((((map__30383.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30383.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30383):map__30383);
var form = cljs.core.get.call(null,map__30383__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.call(null,map__30383__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__26382__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_constant.call(null,form);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(p__30385){
var map__30388 = p__30385;
var map__30388__$1 = ((((!((map__30388 == null)))?((((map__30388.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30388.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30388):map__30388);
var op = cljs.core.get.call(null,map__30388__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__30388__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var and__18263__auto__ = cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"constant","constant",-379609303));
if(and__18263__auto__){
var and__18263__auto____$1 = form;
if(cljs.core.truth_(and__18263__auto____$1)){
return !(((typeof form === 'string') && (cljs.core._EQ_.call(null,form,""))) || ((typeof form === 'number') && ((form === (0)))));
} else {
return and__18263__auto____$1;
}
} else {
return and__18263__auto__;
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(p__30390){
var map__30393 = p__30390;
var map__30393__$1 = ((((!((map__30393 == null)))?((((map__30393.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30393.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30393):map__30393);
var op = cljs.core.get.call(null,map__30393__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__30393__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
return (cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"constant","constant",-379609303))) && ((form === false) || ((form == null)));
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag.call(null,env,e);
var or__18275__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null).call(null,tag);
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_.call(null,e);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__30395){
var map__30396 = p__30395;
var map__30396__$1 = ((((!((map__30396 == null)))?((((map__30396.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30396.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30396):map__30396);
var test = cljs.core.get.call(null,map__30396__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.call(null,map__30396__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.call(null,map__30396__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.call(null,map__30396__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.call(null,map__30396__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not.call(null,(function (){var or__18275__auto__ = unchecked;
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return cljs.compiler.safe_test_QMARK_.call(null,env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,else$);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"(",((checked)?"cljs.core.truth_":null),"(",test,")?",then,":",else$,")");
} else {
if(checked){
cljs.compiler.emitln.call(null,"if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.call(null,"if(",test,"){");
}

cljs.compiler.emitln.call(null,then,"} else {");

return cljs.compiler.emitln.call(null,else$,"}");
}

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"case*","case*",716180697),(function (p__30398){
var map__30399 = p__30398;
var map__30399__$1 = ((((!((map__30399 == null)))?((((map__30399.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30399.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30399):map__30399);
var v = cljs.core.get.call(null,map__30399__$1,new cljs.core.Keyword(null,"v","v",21465059));
var tests = cljs.core.get.call(null,map__30399__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var thens = cljs.core.get.call(null,map__30399__$1,new cljs.core.Keyword(null,"thens","thens",226631442));
var default$ = cljs.core.get.call(null,map__30399__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.call(null,map__30399__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.call(null,"(function(){");
} else {
}

var gs = cljs.core.gensym.call(null,"caseval__");
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"var ",gs,";");
} else {
}

cljs.compiler.emitln.call(null,"switch (",v,") {");

var seq__30401_30415 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),cljs.core.interleave.call(null,tests,thens)));
var chunk__30402_30416 = null;
var count__30403_30417 = (0);
var i__30404_30418 = (0);
while(true){
if((i__30404_30418 < count__30403_30417)){
var vec__30405_30419 = cljs.core._nth.call(null,chunk__30402_30416,i__30404_30418);
var ts_30420 = cljs.core.nth.call(null,vec__30405_30419,(0),null);
var then_30421 = cljs.core.nth.call(null,vec__30405_30419,(1),null);
var seq__30406_30422 = cljs.core.seq.call(null,ts_30420);
var chunk__30407_30423 = null;
var count__30408_30424 = (0);
var i__30409_30425 = (0);
while(true){
if((i__30409_30425 < count__30408_30424)){
var test_30426 = cljs.core._nth.call(null,chunk__30407_30423,i__30409_30425);
cljs.compiler.emitln.call(null,"case ",test_30426,":");

var G__30427 = seq__30406_30422;
var G__30428 = chunk__30407_30423;
var G__30429 = count__30408_30424;
var G__30430 = (i__30409_30425 + (1));
seq__30406_30422 = G__30427;
chunk__30407_30423 = G__30428;
count__30408_30424 = G__30429;
i__30409_30425 = G__30430;
continue;
} else {
var temp__4425__auto___30431 = cljs.core.seq.call(null,seq__30406_30422);
if(temp__4425__auto___30431){
var seq__30406_30432__$1 = temp__4425__auto___30431;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30406_30432__$1)){
var c__19078__auto___30433 = cljs.core.chunk_first.call(null,seq__30406_30432__$1);
var G__30434 = cljs.core.chunk_rest.call(null,seq__30406_30432__$1);
var G__30435 = c__19078__auto___30433;
var G__30436 = cljs.core.count.call(null,c__19078__auto___30433);
var G__30437 = (0);
seq__30406_30422 = G__30434;
chunk__30407_30423 = G__30435;
count__30408_30424 = G__30436;
i__30409_30425 = G__30437;
continue;
} else {
var test_30438 = cljs.core.first.call(null,seq__30406_30432__$1);
cljs.compiler.emitln.call(null,"case ",test_30438,":");

var G__30439 = cljs.core.next.call(null,seq__30406_30432__$1);
var G__30440 = null;
var G__30441 = (0);
var G__30442 = (0);
seq__30406_30422 = G__30439;
chunk__30407_30423 = G__30440;
count__30408_30424 = G__30441;
i__30409_30425 = G__30442;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_30421);
} else {
cljs.compiler.emitln.call(null,then_30421);
}

cljs.compiler.emitln.call(null,"break;");

var G__30443 = seq__30401_30415;
var G__30444 = chunk__30402_30416;
var G__30445 = count__30403_30417;
var G__30446 = (i__30404_30418 + (1));
seq__30401_30415 = G__30443;
chunk__30402_30416 = G__30444;
count__30403_30417 = G__30445;
i__30404_30418 = G__30446;
continue;
} else {
var temp__4425__auto___30447 = cljs.core.seq.call(null,seq__30401_30415);
if(temp__4425__auto___30447){
var seq__30401_30448__$1 = temp__4425__auto___30447;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30401_30448__$1)){
var c__19078__auto___30449 = cljs.core.chunk_first.call(null,seq__30401_30448__$1);
var G__30450 = cljs.core.chunk_rest.call(null,seq__30401_30448__$1);
var G__30451 = c__19078__auto___30449;
var G__30452 = cljs.core.count.call(null,c__19078__auto___30449);
var G__30453 = (0);
seq__30401_30415 = G__30450;
chunk__30402_30416 = G__30451;
count__30403_30417 = G__30452;
i__30404_30418 = G__30453;
continue;
} else {
var vec__30410_30454 = cljs.core.first.call(null,seq__30401_30448__$1);
var ts_30455 = cljs.core.nth.call(null,vec__30410_30454,(0),null);
var then_30456 = cljs.core.nth.call(null,vec__30410_30454,(1),null);
var seq__30411_30457 = cljs.core.seq.call(null,ts_30455);
var chunk__30412_30458 = null;
var count__30413_30459 = (0);
var i__30414_30460 = (0);
while(true){
if((i__30414_30460 < count__30413_30459)){
var test_30461 = cljs.core._nth.call(null,chunk__30412_30458,i__30414_30460);
cljs.compiler.emitln.call(null,"case ",test_30461,":");

var G__30462 = seq__30411_30457;
var G__30463 = chunk__30412_30458;
var G__30464 = count__30413_30459;
var G__30465 = (i__30414_30460 + (1));
seq__30411_30457 = G__30462;
chunk__30412_30458 = G__30463;
count__30413_30459 = G__30464;
i__30414_30460 = G__30465;
continue;
} else {
var temp__4425__auto___30466__$1 = cljs.core.seq.call(null,seq__30411_30457);
if(temp__4425__auto___30466__$1){
var seq__30411_30467__$1 = temp__4425__auto___30466__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30411_30467__$1)){
var c__19078__auto___30468 = cljs.core.chunk_first.call(null,seq__30411_30467__$1);
var G__30469 = cljs.core.chunk_rest.call(null,seq__30411_30467__$1);
var G__30470 = c__19078__auto___30468;
var G__30471 = cljs.core.count.call(null,c__19078__auto___30468);
var G__30472 = (0);
seq__30411_30457 = G__30469;
chunk__30412_30458 = G__30470;
count__30413_30459 = G__30471;
i__30414_30460 = G__30472;
continue;
} else {
var test_30473 = cljs.core.first.call(null,seq__30411_30467__$1);
cljs.compiler.emitln.call(null,"case ",test_30473,":");

var G__30474 = cljs.core.next.call(null,seq__30411_30467__$1);
var G__30475 = null;
var G__30476 = (0);
var G__30477 = (0);
seq__30411_30457 = G__30474;
chunk__30412_30458 = G__30475;
count__30413_30459 = G__30476;
i__30414_30460 = G__30477;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_30456);
} else {
cljs.compiler.emitln.call(null,then_30456);
}

cljs.compiler.emitln.call(null,"break;");

var G__30478 = cljs.core.next.call(null,seq__30401_30448__$1);
var G__30479 = null;
var G__30480 = (0);
var G__30481 = (0);
seq__30401_30415 = G__30478;
chunk__30402_30416 = G__30479;
count__30403_30417 = G__30480;
i__30404_30418 = G__30481;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.call(null,"default:");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",default$);
} else {
cljs.compiler.emitln.call(null,default$);
}
} else {
}

cljs.compiler.emitln.call(null,"}");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"return ",gs,";})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__30482){
var map__30483 = p__30482;
var map__30483__$1 = ((((!((map__30483 == null)))?((((map__30483.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30483.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30483):map__30483);
var throw$ = cljs.core.get.call(null,map__30483__$1,new cljs.core.Keyword(null,"throw","throw",-1044625833));
var env = cljs.core.get.call(null,map__30483__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.call(null,"(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.call(null,"throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.mapped_types,t))){
return cljs.core.get.call(null,cljs.compiler.mapped_types,t);
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"!"))){
return [cljs.core.str("!"),cljs.core.str(cljs$compiler$resolve_type.call(null,env,cljs.core.subs.call(null,t,(1))))].join('');
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"{"))){
return t;
} else {
if(cljs.core.truth_(goog.string.startsWith(t,"function"))){
var idx = t.lastIndexOf(":");
var vec__30488 = ((!(((-1) === idx)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.call(null,t,(0),idx),cljs.core.subs.call(null,t,(idx + (1)),cljs.core.count.call(null,t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.call(null,vec__30488,(0),null);
var rstr = cljs.core.nth.call(null,vec__30488,(1),null);
var ret_t = (cljs.core.truth_(rstr)?cljs$compiler$resolve_type.call(null,env,rstr):null);
var axstr = cljs.core.subs.call(null,fstr,(9),(cljs.core.count.call(null,fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_.call(null,axstr))?null:cljs.core.map.call(null,cljs.core.comp.call(null,((function (idx,vec__30488,fstr,rstr,ret_t,axstr){
return (function (p1__30485_SHARP_){
return cljs$compiler$resolve_type.call(null,env,p1__30485_SHARP_);
});})(idx,vec__30488,fstr,rstr,ret_t,axstr))
,clojure.string.trim),clojure.string.split.call(null,axstr,/,/)));
var G__30489 = [cljs.core.str("function("),cljs.core.str(clojure.string.join.call(null,",",args_ts)),cljs.core.str(")")].join('');
var G__30489__$1 = (cljs.core.truth_(ret_t)?[cljs.core.str(G__30489),cljs.core.str(":"),cljs.core.str(ret_t)].join(''):G__30489);
return G__30489__$1;
} else {
if(cljs.core.truth_(goog.string.endsWith(t,"="))){
return [cljs.core.str(cljs$compiler$resolve_type.call(null,env,cljs.core.subs.call(null,t,(0),(cljs.core.count.call(null,t) - (1))))),cljs.core.str("=")].join('');
} else {
return cljs.compiler.munge.call(null,[cljs.core.str(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,env,cljs.core.symbol.call(null,t))))].join(''));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.call(null,clojure.string.trim.call(null,ts),(1),(cljs.core.count.call(null,ts) - (1)));
var xs = clojure.string.split.call(null,ts__$1,/\|/);
return [cljs.core.str("{"),cljs.core.str(clojure.string.join.call(null,"|",cljs.core.map.call(null,((function (ts__$1,xs){
return (function (p1__30490_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__30490_SHARP_);
});})(ts__$1,xs))
,xs))),cljs.core.str("}")].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find.call(null,/@param/,line))){
var vec__30493 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var p = cljs.core.nth.call(null,vec__30493,(0),null);
var ts = cljs.core.nth.call(null,vec__30493,(1),null);
var n = cljs.core.nth.call(null,vec__30493,(2),null);
var xs = cljs.core.nthnext.call(null,vec__30493,(3));
if(cljs.core.truth_((function (){var and__18263__auto__ = cljs.core._EQ_.call(null,"@param",p);
if(and__18263__auto__){
var and__18263__auto____$1 = ts;
if(cljs.core.truth_(and__18263__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__18263__auto____$1;
}
} else {
return and__18263__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts),cljs.compiler.munge.call(null,n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find.call(null,/@return/,line))){
var vec__30494 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var p = cljs.core.nth.call(null,vec__30494,(0),null);
var ts = cljs.core.nth.call(null,vec__30494,(1),null);
var xs = cljs.core.nthnext.call(null,vec__30494,(2));
if(cljs.core.truth_((function (){var and__18263__auto__ = cljs.core._EQ_.call(null,"@return",p);
if(and__18263__auto__){
var and__18263__auto____$1 = ts;
if(cljs.core.truth_(and__18263__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__18263__auto____$1;
}
} else {
return and__18263__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warn","warn",-436710552),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null).call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null)));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var args30496 = [];
var len__19333__auto___30523 = arguments.length;
var i__19334__auto___30524 = (0);
while(true){
if((i__19334__auto___30524 < len__19333__auto___30523)){
args30496.push((arguments[i__19334__auto___30524]));

var G__30525 = (i__19334__auto___30524 + (1));
i__19334__auto___30524 = G__30525;
continue;
} else {
}
break;
}

var G__30498 = args30496.length;
switch (G__30498) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30496.length)].join('')));

}
});

cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.call(null,null,doc,jsdoc);
});

cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.call(null,docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = ((function (docs,docs__$1,docs__$2){
return (function cljs$compiler$print_comment_lines(e){
var vec__30514 = cljs.core.map.call(null,((function (docs,docs__$1,docs__$2){
return (function (p1__30495_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_.call(null))){
return cljs.compiler.munge_param_return.call(null,env,p1__30495_SHARP_);
} else {
return p1__30495_SHARP_;
}
});})(docs,docs__$1,docs__$2))
,clojure.string.split_lines.call(null,e));
var x = cljs.core.nth.call(null,vec__30514,(0),null);
var ys = cljs.core.nthnext.call(null,vec__30514,(1));
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,x,"*/","* /"));

var seq__30515 = cljs.core.seq.call(null,ys);
var chunk__30516 = null;
var count__30517 = (0);
var i__30518 = (0);
while(true){
if((i__30518 < count__30517)){
var next_line = cljs.core._nth.call(null,chunk__30516,i__30518);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));

var G__30527 = seq__30515;
var G__30528 = chunk__30516;
var G__30529 = count__30517;
var G__30530 = (i__30518 + (1));
seq__30515 = G__30527;
chunk__30516 = G__30528;
count__30517 = G__30529;
i__30518 = G__30530;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__30515);
if(temp__4425__auto__){
var seq__30515__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30515__$1)){
var c__19078__auto__ = cljs.core.chunk_first.call(null,seq__30515__$1);
var G__30531 = cljs.core.chunk_rest.call(null,seq__30515__$1);
var G__30532 = c__19078__auto__;
var G__30533 = cljs.core.count.call(null,c__19078__auto__);
var G__30534 = (0);
seq__30515 = G__30531;
chunk__30516 = G__30532;
count__30517 = G__30533;
i__30518 = G__30534;
continue;
} else {
var next_line = cljs.core.first.call(null,seq__30515__$1);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));

var G__30535 = cljs.core.next.call(null,seq__30515__$1);
var G__30536 = null;
var G__30537 = (0);
var G__30538 = (0);
seq__30515 = G__30535;
chunk__30516 = G__30536;
count__30517 = G__30537;
i__30518 = G__30538;
continue;
}
} else {
return null;
}
}
break;
}
});})(docs,docs__$1,docs__$2))
;
if(cljs.core.seq.call(null,docs__$2)){
cljs.compiler.emitln.call(null,"/**");

var seq__30519_30539 = cljs.core.seq.call(null,docs__$2);
var chunk__30520_30540 = null;
var count__30521_30541 = (0);
var i__30522_30542 = (0);
while(true){
if((i__30522_30542 < count__30521_30541)){
var e_30543 = cljs.core._nth.call(null,chunk__30520_30540,i__30522_30542);
if(cljs.core.truth_(e_30543)){
print_comment_lines.call(null,e_30543);
} else {
}

var G__30544 = seq__30519_30539;
var G__30545 = chunk__30520_30540;
var G__30546 = count__30521_30541;
var G__30547 = (i__30522_30542 + (1));
seq__30519_30539 = G__30544;
chunk__30520_30540 = G__30545;
count__30521_30541 = G__30546;
i__30522_30542 = G__30547;
continue;
} else {
var temp__4425__auto___30548 = cljs.core.seq.call(null,seq__30519_30539);
if(temp__4425__auto___30548){
var seq__30519_30549__$1 = temp__4425__auto___30548;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30519_30549__$1)){
var c__19078__auto___30550 = cljs.core.chunk_first.call(null,seq__30519_30549__$1);
var G__30551 = cljs.core.chunk_rest.call(null,seq__30519_30549__$1);
var G__30552 = c__19078__auto___30550;
var G__30553 = cljs.core.count.call(null,c__19078__auto___30550);
var G__30554 = (0);
seq__30519_30539 = G__30551;
chunk__30520_30540 = G__30552;
count__30521_30541 = G__30553;
i__30522_30542 = G__30554;
continue;
} else {
var e_30555 = cljs.core.first.call(null,seq__30519_30549__$1);
if(cljs.core.truth_(e_30555)){
print_comment_lines.call(null,e_30555);
} else {
}

var G__30556 = cljs.core.next.call(null,seq__30519_30549__$1);
var G__30557 = null;
var G__30558 = (0);
var G__30559 = (0);
seq__30519_30539 = G__30556;
chunk__30520_30540 = G__30557;
count__30521_30541 = G__30558;
i__30522_30542 = G__30559;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.call(null," */");
} else {
return null;
}
});

cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3;
cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return (typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number');
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__18263__auto__ = cljs.core.some.call(null,((function (opts){
return (function (p1__30561_SHARP_){
return goog.string.startsWith(p1__30561_SHARP_,"@define");
});})(opts))
,jsdoc);
if(cljs.core.truth_(and__18263__auto__)){
var and__18263__auto____$1 = opts;
if(cljs.core.truth_(and__18263__auto____$1)){
var and__18263__auto____$2 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478));
if(and__18263__auto____$2){
var define = cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),[cljs.core.str(mname)].join('')], null));
if(cljs.core.truth_(cljs.compiler.valid_define_value_QMARK_.call(null,define))){
return cljs.core.pr_str.call(null,define);
} else {
return null;
}
} else {
return and__18263__auto____$2;
}
} else {
return and__18263__auto____$1;
}
} else {
return and__18263__auto__;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__30562){
var map__30563 = p__30562;
var map__30563__$1 = ((((!((map__30563 == null)))?((((map__30563.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30563.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30563):map__30563);
var name = cljs.core.get.call(null,map__30563__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var var$ = cljs.core.get.call(null,map__30563__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var init = cljs.core.get.call(null,map__30563__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var env = cljs.core.get.call(null,map__30563__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var doc = cljs.core.get.call(null,map__30563__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.call(null,map__30563__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var export$ = cljs.core.get.call(null,map__30563__$1,new cljs.core.Keyword(null,"export","export",214356590));
var test = cljs.core.get.call(null,map__30563__$1,new cljs.core.Keyword(null,"test","test",577538877));
var var_ast = cljs.core.get.call(null,map__30563__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__18275__auto__ = init;
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.call(null,name);
cljs.compiler.emit_comment.call(null,env,doc,cljs.core.concat.call(null,jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"return (");
} else {
}

cljs.compiler.emitln.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.call(null," = ",(function (){var temp__4423__auto__ = cljs.compiler.get_define.call(null,mname,jsdoc);
if(cljs.core.truth_(temp__4423__auto__)){
var define = temp__4423__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"; return (");

cljs.compiler.emits.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"var-special","var-special",1131576802),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast));

cljs.compiler.emitln.call(null,");})()");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,")");
} else {
}
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.call(null,";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.call(null,"goog.exportSymbol('",cljs.compiler.munge.call(null,export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__18263__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__18263__auto__)){
return test;
} else {
return and__18263__auto__;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,";");
} else {
}

return cljs.compiler.emitln.call(null,var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__30565){
var map__30582 = p__30565;
var map__30582__$1 = ((((!((map__30582 == null)))?((((map__30582.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30582.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30582):map__30582);
var name = cljs.core.get.call(null,map__30582__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__30582__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__30582__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.call(null,"arglist__");
var delegate_name = [cljs.core.str(cljs.compiler.munge.call(null,name)),cljs.core.str("__delegate")].join('');
cljs.compiler.emitln.call(null,"(function (",arglist,"){");

var seq__30584_30598 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,cljs.core.vector,cljs.core.drop_last.call(null,(2),params)));
var chunk__30585_30599 = null;
var count__30586_30600 = (0);
var i__30587_30601 = (0);
while(true){
if((i__30587_30601 < count__30586_30600)){
var vec__30588_30602 = cljs.core._nth.call(null,chunk__30585_30599,i__30587_30601);
var i_30603 = cljs.core.nth.call(null,vec__30588_30602,(0),null);
var param_30604 = cljs.core.nth.call(null,vec__30588_30602,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_30604);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");

var G__30605 = seq__30584_30598;
var G__30606 = chunk__30585_30599;
var G__30607 = count__30586_30600;
var G__30608 = (i__30587_30601 + (1));
seq__30584_30598 = G__30605;
chunk__30585_30599 = G__30606;
count__30586_30600 = G__30607;
i__30587_30601 = G__30608;
continue;
} else {
var temp__4425__auto___30609 = cljs.core.seq.call(null,seq__30584_30598);
if(temp__4425__auto___30609){
var seq__30584_30610__$1 = temp__4425__auto___30609;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30584_30610__$1)){
var c__19078__auto___30611 = cljs.core.chunk_first.call(null,seq__30584_30610__$1);
var G__30612 = cljs.core.chunk_rest.call(null,seq__30584_30610__$1);
var G__30613 = c__19078__auto___30611;
var G__30614 = cljs.core.count.call(null,c__19078__auto___30611);
var G__30615 = (0);
seq__30584_30598 = G__30612;
chunk__30585_30599 = G__30613;
count__30586_30600 = G__30614;
i__30587_30601 = G__30615;
continue;
} else {
var vec__30589_30616 = cljs.core.first.call(null,seq__30584_30610__$1);
var i_30617 = cljs.core.nth.call(null,vec__30589_30616,(0),null);
var param_30618 = cljs.core.nth.call(null,vec__30589_30616,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_30618);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");

var G__30619 = cljs.core.next.call(null,seq__30584_30610__$1);
var G__30620 = null;
var G__30621 = (0);
var G__30622 = (0);
seq__30584_30598 = G__30619;
chunk__30585_30599 = G__30620;
count__30586_30600 = G__30621;
i__30587_30601 = G__30622;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count.call(null,params))){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,cljs.core.butlast.call(null,params)));

cljs.compiler.emitln.call(null," = cljs.core.first(",arglist,");");

cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.rest(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__30590_30623 = cljs.core.seq.call(null,params);
var chunk__30591_30624 = null;
var count__30592_30625 = (0);
var i__30593_30626 = (0);
while(true){
if((i__30593_30626 < count__30592_30625)){
var param_30627 = cljs.core._nth.call(null,chunk__30591_30624,i__30593_30626);
cljs.compiler.emit.call(null,param_30627);

if(cljs.core._EQ_.call(null,param_30627,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__30628 = seq__30590_30623;
var G__30629 = chunk__30591_30624;
var G__30630 = count__30592_30625;
var G__30631 = (i__30593_30626 + (1));
seq__30590_30623 = G__30628;
chunk__30591_30624 = G__30629;
count__30592_30625 = G__30630;
i__30593_30626 = G__30631;
continue;
} else {
var temp__4425__auto___30632 = cljs.core.seq.call(null,seq__30590_30623);
if(temp__4425__auto___30632){
var seq__30590_30633__$1 = temp__4425__auto___30632;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30590_30633__$1)){
var c__19078__auto___30634 = cljs.core.chunk_first.call(null,seq__30590_30633__$1);
var G__30635 = cljs.core.chunk_rest.call(null,seq__30590_30633__$1);
var G__30636 = c__19078__auto___30634;
var G__30637 = cljs.core.count.call(null,c__19078__auto___30634);
var G__30638 = (0);
seq__30590_30623 = G__30635;
chunk__30591_30624 = G__30636;
count__30592_30625 = G__30637;
i__30593_30626 = G__30638;
continue;
} else {
var param_30639 = cljs.core.first.call(null,seq__30590_30633__$1);
cljs.compiler.emit.call(null,param_30639);

if(cljs.core._EQ_.call(null,param_30639,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__30640 = cljs.core.next.call(null,seq__30590_30633__$1);
var G__30641 = null;
var G__30642 = (0);
var G__30643 = (0);
seq__30590_30623 = G__30640;
chunk__30591_30624 = G__30641;
count__30592_30625 = G__30642;
i__30593_30626 = G__30643;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
} else {
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.seq(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__30594_30644 = cljs.core.seq.call(null,params);
var chunk__30595_30645 = null;
var count__30596_30646 = (0);
var i__30597_30647 = (0);
while(true){
if((i__30597_30647 < count__30596_30646)){
var param_30648 = cljs.core._nth.call(null,chunk__30595_30645,i__30597_30647);
cljs.compiler.emit.call(null,param_30648);

if(cljs.core._EQ_.call(null,param_30648,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__30649 = seq__30594_30644;
var G__30650 = chunk__30595_30645;
var G__30651 = count__30596_30646;
var G__30652 = (i__30597_30647 + (1));
seq__30594_30644 = G__30649;
chunk__30595_30645 = G__30650;
count__30596_30646 = G__30651;
i__30597_30647 = G__30652;
continue;
} else {
var temp__4425__auto___30653 = cljs.core.seq.call(null,seq__30594_30644);
if(temp__4425__auto___30653){
var seq__30594_30654__$1 = temp__4425__auto___30653;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30594_30654__$1)){
var c__19078__auto___30655 = cljs.core.chunk_first.call(null,seq__30594_30654__$1);
var G__30656 = cljs.core.chunk_rest.call(null,seq__30594_30654__$1);
var G__30657 = c__19078__auto___30655;
var G__30658 = cljs.core.count.call(null,c__19078__auto___30655);
var G__30659 = (0);
seq__30594_30644 = G__30656;
chunk__30595_30645 = G__30657;
count__30596_30646 = G__30658;
i__30597_30647 = G__30659;
continue;
} else {
var param_30660 = cljs.core.first.call(null,seq__30594_30654__$1);
cljs.compiler.emit.call(null,param_30660);

if(cljs.core._EQ_.call(null,param_30660,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__30661 = cljs.core.next.call(null,seq__30594_30654__$1);
var G__30662 = null;
var G__30663 = (0);
var G__30664 = (0);
seq__30594_30644 = G__30661;
chunk__30595_30645 = G__30662;
count__30596_30646 = G__30663;
i__30597_30647 = G__30664;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__30669 = cljs.core.seq.call(null,params);
var chunk__30670 = null;
var count__30671 = (0);
var i__30672 = (0);
while(true){
if((i__30672 < count__30671)){
var param = cljs.core._nth.call(null,chunk__30670,i__30672);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__30673 = seq__30669;
var G__30674 = chunk__30670;
var G__30675 = count__30671;
var G__30676 = (i__30672 + (1));
seq__30669 = G__30673;
chunk__30670 = G__30674;
count__30671 = G__30675;
i__30672 = G__30676;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__30669);
if(temp__4425__auto__){
var seq__30669__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30669__$1)){
var c__19078__auto__ = cljs.core.chunk_first.call(null,seq__30669__$1);
var G__30677 = cljs.core.chunk_rest.call(null,seq__30669__$1);
var G__30678 = c__19078__auto__;
var G__30679 = cljs.core.count.call(null,c__19078__auto__);
var G__30680 = (0);
seq__30669 = G__30677;
chunk__30670 = G__30678;
count__30671 = G__30679;
i__30672 = G__30680;
continue;
} else {
var param = cljs.core.first.call(null,seq__30669__$1);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__30681 = cljs.core.next.call(null,seq__30669__$1);
var G__30682 = null;
var G__30683 = (0);
var G__30684 = (0);
seq__30669 = G__30681;
chunk__30670 = G__30682;
count__30671 = G__30683;
i__30672 = G__30684;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__30685){
var map__30688 = p__30685;
var map__30688__$1 = ((((!((map__30688 == null)))?((((map__30688.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30688.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30688):map__30688);
var type = cljs.core.get.call(null,map__30688__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__30688__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var variadic = cljs.core.get.call(null,map__30688__$1,new cljs.core.Keyword(null,"variadic","variadic",882626057));
var params = cljs.core.get.call(null,map__30688__$1,new cljs.core.Keyword(null,"params","params",710516235));
var expr = cljs.core.get.call(null,map__30688__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__30688__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__30688__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var max_fixed_arity = cljs.core.get.call(null,map__30688__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var env__26382__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(function ",cljs.compiler.munge.call(null,name),"(");

cljs.compiler.emit_fn_params.call(null,params);

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emits.call(null,"})");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if(((startslice >= (0))) && (cljs.core.integer_QMARK_.call(null,startslice))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"and","and",668631710,null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"startslice","startslice",1404029423,null),(0)),cljs.core.list(new cljs.core.Symbol(null,"integer?","integer?",1303791671,null),new cljs.core.Symbol(null,"startslice","startslice",1404029423,null)))))].join('')));
}

var mname = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
var i = [cljs.core.str(mname),cljs.core.str("__i")].join('');
var a = [cljs.core.str(mname),cljs.core.str("__a")].join('');
cljs.compiler.emitln.call(null,"var ",i," = 0, ",a," = new Array(arguments.length -  ",startslice,");");

cljs.compiler.emitln.call(null,"while (",i," < ",a,".length) {",a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}");

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__30690){
var map__30701 = p__30690;
var map__30701__$1 = ((((!((map__30701 == null)))?((((map__30701.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30701.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30701):map__30701);
var f = map__30701__$1;
var type = cljs.core.get.call(null,map__30701__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__30701__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var variadic = cljs.core.get.call(null,map__30701__$1,new cljs.core.Keyword(null,"variadic","variadic",882626057));
var params = cljs.core.get.call(null,map__30701__$1,new cljs.core.Keyword(null,"params","params",710516235));
var expr = cljs.core.get.call(null,map__30701__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__30701__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__30701__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var max_fixed_arity = cljs.core.get.call(null,map__30701__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var env__26382__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var name_30711__$1 = (function (){var or__18275__auto__ = name;
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_30712 = cljs.compiler.munge.call(null,name_30711__$1);
var delegate_name_30713 = [cljs.core.str(mname_30712),cljs.core.str("__delegate")].join('');
cljs.compiler.emitln.call(null,"(function() { ");

cljs.compiler.emits.call(null,"var ",delegate_name_30713," = function (");

var seq__30703_30714 = cljs.core.seq.call(null,params);
var chunk__30704_30715 = null;
var count__30705_30716 = (0);
var i__30706_30717 = (0);
while(true){
if((i__30706_30717 < count__30705_30716)){
var param_30718 = cljs.core._nth.call(null,chunk__30704_30715,i__30706_30717);
cljs.compiler.emit.call(null,param_30718);

if(cljs.core._EQ_.call(null,param_30718,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__30719 = seq__30703_30714;
var G__30720 = chunk__30704_30715;
var G__30721 = count__30705_30716;
var G__30722 = (i__30706_30717 + (1));
seq__30703_30714 = G__30719;
chunk__30704_30715 = G__30720;
count__30705_30716 = G__30721;
i__30706_30717 = G__30722;
continue;
} else {
var temp__4425__auto___30723 = cljs.core.seq.call(null,seq__30703_30714);
if(temp__4425__auto___30723){
var seq__30703_30724__$1 = temp__4425__auto___30723;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30703_30724__$1)){
var c__19078__auto___30725 = cljs.core.chunk_first.call(null,seq__30703_30724__$1);
var G__30726 = cljs.core.chunk_rest.call(null,seq__30703_30724__$1);
var G__30727 = c__19078__auto___30725;
var G__30728 = cljs.core.count.call(null,c__19078__auto___30725);
var G__30729 = (0);
seq__30703_30714 = G__30726;
chunk__30704_30715 = G__30727;
count__30705_30716 = G__30728;
i__30706_30717 = G__30729;
continue;
} else {
var param_30730 = cljs.core.first.call(null,seq__30703_30724__$1);
cljs.compiler.emit.call(null,param_30730);

if(cljs.core._EQ_.call(null,param_30730,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__30731 = cljs.core.next.call(null,seq__30703_30724__$1);
var G__30732 = null;
var G__30733 = (0);
var G__30734 = (0);
seq__30703_30714 = G__30731;
chunk__30704_30715 = G__30732;
count__30705_30716 = G__30733;
i__30706_30717 = G__30734;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,"var ",mname_30712," = function (",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",(cljs.core.count.call(null,params) - (1)),") {");

var a_30735 = cljs.compiler.emit_arguments_to_array.call(null,(cljs.core.count.call(null,params) - (1)));
cljs.compiler.emitln.call(null,"  ",cljs.core.last.call(null,params)," = new cljs.core.IndexedSeq(",a_30735,",0);");

cljs.compiler.emitln.call(null,"} ");
} else {
}

cljs.compiler.emits.call(null,"return ",delegate_name_30713,".call(this,");

var seq__30707_30736 = cljs.core.seq.call(null,params);
var chunk__30708_30737 = null;
var count__30709_30738 = (0);
var i__30710_30739 = (0);
while(true){
if((i__30710_30739 < count__30709_30738)){
var param_30740 = cljs.core._nth.call(null,chunk__30708_30737,i__30710_30739);
cljs.compiler.emit.call(null,param_30740);

if(cljs.core._EQ_.call(null,param_30740,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__30741 = seq__30707_30736;
var G__30742 = chunk__30708_30737;
var G__30743 = count__30709_30738;
var G__30744 = (i__30710_30739 + (1));
seq__30707_30736 = G__30741;
chunk__30708_30737 = G__30742;
count__30709_30738 = G__30743;
i__30710_30739 = G__30744;
continue;
} else {
var temp__4425__auto___30745 = cljs.core.seq.call(null,seq__30707_30736);
if(temp__4425__auto___30745){
var seq__30707_30746__$1 = temp__4425__auto___30745;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30707_30746__$1)){
var c__19078__auto___30747 = cljs.core.chunk_first.call(null,seq__30707_30746__$1);
var G__30748 = cljs.core.chunk_rest.call(null,seq__30707_30746__$1);
var G__30749 = c__19078__auto___30747;
var G__30750 = cljs.core.count.call(null,c__19078__auto___30747);
var G__30751 = (0);
seq__30707_30736 = G__30748;
chunk__30708_30737 = G__30749;
count__30709_30738 = G__30750;
i__30710_30739 = G__30751;
continue;
} else {
var param_30752 = cljs.core.first.call(null,seq__30707_30746__$1);
cljs.compiler.emit.call(null,param_30752);

if(cljs.core._EQ_.call(null,param_30752,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}

var G__30753 = cljs.core.next.call(null,seq__30707_30746__$1);
var G__30754 = null;
var G__30755 = (0);
var G__30756 = (0);
seq__30707_30736 = G__30753;
chunk__30708_30737 = G__30754;
count__30709_30738 = G__30755;
i__30710_30739 = G__30756;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,");");

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,mname_30712,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.call(null,mname_30712,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to.call(null,cljs.core.assoc.call(null,f,new cljs.core.Keyword(null,"name","name",1843675177),name_30711__$1));

cljs.compiler.emitln.call(null,";");

cljs.compiler.emitln.call(null,mname_30712,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_30713,";");

cljs.compiler.emitln.call(null,"return ",mname_30712,";");

cljs.compiler.emitln.call(null,"})()");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__30760){
var map__30761 = p__30760;
var map__30761__$1 = ((((!((map__30761 == null)))?((((map__30761.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30761.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30761):map__30761);
var name = cljs.core.get.call(null,map__30761__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__30761__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.call(null,map__30761__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.call(null,map__30761__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var variadic = cljs.core.get.call(null,map__30761__$1,new cljs.core.Keyword(null,"variadic","variadic",882626057));
var recur_frames = cljs.core.get.call(null,map__30761__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var loop_lets = cljs.core.get.call(null,map__30761__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var loop_locals = cljs.core.seq.call(null,cljs.core.map.call(null,cljs.compiler.munge,cljs.core.concat.call(null,cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.filter.call(null,((function (map__30761,map__30761__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (p1__30757_SHARP_){
var and__18263__auto__ = p1__30757_SHARP_;
if(cljs.core.truth_(and__18263__auto__)){
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__30757_SHARP_));
} else {
return and__18263__auto__;
}
});})(map__30761,map__30761__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,recur_frames)),cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),loop_lets))));
if(loop_locals){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"((function (",cljs.compiler.comma_sep.call(null,cljs.core.map.call(null,cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.call(null,"return ");
}
} else {
}

if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_30782__$1 = (function (){var or__18275__auto__ = name;
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_30783 = cljs.compiler.munge.call(null,name_30782__$1);
var maxparams_30784 = cljs.core.apply.call(null,cljs.core.max_key,cljs.core.count,cljs.core.map.call(null,new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_30785 = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (name_30782__$1,mname_30783,maxparams_30784,loop_locals,map__30761,map__30761__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.call(null,cljs.core.symbol.call(null,[cljs.core.str(mname_30783),cljs.core.str("__"),cljs.core.str(cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
});})(name_30782__$1,mname_30783,maxparams_30784,loop_locals,map__30761,map__30761__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,methods$));
var ms_30786 = cljs.core.sort_by.call(null,((function (name_30782__$1,mname_30783,maxparams_30784,mmap_30785,loop_locals,map__30761,map__30761__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (p1__30758_SHARP_){
return cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,p1__30758_SHARP_)));
});})(name_30782__$1,mname_30783,maxparams_30784,mmap_30785,loop_locals,map__30761,map__30761__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,cljs.core.seq.call(null,mmap_30785));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"(function() {");

cljs.compiler.emitln.call(null,"var ",mname_30783," = null;");

var seq__30763_30787 = cljs.core.seq.call(null,ms_30786);
var chunk__30764_30788 = null;
var count__30765_30789 = (0);
var i__30766_30790 = (0);
while(true){
if((i__30766_30790 < count__30765_30789)){
var vec__30767_30791 = cljs.core._nth.call(null,chunk__30764_30788,i__30766_30790);
var n_30792 = cljs.core.nth.call(null,vec__30767_30791,(0),null);
var meth_30793 = cljs.core.nth.call(null,vec__30767_30791,(1),null);
cljs.compiler.emits.call(null,"var ",n_30792," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_30793))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_30793);
} else {
cljs.compiler.emit_fn_method.call(null,meth_30793);
}

cljs.compiler.emitln.call(null,";");

var G__30794 = seq__30763_30787;
var G__30795 = chunk__30764_30788;
var G__30796 = count__30765_30789;
var G__30797 = (i__30766_30790 + (1));
seq__30763_30787 = G__30794;
chunk__30764_30788 = G__30795;
count__30765_30789 = G__30796;
i__30766_30790 = G__30797;
continue;
} else {
var temp__4425__auto___30798 = cljs.core.seq.call(null,seq__30763_30787);
if(temp__4425__auto___30798){
var seq__30763_30799__$1 = temp__4425__auto___30798;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30763_30799__$1)){
var c__19078__auto___30800 = cljs.core.chunk_first.call(null,seq__30763_30799__$1);
var G__30801 = cljs.core.chunk_rest.call(null,seq__30763_30799__$1);
var G__30802 = c__19078__auto___30800;
var G__30803 = cljs.core.count.call(null,c__19078__auto___30800);
var G__30804 = (0);
seq__30763_30787 = G__30801;
chunk__30764_30788 = G__30802;
count__30765_30789 = G__30803;
i__30766_30790 = G__30804;
continue;
} else {
var vec__30768_30805 = cljs.core.first.call(null,seq__30763_30799__$1);
var n_30806 = cljs.core.nth.call(null,vec__30768_30805,(0),null);
var meth_30807 = cljs.core.nth.call(null,vec__30768_30805,(1),null);
cljs.compiler.emits.call(null,"var ",n_30806," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_30807))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_30807);
} else {
cljs.compiler.emit_fn_method.call(null,meth_30807);
}

cljs.compiler.emitln.call(null,";");

var G__30808 = cljs.core.next.call(null,seq__30763_30799__$1);
var G__30809 = null;
var G__30810 = (0);
var G__30811 = (0);
seq__30763_30787 = G__30808;
chunk__30764_30788 = G__30809;
count__30765_30789 = G__30810;
i__30766_30790 = G__30811;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,mname_30783," = function(",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,maxparams_30784),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_30784)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,maxparams_30784));

cljs.compiler.emitln.call(null," = var_args;");
} else {
}

cljs.compiler.emitln.call(null,"switch(arguments.length){");

var seq__30769_30812 = cljs.core.seq.call(null,ms_30786);
var chunk__30770_30813 = null;
var count__30771_30814 = (0);
var i__30772_30815 = (0);
while(true){
if((i__30772_30815 < count__30771_30814)){
var vec__30773_30816 = cljs.core._nth.call(null,chunk__30770_30813,i__30772_30815);
var n_30817 = cljs.core.nth.call(null,vec__30773_30816,(0),null);
var meth_30818 = cljs.core.nth.call(null,vec__30773_30816,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_30818))){
cljs.compiler.emitln.call(null,"default:");

var restarg_30819 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_30819," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_30820 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_30819," = new cljs.core.IndexedSeq(",a_30820,",0);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_30817,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_30784)),(((cljs.core.count.call(null,maxparams_30784) > (1)))?", ":null),restarg_30819,");");
} else {
var pcnt_30821 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_30818));
cljs.compiler.emitln.call(null,"case ",pcnt_30821,":");

cljs.compiler.emitln.call(null,"return ",n_30817,".call(this",(((pcnt_30821 === (0)))?null:cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_30821,maxparams_30784))),",")),");");
}

var G__30822 = seq__30769_30812;
var G__30823 = chunk__30770_30813;
var G__30824 = count__30771_30814;
var G__30825 = (i__30772_30815 + (1));
seq__30769_30812 = G__30822;
chunk__30770_30813 = G__30823;
count__30771_30814 = G__30824;
i__30772_30815 = G__30825;
continue;
} else {
var temp__4425__auto___30826 = cljs.core.seq.call(null,seq__30769_30812);
if(temp__4425__auto___30826){
var seq__30769_30827__$1 = temp__4425__auto___30826;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30769_30827__$1)){
var c__19078__auto___30828 = cljs.core.chunk_first.call(null,seq__30769_30827__$1);
var G__30829 = cljs.core.chunk_rest.call(null,seq__30769_30827__$1);
var G__30830 = c__19078__auto___30828;
var G__30831 = cljs.core.count.call(null,c__19078__auto___30828);
var G__30832 = (0);
seq__30769_30812 = G__30829;
chunk__30770_30813 = G__30830;
count__30771_30814 = G__30831;
i__30772_30815 = G__30832;
continue;
} else {
var vec__30774_30833 = cljs.core.first.call(null,seq__30769_30827__$1);
var n_30834 = cljs.core.nth.call(null,vec__30774_30833,(0),null);
var meth_30835 = cljs.core.nth.call(null,vec__30774_30833,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_30835))){
cljs.compiler.emitln.call(null,"default:");

var restarg_30836 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_30836," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_30837 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_30836," = new cljs.core.IndexedSeq(",a_30837,",0);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_30834,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_30784)),(((cljs.core.count.call(null,maxparams_30784) > (1)))?", ":null),restarg_30836,");");
} else {
var pcnt_30838 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_30835));
cljs.compiler.emitln.call(null,"case ",pcnt_30838,":");

cljs.compiler.emitln.call(null,"return ",n_30834,".call(this",(((pcnt_30838 === (0)))?null:cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_30838,maxparams_30784))),",")),");");
}

var G__30839 = cljs.core.next.call(null,seq__30769_30827__$1);
var G__30840 = null;
var G__30841 = (0);
var G__30842 = (0);
seq__30769_30812 = G__30839;
chunk__30770_30813 = G__30840;
count__30771_30814 = G__30841;
i__30772_30815 = G__30842;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"throw(new Error('Invalid arity: ' + arguments.length));");

cljs.compiler.emitln.call(null,"};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.call(null,mname_30783,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.call(null,mname_30783,".cljs$lang$applyTo = ",cljs.core.some.call(null,((function (name_30782__$1,mname_30783,maxparams_30784,mmap_30785,ms_30786,loop_locals,map__30761,map__30761__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets){
return (function (p1__30759_SHARP_){
var vec__30775 = p1__30759_SHARP_;
var n = cljs.core.nth.call(null,vec__30775,(0),null);
var m = cljs.core.nth.call(null,vec__30775,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
});})(name_30782__$1,mname_30783,maxparams_30784,mmap_30785,ms_30786,loop_locals,map__30761,map__30761__$1,name,env,methods$,max_fixed_arity,variadic,recur_frames,loop_lets))
,ms_30786),".cljs$lang$applyTo;");
} else {
}

var seq__30776_30843 = cljs.core.seq.call(null,ms_30786);
var chunk__30777_30844 = null;
var count__30778_30845 = (0);
var i__30779_30846 = (0);
while(true){
if((i__30779_30846 < count__30778_30845)){
var vec__30780_30847 = cljs.core._nth.call(null,chunk__30777_30844,i__30779_30846);
var n_30848 = cljs.core.nth.call(null,vec__30780_30847,(0),null);
var meth_30849 = cljs.core.nth.call(null,vec__30780_30847,(1),null);
var c_30850 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_30849));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_30849))){
cljs.compiler.emitln.call(null,mname_30783,".cljs$core$IFn$_invoke$arity$variadic = ",n_30848,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_30783,".cljs$core$IFn$_invoke$arity$",c_30850," = ",n_30848,";");
}

var G__30851 = seq__30776_30843;
var G__30852 = chunk__30777_30844;
var G__30853 = count__30778_30845;
var G__30854 = (i__30779_30846 + (1));
seq__30776_30843 = G__30851;
chunk__30777_30844 = G__30852;
count__30778_30845 = G__30853;
i__30779_30846 = G__30854;
continue;
} else {
var temp__4425__auto___30855 = cljs.core.seq.call(null,seq__30776_30843);
if(temp__4425__auto___30855){
var seq__30776_30856__$1 = temp__4425__auto___30855;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30776_30856__$1)){
var c__19078__auto___30857 = cljs.core.chunk_first.call(null,seq__30776_30856__$1);
var G__30858 = cljs.core.chunk_rest.call(null,seq__30776_30856__$1);
var G__30859 = c__19078__auto___30857;
var G__30860 = cljs.core.count.call(null,c__19078__auto___30857);
var G__30861 = (0);
seq__30776_30843 = G__30858;
chunk__30777_30844 = G__30859;
count__30778_30845 = G__30860;
i__30779_30846 = G__30861;
continue;
} else {
var vec__30781_30862 = cljs.core.first.call(null,seq__30776_30856__$1);
var n_30863 = cljs.core.nth.call(null,vec__30781_30862,(0),null);
var meth_30864 = cljs.core.nth.call(null,vec__30781_30862,(1),null);
var c_30865 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_30864));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(meth_30864))){
cljs.compiler.emitln.call(null,mname_30783,".cljs$core$IFn$_invoke$arity$variadic = ",n_30863,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_30783,".cljs$core$IFn$_invoke$arity$",c_30865," = ",n_30863,";");
}

var G__30866 = cljs.core.next.call(null,seq__30776_30856__$1);
var G__30867 = null;
var G__30868 = (0);
var G__30869 = (0);
seq__30776_30843 = G__30866;
chunk__30777_30844 = G__30867;
count__30778_30845 = G__30868;
i__30779_30846 = G__30869;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"return ",mname_30783,";");

cljs.compiler.emitln.call(null,"})()");
}

if(loop_locals){
return cljs.compiler.emitln.call(null,";})(",cljs.compiler.comma_sep.call(null,loop_locals),"))");
} else {
return null;
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"do","do",46310725),(function (p__30870){
var map__30871 = p__30870;
var map__30871__$1 = ((((!((map__30871 == null)))?((((map__30871.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30871.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30871):map__30871);
var statements = cljs.core.get.call(null,map__30871__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.call(null,map__30871__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.call(null,map__30871__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var and__18263__auto__ = statements;
if(cljs.core.truth_(and__18263__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context);
} else {
return and__18263__auto__;
}
})())){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

var seq__30873_30877 = cljs.core.seq.call(null,statements);
var chunk__30874_30878 = null;
var count__30875_30879 = (0);
var i__30876_30880 = (0);
while(true){
if((i__30876_30880 < count__30875_30879)){
var s_30881 = cljs.core._nth.call(null,chunk__30874_30878,i__30876_30880);
cljs.compiler.emitln.call(null,s_30881);

var G__30882 = seq__30873_30877;
var G__30883 = chunk__30874_30878;
var G__30884 = count__30875_30879;
var G__30885 = (i__30876_30880 + (1));
seq__30873_30877 = G__30882;
chunk__30874_30878 = G__30883;
count__30875_30879 = G__30884;
i__30876_30880 = G__30885;
continue;
} else {
var temp__4425__auto___30886 = cljs.core.seq.call(null,seq__30873_30877);
if(temp__4425__auto___30886){
var seq__30873_30887__$1 = temp__4425__auto___30886;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30873_30887__$1)){
var c__19078__auto___30888 = cljs.core.chunk_first.call(null,seq__30873_30887__$1);
var G__30889 = cljs.core.chunk_rest.call(null,seq__30873_30887__$1);
var G__30890 = c__19078__auto___30888;
var G__30891 = cljs.core.count.call(null,c__19078__auto___30888);
var G__30892 = (0);
seq__30873_30877 = G__30889;
chunk__30874_30878 = G__30890;
count__30875_30879 = G__30891;
i__30876_30880 = G__30892;
continue;
} else {
var s_30893 = cljs.core.first.call(null,seq__30873_30887__$1);
cljs.compiler.emitln.call(null,s_30893);

var G__30894 = cljs.core.next.call(null,seq__30873_30887__$1);
var G__30895 = null;
var G__30896 = (0);
var G__30897 = (0);
seq__30873_30877 = G__30894;
chunk__30874_30878 = G__30895;
count__30875_30879 = G__30896;
i__30876_30880 = G__30897;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit.call(null,ret);

if(cljs.core.truth_((function (){var and__18263__auto__ = statements;
if(cljs.core.truth_(and__18263__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context);
} else {
return and__18263__auto__;
}
})())){
return cljs.compiler.emitln.call(null,"})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__30898){
var map__30899 = p__30898;
var map__30899__$1 = ((((!((map__30899 == null)))?((((map__30899.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30899.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30899):map__30899);
var env = cljs.core.get.call(null,map__30899__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var try$ = cljs.core.get.call(null,map__30899__$1,new cljs.core.Keyword(null,"try","try",1380742522));
var catch$ = cljs.core.get.call(null,map__30899__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.call(null,map__30899__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.call(null,map__30899__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__18275__auto__ = name;
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,"try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.call(null,"catch (",cljs.compiler.munge.call(null,name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"constant","constant",-379609303),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(finally$))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("finally block cannot contain constant"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.Keyword(null,"constant","constant",-379609303),cljs.core.list(new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Symbol(null,"finally","finally",-1065347064,null)))))].join('')));
}

cljs.compiler.emits.call(null,"finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.call(null,try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__30901,is_loop){
var map__30913 = p__30901;
var map__30913__$1 = ((((!((map__30913 == null)))?((((map__30913.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30913.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30913):map__30913);
var bindings = cljs.core.get.call(null,map__30913__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var expr = cljs.core.get.call(null,map__30913__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__30913__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var _STAR_lexical_renames_STAR_30915_30924 = cljs.compiler._STAR_lexical_renames_STAR_;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.into.call(null,cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.call(null,((function (_STAR_lexical_renames_STAR_30915_30924,context,map__30913,map__30913__$1,bindings,expr,env){
return (function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope.call(null,binding),cljs.core.gensym.call(null,[cljs.core.str(name),cljs.core.str("-")].join(''))],null));
});})(_STAR_lexical_renames_STAR_30915_30924,context,map__30913,map__30913__$1,bindings,expr,env))
,bindings):null));

try{var seq__30916_30925 = cljs.core.seq.call(null,bindings);
var chunk__30917_30926 = null;
var count__30918_30927 = (0);
var i__30919_30928 = (0);
while(true){
if((i__30919_30928 < count__30918_30927)){
var map__30920_30929 = cljs.core._nth.call(null,chunk__30917_30926,i__30919_30928);
var map__30920_30930__$1 = ((((!((map__30920_30929 == null)))?((((map__30920_30929.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30920_30929.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30920_30929):map__30920_30929);
var binding_30931 = map__30920_30930__$1;
var init_30932 = cljs.core.get.call(null,map__30920_30930__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_30931);

cljs.compiler.emitln.call(null," = ",init_30932,";");

var G__30933 = seq__30916_30925;
var G__30934 = chunk__30917_30926;
var G__30935 = count__30918_30927;
var G__30936 = (i__30919_30928 + (1));
seq__30916_30925 = G__30933;
chunk__30917_30926 = G__30934;
count__30918_30927 = G__30935;
i__30919_30928 = G__30936;
continue;
} else {
var temp__4425__auto___30937 = cljs.core.seq.call(null,seq__30916_30925);
if(temp__4425__auto___30937){
var seq__30916_30938__$1 = temp__4425__auto___30937;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30916_30938__$1)){
var c__19078__auto___30939 = cljs.core.chunk_first.call(null,seq__30916_30938__$1);
var G__30940 = cljs.core.chunk_rest.call(null,seq__30916_30938__$1);
var G__30941 = c__19078__auto___30939;
var G__30942 = cljs.core.count.call(null,c__19078__auto___30939);
var G__30943 = (0);
seq__30916_30925 = G__30940;
chunk__30917_30926 = G__30941;
count__30918_30927 = G__30942;
i__30919_30928 = G__30943;
continue;
} else {
var map__30922_30944 = cljs.core.first.call(null,seq__30916_30938__$1);
var map__30922_30945__$1 = ((((!((map__30922_30944 == null)))?((((map__30922_30944.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30922_30944.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30922_30944):map__30922_30944);
var binding_30946 = map__30922_30945__$1;
var init_30947 = cljs.core.get.call(null,map__30922_30945__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_30946);

cljs.compiler.emitln.call(null," = ",init_30947,";");

var G__30948 = cljs.core.next.call(null,seq__30916_30938__$1);
var G__30949 = null;
var G__30950 = (0);
var G__30951 = (0);
seq__30916_30925 = G__30948;
chunk__30917_30926 = G__30949;
count__30918_30927 = G__30950;
i__30919_30928 = G__30951;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}
}finally {cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR_30915_30924;
}
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let.call(null,ast,false);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let.call(null,ast,true);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__30952){
var map__30953 = p__30952;
var map__30953__$1 = ((((!((map__30953 == null)))?((((map__30953.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30953.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30953):map__30953);
var frame = cljs.core.get.call(null,map__30953__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.call(null,map__30953__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.call(null,map__30953__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec.call(null,cljs.core.take.call(null,cljs.core.count.call(null,exprs),cljs.core.repeatedly.call(null,cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__19178__auto___30955 = cljs.core.count.call(null,exprs);
var i_30956 = (0);
while(true){
if((i_30956 < n__19178__auto___30955)){
cljs.compiler.emitln.call(null,"var ",temps.call(null,i_30956)," = ",exprs.call(null,i_30956),";");

var G__30957 = (i_30956 + (1));
i_30956 = G__30957;
continue;
} else {
}
break;
}

var n__19178__auto___30958 = cljs.core.count.call(null,exprs);
var i_30959 = (0);
while(true){
if((i_30959 < n__19178__auto___30958)){
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,params.call(null,i_30959))," = ",temps.call(null,i_30959),";");

var G__30960 = (i_30959 + (1));
i_30959 = G__30960;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.call(null,"continue;");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__30961){
var map__30962 = p__30961;
var map__30962__$1 = ((((!((map__30962 == null)))?((((map__30962.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30962.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30962):map__30962);
var bindings = cljs.core.get.call(null,map__30962__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var expr = cljs.core.get.call(null,map__30962__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var env = cljs.core.get.call(null,map__30962__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var seq__30964_30972 = cljs.core.seq.call(null,bindings);
var chunk__30965_30973 = null;
var count__30966_30974 = (0);
var i__30967_30975 = (0);
while(true){
if((i__30967_30975 < count__30966_30974)){
var map__30968_30976 = cljs.core._nth.call(null,chunk__30965_30973,i__30967_30975);
var map__30968_30977__$1 = ((((!((map__30968_30976 == null)))?((((map__30968_30976.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30968_30976.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30968_30976):map__30968_30976);
var binding_30978 = map__30968_30977__$1;
var init_30979 = cljs.core.get.call(null,map__30968_30977__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_30978)," = ",init_30979,";");

var G__30980 = seq__30964_30972;
var G__30981 = chunk__30965_30973;
var G__30982 = count__30966_30974;
var G__30983 = (i__30967_30975 + (1));
seq__30964_30972 = G__30980;
chunk__30965_30973 = G__30981;
count__30966_30974 = G__30982;
i__30967_30975 = G__30983;
continue;
} else {
var temp__4425__auto___30984 = cljs.core.seq.call(null,seq__30964_30972);
if(temp__4425__auto___30984){
var seq__30964_30985__$1 = temp__4425__auto___30984;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30964_30985__$1)){
var c__19078__auto___30986 = cljs.core.chunk_first.call(null,seq__30964_30985__$1);
var G__30987 = cljs.core.chunk_rest.call(null,seq__30964_30985__$1);
var G__30988 = c__19078__auto___30986;
var G__30989 = cljs.core.count.call(null,c__19078__auto___30986);
var G__30990 = (0);
seq__30964_30972 = G__30987;
chunk__30965_30973 = G__30988;
count__30966_30974 = G__30989;
i__30967_30975 = G__30990;
continue;
} else {
var map__30970_30991 = cljs.core.first.call(null,seq__30964_30985__$1);
var map__30970_30992__$1 = ((((!((map__30970_30991 == null)))?((((map__30970_30991.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30970_30991.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30970_30991):map__30970_30991);
var binding_30993 = map__30970_30992__$1;
var init_30994 = cljs.core.get.call(null,map__30970_30992__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_30993)," = ",init_30994,";");

var G__30995 = cljs.core.next.call(null,seq__30964_30985__$1);
var G__30996 = null;
var G__30997 = (0);
var G__30998 = (0);
seq__30964_30972 = G__30995;
chunk__30965_30973 = G__30996;
count__30966_30974 = G__30997;
i__30967_30975 = G__30998;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,expr);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.call(null,[cljs.core.str([cljs.core.str(psym)].join('').replace((new RegExp("\\.","g")),"$").replace("/","$")),cljs.core.str("$")].join(''));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__31001){
var map__31002 = p__31001;
var map__31002__$1 = ((((!((map__31002 == null)))?((((map__31002.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31002.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31002):map__31002);
var expr = map__31002__$1;
var f = cljs.core.get.call(null,map__31002__$1,new cljs.core.Keyword(null,"f","f",-1597136552));
var args = cljs.core.get.call(null,map__31002__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__31002__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__18263__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__18263__auto__)){
var and__18263__auto____$1 = cljs.core.not.call(null,new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info));
if(and__18263__auto____$1){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__18263__auto____$1;
}
} else {
return and__18263__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__18263__auto__ = protocol;
if(cljs.core.truth_(and__18263__auto__)){
var and__18263__auto____$1 = tag;
if(cljs.core.truth_(and__18263__auto____$1)){
var or__18275__auto__ = (function (){var and__18263__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__18263__auto____$2)){
var and__18263__auto____$3 = protocol;
if(cljs.core.truth_(and__18263__auto____$3)){
return cljs.core._EQ_.call(null,tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__18263__auto____$3;
}
} else {
return and__18263__auto____$2;
}
})();
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
var and__18263__auto____$2 = (function (){var or__18275__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__18275__auto____$1)){
return or__18275__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__18263__auto____$2)){
var or__18275__auto____$1 = cljs.core._EQ_.call(null,protocol,tag);
if(or__18275__auto____$1){
return or__18275__auto____$1;
} else {
var and__18263__auto____$3 = !(cljs.core.set_QMARK_.call(null,tag));
if(and__18263__auto____$3){
var and__18263__auto____$4 = cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [new cljs.core.Symbol(null,"clj","clj",980036099,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null,new cljs.core.Symbol(null,"object","object",-1179821820,null),null,new cljs.core.Symbol(null,"any","any",-948528346,null),null,new cljs.core.Symbol(null,"number","number",-1084057331,null),null,new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),null,new cljs.core.Symbol(null,"array","array",-440182315,null),null,new cljs.core.Symbol(null,"string","string",-349010059,null),null,new cljs.core.Symbol(null,"function","function",-486723946,null),null,new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),null], null), null).call(null,tag));
if(and__18263__auto____$4){
var temp__4425__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var.call(null,cljs.core.dissoc.call(null,env,new cljs.core.Keyword(null,"locals","locals",535295783)),tag));
if(cljs.core.truth_(temp__4425__auto__)){
var ps = temp__4425__auto__;
return ps.call(null,protocol);
} else {
return null;
}
} else {
return and__18263__auto____$4;
}
} else {
return and__18263__auto____$3;
}
}
} else {
return and__18263__auto____$2;
}
}
} else {
return and__18263__auto____$1;
}
} else {
return and__18263__auto__;
}
})();
var opt_not_QMARK_ = (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.call(null,cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr))),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var js_QMARK_ = (cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"js","js",-886355190,null))) || (cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null)));
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__18275__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__18275__auto__){
return or__18275__auto__;
} else {
var temp__4425__auto__ = [cljs.core.str(ns)].join('');
if(cljs.core.truth_(temp__4425__auto__)){
var ns_str = temp__4425__auto__;
return cljs.core._EQ_.call(null,cljs.core.get.call(null,clojure.string.split.call(null,ns_str,/\./),(0),null),"goog");
} else {
return null;
}
}
})():null);
var keyword_QMARK_ = (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f),new cljs.core.Keyword(null,"constant","constant",-379609303))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f) instanceof cljs.core.Keyword));
var vec__31004 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count.call(null,args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic","variadic",882626057).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if((cljs.core.not.call(null,variadic_QMARK_)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,mps),(1)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__18263__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__18263__auto__)){
return (arity > mfa);
} else {
return and__18263__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__31002,map__31002__$1,expr,f,args,env){
return (function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str(cljs.compiler.munge.call(null,info__$1)),cljs.core.str(".cljs$core$IFn$_invoke$arity$variadic")].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__31002,map__31002__$1,expr,f,args,env){
return (function (p1__30999_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__30999_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
});})(arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__31002,map__31002__$1,expr,f,args,env))
);
});})(arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__31002,map__31002__$1,expr,f,args,env))
),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.call(null,cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.fromArray([arity], true),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__31002,map__31002__$1,expr,f,args,env){
return (function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str(cljs.compiler.munge.call(null,info__$1)),cljs.core.str(".cljs$core$IFn$_invoke$arity$"),cljs.core.str(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),((function (arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__31002,map__31002__$1,expr,f,args,env){
return (function (p1__31000_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__31000_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
});})(arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__31002,map__31002__$1,expr,f,args,env))
);
});})(arities,arity,variadic_QMARK_,mps,mfa,info,fn_QMARK_,protocol,tag,proto_QMARK_,opt_not_QMARK_,ns,js_QMARK_,goog_QMARK_,keyword_QMARK_,map__31002,map__31002__$1,expr,f,args,env))
),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.call(null,vec__31004,(0),null);
var variadic_invoke = cljs.core.nth.call(null,vec__31004,(1),null);
var env__26382__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.call(null,"!(",cljs.core.first.call(null,args),")");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_31005 = [cljs.core.str(cljs.compiler.munge.call(null,cljs.compiler.protocol_prefix.call(null,protocol))),cljs.core.str(cljs.compiler.munge.call(null,cljs.core.name.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),cljs.core.str("$arity$"),cljs.core.str(cljs.core.count.call(null,args))].join('');
cljs.compiler.emits.call(null,cljs.core.first.call(null,args),".",pimpl_31005,"(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",cljs.core.rest.call(null,args))),")");
} else {
if(keyword_QMARK_){
cljs.compiler.emits.call(null,f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count.call(null,args),"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_31006 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,mfa_31006,args)),(((mfa_31006 === (0)))?null:","),"cljs.core.array_seq([",cljs.compiler.comma_sep.call(null,cljs.core.drop.call(null,mfa_31006,args)),"], 0))");
} else {
if(cljs.core.truth_((function (){var or__18275__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
var or__18275__auto____$1 = js_QMARK_;
if(or__18275__auto____$1){
return or__18275__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_((function (){var and__18263__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__18263__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"var","var",-769682797));
} else {
return and__18263__auto__;
}
})())){
var fprop_31007 = [cljs.core.str(".cljs$core$IFn$_invoke$arity$"),cljs.core.str(cljs.core.count.call(null,args))].join('');
cljs.compiler.emits.call(null,"(",f__$1,fprop_31007," ? ",f__$1,fprop_31007,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),"))");
} else {
cljs.compiler.emits.call(null,f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),")");
}

}
}
}
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__31008){
var map__31009 = p__31008;
var map__31009__$1 = ((((!((map__31009 == null)))?((((map__31009.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31009.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31009):map__31009);
var ctor = cljs.core.get.call(null,map__31009__$1,new cljs.core.Keyword(null,"ctor","ctor",1750864802));
var args = cljs.core.get.call(null,map__31009__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__31009__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__26382__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(new ",ctor,"(",cljs.compiler.comma_sep.call(null,args),"))");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__31011){
var map__31012 = p__31011;
var map__31012__$1 = ((((!((map__31012 == null)))?((((map__31012.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31012.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31012):map__31012);
var target = cljs.core.get.call(null,map__31012__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.call(null,map__31012__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.call(null,map__31012__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__26382__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,target," = ",val);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads){
var loaded_libs = cljs.compiler.munge.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.call(null,cljs.core.gensym.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set();");

cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.set();");
} else {
}

var seq__31018_31022 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,seen)),cljs.core.distinct.call(null,cljs.core.vals.call(null,libs))));
var chunk__31019_31023 = null;
var count__31020_31024 = (0);
var i__31021_31025 = (0);
while(true){
if((i__31021_31025 < count__31020_31024)){
var lib_31026 = cljs.core._nth.call(null,chunk__31019_31023,i__31021_31025);
if(cljs.core.truth_((function (){var or__18275__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_31026),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_31026),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__18275__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_31026),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_31026),"', 'reload-all');");
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_31026),"');");

}
}

var G__31027 = seq__31018_31022;
var G__31028 = chunk__31019_31023;
var G__31029 = count__31020_31024;
var G__31030 = (i__31021_31025 + (1));
seq__31018_31022 = G__31027;
chunk__31019_31023 = G__31028;
count__31020_31024 = G__31029;
i__31021_31025 = G__31030;
continue;
} else {
var temp__4425__auto___31031 = cljs.core.seq.call(null,seq__31018_31022);
if(temp__4425__auto___31031){
var seq__31018_31032__$1 = temp__4425__auto___31031;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31018_31032__$1)){
var c__19078__auto___31033 = cljs.core.chunk_first.call(null,seq__31018_31032__$1);
var G__31034 = cljs.core.chunk_rest.call(null,seq__31018_31032__$1);
var G__31035 = c__19078__auto___31033;
var G__31036 = cljs.core.count.call(null,c__19078__auto___31033);
var G__31037 = (0);
seq__31018_31022 = G__31034;
chunk__31019_31023 = G__31035;
count__31020_31024 = G__31036;
i__31021_31025 = G__31037;
continue;
} else {
var lib_31038 = cljs.core.first.call(null,seq__31018_31032__$1);
if(cljs.core.truth_((function (){var or__18275__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_31038),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_31038),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__18275__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_31038),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_31038),"', 'reload-all');");
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_31038),"');");

}
}

var G__31039 = cljs.core.next.call(null,seq__31018_31032__$1);
var G__31040 = null;
var G__31041 = (0);
var G__31042 = (0);
seq__31018_31022 = G__31039;
chunk__31019_31023 = G__31040;
count__31020_31024 = G__31041;
i__31021_31025 = G__31042;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
return cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",loaded_libs,");");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__31043){
var map__31044 = p__31043;
var map__31044__$1 = ((((!((map__31044 == null)))?((((map__31044.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31044.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31044):map__31044);
var name = cljs.core.get.call(null,map__31044__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__31044__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__31044__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__31044__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__31044__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__31044__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,name),"');");

if(cljs.core._EQ_.call(null,name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('cljs.core');");
}

cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads));

return cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"deftype*","deftype*",-677871637),(function (p__31046){
var map__31047 = p__31046;
var map__31047__$1 = ((((!((map__31047 == null)))?((((map__31047.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31047.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31047):map__31047);
var t = cljs.core.get.call(null,map__31047__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__31047__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__31047__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__31047__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__31047__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.call(null,cljs.compiler.munge,fields);
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__31049_31063 = cljs.core.seq.call(null,protocols);
var chunk__31050_31064 = null;
var count__31051_31065 = (0);
var i__31052_31066 = (0);
while(true){
if((i__31052_31066 < count__31051_31065)){
var protocol_31067 = cljs.core._nth.call(null,chunk__31050_31064,i__31052_31066);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str(protocol_31067)].join('')),"}");

var G__31068 = seq__31049_31063;
var G__31069 = chunk__31050_31064;
var G__31070 = count__31051_31065;
var G__31071 = (i__31052_31066 + (1));
seq__31049_31063 = G__31068;
chunk__31050_31064 = G__31069;
count__31051_31065 = G__31070;
i__31052_31066 = G__31071;
continue;
} else {
var temp__4425__auto___31072 = cljs.core.seq.call(null,seq__31049_31063);
if(temp__4425__auto___31072){
var seq__31049_31073__$1 = temp__4425__auto___31072;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31049_31073__$1)){
var c__19078__auto___31074 = cljs.core.chunk_first.call(null,seq__31049_31073__$1);
var G__31075 = cljs.core.chunk_rest.call(null,seq__31049_31073__$1);
var G__31076 = c__19078__auto___31074;
var G__31077 = cljs.core.count.call(null,c__19078__auto___31074);
var G__31078 = (0);
seq__31049_31063 = G__31075;
chunk__31050_31064 = G__31076;
count__31051_31065 = G__31077;
i__31052_31066 = G__31078;
continue;
} else {
var protocol_31079 = cljs.core.first.call(null,seq__31049_31073__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str(protocol_31079)].join('')),"}");

var G__31080 = cljs.core.next.call(null,seq__31049_31073__$1);
var G__31081 = null;
var G__31082 = (0);
var G__31083 = (0);
seq__31049_31063 = G__31080;
chunk__31050_31064 = G__31081;
count__31051_31065 = G__31082;
i__31052_31066 = G__31083;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__31053_31084 = cljs.core.seq.call(null,fields__$1);
var chunk__31054_31085 = null;
var count__31055_31086 = (0);
var i__31056_31087 = (0);
while(true){
if((i__31056_31087 < count__31055_31086)){
var fld_31088 = cljs.core._nth.call(null,chunk__31054_31085,i__31056_31087);
cljs.compiler.emitln.call(null,"this.",fld_31088," = ",fld_31088,";");

var G__31089 = seq__31053_31084;
var G__31090 = chunk__31054_31085;
var G__31091 = count__31055_31086;
var G__31092 = (i__31056_31087 + (1));
seq__31053_31084 = G__31089;
chunk__31054_31085 = G__31090;
count__31055_31086 = G__31091;
i__31056_31087 = G__31092;
continue;
} else {
var temp__4425__auto___31093 = cljs.core.seq.call(null,seq__31053_31084);
if(temp__4425__auto___31093){
var seq__31053_31094__$1 = temp__4425__auto___31093;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31053_31094__$1)){
var c__19078__auto___31095 = cljs.core.chunk_first.call(null,seq__31053_31094__$1);
var G__31096 = cljs.core.chunk_rest.call(null,seq__31053_31094__$1);
var G__31097 = c__19078__auto___31095;
var G__31098 = cljs.core.count.call(null,c__19078__auto___31095);
var G__31099 = (0);
seq__31053_31084 = G__31096;
chunk__31054_31085 = G__31097;
count__31055_31086 = G__31098;
i__31056_31087 = G__31099;
continue;
} else {
var fld_31100 = cljs.core.first.call(null,seq__31053_31094__$1);
cljs.compiler.emitln.call(null,"this.",fld_31100," = ",fld_31100,";");

var G__31101 = cljs.core.next.call(null,seq__31053_31094__$1);
var G__31102 = null;
var G__31103 = (0);
var G__31104 = (0);
seq__31053_31084 = G__31101;
chunk__31054_31085 = G__31102;
count__31055_31086 = G__31103;
i__31056_31087 = G__31104;
continue;
}
} else {
}
}
break;
}

var seq__31057_31105 = cljs.core.seq.call(null,pmasks);
var chunk__31058_31106 = null;
var count__31059_31107 = (0);
var i__31060_31108 = (0);
while(true){
if((i__31060_31108 < count__31059_31107)){
var vec__31061_31109 = cljs.core._nth.call(null,chunk__31058_31106,i__31060_31108);
var pno_31110 = cljs.core.nth.call(null,vec__31061_31109,(0),null);
var pmask_31111 = cljs.core.nth.call(null,vec__31061_31109,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_31110,"$ = ",pmask_31111,";");

var G__31112 = seq__31057_31105;
var G__31113 = chunk__31058_31106;
var G__31114 = count__31059_31107;
var G__31115 = (i__31060_31108 + (1));
seq__31057_31105 = G__31112;
chunk__31058_31106 = G__31113;
count__31059_31107 = G__31114;
i__31060_31108 = G__31115;
continue;
} else {
var temp__4425__auto___31116 = cljs.core.seq.call(null,seq__31057_31105);
if(temp__4425__auto___31116){
var seq__31057_31117__$1 = temp__4425__auto___31116;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31057_31117__$1)){
var c__19078__auto___31118 = cljs.core.chunk_first.call(null,seq__31057_31117__$1);
var G__31119 = cljs.core.chunk_rest.call(null,seq__31057_31117__$1);
var G__31120 = c__19078__auto___31118;
var G__31121 = cljs.core.count.call(null,c__19078__auto___31118);
var G__31122 = (0);
seq__31057_31105 = G__31119;
chunk__31058_31106 = G__31120;
count__31059_31107 = G__31121;
i__31060_31108 = G__31122;
continue;
} else {
var vec__31062_31123 = cljs.core.first.call(null,seq__31057_31117__$1);
var pno_31124 = cljs.core.nth.call(null,vec__31062_31123,(0),null);
var pmask_31125 = cljs.core.nth.call(null,vec__31062_31123,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_31124,"$ = ",pmask_31125,";");

var G__31126 = cljs.core.next.call(null,seq__31057_31117__$1);
var G__31127 = null;
var G__31128 = (0);
var G__31129 = (0);
seq__31057_31105 = G__31126;
chunk__31058_31106 = G__31127;
count__31059_31107 = G__31128;
i__31060_31108 = G__31129;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"})");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"defrecord*","defrecord*",718069562),(function (p__31130){
var map__31131 = p__31130;
var map__31131__$1 = ((((!((map__31131 == null)))?((((map__31131.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31131.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31131):map__31131);
var t = cljs.core.get.call(null,map__31131__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__31131__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__31131__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__31131__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__31131__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.call(null,cljs.core.map.call(null,cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__31133_31147 = cljs.core.seq.call(null,protocols);
var chunk__31134_31148 = null;
var count__31135_31149 = (0);
var i__31136_31150 = (0);
while(true){
if((i__31136_31150 < count__31135_31149)){
var protocol_31151 = cljs.core._nth.call(null,chunk__31134_31148,i__31136_31150);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str(protocol_31151)].join('')),"}");

var G__31152 = seq__31133_31147;
var G__31153 = chunk__31134_31148;
var G__31154 = count__31135_31149;
var G__31155 = (i__31136_31150 + (1));
seq__31133_31147 = G__31152;
chunk__31134_31148 = G__31153;
count__31135_31149 = G__31154;
i__31136_31150 = G__31155;
continue;
} else {
var temp__4425__auto___31156 = cljs.core.seq.call(null,seq__31133_31147);
if(temp__4425__auto___31156){
var seq__31133_31157__$1 = temp__4425__auto___31156;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31133_31157__$1)){
var c__19078__auto___31158 = cljs.core.chunk_first.call(null,seq__31133_31157__$1);
var G__31159 = cljs.core.chunk_rest.call(null,seq__31133_31157__$1);
var G__31160 = c__19078__auto___31158;
var G__31161 = cljs.core.count.call(null,c__19078__auto___31158);
var G__31162 = (0);
seq__31133_31147 = G__31159;
chunk__31134_31148 = G__31160;
count__31135_31149 = G__31161;
i__31136_31150 = G__31162;
continue;
} else {
var protocol_31163 = cljs.core.first.call(null,seq__31133_31157__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,[cljs.core.str(protocol_31163)].join('')),"}");

var G__31164 = cljs.core.next.call(null,seq__31133_31157__$1);
var G__31165 = null;
var G__31166 = (0);
var G__31167 = (0);
seq__31133_31147 = G__31164;
chunk__31134_31148 = G__31165;
count__31135_31149 = G__31166;
i__31136_31150 = G__31167;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__31137_31168 = cljs.core.seq.call(null,fields__$1);
var chunk__31138_31169 = null;
var count__31139_31170 = (0);
var i__31140_31171 = (0);
while(true){
if((i__31140_31171 < count__31139_31170)){
var fld_31172 = cljs.core._nth.call(null,chunk__31138_31169,i__31140_31171);
cljs.compiler.emitln.call(null,"this.",fld_31172," = ",fld_31172,";");

var G__31173 = seq__31137_31168;
var G__31174 = chunk__31138_31169;
var G__31175 = count__31139_31170;
var G__31176 = (i__31140_31171 + (1));
seq__31137_31168 = G__31173;
chunk__31138_31169 = G__31174;
count__31139_31170 = G__31175;
i__31140_31171 = G__31176;
continue;
} else {
var temp__4425__auto___31177 = cljs.core.seq.call(null,seq__31137_31168);
if(temp__4425__auto___31177){
var seq__31137_31178__$1 = temp__4425__auto___31177;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31137_31178__$1)){
var c__19078__auto___31179 = cljs.core.chunk_first.call(null,seq__31137_31178__$1);
var G__31180 = cljs.core.chunk_rest.call(null,seq__31137_31178__$1);
var G__31181 = c__19078__auto___31179;
var G__31182 = cljs.core.count.call(null,c__19078__auto___31179);
var G__31183 = (0);
seq__31137_31168 = G__31180;
chunk__31138_31169 = G__31181;
count__31139_31170 = G__31182;
i__31140_31171 = G__31183;
continue;
} else {
var fld_31184 = cljs.core.first.call(null,seq__31137_31178__$1);
cljs.compiler.emitln.call(null,"this.",fld_31184," = ",fld_31184,";");

var G__31185 = cljs.core.next.call(null,seq__31137_31178__$1);
var G__31186 = null;
var G__31187 = (0);
var G__31188 = (0);
seq__31137_31168 = G__31185;
chunk__31138_31169 = G__31186;
count__31139_31170 = G__31187;
i__31140_31171 = G__31188;
continue;
}
} else {
}
}
break;
}

var seq__31141_31189 = cljs.core.seq.call(null,pmasks);
var chunk__31142_31190 = null;
var count__31143_31191 = (0);
var i__31144_31192 = (0);
while(true){
if((i__31144_31192 < count__31143_31191)){
var vec__31145_31193 = cljs.core._nth.call(null,chunk__31142_31190,i__31144_31192);
var pno_31194 = cljs.core.nth.call(null,vec__31145_31193,(0),null);
var pmask_31195 = cljs.core.nth.call(null,vec__31145_31193,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_31194,"$ = ",pmask_31195,";");

var G__31196 = seq__31141_31189;
var G__31197 = chunk__31142_31190;
var G__31198 = count__31143_31191;
var G__31199 = (i__31144_31192 + (1));
seq__31141_31189 = G__31196;
chunk__31142_31190 = G__31197;
count__31143_31191 = G__31198;
i__31144_31192 = G__31199;
continue;
} else {
var temp__4425__auto___31200 = cljs.core.seq.call(null,seq__31141_31189);
if(temp__4425__auto___31200){
var seq__31141_31201__$1 = temp__4425__auto___31200;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31141_31201__$1)){
var c__19078__auto___31202 = cljs.core.chunk_first.call(null,seq__31141_31201__$1);
var G__31203 = cljs.core.chunk_rest.call(null,seq__31141_31201__$1);
var G__31204 = c__19078__auto___31202;
var G__31205 = cljs.core.count.call(null,c__19078__auto___31202);
var G__31206 = (0);
seq__31141_31189 = G__31203;
chunk__31142_31190 = G__31204;
count__31143_31191 = G__31205;
i__31144_31192 = G__31206;
continue;
} else {
var vec__31146_31207 = cljs.core.first.call(null,seq__31141_31201__$1);
var pno_31208 = cljs.core.nth.call(null,vec__31146_31207,(0),null);
var pmask_31209 = cljs.core.nth.call(null,vec__31146_31207,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_31208,"$ = ",pmask_31209,";");

var G__31210 = cljs.core.next.call(null,seq__31141_31201__$1);
var G__31211 = null;
var G__31212 = (0);
var G__31213 = (0);
seq__31141_31189 = G__31210;
chunk__31142_31190 = G__31211;
count__31143_31191 = G__31212;
i__31144_31192 = G__31213;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"})");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"dot","dot",1442709401),(function (p__31214){
var map__31215 = p__31214;
var map__31215__$1 = ((((!((map__31215 == null)))?((((map__31215.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31215.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31215):map__31215);
var target = cljs.core.get.call(null,map__31215__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.call(null,map__31215__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.call(null,map__31215__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.call(null,map__31215__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__31215__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__26382__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep.call(null,args),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__31217){
var map__31218 = p__31217;
var map__31218__$1 = ((((!((map__31218 == null)))?((((map__31218.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31218.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31218):map__31218);
var op = cljs.core.get.call(null,map__31218__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.call(null,map__31218__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.call(null,map__31218__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.call(null,map__31218__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.call(null,map__31218__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__18263__auto__ = code;
if(cljs.core.truth_(and__18263__auto__)){
return goog.string.startsWith(clojure.string.trim.call(null,code),"/*");
} else {
return and__18263__auto__;
}
})())){
return cljs.compiler.emits.call(null,code);
} else {
var env__26382__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.call(null,code);
} else {
cljs.compiler.emits.call(null,cljs.core.interleave.call(null,cljs.core.concat.call(null,segs,cljs.core.repeat.call(null,null)),cljs.core.concat.call(null,args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__26382__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.build_affecting_options = (function cljs$compiler$build_affecting_options(opts){
return cljs.core.select_keys.call(null,opts,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"static-fns","static-fns",-501950748),new cljs.core.Keyword(null,"optimize-constants","optimize-constants",232704518),new cljs.core.Keyword(null,"elide-asserts","elide-asserts",537063272),new cljs.core.Keyword(null,"target","target",253001721)], null));
});
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
var seq__31228 = cljs.core.seq.call(null,table);
var chunk__31229 = null;
var count__31230 = (0);
var i__31231 = (0);
while(true){
if((i__31231 < count__31230)){
var vec__31232 = cljs.core._nth.call(null,chunk__31229,i__31231);
var sym = cljs.core.nth.call(null,vec__31232,(0),null);
var value = cljs.core.nth.call(null,vec__31232,(1),null);
var ns_31234 = cljs.core.namespace.call(null,sym);
var name_31235 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str("Cannot emit constant for type "),cljs.core.str(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471)], null));

}
}

cljs.compiler.emits.call(null,";\n");

var G__31236 = seq__31228;
var G__31237 = chunk__31229;
var G__31238 = count__31230;
var G__31239 = (i__31231 + (1));
seq__31228 = G__31236;
chunk__31229 = G__31237;
count__31230 = G__31238;
i__31231 = G__31239;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__31228);
if(temp__4425__auto__){
var seq__31228__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31228__$1)){
var c__19078__auto__ = cljs.core.chunk_first.call(null,seq__31228__$1);
var G__31240 = cljs.core.chunk_rest.call(null,seq__31228__$1);
var G__31241 = c__19078__auto__;
var G__31242 = cljs.core.count.call(null,c__19078__auto__);
var G__31243 = (0);
seq__31228 = G__31240;
chunk__31229 = G__31241;
count__31230 = G__31242;
i__31231 = G__31243;
continue;
} else {
var vec__31233 = cljs.core.first.call(null,seq__31228__$1);
var sym = cljs.core.nth.call(null,vec__31233,(0),null);
var value = cljs.core.nth.call(null,vec__31233,(1),null);
var ns_31244 = cljs.core.namespace.call(null,sym);
var name_31245 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str("Cannot emit constant for type "),cljs.core.str(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471)], null));

}
}

cljs.compiler.emits.call(null,";\n");

var G__31246 = cljs.core.next.call(null,seq__31228__$1);
var G__31247 = null;
var G__31248 = (0);
var G__31249 = (0);
seq__31228 = G__31246;
chunk__31229 = G__31247;
count__31230 = G__31248;
i__31231 = G__31249;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=compiler.js.map