// Compiled by ClojureScript 1.7.228 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__18275__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__18275__auto__){
return or__18275__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__18275__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__23671_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__23671_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__23676 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__23677 = null;
var count__23678 = (0);
var i__23679 = (0);
while(true){
if((i__23679 < count__23678)){
var n = cljs.core._nth.call(null,chunk__23677,i__23679);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__23680 = seq__23676;
var G__23681 = chunk__23677;
var G__23682 = count__23678;
var G__23683 = (i__23679 + (1));
seq__23676 = G__23680;
chunk__23677 = G__23681;
count__23678 = G__23682;
i__23679 = G__23683;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__23676);
if(temp__4425__auto__){
var seq__23676__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23676__$1)){
var c__19078__auto__ = cljs.core.chunk_first.call(null,seq__23676__$1);
var G__23684 = cljs.core.chunk_rest.call(null,seq__23676__$1);
var G__23685 = c__19078__auto__;
var G__23686 = cljs.core.count.call(null,c__19078__auto__);
var G__23687 = (0);
seq__23676 = G__23684;
chunk__23677 = G__23685;
count__23678 = G__23686;
i__23679 = G__23687;
continue;
} else {
var n = cljs.core.first.call(null,seq__23676__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__23688 = cljs.core.next.call(null,seq__23676__$1);
var G__23689 = null;
var G__23690 = (0);
var G__23691 = (0);
seq__23676 = G__23688;
chunk__23677 = G__23689;
count__23678 = G__23690;
i__23679 = G__23691;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__23730_23737 = cljs.core.seq.call(null,deps);
var chunk__23731_23738 = null;
var count__23732_23739 = (0);
var i__23733_23740 = (0);
while(true){
if((i__23733_23740 < count__23732_23739)){
var dep_23741 = cljs.core._nth.call(null,chunk__23731_23738,i__23733_23740);
topo_sort_helper_STAR_.call(null,dep_23741,(depth + (1)),state);

var G__23742 = seq__23730_23737;
var G__23743 = chunk__23731_23738;
var G__23744 = count__23732_23739;
var G__23745 = (i__23733_23740 + (1));
seq__23730_23737 = G__23742;
chunk__23731_23738 = G__23743;
count__23732_23739 = G__23744;
i__23733_23740 = G__23745;
continue;
} else {
var temp__4425__auto___23746 = cljs.core.seq.call(null,seq__23730_23737);
if(temp__4425__auto___23746){
var seq__23730_23747__$1 = temp__4425__auto___23746;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23730_23747__$1)){
var c__19078__auto___23748 = cljs.core.chunk_first.call(null,seq__23730_23747__$1);
var G__23749 = cljs.core.chunk_rest.call(null,seq__23730_23747__$1);
var G__23750 = c__19078__auto___23748;
var G__23751 = cljs.core.count.call(null,c__19078__auto___23748);
var G__23752 = (0);
seq__23730_23737 = G__23749;
chunk__23731_23738 = G__23750;
count__23732_23739 = G__23751;
i__23733_23740 = G__23752;
continue;
} else {
var dep_23753 = cljs.core.first.call(null,seq__23730_23747__$1);
topo_sort_helper_STAR_.call(null,dep_23753,(depth + (1)),state);

var G__23754 = cljs.core.next.call(null,seq__23730_23747__$1);
var G__23755 = null;
var G__23756 = (0);
var G__23757 = (0);
seq__23730_23737 = G__23754;
chunk__23731_23738 = G__23755;
count__23732_23739 = G__23756;
i__23733_23740 = G__23757;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__23734){
var vec__23736 = p__23734;
var x = cljs.core.nth.call(null,vec__23736,(0),null);
var xs = cljs.core.nthnext.call(null,vec__23736,(1));
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__23736,x,xs,get_deps__$1){
return (function (p1__23692_SHARP_){
return clojure.set.difference.call(null,p1__23692_SHARP_,x);
});})(vec__23736,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__23770 = cljs.core.seq.call(null,provides);
var chunk__23771 = null;
var count__23772 = (0);
var i__23773 = (0);
while(true){
if((i__23773 < count__23772)){
var prov = cljs.core._nth.call(null,chunk__23771,i__23773);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__23774_23782 = cljs.core.seq.call(null,requires);
var chunk__23775_23783 = null;
var count__23776_23784 = (0);
var i__23777_23785 = (0);
while(true){
if((i__23777_23785 < count__23776_23784)){
var req_23786 = cljs.core._nth.call(null,chunk__23775_23783,i__23777_23785);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_23786,prov);

var G__23787 = seq__23774_23782;
var G__23788 = chunk__23775_23783;
var G__23789 = count__23776_23784;
var G__23790 = (i__23777_23785 + (1));
seq__23774_23782 = G__23787;
chunk__23775_23783 = G__23788;
count__23776_23784 = G__23789;
i__23777_23785 = G__23790;
continue;
} else {
var temp__4425__auto___23791 = cljs.core.seq.call(null,seq__23774_23782);
if(temp__4425__auto___23791){
var seq__23774_23792__$1 = temp__4425__auto___23791;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23774_23792__$1)){
var c__19078__auto___23793 = cljs.core.chunk_first.call(null,seq__23774_23792__$1);
var G__23794 = cljs.core.chunk_rest.call(null,seq__23774_23792__$1);
var G__23795 = c__19078__auto___23793;
var G__23796 = cljs.core.count.call(null,c__19078__auto___23793);
var G__23797 = (0);
seq__23774_23782 = G__23794;
chunk__23775_23783 = G__23795;
count__23776_23784 = G__23796;
i__23777_23785 = G__23797;
continue;
} else {
var req_23798 = cljs.core.first.call(null,seq__23774_23792__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_23798,prov);

var G__23799 = cljs.core.next.call(null,seq__23774_23792__$1);
var G__23800 = null;
var G__23801 = (0);
var G__23802 = (0);
seq__23774_23782 = G__23799;
chunk__23775_23783 = G__23800;
count__23776_23784 = G__23801;
i__23777_23785 = G__23802;
continue;
}
} else {
}
}
break;
}

var G__23803 = seq__23770;
var G__23804 = chunk__23771;
var G__23805 = count__23772;
var G__23806 = (i__23773 + (1));
seq__23770 = G__23803;
chunk__23771 = G__23804;
count__23772 = G__23805;
i__23773 = G__23806;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__23770);
if(temp__4425__auto__){
var seq__23770__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23770__$1)){
var c__19078__auto__ = cljs.core.chunk_first.call(null,seq__23770__$1);
var G__23807 = cljs.core.chunk_rest.call(null,seq__23770__$1);
var G__23808 = c__19078__auto__;
var G__23809 = cljs.core.count.call(null,c__19078__auto__);
var G__23810 = (0);
seq__23770 = G__23807;
chunk__23771 = G__23808;
count__23772 = G__23809;
i__23773 = G__23810;
continue;
} else {
var prov = cljs.core.first.call(null,seq__23770__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__23778_23811 = cljs.core.seq.call(null,requires);
var chunk__23779_23812 = null;
var count__23780_23813 = (0);
var i__23781_23814 = (0);
while(true){
if((i__23781_23814 < count__23780_23813)){
var req_23815 = cljs.core._nth.call(null,chunk__23779_23812,i__23781_23814);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_23815,prov);

var G__23816 = seq__23778_23811;
var G__23817 = chunk__23779_23812;
var G__23818 = count__23780_23813;
var G__23819 = (i__23781_23814 + (1));
seq__23778_23811 = G__23816;
chunk__23779_23812 = G__23817;
count__23780_23813 = G__23818;
i__23781_23814 = G__23819;
continue;
} else {
var temp__4425__auto___23820__$1 = cljs.core.seq.call(null,seq__23778_23811);
if(temp__4425__auto___23820__$1){
var seq__23778_23821__$1 = temp__4425__auto___23820__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23778_23821__$1)){
var c__19078__auto___23822 = cljs.core.chunk_first.call(null,seq__23778_23821__$1);
var G__23823 = cljs.core.chunk_rest.call(null,seq__23778_23821__$1);
var G__23824 = c__19078__auto___23822;
var G__23825 = cljs.core.count.call(null,c__19078__auto___23822);
var G__23826 = (0);
seq__23778_23811 = G__23823;
chunk__23779_23812 = G__23824;
count__23780_23813 = G__23825;
i__23781_23814 = G__23826;
continue;
} else {
var req_23827 = cljs.core.first.call(null,seq__23778_23821__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_23827,prov);

var G__23828 = cljs.core.next.call(null,seq__23778_23821__$1);
var G__23829 = null;
var G__23830 = (0);
var G__23831 = (0);
seq__23778_23811 = G__23828;
chunk__23779_23812 = G__23829;
count__23780_23813 = G__23830;
i__23781_23814 = G__23831;
continue;
}
} else {
}
}
break;
}

var G__23832 = cljs.core.next.call(null,seq__23770__$1);
var G__23833 = null;
var G__23834 = (0);
var G__23835 = (0);
seq__23770 = G__23832;
chunk__23771 = G__23833;
count__23772 = G__23834;
i__23773 = G__23835;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel$client$file_reloading$figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__23840_23844 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__23841_23845 = null;
var count__23842_23846 = (0);
var i__23843_23847 = (0);
while(true){
if((i__23843_23847 < count__23842_23846)){
var ns_23848 = cljs.core._nth.call(null,chunk__23841_23845,i__23843_23847);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_23848);

var G__23849 = seq__23840_23844;
var G__23850 = chunk__23841_23845;
var G__23851 = count__23842_23846;
var G__23852 = (i__23843_23847 + (1));
seq__23840_23844 = G__23849;
chunk__23841_23845 = G__23850;
count__23842_23846 = G__23851;
i__23843_23847 = G__23852;
continue;
} else {
var temp__4425__auto___23853 = cljs.core.seq.call(null,seq__23840_23844);
if(temp__4425__auto___23853){
var seq__23840_23854__$1 = temp__4425__auto___23853;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23840_23854__$1)){
var c__19078__auto___23855 = cljs.core.chunk_first.call(null,seq__23840_23854__$1);
var G__23856 = cljs.core.chunk_rest.call(null,seq__23840_23854__$1);
var G__23857 = c__19078__auto___23855;
var G__23858 = cljs.core.count.call(null,c__19078__auto___23855);
var G__23859 = (0);
seq__23840_23844 = G__23856;
chunk__23841_23845 = G__23857;
count__23842_23846 = G__23858;
i__23843_23847 = G__23859;
continue;
} else {
var ns_23860 = cljs.core.first.call(null,seq__23840_23854__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_23860);

var G__23861 = cljs.core.next.call(null,seq__23840_23854__$1);
var G__23862 = null;
var G__23863 = (0);
var G__23864 = (0);
seq__23840_23844 = G__23861;
chunk__23841_23845 = G__23862;
count__23842_23846 = G__23863;
i__23843_23847 = G__23864;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__18275__auto__ = goog.require__;
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__23865__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__23865 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__23866__i = 0, G__23866__a = new Array(arguments.length -  0);
while (G__23866__i < G__23866__a.length) {G__23866__a[G__23866__i] = arguments[G__23866__i + 0]; ++G__23866__i;}
  args = new cljs.core.IndexedSeq(G__23866__a,0);
} 
return G__23865__delegate.call(this,args);};
G__23865.cljs$lang$maxFixedArity = 0;
G__23865.cljs$lang$applyTo = (function (arglist__23867){
var args = cljs.core.seq(arglist__23867);
return G__23865__delegate(args);
});
G__23865.cljs$core$IFn$_invoke$arity$variadic = G__23865__delegate;
return G__23865;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__23869 = cljs.core._EQ_;
var expr__23870 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__23869.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__23870))){
var path_parts = ((function (pred__23869,expr__23870){
return (function (p1__23868_SHARP_){
return clojure.string.split.call(null,p1__23868_SHARP_,/[\/\\]/);
});})(pred__23869,expr__23870))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__23869,expr__23870){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e23872){if((e23872 instanceof Error)){
var e = e23872;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e23872;

}
}})());
});
;})(path_parts,sep,root,pred__23869,expr__23870))
} else {
if(cljs.core.truth_(pred__23869.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__23870))){
return ((function (pred__23869,expr__23870){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),{"cleanupWhenDone": true});
deferred.addCallback(((function (deferred,pred__23869,expr__23870){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__23869,expr__23870))
);

return deferred.addErrback(((function (deferred,pred__23869,expr__23870){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__23869,expr__23870))
);
});
;})(pred__23869,expr__23870))
} else {
return ((function (pred__23869,expr__23870){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__23869,expr__23870))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__23873,callback){
var map__23876 = p__23873;
var map__23876__$1 = ((((!((map__23876 == null)))?((((map__23876.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23876.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23876):map__23876);
var file_msg = map__23876__$1;
var request_url = cljs.core.get.call(null,map__23876__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__23876,map__23876__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__23876,map__23876__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__20442__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto__){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto__){
return (function (state_23900){
var state_val_23901 = (state_23900[(1)]);
if((state_val_23901 === (7))){
var inst_23896 = (state_23900[(2)]);
var state_23900__$1 = state_23900;
var statearr_23902_23922 = state_23900__$1;
(statearr_23902_23922[(2)] = inst_23896);

(statearr_23902_23922[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23901 === (1))){
var state_23900__$1 = state_23900;
var statearr_23903_23923 = state_23900__$1;
(statearr_23903_23923[(2)] = null);

(statearr_23903_23923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23901 === (4))){
var inst_23880 = (state_23900[(7)]);
var inst_23880__$1 = (state_23900[(2)]);
var state_23900__$1 = (function (){var statearr_23904 = state_23900;
(statearr_23904[(7)] = inst_23880__$1);

return statearr_23904;
})();
if(cljs.core.truth_(inst_23880__$1)){
var statearr_23905_23924 = state_23900__$1;
(statearr_23905_23924[(1)] = (5));

} else {
var statearr_23906_23925 = state_23900__$1;
(statearr_23906_23925[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23901 === (6))){
var state_23900__$1 = state_23900;
var statearr_23907_23926 = state_23900__$1;
(statearr_23907_23926[(2)] = null);

(statearr_23907_23926[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23901 === (3))){
var inst_23898 = (state_23900[(2)]);
var state_23900__$1 = state_23900;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23900__$1,inst_23898);
} else {
if((state_val_23901 === (2))){
var state_23900__$1 = state_23900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23900__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_23901 === (11))){
var inst_23892 = (state_23900[(2)]);
var state_23900__$1 = (function (){var statearr_23908 = state_23900;
(statearr_23908[(8)] = inst_23892);

return statearr_23908;
})();
var statearr_23909_23927 = state_23900__$1;
(statearr_23909_23927[(2)] = null);

(statearr_23909_23927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23901 === (9))){
var inst_23886 = (state_23900[(9)]);
var inst_23884 = (state_23900[(10)]);
var inst_23888 = inst_23886.call(null,inst_23884);
var state_23900__$1 = state_23900;
var statearr_23910_23928 = state_23900__$1;
(statearr_23910_23928[(2)] = inst_23888);

(statearr_23910_23928[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23901 === (5))){
var inst_23880 = (state_23900[(7)]);
var inst_23882 = figwheel.client.file_reloading.blocking_load.call(null,inst_23880);
var state_23900__$1 = state_23900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23900__$1,(8),inst_23882);
} else {
if((state_val_23901 === (10))){
var inst_23884 = (state_23900[(10)]);
var inst_23890 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_23884);
var state_23900__$1 = state_23900;
var statearr_23911_23929 = state_23900__$1;
(statearr_23911_23929[(2)] = inst_23890);

(statearr_23911_23929[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23901 === (8))){
var inst_23886 = (state_23900[(9)]);
var inst_23880 = (state_23900[(7)]);
var inst_23884 = (state_23900[(2)]);
var inst_23885 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_23886__$1 = cljs.core.get.call(null,inst_23885,inst_23880);
var state_23900__$1 = (function (){var statearr_23912 = state_23900;
(statearr_23912[(9)] = inst_23886__$1);

(statearr_23912[(10)] = inst_23884);

return statearr_23912;
})();
if(cljs.core.truth_(inst_23886__$1)){
var statearr_23913_23930 = state_23900__$1;
(statearr_23913_23930[(1)] = (9));

} else {
var statearr_23914_23931 = state_23900__$1;
(statearr_23914_23931[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto__))
;
return ((function (switch__20330__auto__,c__20442__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__20331__auto__ = null;
var figwheel$client$file_reloading$state_machine__20331__auto____0 = (function (){
var statearr_23918 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23918[(0)] = figwheel$client$file_reloading$state_machine__20331__auto__);

(statearr_23918[(1)] = (1));

return statearr_23918;
});
var figwheel$client$file_reloading$state_machine__20331__auto____1 = (function (state_23900){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_23900);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e23919){if((e23919 instanceof Object)){
var ex__20334__auto__ = e23919;
var statearr_23920_23932 = state_23900;
(statearr_23920_23932[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23900);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23919;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23933 = state_23900;
state_23900 = G__23933;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__20331__auto__ = function(state_23900){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__20331__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__20331__auto____1.call(this,state_23900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__20331__auto____0;
figwheel$client$file_reloading$state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__20331__auto____1;
return figwheel$client$file_reloading$state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto__))
})();
var state__20444__auto__ = (function (){var statearr_23921 = f__20443__auto__.call(null);
(statearr_23921[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto__);

return statearr_23921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto__))
);

return c__20442__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__23934,callback){
var map__23937 = p__23934;
var map__23937__$1 = ((((!((map__23937 == null)))?((((map__23937.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23937.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23937):map__23937);
var file_msg = map__23937__$1;
var namespace = cljs.core.get.call(null,map__23937__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__23937,map__23937__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__23937,map__23937__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__23939){
var map__23942 = p__23939;
var map__23942__$1 = ((((!((map__23942 == null)))?((((map__23942.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23942.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23942):map__23942);
var file_msg = map__23942__$1;
var namespace = cljs.core.get.call(null,map__23942__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__18263__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__18263__auto__){
var or__18275__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
var or__18275__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__18275__auto____$1)){
return or__18275__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__18263__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__23944,callback){
var map__23947 = p__23944;
var map__23947__$1 = ((((!((map__23947 == null)))?((((map__23947.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23947.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23947):map__23947);
var file_msg = map__23947__$1;
var request_url = cljs.core.get.call(null,map__23947__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__23947__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__20442__auto___24035 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto___24035,out){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto___24035,out){
return (function (state_24017){
var state_val_24018 = (state_24017[(1)]);
if((state_val_24018 === (1))){
var inst_23995 = cljs.core.nth.call(null,files,(0),null);
var inst_23996 = cljs.core.nthnext.call(null,files,(1));
var inst_23997 = files;
var state_24017__$1 = (function (){var statearr_24019 = state_24017;
(statearr_24019[(7)] = inst_23997);

(statearr_24019[(8)] = inst_23996);

(statearr_24019[(9)] = inst_23995);

return statearr_24019;
})();
var statearr_24020_24036 = state_24017__$1;
(statearr_24020_24036[(2)] = null);

(statearr_24020_24036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24018 === (2))){
var inst_23997 = (state_24017[(7)]);
var inst_24000 = (state_24017[(10)]);
var inst_24000__$1 = cljs.core.nth.call(null,inst_23997,(0),null);
var inst_24001 = cljs.core.nthnext.call(null,inst_23997,(1));
var inst_24002 = (inst_24000__$1 == null);
var inst_24003 = cljs.core.not.call(null,inst_24002);
var state_24017__$1 = (function (){var statearr_24021 = state_24017;
(statearr_24021[(11)] = inst_24001);

(statearr_24021[(10)] = inst_24000__$1);

return statearr_24021;
})();
if(inst_24003){
var statearr_24022_24037 = state_24017__$1;
(statearr_24022_24037[(1)] = (4));

} else {
var statearr_24023_24038 = state_24017__$1;
(statearr_24023_24038[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24018 === (3))){
var inst_24015 = (state_24017[(2)]);
var state_24017__$1 = state_24017;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24017__$1,inst_24015);
} else {
if((state_val_24018 === (4))){
var inst_24000 = (state_24017[(10)]);
var inst_24005 = figwheel.client.file_reloading.reload_js_file.call(null,inst_24000);
var state_24017__$1 = state_24017;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24017__$1,(7),inst_24005);
} else {
if((state_val_24018 === (5))){
var inst_24011 = cljs.core.async.close_BANG_.call(null,out);
var state_24017__$1 = state_24017;
var statearr_24024_24039 = state_24017__$1;
(statearr_24024_24039[(2)] = inst_24011);

(statearr_24024_24039[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24018 === (6))){
var inst_24013 = (state_24017[(2)]);
var state_24017__$1 = state_24017;
var statearr_24025_24040 = state_24017__$1;
(statearr_24025_24040[(2)] = inst_24013);

(statearr_24025_24040[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24018 === (7))){
var inst_24001 = (state_24017[(11)]);
var inst_24007 = (state_24017[(2)]);
var inst_24008 = cljs.core.async.put_BANG_.call(null,out,inst_24007);
var inst_23997 = inst_24001;
var state_24017__$1 = (function (){var statearr_24026 = state_24017;
(statearr_24026[(12)] = inst_24008);

(statearr_24026[(7)] = inst_23997);

return statearr_24026;
})();
var statearr_24027_24041 = state_24017__$1;
(statearr_24027_24041[(2)] = null);

(statearr_24027_24041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__20442__auto___24035,out))
;
return ((function (switch__20330__auto__,c__20442__auto___24035,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20331__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20331__auto____0 = (function (){
var statearr_24031 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24031[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20331__auto__);

(statearr_24031[(1)] = (1));

return statearr_24031;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20331__auto____1 = (function (state_24017){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_24017);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e24032){if((e24032 instanceof Object)){
var ex__20334__auto__ = e24032;
var statearr_24033_24042 = state_24017;
(statearr_24033_24042[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24017);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24032;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24043 = state_24017;
state_24017 = G__24043;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20331__auto__ = function(state_24017){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20331__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20331__auto____1.call(this,state_24017);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20331__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20331__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto___24035,out))
})();
var state__20444__auto__ = (function (){var statearr_24034 = f__20443__auto__.call(null);
(statearr_24034[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto___24035);

return statearr_24034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto___24035,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__24044,opts){
var map__24048 = p__24044;
var map__24048__$1 = ((((!((map__24048 == null)))?((((map__24048.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24048.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24048):map__24048);
var eval_body__$1 = cljs.core.get.call(null,map__24048__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__24048__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__18263__auto__ = eval_body__$1;
if(cljs.core.truth_(and__18263__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__18263__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e24050){var e = e24050;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4423__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__24051_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__24051_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4423__auto__)){
var file_msg = temp__4423__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__24056){
var vec__24057 = p__24056;
var k = cljs.core.nth.call(null,vec__24057,(0),null);
var v = cljs.core.nth.call(null,vec__24057,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__24058){
var vec__24059 = p__24058;
var k = cljs.core.nth.call(null,vec__24059,(0),null);
var v = cljs.core.nth.call(null,vec__24059,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__24063,p__24064){
var map__24311 = p__24063;
var map__24311__$1 = ((((!((map__24311 == null)))?((((map__24311.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24311.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24311):map__24311);
var opts = map__24311__$1;
var before_jsload = cljs.core.get.call(null,map__24311__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__24311__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__24311__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__24312 = p__24064;
var map__24312__$1 = ((((!((map__24312 == null)))?((((map__24312.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24312.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24312):map__24312);
var msg = map__24312__$1;
var files = cljs.core.get.call(null,map__24312__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__24312__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__24312__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__20442__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_24465){
var state_val_24466 = (state_24465[(1)]);
if((state_val_24466 === (7))){
var inst_24327 = (state_24465[(7)]);
var inst_24328 = (state_24465[(8)]);
var inst_24329 = (state_24465[(9)]);
var inst_24326 = (state_24465[(10)]);
var inst_24334 = cljs.core._nth.call(null,inst_24327,inst_24329);
var inst_24335 = figwheel.client.file_reloading.eval_body.call(null,inst_24334,opts);
var inst_24336 = (inst_24329 + (1));
var tmp24467 = inst_24327;
var tmp24468 = inst_24328;
var tmp24469 = inst_24326;
var inst_24326__$1 = tmp24469;
var inst_24327__$1 = tmp24467;
var inst_24328__$1 = tmp24468;
var inst_24329__$1 = inst_24336;
var state_24465__$1 = (function (){var statearr_24470 = state_24465;
(statearr_24470[(7)] = inst_24327__$1);

(statearr_24470[(8)] = inst_24328__$1);

(statearr_24470[(9)] = inst_24329__$1);

(statearr_24470[(10)] = inst_24326__$1);

(statearr_24470[(11)] = inst_24335);

return statearr_24470;
})();
var statearr_24471_24557 = state_24465__$1;
(statearr_24471_24557[(2)] = null);

(statearr_24471_24557[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (20))){
var inst_24369 = (state_24465[(12)]);
var inst_24377 = figwheel.client.file_reloading.sort_files.call(null,inst_24369);
var state_24465__$1 = state_24465;
var statearr_24472_24558 = state_24465__$1;
(statearr_24472_24558[(2)] = inst_24377);

(statearr_24472_24558[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (27))){
var state_24465__$1 = state_24465;
var statearr_24473_24559 = state_24465__$1;
(statearr_24473_24559[(2)] = null);

(statearr_24473_24559[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (1))){
var inst_24318 = (state_24465[(13)]);
var inst_24315 = before_jsload.call(null,files);
var inst_24316 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_24317 = (function (){return ((function (inst_24318,inst_24315,inst_24316,state_val_24466,c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__24060_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__24060_SHARP_);
});
;})(inst_24318,inst_24315,inst_24316,state_val_24466,c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24318__$1 = cljs.core.filter.call(null,inst_24317,files);
var inst_24319 = cljs.core.not_empty.call(null,inst_24318__$1);
var state_24465__$1 = (function (){var statearr_24474 = state_24465;
(statearr_24474[(13)] = inst_24318__$1);

(statearr_24474[(14)] = inst_24316);

(statearr_24474[(15)] = inst_24315);

return statearr_24474;
})();
if(cljs.core.truth_(inst_24319)){
var statearr_24475_24560 = state_24465__$1;
(statearr_24475_24560[(1)] = (2));

} else {
var statearr_24476_24561 = state_24465__$1;
(statearr_24476_24561[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (24))){
var state_24465__$1 = state_24465;
var statearr_24477_24562 = state_24465__$1;
(statearr_24477_24562[(2)] = null);

(statearr_24477_24562[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (39))){
var inst_24419 = (state_24465[(16)]);
var state_24465__$1 = state_24465;
var statearr_24478_24563 = state_24465__$1;
(statearr_24478_24563[(2)] = inst_24419);

(statearr_24478_24563[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (46))){
var inst_24460 = (state_24465[(2)]);
var state_24465__$1 = state_24465;
var statearr_24479_24564 = state_24465__$1;
(statearr_24479_24564[(2)] = inst_24460);

(statearr_24479_24564[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (4))){
var inst_24363 = (state_24465[(2)]);
var inst_24364 = cljs.core.List.EMPTY;
var inst_24365 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_24364);
var inst_24366 = (function (){return ((function (inst_24363,inst_24364,inst_24365,state_val_24466,c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__24061_SHARP_){
var and__18263__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__24061_SHARP_);
if(cljs.core.truth_(and__18263__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__24061_SHARP_));
} else {
return and__18263__auto__;
}
});
;})(inst_24363,inst_24364,inst_24365,state_val_24466,c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24367 = cljs.core.filter.call(null,inst_24366,files);
var inst_24368 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_24369 = cljs.core.concat.call(null,inst_24367,inst_24368);
var state_24465__$1 = (function (){var statearr_24480 = state_24465;
(statearr_24480[(17)] = inst_24365);

(statearr_24480[(18)] = inst_24363);

(statearr_24480[(12)] = inst_24369);

return statearr_24480;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_24481_24565 = state_24465__$1;
(statearr_24481_24565[(1)] = (16));

} else {
var statearr_24482_24566 = state_24465__$1;
(statearr_24482_24566[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (15))){
var inst_24353 = (state_24465[(2)]);
var state_24465__$1 = state_24465;
var statearr_24483_24567 = state_24465__$1;
(statearr_24483_24567[(2)] = inst_24353);

(statearr_24483_24567[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (21))){
var inst_24379 = (state_24465[(19)]);
var inst_24379__$1 = (state_24465[(2)]);
var inst_24380 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_24379__$1);
var state_24465__$1 = (function (){var statearr_24484 = state_24465;
(statearr_24484[(19)] = inst_24379__$1);

return statearr_24484;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24465__$1,(22),inst_24380);
} else {
if((state_val_24466 === (31))){
var inst_24463 = (state_24465[(2)]);
var state_24465__$1 = state_24465;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24465__$1,inst_24463);
} else {
if((state_val_24466 === (32))){
var inst_24419 = (state_24465[(16)]);
var inst_24424 = inst_24419.cljs$lang$protocol_mask$partition0$;
var inst_24425 = (inst_24424 & (64));
var inst_24426 = inst_24419.cljs$core$ISeq$;
var inst_24427 = (inst_24425) || (inst_24426);
var state_24465__$1 = state_24465;
if(cljs.core.truth_(inst_24427)){
var statearr_24485_24568 = state_24465__$1;
(statearr_24485_24568[(1)] = (35));

} else {
var statearr_24486_24569 = state_24465__$1;
(statearr_24486_24569[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (40))){
var inst_24440 = (state_24465[(20)]);
var inst_24439 = (state_24465[(2)]);
var inst_24440__$1 = cljs.core.get.call(null,inst_24439,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_24441 = cljs.core.get.call(null,inst_24439,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_24442 = cljs.core.not_empty.call(null,inst_24440__$1);
var state_24465__$1 = (function (){var statearr_24487 = state_24465;
(statearr_24487[(21)] = inst_24441);

(statearr_24487[(20)] = inst_24440__$1);

return statearr_24487;
})();
if(cljs.core.truth_(inst_24442)){
var statearr_24488_24570 = state_24465__$1;
(statearr_24488_24570[(1)] = (41));

} else {
var statearr_24489_24571 = state_24465__$1;
(statearr_24489_24571[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (33))){
var state_24465__$1 = state_24465;
var statearr_24490_24572 = state_24465__$1;
(statearr_24490_24572[(2)] = false);

(statearr_24490_24572[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (13))){
var inst_24339 = (state_24465[(22)]);
var inst_24343 = cljs.core.chunk_first.call(null,inst_24339);
var inst_24344 = cljs.core.chunk_rest.call(null,inst_24339);
var inst_24345 = cljs.core.count.call(null,inst_24343);
var inst_24326 = inst_24344;
var inst_24327 = inst_24343;
var inst_24328 = inst_24345;
var inst_24329 = (0);
var state_24465__$1 = (function (){var statearr_24491 = state_24465;
(statearr_24491[(7)] = inst_24327);

(statearr_24491[(8)] = inst_24328);

(statearr_24491[(9)] = inst_24329);

(statearr_24491[(10)] = inst_24326);

return statearr_24491;
})();
var statearr_24492_24573 = state_24465__$1;
(statearr_24492_24573[(2)] = null);

(statearr_24492_24573[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (22))){
var inst_24382 = (state_24465[(23)]);
var inst_24387 = (state_24465[(24)]);
var inst_24383 = (state_24465[(25)]);
var inst_24379 = (state_24465[(19)]);
var inst_24382__$1 = (state_24465[(2)]);
var inst_24383__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_24382__$1);
var inst_24384 = (function (){var all_files = inst_24379;
var res_SINGLEQUOTE_ = inst_24382__$1;
var res = inst_24383__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_24382,inst_24387,inst_24383,inst_24379,inst_24382__$1,inst_24383__$1,state_val_24466,c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__24062_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__24062_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_24382,inst_24387,inst_24383,inst_24379,inst_24382__$1,inst_24383__$1,state_val_24466,c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24385 = cljs.core.filter.call(null,inst_24384,inst_24382__$1);
var inst_24386 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_24387__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_24386);
var inst_24388 = cljs.core.not_empty.call(null,inst_24387__$1);
var state_24465__$1 = (function (){var statearr_24493 = state_24465;
(statearr_24493[(23)] = inst_24382__$1);

(statearr_24493[(26)] = inst_24385);

(statearr_24493[(24)] = inst_24387__$1);

(statearr_24493[(25)] = inst_24383__$1);

return statearr_24493;
})();
if(cljs.core.truth_(inst_24388)){
var statearr_24494_24574 = state_24465__$1;
(statearr_24494_24574[(1)] = (23));

} else {
var statearr_24495_24575 = state_24465__$1;
(statearr_24495_24575[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (36))){
var state_24465__$1 = state_24465;
var statearr_24496_24576 = state_24465__$1;
(statearr_24496_24576[(2)] = false);

(statearr_24496_24576[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (41))){
var inst_24440 = (state_24465[(20)]);
var inst_24444 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_24445 = cljs.core.map.call(null,inst_24444,inst_24440);
var inst_24446 = cljs.core.pr_str.call(null,inst_24445);
var inst_24447 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_24446)].join('');
var inst_24448 = figwheel.client.utils.log.call(null,inst_24447);
var state_24465__$1 = state_24465;
var statearr_24497_24577 = state_24465__$1;
(statearr_24497_24577[(2)] = inst_24448);

(statearr_24497_24577[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (43))){
var inst_24441 = (state_24465[(21)]);
var inst_24451 = (state_24465[(2)]);
var inst_24452 = cljs.core.not_empty.call(null,inst_24441);
var state_24465__$1 = (function (){var statearr_24498 = state_24465;
(statearr_24498[(27)] = inst_24451);

return statearr_24498;
})();
if(cljs.core.truth_(inst_24452)){
var statearr_24499_24578 = state_24465__$1;
(statearr_24499_24578[(1)] = (44));

} else {
var statearr_24500_24579 = state_24465__$1;
(statearr_24500_24579[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (29))){
var inst_24382 = (state_24465[(23)]);
var inst_24385 = (state_24465[(26)]);
var inst_24387 = (state_24465[(24)]);
var inst_24383 = (state_24465[(25)]);
var inst_24379 = (state_24465[(19)]);
var inst_24419 = (state_24465[(16)]);
var inst_24415 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_24418 = (function (){var all_files = inst_24379;
var res_SINGLEQUOTE_ = inst_24382;
var res = inst_24383;
var files_not_loaded = inst_24385;
var dependencies_that_loaded = inst_24387;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24382,inst_24385,inst_24387,inst_24383,inst_24379,inst_24419,inst_24415,state_val_24466,c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__24417){
var map__24501 = p__24417;
var map__24501__$1 = ((((!((map__24501 == null)))?((((map__24501.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24501.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24501):map__24501);
var namespace = cljs.core.get.call(null,map__24501__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24382,inst_24385,inst_24387,inst_24383,inst_24379,inst_24419,inst_24415,state_val_24466,c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24419__$1 = cljs.core.group_by.call(null,inst_24418,inst_24385);
var inst_24421 = (inst_24419__$1 == null);
var inst_24422 = cljs.core.not.call(null,inst_24421);
var state_24465__$1 = (function (){var statearr_24503 = state_24465;
(statearr_24503[(28)] = inst_24415);

(statearr_24503[(16)] = inst_24419__$1);

return statearr_24503;
})();
if(inst_24422){
var statearr_24504_24580 = state_24465__$1;
(statearr_24504_24580[(1)] = (32));

} else {
var statearr_24505_24581 = state_24465__$1;
(statearr_24505_24581[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (44))){
var inst_24441 = (state_24465[(21)]);
var inst_24454 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_24441);
var inst_24455 = cljs.core.pr_str.call(null,inst_24454);
var inst_24456 = [cljs.core.str("not required: "),cljs.core.str(inst_24455)].join('');
var inst_24457 = figwheel.client.utils.log.call(null,inst_24456);
var state_24465__$1 = state_24465;
var statearr_24506_24582 = state_24465__$1;
(statearr_24506_24582[(2)] = inst_24457);

(statearr_24506_24582[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (6))){
var inst_24360 = (state_24465[(2)]);
var state_24465__$1 = state_24465;
var statearr_24507_24583 = state_24465__$1;
(statearr_24507_24583[(2)] = inst_24360);

(statearr_24507_24583[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (28))){
var inst_24385 = (state_24465[(26)]);
var inst_24412 = (state_24465[(2)]);
var inst_24413 = cljs.core.not_empty.call(null,inst_24385);
var state_24465__$1 = (function (){var statearr_24508 = state_24465;
(statearr_24508[(29)] = inst_24412);

return statearr_24508;
})();
if(cljs.core.truth_(inst_24413)){
var statearr_24509_24584 = state_24465__$1;
(statearr_24509_24584[(1)] = (29));

} else {
var statearr_24510_24585 = state_24465__$1;
(statearr_24510_24585[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (25))){
var inst_24383 = (state_24465[(25)]);
var inst_24399 = (state_24465[(2)]);
var inst_24400 = cljs.core.not_empty.call(null,inst_24383);
var state_24465__$1 = (function (){var statearr_24511 = state_24465;
(statearr_24511[(30)] = inst_24399);

return statearr_24511;
})();
if(cljs.core.truth_(inst_24400)){
var statearr_24512_24586 = state_24465__$1;
(statearr_24512_24586[(1)] = (26));

} else {
var statearr_24513_24587 = state_24465__$1;
(statearr_24513_24587[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (34))){
var inst_24434 = (state_24465[(2)]);
var state_24465__$1 = state_24465;
if(cljs.core.truth_(inst_24434)){
var statearr_24514_24588 = state_24465__$1;
(statearr_24514_24588[(1)] = (38));

} else {
var statearr_24515_24589 = state_24465__$1;
(statearr_24515_24589[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (17))){
var state_24465__$1 = state_24465;
var statearr_24516_24590 = state_24465__$1;
(statearr_24516_24590[(2)] = recompile_dependents);

(statearr_24516_24590[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (3))){
var state_24465__$1 = state_24465;
var statearr_24517_24591 = state_24465__$1;
(statearr_24517_24591[(2)] = null);

(statearr_24517_24591[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (12))){
var inst_24356 = (state_24465[(2)]);
var state_24465__$1 = state_24465;
var statearr_24518_24592 = state_24465__$1;
(statearr_24518_24592[(2)] = inst_24356);

(statearr_24518_24592[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (2))){
var inst_24318 = (state_24465[(13)]);
var inst_24325 = cljs.core.seq.call(null,inst_24318);
var inst_24326 = inst_24325;
var inst_24327 = null;
var inst_24328 = (0);
var inst_24329 = (0);
var state_24465__$1 = (function (){var statearr_24519 = state_24465;
(statearr_24519[(7)] = inst_24327);

(statearr_24519[(8)] = inst_24328);

(statearr_24519[(9)] = inst_24329);

(statearr_24519[(10)] = inst_24326);

return statearr_24519;
})();
var statearr_24520_24593 = state_24465__$1;
(statearr_24520_24593[(2)] = null);

(statearr_24520_24593[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (23))){
var inst_24382 = (state_24465[(23)]);
var inst_24385 = (state_24465[(26)]);
var inst_24387 = (state_24465[(24)]);
var inst_24383 = (state_24465[(25)]);
var inst_24379 = (state_24465[(19)]);
var inst_24390 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_24392 = (function (){var all_files = inst_24379;
var res_SINGLEQUOTE_ = inst_24382;
var res = inst_24383;
var files_not_loaded = inst_24385;
var dependencies_that_loaded = inst_24387;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24382,inst_24385,inst_24387,inst_24383,inst_24379,inst_24390,state_val_24466,c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__24391){
var map__24521 = p__24391;
var map__24521__$1 = ((((!((map__24521 == null)))?((((map__24521.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24521.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24521):map__24521);
var request_url = cljs.core.get.call(null,map__24521__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24382,inst_24385,inst_24387,inst_24383,inst_24379,inst_24390,state_val_24466,c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24393 = cljs.core.reverse.call(null,inst_24387);
var inst_24394 = cljs.core.map.call(null,inst_24392,inst_24393);
var inst_24395 = cljs.core.pr_str.call(null,inst_24394);
var inst_24396 = figwheel.client.utils.log.call(null,inst_24395);
var state_24465__$1 = (function (){var statearr_24523 = state_24465;
(statearr_24523[(31)] = inst_24390);

return statearr_24523;
})();
var statearr_24524_24594 = state_24465__$1;
(statearr_24524_24594[(2)] = inst_24396);

(statearr_24524_24594[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (35))){
var state_24465__$1 = state_24465;
var statearr_24525_24595 = state_24465__$1;
(statearr_24525_24595[(2)] = true);

(statearr_24525_24595[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (19))){
var inst_24369 = (state_24465[(12)]);
var inst_24375 = figwheel.client.file_reloading.expand_files.call(null,inst_24369);
var state_24465__$1 = state_24465;
var statearr_24526_24596 = state_24465__$1;
(statearr_24526_24596[(2)] = inst_24375);

(statearr_24526_24596[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (11))){
var state_24465__$1 = state_24465;
var statearr_24527_24597 = state_24465__$1;
(statearr_24527_24597[(2)] = null);

(statearr_24527_24597[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (9))){
var inst_24358 = (state_24465[(2)]);
var state_24465__$1 = state_24465;
var statearr_24528_24598 = state_24465__$1;
(statearr_24528_24598[(2)] = inst_24358);

(statearr_24528_24598[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (5))){
var inst_24328 = (state_24465[(8)]);
var inst_24329 = (state_24465[(9)]);
var inst_24331 = (inst_24329 < inst_24328);
var inst_24332 = inst_24331;
var state_24465__$1 = state_24465;
if(cljs.core.truth_(inst_24332)){
var statearr_24529_24599 = state_24465__$1;
(statearr_24529_24599[(1)] = (7));

} else {
var statearr_24530_24600 = state_24465__$1;
(statearr_24530_24600[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (14))){
var inst_24339 = (state_24465[(22)]);
var inst_24348 = cljs.core.first.call(null,inst_24339);
var inst_24349 = figwheel.client.file_reloading.eval_body.call(null,inst_24348,opts);
var inst_24350 = cljs.core.next.call(null,inst_24339);
var inst_24326 = inst_24350;
var inst_24327 = null;
var inst_24328 = (0);
var inst_24329 = (0);
var state_24465__$1 = (function (){var statearr_24531 = state_24465;
(statearr_24531[(7)] = inst_24327);

(statearr_24531[(32)] = inst_24349);

(statearr_24531[(8)] = inst_24328);

(statearr_24531[(9)] = inst_24329);

(statearr_24531[(10)] = inst_24326);

return statearr_24531;
})();
var statearr_24532_24601 = state_24465__$1;
(statearr_24532_24601[(2)] = null);

(statearr_24532_24601[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (45))){
var state_24465__$1 = state_24465;
var statearr_24533_24602 = state_24465__$1;
(statearr_24533_24602[(2)] = null);

(statearr_24533_24602[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (26))){
var inst_24382 = (state_24465[(23)]);
var inst_24385 = (state_24465[(26)]);
var inst_24387 = (state_24465[(24)]);
var inst_24383 = (state_24465[(25)]);
var inst_24379 = (state_24465[(19)]);
var inst_24402 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_24404 = (function (){var all_files = inst_24379;
var res_SINGLEQUOTE_ = inst_24382;
var res = inst_24383;
var files_not_loaded = inst_24385;
var dependencies_that_loaded = inst_24387;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24382,inst_24385,inst_24387,inst_24383,inst_24379,inst_24402,state_val_24466,c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__24403){
var map__24534 = p__24403;
var map__24534__$1 = ((((!((map__24534 == null)))?((((map__24534.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24534.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24534):map__24534);
var namespace = cljs.core.get.call(null,map__24534__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__24534__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24382,inst_24385,inst_24387,inst_24383,inst_24379,inst_24402,state_val_24466,c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24405 = cljs.core.map.call(null,inst_24404,inst_24383);
var inst_24406 = cljs.core.pr_str.call(null,inst_24405);
var inst_24407 = figwheel.client.utils.log.call(null,inst_24406);
var inst_24408 = (function (){var all_files = inst_24379;
var res_SINGLEQUOTE_ = inst_24382;
var res = inst_24383;
var files_not_loaded = inst_24385;
var dependencies_that_loaded = inst_24387;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24382,inst_24385,inst_24387,inst_24383,inst_24379,inst_24402,inst_24404,inst_24405,inst_24406,inst_24407,state_val_24466,c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24382,inst_24385,inst_24387,inst_24383,inst_24379,inst_24402,inst_24404,inst_24405,inst_24406,inst_24407,state_val_24466,c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24409 = setTimeout(inst_24408,(10));
var state_24465__$1 = (function (){var statearr_24536 = state_24465;
(statearr_24536[(33)] = inst_24407);

(statearr_24536[(34)] = inst_24402);

return statearr_24536;
})();
var statearr_24537_24603 = state_24465__$1;
(statearr_24537_24603[(2)] = inst_24409);

(statearr_24537_24603[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (16))){
var state_24465__$1 = state_24465;
var statearr_24538_24604 = state_24465__$1;
(statearr_24538_24604[(2)] = reload_dependents);

(statearr_24538_24604[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (38))){
var inst_24419 = (state_24465[(16)]);
var inst_24436 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24419);
var state_24465__$1 = state_24465;
var statearr_24539_24605 = state_24465__$1;
(statearr_24539_24605[(2)] = inst_24436);

(statearr_24539_24605[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (30))){
var state_24465__$1 = state_24465;
var statearr_24540_24606 = state_24465__$1;
(statearr_24540_24606[(2)] = null);

(statearr_24540_24606[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (10))){
var inst_24339 = (state_24465[(22)]);
var inst_24341 = cljs.core.chunked_seq_QMARK_.call(null,inst_24339);
var state_24465__$1 = state_24465;
if(inst_24341){
var statearr_24541_24607 = state_24465__$1;
(statearr_24541_24607[(1)] = (13));

} else {
var statearr_24542_24608 = state_24465__$1;
(statearr_24542_24608[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (18))){
var inst_24373 = (state_24465[(2)]);
var state_24465__$1 = state_24465;
if(cljs.core.truth_(inst_24373)){
var statearr_24543_24609 = state_24465__$1;
(statearr_24543_24609[(1)] = (19));

} else {
var statearr_24544_24610 = state_24465__$1;
(statearr_24544_24610[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (42))){
var state_24465__$1 = state_24465;
var statearr_24545_24611 = state_24465__$1;
(statearr_24545_24611[(2)] = null);

(statearr_24545_24611[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (37))){
var inst_24431 = (state_24465[(2)]);
var state_24465__$1 = state_24465;
var statearr_24546_24612 = state_24465__$1;
(statearr_24546_24612[(2)] = inst_24431);

(statearr_24546_24612[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24466 === (8))){
var inst_24339 = (state_24465[(22)]);
var inst_24326 = (state_24465[(10)]);
var inst_24339__$1 = cljs.core.seq.call(null,inst_24326);
var state_24465__$1 = (function (){var statearr_24547 = state_24465;
(statearr_24547[(22)] = inst_24339__$1);

return statearr_24547;
})();
if(inst_24339__$1){
var statearr_24548_24613 = state_24465__$1;
(statearr_24548_24613[(1)] = (10));

} else {
var statearr_24549_24614 = state_24465__$1;
(statearr_24549_24614[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__20330__auto__,c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20331__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20331__auto____0 = (function (){
var statearr_24553 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24553[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__20331__auto__);

(statearr_24553[(1)] = (1));

return statearr_24553;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20331__auto____1 = (function (state_24465){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_24465);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e24554){if((e24554 instanceof Object)){
var ex__20334__auto__ = e24554;
var statearr_24555_24615 = state_24465;
(statearr_24555_24615[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24465);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24554;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24616 = state_24465;
state_24465 = G__24616;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__20331__auto__ = function(state_24465){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20331__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20331__auto____1.call(this,state_24465);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__20331__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__20331__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__20444__auto__ = (function (){var statearr_24556 = f__20443__auto__.call(null);
(statearr_24556[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto__);

return statearr_24556;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto__,map__24311,map__24311__$1,opts,before_jsload,on_jsload,reload_dependents,map__24312,map__24312__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__20442__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__24619,link){
var map__24622 = p__24619;
var map__24622__$1 = ((((!((map__24622 == null)))?((((map__24622.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24622.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24622):map__24622);
var file = cljs.core.get.call(null,map__24622__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = link.href;
if(cljs.core.truth_(temp__4425__auto__)){
var link_href = temp__4425__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4425__auto__,map__24622,map__24622__$1,file){
return (function (p1__24617_SHARP_,p2__24618_SHARP_){
if(cljs.core._EQ_.call(null,p1__24617_SHARP_,p2__24618_SHARP_)){
return p1__24617_SHARP_;
} else {
return false;
}
});})(link_href,temp__4425__auto__,map__24622,map__24622__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4425__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__24628){
var map__24629 = p__24628;
var map__24629__$1 = ((((!((map__24629 == null)))?((((map__24629.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24629.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24629):map__24629);
var match_length = cljs.core.get.call(null,map__24629__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__24629__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__24624_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__24624_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4425__auto__)){
var res = temp__4425__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args24631 = [];
var len__19333__auto___24634 = arguments.length;
var i__19334__auto___24635 = (0);
while(true){
if((i__19334__auto___24635 < len__19333__auto___24634)){
args24631.push((arguments[i__19334__auto___24635]));

var G__24636 = (i__19334__auto___24635 + (1));
i__19334__auto___24635 = G__24636;
continue;
} else {
}
break;
}

var G__24633 = args24631.length;
switch (G__24633) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24631.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__24638_SHARP_,p2__24639_SHARP_){
return cljs.core.assoc.call(null,p1__24638_SHARP_,cljs.core.get.call(null,p2__24639_SHARP_,key),p2__24639_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__24640){
var map__24643 = p__24640;
var map__24643__$1 = ((((!((map__24643 == null)))?((((map__24643.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24643.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24643):map__24643);
var f_data = map__24643__$1;
var file = cljs.core.get.call(null,map__24643__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4425__auto__)){
var link = temp__4425__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__24645,files_msg){
var map__24652 = p__24645;
var map__24652__$1 = ((((!((map__24652 == null)))?((((map__24652.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24652.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24652):map__24652);
var opts = map__24652__$1;
var on_cssload = cljs.core.get.call(null,map__24652__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__24654_24658 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__24655_24659 = null;
var count__24656_24660 = (0);
var i__24657_24661 = (0);
while(true){
if((i__24657_24661 < count__24656_24660)){
var f_24662 = cljs.core._nth.call(null,chunk__24655_24659,i__24657_24661);
figwheel.client.file_reloading.reload_css_file.call(null,f_24662);

var G__24663 = seq__24654_24658;
var G__24664 = chunk__24655_24659;
var G__24665 = count__24656_24660;
var G__24666 = (i__24657_24661 + (1));
seq__24654_24658 = G__24663;
chunk__24655_24659 = G__24664;
count__24656_24660 = G__24665;
i__24657_24661 = G__24666;
continue;
} else {
var temp__4425__auto___24667 = cljs.core.seq.call(null,seq__24654_24658);
if(temp__4425__auto___24667){
var seq__24654_24668__$1 = temp__4425__auto___24667;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24654_24668__$1)){
var c__19078__auto___24669 = cljs.core.chunk_first.call(null,seq__24654_24668__$1);
var G__24670 = cljs.core.chunk_rest.call(null,seq__24654_24668__$1);
var G__24671 = c__19078__auto___24669;
var G__24672 = cljs.core.count.call(null,c__19078__auto___24669);
var G__24673 = (0);
seq__24654_24658 = G__24670;
chunk__24655_24659 = G__24671;
count__24656_24660 = G__24672;
i__24657_24661 = G__24673;
continue;
} else {
var f_24674 = cljs.core.first.call(null,seq__24654_24668__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_24674);

var G__24675 = cljs.core.next.call(null,seq__24654_24668__$1);
var G__24676 = null;
var G__24677 = (0);
var G__24678 = (0);
seq__24654_24658 = G__24675;
chunk__24655_24659 = G__24676;
count__24656_24660 = G__24677;
i__24657_24661 = G__24678;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__24652,map__24652__$1,opts,on_cssload){
return (function (){
return on_cssload.call(null,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg));
});})(map__24652,map__24652__$1,opts,on_cssload))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map