// Compiled by ClojureScript 1.7.228 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
goog.require('cljs.repl');
goog.require('figwheel.client.heads_up');
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),args], null));

return args;
});
figwheel.client.autoload_QMARK_ = (cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?(function (){
var pred__24935 = cljs.core._EQ_;
var expr__24936 = (function (){var or__18275__auto__ = (function (){try{return localStorage.getItem("figwheel_autoload");
}catch (e24939){if((e24939 instanceof Error)){
var e = e24939;
return false;
} else {
throw e24939;

}
}})();
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return "true";
}
})();
if(cljs.core.truth_(pred__24935.call(null,"true",expr__24936))){
return true;
} else {
if(cljs.core.truth_(pred__24935.call(null,"false",expr__24936))){
return false;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__24936)].join('')));
}
}
}):(function (){
return true;
}));
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
try{localStorage.setItem("figwheel_autoload",cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));

return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Figwheel autoloading "),cljs.core.str((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));
}catch (e24941){if((e24941 instanceof Error)){
var e = e24941;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Unable to access localStorage")].join(''));
} else {
throw e24941;

}
}} else {
return null;
}
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
figwheel.client.console_print = (function figwheel$client$console_print(args){
console.log.apply(console,cljs.core.into_array.call(null,args));

return args;
});
figwheel.client.repl_print_fn = (function figwheel$client$repl_print_fn(var_args){
var args__19340__auto__ = [];
var len__19333__auto___24943 = arguments.length;
var i__19334__auto___24944 = (0);
while(true){
if((i__19334__auto___24944 < len__19333__auto___24943)){
args__19340__auto__.push((arguments[i__19334__auto___24944]));

var G__24945 = (i__19334__auto___24944 + (1));
i__19334__auto___24944 = G__24945;
continue;
} else {
}
break;
}

var argseq__19341__auto__ = ((((0) < args__19340__auto__.length))?(new cljs.core.IndexedSeq(args__19340__auto__.slice((0)),(0))):null);
return figwheel.client.repl_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__19341__auto__);
});

figwheel.client.repl_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.figwheel_repl_print.call(null,figwheel.client.console_print.call(null,args));

return null;
});

figwheel.client.repl_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_print_fn.cljs$lang$applyTo = (function (seq24942){
return figwheel.client.repl_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq24942));
});
figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

return cljs.core._STAR_print_fn_STAR_ = figwheel.client.repl_print_fn;
});
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel$client$get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__24946){
var map__24949 = p__24946;
var map__24949__$1 = ((((!((map__24949 == null)))?((((map__24949.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24949.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24949):map__24949);
var message = cljs.core.get.call(null,map__24949__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__24949__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str(class$),cljs.core.str(" : "),cljs.core.str(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__18275__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__18275__auto__)){
return or__18275__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__18263__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__18263__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__18263__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__20442__auto___25111 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto___25111,ch){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto___25111,ch){
return (function (state_25080){
var state_val_25081 = (state_25080[(1)]);
if((state_val_25081 === (7))){
var inst_25076 = (state_25080[(2)]);
var state_25080__$1 = state_25080;
var statearr_25082_25112 = state_25080__$1;
(statearr_25082_25112[(2)] = inst_25076);

(statearr_25082_25112[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (1))){
var state_25080__$1 = state_25080;
var statearr_25083_25113 = state_25080__$1;
(statearr_25083_25113[(2)] = null);

(statearr_25083_25113[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (4))){
var inst_25033 = (state_25080[(7)]);
var inst_25033__$1 = (state_25080[(2)]);
var state_25080__$1 = (function (){var statearr_25084 = state_25080;
(statearr_25084[(7)] = inst_25033__$1);

return statearr_25084;
})();
if(cljs.core.truth_(inst_25033__$1)){
var statearr_25085_25114 = state_25080__$1;
(statearr_25085_25114[(1)] = (5));

} else {
var statearr_25086_25115 = state_25080__$1;
(statearr_25086_25115[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (15))){
var inst_25040 = (state_25080[(8)]);
var inst_25055 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_25040);
var inst_25056 = cljs.core.first.call(null,inst_25055);
var inst_25057 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_25056);
var inst_25058 = [cljs.core.str("Figwheel: Not loading code with warnings - "),cljs.core.str(inst_25057)].join('');
var inst_25059 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_25058);
var state_25080__$1 = state_25080;
var statearr_25087_25116 = state_25080__$1;
(statearr_25087_25116[(2)] = inst_25059);

(statearr_25087_25116[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (13))){
var inst_25064 = (state_25080[(2)]);
var state_25080__$1 = state_25080;
var statearr_25088_25117 = state_25080__$1;
(statearr_25088_25117[(2)] = inst_25064);

(statearr_25088_25117[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (6))){
var state_25080__$1 = state_25080;
var statearr_25089_25118 = state_25080__$1;
(statearr_25089_25118[(2)] = null);

(statearr_25089_25118[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (17))){
var inst_25062 = (state_25080[(2)]);
var state_25080__$1 = state_25080;
var statearr_25090_25119 = state_25080__$1;
(statearr_25090_25119[(2)] = inst_25062);

(statearr_25090_25119[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (3))){
var inst_25078 = (state_25080[(2)]);
var state_25080__$1 = state_25080;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25080__$1,inst_25078);
} else {
if((state_val_25081 === (12))){
var inst_25039 = (state_25080[(9)]);
var inst_25053 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_25039,opts);
var state_25080__$1 = state_25080;
if(cljs.core.truth_(inst_25053)){
var statearr_25091_25120 = state_25080__$1;
(statearr_25091_25120[(1)] = (15));

} else {
var statearr_25092_25121 = state_25080__$1;
(statearr_25092_25121[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (2))){
var state_25080__$1 = state_25080;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25080__$1,(4),ch);
} else {
if((state_val_25081 === (11))){
var inst_25040 = (state_25080[(8)]);
var inst_25045 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25046 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_25040);
var inst_25047 = cljs.core.async.timeout.call(null,(1000));
var inst_25048 = [inst_25046,inst_25047];
var inst_25049 = (new cljs.core.PersistentVector(null,2,(5),inst_25045,inst_25048,null));
var state_25080__$1 = state_25080;
return cljs.core.async.ioc_alts_BANG_.call(null,state_25080__$1,(14),inst_25049);
} else {
if((state_val_25081 === (9))){
var inst_25040 = (state_25080[(8)]);
var inst_25066 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_25067 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_25040);
var inst_25068 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_25067);
var inst_25069 = [cljs.core.str("Not loading: "),cljs.core.str(inst_25068)].join('');
var inst_25070 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_25069);
var state_25080__$1 = (function (){var statearr_25093 = state_25080;
(statearr_25093[(10)] = inst_25066);

return statearr_25093;
})();
var statearr_25094_25122 = state_25080__$1;
(statearr_25094_25122[(2)] = inst_25070);

(statearr_25094_25122[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (5))){
var inst_25033 = (state_25080[(7)]);
var inst_25035 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_25036 = (new cljs.core.PersistentArrayMap(null,2,inst_25035,null));
var inst_25037 = (new cljs.core.PersistentHashSet(null,inst_25036,null));
var inst_25038 = figwheel.client.focus_msgs.call(null,inst_25037,inst_25033);
var inst_25039 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_25038);
var inst_25040 = cljs.core.first.call(null,inst_25038);
var inst_25041 = figwheel.client.autoload_QMARK_.call(null);
var state_25080__$1 = (function (){var statearr_25095 = state_25080;
(statearr_25095[(8)] = inst_25040);

(statearr_25095[(9)] = inst_25039);

return statearr_25095;
})();
if(cljs.core.truth_(inst_25041)){
var statearr_25096_25123 = state_25080__$1;
(statearr_25096_25123[(1)] = (8));

} else {
var statearr_25097_25124 = state_25080__$1;
(statearr_25097_25124[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (14))){
var inst_25051 = (state_25080[(2)]);
var state_25080__$1 = state_25080;
var statearr_25098_25125 = state_25080__$1;
(statearr_25098_25125[(2)] = inst_25051);

(statearr_25098_25125[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (16))){
var state_25080__$1 = state_25080;
var statearr_25099_25126 = state_25080__$1;
(statearr_25099_25126[(2)] = null);

(statearr_25099_25126[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (10))){
var inst_25072 = (state_25080[(2)]);
var state_25080__$1 = (function (){var statearr_25100 = state_25080;
(statearr_25100[(11)] = inst_25072);

return statearr_25100;
})();
var statearr_25101_25127 = state_25080__$1;
(statearr_25101_25127[(2)] = null);

(statearr_25101_25127[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (8))){
var inst_25039 = (state_25080[(9)]);
var inst_25043 = figwheel.client.reload_file_state_QMARK_.call(null,inst_25039,opts);
var state_25080__$1 = state_25080;
if(cljs.core.truth_(inst_25043)){
var statearr_25102_25128 = state_25080__$1;
(statearr_25102_25128[(1)] = (11));

} else {
var statearr_25103_25129 = state_25080__$1;
(statearr_25103_25129[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto___25111,ch))
;
return ((function (switch__20330__auto__,c__20442__auto___25111,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__20331__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__20331__auto____0 = (function (){
var statearr_25107 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25107[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__20331__auto__);

(statearr_25107[(1)] = (1));

return statearr_25107;
});
var figwheel$client$file_reloader_plugin_$_state_machine__20331__auto____1 = (function (state_25080){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_25080);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e25108){if((e25108 instanceof Object)){
var ex__20334__auto__ = e25108;
var statearr_25109_25130 = state_25080;
(statearr_25109_25130[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25080);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25108;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25131 = state_25080;
state_25080 = G__25131;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__20331__auto__ = function(state_25080){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__20331__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__20331__auto____1.call(this,state_25080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__20331__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__20331__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto___25111,ch))
})();
var state__20444__auto__ = (function (){var statearr_25110 = f__20443__auto__.call(null);
(statearr_25110[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto___25111);

return statearr_25110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto___25111,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__25132_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__25132_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_25139 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_25139){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var _STAR_print_fn_STAR_25137 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR_25138 = cljs.core._STAR_print_newline_STAR_;
cljs.core._STAR_print_fn_STAR_ = figwheel.client.repl_print_fn;

cljs.core._STAR_print_newline_STAR_ = false;

try{return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),figwheel.client.utils.eval_helper.call(null,code,opts)], null));
}finally {cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_25138;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_25137;
}}catch (e25136){if((e25136 instanceof Error)){
var e = e25136;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_25139], null));
} else {
var e = e25136;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}});})(base_path_25139))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = {};
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__25140){
var map__25147 = p__25140;
var map__25147__$1 = ((((!((map__25147 == null)))?((((map__25147.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25147.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25147):map__25147);
var opts = map__25147__$1;
var build_id = cljs.core.get.call(null,map__25147__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__25147,map__25147__$1,opts,build_id){
return (function (p__25149){
var vec__25150 = p__25149;
var map__25151 = cljs.core.nth.call(null,vec__25150,(0),null);
var map__25151__$1 = ((((!((map__25151 == null)))?((((map__25151.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25151.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25151):map__25151);
var msg = map__25151__$1;
var msg_name = cljs.core.get.call(null,map__25151__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__25150,(1));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__25150,map__25151,map__25151__$1,msg,msg_name,_,map__25147,map__25147__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__25150,map__25151,map__25151__$1,msg,msg_name,_,map__25147,map__25147__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__25147,map__25147__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__25157){
var vec__25158 = p__25157;
var map__25159 = cljs.core.nth.call(null,vec__25158,(0),null);
var map__25159__$1 = ((((!((map__25159 == null)))?((((map__25159.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25159.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25159):map__25159);
var msg = map__25159__$1;
var msg_name = cljs.core.get.call(null,map__25159__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__25158,(1));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__25161){
var map__25171 = p__25161;
var map__25171__$1 = ((((!((map__25171 == null)))?((((map__25171.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25171.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25171):map__25171);
var on_compile_warning = cljs.core.get.call(null,map__25171__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__25171__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__25171,map__25171__$1,on_compile_warning,on_compile_fail){
return (function (p__25173){
var vec__25174 = p__25173;
var map__25175 = cljs.core.nth.call(null,vec__25174,(0),null);
var map__25175__$1 = ((((!((map__25175 == null)))?((((map__25175.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25175.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25175):map__25175);
var msg = map__25175__$1;
var msg_name = cljs.core.get.call(null,map__25175__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__25174,(1));
var pred__25177 = cljs.core._EQ_;
var expr__25178 = msg_name;
if(cljs.core.truth_(pred__25177.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__25178))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__25177.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__25178))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__25171,map__25171__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__20442__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto__,msg_hist,msg_names,msg){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto__,msg_hist,msg_names,msg){
return (function (state_25394){
var state_val_25395 = (state_25394[(1)]);
if((state_val_25395 === (7))){
var inst_25318 = (state_25394[(2)]);
var state_25394__$1 = state_25394;
if(cljs.core.truth_(inst_25318)){
var statearr_25396_25442 = state_25394__$1;
(statearr_25396_25442[(1)] = (8));

} else {
var statearr_25397_25443 = state_25394__$1;
(statearr_25397_25443[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (20))){
var inst_25388 = (state_25394[(2)]);
var state_25394__$1 = state_25394;
var statearr_25398_25444 = state_25394__$1;
(statearr_25398_25444[(2)] = inst_25388);

(statearr_25398_25444[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (27))){
var inst_25384 = (state_25394[(2)]);
var state_25394__$1 = state_25394;
var statearr_25399_25445 = state_25394__$1;
(statearr_25399_25445[(2)] = inst_25384);

(statearr_25399_25445[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (1))){
var inst_25311 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_25394__$1 = state_25394;
if(cljs.core.truth_(inst_25311)){
var statearr_25400_25446 = state_25394__$1;
(statearr_25400_25446[(1)] = (2));

} else {
var statearr_25401_25447 = state_25394__$1;
(statearr_25401_25447[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (24))){
var inst_25386 = (state_25394[(2)]);
var state_25394__$1 = state_25394;
var statearr_25402_25448 = state_25394__$1;
(statearr_25402_25448[(2)] = inst_25386);

(statearr_25402_25448[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (4))){
var inst_25392 = (state_25394[(2)]);
var state_25394__$1 = state_25394;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25394__$1,inst_25392);
} else {
if((state_val_25395 === (15))){
var inst_25390 = (state_25394[(2)]);
var state_25394__$1 = state_25394;
var statearr_25403_25449 = state_25394__$1;
(statearr_25403_25449[(2)] = inst_25390);

(statearr_25403_25449[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (21))){
var inst_25349 = (state_25394[(2)]);
var state_25394__$1 = state_25394;
var statearr_25404_25450 = state_25394__$1;
(statearr_25404_25450[(2)] = inst_25349);

(statearr_25404_25450[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (31))){
var inst_25373 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_25394__$1 = state_25394;
if(cljs.core.truth_(inst_25373)){
var statearr_25405_25451 = state_25394__$1;
(statearr_25405_25451[(1)] = (34));

} else {
var statearr_25406_25452 = state_25394__$1;
(statearr_25406_25452[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (32))){
var inst_25382 = (state_25394[(2)]);
var state_25394__$1 = state_25394;
var statearr_25407_25453 = state_25394__$1;
(statearr_25407_25453[(2)] = inst_25382);

(statearr_25407_25453[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (33))){
var inst_25371 = (state_25394[(2)]);
var state_25394__$1 = state_25394;
var statearr_25408_25454 = state_25394__$1;
(statearr_25408_25454[(2)] = inst_25371);

(statearr_25408_25454[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (13))){
var inst_25332 = figwheel.client.heads_up.clear.call(null);
var state_25394__$1 = state_25394;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25394__$1,(16),inst_25332);
} else {
if((state_val_25395 === (22))){
var inst_25353 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_25354 = figwheel.client.heads_up.append_message.call(null,inst_25353);
var state_25394__$1 = state_25394;
var statearr_25409_25455 = state_25394__$1;
(statearr_25409_25455[(2)] = inst_25354);

(statearr_25409_25455[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (36))){
var inst_25380 = (state_25394[(2)]);
var state_25394__$1 = state_25394;
var statearr_25410_25456 = state_25394__$1;
(statearr_25410_25456[(2)] = inst_25380);

(statearr_25410_25456[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (29))){
var inst_25364 = (state_25394[(2)]);
var state_25394__$1 = state_25394;
var statearr_25411_25457 = state_25394__$1;
(statearr_25411_25457[(2)] = inst_25364);

(statearr_25411_25457[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (6))){
var inst_25313 = (state_25394[(7)]);
var state_25394__$1 = state_25394;
var statearr_25412_25458 = state_25394__$1;
(statearr_25412_25458[(2)] = inst_25313);

(statearr_25412_25458[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (28))){
var inst_25360 = (state_25394[(2)]);
var inst_25361 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_25362 = figwheel.client.heads_up.display_warning.call(null,inst_25361);
var state_25394__$1 = (function (){var statearr_25413 = state_25394;
(statearr_25413[(8)] = inst_25360);

return statearr_25413;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25394__$1,(29),inst_25362);
} else {
if((state_val_25395 === (25))){
var inst_25358 = figwheel.client.heads_up.clear.call(null);
var state_25394__$1 = state_25394;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25394__$1,(28),inst_25358);
} else {
if((state_val_25395 === (34))){
var inst_25375 = figwheel.client.heads_up.flash_loaded.call(null);
var state_25394__$1 = state_25394;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25394__$1,(37),inst_25375);
} else {
if((state_val_25395 === (17))){
var inst_25340 = (state_25394[(2)]);
var state_25394__$1 = state_25394;
var statearr_25414_25459 = state_25394__$1;
(statearr_25414_25459[(2)] = inst_25340);

(statearr_25414_25459[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (3))){
var inst_25330 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_25394__$1 = state_25394;
if(cljs.core.truth_(inst_25330)){
var statearr_25415_25460 = state_25394__$1;
(statearr_25415_25460[(1)] = (13));

} else {
var statearr_25416_25461 = state_25394__$1;
(statearr_25416_25461[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (12))){
var inst_25326 = (state_25394[(2)]);
var state_25394__$1 = state_25394;
var statearr_25417_25462 = state_25394__$1;
(statearr_25417_25462[(2)] = inst_25326);

(statearr_25417_25462[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (2))){
var inst_25313 = (state_25394[(7)]);
var inst_25313__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_25394__$1 = (function (){var statearr_25418 = state_25394;
(statearr_25418[(7)] = inst_25313__$1);

return statearr_25418;
})();
if(cljs.core.truth_(inst_25313__$1)){
var statearr_25419_25463 = state_25394__$1;
(statearr_25419_25463[(1)] = (5));

} else {
var statearr_25420_25464 = state_25394__$1;
(statearr_25420_25464[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (23))){
var inst_25356 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_25394__$1 = state_25394;
if(cljs.core.truth_(inst_25356)){
var statearr_25421_25465 = state_25394__$1;
(statearr_25421_25465[(1)] = (25));

} else {
var statearr_25422_25466 = state_25394__$1;
(statearr_25422_25466[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (35))){
var state_25394__$1 = state_25394;
var statearr_25423_25467 = state_25394__$1;
(statearr_25423_25467[(2)] = null);

(statearr_25423_25467[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (19))){
var inst_25351 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_25394__$1 = state_25394;
if(cljs.core.truth_(inst_25351)){
var statearr_25424_25468 = state_25394__$1;
(statearr_25424_25468[(1)] = (22));

} else {
var statearr_25425_25469 = state_25394__$1;
(statearr_25425_25469[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (11))){
var inst_25322 = (state_25394[(2)]);
var state_25394__$1 = state_25394;
var statearr_25426_25470 = state_25394__$1;
(statearr_25426_25470[(2)] = inst_25322);

(statearr_25426_25470[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (9))){
var inst_25324 = figwheel.client.heads_up.clear.call(null);
var state_25394__$1 = state_25394;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25394__$1,(12),inst_25324);
} else {
if((state_val_25395 === (5))){
var inst_25315 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_25394__$1 = state_25394;
var statearr_25427_25471 = state_25394__$1;
(statearr_25427_25471[(2)] = inst_25315);

(statearr_25427_25471[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (14))){
var inst_25342 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_25394__$1 = state_25394;
if(cljs.core.truth_(inst_25342)){
var statearr_25428_25472 = state_25394__$1;
(statearr_25428_25472[(1)] = (18));

} else {
var statearr_25429_25473 = state_25394__$1;
(statearr_25429_25473[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (26))){
var inst_25366 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_25394__$1 = state_25394;
if(cljs.core.truth_(inst_25366)){
var statearr_25430_25474 = state_25394__$1;
(statearr_25430_25474[(1)] = (30));

} else {
var statearr_25431_25475 = state_25394__$1;
(statearr_25431_25475[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (16))){
var inst_25334 = (state_25394[(2)]);
var inst_25335 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_25336 = figwheel.client.format_messages.call(null,inst_25335);
var inst_25337 = new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(msg);
var inst_25338 = figwheel.client.heads_up.display_error.call(null,inst_25336,inst_25337);
var state_25394__$1 = (function (){var statearr_25432 = state_25394;
(statearr_25432[(9)] = inst_25334);

return statearr_25432;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25394__$1,(17),inst_25338);
} else {
if((state_val_25395 === (30))){
var inst_25368 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_25369 = figwheel.client.heads_up.display_warning.call(null,inst_25368);
var state_25394__$1 = state_25394;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25394__$1,(33),inst_25369);
} else {
if((state_val_25395 === (10))){
var inst_25328 = (state_25394[(2)]);
var state_25394__$1 = state_25394;
var statearr_25433_25476 = state_25394__$1;
(statearr_25433_25476[(2)] = inst_25328);

(statearr_25433_25476[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (18))){
var inst_25344 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_25345 = figwheel.client.format_messages.call(null,inst_25344);
var inst_25346 = new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(msg);
var inst_25347 = figwheel.client.heads_up.display_error.call(null,inst_25345,inst_25346);
var state_25394__$1 = state_25394;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25394__$1,(21),inst_25347);
} else {
if((state_val_25395 === (37))){
var inst_25377 = (state_25394[(2)]);
var state_25394__$1 = state_25394;
var statearr_25434_25477 = state_25394__$1;
(statearr_25434_25477[(2)] = inst_25377);

(statearr_25434_25477[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25395 === (8))){
var inst_25320 = figwheel.client.heads_up.flash_loaded.call(null);
var state_25394__$1 = state_25394;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25394__$1,(11),inst_25320);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20442__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__20330__auto__,c__20442__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20331__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20331__auto____0 = (function (){
var statearr_25438 = [null,null,null,null,null,null,null,null,null,null];
(statearr_25438[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20331__auto__);

(statearr_25438[(1)] = (1));

return statearr_25438;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20331__auto____1 = (function (state_25394){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_25394);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e25439){if((e25439 instanceof Object)){
var ex__20334__auto__ = e25439;
var statearr_25440_25478 = state_25394;
(statearr_25440_25478[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25394);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25439;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25479 = state_25394;
state_25394 = G__25479;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20331__auto__ = function(state_25394){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20331__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20331__auto____1.call(this,state_25394);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20331__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20331__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto__,msg_hist,msg_names,msg))
})();
var state__20444__auto__ = (function (){var statearr_25441 = f__20443__auto__.call(null);
(statearr_25441[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto__);

return statearr_25441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto__,msg_hist,msg_names,msg))
);

return c__20442__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__20442__auto___25542 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto___25542,ch){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto___25542,ch){
return (function (state_25525){
var state_val_25526 = (state_25525[(1)]);
if((state_val_25526 === (1))){
var state_25525__$1 = state_25525;
var statearr_25527_25543 = state_25525__$1;
(statearr_25527_25543[(2)] = null);

(statearr_25527_25543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25526 === (2))){
var state_25525__$1 = state_25525;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25525__$1,(4),ch);
} else {
if((state_val_25526 === (3))){
var inst_25523 = (state_25525[(2)]);
var state_25525__$1 = state_25525;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25525__$1,inst_25523);
} else {
if((state_val_25526 === (4))){
var inst_25513 = (state_25525[(7)]);
var inst_25513__$1 = (state_25525[(2)]);
var state_25525__$1 = (function (){var statearr_25528 = state_25525;
(statearr_25528[(7)] = inst_25513__$1);

return statearr_25528;
})();
if(cljs.core.truth_(inst_25513__$1)){
var statearr_25529_25544 = state_25525__$1;
(statearr_25529_25544[(1)] = (5));

} else {
var statearr_25530_25545 = state_25525__$1;
(statearr_25530_25545[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25526 === (5))){
var inst_25513 = (state_25525[(7)]);
var inst_25515 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_25513);
var state_25525__$1 = state_25525;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25525__$1,(8),inst_25515);
} else {
if((state_val_25526 === (6))){
var state_25525__$1 = state_25525;
var statearr_25531_25546 = state_25525__$1;
(statearr_25531_25546[(2)] = null);

(statearr_25531_25546[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25526 === (7))){
var inst_25521 = (state_25525[(2)]);
var state_25525__$1 = state_25525;
var statearr_25532_25547 = state_25525__$1;
(statearr_25532_25547[(2)] = inst_25521);

(statearr_25532_25547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25526 === (8))){
var inst_25517 = (state_25525[(2)]);
var state_25525__$1 = (function (){var statearr_25533 = state_25525;
(statearr_25533[(8)] = inst_25517);

return statearr_25533;
})();
var statearr_25534_25548 = state_25525__$1;
(statearr_25534_25548[(2)] = null);

(statearr_25534_25548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__20442__auto___25542,ch))
;
return ((function (switch__20330__auto__,c__20442__auto___25542,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__20331__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__20331__auto____0 = (function (){
var statearr_25538 = [null,null,null,null,null,null,null,null,null];
(statearr_25538[(0)] = figwheel$client$heads_up_plugin_$_state_machine__20331__auto__);

(statearr_25538[(1)] = (1));

return statearr_25538;
});
var figwheel$client$heads_up_plugin_$_state_machine__20331__auto____1 = (function (state_25525){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_25525);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e25539){if((e25539 instanceof Object)){
var ex__20334__auto__ = e25539;
var statearr_25540_25549 = state_25525;
(statearr_25540_25549[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25525);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25539;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25550 = state_25525;
state_25525 = G__25550;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__20331__auto__ = function(state_25525){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__20331__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__20331__auto____1.call(this,state_25525);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__20331__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__20331__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto___25542,ch))
})();
var state__20444__auto__ = (function (){var statearr_25541 = f__20443__auto__.call(null);
(statearr_25541[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto___25542);

return statearr_25541;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto___25542,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__20442__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20442__auto__){
return (function (){
var f__20443__auto__ = (function (){var switch__20330__auto__ = ((function (c__20442__auto__){
return (function (state_25571){
var state_val_25572 = (state_25571[(1)]);
if((state_val_25572 === (1))){
var inst_25566 = cljs.core.async.timeout.call(null,(3000));
var state_25571__$1 = state_25571;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25571__$1,(2),inst_25566);
} else {
if((state_val_25572 === (2))){
var inst_25568 = (state_25571[(2)]);
var inst_25569 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_25571__$1 = (function (){var statearr_25573 = state_25571;
(statearr_25573[(7)] = inst_25568);

return statearr_25573;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25571__$1,inst_25569);
} else {
return null;
}
}
});})(c__20442__auto__))
;
return ((function (switch__20330__auto__,c__20442__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__20331__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__20331__auto____0 = (function (){
var statearr_25577 = [null,null,null,null,null,null,null,null];
(statearr_25577[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__20331__auto__);

(statearr_25577[(1)] = (1));

return statearr_25577;
});
var figwheel$client$enforce_project_plugin_$_state_machine__20331__auto____1 = (function (state_25571){
while(true){
var ret_value__20332__auto__ = (function (){try{while(true){
var result__20333__auto__ = switch__20330__auto__.call(null,state_25571);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20333__auto__;
}
break;
}
}catch (e25578){if((e25578 instanceof Object)){
var ex__20334__auto__ = e25578;
var statearr_25579_25581 = state_25571;
(statearr_25579_25581[(5)] = ex__20334__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25571);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25578;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20332__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25582 = state_25571;
state_25571 = G__25582;
continue;
} else {
return ret_value__20332__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__20331__auto__ = function(state_25571){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__20331__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__20331__auto____1.call(this,state_25571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__20331__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__20331__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__20331__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__20331__auto__;
})()
;})(switch__20330__auto__,c__20442__auto__))
})();
var state__20444__auto__ = (function (){var statearr_25580 = f__20443__auto__.call(null);
(statearr_25580[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20442__auto__);

return statearr_25580;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20444__auto__);
});})(c__20442__auto__))
);

return c__20442__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__25583){
var map__25590 = p__25583;
var map__25590__$1 = ((((!((map__25590 == null)))?((((map__25590.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25590.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25590):map__25590);
var ed = map__25590__$1;
var formatted_exception = cljs.core.get.call(null,map__25590__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__25590__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__25590__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__25592_25596 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__25593_25597 = null;
var count__25594_25598 = (0);
var i__25595_25599 = (0);
while(true){
if((i__25595_25599 < count__25594_25598)){
var msg_25600 = cljs.core._nth.call(null,chunk__25593_25597,i__25595_25599);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_25600);

var G__25601 = seq__25592_25596;
var G__25602 = chunk__25593_25597;
var G__25603 = count__25594_25598;
var G__25604 = (i__25595_25599 + (1));
seq__25592_25596 = G__25601;
chunk__25593_25597 = G__25602;
count__25594_25598 = G__25603;
i__25595_25599 = G__25604;
continue;
} else {
var temp__4425__auto___25605 = cljs.core.seq.call(null,seq__25592_25596);
if(temp__4425__auto___25605){
var seq__25592_25606__$1 = temp__4425__auto___25605;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25592_25606__$1)){
var c__19078__auto___25607 = cljs.core.chunk_first.call(null,seq__25592_25606__$1);
var G__25608 = cljs.core.chunk_rest.call(null,seq__25592_25606__$1);
var G__25609 = c__19078__auto___25607;
var G__25610 = cljs.core.count.call(null,c__19078__auto___25607);
var G__25611 = (0);
seq__25592_25596 = G__25608;
chunk__25593_25597 = G__25609;
count__25594_25598 = G__25610;
i__25595_25599 = G__25611;
continue;
} else {
var msg_25612 = cljs.core.first.call(null,seq__25592_25606__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_25612);

var G__25613 = cljs.core.next.call(null,seq__25592_25606__$1);
var G__25614 = null;
var G__25615 = (0);
var G__25616 = (0);
seq__25592_25596 = G__25613;
chunk__25593_25597 = G__25614;
count__25594_25598 = G__25615;
i__25595_25599 = G__25616;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Error on file "),cljs.core.str(new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(cause)),cljs.core.str(", line "),cljs.core.str(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(cause)),cljs.core.str(", column "),cljs.core.str(new cljs.core.Keyword(null,"column","column",2078222095).cljs$core$IFn$_invoke$arity$1(cause))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__25617){
var map__25620 = p__25617;
var map__25620__$1 = ((((!((map__25620 == null)))?((((map__25620.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25620.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25620):map__25620);
var w = map__25620__$1;
var message = cljs.core.get.call(null,map__25620__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str("Figwheel: Compile Warning - "),cljs.core.str(message)].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[figwheel.client.default_on_compile_warning,figwheel.client.default_on_jsload,true,figwheel.client.default_on_compile_fail,false,true,[cljs.core.str("ws://"),cljs.core.str((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str("/figwheel-ws")].join(''),figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__18263__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__18263__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__18263__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__25628 = cljs.core.seq.call(null,plugins);
var chunk__25629 = null;
var count__25630 = (0);
var i__25631 = (0);
while(true){
if((i__25631 < count__25630)){
var vec__25632 = cljs.core._nth.call(null,chunk__25629,i__25631);
var k = cljs.core.nth.call(null,vec__25632,(0),null);
var plugin = cljs.core.nth.call(null,vec__25632,(1),null);
if(cljs.core.truth_(plugin)){
var pl_25634 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__25628,chunk__25629,count__25630,i__25631,pl_25634,vec__25632,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_25634.call(null,msg_hist);
});})(seq__25628,chunk__25629,count__25630,i__25631,pl_25634,vec__25632,k,plugin))
);
} else {
}

var G__25635 = seq__25628;
var G__25636 = chunk__25629;
var G__25637 = count__25630;
var G__25638 = (i__25631 + (1));
seq__25628 = G__25635;
chunk__25629 = G__25636;
count__25630 = G__25637;
i__25631 = G__25638;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__25628);
if(temp__4425__auto__){
var seq__25628__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25628__$1)){
var c__19078__auto__ = cljs.core.chunk_first.call(null,seq__25628__$1);
var G__25639 = cljs.core.chunk_rest.call(null,seq__25628__$1);
var G__25640 = c__19078__auto__;
var G__25641 = cljs.core.count.call(null,c__19078__auto__);
var G__25642 = (0);
seq__25628 = G__25639;
chunk__25629 = G__25640;
count__25630 = G__25641;
i__25631 = G__25642;
continue;
} else {
var vec__25633 = cljs.core.first.call(null,seq__25628__$1);
var k = cljs.core.nth.call(null,vec__25633,(0),null);
var plugin = cljs.core.nth.call(null,vec__25633,(1),null);
if(cljs.core.truth_(plugin)){
var pl_25643 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__25628,chunk__25629,count__25630,i__25631,pl_25643,vec__25633,k,plugin,seq__25628__$1,temp__4425__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_25643.call(null,msg_hist);
});})(seq__25628,chunk__25629,count__25630,i__25631,pl_25643,vec__25633,k,plugin,seq__25628__$1,temp__4425__auto__))
);
} else {
}

var G__25644 = cljs.core.next.call(null,seq__25628__$1);
var G__25645 = null;
var G__25646 = (0);
var G__25647 = (0);
seq__25628 = G__25644;
chunk__25629 = G__25645;
count__25630 = G__25646;
i__25631 = G__25647;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var args25648 = [];
var len__19333__auto___25651 = arguments.length;
var i__19334__auto___25652 = (0);
while(true){
if((i__19334__auto___25652 < len__19333__auto___25651)){
args25648.push((arguments[i__19334__auto___25652]));

var G__25653 = (i__19334__auto___25652 + (1));
i__19334__auto___25652 = G__25653;
continue;
} else {
}
break;
}

var G__25650 = args25648.length;
switch (G__25650) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25648.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

return figwheel.client.socket.open.call(null,system_options);
}));
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;
figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__19340__auto__ = [];
var len__19333__auto___25659 = arguments.length;
var i__19334__auto___25660 = (0);
while(true){
if((i__19334__auto___25660 < len__19333__auto___25659)){
args__19340__auto__.push((arguments[i__19334__auto___25660]));

var G__25661 = (i__19334__auto___25660 + (1));
i__19334__auto___25660 = G__25661;
continue;
} else {
}
break;
}

var argseq__19341__auto__ = ((((0) < args__19340__auto__.length))?(new cljs.core.IndexedSeq(args__19340__auto__.slice((0)),(0))):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__19341__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__25656){
var map__25657 = p__25656;
var map__25657__$1 = ((((!((map__25657 == null)))?((((map__25657.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25657.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25657):map__25657);
var opts = map__25657__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq25655){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq25655));
});

//# sourceMappingURL=client.js.map