// Compiled by ClojureScript 1.7.228 {}
goog.provide('gadjett.collections');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('clojure.string');
gadjett.collections.to_regular_array = (function gadjett$collections$to_regular_array(arr){
return (new cljs.core.IndexedSeq(arr,(0)));
});
gadjett.collections._EQ_without_keys_QMARK_ = (function gadjett$collections$_EQ_without_keys_QMARK_(obj_a,obj_b,keys_list){
return cljs.core.apply.call(null,cljs.core._EQ_,cljs.core.map.call(null,(function (p1__19680_SHARP_){
return cljs.core.apply.call(null,cljs.core.dissoc,p1__19680_SHARP_,keys_list);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [obj_a,obj_b], null)));
});
/**
 * Converts a 2d vec to a hash-map.
 *   E.g. 
 * 
 * [[:a 1] [:b 2]] -> {:a 1 :b 2}
 * 
 */
gadjett.collections.vec__GT_map = (function gadjett$collections$vec__GT_map(vec){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,vec);
});
gadjett.collections.map_2d_vec = (function gadjett$collections$map_2d_vec(f,m){
return cljs.core.map.call(null,(function (p__19683){
var vec__19684 = p__19683;
var k = cljs.core.nth.call(null,vec__19684,(0),null);
var id = cljs.core.nth.call(null,vec__19684,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,f.call(null,id)], null);
}),m);
});
/**
 * Usage:
 * 
 *    (map-object f m)
 * 
 *   Returns a map with the same keys as `m` and with the values transformed by `f`.
 * 
 *   For instance:
 * 
 *           (map-object #(* 100 %) {:a 1 :b 2 :c 3}); => {:a 100 :b 200 :c 300})
 * 
 *   
 */
gadjett.collections.map_object = (function gadjett$collections$map_object(f,m){
return gadjett.collections.vec__GT_map.call(null,gadjett.collections.map_2d_vec.call(null,f,m));
});
gadjett.collections.map_object_with_key = (function gadjett$collections$map_object_with_key(f,m){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__19687){
var vec__19688 = p__19687;
var a = cljs.core.nth.call(null,vec__19688,(0),null);
var b = cljs.core.nth.call(null,vec__19688,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,f.call(null,a,b)], null);
}),m));
});
gadjett.collections.map_2d_vec_kv = (function gadjett$collections$map_2d_vec_kv(fk,fv,m){
return cljs.core.map.call(null,(function (p__19691){
var vec__19692 = p__19691;
var k = cljs.core.nth.call(null,vec__19692,(0),null);
var id = cljs.core.nth.call(null,vec__19692,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fk.call(null,k),fv.call(null,id)], null);
}),m);
});
gadjett.collections.map_object_kv = (function gadjett$collections$map_object_kv(fk,fv,m){
return gadjett.collections.vec__GT_map.call(null,gadjett.collections.map_2d_vec_kv.call(null,fk,fv,m));
});
/**
 * Turns a hash map inside out.
 *   See:  [here](http://stackoverflow.com/a/23653784/813665)
 */
gadjett.collections.map_reverse_hierarchy = (function gadjett$collections$map_reverse_hierarchy(m){
var or__18202__auto__ = cljs.core.apply.call(null,cljs.core.merge_with,cljs.core.conj,(function (){var iter__18974__auto__ = (function gadjett$collections$map_reverse_hierarchy_$_iter__19741(s__19742){
return (new cljs.core.LazySeq(null,(function (){
var s__19742__$1 = s__19742;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__19742__$1);
if(temp__4425__auto__){
var xs__4977__auto__ = temp__4425__auto__;
var vec__19752 = cljs.core.first.call(null,xs__4977__auto__);
var k1 = cljs.core.nth.call(null,vec__19752,(0),null);
var v1 = cljs.core.nth.call(null,vec__19752,(1),null);
var iterys__18970__auto__ = ((function (s__19742__$1,vec__19752,k1,v1,xs__4977__auto__,temp__4425__auto__){
return (function gadjett$collections$map_reverse_hierarchy_$_iter__19741_$_iter__19743(s__19744){
return (new cljs.core.LazySeq(null,((function (s__19742__$1,vec__19752,k1,v1,xs__4977__auto__,temp__4425__auto__){
return (function (){
var s__19744__$1 = s__19744;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__19744__$1);
if(temp__4425__auto____$1){
var s__19744__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19744__$2)){
var c__18972__auto__ = cljs.core.chunk_first.call(null,s__19744__$2);
var size__18973__auto__ = cljs.core.count.call(null,c__18972__auto__);
var b__19746 = cljs.core.chunk_buffer.call(null,size__18973__auto__);
if((function (){var i__19745 = (0);
while(true){
if((i__19745 < size__18973__auto__)){
var vec__19755 = cljs.core._nth.call(null,c__18972__auto__,i__19745);
var k2 = cljs.core.nth.call(null,vec__19755,(0),null);
var v2 = cljs.core.nth.call(null,vec__19755,(1),null);
cljs.core.chunk_append.call(null,b__19746,cljs.core.PersistentArrayMap.fromArray([k2,cljs.core.PersistentArrayMap.fromArray([k1,v2], true, false)], true, false));

var G__19757 = (i__19745 + (1));
i__19745 = G__19757;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19746),gadjett$collections$map_reverse_hierarchy_$_iter__19741_$_iter__19743.call(null,cljs.core.chunk_rest.call(null,s__19744__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19746),null);
}
} else {
var vec__19756 = cljs.core.first.call(null,s__19744__$2);
var k2 = cljs.core.nth.call(null,vec__19756,(0),null);
var v2 = cljs.core.nth.call(null,vec__19756,(1),null);
return cljs.core.cons.call(null,cljs.core.PersistentArrayMap.fromArray([k2,cljs.core.PersistentArrayMap.fromArray([k1,v2], true, false)], true, false),gadjett$collections$map_reverse_hierarchy_$_iter__19741_$_iter__19743.call(null,cljs.core.rest.call(null,s__19744__$2)));
}
} else {
return null;
}
break;
}
});})(s__19742__$1,vec__19752,k1,v1,xs__4977__auto__,temp__4425__auto__))
,null,null));
});})(s__19742__$1,vec__19752,k1,v1,xs__4977__auto__,temp__4425__auto__))
;
var fs__18971__auto__ = cljs.core.seq.call(null,iterys__18970__auto__.call(null,v1));
if(fs__18971__auto__){
return cljs.core.concat.call(null,fs__18971__auto__,gadjett$collections$map_reverse_hierarchy_$_iter__19741.call(null,cljs.core.rest.call(null,s__19742__$1)));
} else {
var G__19758 = cljs.core.rest.call(null,s__19742__$1);
s__19742__$1 = G__19758;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__18974__auto__.call(null,m);
})());
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
gadjett.collections.mean = (function gadjett$collections$mean(x){
if(cljs.core.empty_QMARK_.call(null,x)){
return (0);
} else {
return (cljs.core.apply.call(null,cljs.core._PLUS_,x) / cljs.core.count.call(null,x));
}
});
/**
 * 
 *   Usage:
 * 
 *   (sequence->map s)
 * 
 *   Converts a sequence into a map where the keys are the indexes of the elements in the sequence.
 * 
 *   For instance: 
 * 
 *   (sequence->map [10 20 30]) => {0 10 1 20 2 30}
 *   
 */
gadjett.collections.sequence__GT_map = (function gadjett$collections$sequence__GT_map(s){
return cljs.core.zipmap.call(null,cljs.core.range.call(null,cljs.core.count.call(null,s)),s);
});
gadjett.collections.range_with_end = (function gadjett$collections$range_with_end(var_args){
var args19759 = [];
var len__19260__auto___19762 = arguments.length;
var i__19261__auto___19763 = (0);
while(true){
if((i__19261__auto___19763 < len__19260__auto___19762)){
args19759.push((arguments[i__19261__auto___19763]));

var G__19764 = (i__19261__auto___19763 + (1));
i__19261__auto___19763 = G__19764;
continue;
} else {
}
break;
}

var G__19761 = args19759.length;
switch (G__19761) {
case 1:
return gadjett.collections.range_with_end.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return gadjett.collections.range_with_end.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return gadjett.collections.range_with_end.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19759.length)].join('')));

}
});

gadjett.collections.range_with_end.cljs$core$IFn$_invoke$arity$1 = (function (end){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [end,cljs.core.range.call(null,end)], null);
});

gadjett.collections.range_with_end.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [end,cljs.core.range.call(null,start,end)], null);
});

gadjett.collections.range_with_end.cljs$core$IFn$_invoke$arity$3 = (function (start,end,steps){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [end,cljs.core.range.call(null,start,end,steps)], null);
});

gadjett.collections.range_with_end.cljs$lang$maxFixedArity = 3;
gadjett.collections.range_till_end = (function gadjett$collections$range_till_end(var_args){
var args__19267__auto__ = [];
var len__19260__auto___19768 = arguments.length;
var i__19261__auto___19769 = (0);
while(true){
if((i__19261__auto___19769 < len__19260__auto___19768)){
args__19267__auto__.push((arguments[i__19261__auto___19769]));

var G__19770 = (i__19261__auto___19769 + (1));
i__19261__auto___19769 = G__19770;
continue;
} else {
}
break;
}

var argseq__19268__auto__ = ((((0) < args__19267__auto__.length))?(new cljs.core.IndexedSeq(args__19267__auto__.slice((0)),(0))):null);
return gadjett.collections.range_till_end.cljs$core$IFn$_invoke$arity$variadic(argseq__19268__auto__);
});

gadjett.collections.range_till_end.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var vec__19767 = cljs.core.apply.call(null,gadjett.collections.range_with_end,args);
var end = cljs.core.nth.call(null,vec__19767,(0),null);
var lis = cljs.core.nth.call(null,vec__19767,(1),null);
return cljs.core.concat.call(null,lis,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [end], null));
});

gadjett.collections.range_till_end.cljs$lang$maxFixedArity = (0);

gadjett.collections.range_till_end.cljs$lang$applyTo = (function (seq19766){
return gadjett.collections.range_till_end.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq19766));
});
gadjett.collections.append_cyclic = (function gadjett$collections$append_cyclic(lst,a){
if(cljs.core.seq.call(null,lst)){
return cljs.core.concat.call(null,cljs.core.rest.call(null,lst),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a], null));
} else {
return lst;
}
});
gadjett.collections.assoc_cyclic = (function gadjett$collections$assoc_cyclic(var_args){
var args19771 = [];
var len__19260__auto___19774 = arguments.length;
var i__19261__auto___19775 = (0);
while(true){
if((i__19261__auto___19775 < len__19260__auto___19774)){
args19771.push((arguments[i__19261__auto___19775]));

var G__19776 = (i__19261__auto___19775 + (1));
i__19261__auto___19775 = G__19776;
continue;
} else {
}
break;
}

var G__19773 = args19771.length;
switch (G__19773) {
case 3:
return gadjett.collections.assoc_cyclic.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return gadjett.collections.assoc_cyclic.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19771.length)].join('')));

}
});

gadjett.collections.assoc_cyclic.cljs$core$IFn$_invoke$arity$3 = (function (coll,k,v){
if(cljs.core.contains_QMARK_.call(null,coll,k)){
return cljs.core.assoc.call(null,coll,k,v);
} else {
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,gadjett.collections.append_cyclic.call(null,coll,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null)));
}
});

gadjett.collections.assoc_cyclic.cljs$core$IFn$_invoke$arity$4 = (function (coll,k,v,n){
if((cljs.core.count.call(null,coll) < n)){
return cljs.core.assoc.call(null,coll,k,v);
} else {
return gadjett.collections.assoc_cyclic.call(null,coll,k,v);
}
});

gadjett.collections.assoc_cyclic.cljs$lang$maxFixedArity = 4;
gadjett.collections.max_and_min = (function gadjett$collections$max_and_min(x){
if(cljs.core.empty_QMARK_.call(null,x)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
} else {
return cljs.core.juxt.call(null,(function (p1__19778_SHARP_){
return cljs.core.apply.call(null,cljs.core.max,p1__19778_SHARP_);
}),(function (p1__19779_SHARP_){
return cljs.core.apply.call(null,cljs.core.min,p1__19779_SHARP_);
})).call(null,x);
}
});
gadjett.collections.compactize_map = (function gadjett$collections$compactize_map(m){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.remove.call(null,cljs.core.comp.call(null,cljs.core.nil_QMARK_,cljs.core.second),m));
});
/**
 * Run a function on the elements of a map and keep only those elements for which
 *   the function returns true
 */
gadjett.collections.filter_map = (function gadjett$collections$filter_map(f,m){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,cljs.core.comp.call(null,f,cljs.core.val),m));
});
gadjett.collections.abs = (function gadjett$collections$abs(x){
var x__18533__auto__ = x;
var y__18534__auto__ = (- x);
return ((x__18533__auto__ > y__18534__auto__) ? x__18533__auto__ : y__18534__auto__);
});
gadjett.collections.nearest_of_ss = (function gadjett$collections$nearest_of_ss(ss,x){
var greater = cljs.core.first.call(null,cljs.core.subseq.call(null,ss,cljs.core._GT__EQ_,x));
var smaller = cljs.core.first.call(null,cljs.core.rsubseq.call(null,ss,cljs.core._LT__EQ_,x));
return cljs.core.apply.call(null,cljs.core.min_key,((function (greater,smaller){
return (function (p1__19780_SHARP_){
return gadjett.collections.abs.call(null,(p1__19780_SHARP_ - x));
});})(greater,smaller))
,cljs.core.remove.call(null,cljs.core.nil_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [greater,smaller], null)));
});
gadjett.collections.nearest_of_seq = (function gadjett$collections$nearest_of_seq(a,b){
if(cljs.core.empty_QMARK_.call(null,a)){
return b;
} else {
return cljs.core.map.call(null,cljs.core.partial.call(null,gadjett.collections.nearest_of_ss,cljs.core.apply.call(null,cljs.core.sorted_set,a)),b);
}
});
gadjett.collections.map_to_object = (function gadjett$collections$map_to_object(f,lst){
return cljs.core.zipmap.call(null,lst,cljs.core.map.call(null,f,lst));
});
/**
 * 
 *   Usage:
 * 
 *    (map-with-index coll idx-key val-key)
 * 
 * 
 *   Maps a sequence to a sequence of maps with index and value
 *   For instance:
 *   
 *    (map-with-index [10 20 30] :idx :val) =>  '({:idx 0, :val 10} {:idx 1, :val 20} {:idx 2, :val 30}))
 *   
 */
gadjett.collections.map_with_index = (function gadjett$collections$map_with_index(s,idx_key,val_key){
return cljs.core.map_indexed.call(null,(function (i,v){
return cljs.core.PersistentArrayMap.fromArray([idx_key,i,val_key,v], true, false);
}),s);
});
/**
 * 
 *   Takes a seq, and returns a map where the keys are the result of applying f to the elements in the seq.
 *   The result of f should be unique for each element in the seq, otherwise you will loose some data.
 *   If it is not unique, consider using [group-by](https://clojuredocs.org/clojure.core/group-by)
 *   
 */
gadjett.collections.mapify = (function gadjett$collections$mapify(s,f){
return cljs.core.zipmap.call(null,cljs.core.map.call(null,f,s),s);
});
gadjett.collections.map_to_object_with_index = (function gadjett$collections$map_to_object_with_index(f,s){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.call(null,(function (p1__19781_SHARP_,p2__19782_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__19781_SHARP_,f.call(null,p2__19782_SHARP_)],null));
}),s));
});
/**
 * Dissociates an entry from a nested associative structure returning a new
 *   nested structure. keys is a sequence of keys. Any empty maps that result
 *   will not be present in the new structure.
 */
gadjett.collections.dissoc_in = (function gadjett$collections$dissoc_in(m,p__19783){
var vec__19785 = p__19783;
var k = cljs.core.nth.call(null,vec__19785,(0),null);
var ks = cljs.core.nthnext.call(null,vec__19785,(1));
var keys = vec__19785;
if(cljs.core.truth_(ks)){
var temp__4423__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(temp__4423__auto__)){
var nextmap = temp__4423__auto__;
var newmap = gadjett$collections$dissoc_in.call(null,nextmap,ks);
if(cljs.core.seq.call(null,newmap)){
return cljs.core.assoc.call(null,m,k,newmap);
} else {
return cljs.core.dissoc.call(null,m,k);
}
} else {
return m;
}
} else {
return cljs.core.dissoc.call(null,m,k);
}
});
/**
 * Splits a collection to items where the separator is a repetition of at least n elements that satisfy pred
 *   inspired by: [this question](http://stackoverflow.com/a/23555616/813665)
 */
gadjett.collections.split_by_predicate = (function gadjett$collections$split_by_predicate(coll,pred,n){
var part = cljs.core.partition_by.call(null,pred,coll);
var ppart = cljs.core.partition_by.call(null,((function (part){
return (function (x){
return ((cljs.core.count.call(null,x) >= n)) && (cljs.core.every_QMARK_.call(null,pred,x));
});})(part))
,part);
return cljs.core.map.call(null,((function (part,ppart){
return (function (p1__19786_SHARP_){
return cljs.core.apply.call(null,cljs.core.concat,p1__19786_SHARP_);
});})(part,ppart))
,ppart);
});
/**
 * Receives a collection of lengths and returns a list of start and end positions
 */
gadjett.collections.positions = (function gadjett$collections$positions(coll_of_lengths,maximal_value){
var end_pos = cljs.core.reductions.call(null,cljs.core._PLUS_,coll_of_lengths);
var start_pos = cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),end_pos);
return cljs.core.map.call(null,((function (end_pos,start_pos){
return (function (p1__19787_SHARP_,p2__19788_SHARP_){
return cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,(function (){var x__18540__auto__ = maximal_value;
var y__18541__auto__ = p2__19788_SHARP_;
return ((x__18540__auto__ < y__18541__auto__) ? x__18540__auto__ : y__18541__auto__);
})()),(function (){var x__18540__auto__ = maximal_value;
var y__18541__auto__ = p1__19787_SHARP_;
return ((x__18540__auto__ < y__18541__auto__) ? x__18540__auto__ : y__18541__auto__);
})());
});})(end_pos,start_pos))
,start_pos,end_pos);
});
/**
 * Checks if m1 is a submap of m2.
 *   Map m1 is a submap of m2 if all key/value pairs in m1 exist in m2
 */
gadjett.collections.submap_QMARK_ = (function gadjett$collections$submap_QMARK_(m1,m2){
return cljs.core._EQ_.call(null,m1,cljs.core.select_keys.call(null,m2,cljs.core.keys.call(null,m1)));
});
gadjett.collections.subsequence = (function gadjett$collections$subsequence(coll,start,end){
return cljs.core.take.call(null,(end - start),cljs.core.drop.call(null,start,coll));
});
gadjett.collections.split_by_predicate_opt = (function gadjett$collections$split_by_predicate_opt(coll,pred,n,d){
var lengths = cljs.core.map.call(null,(function (p1__19789_SHARP_){
return (d * p1__19789_SHARP_);
}),cljs.core.map.call(null,cljs.core.count,gadjett.collections.split_by_predicate.call(null,cljs.core.take_nth.call(null,d,coll),pred,(n / d))));
var pos = gadjett.collections.positions.call(null,lengths,cljs.core.count.call(null,coll));
return pos;
});
gadjett.collections.index_of = (function gadjett$collections$index_of(s,element){
var or__18202__auto__ = cljs.core.ffirst.call(null,cljs.core.filter.call(null,(function (p1__19790_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.second.call(null,p1__19790_SHARP_),element);
}),cljs.core.map_indexed.call(null,(function (p1__19791_SHARP_,p2__19792_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__19791_SHARP_,p2__19792_SHARP_],null));
}),s)));
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
return (-1);
}
});
gadjett.collections.display_sequence = (function gadjett$collections$display_sequence(long_seq,short_seq,value,abs_step){
var old_step = (cljs.core.second.call(null,short_seq) - cljs.core.first.call(null,short_seq));
var step = ((cljs.core.second.call(null,long_seq) - cljs.core.first.call(null,long_seq)) * abs_step);
var position_in_old_sequence = ((value - cljs.core.first.call(null,short_seq)) / old_step);
if((((0) <= position_in_old_sequence)) && ((position_in_old_sequence <= (4)))){
return cljs.core.range.call(null,(value - (step * position_in_old_sequence)),(value + (step * ((5) - position_in_old_sequence))),step);
} else {
if(cljs.core._EQ_.call(null,position_in_old_sequence,(5))){
return cljs.core.range.call(null,(value - (step * (position_in_old_sequence - (1)))),(value + step),step);
} else {
if(cljs.core.empty_QMARK_.call(null,short_seq)){
return cljs.core.range.call(null,(value - step),(value + ((4) * step)),step);
} else {
return cljs.core.range.call(null,value,(value + ((5) * step)),step);

}
}
}
});
gadjett.collections.highest_below_y = (function gadjett$collections$highest_below_y(m,v){
return cljs.core.second.call(null,cljs.core.last.call(null,cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,cljs.core.second,cljs.core.filter.call(null,(function (p__19795){
var vec__19796 = p__19795;
var x = cljs.core.nth.call(null,vec__19796,(0),null);
var y = cljs.core.nth.call(null,vec__19796,(1),null);
return (y <= v);
}),m)))));
});
gadjett.collections.lowest_above_y = (function gadjett$collections$lowest_above_y(m,v){
return cljs.core.second.call(null,cljs.core.first.call(null,cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,cljs.core.second,cljs.core.filter.call(null,(function (p__19799){
var vec__19800 = p__19799;
var x = cljs.core.nth.call(null,vec__19800,(0),null);
var y = cljs.core.nth.call(null,vec__19800,(1),null);
return (y >= v);
}),m)))));
});
gadjett.collections.highest_below_x = (function gadjett$collections$highest_below_x(m,v){
return cljs.core.second.call(null,cljs.core.last.call(null,cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__19803){
var vec__19804 = p__19803;
var x = cljs.core.nth.call(null,vec__19804,(0),null);
var y = cljs.core.nth.call(null,vec__19804,(1),null);
return (x <= v);
}),m)))));
});
gadjett.collections.lowest_above_x = (function gadjett$collections$lowest_above_x(m,v){
return cljs.core.second.call(null,cljs.core.first.call(null,cljs.core.sort_by.call(null,cljs.core.first,cljs.core.group_by.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__19807){
var vec__19808 = p__19807;
var x = cljs.core.nth.call(null,vec__19808,(0),null);
var y = cljs.core.nth.call(null,vec__19808,(1),null);
return (x >= v);
}),m)))));
});
gadjett.collections.find_keys_with_values_in = (function gadjett$collections$find_keys_with_values_in(m,s){
return cljs.core.filter.call(null,cljs.core.comp.call(null,s,m),cljs.core.keys.call(null,m));
});
gadjett.collections.replace_keys = (function gadjett$collections$replace_keys(coll,key_map){
return cljs.core.zipmap.call(null,cljs.core.map.call(null,(function (p1__19809_SHARP_){
return cljs.core.get.call(null,key_map,p1__19809_SHARP_,p1__19809_SHARP_);
}),cljs.core.keys.call(null,coll)),cljs.core.vals.call(null,coll));
});
gadjett.collections.find_keys_with_value = (function gadjett$collections$find_keys_with_value(m,v){
return gadjett.collections.find_keys_with_values_in.call(null,m,cljs.core.PersistentHashSet.fromArray([v], true));
});
gadjett.collections.linear_y = (function gadjett$collections$linear_y(x,x1,y1,x2,y2){
return (y1 + (((y2 - y1) * (x - x1)) / (x2 - x1)));
});
gadjett.collections.log_x_linear_y = (function gadjett$collections$log_x_linear_y(x,x1,y1,x2,y2){
return (y1 + (((y2 - y1) * (Math.log(x) - Math.log(x1))) / (Math.log(x2) - Math.log(x1))));
});
gadjett.collections.linear_y_func = (function gadjett$collections$linear_y_func(p__19810){
var map__19814 = p__19810;
var map__19814__$1 = ((((!((map__19814 == null)))?((((map__19814.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19814.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19814):map__19814);
var axes = map__19814__$1;
var x = cljs.core.get.call(null,map__19814__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.call(null,map__19814__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var G__19816 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__19816)){
return gadjett.collections.linear_y;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__19816)){
return gadjett.collections.log_x_linear_y;
} else {
return gadjett.collections.linear_y;

}
}
});
gadjett.collections.interpolate_linear_y = (function gadjett$collections$interpolate_linear_y(var_args){
var args__19267__auto__ = [];
var len__19260__auto___19825 = arguments.length;
var i__19261__auto___19826 = (0);
while(true){
if((i__19261__auto___19826 < len__19260__auto___19825)){
args__19267__auto__.push((arguments[i__19261__auto___19826]));

var G__19827 = (i__19261__auto___19826 + (1));
i__19261__auto___19826 = G__19827;
continue;
} else {
}
break;
}

var argseq__19268__auto__ = ((((2) < args__19267__auto__.length))?(new cljs.core.IndexedSeq(args__19267__auto__.slice((2)),(0))):null);
return gadjett.collections.interpolate_linear_y.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19268__auto__);
});

gadjett.collections.interpolate_linear_y.cljs$core$IFn$_invoke$arity$variadic = (function (m,x,p__19820){
var map__19821 = p__19820;
var map__19821__$1 = ((((!((map__19821 == null)))?((((map__19821.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19821.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19821):map__19821);
var interpolate_QMARK_ = cljs.core.get.call(null,map__19821__$1,new cljs.core.Keyword(null,"interpolate?","interpolate?",-423156286),cljs.core.constantly.call(null,true));
var axes = cljs.core.get.call(null,map__19821__$1,new cljs.core.Keyword(null,"axes","axes",1970866440),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"linear","linear",872268697)], null));
var or__18202__auto__ = cljs.core.get.call(null,m,x);
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
var vec__19823 = cljs.core.last.call(null,cljs.core.sort.call(null,gadjett.collections.highest_below_x.call(null,m,x)));
var x_below = cljs.core.nth.call(null,vec__19823,(0),null);
var y_below = cljs.core.nth.call(null,vec__19823,(1),null);
var vec__19824 = cljs.core.first.call(null,cljs.core.sort.call(null,gadjett.collections.lowest_above_x.call(null,m,x)));
var x_above = cljs.core.nth.call(null,vec__19824,(0),null);
var y_above = cljs.core.nth.call(null,vec__19824,(1),null);
if(cljs.core.truth_((function (){var and__18190__auto__ = x_below;
if(cljs.core.truth_(and__18190__auto__)){
var and__18190__auto____$1 = x_above;
if(cljs.core.truth_(and__18190__auto____$1)){
return interpolate_QMARK_.call(null,x_below,x_above);
} else {
return and__18190__auto____$1;
}
} else {
return and__18190__auto__;
}
})())){
return gadjett.collections.linear_y_func.call(null,axes).call(null,x,x_below,y_below,x_above,y_above);
} else {
return null;
}
}
});

gadjett.collections.interpolate_linear_y.cljs$lang$maxFixedArity = (2);

gadjett.collections.interpolate_linear_y.cljs$lang$applyTo = (function (seq19817){
var G__19818 = cljs.core.first.call(null,seq19817);
var seq19817__$1 = cljs.core.next.call(null,seq19817);
var G__19819 = cljs.core.first.call(null,seq19817__$1);
var seq19817__$2 = cljs.core.next.call(null,seq19817__$1);
return gadjett.collections.interpolate_linear_y.cljs$core$IFn$_invoke$arity$variadic(G__19818,G__19819,seq19817__$2);
});
gadjett.collections.linear_x = (function gadjett$collections$linear_x(y,x1,y1,x2,y2){
return (x1 + (((x2 - x1) * (y - y1)) / (y2 - y1)));
});
gadjett.collections.linear_x_func = (function gadjett$collections$linear_x_func(p__19828){
var map__19832 = p__19828;
var map__19832__$1 = ((((!((map__19832 == null)))?((((map__19832.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19832.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19832):map__19832);
var axes = map__19832__$1;
var x = cljs.core.get.call(null,map__19832__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.call(null,map__19832__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var G__19834 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__19834)){
return gadjett.collections.linear_x;
} else {
return gadjett.collections.linear_x;

}
});
gadjett.collections.below_and_above_y = (function gadjett$collections$below_and_above_y(y,p__19835,p__19836){
var vec__19839 = p__19835;
var x1 = cljs.core.nth.call(null,vec__19839,(0),null);
var y1 = cljs.core.nth.call(null,vec__19839,(1),null);
var vec__19840 = p__19836;
var x2 = cljs.core.nth.call(null,vec__19840,(0),null);
var y2 = cljs.core.nth.call(null,vec__19840,(1),null);
if((((y1 < y)) && ((y < y2))) || (((y1 > y)) && ((y > y2)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x1,y1], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x2,y2], null)], null);
} else {
return null;
}
});
gadjett.collections.find_below_and_above_y = (function gadjett$collections$find_below_and_above_y(m,y){
var $ = cljs.core.map.call(null,cljs.core.vec,m);
var $__$1 = cljs.core.sort_by.call(null,cljs.core.first,$);
var $__$2 = cljs.core.map.call(null,cljs.core.partial.call(null,gadjett.collections.below_and_above_y,y),$__$1,cljs.core.rest.call(null,$__$1));
var $__$3 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,$__$2);
return $__$3;
});
gadjett.collections.calc_interpolated_values = (function gadjett$collections$calc_interpolated_values(m,y,interpolate_QMARK_,axes){
var $ = (function (p__19845){
var vec__19846 = p__19845;
var vec__19847 = cljs.core.nth.call(null,vec__19846,(0),null);
var x_below = cljs.core.nth.call(null,vec__19847,(0),null);
var y_below = cljs.core.nth.call(null,vec__19847,(1),null);
var vec__19848 = cljs.core.nth.call(null,vec__19846,(1),null);
var x_above = cljs.core.nth.call(null,vec__19848,(0),null);
var y_above = cljs.core.nth.call(null,vec__19848,(1),null);
if(cljs.core.truth_((function (){var and__18190__auto__ = y_below;
if(cljs.core.truth_(and__18190__auto__)){
var and__18190__auto____$1 = y_above;
if(cljs.core.truth_(and__18190__auto____$1)){
return interpolate_QMARK_.call(null,y_below,y_above);
} else {
return and__18190__auto____$1;
}
} else {
return and__18190__auto__;
}
})())){
return gadjett.collections.linear_x_func.call(null,axes).call(null,y,x_below,y_below,x_above,y_above);
} else {
return null;
}
});
var $__$1 = cljs.core.keep.call(null,$,gadjett.collections.find_below_and_above_y.call(null,m,y));
return $__$1;
});
gadjett.collections.min_coll = (function gadjett$collections$min_coll(coll){
if(cljs.core.empty_QMARK_.call(null,coll)){
return null;
} else {
return cljs.core.apply.call(null,cljs.core.min,coll);
}
});
/**
 * Usage:
 * 
 *   (interpolate-linear-x m y :interpolate? interpolate? :axes axes :select-func select-func)
 * 
 *   returnes the interpolated x for a given y acording to the select-func thats passed
 * 
 *   :interpolate? a predicate for deciding eather to calc th interpolation or not.
 *   :axes a map that defines what are the axes scales
 *   :select-func what functionality to use if there are multiple interpolated values
 * 
 *   for instance:
 * 
 *   (interpolate-linear-x {10 30 20 50 70 60}}) => 20
 */
gadjett.collections.interpolate_linear_x = (function gadjett$collections$interpolate_linear_x(var_args){
var args__19267__auto__ = [];
var len__19260__auto___19855 = arguments.length;
var i__19261__auto___19856 = (0);
while(true){
if((i__19261__auto___19856 < len__19260__auto___19855)){
args__19267__auto__.push((arguments[i__19261__auto___19856]));

var G__19857 = (i__19261__auto___19856 + (1));
i__19261__auto___19856 = G__19857;
continue;
} else {
}
break;
}

var argseq__19268__auto__ = ((((2) < args__19267__auto__.length))?(new cljs.core.IndexedSeq(args__19267__auto__.slice((2)),(0))):null);
return gadjett.collections.interpolate_linear_x.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19268__auto__);
});

gadjett.collections.interpolate_linear_x.cljs$core$IFn$_invoke$arity$variadic = (function (m,y,p__19852){
var map__19853 = p__19852;
var map__19853__$1 = ((((!((map__19853 == null)))?((((map__19853.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19853.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19853):map__19853);
var interpolate_QMARK_ = cljs.core.get.call(null,map__19853__$1,new cljs.core.Keyword(null,"interpolate?","interpolate?",-423156286),cljs.core.constantly.call(null,true));
var axes = cljs.core.get.call(null,map__19853__$1,new cljs.core.Keyword(null,"axes","axes",1970866440),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"linear","linear",872268697)], null));
var select_func = cljs.core.get.call(null,map__19853__$1,new cljs.core.Keyword(null,"select-func","select-func",-1706031810),gadjett.collections.min_coll);
var values = gadjett.collections.find_keys_with_value.call(null,m,y);
var interpolated_values = gadjett.collections.calc_interpolated_values.call(null,m,y,interpolate_QMARK_,axes);
return select_func.call(null,cljs.core.concat.call(null,values,interpolated_values));
});

gadjett.collections.interpolate_linear_x.cljs$lang$maxFixedArity = (2);

gadjett.collections.interpolate_linear_x.cljs$lang$applyTo = (function (seq19849){
var G__19850 = cljs.core.first.call(null,seq19849);
var seq19849__$1 = cljs.core.next.call(null,seq19849);
var G__19851 = cljs.core.first.call(null,seq19849__$1);
var seq19849__$2 = cljs.core.next.call(null,seq19849__$1);
return gadjett.collections.interpolate_linear_x.cljs$core$IFn$_invoke$arity$variadic(G__19850,G__19851,seq19849__$2);
});
gadjett.collections.linear_equation = (function gadjett$collections$linear_equation(x1,y1,x2,y2){
var a = ((y1 - y2) / (x1 - x2));
var b = (y1 - (a * x1));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
});
gadjett.collections.log_x_linear_equation = (function gadjett$collections$log_x_linear_equation(x1,y1,x2,y2){
var a = ((y1 - y2) / (Math.log(x1) - Math.log(x2)));
var b = (y1 - (a * Math.log(x1)));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
});
gadjett.collections.linear_equation_func = (function gadjett$collections$linear_equation_func(p__19858){
var map__19862 = p__19858;
var map__19862__$1 = ((((!((map__19862 == null)))?((((map__19862.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19862.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19862):map__19862);
var axes = map__19862__$1;
var x = cljs.core.get.call(null,map__19862__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.call(null,map__19862__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var G__19864 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__19864)){
return gadjett.collections.linear_equation;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__19864)){
return gadjett.collections.log_x_linear_equation;
} else {
return gadjett.collections.linear_equation;

}
}
});
gadjett.collections.intersection_point = (function gadjett$collections$intersection_point(a1,b1,a2,b2){
var x = ((b2 - b1) / (a1 - a2));
var y = ((a1 * x) + b1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
});
gadjett.collections.log_x_intersection_point = (function gadjett$collections$log_x_intersection_point(a1,b1,a2,b2){
var x = ((b2 - b1) / (a1 - a2));
var y = ((a1 * x) + b1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [Math.exp(x),y], null);
});
gadjett.collections.intersection_point_func = (function gadjett$collections$intersection_point_func(p__19865){
var map__19869 = p__19865;
var map__19869__$1 = ((((!((map__19869 == null)))?((((map__19869.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19869.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19869):map__19869);
var axes = map__19869__$1;
var x = cljs.core.get.call(null,map__19869__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.call(null,map__19869__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var G__19871 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__19871)){
return gadjett.collections.intersection_point;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"linear","linear",872268697)], null),G__19871)){
return gadjett.collections.log_x_intersection_point;
} else {
return gadjett.collections.intersection_point;

}
}
});
gadjett.collections.intersection_point_from_2_lines_points = (function gadjett$collections$intersection_point_from_2_lines_points(var_args){
var args__19267__auto__ = [];
var len__19260__auto___19885 = arguments.length;
var i__19261__auto___19886 = (0);
while(true){
if((i__19261__auto___19886 < len__19260__auto___19885)){
args__19267__auto__.push((arguments[i__19261__auto___19886]));

var G__19887 = (i__19261__auto___19886 + (1));
i__19261__auto___19886 = G__19887;
continue;
} else {
}
break;
}

var argseq__19268__auto__ = ((((2) < args__19267__auto__.length))?(new cljs.core.IndexedSeq(args__19267__auto__.slice((2)),(0))):null);
return gadjett.collections.intersection_point_from_2_lines_points.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__19268__auto__);
});

gadjett.collections.intersection_point_from_2_lines_points.cljs$core$IFn$_invoke$arity$variadic = (function (p__19875,p__19876,p__19877){
var vec__19878 = p__19875;
var ax1 = cljs.core.nth.call(null,vec__19878,(0),null);
var ay1 = cljs.core.nth.call(null,vec__19878,(1),null);
var ax2 = cljs.core.nth.call(null,vec__19878,(2),null);
var ay2 = cljs.core.nth.call(null,vec__19878,(3),null);
var vec__19879 = p__19876;
var bx1 = cljs.core.nth.call(null,vec__19879,(0),null);
var by1 = cljs.core.nth.call(null,vec__19879,(1),null);
var bx2 = cljs.core.nth.call(null,vec__19879,(2),null);
var by2 = cljs.core.nth.call(null,vec__19879,(3),null);
var map__19880 = p__19877;
var map__19880__$1 = ((((!((map__19880 == null)))?((((map__19880.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19880.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19880):map__19880);
var axes = cljs.core.get.call(null,map__19880__$1,new cljs.core.Keyword(null,"axes","axes",1970866440),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"linear","linear",872268697),new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"linear","linear",872268697)], null));
var vec__19882 = gadjett.collections.linear_equation_func.call(null,axes).call(null,ax1,ay1,ax2,ay2);
var a1 = cljs.core.nth.call(null,vec__19882,(0),null);
var b1 = cljs.core.nth.call(null,vec__19882,(1),null);
var vec__19883 = gadjett.collections.linear_equation_func.call(null,axes).call(null,bx1,by1,bx2,by2);
var a2 = cljs.core.nth.call(null,vec__19883,(0),null);
var b2 = cljs.core.nth.call(null,vec__19883,(1),null);
var vec__19884 = gadjett.collections.intersection_point_func.call(null,axes).call(null,a1,b1,a2,b2);
var x = cljs.core.nth.call(null,vec__19884,(0),null);
var y = cljs.core.nth.call(null,vec__19884,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null);
});

gadjett.collections.intersection_point_from_2_lines_points.cljs$lang$maxFixedArity = (2);

gadjett.collections.intersection_point_from_2_lines_points.cljs$lang$applyTo = (function (seq19872){
var G__19873 = cljs.core.first.call(null,seq19872);
var seq19872__$1 = cljs.core.next.call(null,seq19872);
var G__19874 = cljs.core.first.call(null,seq19872__$1);
var seq19872__$2 = cljs.core.next.call(null,seq19872__$1);
return gadjett.collections.intersection_point_from_2_lines_points.cljs$core$IFn$_invoke$arity$variadic(G__19873,G__19874,seq19872__$2);
});
gadjett.collections.strings_to_keywords = (function gadjett$collections$strings_to_keywords(strings){
return cljs.core.map.call(null,cljs.core.keyword,clojure.string.split.call(null,strings,/\s+/));
});
/**
 * Thanks [Jay Fields](http://blog.jayfields.com/2011/01/clojure-select-keys-select-values-and.html)
 */
gadjett.collections.select_keys_in_order = (function gadjett$collections$select_keys_in_order(m,keyseq){
return cljs.core.map.call(null,m,keyseq);
});
gadjett.collections.select_vals = (function gadjett$collections$select_vals(map,keyseq){
return cljs.core.vals.call(null,cljs.core.select_keys.call(null,map,keyseq));
});
/**
 * Thanks [Jay Fields](http://blog.jayfields.com/2011/01/clojure-select-keys-select-values-and.html)
 */
gadjett.collections.select_vals_in_order = (function gadjett$collections$select_vals_in_order(map,ks){
return cljs.core.reduce.call(null,(function (p1__19888_SHARP_,p2__19889_SHARP_){
return cljs.core.conj.call(null,p1__19888_SHARP_,map.call(null,p2__19889_SHARP_));
}),cljs.core.PersistentVector.EMPTY,ks);
});
gadjett.collections.flatten_keys_STAR_ = (function gadjett$collections$flatten_keys_STAR_(a,ks,m){
if(cljs.core.map_QMARK_.call(null,m)){
if(cljs.core.seq.call(null,m)){
return cljs.core.reduce.call(null,cljs.core.into,cljs.core.map.call(null,(function (p__19892){
var vec__19893 = p__19892;
var k = cljs.core.nth.call(null,vec__19893,(0),null);
var v = cljs.core.nth.call(null,vec__19893,(1),null);
return gadjett$collections$flatten_keys_STAR_.call(null,a,cljs.core.conj.call(null,ks,k),v);
}),cljs.core.seq.call(null,m)));
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
} else {
return cljs.core.assoc.call(null,a,ks,m);
}
});
/**
 * Thanks to [Jay Fields](http://blog.jayfields.com/2010/09/clojure-flatten-keys.html)
 */
gadjett.collections.flatten_keys = (function gadjett$collections$flatten_keys(m){
return gadjett.collections.flatten_keys_STAR_.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentVector.EMPTY,m);
});
gadjett.collections.unflatten_keys = (function gadjett$collections$unflatten_keys(m){
return cljs.core.reduce_kv.call(null,(function (a,b,c){
return cljs.core.assoc_in.call(null,a,b,c);
}),cljs.core.PersistentArrayMap.EMPTY,m);
});
/**
 * Creates a map with n leaves which are nested values of m.
 * 
 *    (= n (count (flatten-keys (take-from-map n m)))))))
 */
gadjett.collections.take_from_map = (function gadjett$collections$take_from_map(n,m){
return gadjett.collections.unflatten_keys.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.take.call(null,n,gadjett.collections.flatten_keys.call(null,m))));
});
gadjett.collections.recursive_vals = (function gadjett$collections$recursive_vals(m){
if(cljs.core.truth_(m)){
return cljs.core.vals.call(null,gadjett.collections.flatten_keys.call(null,m));
} else {
return null;
}
});
gadjett.collections.sort_keys_by = (function gadjett$collections$sort_keys_by(a_func,a_map){
return cljs.core.map.call(null,cljs.core.first,cljs.core.sort_by.call(null,a_func,a_map));
});
gadjett.collections.deep_merge_STAR_ = (function gadjett$collections$deep_merge_STAR_(var_args){
var args__19267__auto__ = [];
var len__19260__auto___19895 = arguments.length;
var i__19261__auto___19896 = (0);
while(true){
if((i__19261__auto___19896 < len__19260__auto___19895)){
args__19267__auto__.push((arguments[i__19261__auto___19896]));

var G__19897 = (i__19261__auto___19896 + (1));
i__19261__auto___19896 = G__19897;
continue;
} else {
}
break;
}

var argseq__19268__auto__ = ((((0) < args__19267__auto__.length))?(new cljs.core.IndexedSeq(args__19267__auto__.slice((0)),(0))):null);
return gadjett.collections.deep_merge_STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__19268__auto__);
});

gadjett.collections.deep_merge_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
var f = (function (old,new$){
if((cljs.core.map_QMARK_.call(null,old)) && (cljs.core.map_QMARK_.call(null,new$))){
return cljs.core.merge_with.call(null,gadjett.collections.deep_merge_STAR_,old,new$);
} else {
return new$;
}
});
if(cljs.core.every_QMARK_.call(null,cljs.core.map_QMARK_,maps)){
return cljs.core.apply.call(null,cljs.core.merge_with,f,maps);
} else {
return cljs.core.last.call(null,maps);
}
});

gadjett.collections.deep_merge_STAR_.cljs$lang$maxFixedArity = (0);

gadjett.collections.deep_merge_STAR_.cljs$lang$applyTo = (function (seq19894){
return gadjett.collections.deep_merge_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq19894));
});
gadjett.collections.deep_merge = (function gadjett$collections$deep_merge(var_args){
var args__19267__auto__ = [];
var len__19260__auto___19899 = arguments.length;
var i__19261__auto___19900 = (0);
while(true){
if((i__19261__auto___19900 < len__19260__auto___19899)){
args__19267__auto__.push((arguments[i__19261__auto___19900]));

var G__19901 = (i__19261__auto___19900 + (1));
i__19261__auto___19900 = G__19901;
continue;
} else {
}
break;
}

var argseq__19268__auto__ = ((((0) < args__19267__auto__.length))?(new cljs.core.IndexedSeq(args__19267__auto__.slice((0)),(0))):null);
return gadjett.collections.deep_merge.cljs$core$IFn$_invoke$arity$variadic(argseq__19268__auto__);
});

gadjett.collections.deep_merge.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
var maps__$1 = cljs.core.filter.call(null,cljs.core.identity,maps);
if(cljs.core.every_QMARK_.call(null,cljs.core.map_QMARK_,maps__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"every?","every?",2083724064,null),new cljs.core.Symbol(null,"map?","map?",-1780568534,null),new cljs.core.Symbol(null,"maps","maps",-71029607,null))))].join('')));
}

return cljs.core.apply.call(null,cljs.core.merge_with,gadjett.collections.deep_merge_STAR_,maps__$1);
});

gadjett.collections.deep_merge.cljs$lang$maxFixedArity = (0);

gadjett.collections.deep_merge.cljs$lang$applyTo = (function (seq19898){
return gadjett.collections.deep_merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq19898));
});
gadjett.collections.branches_and_leaves = (function gadjett$collections$branches_and_leaves(m){

var $ = cljs.core.tree_seq.call(null,cljs.core.coll_QMARK_,(function (p1__19902_SHARP_){
if(cljs.core.map_QMARK_.call(null,p1__19902_SHARP_)){
return cljs.core.vals.call(null,p1__19902_SHARP_);
} else {
return p1__19902_SHARP_;
}
}),m);
var $__$1 = cljs.core.group_by.call(null,cljs.core.coll_QMARK_,$);
var $__$2 = cljs.core.assoc.call(null,$__$1,true,(function (){var or__18202__auto__ = cljs.core.get.call(null,$__$1,true);
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})());
var $__$3 = cljs.core.assoc.call(null,$__$2,false,(function (){var or__18202__auto__ = cljs.core.get.call(null,$__$2,false);
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})());
var $__$4 = clojure.set.rename_keys.call(null,$__$3,new cljs.core.PersistentArrayMap(null, 2, [true,new cljs.core.Keyword(null,"branches","branches",-1240337268),false,new cljs.core.Keyword(null,"leaves","leaves",-2143630574)], null));
return $__$4;
});
gadjett.collections.filter_branches = (function gadjett$collections$filter_branches(m,p){

return cljs.core.filter.call(null,p,new cljs.core.Keyword(null,"branches","branches",-1240337268).cljs$core$IFn$_invoke$arity$1(gadjett.collections.branches_and_leaves.call(null,m)));
});
/**
 * check if index `idx` is in range of vector `v`. More efficiant than ```(get v idx)```
 */
gadjett.collections.out_of_bound_QMARK_ = (function gadjett$collections$out_of_bound_QMARK_(v,idx){
return ((cljs.core.count.call(null,v) <= idx)) || (((0) > idx));
});
/**
 * Usage: 
 * 
 *  (partition-between pred coll)
 * 
 *  splits a collection between two items according to the pred.
 *  which means split the sequence on breaking point.
 * 
 *   See: [here](http://stackoverflow.com/questions/23207490/partition-a-seq-by-a-windowing-predicate-in-clojure)
 * 
 *   For instance:
 *  split when ascending serie breaks.
 * 
 *  (partition-between (fn [a b] (> a b)) [1 2 4 9 4 6 8 2]) => [[1 2 4 9] [4 6 8] [2]]
 */
gadjett.collections.partition_between = (function gadjett$collections$partition_between(pred_QMARK_,coll){
var switch$ = cljs.core.reductions.call(null,cljs.core.not_EQ_,true,cljs.core.map.call(null,pred_QMARK_,coll,cljs.core.rest.call(null,coll)));
return cljs.core.map.call(null,cljs.core.partial.call(null,cljs.core.map,cljs.core.first),cljs.core.partition_by.call(null,cljs.core.second,cljs.core.map.call(null,cljs.core.list,coll,switch$)));
});
gadjett.collections.interpolate_linear = gadjett.collections.interpolate_linear_x;
gadjett.collections.linear = gadjett.collections.linear_x;
gadjett.collections.highest_below = gadjett.collections.highest_below_y;
gadjett.collections.lowest_above = gadjett.collections.lowest_above_y;

//# sourceMappingURL=collections.js.map