// Compiled by ClojureScript 1.7.228 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
goog.require('cljs.repl');
goog.require('figwheel.client.heads_up');
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),args], null));

return args;
});
figwheel.client.autoload_QMARK_ = (cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?(function (){
var pred__24805 = cljs.core._EQ_;
var expr__24806 = (function (){var or__18202__auto__ = localStorage.getItem("figwheel_autoload");
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
return "true";
}
})();
if(cljs.core.truth_(pred__24805.call(null,"true",expr__24806))){
return true;
} else {
if(cljs.core.truth_(pred__24805.call(null,"false",expr__24806))){
return false;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__24806)].join('')));
}
}
}):(function (){
return true;
}));
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
localStorage.setItem("figwheel_autoload",cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));

return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Figwheel autoloading "),cljs.core.str((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));
} else {
return null;
}
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
figwheel.client.console_print = (function figwheel$client$console_print(args){
console.log.apply(console,cljs.core.into_array.call(null,args));

return args;
});
figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

return cljs.core._STAR_print_fn_STAR_ = (function() { 
var G__24808__delegate = function (args){
return figwheel.client.figwheel_repl_print.call(null,figwheel.client.console_print.call(null,args));
};
var G__24808 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__24809__i = 0, G__24809__a = new Array(arguments.length -  0);
while (G__24809__i < G__24809__a.length) {G__24809__a[G__24809__i] = arguments[G__24809__i + 0]; ++G__24809__i;}
  args = new cljs.core.IndexedSeq(G__24809__a,0);
} 
return G__24808__delegate.call(this,args);};
G__24808.cljs$lang$maxFixedArity = 0;
G__24808.cljs$lang$applyTo = (function (arglist__24810){
var args = cljs.core.seq(arglist__24810);
return G__24808__delegate(args);
});
G__24808.cljs$core$IFn$_invoke$arity$variadic = G__24808__delegate;
return G__24808;
})()
;
});
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel$client$get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__24811){
var map__24814 = p__24811;
var map__24814__$1 = ((((!((map__24814 == null)))?((((map__24814.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24814.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24814):map__24814);
var message = cljs.core.get.call(null,map__24814__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__24814__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str(class$),cljs.core.str(" : "),cljs.core.str(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__18202__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__18190__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__18190__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__18190__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__20617__auto___24976 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto___24976,ch){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto___24976,ch){
return (function (state_24945){
var state_val_24946 = (state_24945[(1)]);
if((state_val_24946 === (7))){
var inst_24941 = (state_24945[(2)]);
var state_24945__$1 = state_24945;
var statearr_24947_24977 = state_24945__$1;
(statearr_24947_24977[(2)] = inst_24941);

(statearr_24947_24977[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24946 === (1))){
var state_24945__$1 = state_24945;
var statearr_24948_24978 = state_24945__$1;
(statearr_24948_24978[(2)] = null);

(statearr_24948_24978[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24946 === (4))){
var inst_24898 = (state_24945[(7)]);
var inst_24898__$1 = (state_24945[(2)]);
var state_24945__$1 = (function (){var statearr_24949 = state_24945;
(statearr_24949[(7)] = inst_24898__$1);

return statearr_24949;
})();
if(cljs.core.truth_(inst_24898__$1)){
var statearr_24950_24979 = state_24945__$1;
(statearr_24950_24979[(1)] = (5));

} else {
var statearr_24951_24980 = state_24945__$1;
(statearr_24951_24980[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24946 === (15))){
var inst_24905 = (state_24945[(8)]);
var inst_24920 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_24905);
var inst_24921 = cljs.core.first.call(null,inst_24920);
var inst_24922 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_24921);
var inst_24923 = [cljs.core.str("Figwheel: Not loading code with warnings - "),cljs.core.str(inst_24922)].join('');
var inst_24924 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_24923);
var state_24945__$1 = state_24945;
var statearr_24952_24981 = state_24945__$1;
(statearr_24952_24981[(2)] = inst_24924);

(statearr_24952_24981[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24946 === (13))){
var inst_24929 = (state_24945[(2)]);
var state_24945__$1 = state_24945;
var statearr_24953_24982 = state_24945__$1;
(statearr_24953_24982[(2)] = inst_24929);

(statearr_24953_24982[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24946 === (6))){
var state_24945__$1 = state_24945;
var statearr_24954_24983 = state_24945__$1;
(statearr_24954_24983[(2)] = null);

(statearr_24954_24983[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24946 === (17))){
var inst_24927 = (state_24945[(2)]);
var state_24945__$1 = state_24945;
var statearr_24955_24984 = state_24945__$1;
(statearr_24955_24984[(2)] = inst_24927);

(statearr_24955_24984[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24946 === (3))){
var inst_24943 = (state_24945[(2)]);
var state_24945__$1 = state_24945;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24945__$1,inst_24943);
} else {
if((state_val_24946 === (12))){
var inst_24904 = (state_24945[(9)]);
var inst_24918 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_24904,opts);
var state_24945__$1 = state_24945;
if(cljs.core.truth_(inst_24918)){
var statearr_24956_24985 = state_24945__$1;
(statearr_24956_24985[(1)] = (15));

} else {
var statearr_24957_24986 = state_24945__$1;
(statearr_24957_24986[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24946 === (2))){
var state_24945__$1 = state_24945;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24945__$1,(4),ch);
} else {
if((state_val_24946 === (11))){
var inst_24905 = (state_24945[(8)]);
var inst_24910 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24911 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_24905);
var inst_24912 = cljs.core.async.timeout.call(null,(1000));
var inst_24913 = [inst_24911,inst_24912];
var inst_24914 = (new cljs.core.PersistentVector(null,2,(5),inst_24910,inst_24913,null));
var state_24945__$1 = state_24945;
return cljs.core.async.ioc_alts_BANG_.call(null,state_24945__$1,(14),inst_24914);
} else {
if((state_val_24946 === (9))){
var inst_24905 = (state_24945[(8)]);
var inst_24931 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_24932 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_24905);
var inst_24933 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_24932);
var inst_24934 = [cljs.core.str("Not loading: "),cljs.core.str(inst_24933)].join('');
var inst_24935 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_24934);
var state_24945__$1 = (function (){var statearr_24958 = state_24945;
(statearr_24958[(10)] = inst_24931);

return statearr_24958;
})();
var statearr_24959_24987 = state_24945__$1;
(statearr_24959_24987[(2)] = inst_24935);

(statearr_24959_24987[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24946 === (5))){
var inst_24898 = (state_24945[(7)]);
var inst_24900 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_24901 = (new cljs.core.PersistentArrayMap(null,2,inst_24900,null));
var inst_24902 = (new cljs.core.PersistentHashSet(null,inst_24901,null));
var inst_24903 = figwheel.client.focus_msgs.call(null,inst_24902,inst_24898);
var inst_24904 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_24903);
var inst_24905 = cljs.core.first.call(null,inst_24903);
var inst_24906 = figwheel.client.autoload_QMARK_.call(null);
var state_24945__$1 = (function (){var statearr_24960 = state_24945;
(statearr_24960[(8)] = inst_24905);

(statearr_24960[(9)] = inst_24904);

return statearr_24960;
})();
if(cljs.core.truth_(inst_24906)){
var statearr_24961_24988 = state_24945__$1;
(statearr_24961_24988[(1)] = (8));

} else {
var statearr_24962_24989 = state_24945__$1;
(statearr_24962_24989[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24946 === (14))){
var inst_24916 = (state_24945[(2)]);
var state_24945__$1 = state_24945;
var statearr_24963_24990 = state_24945__$1;
(statearr_24963_24990[(2)] = inst_24916);

(statearr_24963_24990[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24946 === (16))){
var state_24945__$1 = state_24945;
var statearr_24964_24991 = state_24945__$1;
(statearr_24964_24991[(2)] = null);

(statearr_24964_24991[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24946 === (10))){
var inst_24937 = (state_24945[(2)]);
var state_24945__$1 = (function (){var statearr_24965 = state_24945;
(statearr_24965[(11)] = inst_24937);

return statearr_24965;
})();
var statearr_24966_24992 = state_24945__$1;
(statearr_24966_24992[(2)] = null);

(statearr_24966_24992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24946 === (8))){
var inst_24904 = (state_24945[(9)]);
var inst_24908 = figwheel.client.reload_file_state_QMARK_.call(null,inst_24904,opts);
var state_24945__$1 = state_24945;
if(cljs.core.truth_(inst_24908)){
var statearr_24967_24993 = state_24945__$1;
(statearr_24967_24993[(1)] = (11));

} else {
var statearr_24968_24994 = state_24945__$1;
(statearr_24968_24994[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto___24976,ch))
;
return ((function (switch__20505__auto__,c__20617__auto___24976,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__20506__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__20506__auto____0 = (function (){
var statearr_24972 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24972[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__20506__auto__);

(statearr_24972[(1)] = (1));

return statearr_24972;
});
var figwheel$client$file_reloader_plugin_$_state_machine__20506__auto____1 = (function (state_24945){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_24945);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e24973){if((e24973 instanceof Object)){
var ex__20509__auto__ = e24973;
var statearr_24974_24995 = state_24945;
(statearr_24974_24995[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24945);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24973;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24996 = state_24945;
state_24945 = G__24996;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__20506__auto__ = function(state_24945){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__20506__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__20506__auto____1.call(this,state_24945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__20506__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__20506__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto___24976,ch))
})();
var state__20619__auto__ = (function (){var statearr_24975 = f__20618__auto__.call(null);
(statearr_24975[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto___24976);

return statearr_24975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto___24976,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__24997_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__24997_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_25004 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_25004){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var _STAR_print_fn_STAR_25002 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR_25003 = cljs.core._STAR_print_newline_STAR_;
cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_fn_STAR_25002,_STAR_print_newline_STAR_25003,base_path_25004){
return (function() { 
var G__25005__delegate = function (args){
return figwheel.client.figwheel_repl_print.call(null,figwheel.client.console_print.call(null,args));
};
var G__25005 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__25006__i = 0, G__25006__a = new Array(arguments.length -  0);
while (G__25006__i < G__25006__a.length) {G__25006__a[G__25006__i] = arguments[G__25006__i + 0]; ++G__25006__i;}
  args = new cljs.core.IndexedSeq(G__25006__a,0);
} 
return G__25005__delegate.call(this,args);};
G__25005.cljs$lang$maxFixedArity = 0;
G__25005.cljs$lang$applyTo = (function (arglist__25007){
var args = cljs.core.seq(arglist__25007);
return G__25005__delegate(args);
});
G__25005.cljs$core$IFn$_invoke$arity$variadic = G__25005__delegate;
return G__25005;
})()
;})(_STAR_print_fn_STAR_25002,_STAR_print_newline_STAR_25003,base_path_25004))
;

cljs.core._STAR_print_newline_STAR_ = false;

try{return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),[cljs.core.str(figwheel.client.utils.eval_helper.call(null,code,opts))].join('')], null));
}finally {cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_25003;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_25002;
}}catch (e25001){if((e25001 instanceof Error)){
var e = e25001;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_25004], null));
} else {
var e = e25001;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}});})(base_path_25004))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = {};
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__25008){
var map__25015 = p__25008;
var map__25015__$1 = ((((!((map__25015 == null)))?((((map__25015.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25015.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25015):map__25015);
var opts = map__25015__$1;
var build_id = cljs.core.get.call(null,map__25015__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__25015,map__25015__$1,opts,build_id){
return (function (p__25017){
var vec__25018 = p__25017;
var map__25019 = cljs.core.nth.call(null,vec__25018,(0),null);
var map__25019__$1 = ((((!((map__25019 == null)))?((((map__25019.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25019.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25019):map__25019);
var msg = map__25019__$1;
var msg_name = cljs.core.get.call(null,map__25019__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__25018,(1));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__25018,map__25019,map__25019__$1,msg,msg_name,_,map__25015,map__25015__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__25018,map__25019,map__25019__$1,msg,msg_name,_,map__25015,map__25015__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__25015,map__25015__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__25025){
var vec__25026 = p__25025;
var map__25027 = cljs.core.nth.call(null,vec__25026,(0),null);
var map__25027__$1 = ((((!((map__25027 == null)))?((((map__25027.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25027.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25027):map__25027);
var msg = map__25027__$1;
var msg_name = cljs.core.get.call(null,map__25027__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__25026,(1));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__25029){
var map__25039 = p__25029;
var map__25039__$1 = ((((!((map__25039 == null)))?((((map__25039.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25039.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25039):map__25039);
var on_compile_warning = cljs.core.get.call(null,map__25039__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__25039__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__25039,map__25039__$1,on_compile_warning,on_compile_fail){
return (function (p__25041){
var vec__25042 = p__25041;
var map__25043 = cljs.core.nth.call(null,vec__25042,(0),null);
var map__25043__$1 = ((((!((map__25043 == null)))?((((map__25043.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25043.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25043):map__25043);
var msg = map__25043__$1;
var msg_name = cljs.core.get.call(null,map__25043__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__25042,(1));
var pred__25045 = cljs.core._EQ_;
var expr__25046 = msg_name;
if(cljs.core.truth_(pred__25045.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__25046))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__25045.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__25046))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__25039,map__25039__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__20617__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto__,msg_hist,msg_names,msg){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto__,msg_hist,msg_names,msg){
return (function (state_25262){
var state_val_25263 = (state_25262[(1)]);
if((state_val_25263 === (7))){
var inst_25186 = (state_25262[(2)]);
var state_25262__$1 = state_25262;
if(cljs.core.truth_(inst_25186)){
var statearr_25264_25310 = state_25262__$1;
(statearr_25264_25310[(1)] = (8));

} else {
var statearr_25265_25311 = state_25262__$1;
(statearr_25265_25311[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (20))){
var inst_25256 = (state_25262[(2)]);
var state_25262__$1 = state_25262;
var statearr_25266_25312 = state_25262__$1;
(statearr_25266_25312[(2)] = inst_25256);

(statearr_25266_25312[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (27))){
var inst_25252 = (state_25262[(2)]);
var state_25262__$1 = state_25262;
var statearr_25267_25313 = state_25262__$1;
(statearr_25267_25313[(2)] = inst_25252);

(statearr_25267_25313[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (1))){
var inst_25179 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_25262__$1 = state_25262;
if(cljs.core.truth_(inst_25179)){
var statearr_25268_25314 = state_25262__$1;
(statearr_25268_25314[(1)] = (2));

} else {
var statearr_25269_25315 = state_25262__$1;
(statearr_25269_25315[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (24))){
var inst_25254 = (state_25262[(2)]);
var state_25262__$1 = state_25262;
var statearr_25270_25316 = state_25262__$1;
(statearr_25270_25316[(2)] = inst_25254);

(statearr_25270_25316[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (4))){
var inst_25260 = (state_25262[(2)]);
var state_25262__$1 = state_25262;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25262__$1,inst_25260);
} else {
if((state_val_25263 === (15))){
var inst_25258 = (state_25262[(2)]);
var state_25262__$1 = state_25262;
var statearr_25271_25317 = state_25262__$1;
(statearr_25271_25317[(2)] = inst_25258);

(statearr_25271_25317[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (21))){
var inst_25217 = (state_25262[(2)]);
var state_25262__$1 = state_25262;
var statearr_25272_25318 = state_25262__$1;
(statearr_25272_25318[(2)] = inst_25217);

(statearr_25272_25318[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (31))){
var inst_25241 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_25262__$1 = state_25262;
if(cljs.core.truth_(inst_25241)){
var statearr_25273_25319 = state_25262__$1;
(statearr_25273_25319[(1)] = (34));

} else {
var statearr_25274_25320 = state_25262__$1;
(statearr_25274_25320[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (32))){
var inst_25250 = (state_25262[(2)]);
var state_25262__$1 = state_25262;
var statearr_25275_25321 = state_25262__$1;
(statearr_25275_25321[(2)] = inst_25250);

(statearr_25275_25321[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (33))){
var inst_25239 = (state_25262[(2)]);
var state_25262__$1 = state_25262;
var statearr_25276_25322 = state_25262__$1;
(statearr_25276_25322[(2)] = inst_25239);

(statearr_25276_25322[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (13))){
var inst_25200 = figwheel.client.heads_up.clear.call(null);
var state_25262__$1 = state_25262;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25262__$1,(16),inst_25200);
} else {
if((state_val_25263 === (22))){
var inst_25221 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_25222 = figwheel.client.heads_up.append_message.call(null,inst_25221);
var state_25262__$1 = state_25262;
var statearr_25277_25323 = state_25262__$1;
(statearr_25277_25323[(2)] = inst_25222);

(statearr_25277_25323[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (36))){
var inst_25248 = (state_25262[(2)]);
var state_25262__$1 = state_25262;
var statearr_25278_25324 = state_25262__$1;
(statearr_25278_25324[(2)] = inst_25248);

(statearr_25278_25324[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (29))){
var inst_25232 = (state_25262[(2)]);
var state_25262__$1 = state_25262;
var statearr_25279_25325 = state_25262__$1;
(statearr_25279_25325[(2)] = inst_25232);

(statearr_25279_25325[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (6))){
var inst_25181 = (state_25262[(7)]);
var state_25262__$1 = state_25262;
var statearr_25280_25326 = state_25262__$1;
(statearr_25280_25326[(2)] = inst_25181);

(statearr_25280_25326[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (28))){
var inst_25228 = (state_25262[(2)]);
var inst_25229 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_25230 = figwheel.client.heads_up.display_warning.call(null,inst_25229);
var state_25262__$1 = (function (){var statearr_25281 = state_25262;
(statearr_25281[(8)] = inst_25228);

return statearr_25281;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25262__$1,(29),inst_25230);
} else {
if((state_val_25263 === (25))){
var inst_25226 = figwheel.client.heads_up.clear.call(null);
var state_25262__$1 = state_25262;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25262__$1,(28),inst_25226);
} else {
if((state_val_25263 === (34))){
var inst_25243 = figwheel.client.heads_up.flash_loaded.call(null);
var state_25262__$1 = state_25262;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25262__$1,(37),inst_25243);
} else {
if((state_val_25263 === (17))){
var inst_25208 = (state_25262[(2)]);
var state_25262__$1 = state_25262;
var statearr_25282_25327 = state_25262__$1;
(statearr_25282_25327[(2)] = inst_25208);

(statearr_25282_25327[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (3))){
var inst_25198 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_25262__$1 = state_25262;
if(cljs.core.truth_(inst_25198)){
var statearr_25283_25328 = state_25262__$1;
(statearr_25283_25328[(1)] = (13));

} else {
var statearr_25284_25329 = state_25262__$1;
(statearr_25284_25329[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (12))){
var inst_25194 = (state_25262[(2)]);
var state_25262__$1 = state_25262;
var statearr_25285_25330 = state_25262__$1;
(statearr_25285_25330[(2)] = inst_25194);

(statearr_25285_25330[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (2))){
var inst_25181 = (state_25262[(7)]);
var inst_25181__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_25262__$1 = (function (){var statearr_25286 = state_25262;
(statearr_25286[(7)] = inst_25181__$1);

return statearr_25286;
})();
if(cljs.core.truth_(inst_25181__$1)){
var statearr_25287_25331 = state_25262__$1;
(statearr_25287_25331[(1)] = (5));

} else {
var statearr_25288_25332 = state_25262__$1;
(statearr_25288_25332[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (23))){
var inst_25224 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_25262__$1 = state_25262;
if(cljs.core.truth_(inst_25224)){
var statearr_25289_25333 = state_25262__$1;
(statearr_25289_25333[(1)] = (25));

} else {
var statearr_25290_25334 = state_25262__$1;
(statearr_25290_25334[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (35))){
var state_25262__$1 = state_25262;
var statearr_25291_25335 = state_25262__$1;
(statearr_25291_25335[(2)] = null);

(statearr_25291_25335[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (19))){
var inst_25219 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_25262__$1 = state_25262;
if(cljs.core.truth_(inst_25219)){
var statearr_25292_25336 = state_25262__$1;
(statearr_25292_25336[(1)] = (22));

} else {
var statearr_25293_25337 = state_25262__$1;
(statearr_25293_25337[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (11))){
var inst_25190 = (state_25262[(2)]);
var state_25262__$1 = state_25262;
var statearr_25294_25338 = state_25262__$1;
(statearr_25294_25338[(2)] = inst_25190);

(statearr_25294_25338[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (9))){
var inst_25192 = figwheel.client.heads_up.clear.call(null);
var state_25262__$1 = state_25262;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25262__$1,(12),inst_25192);
} else {
if((state_val_25263 === (5))){
var inst_25183 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_25262__$1 = state_25262;
var statearr_25295_25339 = state_25262__$1;
(statearr_25295_25339[(2)] = inst_25183);

(statearr_25295_25339[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (14))){
var inst_25210 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_25262__$1 = state_25262;
if(cljs.core.truth_(inst_25210)){
var statearr_25296_25340 = state_25262__$1;
(statearr_25296_25340[(1)] = (18));

} else {
var statearr_25297_25341 = state_25262__$1;
(statearr_25297_25341[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (26))){
var inst_25234 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_25262__$1 = state_25262;
if(cljs.core.truth_(inst_25234)){
var statearr_25298_25342 = state_25262__$1;
(statearr_25298_25342[(1)] = (30));

} else {
var statearr_25299_25343 = state_25262__$1;
(statearr_25299_25343[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (16))){
var inst_25202 = (state_25262[(2)]);
var inst_25203 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_25204 = figwheel.client.format_messages.call(null,inst_25203);
var inst_25205 = new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(msg);
var inst_25206 = figwheel.client.heads_up.display_error.call(null,inst_25204,inst_25205);
var state_25262__$1 = (function (){var statearr_25300 = state_25262;
(statearr_25300[(9)] = inst_25202);

return statearr_25300;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25262__$1,(17),inst_25206);
} else {
if((state_val_25263 === (30))){
var inst_25236 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_25237 = figwheel.client.heads_up.display_warning.call(null,inst_25236);
var state_25262__$1 = state_25262;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25262__$1,(33),inst_25237);
} else {
if((state_val_25263 === (10))){
var inst_25196 = (state_25262[(2)]);
var state_25262__$1 = state_25262;
var statearr_25301_25344 = state_25262__$1;
(statearr_25301_25344[(2)] = inst_25196);

(statearr_25301_25344[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (18))){
var inst_25212 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_25213 = figwheel.client.format_messages.call(null,inst_25212);
var inst_25214 = new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(msg);
var inst_25215 = figwheel.client.heads_up.display_error.call(null,inst_25213,inst_25214);
var state_25262__$1 = state_25262;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25262__$1,(21),inst_25215);
} else {
if((state_val_25263 === (37))){
var inst_25245 = (state_25262[(2)]);
var state_25262__$1 = state_25262;
var statearr_25302_25345 = state_25262__$1;
(statearr_25302_25345[(2)] = inst_25245);

(statearr_25302_25345[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25263 === (8))){
var inst_25188 = figwheel.client.heads_up.flash_loaded.call(null);
var state_25262__$1 = state_25262;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25262__$1,(11),inst_25188);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__20505__auto__,c__20617__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20506__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20506__auto____0 = (function (){
var statearr_25306 = [null,null,null,null,null,null,null,null,null,null];
(statearr_25306[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20506__auto__);

(statearr_25306[(1)] = (1));

return statearr_25306;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20506__auto____1 = (function (state_25262){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_25262);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e25307){if((e25307 instanceof Object)){
var ex__20509__auto__ = e25307;
var statearr_25308_25346 = state_25262;
(statearr_25308_25346[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25262);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25307;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25347 = state_25262;
state_25262 = G__25347;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20506__auto__ = function(state_25262){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20506__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20506__auto____1.call(this,state_25262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20506__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20506__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto__,msg_hist,msg_names,msg))
})();
var state__20619__auto__ = (function (){var statearr_25309 = f__20618__auto__.call(null);
(statearr_25309[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto__);

return statearr_25309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto__,msg_hist,msg_names,msg))
);

return c__20617__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__20617__auto___25410 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto___25410,ch){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto___25410,ch){
return (function (state_25393){
var state_val_25394 = (state_25393[(1)]);
if((state_val_25394 === (1))){
var state_25393__$1 = state_25393;
var statearr_25395_25411 = state_25393__$1;
(statearr_25395_25411[(2)] = null);

(statearr_25395_25411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25394 === (2))){
var state_25393__$1 = state_25393;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25393__$1,(4),ch);
} else {
if((state_val_25394 === (3))){
var inst_25391 = (state_25393[(2)]);
var state_25393__$1 = state_25393;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25393__$1,inst_25391);
} else {
if((state_val_25394 === (4))){
var inst_25381 = (state_25393[(7)]);
var inst_25381__$1 = (state_25393[(2)]);
var state_25393__$1 = (function (){var statearr_25396 = state_25393;
(statearr_25396[(7)] = inst_25381__$1);

return statearr_25396;
})();
if(cljs.core.truth_(inst_25381__$1)){
var statearr_25397_25412 = state_25393__$1;
(statearr_25397_25412[(1)] = (5));

} else {
var statearr_25398_25413 = state_25393__$1;
(statearr_25398_25413[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25394 === (5))){
var inst_25381 = (state_25393[(7)]);
var inst_25383 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_25381);
var state_25393__$1 = state_25393;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25393__$1,(8),inst_25383);
} else {
if((state_val_25394 === (6))){
var state_25393__$1 = state_25393;
var statearr_25399_25414 = state_25393__$1;
(statearr_25399_25414[(2)] = null);

(statearr_25399_25414[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25394 === (7))){
var inst_25389 = (state_25393[(2)]);
var state_25393__$1 = state_25393;
var statearr_25400_25415 = state_25393__$1;
(statearr_25400_25415[(2)] = inst_25389);

(statearr_25400_25415[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25394 === (8))){
var inst_25385 = (state_25393[(2)]);
var state_25393__$1 = (function (){var statearr_25401 = state_25393;
(statearr_25401[(8)] = inst_25385);

return statearr_25401;
})();
var statearr_25402_25416 = state_25393__$1;
(statearr_25402_25416[(2)] = null);

(statearr_25402_25416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__20617__auto___25410,ch))
;
return ((function (switch__20505__auto__,c__20617__auto___25410,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__20506__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__20506__auto____0 = (function (){
var statearr_25406 = [null,null,null,null,null,null,null,null,null];
(statearr_25406[(0)] = figwheel$client$heads_up_plugin_$_state_machine__20506__auto__);

(statearr_25406[(1)] = (1));

return statearr_25406;
});
var figwheel$client$heads_up_plugin_$_state_machine__20506__auto____1 = (function (state_25393){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_25393);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e25407){if((e25407 instanceof Object)){
var ex__20509__auto__ = e25407;
var statearr_25408_25417 = state_25393;
(statearr_25408_25417[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25393);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25407;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25418 = state_25393;
state_25393 = G__25418;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__20506__auto__ = function(state_25393){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__20506__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__20506__auto____1.call(this,state_25393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__20506__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__20506__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto___25410,ch))
})();
var state__20619__auto__ = (function (){var statearr_25409 = f__20618__auto__.call(null);
(statearr_25409[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto___25410);

return statearr_25409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto___25410,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__20617__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto__){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto__){
return (function (state_25439){
var state_val_25440 = (state_25439[(1)]);
if((state_val_25440 === (1))){
var inst_25434 = cljs.core.async.timeout.call(null,(3000));
var state_25439__$1 = state_25439;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25439__$1,(2),inst_25434);
} else {
if((state_val_25440 === (2))){
var inst_25436 = (state_25439[(2)]);
var inst_25437 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_25439__$1 = (function (){var statearr_25441 = state_25439;
(statearr_25441[(7)] = inst_25436);

return statearr_25441;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25439__$1,inst_25437);
} else {
return null;
}
}
});})(c__20617__auto__))
;
return ((function (switch__20505__auto__,c__20617__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__20506__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__20506__auto____0 = (function (){
var statearr_25445 = [null,null,null,null,null,null,null,null];
(statearr_25445[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__20506__auto__);

(statearr_25445[(1)] = (1));

return statearr_25445;
});
var figwheel$client$enforce_project_plugin_$_state_machine__20506__auto____1 = (function (state_25439){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_25439);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e25446){if((e25446 instanceof Object)){
var ex__20509__auto__ = e25446;
var statearr_25447_25449 = state_25439;
(statearr_25447_25449[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25439);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25446;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25450 = state_25439;
state_25439 = G__25450;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__20506__auto__ = function(state_25439){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__20506__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__20506__auto____1.call(this,state_25439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__20506__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__20506__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto__))
})();
var state__20619__auto__ = (function (){var statearr_25448 = f__20618__auto__.call(null);
(statearr_25448[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto__);

return statearr_25448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto__))
);

return c__20617__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__25451){
var map__25458 = p__25451;
var map__25458__$1 = ((((!((map__25458 == null)))?((((map__25458.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25458.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25458):map__25458);
var ed = map__25458__$1;
var formatted_exception = cljs.core.get.call(null,map__25458__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__25458__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__25458__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__25460_25464 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__25461_25465 = null;
var count__25462_25466 = (0);
var i__25463_25467 = (0);
while(true){
if((i__25463_25467 < count__25462_25466)){
var msg_25468 = cljs.core._nth.call(null,chunk__25461_25465,i__25463_25467);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_25468);

var G__25469 = seq__25460_25464;
var G__25470 = chunk__25461_25465;
var G__25471 = count__25462_25466;
var G__25472 = (i__25463_25467 + (1));
seq__25460_25464 = G__25469;
chunk__25461_25465 = G__25470;
count__25462_25466 = G__25471;
i__25463_25467 = G__25472;
continue;
} else {
var temp__4425__auto___25473 = cljs.core.seq.call(null,seq__25460_25464);
if(temp__4425__auto___25473){
var seq__25460_25474__$1 = temp__4425__auto___25473;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25460_25474__$1)){
var c__19005__auto___25475 = cljs.core.chunk_first.call(null,seq__25460_25474__$1);
var G__25476 = cljs.core.chunk_rest.call(null,seq__25460_25474__$1);
var G__25477 = c__19005__auto___25475;
var G__25478 = cljs.core.count.call(null,c__19005__auto___25475);
var G__25479 = (0);
seq__25460_25464 = G__25476;
chunk__25461_25465 = G__25477;
count__25462_25466 = G__25478;
i__25463_25467 = G__25479;
continue;
} else {
var msg_25480 = cljs.core.first.call(null,seq__25460_25474__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_25480);

var G__25481 = cljs.core.next.call(null,seq__25460_25474__$1);
var G__25482 = null;
var G__25483 = (0);
var G__25484 = (0);
seq__25460_25464 = G__25481;
chunk__25461_25465 = G__25482;
count__25462_25466 = G__25483;
i__25463_25467 = G__25484;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Error on file "),cljs.core.str(new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(cause)),cljs.core.str(", line "),cljs.core.str(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(cause)),cljs.core.str(", column "),cljs.core.str(new cljs.core.Keyword(null,"column","column",2078222095).cljs$core$IFn$_invoke$arity$1(cause))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__25485){
var map__25488 = p__25485;
var map__25488__$1 = ((((!((map__25488 == null)))?((((map__25488.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25488.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25488):map__25488);
var w = map__25488__$1;
var message = cljs.core.get.call(null,map__25488__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str("Figwheel: Compile Warning - "),cljs.core.str(message)].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[figwheel.client.default_on_compile_warning,figwheel.client.default_on_jsload,true,figwheel.client.default_on_compile_fail,false,true,[cljs.core.str("ws://"),cljs.core.str((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str("/figwheel-ws")].join(''),figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__18190__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__18190__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__18190__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__25496 = cljs.core.seq.call(null,plugins);
var chunk__25497 = null;
var count__25498 = (0);
var i__25499 = (0);
while(true){
if((i__25499 < count__25498)){
var vec__25500 = cljs.core._nth.call(null,chunk__25497,i__25499);
var k = cljs.core.nth.call(null,vec__25500,(0),null);
var plugin = cljs.core.nth.call(null,vec__25500,(1),null);
if(cljs.core.truth_(plugin)){
var pl_25502 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__25496,chunk__25497,count__25498,i__25499,pl_25502,vec__25500,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_25502.call(null,msg_hist);
});})(seq__25496,chunk__25497,count__25498,i__25499,pl_25502,vec__25500,k,plugin))
);
} else {
}

var G__25503 = seq__25496;
var G__25504 = chunk__25497;
var G__25505 = count__25498;
var G__25506 = (i__25499 + (1));
seq__25496 = G__25503;
chunk__25497 = G__25504;
count__25498 = G__25505;
i__25499 = G__25506;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__25496);
if(temp__4425__auto__){
var seq__25496__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25496__$1)){
var c__19005__auto__ = cljs.core.chunk_first.call(null,seq__25496__$1);
var G__25507 = cljs.core.chunk_rest.call(null,seq__25496__$1);
var G__25508 = c__19005__auto__;
var G__25509 = cljs.core.count.call(null,c__19005__auto__);
var G__25510 = (0);
seq__25496 = G__25507;
chunk__25497 = G__25508;
count__25498 = G__25509;
i__25499 = G__25510;
continue;
} else {
var vec__25501 = cljs.core.first.call(null,seq__25496__$1);
var k = cljs.core.nth.call(null,vec__25501,(0),null);
var plugin = cljs.core.nth.call(null,vec__25501,(1),null);
if(cljs.core.truth_(plugin)){
var pl_25511 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__25496,chunk__25497,count__25498,i__25499,pl_25511,vec__25501,k,plugin,seq__25496__$1,temp__4425__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_25511.call(null,msg_hist);
});})(seq__25496,chunk__25497,count__25498,i__25499,pl_25511,vec__25501,k,plugin,seq__25496__$1,temp__4425__auto__))
);
} else {
}

var G__25512 = cljs.core.next.call(null,seq__25496__$1);
var G__25513 = null;
var G__25514 = (0);
var G__25515 = (0);
seq__25496 = G__25512;
chunk__25497 = G__25513;
count__25498 = G__25514;
i__25499 = G__25515;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var args25516 = [];
var len__19260__auto___25519 = arguments.length;
var i__19261__auto___25520 = (0);
while(true){
if((i__19261__auto___25520 < len__19260__auto___25519)){
args25516.push((arguments[i__19261__auto___25520]));

var G__25521 = (i__19261__auto___25520 + (1));
i__19261__auto___25520 = G__25521;
continue;
} else {
}
break;
}

var G__25518 = args25516.length;
switch (G__25518) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25516.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

return figwheel.client.socket.open.call(null,system_options);
}));
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;
figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__19267__auto__ = [];
var len__19260__auto___25527 = arguments.length;
var i__19261__auto___25528 = (0);
while(true){
if((i__19261__auto___25528 < len__19260__auto___25527)){
args__19267__auto__.push((arguments[i__19261__auto___25528]));

var G__25529 = (i__19261__auto___25528 + (1));
i__19261__auto___25528 = G__25529;
continue;
} else {
}
break;
}

var argseq__19268__auto__ = ((((0) < args__19267__auto__.length))?(new cljs.core.IndexedSeq(args__19267__auto__.slice((0)),(0))):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__19268__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__25524){
var map__25525 = p__25524;
var map__25525__$1 = ((((!((map__25525 == null)))?((((map__25525.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25525.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25525):map__25525);
var opts = map__25525__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq25523){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq25523));
});

//# sourceMappingURL=client.js.map