// Compiled by ClojureScript 1.7.228 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args20662 = [];
var len__19260__auto___20668 = arguments.length;
var i__19261__auto___20669 = (0);
while(true){
if((i__19261__auto___20669 < len__19260__auto___20668)){
args20662.push((arguments[i__19261__auto___20669]));

var G__20670 = (i__19261__auto___20669 + (1));
i__19261__auto___20669 = G__20670;
continue;
} else {
}
break;
}

var G__20664 = args20662.length;
switch (G__20664) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20662.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async20665 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20665 = (function (f,blockable,meta20666){
this.f = f;
this.blockable = blockable;
this.meta20666 = meta20666;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20665.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20667,meta20666__$1){
var self__ = this;
var _20667__$1 = this;
return (new cljs.core.async.t_cljs$core$async20665(self__.f,self__.blockable,meta20666__$1));
});

cljs.core.async.t_cljs$core$async20665.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20667){
var self__ = this;
var _20667__$1 = this;
return self__.meta20666;
});

cljs.core.async.t_cljs$core$async20665.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20665.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async20665.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async20665.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async20665.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta20666","meta20666",-435294268,null)], null);
});

cljs.core.async.t_cljs$core$async20665.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20665.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20665";

cljs.core.async.t_cljs$core$async20665.cljs$lang$ctorPrWriter = (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async20665");
});

cljs.core.async.__GT_t_cljs$core$async20665 = (function cljs$core$async$__GT_t_cljs$core$async20665(f__$1,blockable__$1,meta20666){
return (new cljs.core.async.t_cljs$core$async20665(f__$1,blockable__$1,meta20666));
});

}

return (new cljs.core.async.t_cljs$core$async20665(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args20674 = [];
var len__19260__auto___20677 = arguments.length;
var i__19261__auto___20678 = (0);
while(true){
if((i__19261__auto___20678 < len__19260__auto___20677)){
args20674.push((arguments[i__19261__auto___20678]));

var G__20679 = (i__19261__auto___20678 + (1));
i__19261__auto___20678 = G__20679;
continue;
} else {
}
break;
}

var G__20676 = args20674.length;
switch (G__20676) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20674.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args20681 = [];
var len__19260__auto___20684 = arguments.length;
var i__19261__auto___20685 = (0);
while(true){
if((i__19261__auto___20685 < len__19260__auto___20684)){
args20681.push((arguments[i__19261__auto___20685]));

var G__20686 = (i__19261__auto___20685 + (1));
i__19261__auto___20685 = G__20686;
continue;
} else {
}
break;
}

var G__20683 = args20681.length;
switch (G__20683) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20681.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args20688 = [];
var len__19260__auto___20691 = arguments.length;
var i__19261__auto___20692 = (0);
while(true){
if((i__19261__auto___20692 < len__19260__auto___20691)){
args20688.push((arguments[i__19261__auto___20692]));

var G__20693 = (i__19261__auto___20692 + (1));
i__19261__auto___20692 = G__20693;
continue;
} else {
}
break;
}

var G__20690 = args20688.length;
switch (G__20690) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20688.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_20695 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_20695);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_20695,ret){
return (function (){
return fn1.call(null,val_20695);
});})(val_20695,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args20696 = [];
var len__19260__auto___20699 = arguments.length;
var i__19261__auto___20700 = (0);
while(true){
if((i__19261__auto___20700 < len__19260__auto___20699)){
args20696.push((arguments[i__19261__auto___20700]));

var G__20701 = (i__19261__auto___20700 + (1));
i__19261__auto___20700 = G__20701;
continue;
} else {
}
break;
}

var G__20698 = args20696.length;
switch (G__20698) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20696.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__19105__auto___20703 = n;
var x_20704 = (0);
while(true){
if((x_20704 < n__19105__auto___20703)){
(a[x_20704] = (0));

var G__20705 = (x_20704 + (1));
x_20704 = G__20705;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__20706 = (i + (1));
i = G__20706;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async20710 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20710 = (function (alt_flag,flag,meta20711){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta20711 = meta20711;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20710.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_20712,meta20711__$1){
var self__ = this;
var _20712__$1 = this;
return (new cljs.core.async.t_cljs$core$async20710(self__.alt_flag,self__.flag,meta20711__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async20710.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_20712){
var self__ = this;
var _20712__$1 = this;
return self__.meta20711;
});})(flag))
;

cljs.core.async.t_cljs$core$async20710.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20710.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async20710.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async20710.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async20710.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta20711","meta20711",2100872266,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async20710.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20710.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20710";

cljs.core.async.t_cljs$core$async20710.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async20710");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async20710 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async20710(alt_flag__$1,flag__$1,meta20711){
return (new cljs.core.async.t_cljs$core$async20710(alt_flag__$1,flag__$1,meta20711));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async20710(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async20716 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20716 = (function (alt_handler,flag,cb,meta20717){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta20717 = meta20717;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20716.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20718,meta20717__$1){
var self__ = this;
var _20718__$1 = this;
return (new cljs.core.async.t_cljs$core$async20716(self__.alt_handler,self__.flag,self__.cb,meta20717__$1));
});

cljs.core.async.t_cljs$core$async20716.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20718){
var self__ = this;
var _20718__$1 = this;
return self__.meta20717;
});

cljs.core.async.t_cljs$core$async20716.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20716.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async20716.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async20716.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async20716.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta20717","meta20717",-1713094687,null)], null);
});

cljs.core.async.t_cljs$core$async20716.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20716.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20716";

cljs.core.async.t_cljs$core$async20716.cljs$lang$ctorPrWriter = (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async20716");
});

cljs.core.async.__GT_t_cljs$core$async20716 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async20716(alt_handler__$1,flag__$1,cb__$1,meta20717){
return (new cljs.core.async.t_cljs$core$async20716(alt_handler__$1,flag__$1,cb__$1,meta20717));
});

}

return (new cljs.core.async.t_cljs$core$async20716(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20719_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20719_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20720_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20720_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__18202__auto__ = wport;
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
return port;
}
})()], null));
} else {
var G__20721 = (i + (1));
i = G__20721;
continue;
}
} else {
return null;
}
break;
}
})();
var or__18202__auto__ = ret;
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__18190__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__18190__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__18190__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__19267__auto__ = [];
var len__19260__auto___20727 = arguments.length;
var i__19261__auto___20728 = (0);
while(true){
if((i__19261__auto___20728 < len__19260__auto___20727)){
args__19267__auto__.push((arguments[i__19261__auto___20728]));

var G__20729 = (i__19261__auto___20728 + (1));
i__19261__auto___20728 = G__20729;
continue;
} else {
}
break;
}

var argseq__19268__auto__ = ((((1) < args__19267__auto__.length))?(new cljs.core.IndexedSeq(args__19267__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19268__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__20724){
var map__20725 = p__20724;
var map__20725__$1 = ((((!((map__20725 == null)))?((((map__20725.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20725.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20725):map__20725);
var opts = map__20725__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq20722){
var G__20723 = cljs.core.first.call(null,seq20722);
var seq20722__$1 = cljs.core.next.call(null,seq20722);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20723,seq20722__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args20730 = [];
var len__19260__auto___20780 = arguments.length;
var i__19261__auto___20781 = (0);
while(true){
if((i__19261__auto___20781 < len__19260__auto___20780)){
args20730.push((arguments[i__19261__auto___20781]));

var G__20782 = (i__19261__auto___20781 + (1));
i__19261__auto___20781 = G__20782;
continue;
} else {
}
break;
}

var G__20732 = args20730.length;
switch (G__20732) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20730.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__20617__auto___20784 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto___20784){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto___20784){
return (function (state_20756){
var state_val_20757 = (state_20756[(1)]);
if((state_val_20757 === (7))){
var inst_20752 = (state_20756[(2)]);
var state_20756__$1 = state_20756;
var statearr_20758_20785 = state_20756__$1;
(statearr_20758_20785[(2)] = inst_20752);

(statearr_20758_20785[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20757 === (1))){
var state_20756__$1 = state_20756;
var statearr_20759_20786 = state_20756__$1;
(statearr_20759_20786[(2)] = null);

(statearr_20759_20786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20757 === (4))){
var inst_20735 = (state_20756[(7)]);
var inst_20735__$1 = (state_20756[(2)]);
var inst_20736 = (inst_20735__$1 == null);
var state_20756__$1 = (function (){var statearr_20760 = state_20756;
(statearr_20760[(7)] = inst_20735__$1);

return statearr_20760;
})();
if(cljs.core.truth_(inst_20736)){
var statearr_20761_20787 = state_20756__$1;
(statearr_20761_20787[(1)] = (5));

} else {
var statearr_20762_20788 = state_20756__$1;
(statearr_20762_20788[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20757 === (13))){
var state_20756__$1 = state_20756;
var statearr_20763_20789 = state_20756__$1;
(statearr_20763_20789[(2)] = null);

(statearr_20763_20789[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20757 === (6))){
var inst_20735 = (state_20756[(7)]);
var state_20756__$1 = state_20756;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20756__$1,(11),to,inst_20735);
} else {
if((state_val_20757 === (3))){
var inst_20754 = (state_20756[(2)]);
var state_20756__$1 = state_20756;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20756__$1,inst_20754);
} else {
if((state_val_20757 === (12))){
var state_20756__$1 = state_20756;
var statearr_20764_20790 = state_20756__$1;
(statearr_20764_20790[(2)] = null);

(statearr_20764_20790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20757 === (2))){
var state_20756__$1 = state_20756;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20756__$1,(4),from);
} else {
if((state_val_20757 === (11))){
var inst_20745 = (state_20756[(2)]);
var state_20756__$1 = state_20756;
if(cljs.core.truth_(inst_20745)){
var statearr_20765_20791 = state_20756__$1;
(statearr_20765_20791[(1)] = (12));

} else {
var statearr_20766_20792 = state_20756__$1;
(statearr_20766_20792[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20757 === (9))){
var state_20756__$1 = state_20756;
var statearr_20767_20793 = state_20756__$1;
(statearr_20767_20793[(2)] = null);

(statearr_20767_20793[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20757 === (5))){
var state_20756__$1 = state_20756;
if(cljs.core.truth_(close_QMARK_)){
var statearr_20768_20794 = state_20756__$1;
(statearr_20768_20794[(1)] = (8));

} else {
var statearr_20769_20795 = state_20756__$1;
(statearr_20769_20795[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20757 === (14))){
var inst_20750 = (state_20756[(2)]);
var state_20756__$1 = state_20756;
var statearr_20770_20796 = state_20756__$1;
(statearr_20770_20796[(2)] = inst_20750);

(statearr_20770_20796[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20757 === (10))){
var inst_20742 = (state_20756[(2)]);
var state_20756__$1 = state_20756;
var statearr_20771_20797 = state_20756__$1;
(statearr_20771_20797[(2)] = inst_20742);

(statearr_20771_20797[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20757 === (8))){
var inst_20739 = cljs.core.async.close_BANG_.call(null,to);
var state_20756__$1 = state_20756;
var statearr_20772_20798 = state_20756__$1;
(statearr_20772_20798[(2)] = inst_20739);

(statearr_20772_20798[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto___20784))
;
return ((function (switch__20505__auto__,c__20617__auto___20784){
return (function() {
var cljs$core$async$state_machine__20506__auto__ = null;
var cljs$core$async$state_machine__20506__auto____0 = (function (){
var statearr_20776 = [null,null,null,null,null,null,null,null];
(statearr_20776[(0)] = cljs$core$async$state_machine__20506__auto__);

(statearr_20776[(1)] = (1));

return statearr_20776;
});
var cljs$core$async$state_machine__20506__auto____1 = (function (state_20756){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_20756);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e20777){if((e20777 instanceof Object)){
var ex__20509__auto__ = e20777;
var statearr_20778_20799 = state_20756;
(statearr_20778_20799[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20756);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20777;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20800 = state_20756;
state_20756 = G__20800;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$state_machine__20506__auto__ = function(state_20756){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20506__auto____1.call(this,state_20756);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20506__auto____0;
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20506__auto____1;
return cljs$core$async$state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto___20784))
})();
var state__20619__auto__ = (function (){var statearr_20779 = f__20618__auto__.call(null);
(statearr_20779[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto___20784);

return statearr_20779;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto___20784))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__20984){
var vec__20985 = p__20984;
var v = cljs.core.nth.call(null,vec__20985,(0),null);
var p = cljs.core.nth.call(null,vec__20985,(1),null);
var job = vec__20985;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__20617__auto___21167 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto___21167,res,vec__20985,v,p,job,jobs,results){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto___21167,res,vec__20985,v,p,job,jobs,results){
return (function (state_20990){
var state_val_20991 = (state_20990[(1)]);
if((state_val_20991 === (1))){
var state_20990__$1 = state_20990;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20990__$1,(2),res,v);
} else {
if((state_val_20991 === (2))){
var inst_20987 = (state_20990[(2)]);
var inst_20988 = cljs.core.async.close_BANG_.call(null,res);
var state_20990__$1 = (function (){var statearr_20992 = state_20990;
(statearr_20992[(7)] = inst_20987);

return statearr_20992;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20990__$1,inst_20988);
} else {
return null;
}
}
});})(c__20617__auto___21167,res,vec__20985,v,p,job,jobs,results))
;
return ((function (switch__20505__auto__,c__20617__auto___21167,res,vec__20985,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____0 = (function (){
var statearr_20996 = [null,null,null,null,null,null,null,null];
(statearr_20996[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__);

(statearr_20996[(1)] = (1));

return statearr_20996;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____1 = (function (state_20990){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_20990);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e20997){if((e20997 instanceof Object)){
var ex__20509__auto__ = e20997;
var statearr_20998_21168 = state_20990;
(statearr_20998_21168[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20990);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20997;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21169 = state_20990;
state_20990 = G__21169;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__ = function(state_20990){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____1.call(this,state_20990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto___21167,res,vec__20985,v,p,job,jobs,results))
})();
var state__20619__auto__ = (function (){var statearr_20999 = f__20618__auto__.call(null);
(statearr_20999[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto___21167);

return statearr_20999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto___21167,res,vec__20985,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__21000){
var vec__21001 = p__21000;
var v = cljs.core.nth.call(null,vec__21001,(0),null);
var p = cljs.core.nth.call(null,vec__21001,(1),null);
var job = vec__21001;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__19105__auto___21170 = n;
var __21171 = (0);
while(true){
if((__21171 < n__19105__auto___21170)){
var G__21002_21172 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__21002_21172) {
case "compute":
var c__20617__auto___21174 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__21171,c__20617__auto___21174,G__21002_21172,n__19105__auto___21170,jobs,results,process,async){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (__21171,c__20617__auto___21174,G__21002_21172,n__19105__auto___21170,jobs,results,process,async){
return (function (state_21015){
var state_val_21016 = (state_21015[(1)]);
if((state_val_21016 === (1))){
var state_21015__$1 = state_21015;
var statearr_21017_21175 = state_21015__$1;
(statearr_21017_21175[(2)] = null);

(statearr_21017_21175[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21016 === (2))){
var state_21015__$1 = state_21015;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21015__$1,(4),jobs);
} else {
if((state_val_21016 === (3))){
var inst_21013 = (state_21015[(2)]);
var state_21015__$1 = state_21015;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21015__$1,inst_21013);
} else {
if((state_val_21016 === (4))){
var inst_21005 = (state_21015[(2)]);
var inst_21006 = process.call(null,inst_21005);
var state_21015__$1 = state_21015;
if(cljs.core.truth_(inst_21006)){
var statearr_21018_21176 = state_21015__$1;
(statearr_21018_21176[(1)] = (5));

} else {
var statearr_21019_21177 = state_21015__$1;
(statearr_21019_21177[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21016 === (5))){
var state_21015__$1 = state_21015;
var statearr_21020_21178 = state_21015__$1;
(statearr_21020_21178[(2)] = null);

(statearr_21020_21178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21016 === (6))){
var state_21015__$1 = state_21015;
var statearr_21021_21179 = state_21015__$1;
(statearr_21021_21179[(2)] = null);

(statearr_21021_21179[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21016 === (7))){
var inst_21011 = (state_21015[(2)]);
var state_21015__$1 = state_21015;
var statearr_21022_21180 = state_21015__$1;
(statearr_21022_21180[(2)] = inst_21011);

(statearr_21022_21180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__21171,c__20617__auto___21174,G__21002_21172,n__19105__auto___21170,jobs,results,process,async))
;
return ((function (__21171,switch__20505__auto__,c__20617__auto___21174,G__21002_21172,n__19105__auto___21170,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____0 = (function (){
var statearr_21026 = [null,null,null,null,null,null,null];
(statearr_21026[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__);

(statearr_21026[(1)] = (1));

return statearr_21026;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____1 = (function (state_21015){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_21015);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e21027){if((e21027 instanceof Object)){
var ex__20509__auto__ = e21027;
var statearr_21028_21181 = state_21015;
(statearr_21028_21181[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21015);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21027;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21182 = state_21015;
state_21015 = G__21182;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__ = function(state_21015){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____1.call(this,state_21015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__;
})()
;})(__21171,switch__20505__auto__,c__20617__auto___21174,G__21002_21172,n__19105__auto___21170,jobs,results,process,async))
})();
var state__20619__auto__ = (function (){var statearr_21029 = f__20618__auto__.call(null);
(statearr_21029[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto___21174);

return statearr_21029;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(__21171,c__20617__auto___21174,G__21002_21172,n__19105__auto___21170,jobs,results,process,async))
);


break;
case "async":
var c__20617__auto___21183 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__21171,c__20617__auto___21183,G__21002_21172,n__19105__auto___21170,jobs,results,process,async){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (__21171,c__20617__auto___21183,G__21002_21172,n__19105__auto___21170,jobs,results,process,async){
return (function (state_21042){
var state_val_21043 = (state_21042[(1)]);
if((state_val_21043 === (1))){
var state_21042__$1 = state_21042;
var statearr_21044_21184 = state_21042__$1;
(statearr_21044_21184[(2)] = null);

(statearr_21044_21184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21043 === (2))){
var state_21042__$1 = state_21042;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21042__$1,(4),jobs);
} else {
if((state_val_21043 === (3))){
var inst_21040 = (state_21042[(2)]);
var state_21042__$1 = state_21042;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21042__$1,inst_21040);
} else {
if((state_val_21043 === (4))){
var inst_21032 = (state_21042[(2)]);
var inst_21033 = async.call(null,inst_21032);
var state_21042__$1 = state_21042;
if(cljs.core.truth_(inst_21033)){
var statearr_21045_21185 = state_21042__$1;
(statearr_21045_21185[(1)] = (5));

} else {
var statearr_21046_21186 = state_21042__$1;
(statearr_21046_21186[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21043 === (5))){
var state_21042__$1 = state_21042;
var statearr_21047_21187 = state_21042__$1;
(statearr_21047_21187[(2)] = null);

(statearr_21047_21187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21043 === (6))){
var state_21042__$1 = state_21042;
var statearr_21048_21188 = state_21042__$1;
(statearr_21048_21188[(2)] = null);

(statearr_21048_21188[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21043 === (7))){
var inst_21038 = (state_21042[(2)]);
var state_21042__$1 = state_21042;
var statearr_21049_21189 = state_21042__$1;
(statearr_21049_21189[(2)] = inst_21038);

(statearr_21049_21189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__21171,c__20617__auto___21183,G__21002_21172,n__19105__auto___21170,jobs,results,process,async))
;
return ((function (__21171,switch__20505__auto__,c__20617__auto___21183,G__21002_21172,n__19105__auto___21170,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____0 = (function (){
var statearr_21053 = [null,null,null,null,null,null,null];
(statearr_21053[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__);

(statearr_21053[(1)] = (1));

return statearr_21053;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____1 = (function (state_21042){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_21042);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e21054){if((e21054 instanceof Object)){
var ex__20509__auto__ = e21054;
var statearr_21055_21190 = state_21042;
(statearr_21055_21190[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21042);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21054;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21191 = state_21042;
state_21042 = G__21191;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__ = function(state_21042){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____1.call(this,state_21042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__;
})()
;})(__21171,switch__20505__auto__,c__20617__auto___21183,G__21002_21172,n__19105__auto___21170,jobs,results,process,async))
})();
var state__20619__auto__ = (function (){var statearr_21056 = f__20618__auto__.call(null);
(statearr_21056[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto___21183);

return statearr_21056;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(__21171,c__20617__auto___21183,G__21002_21172,n__19105__auto___21170,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__21192 = (__21171 + (1));
__21171 = G__21192;
continue;
} else {
}
break;
}

var c__20617__auto___21193 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto___21193,jobs,results,process,async){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto___21193,jobs,results,process,async){
return (function (state_21078){
var state_val_21079 = (state_21078[(1)]);
if((state_val_21079 === (1))){
var state_21078__$1 = state_21078;
var statearr_21080_21194 = state_21078__$1;
(statearr_21080_21194[(2)] = null);

(statearr_21080_21194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21079 === (2))){
var state_21078__$1 = state_21078;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21078__$1,(4),from);
} else {
if((state_val_21079 === (3))){
var inst_21076 = (state_21078[(2)]);
var state_21078__$1 = state_21078;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21078__$1,inst_21076);
} else {
if((state_val_21079 === (4))){
var inst_21059 = (state_21078[(7)]);
var inst_21059__$1 = (state_21078[(2)]);
var inst_21060 = (inst_21059__$1 == null);
var state_21078__$1 = (function (){var statearr_21081 = state_21078;
(statearr_21081[(7)] = inst_21059__$1);

return statearr_21081;
})();
if(cljs.core.truth_(inst_21060)){
var statearr_21082_21195 = state_21078__$1;
(statearr_21082_21195[(1)] = (5));

} else {
var statearr_21083_21196 = state_21078__$1;
(statearr_21083_21196[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21079 === (5))){
var inst_21062 = cljs.core.async.close_BANG_.call(null,jobs);
var state_21078__$1 = state_21078;
var statearr_21084_21197 = state_21078__$1;
(statearr_21084_21197[(2)] = inst_21062);

(statearr_21084_21197[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21079 === (6))){
var inst_21064 = (state_21078[(8)]);
var inst_21059 = (state_21078[(7)]);
var inst_21064__$1 = cljs.core.async.chan.call(null,(1));
var inst_21065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21066 = [inst_21059,inst_21064__$1];
var inst_21067 = (new cljs.core.PersistentVector(null,2,(5),inst_21065,inst_21066,null));
var state_21078__$1 = (function (){var statearr_21085 = state_21078;
(statearr_21085[(8)] = inst_21064__$1);

return statearr_21085;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21078__$1,(8),jobs,inst_21067);
} else {
if((state_val_21079 === (7))){
var inst_21074 = (state_21078[(2)]);
var state_21078__$1 = state_21078;
var statearr_21086_21198 = state_21078__$1;
(statearr_21086_21198[(2)] = inst_21074);

(statearr_21086_21198[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21079 === (8))){
var inst_21064 = (state_21078[(8)]);
var inst_21069 = (state_21078[(2)]);
var state_21078__$1 = (function (){var statearr_21087 = state_21078;
(statearr_21087[(9)] = inst_21069);

return statearr_21087;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21078__$1,(9),results,inst_21064);
} else {
if((state_val_21079 === (9))){
var inst_21071 = (state_21078[(2)]);
var state_21078__$1 = (function (){var statearr_21088 = state_21078;
(statearr_21088[(10)] = inst_21071);

return statearr_21088;
})();
var statearr_21089_21199 = state_21078__$1;
(statearr_21089_21199[(2)] = null);

(statearr_21089_21199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__20617__auto___21193,jobs,results,process,async))
;
return ((function (switch__20505__auto__,c__20617__auto___21193,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____0 = (function (){
var statearr_21093 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21093[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__);

(statearr_21093[(1)] = (1));

return statearr_21093;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____1 = (function (state_21078){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_21078);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e21094){if((e21094 instanceof Object)){
var ex__20509__auto__ = e21094;
var statearr_21095_21200 = state_21078;
(statearr_21095_21200[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21078);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21094;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21201 = state_21078;
state_21078 = G__21201;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__ = function(state_21078){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____1.call(this,state_21078);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto___21193,jobs,results,process,async))
})();
var state__20619__auto__ = (function (){var statearr_21096 = f__20618__auto__.call(null);
(statearr_21096[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto___21193);

return statearr_21096;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto___21193,jobs,results,process,async))
);


var c__20617__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto__,jobs,results,process,async){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto__,jobs,results,process,async){
return (function (state_21134){
var state_val_21135 = (state_21134[(1)]);
if((state_val_21135 === (7))){
var inst_21130 = (state_21134[(2)]);
var state_21134__$1 = state_21134;
var statearr_21136_21202 = state_21134__$1;
(statearr_21136_21202[(2)] = inst_21130);

(statearr_21136_21202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21135 === (20))){
var state_21134__$1 = state_21134;
var statearr_21137_21203 = state_21134__$1;
(statearr_21137_21203[(2)] = null);

(statearr_21137_21203[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21135 === (1))){
var state_21134__$1 = state_21134;
var statearr_21138_21204 = state_21134__$1;
(statearr_21138_21204[(2)] = null);

(statearr_21138_21204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21135 === (4))){
var inst_21099 = (state_21134[(7)]);
var inst_21099__$1 = (state_21134[(2)]);
var inst_21100 = (inst_21099__$1 == null);
var state_21134__$1 = (function (){var statearr_21139 = state_21134;
(statearr_21139[(7)] = inst_21099__$1);

return statearr_21139;
})();
if(cljs.core.truth_(inst_21100)){
var statearr_21140_21205 = state_21134__$1;
(statearr_21140_21205[(1)] = (5));

} else {
var statearr_21141_21206 = state_21134__$1;
(statearr_21141_21206[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21135 === (15))){
var inst_21112 = (state_21134[(8)]);
var state_21134__$1 = state_21134;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21134__$1,(18),to,inst_21112);
} else {
if((state_val_21135 === (21))){
var inst_21125 = (state_21134[(2)]);
var state_21134__$1 = state_21134;
var statearr_21142_21207 = state_21134__$1;
(statearr_21142_21207[(2)] = inst_21125);

(statearr_21142_21207[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21135 === (13))){
var inst_21127 = (state_21134[(2)]);
var state_21134__$1 = (function (){var statearr_21143 = state_21134;
(statearr_21143[(9)] = inst_21127);

return statearr_21143;
})();
var statearr_21144_21208 = state_21134__$1;
(statearr_21144_21208[(2)] = null);

(statearr_21144_21208[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21135 === (6))){
var inst_21099 = (state_21134[(7)]);
var state_21134__$1 = state_21134;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21134__$1,(11),inst_21099);
} else {
if((state_val_21135 === (17))){
var inst_21120 = (state_21134[(2)]);
var state_21134__$1 = state_21134;
if(cljs.core.truth_(inst_21120)){
var statearr_21145_21209 = state_21134__$1;
(statearr_21145_21209[(1)] = (19));

} else {
var statearr_21146_21210 = state_21134__$1;
(statearr_21146_21210[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21135 === (3))){
var inst_21132 = (state_21134[(2)]);
var state_21134__$1 = state_21134;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21134__$1,inst_21132);
} else {
if((state_val_21135 === (12))){
var inst_21109 = (state_21134[(10)]);
var state_21134__$1 = state_21134;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21134__$1,(14),inst_21109);
} else {
if((state_val_21135 === (2))){
var state_21134__$1 = state_21134;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21134__$1,(4),results);
} else {
if((state_val_21135 === (19))){
var state_21134__$1 = state_21134;
var statearr_21147_21211 = state_21134__$1;
(statearr_21147_21211[(2)] = null);

(statearr_21147_21211[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21135 === (11))){
var inst_21109 = (state_21134[(2)]);
var state_21134__$1 = (function (){var statearr_21148 = state_21134;
(statearr_21148[(10)] = inst_21109);

return statearr_21148;
})();
var statearr_21149_21212 = state_21134__$1;
(statearr_21149_21212[(2)] = null);

(statearr_21149_21212[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21135 === (9))){
var state_21134__$1 = state_21134;
var statearr_21150_21213 = state_21134__$1;
(statearr_21150_21213[(2)] = null);

(statearr_21150_21213[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21135 === (5))){
var state_21134__$1 = state_21134;
if(cljs.core.truth_(close_QMARK_)){
var statearr_21151_21214 = state_21134__$1;
(statearr_21151_21214[(1)] = (8));

} else {
var statearr_21152_21215 = state_21134__$1;
(statearr_21152_21215[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21135 === (14))){
var inst_21112 = (state_21134[(8)]);
var inst_21114 = (state_21134[(11)]);
var inst_21112__$1 = (state_21134[(2)]);
var inst_21113 = (inst_21112__$1 == null);
var inst_21114__$1 = cljs.core.not.call(null,inst_21113);
var state_21134__$1 = (function (){var statearr_21153 = state_21134;
(statearr_21153[(8)] = inst_21112__$1);

(statearr_21153[(11)] = inst_21114__$1);

return statearr_21153;
})();
if(inst_21114__$1){
var statearr_21154_21216 = state_21134__$1;
(statearr_21154_21216[(1)] = (15));

} else {
var statearr_21155_21217 = state_21134__$1;
(statearr_21155_21217[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21135 === (16))){
var inst_21114 = (state_21134[(11)]);
var state_21134__$1 = state_21134;
var statearr_21156_21218 = state_21134__$1;
(statearr_21156_21218[(2)] = inst_21114);

(statearr_21156_21218[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21135 === (10))){
var inst_21106 = (state_21134[(2)]);
var state_21134__$1 = state_21134;
var statearr_21157_21219 = state_21134__$1;
(statearr_21157_21219[(2)] = inst_21106);

(statearr_21157_21219[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21135 === (18))){
var inst_21117 = (state_21134[(2)]);
var state_21134__$1 = state_21134;
var statearr_21158_21220 = state_21134__$1;
(statearr_21158_21220[(2)] = inst_21117);

(statearr_21158_21220[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21135 === (8))){
var inst_21103 = cljs.core.async.close_BANG_.call(null,to);
var state_21134__$1 = state_21134;
var statearr_21159_21221 = state_21134__$1;
(statearr_21159_21221[(2)] = inst_21103);

(statearr_21159_21221[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto__,jobs,results,process,async))
;
return ((function (switch__20505__auto__,c__20617__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____0 = (function (){
var statearr_21163 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21163[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__);

(statearr_21163[(1)] = (1));

return statearr_21163;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____1 = (function (state_21134){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_21134);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e21164){if((e21164 instanceof Object)){
var ex__20509__auto__ = e21164;
var statearr_21165_21222 = state_21134;
(statearr_21165_21222[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21134);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21164;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21223 = state_21134;
state_21134 = G__21223;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__ = function(state_21134){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____1.call(this,state_21134);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20506__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto__,jobs,results,process,async))
})();
var state__20619__auto__ = (function (){var statearr_21166 = f__20618__auto__.call(null);
(statearr_21166[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto__);

return statearr_21166;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto__,jobs,results,process,async))
);

return c__20617__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args21224 = [];
var len__19260__auto___21227 = arguments.length;
var i__19261__auto___21228 = (0);
while(true){
if((i__19261__auto___21228 < len__19260__auto___21227)){
args21224.push((arguments[i__19261__auto___21228]));

var G__21229 = (i__19261__auto___21228 + (1));
i__19261__auto___21228 = G__21229;
continue;
} else {
}
break;
}

var G__21226 = args21224.length;
switch (G__21226) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21224.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args21231 = [];
var len__19260__auto___21234 = arguments.length;
var i__19261__auto___21235 = (0);
while(true){
if((i__19261__auto___21235 < len__19260__auto___21234)){
args21231.push((arguments[i__19261__auto___21235]));

var G__21236 = (i__19261__auto___21235 + (1));
i__19261__auto___21235 = G__21236;
continue;
} else {
}
break;
}

var G__21233 = args21231.length;
switch (G__21233) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21231.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args21238 = [];
var len__19260__auto___21291 = arguments.length;
var i__19261__auto___21292 = (0);
while(true){
if((i__19261__auto___21292 < len__19260__auto___21291)){
args21238.push((arguments[i__19261__auto___21292]));

var G__21293 = (i__19261__auto___21292 + (1));
i__19261__auto___21292 = G__21293;
continue;
} else {
}
break;
}

var G__21240 = args21238.length;
switch (G__21240) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21238.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__20617__auto___21295 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto___21295,tc,fc){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto___21295,tc,fc){
return (function (state_21266){
var state_val_21267 = (state_21266[(1)]);
if((state_val_21267 === (7))){
var inst_21262 = (state_21266[(2)]);
var state_21266__$1 = state_21266;
var statearr_21268_21296 = state_21266__$1;
(statearr_21268_21296[(2)] = inst_21262);

(statearr_21268_21296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21267 === (1))){
var state_21266__$1 = state_21266;
var statearr_21269_21297 = state_21266__$1;
(statearr_21269_21297[(2)] = null);

(statearr_21269_21297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21267 === (4))){
var inst_21243 = (state_21266[(7)]);
var inst_21243__$1 = (state_21266[(2)]);
var inst_21244 = (inst_21243__$1 == null);
var state_21266__$1 = (function (){var statearr_21270 = state_21266;
(statearr_21270[(7)] = inst_21243__$1);

return statearr_21270;
})();
if(cljs.core.truth_(inst_21244)){
var statearr_21271_21298 = state_21266__$1;
(statearr_21271_21298[(1)] = (5));

} else {
var statearr_21272_21299 = state_21266__$1;
(statearr_21272_21299[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21267 === (13))){
var state_21266__$1 = state_21266;
var statearr_21273_21300 = state_21266__$1;
(statearr_21273_21300[(2)] = null);

(statearr_21273_21300[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21267 === (6))){
var inst_21243 = (state_21266[(7)]);
var inst_21249 = p.call(null,inst_21243);
var state_21266__$1 = state_21266;
if(cljs.core.truth_(inst_21249)){
var statearr_21274_21301 = state_21266__$1;
(statearr_21274_21301[(1)] = (9));

} else {
var statearr_21275_21302 = state_21266__$1;
(statearr_21275_21302[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21267 === (3))){
var inst_21264 = (state_21266[(2)]);
var state_21266__$1 = state_21266;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21266__$1,inst_21264);
} else {
if((state_val_21267 === (12))){
var state_21266__$1 = state_21266;
var statearr_21276_21303 = state_21266__$1;
(statearr_21276_21303[(2)] = null);

(statearr_21276_21303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21267 === (2))){
var state_21266__$1 = state_21266;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21266__$1,(4),ch);
} else {
if((state_val_21267 === (11))){
var inst_21243 = (state_21266[(7)]);
var inst_21253 = (state_21266[(2)]);
var state_21266__$1 = state_21266;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21266__$1,(8),inst_21253,inst_21243);
} else {
if((state_val_21267 === (9))){
var state_21266__$1 = state_21266;
var statearr_21277_21304 = state_21266__$1;
(statearr_21277_21304[(2)] = tc);

(statearr_21277_21304[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21267 === (5))){
var inst_21246 = cljs.core.async.close_BANG_.call(null,tc);
var inst_21247 = cljs.core.async.close_BANG_.call(null,fc);
var state_21266__$1 = (function (){var statearr_21278 = state_21266;
(statearr_21278[(8)] = inst_21246);

return statearr_21278;
})();
var statearr_21279_21305 = state_21266__$1;
(statearr_21279_21305[(2)] = inst_21247);

(statearr_21279_21305[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21267 === (14))){
var inst_21260 = (state_21266[(2)]);
var state_21266__$1 = state_21266;
var statearr_21280_21306 = state_21266__$1;
(statearr_21280_21306[(2)] = inst_21260);

(statearr_21280_21306[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21267 === (10))){
var state_21266__$1 = state_21266;
var statearr_21281_21307 = state_21266__$1;
(statearr_21281_21307[(2)] = fc);

(statearr_21281_21307[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21267 === (8))){
var inst_21255 = (state_21266[(2)]);
var state_21266__$1 = state_21266;
if(cljs.core.truth_(inst_21255)){
var statearr_21282_21308 = state_21266__$1;
(statearr_21282_21308[(1)] = (12));

} else {
var statearr_21283_21309 = state_21266__$1;
(statearr_21283_21309[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto___21295,tc,fc))
;
return ((function (switch__20505__auto__,c__20617__auto___21295,tc,fc){
return (function() {
var cljs$core$async$state_machine__20506__auto__ = null;
var cljs$core$async$state_machine__20506__auto____0 = (function (){
var statearr_21287 = [null,null,null,null,null,null,null,null,null];
(statearr_21287[(0)] = cljs$core$async$state_machine__20506__auto__);

(statearr_21287[(1)] = (1));

return statearr_21287;
});
var cljs$core$async$state_machine__20506__auto____1 = (function (state_21266){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_21266);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e21288){if((e21288 instanceof Object)){
var ex__20509__auto__ = e21288;
var statearr_21289_21310 = state_21266;
(statearr_21289_21310[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21266);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21288;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21311 = state_21266;
state_21266 = G__21311;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$state_machine__20506__auto__ = function(state_21266){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20506__auto____1.call(this,state_21266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20506__auto____0;
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20506__auto____1;
return cljs$core$async$state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto___21295,tc,fc))
})();
var state__20619__auto__ = (function (){var statearr_21290 = f__20618__auto__.call(null);
(statearr_21290[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto___21295);

return statearr_21290;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto___21295,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__20617__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto__){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto__){
return (function (state_21375){
var state_val_21376 = (state_21375[(1)]);
if((state_val_21376 === (7))){
var inst_21371 = (state_21375[(2)]);
var state_21375__$1 = state_21375;
var statearr_21377_21398 = state_21375__$1;
(statearr_21377_21398[(2)] = inst_21371);

(statearr_21377_21398[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21376 === (1))){
var inst_21355 = init;
var state_21375__$1 = (function (){var statearr_21378 = state_21375;
(statearr_21378[(7)] = inst_21355);

return statearr_21378;
})();
var statearr_21379_21399 = state_21375__$1;
(statearr_21379_21399[(2)] = null);

(statearr_21379_21399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21376 === (4))){
var inst_21358 = (state_21375[(8)]);
var inst_21358__$1 = (state_21375[(2)]);
var inst_21359 = (inst_21358__$1 == null);
var state_21375__$1 = (function (){var statearr_21380 = state_21375;
(statearr_21380[(8)] = inst_21358__$1);

return statearr_21380;
})();
if(cljs.core.truth_(inst_21359)){
var statearr_21381_21400 = state_21375__$1;
(statearr_21381_21400[(1)] = (5));

} else {
var statearr_21382_21401 = state_21375__$1;
(statearr_21382_21401[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21376 === (6))){
var inst_21358 = (state_21375[(8)]);
var inst_21362 = (state_21375[(9)]);
var inst_21355 = (state_21375[(7)]);
var inst_21362__$1 = f.call(null,inst_21355,inst_21358);
var inst_21363 = cljs.core.reduced_QMARK_.call(null,inst_21362__$1);
var state_21375__$1 = (function (){var statearr_21383 = state_21375;
(statearr_21383[(9)] = inst_21362__$1);

return statearr_21383;
})();
if(inst_21363){
var statearr_21384_21402 = state_21375__$1;
(statearr_21384_21402[(1)] = (8));

} else {
var statearr_21385_21403 = state_21375__$1;
(statearr_21385_21403[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21376 === (3))){
var inst_21373 = (state_21375[(2)]);
var state_21375__$1 = state_21375;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21375__$1,inst_21373);
} else {
if((state_val_21376 === (2))){
var state_21375__$1 = state_21375;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21375__$1,(4),ch);
} else {
if((state_val_21376 === (9))){
var inst_21362 = (state_21375[(9)]);
var inst_21355 = inst_21362;
var state_21375__$1 = (function (){var statearr_21386 = state_21375;
(statearr_21386[(7)] = inst_21355);

return statearr_21386;
})();
var statearr_21387_21404 = state_21375__$1;
(statearr_21387_21404[(2)] = null);

(statearr_21387_21404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21376 === (5))){
var inst_21355 = (state_21375[(7)]);
var state_21375__$1 = state_21375;
var statearr_21388_21405 = state_21375__$1;
(statearr_21388_21405[(2)] = inst_21355);

(statearr_21388_21405[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21376 === (10))){
var inst_21369 = (state_21375[(2)]);
var state_21375__$1 = state_21375;
var statearr_21389_21406 = state_21375__$1;
(statearr_21389_21406[(2)] = inst_21369);

(statearr_21389_21406[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21376 === (8))){
var inst_21362 = (state_21375[(9)]);
var inst_21365 = cljs.core.deref.call(null,inst_21362);
var state_21375__$1 = state_21375;
var statearr_21390_21407 = state_21375__$1;
(statearr_21390_21407[(2)] = inst_21365);

(statearr_21390_21407[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto__))
;
return ((function (switch__20505__auto__,c__20617__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__20506__auto__ = null;
var cljs$core$async$reduce_$_state_machine__20506__auto____0 = (function (){
var statearr_21394 = [null,null,null,null,null,null,null,null,null,null];
(statearr_21394[(0)] = cljs$core$async$reduce_$_state_machine__20506__auto__);

(statearr_21394[(1)] = (1));

return statearr_21394;
});
var cljs$core$async$reduce_$_state_machine__20506__auto____1 = (function (state_21375){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_21375);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e21395){if((e21395 instanceof Object)){
var ex__20509__auto__ = e21395;
var statearr_21396_21408 = state_21375;
(statearr_21396_21408[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21375);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21395;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21409 = state_21375;
state_21375 = G__21409;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__20506__auto__ = function(state_21375){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__20506__auto____1.call(this,state_21375);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__20506__auto____0;
cljs$core$async$reduce_$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__20506__auto____1;
return cljs$core$async$reduce_$_state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto__))
})();
var state__20619__auto__ = (function (){var statearr_21397 = f__20618__auto__.call(null);
(statearr_21397[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto__);

return statearr_21397;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto__))
);

return c__20617__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args21410 = [];
var len__19260__auto___21462 = arguments.length;
var i__19261__auto___21463 = (0);
while(true){
if((i__19261__auto___21463 < len__19260__auto___21462)){
args21410.push((arguments[i__19261__auto___21463]));

var G__21464 = (i__19261__auto___21463 + (1));
i__19261__auto___21463 = G__21464;
continue;
} else {
}
break;
}

var G__21412 = args21410.length;
switch (G__21412) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21410.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__20617__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto__){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto__){
return (function (state_21437){
var state_val_21438 = (state_21437[(1)]);
if((state_val_21438 === (7))){
var inst_21419 = (state_21437[(2)]);
var state_21437__$1 = state_21437;
var statearr_21439_21466 = state_21437__$1;
(statearr_21439_21466[(2)] = inst_21419);

(statearr_21439_21466[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21438 === (1))){
var inst_21413 = cljs.core.seq.call(null,coll);
var inst_21414 = inst_21413;
var state_21437__$1 = (function (){var statearr_21440 = state_21437;
(statearr_21440[(7)] = inst_21414);

return statearr_21440;
})();
var statearr_21441_21467 = state_21437__$1;
(statearr_21441_21467[(2)] = null);

(statearr_21441_21467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21438 === (4))){
var inst_21414 = (state_21437[(7)]);
var inst_21417 = cljs.core.first.call(null,inst_21414);
var state_21437__$1 = state_21437;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21437__$1,(7),ch,inst_21417);
} else {
if((state_val_21438 === (13))){
var inst_21431 = (state_21437[(2)]);
var state_21437__$1 = state_21437;
var statearr_21442_21468 = state_21437__$1;
(statearr_21442_21468[(2)] = inst_21431);

(statearr_21442_21468[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21438 === (6))){
var inst_21422 = (state_21437[(2)]);
var state_21437__$1 = state_21437;
if(cljs.core.truth_(inst_21422)){
var statearr_21443_21469 = state_21437__$1;
(statearr_21443_21469[(1)] = (8));

} else {
var statearr_21444_21470 = state_21437__$1;
(statearr_21444_21470[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21438 === (3))){
var inst_21435 = (state_21437[(2)]);
var state_21437__$1 = state_21437;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21437__$1,inst_21435);
} else {
if((state_val_21438 === (12))){
var state_21437__$1 = state_21437;
var statearr_21445_21471 = state_21437__$1;
(statearr_21445_21471[(2)] = null);

(statearr_21445_21471[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21438 === (2))){
var inst_21414 = (state_21437[(7)]);
var state_21437__$1 = state_21437;
if(cljs.core.truth_(inst_21414)){
var statearr_21446_21472 = state_21437__$1;
(statearr_21446_21472[(1)] = (4));

} else {
var statearr_21447_21473 = state_21437__$1;
(statearr_21447_21473[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21438 === (11))){
var inst_21428 = cljs.core.async.close_BANG_.call(null,ch);
var state_21437__$1 = state_21437;
var statearr_21448_21474 = state_21437__$1;
(statearr_21448_21474[(2)] = inst_21428);

(statearr_21448_21474[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21438 === (9))){
var state_21437__$1 = state_21437;
if(cljs.core.truth_(close_QMARK_)){
var statearr_21449_21475 = state_21437__$1;
(statearr_21449_21475[(1)] = (11));

} else {
var statearr_21450_21476 = state_21437__$1;
(statearr_21450_21476[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21438 === (5))){
var inst_21414 = (state_21437[(7)]);
var state_21437__$1 = state_21437;
var statearr_21451_21477 = state_21437__$1;
(statearr_21451_21477[(2)] = inst_21414);

(statearr_21451_21477[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21438 === (10))){
var inst_21433 = (state_21437[(2)]);
var state_21437__$1 = state_21437;
var statearr_21452_21478 = state_21437__$1;
(statearr_21452_21478[(2)] = inst_21433);

(statearr_21452_21478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21438 === (8))){
var inst_21414 = (state_21437[(7)]);
var inst_21424 = cljs.core.next.call(null,inst_21414);
var inst_21414__$1 = inst_21424;
var state_21437__$1 = (function (){var statearr_21453 = state_21437;
(statearr_21453[(7)] = inst_21414__$1);

return statearr_21453;
})();
var statearr_21454_21479 = state_21437__$1;
(statearr_21454_21479[(2)] = null);

(statearr_21454_21479[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto__))
;
return ((function (switch__20505__auto__,c__20617__auto__){
return (function() {
var cljs$core$async$state_machine__20506__auto__ = null;
var cljs$core$async$state_machine__20506__auto____0 = (function (){
var statearr_21458 = [null,null,null,null,null,null,null,null];
(statearr_21458[(0)] = cljs$core$async$state_machine__20506__auto__);

(statearr_21458[(1)] = (1));

return statearr_21458;
});
var cljs$core$async$state_machine__20506__auto____1 = (function (state_21437){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_21437);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e21459){if((e21459 instanceof Object)){
var ex__20509__auto__ = e21459;
var statearr_21460_21480 = state_21437;
(statearr_21460_21480[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21437);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21459;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21481 = state_21437;
state_21437 = G__21481;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$state_machine__20506__auto__ = function(state_21437){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20506__auto____1.call(this,state_21437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20506__auto____0;
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20506__auto____1;
return cljs$core$async$state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto__))
})();
var state__20619__auto__ = (function (){var statearr_21461 = f__20618__auto__.call(null);
(statearr_21461[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto__);

return statearr_21461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto__))
);

return c__20617__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__18857__auto__ = (((_ == null))?null:_);
var m__18858__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,_);
} else {
var m__18858__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__18857__auto__ = (((m == null))?null:m);
var m__18858__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__18858__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__18857__auto__ = (((m == null))?null:m);
var m__18858__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,m,ch);
} else {
var m__18858__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__18857__auto__ = (((m == null))?null:m);
var m__18858__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,m);
} else {
var m__18858__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async21703 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21703 = (function (mult,ch,cs,meta21704){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta21704 = meta21704;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21703.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_21705,meta21704__$1){
var self__ = this;
var _21705__$1 = this;
return (new cljs.core.async.t_cljs$core$async21703(self__.mult,self__.ch,self__.cs,meta21704__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async21703.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_21705){
var self__ = this;
var _21705__$1 = this;
return self__.meta21704;
});})(cs))
;

cljs.core.async.t_cljs$core$async21703.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async21703.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async21703.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async21703.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21703.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21703.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21703.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta21704","meta21704",-1176827702,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async21703.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21703.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21703";

cljs.core.async.t_cljs$core$async21703.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async21703");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async21703 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async21703(mult__$1,ch__$1,cs__$1,meta21704){
return (new cljs.core.async.t_cljs$core$async21703(mult__$1,ch__$1,cs__$1,meta21704));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async21703(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__20617__auto___21924 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto___21924,cs,m,dchan,dctr,done){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto___21924,cs,m,dchan,dctr,done){
return (function (state_21836){
var state_val_21837 = (state_21836[(1)]);
if((state_val_21837 === (7))){
var inst_21832 = (state_21836[(2)]);
var state_21836__$1 = state_21836;
var statearr_21838_21925 = state_21836__$1;
(statearr_21838_21925[(2)] = inst_21832);

(statearr_21838_21925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (20))){
var inst_21737 = (state_21836[(7)]);
var inst_21747 = cljs.core.first.call(null,inst_21737);
var inst_21748 = cljs.core.nth.call(null,inst_21747,(0),null);
var inst_21749 = cljs.core.nth.call(null,inst_21747,(1),null);
var state_21836__$1 = (function (){var statearr_21839 = state_21836;
(statearr_21839[(8)] = inst_21748);

return statearr_21839;
})();
if(cljs.core.truth_(inst_21749)){
var statearr_21840_21926 = state_21836__$1;
(statearr_21840_21926[(1)] = (22));

} else {
var statearr_21841_21927 = state_21836__$1;
(statearr_21841_21927[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (27))){
var inst_21777 = (state_21836[(9)]);
var inst_21784 = (state_21836[(10)]);
var inst_21779 = (state_21836[(11)]);
var inst_21708 = (state_21836[(12)]);
var inst_21784__$1 = cljs.core._nth.call(null,inst_21777,inst_21779);
var inst_21785 = cljs.core.async.put_BANG_.call(null,inst_21784__$1,inst_21708,done);
var state_21836__$1 = (function (){var statearr_21842 = state_21836;
(statearr_21842[(10)] = inst_21784__$1);

return statearr_21842;
})();
if(cljs.core.truth_(inst_21785)){
var statearr_21843_21928 = state_21836__$1;
(statearr_21843_21928[(1)] = (30));

} else {
var statearr_21844_21929 = state_21836__$1;
(statearr_21844_21929[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (1))){
var state_21836__$1 = state_21836;
var statearr_21845_21930 = state_21836__$1;
(statearr_21845_21930[(2)] = null);

(statearr_21845_21930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (24))){
var inst_21737 = (state_21836[(7)]);
var inst_21754 = (state_21836[(2)]);
var inst_21755 = cljs.core.next.call(null,inst_21737);
var inst_21717 = inst_21755;
var inst_21718 = null;
var inst_21719 = (0);
var inst_21720 = (0);
var state_21836__$1 = (function (){var statearr_21846 = state_21836;
(statearr_21846[(13)] = inst_21717);

(statearr_21846[(14)] = inst_21719);

(statearr_21846[(15)] = inst_21718);

(statearr_21846[(16)] = inst_21720);

(statearr_21846[(17)] = inst_21754);

return statearr_21846;
})();
var statearr_21847_21931 = state_21836__$1;
(statearr_21847_21931[(2)] = null);

(statearr_21847_21931[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (39))){
var state_21836__$1 = state_21836;
var statearr_21851_21932 = state_21836__$1;
(statearr_21851_21932[(2)] = null);

(statearr_21851_21932[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (4))){
var inst_21708 = (state_21836[(12)]);
var inst_21708__$1 = (state_21836[(2)]);
var inst_21709 = (inst_21708__$1 == null);
var state_21836__$1 = (function (){var statearr_21852 = state_21836;
(statearr_21852[(12)] = inst_21708__$1);

return statearr_21852;
})();
if(cljs.core.truth_(inst_21709)){
var statearr_21853_21933 = state_21836__$1;
(statearr_21853_21933[(1)] = (5));

} else {
var statearr_21854_21934 = state_21836__$1;
(statearr_21854_21934[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (15))){
var inst_21717 = (state_21836[(13)]);
var inst_21719 = (state_21836[(14)]);
var inst_21718 = (state_21836[(15)]);
var inst_21720 = (state_21836[(16)]);
var inst_21733 = (state_21836[(2)]);
var inst_21734 = (inst_21720 + (1));
var tmp21848 = inst_21717;
var tmp21849 = inst_21719;
var tmp21850 = inst_21718;
var inst_21717__$1 = tmp21848;
var inst_21718__$1 = tmp21850;
var inst_21719__$1 = tmp21849;
var inst_21720__$1 = inst_21734;
var state_21836__$1 = (function (){var statearr_21855 = state_21836;
(statearr_21855[(13)] = inst_21717__$1);

(statearr_21855[(14)] = inst_21719__$1);

(statearr_21855[(15)] = inst_21718__$1);

(statearr_21855[(18)] = inst_21733);

(statearr_21855[(16)] = inst_21720__$1);

return statearr_21855;
})();
var statearr_21856_21935 = state_21836__$1;
(statearr_21856_21935[(2)] = null);

(statearr_21856_21935[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (21))){
var inst_21758 = (state_21836[(2)]);
var state_21836__$1 = state_21836;
var statearr_21860_21936 = state_21836__$1;
(statearr_21860_21936[(2)] = inst_21758);

(statearr_21860_21936[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (31))){
var inst_21784 = (state_21836[(10)]);
var inst_21788 = done.call(null,null);
var inst_21789 = cljs.core.async.untap_STAR_.call(null,m,inst_21784);
var state_21836__$1 = (function (){var statearr_21861 = state_21836;
(statearr_21861[(19)] = inst_21788);

return statearr_21861;
})();
var statearr_21862_21937 = state_21836__$1;
(statearr_21862_21937[(2)] = inst_21789);

(statearr_21862_21937[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (32))){
var inst_21776 = (state_21836[(20)]);
var inst_21777 = (state_21836[(9)]);
var inst_21778 = (state_21836[(21)]);
var inst_21779 = (state_21836[(11)]);
var inst_21791 = (state_21836[(2)]);
var inst_21792 = (inst_21779 + (1));
var tmp21857 = inst_21776;
var tmp21858 = inst_21777;
var tmp21859 = inst_21778;
var inst_21776__$1 = tmp21857;
var inst_21777__$1 = tmp21858;
var inst_21778__$1 = tmp21859;
var inst_21779__$1 = inst_21792;
var state_21836__$1 = (function (){var statearr_21863 = state_21836;
(statearr_21863[(20)] = inst_21776__$1);

(statearr_21863[(9)] = inst_21777__$1);

(statearr_21863[(21)] = inst_21778__$1);

(statearr_21863[(11)] = inst_21779__$1);

(statearr_21863[(22)] = inst_21791);

return statearr_21863;
})();
var statearr_21864_21938 = state_21836__$1;
(statearr_21864_21938[(2)] = null);

(statearr_21864_21938[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (40))){
var inst_21804 = (state_21836[(23)]);
var inst_21808 = done.call(null,null);
var inst_21809 = cljs.core.async.untap_STAR_.call(null,m,inst_21804);
var state_21836__$1 = (function (){var statearr_21865 = state_21836;
(statearr_21865[(24)] = inst_21808);

return statearr_21865;
})();
var statearr_21866_21939 = state_21836__$1;
(statearr_21866_21939[(2)] = inst_21809);

(statearr_21866_21939[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (33))){
var inst_21795 = (state_21836[(25)]);
var inst_21797 = cljs.core.chunked_seq_QMARK_.call(null,inst_21795);
var state_21836__$1 = state_21836;
if(inst_21797){
var statearr_21867_21940 = state_21836__$1;
(statearr_21867_21940[(1)] = (36));

} else {
var statearr_21868_21941 = state_21836__$1;
(statearr_21868_21941[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (13))){
var inst_21727 = (state_21836[(26)]);
var inst_21730 = cljs.core.async.close_BANG_.call(null,inst_21727);
var state_21836__$1 = state_21836;
var statearr_21869_21942 = state_21836__$1;
(statearr_21869_21942[(2)] = inst_21730);

(statearr_21869_21942[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (22))){
var inst_21748 = (state_21836[(8)]);
var inst_21751 = cljs.core.async.close_BANG_.call(null,inst_21748);
var state_21836__$1 = state_21836;
var statearr_21870_21943 = state_21836__$1;
(statearr_21870_21943[(2)] = inst_21751);

(statearr_21870_21943[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (36))){
var inst_21795 = (state_21836[(25)]);
var inst_21799 = cljs.core.chunk_first.call(null,inst_21795);
var inst_21800 = cljs.core.chunk_rest.call(null,inst_21795);
var inst_21801 = cljs.core.count.call(null,inst_21799);
var inst_21776 = inst_21800;
var inst_21777 = inst_21799;
var inst_21778 = inst_21801;
var inst_21779 = (0);
var state_21836__$1 = (function (){var statearr_21871 = state_21836;
(statearr_21871[(20)] = inst_21776);

(statearr_21871[(9)] = inst_21777);

(statearr_21871[(21)] = inst_21778);

(statearr_21871[(11)] = inst_21779);

return statearr_21871;
})();
var statearr_21872_21944 = state_21836__$1;
(statearr_21872_21944[(2)] = null);

(statearr_21872_21944[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (41))){
var inst_21795 = (state_21836[(25)]);
var inst_21811 = (state_21836[(2)]);
var inst_21812 = cljs.core.next.call(null,inst_21795);
var inst_21776 = inst_21812;
var inst_21777 = null;
var inst_21778 = (0);
var inst_21779 = (0);
var state_21836__$1 = (function (){var statearr_21873 = state_21836;
(statearr_21873[(20)] = inst_21776);

(statearr_21873[(9)] = inst_21777);

(statearr_21873[(21)] = inst_21778);

(statearr_21873[(11)] = inst_21779);

(statearr_21873[(27)] = inst_21811);

return statearr_21873;
})();
var statearr_21874_21945 = state_21836__$1;
(statearr_21874_21945[(2)] = null);

(statearr_21874_21945[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (43))){
var state_21836__$1 = state_21836;
var statearr_21875_21946 = state_21836__$1;
(statearr_21875_21946[(2)] = null);

(statearr_21875_21946[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (29))){
var inst_21820 = (state_21836[(2)]);
var state_21836__$1 = state_21836;
var statearr_21876_21947 = state_21836__$1;
(statearr_21876_21947[(2)] = inst_21820);

(statearr_21876_21947[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (44))){
var inst_21829 = (state_21836[(2)]);
var state_21836__$1 = (function (){var statearr_21877 = state_21836;
(statearr_21877[(28)] = inst_21829);

return statearr_21877;
})();
var statearr_21878_21948 = state_21836__$1;
(statearr_21878_21948[(2)] = null);

(statearr_21878_21948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (6))){
var inst_21768 = (state_21836[(29)]);
var inst_21767 = cljs.core.deref.call(null,cs);
var inst_21768__$1 = cljs.core.keys.call(null,inst_21767);
var inst_21769 = cljs.core.count.call(null,inst_21768__$1);
var inst_21770 = cljs.core.reset_BANG_.call(null,dctr,inst_21769);
var inst_21775 = cljs.core.seq.call(null,inst_21768__$1);
var inst_21776 = inst_21775;
var inst_21777 = null;
var inst_21778 = (0);
var inst_21779 = (0);
var state_21836__$1 = (function (){var statearr_21879 = state_21836;
(statearr_21879[(20)] = inst_21776);

(statearr_21879[(9)] = inst_21777);

(statearr_21879[(21)] = inst_21778);

(statearr_21879[(11)] = inst_21779);

(statearr_21879[(30)] = inst_21770);

(statearr_21879[(29)] = inst_21768__$1);

return statearr_21879;
})();
var statearr_21880_21949 = state_21836__$1;
(statearr_21880_21949[(2)] = null);

(statearr_21880_21949[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (28))){
var inst_21776 = (state_21836[(20)]);
var inst_21795 = (state_21836[(25)]);
var inst_21795__$1 = cljs.core.seq.call(null,inst_21776);
var state_21836__$1 = (function (){var statearr_21881 = state_21836;
(statearr_21881[(25)] = inst_21795__$1);

return statearr_21881;
})();
if(inst_21795__$1){
var statearr_21882_21950 = state_21836__$1;
(statearr_21882_21950[(1)] = (33));

} else {
var statearr_21883_21951 = state_21836__$1;
(statearr_21883_21951[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (25))){
var inst_21778 = (state_21836[(21)]);
var inst_21779 = (state_21836[(11)]);
var inst_21781 = (inst_21779 < inst_21778);
var inst_21782 = inst_21781;
var state_21836__$1 = state_21836;
if(cljs.core.truth_(inst_21782)){
var statearr_21884_21952 = state_21836__$1;
(statearr_21884_21952[(1)] = (27));

} else {
var statearr_21885_21953 = state_21836__$1;
(statearr_21885_21953[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (34))){
var state_21836__$1 = state_21836;
var statearr_21886_21954 = state_21836__$1;
(statearr_21886_21954[(2)] = null);

(statearr_21886_21954[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (17))){
var state_21836__$1 = state_21836;
var statearr_21887_21955 = state_21836__$1;
(statearr_21887_21955[(2)] = null);

(statearr_21887_21955[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (3))){
var inst_21834 = (state_21836[(2)]);
var state_21836__$1 = state_21836;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21836__$1,inst_21834);
} else {
if((state_val_21837 === (12))){
var inst_21763 = (state_21836[(2)]);
var state_21836__$1 = state_21836;
var statearr_21888_21956 = state_21836__$1;
(statearr_21888_21956[(2)] = inst_21763);

(statearr_21888_21956[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (2))){
var state_21836__$1 = state_21836;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21836__$1,(4),ch);
} else {
if((state_val_21837 === (23))){
var state_21836__$1 = state_21836;
var statearr_21889_21957 = state_21836__$1;
(statearr_21889_21957[(2)] = null);

(statearr_21889_21957[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (35))){
var inst_21818 = (state_21836[(2)]);
var state_21836__$1 = state_21836;
var statearr_21890_21958 = state_21836__$1;
(statearr_21890_21958[(2)] = inst_21818);

(statearr_21890_21958[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (19))){
var inst_21737 = (state_21836[(7)]);
var inst_21741 = cljs.core.chunk_first.call(null,inst_21737);
var inst_21742 = cljs.core.chunk_rest.call(null,inst_21737);
var inst_21743 = cljs.core.count.call(null,inst_21741);
var inst_21717 = inst_21742;
var inst_21718 = inst_21741;
var inst_21719 = inst_21743;
var inst_21720 = (0);
var state_21836__$1 = (function (){var statearr_21891 = state_21836;
(statearr_21891[(13)] = inst_21717);

(statearr_21891[(14)] = inst_21719);

(statearr_21891[(15)] = inst_21718);

(statearr_21891[(16)] = inst_21720);

return statearr_21891;
})();
var statearr_21892_21959 = state_21836__$1;
(statearr_21892_21959[(2)] = null);

(statearr_21892_21959[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (11))){
var inst_21717 = (state_21836[(13)]);
var inst_21737 = (state_21836[(7)]);
var inst_21737__$1 = cljs.core.seq.call(null,inst_21717);
var state_21836__$1 = (function (){var statearr_21893 = state_21836;
(statearr_21893[(7)] = inst_21737__$1);

return statearr_21893;
})();
if(inst_21737__$1){
var statearr_21894_21960 = state_21836__$1;
(statearr_21894_21960[(1)] = (16));

} else {
var statearr_21895_21961 = state_21836__$1;
(statearr_21895_21961[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (9))){
var inst_21765 = (state_21836[(2)]);
var state_21836__$1 = state_21836;
var statearr_21896_21962 = state_21836__$1;
(statearr_21896_21962[(2)] = inst_21765);

(statearr_21896_21962[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (5))){
var inst_21715 = cljs.core.deref.call(null,cs);
var inst_21716 = cljs.core.seq.call(null,inst_21715);
var inst_21717 = inst_21716;
var inst_21718 = null;
var inst_21719 = (0);
var inst_21720 = (0);
var state_21836__$1 = (function (){var statearr_21897 = state_21836;
(statearr_21897[(13)] = inst_21717);

(statearr_21897[(14)] = inst_21719);

(statearr_21897[(15)] = inst_21718);

(statearr_21897[(16)] = inst_21720);

return statearr_21897;
})();
var statearr_21898_21963 = state_21836__$1;
(statearr_21898_21963[(2)] = null);

(statearr_21898_21963[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (14))){
var state_21836__$1 = state_21836;
var statearr_21899_21964 = state_21836__$1;
(statearr_21899_21964[(2)] = null);

(statearr_21899_21964[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (45))){
var inst_21826 = (state_21836[(2)]);
var state_21836__$1 = state_21836;
var statearr_21900_21965 = state_21836__$1;
(statearr_21900_21965[(2)] = inst_21826);

(statearr_21900_21965[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (26))){
var inst_21768 = (state_21836[(29)]);
var inst_21822 = (state_21836[(2)]);
var inst_21823 = cljs.core.seq.call(null,inst_21768);
var state_21836__$1 = (function (){var statearr_21901 = state_21836;
(statearr_21901[(31)] = inst_21822);

return statearr_21901;
})();
if(inst_21823){
var statearr_21902_21966 = state_21836__$1;
(statearr_21902_21966[(1)] = (42));

} else {
var statearr_21903_21967 = state_21836__$1;
(statearr_21903_21967[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (16))){
var inst_21737 = (state_21836[(7)]);
var inst_21739 = cljs.core.chunked_seq_QMARK_.call(null,inst_21737);
var state_21836__$1 = state_21836;
if(inst_21739){
var statearr_21904_21968 = state_21836__$1;
(statearr_21904_21968[(1)] = (19));

} else {
var statearr_21905_21969 = state_21836__$1;
(statearr_21905_21969[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (38))){
var inst_21815 = (state_21836[(2)]);
var state_21836__$1 = state_21836;
var statearr_21906_21970 = state_21836__$1;
(statearr_21906_21970[(2)] = inst_21815);

(statearr_21906_21970[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (30))){
var state_21836__$1 = state_21836;
var statearr_21907_21971 = state_21836__$1;
(statearr_21907_21971[(2)] = null);

(statearr_21907_21971[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (10))){
var inst_21718 = (state_21836[(15)]);
var inst_21720 = (state_21836[(16)]);
var inst_21726 = cljs.core._nth.call(null,inst_21718,inst_21720);
var inst_21727 = cljs.core.nth.call(null,inst_21726,(0),null);
var inst_21728 = cljs.core.nth.call(null,inst_21726,(1),null);
var state_21836__$1 = (function (){var statearr_21908 = state_21836;
(statearr_21908[(26)] = inst_21727);

return statearr_21908;
})();
if(cljs.core.truth_(inst_21728)){
var statearr_21909_21972 = state_21836__$1;
(statearr_21909_21972[(1)] = (13));

} else {
var statearr_21910_21973 = state_21836__$1;
(statearr_21910_21973[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (18))){
var inst_21761 = (state_21836[(2)]);
var state_21836__$1 = state_21836;
var statearr_21911_21974 = state_21836__$1;
(statearr_21911_21974[(2)] = inst_21761);

(statearr_21911_21974[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (42))){
var state_21836__$1 = state_21836;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21836__$1,(45),dchan);
} else {
if((state_val_21837 === (37))){
var inst_21795 = (state_21836[(25)]);
var inst_21708 = (state_21836[(12)]);
var inst_21804 = (state_21836[(23)]);
var inst_21804__$1 = cljs.core.first.call(null,inst_21795);
var inst_21805 = cljs.core.async.put_BANG_.call(null,inst_21804__$1,inst_21708,done);
var state_21836__$1 = (function (){var statearr_21912 = state_21836;
(statearr_21912[(23)] = inst_21804__$1);

return statearr_21912;
})();
if(cljs.core.truth_(inst_21805)){
var statearr_21913_21975 = state_21836__$1;
(statearr_21913_21975[(1)] = (39));

} else {
var statearr_21914_21976 = state_21836__$1;
(statearr_21914_21976[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21837 === (8))){
var inst_21719 = (state_21836[(14)]);
var inst_21720 = (state_21836[(16)]);
var inst_21722 = (inst_21720 < inst_21719);
var inst_21723 = inst_21722;
var state_21836__$1 = state_21836;
if(cljs.core.truth_(inst_21723)){
var statearr_21915_21977 = state_21836__$1;
(statearr_21915_21977[(1)] = (10));

} else {
var statearr_21916_21978 = state_21836__$1;
(statearr_21916_21978[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto___21924,cs,m,dchan,dctr,done))
;
return ((function (switch__20505__auto__,c__20617__auto___21924,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__20506__auto__ = null;
var cljs$core$async$mult_$_state_machine__20506__auto____0 = (function (){
var statearr_21920 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21920[(0)] = cljs$core$async$mult_$_state_machine__20506__auto__);

(statearr_21920[(1)] = (1));

return statearr_21920;
});
var cljs$core$async$mult_$_state_machine__20506__auto____1 = (function (state_21836){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_21836);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e21921){if((e21921 instanceof Object)){
var ex__20509__auto__ = e21921;
var statearr_21922_21979 = state_21836;
(statearr_21922_21979[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21836);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21921;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21980 = state_21836;
state_21836 = G__21980;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__20506__auto__ = function(state_21836){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__20506__auto____1.call(this,state_21836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__20506__auto____0;
cljs$core$async$mult_$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__20506__auto____1;
return cljs$core$async$mult_$_state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto___21924,cs,m,dchan,dctr,done))
})();
var state__20619__auto__ = (function (){var statearr_21923 = f__20618__auto__.call(null);
(statearr_21923[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto___21924);

return statearr_21923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto___21924,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args21981 = [];
var len__19260__auto___21984 = arguments.length;
var i__19261__auto___21985 = (0);
while(true){
if((i__19261__auto___21985 < len__19260__auto___21984)){
args21981.push((arguments[i__19261__auto___21985]));

var G__21986 = (i__19261__auto___21985 + (1));
i__19261__auto___21985 = G__21986;
continue;
} else {
}
break;
}

var G__21983 = args21981.length;
switch (G__21983) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21981.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__18857__auto__ = (((m == null))?null:m);
var m__18858__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,m,ch);
} else {
var m__18858__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__18857__auto__ = (((m == null))?null:m);
var m__18858__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,m,ch);
} else {
var m__18858__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__18857__auto__ = (((m == null))?null:m);
var m__18858__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,m);
} else {
var m__18858__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__18857__auto__ = (((m == null))?null:m);
var m__18858__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,m,state_map);
} else {
var m__18858__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__18857__auto__ = (((m == null))?null:m);
var m__18858__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,m,mode);
} else {
var m__18858__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__19267__auto__ = [];
var len__19260__auto___21998 = arguments.length;
var i__19261__auto___21999 = (0);
while(true){
if((i__19261__auto___21999 < len__19260__auto___21998)){
args__19267__auto__.push((arguments[i__19261__auto___21999]));

var G__22000 = (i__19261__auto___21999 + (1));
i__19261__auto___21999 = G__22000;
continue;
} else {
}
break;
}

var argseq__19268__auto__ = ((((3) < args__19267__auto__.length))?(new cljs.core.IndexedSeq(args__19267__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__19268__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__21992){
var map__21993 = p__21992;
var map__21993__$1 = ((((!((map__21993 == null)))?((((map__21993.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21993.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21993):map__21993);
var opts = map__21993__$1;
var statearr_21995_22001 = state;
(statearr_21995_22001[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__21993,map__21993__$1,opts){
return (function (val){
var statearr_21996_22002 = state;
(statearr_21996_22002[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__21993,map__21993__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_21997_22003 = state;
(statearr_21997_22003[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq21988){
var G__21989 = cljs.core.first.call(null,seq21988);
var seq21988__$1 = cljs.core.next.call(null,seq21988);
var G__21990 = cljs.core.first.call(null,seq21988__$1);
var seq21988__$2 = cljs.core.next.call(null,seq21988__$1);
var G__21991 = cljs.core.first.call(null,seq21988__$2);
var seq21988__$3 = cljs.core.next.call(null,seq21988__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21989,G__21990,G__21991,seq21988__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async22167 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22167 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta22168){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta22168 = meta22168;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22167.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_22169,meta22168__$1){
var self__ = this;
var _22169__$1 = this;
return (new cljs.core.async.t_cljs$core$async22167(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta22168__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22167.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_22169){
var self__ = this;
var _22169__$1 = this;
return self__.meta22168;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22167.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async22167.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22167.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async22167.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22167.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22167.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22167.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22167.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22167.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta22168","meta22168",-1456987031,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async22167.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22167.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22167";

cljs.core.async.t_cljs$core$async22167.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async22167");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async22167 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async22167(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta22168){
return (new cljs.core.async.t_cljs$core$async22167(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta22168));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async22167(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20617__auto___22330 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto___22330,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto___22330,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_22267){
var state_val_22268 = (state_22267[(1)]);
if((state_val_22268 === (7))){
var inst_22185 = (state_22267[(2)]);
var state_22267__$1 = state_22267;
var statearr_22269_22331 = state_22267__$1;
(statearr_22269_22331[(2)] = inst_22185);

(statearr_22269_22331[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (20))){
var inst_22197 = (state_22267[(7)]);
var state_22267__$1 = state_22267;
var statearr_22270_22332 = state_22267__$1;
(statearr_22270_22332[(2)] = inst_22197);

(statearr_22270_22332[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (27))){
var state_22267__$1 = state_22267;
var statearr_22271_22333 = state_22267__$1;
(statearr_22271_22333[(2)] = null);

(statearr_22271_22333[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (1))){
var inst_22173 = (state_22267[(8)]);
var inst_22173__$1 = calc_state.call(null);
var inst_22175 = (inst_22173__$1 == null);
var inst_22176 = cljs.core.not.call(null,inst_22175);
var state_22267__$1 = (function (){var statearr_22272 = state_22267;
(statearr_22272[(8)] = inst_22173__$1);

return statearr_22272;
})();
if(inst_22176){
var statearr_22273_22334 = state_22267__$1;
(statearr_22273_22334[(1)] = (2));

} else {
var statearr_22274_22335 = state_22267__$1;
(statearr_22274_22335[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (24))){
var inst_22227 = (state_22267[(9)]);
var inst_22241 = (state_22267[(10)]);
var inst_22220 = (state_22267[(11)]);
var inst_22241__$1 = inst_22220.call(null,inst_22227);
var state_22267__$1 = (function (){var statearr_22275 = state_22267;
(statearr_22275[(10)] = inst_22241__$1);

return statearr_22275;
})();
if(cljs.core.truth_(inst_22241__$1)){
var statearr_22276_22336 = state_22267__$1;
(statearr_22276_22336[(1)] = (29));

} else {
var statearr_22277_22337 = state_22267__$1;
(statearr_22277_22337[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (4))){
var inst_22188 = (state_22267[(2)]);
var state_22267__$1 = state_22267;
if(cljs.core.truth_(inst_22188)){
var statearr_22278_22338 = state_22267__$1;
(statearr_22278_22338[(1)] = (8));

} else {
var statearr_22279_22339 = state_22267__$1;
(statearr_22279_22339[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (15))){
var inst_22214 = (state_22267[(2)]);
var state_22267__$1 = state_22267;
if(cljs.core.truth_(inst_22214)){
var statearr_22280_22340 = state_22267__$1;
(statearr_22280_22340[(1)] = (19));

} else {
var statearr_22281_22341 = state_22267__$1;
(statearr_22281_22341[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (21))){
var inst_22219 = (state_22267[(12)]);
var inst_22219__$1 = (state_22267[(2)]);
var inst_22220 = cljs.core.get.call(null,inst_22219__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_22221 = cljs.core.get.call(null,inst_22219__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_22222 = cljs.core.get.call(null,inst_22219__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_22267__$1 = (function (){var statearr_22282 = state_22267;
(statearr_22282[(13)] = inst_22221);

(statearr_22282[(12)] = inst_22219__$1);

(statearr_22282[(11)] = inst_22220);

return statearr_22282;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_22267__$1,(22),inst_22222);
} else {
if((state_val_22268 === (31))){
var inst_22249 = (state_22267[(2)]);
var state_22267__$1 = state_22267;
if(cljs.core.truth_(inst_22249)){
var statearr_22283_22342 = state_22267__$1;
(statearr_22283_22342[(1)] = (32));

} else {
var statearr_22284_22343 = state_22267__$1;
(statearr_22284_22343[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (32))){
var inst_22226 = (state_22267[(14)]);
var state_22267__$1 = state_22267;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22267__$1,(35),out,inst_22226);
} else {
if((state_val_22268 === (33))){
var inst_22219 = (state_22267[(12)]);
var inst_22197 = inst_22219;
var state_22267__$1 = (function (){var statearr_22285 = state_22267;
(statearr_22285[(7)] = inst_22197);

return statearr_22285;
})();
var statearr_22286_22344 = state_22267__$1;
(statearr_22286_22344[(2)] = null);

(statearr_22286_22344[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (13))){
var inst_22197 = (state_22267[(7)]);
var inst_22204 = inst_22197.cljs$lang$protocol_mask$partition0$;
var inst_22205 = (inst_22204 & (64));
var inst_22206 = inst_22197.cljs$core$ISeq$;
var inst_22207 = (inst_22205) || (inst_22206);
var state_22267__$1 = state_22267;
if(cljs.core.truth_(inst_22207)){
var statearr_22287_22345 = state_22267__$1;
(statearr_22287_22345[(1)] = (16));

} else {
var statearr_22288_22346 = state_22267__$1;
(statearr_22288_22346[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (22))){
var inst_22227 = (state_22267[(9)]);
var inst_22226 = (state_22267[(14)]);
var inst_22225 = (state_22267[(2)]);
var inst_22226__$1 = cljs.core.nth.call(null,inst_22225,(0),null);
var inst_22227__$1 = cljs.core.nth.call(null,inst_22225,(1),null);
var inst_22228 = (inst_22226__$1 == null);
var inst_22229 = cljs.core._EQ_.call(null,inst_22227__$1,change);
var inst_22230 = (inst_22228) || (inst_22229);
var state_22267__$1 = (function (){var statearr_22289 = state_22267;
(statearr_22289[(9)] = inst_22227__$1);

(statearr_22289[(14)] = inst_22226__$1);

return statearr_22289;
})();
if(cljs.core.truth_(inst_22230)){
var statearr_22290_22347 = state_22267__$1;
(statearr_22290_22347[(1)] = (23));

} else {
var statearr_22291_22348 = state_22267__$1;
(statearr_22291_22348[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (36))){
var inst_22219 = (state_22267[(12)]);
var inst_22197 = inst_22219;
var state_22267__$1 = (function (){var statearr_22292 = state_22267;
(statearr_22292[(7)] = inst_22197);

return statearr_22292;
})();
var statearr_22293_22349 = state_22267__$1;
(statearr_22293_22349[(2)] = null);

(statearr_22293_22349[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (29))){
var inst_22241 = (state_22267[(10)]);
var state_22267__$1 = state_22267;
var statearr_22294_22350 = state_22267__$1;
(statearr_22294_22350[(2)] = inst_22241);

(statearr_22294_22350[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (6))){
var state_22267__$1 = state_22267;
var statearr_22295_22351 = state_22267__$1;
(statearr_22295_22351[(2)] = false);

(statearr_22295_22351[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (28))){
var inst_22237 = (state_22267[(2)]);
var inst_22238 = calc_state.call(null);
var inst_22197 = inst_22238;
var state_22267__$1 = (function (){var statearr_22296 = state_22267;
(statearr_22296[(15)] = inst_22237);

(statearr_22296[(7)] = inst_22197);

return statearr_22296;
})();
var statearr_22297_22352 = state_22267__$1;
(statearr_22297_22352[(2)] = null);

(statearr_22297_22352[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (25))){
var inst_22263 = (state_22267[(2)]);
var state_22267__$1 = state_22267;
var statearr_22298_22353 = state_22267__$1;
(statearr_22298_22353[(2)] = inst_22263);

(statearr_22298_22353[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (34))){
var inst_22261 = (state_22267[(2)]);
var state_22267__$1 = state_22267;
var statearr_22299_22354 = state_22267__$1;
(statearr_22299_22354[(2)] = inst_22261);

(statearr_22299_22354[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (17))){
var state_22267__$1 = state_22267;
var statearr_22300_22355 = state_22267__$1;
(statearr_22300_22355[(2)] = false);

(statearr_22300_22355[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (3))){
var state_22267__$1 = state_22267;
var statearr_22301_22356 = state_22267__$1;
(statearr_22301_22356[(2)] = false);

(statearr_22301_22356[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (12))){
var inst_22265 = (state_22267[(2)]);
var state_22267__$1 = state_22267;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22267__$1,inst_22265);
} else {
if((state_val_22268 === (2))){
var inst_22173 = (state_22267[(8)]);
var inst_22178 = inst_22173.cljs$lang$protocol_mask$partition0$;
var inst_22179 = (inst_22178 & (64));
var inst_22180 = inst_22173.cljs$core$ISeq$;
var inst_22181 = (inst_22179) || (inst_22180);
var state_22267__$1 = state_22267;
if(cljs.core.truth_(inst_22181)){
var statearr_22302_22357 = state_22267__$1;
(statearr_22302_22357[(1)] = (5));

} else {
var statearr_22303_22358 = state_22267__$1;
(statearr_22303_22358[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (23))){
var inst_22226 = (state_22267[(14)]);
var inst_22232 = (inst_22226 == null);
var state_22267__$1 = state_22267;
if(cljs.core.truth_(inst_22232)){
var statearr_22304_22359 = state_22267__$1;
(statearr_22304_22359[(1)] = (26));

} else {
var statearr_22305_22360 = state_22267__$1;
(statearr_22305_22360[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (35))){
var inst_22252 = (state_22267[(2)]);
var state_22267__$1 = state_22267;
if(cljs.core.truth_(inst_22252)){
var statearr_22306_22361 = state_22267__$1;
(statearr_22306_22361[(1)] = (36));

} else {
var statearr_22307_22362 = state_22267__$1;
(statearr_22307_22362[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (19))){
var inst_22197 = (state_22267[(7)]);
var inst_22216 = cljs.core.apply.call(null,cljs.core.hash_map,inst_22197);
var state_22267__$1 = state_22267;
var statearr_22308_22363 = state_22267__$1;
(statearr_22308_22363[(2)] = inst_22216);

(statearr_22308_22363[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (11))){
var inst_22197 = (state_22267[(7)]);
var inst_22201 = (inst_22197 == null);
var inst_22202 = cljs.core.not.call(null,inst_22201);
var state_22267__$1 = state_22267;
if(inst_22202){
var statearr_22309_22364 = state_22267__$1;
(statearr_22309_22364[(1)] = (13));

} else {
var statearr_22310_22365 = state_22267__$1;
(statearr_22310_22365[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (9))){
var inst_22173 = (state_22267[(8)]);
var state_22267__$1 = state_22267;
var statearr_22311_22366 = state_22267__$1;
(statearr_22311_22366[(2)] = inst_22173);

(statearr_22311_22366[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (5))){
var state_22267__$1 = state_22267;
var statearr_22312_22367 = state_22267__$1;
(statearr_22312_22367[(2)] = true);

(statearr_22312_22367[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (14))){
var state_22267__$1 = state_22267;
var statearr_22313_22368 = state_22267__$1;
(statearr_22313_22368[(2)] = false);

(statearr_22313_22368[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (26))){
var inst_22227 = (state_22267[(9)]);
var inst_22234 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_22227);
var state_22267__$1 = state_22267;
var statearr_22314_22369 = state_22267__$1;
(statearr_22314_22369[(2)] = inst_22234);

(statearr_22314_22369[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (16))){
var state_22267__$1 = state_22267;
var statearr_22315_22370 = state_22267__$1;
(statearr_22315_22370[(2)] = true);

(statearr_22315_22370[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (38))){
var inst_22257 = (state_22267[(2)]);
var state_22267__$1 = state_22267;
var statearr_22316_22371 = state_22267__$1;
(statearr_22316_22371[(2)] = inst_22257);

(statearr_22316_22371[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (30))){
var inst_22227 = (state_22267[(9)]);
var inst_22221 = (state_22267[(13)]);
var inst_22220 = (state_22267[(11)]);
var inst_22244 = cljs.core.empty_QMARK_.call(null,inst_22220);
var inst_22245 = inst_22221.call(null,inst_22227);
var inst_22246 = cljs.core.not.call(null,inst_22245);
var inst_22247 = (inst_22244) && (inst_22246);
var state_22267__$1 = state_22267;
var statearr_22317_22372 = state_22267__$1;
(statearr_22317_22372[(2)] = inst_22247);

(statearr_22317_22372[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (10))){
var inst_22173 = (state_22267[(8)]);
var inst_22193 = (state_22267[(2)]);
var inst_22194 = cljs.core.get.call(null,inst_22193,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_22195 = cljs.core.get.call(null,inst_22193,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_22196 = cljs.core.get.call(null,inst_22193,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_22197 = inst_22173;
var state_22267__$1 = (function (){var statearr_22318 = state_22267;
(statearr_22318[(16)] = inst_22196);

(statearr_22318[(17)] = inst_22194);

(statearr_22318[(7)] = inst_22197);

(statearr_22318[(18)] = inst_22195);

return statearr_22318;
})();
var statearr_22319_22373 = state_22267__$1;
(statearr_22319_22373[(2)] = null);

(statearr_22319_22373[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (18))){
var inst_22211 = (state_22267[(2)]);
var state_22267__$1 = state_22267;
var statearr_22320_22374 = state_22267__$1;
(statearr_22320_22374[(2)] = inst_22211);

(statearr_22320_22374[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (37))){
var state_22267__$1 = state_22267;
var statearr_22321_22375 = state_22267__$1;
(statearr_22321_22375[(2)] = null);

(statearr_22321_22375[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22268 === (8))){
var inst_22173 = (state_22267[(8)]);
var inst_22190 = cljs.core.apply.call(null,cljs.core.hash_map,inst_22173);
var state_22267__$1 = state_22267;
var statearr_22322_22376 = state_22267__$1;
(statearr_22322_22376[(2)] = inst_22190);

(statearr_22322_22376[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto___22330,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__20505__auto__,c__20617__auto___22330,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__20506__auto__ = null;
var cljs$core$async$mix_$_state_machine__20506__auto____0 = (function (){
var statearr_22326 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22326[(0)] = cljs$core$async$mix_$_state_machine__20506__auto__);

(statearr_22326[(1)] = (1));

return statearr_22326;
});
var cljs$core$async$mix_$_state_machine__20506__auto____1 = (function (state_22267){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_22267);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e22327){if((e22327 instanceof Object)){
var ex__20509__auto__ = e22327;
var statearr_22328_22377 = state_22267;
(statearr_22328_22377[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22267);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22327;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22378 = state_22267;
state_22267 = G__22378;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__20506__auto__ = function(state_22267){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__20506__auto____1.call(this,state_22267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__20506__auto____0;
cljs$core$async$mix_$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__20506__auto____1;
return cljs$core$async$mix_$_state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto___22330,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__20619__auto__ = (function (){var statearr_22329 = f__20618__auto__.call(null);
(statearr_22329[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto___22330);

return statearr_22329;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto___22330,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__18857__auto__ = (((p == null))?null:p);
var m__18858__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__18858__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__18857__auto__ = (((p == null))?null:p);
var m__18858__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,p,v,ch);
} else {
var m__18858__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args22379 = [];
var len__19260__auto___22382 = arguments.length;
var i__19261__auto___22383 = (0);
while(true){
if((i__19261__auto___22383 < len__19260__auto___22382)){
args22379.push((arguments[i__19261__auto___22383]));

var G__22384 = (i__19261__auto___22383 + (1));
i__19261__auto___22383 = G__22384;
continue;
} else {
}
break;
}

var G__22381 = args22379.length;
switch (G__22381) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22379.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__18857__auto__ = (((p == null))?null:p);
var m__18858__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,p);
} else {
var m__18858__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__18857__auto__ = (((p == null))?null:p);
var m__18858__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,p,v);
} else {
var m__18858__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args22387 = [];
var len__19260__auto___22512 = arguments.length;
var i__19261__auto___22513 = (0);
while(true){
if((i__19261__auto___22513 < len__19260__auto___22512)){
args22387.push((arguments[i__19261__auto___22513]));

var G__22514 = (i__19261__auto___22513 + (1));
i__19261__auto___22513 = G__22514;
continue;
} else {
}
break;
}

var G__22389 = args22387.length;
switch (G__22389) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22387.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__18202__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__18202__auto__,mults){
return (function (p1__22386_SHARP_){
if(cljs.core.truth_(p1__22386_SHARP_.call(null,topic))){
return p1__22386_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__22386_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__18202__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async22390 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22390 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta22391){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta22391 = meta22391;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22390.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_22392,meta22391__$1){
var self__ = this;
var _22392__$1 = this;
return (new cljs.core.async.t_cljs$core$async22390(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta22391__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22390.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_22392){
var self__ = this;
var _22392__$1 = this;
return self__.meta22391;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22390.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async22390.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22390.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async22390.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22390.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22390.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22390.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22390.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta22391","meta22391",1565520784,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22390.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22390.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22390";

cljs.core.async.t_cljs$core$async22390.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async22390");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async22390 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async22390(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta22391){
return (new cljs.core.async.t_cljs$core$async22390(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta22391));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async22390(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20617__auto___22516 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto___22516,mults,ensure_mult,p){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto___22516,mults,ensure_mult,p){
return (function (state_22464){
var state_val_22465 = (state_22464[(1)]);
if((state_val_22465 === (7))){
var inst_22460 = (state_22464[(2)]);
var state_22464__$1 = state_22464;
var statearr_22466_22517 = state_22464__$1;
(statearr_22466_22517[(2)] = inst_22460);

(statearr_22466_22517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (20))){
var state_22464__$1 = state_22464;
var statearr_22467_22518 = state_22464__$1;
(statearr_22467_22518[(2)] = null);

(statearr_22467_22518[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (1))){
var state_22464__$1 = state_22464;
var statearr_22468_22519 = state_22464__$1;
(statearr_22468_22519[(2)] = null);

(statearr_22468_22519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (24))){
var inst_22443 = (state_22464[(7)]);
var inst_22452 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_22443);
var state_22464__$1 = state_22464;
var statearr_22469_22520 = state_22464__$1;
(statearr_22469_22520[(2)] = inst_22452);

(statearr_22469_22520[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (4))){
var inst_22395 = (state_22464[(8)]);
var inst_22395__$1 = (state_22464[(2)]);
var inst_22396 = (inst_22395__$1 == null);
var state_22464__$1 = (function (){var statearr_22470 = state_22464;
(statearr_22470[(8)] = inst_22395__$1);

return statearr_22470;
})();
if(cljs.core.truth_(inst_22396)){
var statearr_22471_22521 = state_22464__$1;
(statearr_22471_22521[(1)] = (5));

} else {
var statearr_22472_22522 = state_22464__$1;
(statearr_22472_22522[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (15))){
var inst_22437 = (state_22464[(2)]);
var state_22464__$1 = state_22464;
var statearr_22473_22523 = state_22464__$1;
(statearr_22473_22523[(2)] = inst_22437);

(statearr_22473_22523[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (21))){
var inst_22457 = (state_22464[(2)]);
var state_22464__$1 = (function (){var statearr_22474 = state_22464;
(statearr_22474[(9)] = inst_22457);

return statearr_22474;
})();
var statearr_22475_22524 = state_22464__$1;
(statearr_22475_22524[(2)] = null);

(statearr_22475_22524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (13))){
var inst_22419 = (state_22464[(10)]);
var inst_22421 = cljs.core.chunked_seq_QMARK_.call(null,inst_22419);
var state_22464__$1 = state_22464;
if(inst_22421){
var statearr_22476_22525 = state_22464__$1;
(statearr_22476_22525[(1)] = (16));

} else {
var statearr_22477_22526 = state_22464__$1;
(statearr_22477_22526[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (22))){
var inst_22449 = (state_22464[(2)]);
var state_22464__$1 = state_22464;
if(cljs.core.truth_(inst_22449)){
var statearr_22478_22527 = state_22464__$1;
(statearr_22478_22527[(1)] = (23));

} else {
var statearr_22479_22528 = state_22464__$1;
(statearr_22479_22528[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (6))){
var inst_22445 = (state_22464[(11)]);
var inst_22395 = (state_22464[(8)]);
var inst_22443 = (state_22464[(7)]);
var inst_22443__$1 = topic_fn.call(null,inst_22395);
var inst_22444 = cljs.core.deref.call(null,mults);
var inst_22445__$1 = cljs.core.get.call(null,inst_22444,inst_22443__$1);
var state_22464__$1 = (function (){var statearr_22480 = state_22464;
(statearr_22480[(11)] = inst_22445__$1);

(statearr_22480[(7)] = inst_22443__$1);

return statearr_22480;
})();
if(cljs.core.truth_(inst_22445__$1)){
var statearr_22481_22529 = state_22464__$1;
(statearr_22481_22529[(1)] = (19));

} else {
var statearr_22482_22530 = state_22464__$1;
(statearr_22482_22530[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (25))){
var inst_22454 = (state_22464[(2)]);
var state_22464__$1 = state_22464;
var statearr_22483_22531 = state_22464__$1;
(statearr_22483_22531[(2)] = inst_22454);

(statearr_22483_22531[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (17))){
var inst_22419 = (state_22464[(10)]);
var inst_22428 = cljs.core.first.call(null,inst_22419);
var inst_22429 = cljs.core.async.muxch_STAR_.call(null,inst_22428);
var inst_22430 = cljs.core.async.close_BANG_.call(null,inst_22429);
var inst_22431 = cljs.core.next.call(null,inst_22419);
var inst_22405 = inst_22431;
var inst_22406 = null;
var inst_22407 = (0);
var inst_22408 = (0);
var state_22464__$1 = (function (){var statearr_22484 = state_22464;
(statearr_22484[(12)] = inst_22406);

(statearr_22484[(13)] = inst_22408);

(statearr_22484[(14)] = inst_22430);

(statearr_22484[(15)] = inst_22405);

(statearr_22484[(16)] = inst_22407);

return statearr_22484;
})();
var statearr_22485_22532 = state_22464__$1;
(statearr_22485_22532[(2)] = null);

(statearr_22485_22532[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (3))){
var inst_22462 = (state_22464[(2)]);
var state_22464__$1 = state_22464;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22464__$1,inst_22462);
} else {
if((state_val_22465 === (12))){
var inst_22439 = (state_22464[(2)]);
var state_22464__$1 = state_22464;
var statearr_22486_22533 = state_22464__$1;
(statearr_22486_22533[(2)] = inst_22439);

(statearr_22486_22533[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (2))){
var state_22464__$1 = state_22464;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22464__$1,(4),ch);
} else {
if((state_val_22465 === (23))){
var state_22464__$1 = state_22464;
var statearr_22487_22534 = state_22464__$1;
(statearr_22487_22534[(2)] = null);

(statearr_22487_22534[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (19))){
var inst_22445 = (state_22464[(11)]);
var inst_22395 = (state_22464[(8)]);
var inst_22447 = cljs.core.async.muxch_STAR_.call(null,inst_22445);
var state_22464__$1 = state_22464;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22464__$1,(22),inst_22447,inst_22395);
} else {
if((state_val_22465 === (11))){
var inst_22419 = (state_22464[(10)]);
var inst_22405 = (state_22464[(15)]);
var inst_22419__$1 = cljs.core.seq.call(null,inst_22405);
var state_22464__$1 = (function (){var statearr_22488 = state_22464;
(statearr_22488[(10)] = inst_22419__$1);

return statearr_22488;
})();
if(inst_22419__$1){
var statearr_22489_22535 = state_22464__$1;
(statearr_22489_22535[(1)] = (13));

} else {
var statearr_22490_22536 = state_22464__$1;
(statearr_22490_22536[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (9))){
var inst_22441 = (state_22464[(2)]);
var state_22464__$1 = state_22464;
var statearr_22491_22537 = state_22464__$1;
(statearr_22491_22537[(2)] = inst_22441);

(statearr_22491_22537[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (5))){
var inst_22402 = cljs.core.deref.call(null,mults);
var inst_22403 = cljs.core.vals.call(null,inst_22402);
var inst_22404 = cljs.core.seq.call(null,inst_22403);
var inst_22405 = inst_22404;
var inst_22406 = null;
var inst_22407 = (0);
var inst_22408 = (0);
var state_22464__$1 = (function (){var statearr_22492 = state_22464;
(statearr_22492[(12)] = inst_22406);

(statearr_22492[(13)] = inst_22408);

(statearr_22492[(15)] = inst_22405);

(statearr_22492[(16)] = inst_22407);

return statearr_22492;
})();
var statearr_22493_22538 = state_22464__$1;
(statearr_22493_22538[(2)] = null);

(statearr_22493_22538[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (14))){
var state_22464__$1 = state_22464;
var statearr_22497_22539 = state_22464__$1;
(statearr_22497_22539[(2)] = null);

(statearr_22497_22539[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (16))){
var inst_22419 = (state_22464[(10)]);
var inst_22423 = cljs.core.chunk_first.call(null,inst_22419);
var inst_22424 = cljs.core.chunk_rest.call(null,inst_22419);
var inst_22425 = cljs.core.count.call(null,inst_22423);
var inst_22405 = inst_22424;
var inst_22406 = inst_22423;
var inst_22407 = inst_22425;
var inst_22408 = (0);
var state_22464__$1 = (function (){var statearr_22498 = state_22464;
(statearr_22498[(12)] = inst_22406);

(statearr_22498[(13)] = inst_22408);

(statearr_22498[(15)] = inst_22405);

(statearr_22498[(16)] = inst_22407);

return statearr_22498;
})();
var statearr_22499_22540 = state_22464__$1;
(statearr_22499_22540[(2)] = null);

(statearr_22499_22540[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (10))){
var inst_22406 = (state_22464[(12)]);
var inst_22408 = (state_22464[(13)]);
var inst_22405 = (state_22464[(15)]);
var inst_22407 = (state_22464[(16)]);
var inst_22413 = cljs.core._nth.call(null,inst_22406,inst_22408);
var inst_22414 = cljs.core.async.muxch_STAR_.call(null,inst_22413);
var inst_22415 = cljs.core.async.close_BANG_.call(null,inst_22414);
var inst_22416 = (inst_22408 + (1));
var tmp22494 = inst_22406;
var tmp22495 = inst_22405;
var tmp22496 = inst_22407;
var inst_22405__$1 = tmp22495;
var inst_22406__$1 = tmp22494;
var inst_22407__$1 = tmp22496;
var inst_22408__$1 = inst_22416;
var state_22464__$1 = (function (){var statearr_22500 = state_22464;
(statearr_22500[(12)] = inst_22406__$1);

(statearr_22500[(13)] = inst_22408__$1);

(statearr_22500[(15)] = inst_22405__$1);

(statearr_22500[(16)] = inst_22407__$1);

(statearr_22500[(17)] = inst_22415);

return statearr_22500;
})();
var statearr_22501_22541 = state_22464__$1;
(statearr_22501_22541[(2)] = null);

(statearr_22501_22541[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (18))){
var inst_22434 = (state_22464[(2)]);
var state_22464__$1 = state_22464;
var statearr_22502_22542 = state_22464__$1;
(statearr_22502_22542[(2)] = inst_22434);

(statearr_22502_22542[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22465 === (8))){
var inst_22408 = (state_22464[(13)]);
var inst_22407 = (state_22464[(16)]);
var inst_22410 = (inst_22408 < inst_22407);
var inst_22411 = inst_22410;
var state_22464__$1 = state_22464;
if(cljs.core.truth_(inst_22411)){
var statearr_22503_22543 = state_22464__$1;
(statearr_22503_22543[(1)] = (10));

} else {
var statearr_22504_22544 = state_22464__$1;
(statearr_22504_22544[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto___22516,mults,ensure_mult,p))
;
return ((function (switch__20505__auto__,c__20617__auto___22516,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__20506__auto__ = null;
var cljs$core$async$state_machine__20506__auto____0 = (function (){
var statearr_22508 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22508[(0)] = cljs$core$async$state_machine__20506__auto__);

(statearr_22508[(1)] = (1));

return statearr_22508;
});
var cljs$core$async$state_machine__20506__auto____1 = (function (state_22464){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_22464);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e22509){if((e22509 instanceof Object)){
var ex__20509__auto__ = e22509;
var statearr_22510_22545 = state_22464;
(statearr_22510_22545[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22464);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22509;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22546 = state_22464;
state_22464 = G__22546;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$state_machine__20506__auto__ = function(state_22464){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20506__auto____1.call(this,state_22464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20506__auto____0;
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20506__auto____1;
return cljs$core$async$state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto___22516,mults,ensure_mult,p))
})();
var state__20619__auto__ = (function (){var statearr_22511 = f__20618__auto__.call(null);
(statearr_22511[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto___22516);

return statearr_22511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto___22516,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args22547 = [];
var len__19260__auto___22550 = arguments.length;
var i__19261__auto___22551 = (0);
while(true){
if((i__19261__auto___22551 < len__19260__auto___22550)){
args22547.push((arguments[i__19261__auto___22551]));

var G__22552 = (i__19261__auto___22551 + (1));
i__19261__auto___22551 = G__22552;
continue;
} else {
}
break;
}

var G__22549 = args22547.length;
switch (G__22549) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22547.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args22554 = [];
var len__19260__auto___22557 = arguments.length;
var i__19261__auto___22558 = (0);
while(true){
if((i__19261__auto___22558 < len__19260__auto___22557)){
args22554.push((arguments[i__19261__auto___22558]));

var G__22559 = (i__19261__auto___22558 + (1));
i__19261__auto___22558 = G__22559;
continue;
} else {
}
break;
}

var G__22556 = args22554.length;
switch (G__22556) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22554.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args22561 = [];
var len__19260__auto___22632 = arguments.length;
var i__19261__auto___22633 = (0);
while(true){
if((i__19261__auto___22633 < len__19260__auto___22632)){
args22561.push((arguments[i__19261__auto___22633]));

var G__22634 = (i__19261__auto___22633 + (1));
i__19261__auto___22633 = G__22634;
continue;
} else {
}
break;
}

var G__22563 = args22561.length;
switch (G__22563) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22561.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__20617__auto___22636 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto___22636,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto___22636,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_22602){
var state_val_22603 = (state_22602[(1)]);
if((state_val_22603 === (7))){
var state_22602__$1 = state_22602;
var statearr_22604_22637 = state_22602__$1;
(statearr_22604_22637[(2)] = null);

(statearr_22604_22637[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22603 === (1))){
var state_22602__$1 = state_22602;
var statearr_22605_22638 = state_22602__$1;
(statearr_22605_22638[(2)] = null);

(statearr_22605_22638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22603 === (4))){
var inst_22566 = (state_22602[(7)]);
var inst_22568 = (inst_22566 < cnt);
var state_22602__$1 = state_22602;
if(cljs.core.truth_(inst_22568)){
var statearr_22606_22639 = state_22602__$1;
(statearr_22606_22639[(1)] = (6));

} else {
var statearr_22607_22640 = state_22602__$1;
(statearr_22607_22640[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22603 === (15))){
var inst_22598 = (state_22602[(2)]);
var state_22602__$1 = state_22602;
var statearr_22608_22641 = state_22602__$1;
(statearr_22608_22641[(2)] = inst_22598);

(statearr_22608_22641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22603 === (13))){
var inst_22591 = cljs.core.async.close_BANG_.call(null,out);
var state_22602__$1 = state_22602;
var statearr_22609_22642 = state_22602__$1;
(statearr_22609_22642[(2)] = inst_22591);

(statearr_22609_22642[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22603 === (6))){
var state_22602__$1 = state_22602;
var statearr_22610_22643 = state_22602__$1;
(statearr_22610_22643[(2)] = null);

(statearr_22610_22643[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22603 === (3))){
var inst_22600 = (state_22602[(2)]);
var state_22602__$1 = state_22602;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22602__$1,inst_22600);
} else {
if((state_val_22603 === (12))){
var inst_22588 = (state_22602[(8)]);
var inst_22588__$1 = (state_22602[(2)]);
var inst_22589 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_22588__$1);
var state_22602__$1 = (function (){var statearr_22611 = state_22602;
(statearr_22611[(8)] = inst_22588__$1);

return statearr_22611;
})();
if(cljs.core.truth_(inst_22589)){
var statearr_22612_22644 = state_22602__$1;
(statearr_22612_22644[(1)] = (13));

} else {
var statearr_22613_22645 = state_22602__$1;
(statearr_22613_22645[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22603 === (2))){
var inst_22565 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_22566 = (0);
var state_22602__$1 = (function (){var statearr_22614 = state_22602;
(statearr_22614[(9)] = inst_22565);

(statearr_22614[(7)] = inst_22566);

return statearr_22614;
})();
var statearr_22615_22646 = state_22602__$1;
(statearr_22615_22646[(2)] = null);

(statearr_22615_22646[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22603 === (11))){
var inst_22566 = (state_22602[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_22602,(10),Object,null,(9));
var inst_22575 = chs__$1.call(null,inst_22566);
var inst_22576 = done.call(null,inst_22566);
var inst_22577 = cljs.core.async.take_BANG_.call(null,inst_22575,inst_22576);
var state_22602__$1 = state_22602;
var statearr_22616_22647 = state_22602__$1;
(statearr_22616_22647[(2)] = inst_22577);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22602__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22603 === (9))){
var inst_22566 = (state_22602[(7)]);
var inst_22579 = (state_22602[(2)]);
var inst_22580 = (inst_22566 + (1));
var inst_22566__$1 = inst_22580;
var state_22602__$1 = (function (){var statearr_22617 = state_22602;
(statearr_22617[(10)] = inst_22579);

(statearr_22617[(7)] = inst_22566__$1);

return statearr_22617;
})();
var statearr_22618_22648 = state_22602__$1;
(statearr_22618_22648[(2)] = null);

(statearr_22618_22648[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22603 === (5))){
var inst_22586 = (state_22602[(2)]);
var state_22602__$1 = (function (){var statearr_22619 = state_22602;
(statearr_22619[(11)] = inst_22586);

return statearr_22619;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22602__$1,(12),dchan);
} else {
if((state_val_22603 === (14))){
var inst_22588 = (state_22602[(8)]);
var inst_22593 = cljs.core.apply.call(null,f,inst_22588);
var state_22602__$1 = state_22602;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22602__$1,(16),out,inst_22593);
} else {
if((state_val_22603 === (16))){
var inst_22595 = (state_22602[(2)]);
var state_22602__$1 = (function (){var statearr_22620 = state_22602;
(statearr_22620[(12)] = inst_22595);

return statearr_22620;
})();
var statearr_22621_22649 = state_22602__$1;
(statearr_22621_22649[(2)] = null);

(statearr_22621_22649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22603 === (10))){
var inst_22570 = (state_22602[(2)]);
var inst_22571 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_22602__$1 = (function (){var statearr_22622 = state_22602;
(statearr_22622[(13)] = inst_22570);

return statearr_22622;
})();
var statearr_22623_22650 = state_22602__$1;
(statearr_22623_22650[(2)] = inst_22571);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22602__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22603 === (8))){
var inst_22584 = (state_22602[(2)]);
var state_22602__$1 = state_22602;
var statearr_22624_22651 = state_22602__$1;
(statearr_22624_22651[(2)] = inst_22584);

(statearr_22624_22651[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto___22636,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__20505__auto__,c__20617__auto___22636,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__20506__auto__ = null;
var cljs$core$async$state_machine__20506__auto____0 = (function (){
var statearr_22628 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22628[(0)] = cljs$core$async$state_machine__20506__auto__);

(statearr_22628[(1)] = (1));

return statearr_22628;
});
var cljs$core$async$state_machine__20506__auto____1 = (function (state_22602){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_22602);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e22629){if((e22629 instanceof Object)){
var ex__20509__auto__ = e22629;
var statearr_22630_22652 = state_22602;
(statearr_22630_22652[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22602);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22629;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22653 = state_22602;
state_22602 = G__22653;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$state_machine__20506__auto__ = function(state_22602){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20506__auto____1.call(this,state_22602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20506__auto____0;
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20506__auto____1;
return cljs$core$async$state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto___22636,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__20619__auto__ = (function (){var statearr_22631 = f__20618__auto__.call(null);
(statearr_22631[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto___22636);

return statearr_22631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto___22636,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args22655 = [];
var len__19260__auto___22711 = arguments.length;
var i__19261__auto___22712 = (0);
while(true){
if((i__19261__auto___22712 < len__19260__auto___22711)){
args22655.push((arguments[i__19261__auto___22712]));

var G__22713 = (i__19261__auto___22712 + (1));
i__19261__auto___22712 = G__22713;
continue;
} else {
}
break;
}

var G__22657 = args22655.length;
switch (G__22657) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22655.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20617__auto___22715 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto___22715,out){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto___22715,out){
return (function (state_22687){
var state_val_22688 = (state_22687[(1)]);
if((state_val_22688 === (7))){
var inst_22667 = (state_22687[(7)]);
var inst_22666 = (state_22687[(8)]);
var inst_22666__$1 = (state_22687[(2)]);
var inst_22667__$1 = cljs.core.nth.call(null,inst_22666__$1,(0),null);
var inst_22668 = cljs.core.nth.call(null,inst_22666__$1,(1),null);
var inst_22669 = (inst_22667__$1 == null);
var state_22687__$1 = (function (){var statearr_22689 = state_22687;
(statearr_22689[(9)] = inst_22668);

(statearr_22689[(7)] = inst_22667__$1);

(statearr_22689[(8)] = inst_22666__$1);

return statearr_22689;
})();
if(cljs.core.truth_(inst_22669)){
var statearr_22690_22716 = state_22687__$1;
(statearr_22690_22716[(1)] = (8));

} else {
var statearr_22691_22717 = state_22687__$1;
(statearr_22691_22717[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22688 === (1))){
var inst_22658 = cljs.core.vec.call(null,chs);
var inst_22659 = inst_22658;
var state_22687__$1 = (function (){var statearr_22692 = state_22687;
(statearr_22692[(10)] = inst_22659);

return statearr_22692;
})();
var statearr_22693_22718 = state_22687__$1;
(statearr_22693_22718[(2)] = null);

(statearr_22693_22718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22688 === (4))){
var inst_22659 = (state_22687[(10)]);
var state_22687__$1 = state_22687;
return cljs.core.async.ioc_alts_BANG_.call(null,state_22687__$1,(7),inst_22659);
} else {
if((state_val_22688 === (6))){
var inst_22683 = (state_22687[(2)]);
var state_22687__$1 = state_22687;
var statearr_22694_22719 = state_22687__$1;
(statearr_22694_22719[(2)] = inst_22683);

(statearr_22694_22719[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22688 === (3))){
var inst_22685 = (state_22687[(2)]);
var state_22687__$1 = state_22687;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22687__$1,inst_22685);
} else {
if((state_val_22688 === (2))){
var inst_22659 = (state_22687[(10)]);
var inst_22661 = cljs.core.count.call(null,inst_22659);
var inst_22662 = (inst_22661 > (0));
var state_22687__$1 = state_22687;
if(cljs.core.truth_(inst_22662)){
var statearr_22696_22720 = state_22687__$1;
(statearr_22696_22720[(1)] = (4));

} else {
var statearr_22697_22721 = state_22687__$1;
(statearr_22697_22721[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22688 === (11))){
var inst_22659 = (state_22687[(10)]);
var inst_22676 = (state_22687[(2)]);
var tmp22695 = inst_22659;
var inst_22659__$1 = tmp22695;
var state_22687__$1 = (function (){var statearr_22698 = state_22687;
(statearr_22698[(10)] = inst_22659__$1);

(statearr_22698[(11)] = inst_22676);

return statearr_22698;
})();
var statearr_22699_22722 = state_22687__$1;
(statearr_22699_22722[(2)] = null);

(statearr_22699_22722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22688 === (9))){
var inst_22667 = (state_22687[(7)]);
var state_22687__$1 = state_22687;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22687__$1,(11),out,inst_22667);
} else {
if((state_val_22688 === (5))){
var inst_22681 = cljs.core.async.close_BANG_.call(null,out);
var state_22687__$1 = state_22687;
var statearr_22700_22723 = state_22687__$1;
(statearr_22700_22723[(2)] = inst_22681);

(statearr_22700_22723[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22688 === (10))){
var inst_22679 = (state_22687[(2)]);
var state_22687__$1 = state_22687;
var statearr_22701_22724 = state_22687__$1;
(statearr_22701_22724[(2)] = inst_22679);

(statearr_22701_22724[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22688 === (8))){
var inst_22659 = (state_22687[(10)]);
var inst_22668 = (state_22687[(9)]);
var inst_22667 = (state_22687[(7)]);
var inst_22666 = (state_22687[(8)]);
var inst_22671 = (function (){var cs = inst_22659;
var vec__22664 = inst_22666;
var v = inst_22667;
var c = inst_22668;
return ((function (cs,vec__22664,v,c,inst_22659,inst_22668,inst_22667,inst_22666,state_val_22688,c__20617__auto___22715,out){
return (function (p1__22654_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__22654_SHARP_);
});
;})(cs,vec__22664,v,c,inst_22659,inst_22668,inst_22667,inst_22666,state_val_22688,c__20617__auto___22715,out))
})();
var inst_22672 = cljs.core.filterv.call(null,inst_22671,inst_22659);
var inst_22659__$1 = inst_22672;
var state_22687__$1 = (function (){var statearr_22702 = state_22687;
(statearr_22702[(10)] = inst_22659__$1);

return statearr_22702;
})();
var statearr_22703_22725 = state_22687__$1;
(statearr_22703_22725[(2)] = null);

(statearr_22703_22725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto___22715,out))
;
return ((function (switch__20505__auto__,c__20617__auto___22715,out){
return (function() {
var cljs$core$async$state_machine__20506__auto__ = null;
var cljs$core$async$state_machine__20506__auto____0 = (function (){
var statearr_22707 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22707[(0)] = cljs$core$async$state_machine__20506__auto__);

(statearr_22707[(1)] = (1));

return statearr_22707;
});
var cljs$core$async$state_machine__20506__auto____1 = (function (state_22687){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_22687);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e22708){if((e22708 instanceof Object)){
var ex__20509__auto__ = e22708;
var statearr_22709_22726 = state_22687;
(statearr_22709_22726[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22687);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22708;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22727 = state_22687;
state_22687 = G__22727;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$state_machine__20506__auto__ = function(state_22687){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20506__auto____1.call(this,state_22687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20506__auto____0;
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20506__auto____1;
return cljs$core$async$state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto___22715,out))
})();
var state__20619__auto__ = (function (){var statearr_22710 = f__20618__auto__.call(null);
(statearr_22710[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto___22715);

return statearr_22710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto___22715,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args22728 = [];
var len__19260__auto___22777 = arguments.length;
var i__19261__auto___22778 = (0);
while(true){
if((i__19261__auto___22778 < len__19260__auto___22777)){
args22728.push((arguments[i__19261__auto___22778]));

var G__22779 = (i__19261__auto___22778 + (1));
i__19261__auto___22778 = G__22779;
continue;
} else {
}
break;
}

var G__22730 = args22728.length;
switch (G__22730) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22728.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20617__auto___22781 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto___22781,out){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto___22781,out){
return (function (state_22754){
var state_val_22755 = (state_22754[(1)]);
if((state_val_22755 === (7))){
var inst_22736 = (state_22754[(7)]);
var inst_22736__$1 = (state_22754[(2)]);
var inst_22737 = (inst_22736__$1 == null);
var inst_22738 = cljs.core.not.call(null,inst_22737);
var state_22754__$1 = (function (){var statearr_22756 = state_22754;
(statearr_22756[(7)] = inst_22736__$1);

return statearr_22756;
})();
if(inst_22738){
var statearr_22757_22782 = state_22754__$1;
(statearr_22757_22782[(1)] = (8));

} else {
var statearr_22758_22783 = state_22754__$1;
(statearr_22758_22783[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22755 === (1))){
var inst_22731 = (0);
var state_22754__$1 = (function (){var statearr_22759 = state_22754;
(statearr_22759[(8)] = inst_22731);

return statearr_22759;
})();
var statearr_22760_22784 = state_22754__$1;
(statearr_22760_22784[(2)] = null);

(statearr_22760_22784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22755 === (4))){
var state_22754__$1 = state_22754;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22754__$1,(7),ch);
} else {
if((state_val_22755 === (6))){
var inst_22749 = (state_22754[(2)]);
var state_22754__$1 = state_22754;
var statearr_22761_22785 = state_22754__$1;
(statearr_22761_22785[(2)] = inst_22749);

(statearr_22761_22785[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22755 === (3))){
var inst_22751 = (state_22754[(2)]);
var inst_22752 = cljs.core.async.close_BANG_.call(null,out);
var state_22754__$1 = (function (){var statearr_22762 = state_22754;
(statearr_22762[(9)] = inst_22751);

return statearr_22762;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22754__$1,inst_22752);
} else {
if((state_val_22755 === (2))){
var inst_22731 = (state_22754[(8)]);
var inst_22733 = (inst_22731 < n);
var state_22754__$1 = state_22754;
if(cljs.core.truth_(inst_22733)){
var statearr_22763_22786 = state_22754__$1;
(statearr_22763_22786[(1)] = (4));

} else {
var statearr_22764_22787 = state_22754__$1;
(statearr_22764_22787[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22755 === (11))){
var inst_22731 = (state_22754[(8)]);
var inst_22741 = (state_22754[(2)]);
var inst_22742 = (inst_22731 + (1));
var inst_22731__$1 = inst_22742;
var state_22754__$1 = (function (){var statearr_22765 = state_22754;
(statearr_22765[(10)] = inst_22741);

(statearr_22765[(8)] = inst_22731__$1);

return statearr_22765;
})();
var statearr_22766_22788 = state_22754__$1;
(statearr_22766_22788[(2)] = null);

(statearr_22766_22788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22755 === (9))){
var state_22754__$1 = state_22754;
var statearr_22767_22789 = state_22754__$1;
(statearr_22767_22789[(2)] = null);

(statearr_22767_22789[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22755 === (5))){
var state_22754__$1 = state_22754;
var statearr_22768_22790 = state_22754__$1;
(statearr_22768_22790[(2)] = null);

(statearr_22768_22790[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22755 === (10))){
var inst_22746 = (state_22754[(2)]);
var state_22754__$1 = state_22754;
var statearr_22769_22791 = state_22754__$1;
(statearr_22769_22791[(2)] = inst_22746);

(statearr_22769_22791[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22755 === (8))){
var inst_22736 = (state_22754[(7)]);
var state_22754__$1 = state_22754;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22754__$1,(11),out,inst_22736);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto___22781,out))
;
return ((function (switch__20505__auto__,c__20617__auto___22781,out){
return (function() {
var cljs$core$async$state_machine__20506__auto__ = null;
var cljs$core$async$state_machine__20506__auto____0 = (function (){
var statearr_22773 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22773[(0)] = cljs$core$async$state_machine__20506__auto__);

(statearr_22773[(1)] = (1));

return statearr_22773;
});
var cljs$core$async$state_machine__20506__auto____1 = (function (state_22754){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_22754);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e22774){if((e22774 instanceof Object)){
var ex__20509__auto__ = e22774;
var statearr_22775_22792 = state_22754;
(statearr_22775_22792[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22754);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22774;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22793 = state_22754;
state_22754 = G__22793;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$state_machine__20506__auto__ = function(state_22754){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20506__auto____1.call(this,state_22754);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20506__auto____0;
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20506__auto____1;
return cljs$core$async$state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto___22781,out))
})();
var state__20619__auto__ = (function (){var statearr_22776 = f__20618__auto__.call(null);
(statearr_22776[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto___22781);

return statearr_22776;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto___22781,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async22801 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22801 = (function (map_LT_,f,ch,meta22802){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta22802 = meta22802;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22801.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22803,meta22802__$1){
var self__ = this;
var _22803__$1 = this;
return (new cljs.core.async.t_cljs$core$async22801(self__.map_LT_,self__.f,self__.ch,meta22802__$1));
});

cljs.core.async.t_cljs$core$async22801.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22803){
var self__ = this;
var _22803__$1 = this;
return self__.meta22802;
});

cljs.core.async.t_cljs$core$async22801.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22801.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22801.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22801.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22801.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async22804 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22804 = (function (map_LT_,f,ch,meta22802,_,fn1,meta22805){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta22802 = meta22802;
this._ = _;
this.fn1 = fn1;
this.meta22805 = meta22805;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22804.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_22806,meta22805__$1){
var self__ = this;
var _22806__$1 = this;
return (new cljs.core.async.t_cljs$core$async22804(self__.map_LT_,self__.f,self__.ch,self__.meta22802,self__._,self__.fn1,meta22805__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async22804.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_22806){
var self__ = this;
var _22806__$1 = this;
return self__.meta22805;
});})(___$1))
;

cljs.core.async.t_cljs$core$async22804.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async22804.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async22804.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async22804.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__22794_SHARP_){
return f1.call(null,(((p1__22794_SHARP_ == null))?null:self__.f.call(null,p1__22794_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async22804.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22802","meta22802",-1065368131,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async22801","cljs.core.async/t_cljs$core$async22801",907491547,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta22805","meta22805",-1851527099,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async22804.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22804.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22804";

cljs.core.async.t_cljs$core$async22804.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async22804");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async22804 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async22804(map_LT___$1,f__$1,ch__$1,meta22802__$1,___$2,fn1__$1,meta22805){
return (new cljs.core.async.t_cljs$core$async22804(map_LT___$1,f__$1,ch__$1,meta22802__$1,___$2,fn1__$1,meta22805));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async22804(self__.map_LT_,self__.f,self__.ch,self__.meta22802,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__18190__auto__ = ret;
if(cljs.core.truth_(and__18190__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__18190__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async22801.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22801.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async22801.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22802","meta22802",-1065368131,null)], null);
});

cljs.core.async.t_cljs$core$async22801.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22801.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22801";

cljs.core.async.t_cljs$core$async22801.cljs$lang$ctorPrWriter = (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async22801");
});

cljs.core.async.__GT_t_cljs$core$async22801 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async22801(map_LT___$1,f__$1,ch__$1,meta22802){
return (new cljs.core.async.t_cljs$core$async22801(map_LT___$1,f__$1,ch__$1,meta22802));
});

}

return (new cljs.core.async.t_cljs$core$async22801(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async22810 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22810 = (function (map_GT_,f,ch,meta22811){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta22811 = meta22811;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22810.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22812,meta22811__$1){
var self__ = this;
var _22812__$1 = this;
return (new cljs.core.async.t_cljs$core$async22810(self__.map_GT_,self__.f,self__.ch,meta22811__$1));
});

cljs.core.async.t_cljs$core$async22810.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22812){
var self__ = this;
var _22812__$1 = this;
return self__.meta22811;
});

cljs.core.async.t_cljs$core$async22810.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22810.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22810.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22810.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async22810.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22810.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async22810.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22811","meta22811",-80561425,null)], null);
});

cljs.core.async.t_cljs$core$async22810.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22810.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22810";

cljs.core.async.t_cljs$core$async22810.cljs$lang$ctorPrWriter = (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async22810");
});

cljs.core.async.__GT_t_cljs$core$async22810 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async22810(map_GT___$1,f__$1,ch__$1,meta22811){
return (new cljs.core.async.t_cljs$core$async22810(map_GT___$1,f__$1,ch__$1,meta22811));
});

}

return (new cljs.core.async.t_cljs$core$async22810(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async22816 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22816 = (function (filter_GT_,p,ch,meta22817){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta22817 = meta22817;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22816.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22818,meta22817__$1){
var self__ = this;
var _22818__$1 = this;
return (new cljs.core.async.t_cljs$core$async22816(self__.filter_GT_,self__.p,self__.ch,meta22817__$1));
});

cljs.core.async.t_cljs$core$async22816.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22818){
var self__ = this;
var _22818__$1 = this;
return self__.meta22817;
});

cljs.core.async.t_cljs$core$async22816.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22816.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22816.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22816.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22816.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async22816.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22816.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async22816.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22817","meta22817",-299519906,null)], null);
});

cljs.core.async.t_cljs$core$async22816.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22816.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22816";

cljs.core.async.t_cljs$core$async22816.cljs$lang$ctorPrWriter = (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async22816");
});

cljs.core.async.__GT_t_cljs$core$async22816 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async22816(filter_GT___$1,p__$1,ch__$1,meta22817){
return (new cljs.core.async.t_cljs$core$async22816(filter_GT___$1,p__$1,ch__$1,meta22817));
});

}

return (new cljs.core.async.t_cljs$core$async22816(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args22819 = [];
var len__19260__auto___22863 = arguments.length;
var i__19261__auto___22864 = (0);
while(true){
if((i__19261__auto___22864 < len__19260__auto___22863)){
args22819.push((arguments[i__19261__auto___22864]));

var G__22865 = (i__19261__auto___22864 + (1));
i__19261__auto___22864 = G__22865;
continue;
} else {
}
break;
}

var G__22821 = args22819.length;
switch (G__22821) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22819.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20617__auto___22867 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto___22867,out){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto___22867,out){
return (function (state_22842){
var state_val_22843 = (state_22842[(1)]);
if((state_val_22843 === (7))){
var inst_22838 = (state_22842[(2)]);
var state_22842__$1 = state_22842;
var statearr_22844_22868 = state_22842__$1;
(statearr_22844_22868[(2)] = inst_22838);

(statearr_22844_22868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22843 === (1))){
var state_22842__$1 = state_22842;
var statearr_22845_22869 = state_22842__$1;
(statearr_22845_22869[(2)] = null);

(statearr_22845_22869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22843 === (4))){
var inst_22824 = (state_22842[(7)]);
var inst_22824__$1 = (state_22842[(2)]);
var inst_22825 = (inst_22824__$1 == null);
var state_22842__$1 = (function (){var statearr_22846 = state_22842;
(statearr_22846[(7)] = inst_22824__$1);

return statearr_22846;
})();
if(cljs.core.truth_(inst_22825)){
var statearr_22847_22870 = state_22842__$1;
(statearr_22847_22870[(1)] = (5));

} else {
var statearr_22848_22871 = state_22842__$1;
(statearr_22848_22871[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22843 === (6))){
var inst_22824 = (state_22842[(7)]);
var inst_22829 = p.call(null,inst_22824);
var state_22842__$1 = state_22842;
if(cljs.core.truth_(inst_22829)){
var statearr_22849_22872 = state_22842__$1;
(statearr_22849_22872[(1)] = (8));

} else {
var statearr_22850_22873 = state_22842__$1;
(statearr_22850_22873[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22843 === (3))){
var inst_22840 = (state_22842[(2)]);
var state_22842__$1 = state_22842;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22842__$1,inst_22840);
} else {
if((state_val_22843 === (2))){
var state_22842__$1 = state_22842;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22842__$1,(4),ch);
} else {
if((state_val_22843 === (11))){
var inst_22832 = (state_22842[(2)]);
var state_22842__$1 = state_22842;
var statearr_22851_22874 = state_22842__$1;
(statearr_22851_22874[(2)] = inst_22832);

(statearr_22851_22874[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22843 === (9))){
var state_22842__$1 = state_22842;
var statearr_22852_22875 = state_22842__$1;
(statearr_22852_22875[(2)] = null);

(statearr_22852_22875[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22843 === (5))){
var inst_22827 = cljs.core.async.close_BANG_.call(null,out);
var state_22842__$1 = state_22842;
var statearr_22853_22876 = state_22842__$1;
(statearr_22853_22876[(2)] = inst_22827);

(statearr_22853_22876[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22843 === (10))){
var inst_22835 = (state_22842[(2)]);
var state_22842__$1 = (function (){var statearr_22854 = state_22842;
(statearr_22854[(8)] = inst_22835);

return statearr_22854;
})();
var statearr_22855_22877 = state_22842__$1;
(statearr_22855_22877[(2)] = null);

(statearr_22855_22877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22843 === (8))){
var inst_22824 = (state_22842[(7)]);
var state_22842__$1 = state_22842;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22842__$1,(11),out,inst_22824);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto___22867,out))
;
return ((function (switch__20505__auto__,c__20617__auto___22867,out){
return (function() {
var cljs$core$async$state_machine__20506__auto__ = null;
var cljs$core$async$state_machine__20506__auto____0 = (function (){
var statearr_22859 = [null,null,null,null,null,null,null,null,null];
(statearr_22859[(0)] = cljs$core$async$state_machine__20506__auto__);

(statearr_22859[(1)] = (1));

return statearr_22859;
});
var cljs$core$async$state_machine__20506__auto____1 = (function (state_22842){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_22842);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e22860){if((e22860 instanceof Object)){
var ex__20509__auto__ = e22860;
var statearr_22861_22878 = state_22842;
(statearr_22861_22878[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22842);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22860;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22879 = state_22842;
state_22842 = G__22879;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$state_machine__20506__auto__ = function(state_22842){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20506__auto____1.call(this,state_22842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20506__auto____0;
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20506__auto____1;
return cljs$core$async$state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto___22867,out))
})();
var state__20619__auto__ = (function (){var statearr_22862 = f__20618__auto__.call(null);
(statearr_22862[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto___22867);

return statearr_22862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto___22867,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args22880 = [];
var len__19260__auto___22883 = arguments.length;
var i__19261__auto___22884 = (0);
while(true){
if((i__19261__auto___22884 < len__19260__auto___22883)){
args22880.push((arguments[i__19261__auto___22884]));

var G__22885 = (i__19261__auto___22884 + (1));
i__19261__auto___22884 = G__22885;
continue;
} else {
}
break;
}

var G__22882 = args22880.length;
switch (G__22882) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22880.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__20617__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto__){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto__){
return (function (state_23052){
var state_val_23053 = (state_23052[(1)]);
if((state_val_23053 === (7))){
var inst_23048 = (state_23052[(2)]);
var state_23052__$1 = state_23052;
var statearr_23054_23095 = state_23052__$1;
(statearr_23054_23095[(2)] = inst_23048);

(statearr_23054_23095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23053 === (20))){
var inst_23018 = (state_23052[(7)]);
var inst_23029 = (state_23052[(2)]);
var inst_23030 = cljs.core.next.call(null,inst_23018);
var inst_23004 = inst_23030;
var inst_23005 = null;
var inst_23006 = (0);
var inst_23007 = (0);
var state_23052__$1 = (function (){var statearr_23055 = state_23052;
(statearr_23055[(8)] = inst_23029);

(statearr_23055[(9)] = inst_23004);

(statearr_23055[(10)] = inst_23005);

(statearr_23055[(11)] = inst_23007);

(statearr_23055[(12)] = inst_23006);

return statearr_23055;
})();
var statearr_23056_23096 = state_23052__$1;
(statearr_23056_23096[(2)] = null);

(statearr_23056_23096[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23053 === (1))){
var state_23052__$1 = state_23052;
var statearr_23057_23097 = state_23052__$1;
(statearr_23057_23097[(2)] = null);

(statearr_23057_23097[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23053 === (4))){
var inst_22993 = (state_23052[(13)]);
var inst_22993__$1 = (state_23052[(2)]);
var inst_22994 = (inst_22993__$1 == null);
var state_23052__$1 = (function (){var statearr_23058 = state_23052;
(statearr_23058[(13)] = inst_22993__$1);

return statearr_23058;
})();
if(cljs.core.truth_(inst_22994)){
var statearr_23059_23098 = state_23052__$1;
(statearr_23059_23098[(1)] = (5));

} else {
var statearr_23060_23099 = state_23052__$1;
(statearr_23060_23099[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23053 === (15))){
var state_23052__$1 = state_23052;
var statearr_23064_23100 = state_23052__$1;
(statearr_23064_23100[(2)] = null);

(statearr_23064_23100[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23053 === (21))){
var state_23052__$1 = state_23052;
var statearr_23065_23101 = state_23052__$1;
(statearr_23065_23101[(2)] = null);

(statearr_23065_23101[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23053 === (13))){
var inst_23004 = (state_23052[(9)]);
var inst_23005 = (state_23052[(10)]);
var inst_23007 = (state_23052[(11)]);
var inst_23006 = (state_23052[(12)]);
var inst_23014 = (state_23052[(2)]);
var inst_23015 = (inst_23007 + (1));
var tmp23061 = inst_23004;
var tmp23062 = inst_23005;
var tmp23063 = inst_23006;
var inst_23004__$1 = tmp23061;
var inst_23005__$1 = tmp23062;
var inst_23006__$1 = tmp23063;
var inst_23007__$1 = inst_23015;
var state_23052__$1 = (function (){var statearr_23066 = state_23052;
(statearr_23066[(9)] = inst_23004__$1);

(statearr_23066[(10)] = inst_23005__$1);

(statearr_23066[(11)] = inst_23007__$1);

(statearr_23066[(14)] = inst_23014);

(statearr_23066[(12)] = inst_23006__$1);

return statearr_23066;
})();
var statearr_23067_23102 = state_23052__$1;
(statearr_23067_23102[(2)] = null);

(statearr_23067_23102[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23053 === (22))){
var state_23052__$1 = state_23052;
var statearr_23068_23103 = state_23052__$1;
(statearr_23068_23103[(2)] = null);

(statearr_23068_23103[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23053 === (6))){
var inst_22993 = (state_23052[(13)]);
var inst_23002 = f.call(null,inst_22993);
var inst_23003 = cljs.core.seq.call(null,inst_23002);
var inst_23004 = inst_23003;
var inst_23005 = null;
var inst_23006 = (0);
var inst_23007 = (0);
var state_23052__$1 = (function (){var statearr_23069 = state_23052;
(statearr_23069[(9)] = inst_23004);

(statearr_23069[(10)] = inst_23005);

(statearr_23069[(11)] = inst_23007);

(statearr_23069[(12)] = inst_23006);

return statearr_23069;
})();
var statearr_23070_23104 = state_23052__$1;
(statearr_23070_23104[(2)] = null);

(statearr_23070_23104[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23053 === (17))){
var inst_23018 = (state_23052[(7)]);
var inst_23022 = cljs.core.chunk_first.call(null,inst_23018);
var inst_23023 = cljs.core.chunk_rest.call(null,inst_23018);
var inst_23024 = cljs.core.count.call(null,inst_23022);
var inst_23004 = inst_23023;
var inst_23005 = inst_23022;
var inst_23006 = inst_23024;
var inst_23007 = (0);
var state_23052__$1 = (function (){var statearr_23071 = state_23052;
(statearr_23071[(9)] = inst_23004);

(statearr_23071[(10)] = inst_23005);

(statearr_23071[(11)] = inst_23007);

(statearr_23071[(12)] = inst_23006);

return statearr_23071;
})();
var statearr_23072_23105 = state_23052__$1;
(statearr_23072_23105[(2)] = null);

(statearr_23072_23105[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23053 === (3))){
var inst_23050 = (state_23052[(2)]);
var state_23052__$1 = state_23052;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23052__$1,inst_23050);
} else {
if((state_val_23053 === (12))){
var inst_23038 = (state_23052[(2)]);
var state_23052__$1 = state_23052;
var statearr_23073_23106 = state_23052__$1;
(statearr_23073_23106[(2)] = inst_23038);

(statearr_23073_23106[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23053 === (2))){
var state_23052__$1 = state_23052;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23052__$1,(4),in$);
} else {
if((state_val_23053 === (23))){
var inst_23046 = (state_23052[(2)]);
var state_23052__$1 = state_23052;
var statearr_23074_23107 = state_23052__$1;
(statearr_23074_23107[(2)] = inst_23046);

(statearr_23074_23107[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23053 === (19))){
var inst_23033 = (state_23052[(2)]);
var state_23052__$1 = state_23052;
var statearr_23075_23108 = state_23052__$1;
(statearr_23075_23108[(2)] = inst_23033);

(statearr_23075_23108[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23053 === (11))){
var inst_23004 = (state_23052[(9)]);
var inst_23018 = (state_23052[(7)]);
var inst_23018__$1 = cljs.core.seq.call(null,inst_23004);
var state_23052__$1 = (function (){var statearr_23076 = state_23052;
(statearr_23076[(7)] = inst_23018__$1);

return statearr_23076;
})();
if(inst_23018__$1){
var statearr_23077_23109 = state_23052__$1;
(statearr_23077_23109[(1)] = (14));

} else {
var statearr_23078_23110 = state_23052__$1;
(statearr_23078_23110[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23053 === (9))){
var inst_23040 = (state_23052[(2)]);
var inst_23041 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_23052__$1 = (function (){var statearr_23079 = state_23052;
(statearr_23079[(15)] = inst_23040);

return statearr_23079;
})();
if(cljs.core.truth_(inst_23041)){
var statearr_23080_23111 = state_23052__$1;
(statearr_23080_23111[(1)] = (21));

} else {
var statearr_23081_23112 = state_23052__$1;
(statearr_23081_23112[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23053 === (5))){
var inst_22996 = cljs.core.async.close_BANG_.call(null,out);
var state_23052__$1 = state_23052;
var statearr_23082_23113 = state_23052__$1;
(statearr_23082_23113[(2)] = inst_22996);

(statearr_23082_23113[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23053 === (14))){
var inst_23018 = (state_23052[(7)]);
var inst_23020 = cljs.core.chunked_seq_QMARK_.call(null,inst_23018);
var state_23052__$1 = state_23052;
if(inst_23020){
var statearr_23083_23114 = state_23052__$1;
(statearr_23083_23114[(1)] = (17));

} else {
var statearr_23084_23115 = state_23052__$1;
(statearr_23084_23115[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23053 === (16))){
var inst_23036 = (state_23052[(2)]);
var state_23052__$1 = state_23052;
var statearr_23085_23116 = state_23052__$1;
(statearr_23085_23116[(2)] = inst_23036);

(statearr_23085_23116[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23053 === (10))){
var inst_23005 = (state_23052[(10)]);
var inst_23007 = (state_23052[(11)]);
var inst_23012 = cljs.core._nth.call(null,inst_23005,inst_23007);
var state_23052__$1 = state_23052;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23052__$1,(13),out,inst_23012);
} else {
if((state_val_23053 === (18))){
var inst_23018 = (state_23052[(7)]);
var inst_23027 = cljs.core.first.call(null,inst_23018);
var state_23052__$1 = state_23052;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23052__$1,(20),out,inst_23027);
} else {
if((state_val_23053 === (8))){
var inst_23007 = (state_23052[(11)]);
var inst_23006 = (state_23052[(12)]);
var inst_23009 = (inst_23007 < inst_23006);
var inst_23010 = inst_23009;
var state_23052__$1 = state_23052;
if(cljs.core.truth_(inst_23010)){
var statearr_23086_23117 = state_23052__$1;
(statearr_23086_23117[(1)] = (10));

} else {
var statearr_23087_23118 = state_23052__$1;
(statearr_23087_23118[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto__))
;
return ((function (switch__20505__auto__,c__20617__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__20506__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__20506__auto____0 = (function (){
var statearr_23091 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23091[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__20506__auto__);

(statearr_23091[(1)] = (1));

return statearr_23091;
});
var cljs$core$async$mapcat_STAR__$_state_machine__20506__auto____1 = (function (state_23052){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_23052);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e23092){if((e23092 instanceof Object)){
var ex__20509__auto__ = e23092;
var statearr_23093_23119 = state_23052;
(statearr_23093_23119[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23052);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23092;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23120 = state_23052;
state_23052 = G__23120;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__20506__auto__ = function(state_23052){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__20506__auto____1.call(this,state_23052);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__20506__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__20506__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto__))
})();
var state__20619__auto__ = (function (){var statearr_23094 = f__20618__auto__.call(null);
(statearr_23094[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto__);

return statearr_23094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto__))
);

return c__20617__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args23121 = [];
var len__19260__auto___23124 = arguments.length;
var i__19261__auto___23125 = (0);
while(true){
if((i__19261__auto___23125 < len__19260__auto___23124)){
args23121.push((arguments[i__19261__auto___23125]));

var G__23126 = (i__19261__auto___23125 + (1));
i__19261__auto___23125 = G__23126;
continue;
} else {
}
break;
}

var G__23123 = args23121.length;
switch (G__23123) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23121.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args23128 = [];
var len__19260__auto___23131 = arguments.length;
var i__19261__auto___23132 = (0);
while(true){
if((i__19261__auto___23132 < len__19260__auto___23131)){
args23128.push((arguments[i__19261__auto___23132]));

var G__23133 = (i__19261__auto___23132 + (1));
i__19261__auto___23132 = G__23133;
continue;
} else {
}
break;
}

var G__23130 = args23128.length;
switch (G__23130) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23128.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args23135 = [];
var len__19260__auto___23186 = arguments.length;
var i__19261__auto___23187 = (0);
while(true){
if((i__19261__auto___23187 < len__19260__auto___23186)){
args23135.push((arguments[i__19261__auto___23187]));

var G__23188 = (i__19261__auto___23187 + (1));
i__19261__auto___23187 = G__23188;
continue;
} else {
}
break;
}

var G__23137 = args23135.length;
switch (G__23137) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23135.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20617__auto___23190 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto___23190,out){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto___23190,out){
return (function (state_23161){
var state_val_23162 = (state_23161[(1)]);
if((state_val_23162 === (7))){
var inst_23156 = (state_23161[(2)]);
var state_23161__$1 = state_23161;
var statearr_23163_23191 = state_23161__$1;
(statearr_23163_23191[(2)] = inst_23156);

(statearr_23163_23191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23162 === (1))){
var inst_23138 = null;
var state_23161__$1 = (function (){var statearr_23164 = state_23161;
(statearr_23164[(7)] = inst_23138);

return statearr_23164;
})();
var statearr_23165_23192 = state_23161__$1;
(statearr_23165_23192[(2)] = null);

(statearr_23165_23192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23162 === (4))){
var inst_23141 = (state_23161[(8)]);
var inst_23141__$1 = (state_23161[(2)]);
var inst_23142 = (inst_23141__$1 == null);
var inst_23143 = cljs.core.not.call(null,inst_23142);
var state_23161__$1 = (function (){var statearr_23166 = state_23161;
(statearr_23166[(8)] = inst_23141__$1);

return statearr_23166;
})();
if(inst_23143){
var statearr_23167_23193 = state_23161__$1;
(statearr_23167_23193[(1)] = (5));

} else {
var statearr_23168_23194 = state_23161__$1;
(statearr_23168_23194[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23162 === (6))){
var state_23161__$1 = state_23161;
var statearr_23169_23195 = state_23161__$1;
(statearr_23169_23195[(2)] = null);

(statearr_23169_23195[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23162 === (3))){
var inst_23158 = (state_23161[(2)]);
var inst_23159 = cljs.core.async.close_BANG_.call(null,out);
var state_23161__$1 = (function (){var statearr_23170 = state_23161;
(statearr_23170[(9)] = inst_23158);

return statearr_23170;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23161__$1,inst_23159);
} else {
if((state_val_23162 === (2))){
var state_23161__$1 = state_23161;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23161__$1,(4),ch);
} else {
if((state_val_23162 === (11))){
var inst_23141 = (state_23161[(8)]);
var inst_23150 = (state_23161[(2)]);
var inst_23138 = inst_23141;
var state_23161__$1 = (function (){var statearr_23171 = state_23161;
(statearr_23171[(7)] = inst_23138);

(statearr_23171[(10)] = inst_23150);

return statearr_23171;
})();
var statearr_23172_23196 = state_23161__$1;
(statearr_23172_23196[(2)] = null);

(statearr_23172_23196[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23162 === (9))){
var inst_23141 = (state_23161[(8)]);
var state_23161__$1 = state_23161;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23161__$1,(11),out,inst_23141);
} else {
if((state_val_23162 === (5))){
var inst_23138 = (state_23161[(7)]);
var inst_23141 = (state_23161[(8)]);
var inst_23145 = cljs.core._EQ_.call(null,inst_23141,inst_23138);
var state_23161__$1 = state_23161;
if(inst_23145){
var statearr_23174_23197 = state_23161__$1;
(statearr_23174_23197[(1)] = (8));

} else {
var statearr_23175_23198 = state_23161__$1;
(statearr_23175_23198[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23162 === (10))){
var inst_23153 = (state_23161[(2)]);
var state_23161__$1 = state_23161;
var statearr_23176_23199 = state_23161__$1;
(statearr_23176_23199[(2)] = inst_23153);

(statearr_23176_23199[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23162 === (8))){
var inst_23138 = (state_23161[(7)]);
var tmp23173 = inst_23138;
var inst_23138__$1 = tmp23173;
var state_23161__$1 = (function (){var statearr_23177 = state_23161;
(statearr_23177[(7)] = inst_23138__$1);

return statearr_23177;
})();
var statearr_23178_23200 = state_23161__$1;
(statearr_23178_23200[(2)] = null);

(statearr_23178_23200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto___23190,out))
;
return ((function (switch__20505__auto__,c__20617__auto___23190,out){
return (function() {
var cljs$core$async$state_machine__20506__auto__ = null;
var cljs$core$async$state_machine__20506__auto____0 = (function (){
var statearr_23182 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23182[(0)] = cljs$core$async$state_machine__20506__auto__);

(statearr_23182[(1)] = (1));

return statearr_23182;
});
var cljs$core$async$state_machine__20506__auto____1 = (function (state_23161){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_23161);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e23183){if((e23183 instanceof Object)){
var ex__20509__auto__ = e23183;
var statearr_23184_23201 = state_23161;
(statearr_23184_23201[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23161);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23183;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23202 = state_23161;
state_23161 = G__23202;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$state_machine__20506__auto__ = function(state_23161){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20506__auto____1.call(this,state_23161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20506__auto____0;
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20506__auto____1;
return cljs$core$async$state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto___23190,out))
})();
var state__20619__auto__ = (function (){var statearr_23185 = f__20618__auto__.call(null);
(statearr_23185[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto___23190);

return statearr_23185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto___23190,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args23203 = [];
var len__19260__auto___23273 = arguments.length;
var i__19261__auto___23274 = (0);
while(true){
if((i__19261__auto___23274 < len__19260__auto___23273)){
args23203.push((arguments[i__19261__auto___23274]));

var G__23275 = (i__19261__auto___23274 + (1));
i__19261__auto___23274 = G__23275;
continue;
} else {
}
break;
}

var G__23205 = args23203.length;
switch (G__23205) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23203.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20617__auto___23277 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto___23277,out){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto___23277,out){
return (function (state_23243){
var state_val_23244 = (state_23243[(1)]);
if((state_val_23244 === (7))){
var inst_23239 = (state_23243[(2)]);
var state_23243__$1 = state_23243;
var statearr_23245_23278 = state_23243__$1;
(statearr_23245_23278[(2)] = inst_23239);

(statearr_23245_23278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23244 === (1))){
var inst_23206 = (new Array(n));
var inst_23207 = inst_23206;
var inst_23208 = (0);
var state_23243__$1 = (function (){var statearr_23246 = state_23243;
(statearr_23246[(7)] = inst_23207);

(statearr_23246[(8)] = inst_23208);

return statearr_23246;
})();
var statearr_23247_23279 = state_23243__$1;
(statearr_23247_23279[(2)] = null);

(statearr_23247_23279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23244 === (4))){
var inst_23211 = (state_23243[(9)]);
var inst_23211__$1 = (state_23243[(2)]);
var inst_23212 = (inst_23211__$1 == null);
var inst_23213 = cljs.core.not.call(null,inst_23212);
var state_23243__$1 = (function (){var statearr_23248 = state_23243;
(statearr_23248[(9)] = inst_23211__$1);

return statearr_23248;
})();
if(inst_23213){
var statearr_23249_23280 = state_23243__$1;
(statearr_23249_23280[(1)] = (5));

} else {
var statearr_23250_23281 = state_23243__$1;
(statearr_23250_23281[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23244 === (15))){
var inst_23233 = (state_23243[(2)]);
var state_23243__$1 = state_23243;
var statearr_23251_23282 = state_23243__$1;
(statearr_23251_23282[(2)] = inst_23233);

(statearr_23251_23282[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23244 === (13))){
var state_23243__$1 = state_23243;
var statearr_23252_23283 = state_23243__$1;
(statearr_23252_23283[(2)] = null);

(statearr_23252_23283[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23244 === (6))){
var inst_23208 = (state_23243[(8)]);
var inst_23229 = (inst_23208 > (0));
var state_23243__$1 = state_23243;
if(cljs.core.truth_(inst_23229)){
var statearr_23253_23284 = state_23243__$1;
(statearr_23253_23284[(1)] = (12));

} else {
var statearr_23254_23285 = state_23243__$1;
(statearr_23254_23285[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23244 === (3))){
var inst_23241 = (state_23243[(2)]);
var state_23243__$1 = state_23243;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23243__$1,inst_23241);
} else {
if((state_val_23244 === (12))){
var inst_23207 = (state_23243[(7)]);
var inst_23231 = cljs.core.vec.call(null,inst_23207);
var state_23243__$1 = state_23243;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23243__$1,(15),out,inst_23231);
} else {
if((state_val_23244 === (2))){
var state_23243__$1 = state_23243;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23243__$1,(4),ch);
} else {
if((state_val_23244 === (11))){
var inst_23223 = (state_23243[(2)]);
var inst_23224 = (new Array(n));
var inst_23207 = inst_23224;
var inst_23208 = (0);
var state_23243__$1 = (function (){var statearr_23255 = state_23243;
(statearr_23255[(10)] = inst_23223);

(statearr_23255[(7)] = inst_23207);

(statearr_23255[(8)] = inst_23208);

return statearr_23255;
})();
var statearr_23256_23286 = state_23243__$1;
(statearr_23256_23286[(2)] = null);

(statearr_23256_23286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23244 === (9))){
var inst_23207 = (state_23243[(7)]);
var inst_23221 = cljs.core.vec.call(null,inst_23207);
var state_23243__$1 = state_23243;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23243__$1,(11),out,inst_23221);
} else {
if((state_val_23244 === (5))){
var inst_23216 = (state_23243[(11)]);
var inst_23207 = (state_23243[(7)]);
var inst_23208 = (state_23243[(8)]);
var inst_23211 = (state_23243[(9)]);
var inst_23215 = (inst_23207[inst_23208] = inst_23211);
var inst_23216__$1 = (inst_23208 + (1));
var inst_23217 = (inst_23216__$1 < n);
var state_23243__$1 = (function (){var statearr_23257 = state_23243;
(statearr_23257[(11)] = inst_23216__$1);

(statearr_23257[(12)] = inst_23215);

return statearr_23257;
})();
if(cljs.core.truth_(inst_23217)){
var statearr_23258_23287 = state_23243__$1;
(statearr_23258_23287[(1)] = (8));

} else {
var statearr_23259_23288 = state_23243__$1;
(statearr_23259_23288[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23244 === (14))){
var inst_23236 = (state_23243[(2)]);
var inst_23237 = cljs.core.async.close_BANG_.call(null,out);
var state_23243__$1 = (function (){var statearr_23261 = state_23243;
(statearr_23261[(13)] = inst_23236);

return statearr_23261;
})();
var statearr_23262_23289 = state_23243__$1;
(statearr_23262_23289[(2)] = inst_23237);

(statearr_23262_23289[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23244 === (10))){
var inst_23227 = (state_23243[(2)]);
var state_23243__$1 = state_23243;
var statearr_23263_23290 = state_23243__$1;
(statearr_23263_23290[(2)] = inst_23227);

(statearr_23263_23290[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23244 === (8))){
var inst_23216 = (state_23243[(11)]);
var inst_23207 = (state_23243[(7)]);
var tmp23260 = inst_23207;
var inst_23207__$1 = tmp23260;
var inst_23208 = inst_23216;
var state_23243__$1 = (function (){var statearr_23264 = state_23243;
(statearr_23264[(7)] = inst_23207__$1);

(statearr_23264[(8)] = inst_23208);

return statearr_23264;
})();
var statearr_23265_23291 = state_23243__$1;
(statearr_23265_23291[(2)] = null);

(statearr_23265_23291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto___23277,out))
;
return ((function (switch__20505__auto__,c__20617__auto___23277,out){
return (function() {
var cljs$core$async$state_machine__20506__auto__ = null;
var cljs$core$async$state_machine__20506__auto____0 = (function (){
var statearr_23269 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23269[(0)] = cljs$core$async$state_machine__20506__auto__);

(statearr_23269[(1)] = (1));

return statearr_23269;
});
var cljs$core$async$state_machine__20506__auto____1 = (function (state_23243){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_23243);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e23270){if((e23270 instanceof Object)){
var ex__20509__auto__ = e23270;
var statearr_23271_23292 = state_23243;
(statearr_23271_23292[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23243);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23270;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23293 = state_23243;
state_23243 = G__23293;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$state_machine__20506__auto__ = function(state_23243){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20506__auto____1.call(this,state_23243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20506__auto____0;
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20506__auto____1;
return cljs$core$async$state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto___23277,out))
})();
var state__20619__auto__ = (function (){var statearr_23272 = f__20618__auto__.call(null);
(statearr_23272[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto___23277);

return statearr_23272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto___23277,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args23294 = [];
var len__19260__auto___23368 = arguments.length;
var i__19261__auto___23369 = (0);
while(true){
if((i__19261__auto___23369 < len__19260__auto___23368)){
args23294.push((arguments[i__19261__auto___23369]));

var G__23370 = (i__19261__auto___23369 + (1));
i__19261__auto___23369 = G__23370;
continue;
} else {
}
break;
}

var G__23296 = args23294.length;
switch (G__23296) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23294.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20617__auto___23372 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20617__auto___23372,out){
return (function (){
var f__20618__auto__ = (function (){var switch__20505__auto__ = ((function (c__20617__auto___23372,out){
return (function (state_23338){
var state_val_23339 = (state_23338[(1)]);
if((state_val_23339 === (7))){
var inst_23334 = (state_23338[(2)]);
var state_23338__$1 = state_23338;
var statearr_23340_23373 = state_23338__$1;
(statearr_23340_23373[(2)] = inst_23334);

(statearr_23340_23373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23339 === (1))){
var inst_23297 = [];
var inst_23298 = inst_23297;
var inst_23299 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_23338__$1 = (function (){var statearr_23341 = state_23338;
(statearr_23341[(7)] = inst_23298);

(statearr_23341[(8)] = inst_23299);

return statearr_23341;
})();
var statearr_23342_23374 = state_23338__$1;
(statearr_23342_23374[(2)] = null);

(statearr_23342_23374[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23339 === (4))){
var inst_23302 = (state_23338[(9)]);
var inst_23302__$1 = (state_23338[(2)]);
var inst_23303 = (inst_23302__$1 == null);
var inst_23304 = cljs.core.not.call(null,inst_23303);
var state_23338__$1 = (function (){var statearr_23343 = state_23338;
(statearr_23343[(9)] = inst_23302__$1);

return statearr_23343;
})();
if(inst_23304){
var statearr_23344_23375 = state_23338__$1;
(statearr_23344_23375[(1)] = (5));

} else {
var statearr_23345_23376 = state_23338__$1;
(statearr_23345_23376[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23339 === (15))){
var inst_23328 = (state_23338[(2)]);
var state_23338__$1 = state_23338;
var statearr_23346_23377 = state_23338__$1;
(statearr_23346_23377[(2)] = inst_23328);

(statearr_23346_23377[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23339 === (13))){
var state_23338__$1 = state_23338;
var statearr_23347_23378 = state_23338__$1;
(statearr_23347_23378[(2)] = null);

(statearr_23347_23378[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23339 === (6))){
var inst_23298 = (state_23338[(7)]);
var inst_23323 = inst_23298.length;
var inst_23324 = (inst_23323 > (0));
var state_23338__$1 = state_23338;
if(cljs.core.truth_(inst_23324)){
var statearr_23348_23379 = state_23338__$1;
(statearr_23348_23379[(1)] = (12));

} else {
var statearr_23349_23380 = state_23338__$1;
(statearr_23349_23380[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23339 === (3))){
var inst_23336 = (state_23338[(2)]);
var state_23338__$1 = state_23338;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23338__$1,inst_23336);
} else {
if((state_val_23339 === (12))){
var inst_23298 = (state_23338[(7)]);
var inst_23326 = cljs.core.vec.call(null,inst_23298);
var state_23338__$1 = state_23338;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23338__$1,(15),out,inst_23326);
} else {
if((state_val_23339 === (2))){
var state_23338__$1 = state_23338;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23338__$1,(4),ch);
} else {
if((state_val_23339 === (11))){
var inst_23302 = (state_23338[(9)]);
var inst_23306 = (state_23338[(10)]);
var inst_23316 = (state_23338[(2)]);
var inst_23317 = [];
var inst_23318 = inst_23317.push(inst_23302);
var inst_23298 = inst_23317;
var inst_23299 = inst_23306;
var state_23338__$1 = (function (){var statearr_23350 = state_23338;
(statearr_23350[(7)] = inst_23298);

(statearr_23350[(11)] = inst_23316);

(statearr_23350[(12)] = inst_23318);

(statearr_23350[(8)] = inst_23299);

return statearr_23350;
})();
var statearr_23351_23381 = state_23338__$1;
(statearr_23351_23381[(2)] = null);

(statearr_23351_23381[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23339 === (9))){
var inst_23298 = (state_23338[(7)]);
var inst_23314 = cljs.core.vec.call(null,inst_23298);
var state_23338__$1 = state_23338;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23338__$1,(11),out,inst_23314);
} else {
if((state_val_23339 === (5))){
var inst_23302 = (state_23338[(9)]);
var inst_23306 = (state_23338[(10)]);
var inst_23299 = (state_23338[(8)]);
var inst_23306__$1 = f.call(null,inst_23302);
var inst_23307 = cljs.core._EQ_.call(null,inst_23306__$1,inst_23299);
var inst_23308 = cljs.core.keyword_identical_QMARK_.call(null,inst_23299,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_23309 = (inst_23307) || (inst_23308);
var state_23338__$1 = (function (){var statearr_23352 = state_23338;
(statearr_23352[(10)] = inst_23306__$1);

return statearr_23352;
})();
if(cljs.core.truth_(inst_23309)){
var statearr_23353_23382 = state_23338__$1;
(statearr_23353_23382[(1)] = (8));

} else {
var statearr_23354_23383 = state_23338__$1;
(statearr_23354_23383[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23339 === (14))){
var inst_23331 = (state_23338[(2)]);
var inst_23332 = cljs.core.async.close_BANG_.call(null,out);
var state_23338__$1 = (function (){var statearr_23356 = state_23338;
(statearr_23356[(13)] = inst_23331);

return statearr_23356;
})();
var statearr_23357_23384 = state_23338__$1;
(statearr_23357_23384[(2)] = inst_23332);

(statearr_23357_23384[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23339 === (10))){
var inst_23321 = (state_23338[(2)]);
var state_23338__$1 = state_23338;
var statearr_23358_23385 = state_23338__$1;
(statearr_23358_23385[(2)] = inst_23321);

(statearr_23358_23385[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23339 === (8))){
var inst_23298 = (state_23338[(7)]);
var inst_23302 = (state_23338[(9)]);
var inst_23306 = (state_23338[(10)]);
var inst_23311 = inst_23298.push(inst_23302);
var tmp23355 = inst_23298;
var inst_23298__$1 = tmp23355;
var inst_23299 = inst_23306;
var state_23338__$1 = (function (){var statearr_23359 = state_23338;
(statearr_23359[(7)] = inst_23298__$1);

(statearr_23359[(14)] = inst_23311);

(statearr_23359[(8)] = inst_23299);

return statearr_23359;
})();
var statearr_23360_23386 = state_23338__$1;
(statearr_23360_23386[(2)] = null);

(statearr_23360_23386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20617__auto___23372,out))
;
return ((function (switch__20505__auto__,c__20617__auto___23372,out){
return (function() {
var cljs$core$async$state_machine__20506__auto__ = null;
var cljs$core$async$state_machine__20506__auto____0 = (function (){
var statearr_23364 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23364[(0)] = cljs$core$async$state_machine__20506__auto__);

(statearr_23364[(1)] = (1));

return statearr_23364;
});
var cljs$core$async$state_machine__20506__auto____1 = (function (state_23338){
while(true){
var ret_value__20507__auto__ = (function (){try{while(true){
var result__20508__auto__ = switch__20505__auto__.call(null,state_23338);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20508__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20508__auto__;
}
break;
}
}catch (e23365){if((e23365 instanceof Object)){
var ex__20509__auto__ = e23365;
var statearr_23366_23387 = state_23338;
(statearr_23366_23387[(5)] = ex__20509__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23338);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23365;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20507__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23388 = state_23338;
state_23338 = G__23388;
continue;
} else {
return ret_value__20507__auto__;
}
break;
}
});
cljs$core$async$state_machine__20506__auto__ = function(state_23338){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20506__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20506__auto____1.call(this,state_23338);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20506__auto____0;
cljs$core$async$state_machine__20506__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20506__auto____1;
return cljs$core$async$state_machine__20506__auto__;
})()
;})(switch__20505__auto__,c__20617__auto___23372,out))
})();
var state__20619__auto__ = (function (){var statearr_23367 = f__20618__auto__.call(null);
(statearr_23367[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20617__auto___23372);

return statearr_23367;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20619__auto__);
});})(c__20617__auto___23372,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map