// Compiled by ClojureScript 1.7.228 {}
goog.provide('gadjett.core');
goog.require('cljs.core');
if(typeof gadjett.core.history !== 'undefined'){
} else {
gadjett.core.history = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
gadjett.core.max_function_calls = (50);
gadjett.core.timeslot_function_calls_msec = (1000);
gadjett.core.add_event_and_filter = (function gadjett$core$add_event_and_filter(timestamp_msec,events){
return cljs.core.cons.call(null,timestamp_msec,cljs.core.take_while.call(null,(function (p1__20497_SHARP_){
return (p1__20497_SHARP_ > (timestamp_msec - gadjett.core.timeslot_function_calls_msec));
}),events));
});
gadjett.core.add_event = (function gadjett$core$add_event(history,func_name,timestamp_msec){
return cljs.core.update.call(null,history,func_name,cljs.core.partial.call(null,gadjett.core.add_event_and_filter,timestamp_msec));
});
gadjett.core.record_function_call = (function gadjett$core$record_function_call(func_name){
cljs.core.swap_BANG_.call(null,gadjett.core.history,gadjett.core.add_event,func_name,(new Date()).valueOf());

return (cljs.core.count.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,gadjett.core.history),func_name)) <= gadjett.core.max_function_calls);
});
/**
 * returns the history sorted by number of function calls
 */
gadjett.core.sort_history = (function gadjett$core$sort_history(hist){
return cljs.core.reverse.call(null,cljs.core.sort_by.call(null,cljs.core.comp.call(null,cljs.core.count,cljs.core.second),hist));
});
/**
 * returns the history as an array, sorted by number of function calls
 */
gadjett.core.the_history = (function gadjett$core$the_history(var_args){
var args20498 = [];
var len__19260__auto___20501 = arguments.length;
var i__19261__auto___20502 = (0);
while(true){
if((i__19261__auto___20502 < len__19260__auto___20501)){
args20498.push((arguments[i__19261__auto___20502]));

var G__20503 = (i__19261__auto___20502 + (1));
i__19261__auto___20502 = G__20503;
continue;
} else {
}
break;
}

var G__20500 = args20498.length;
switch (G__20500) {
case 1:
return gadjett.core.the_history.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return gadjett.core.the_history.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20498.length)].join('')));

}
});

gadjett.core.the_history.cljs$core$IFn$_invoke$arity$1 = (function (k){
return cljs.core.get.call(null,cljs.core.deref.call(null,gadjett.core.history),k);
});

gadjett.core.the_history.cljs$core$IFn$_invoke$arity$0 = (function (){
return gadjett.core.sort_history.call(null,cljs.core.deref.call(null,gadjett.core.history));
});

gadjett.core.the_history.cljs$lang$maxFixedArity = 1;
gadjett.core.function_call_err_msg = (function gadjett$core$function_call_err_msg(func_name){
return [cljs.core.str(func_name),cljs.core.str(" was called too much: "),cljs.core.str(gadjett.core.max_function_calls),cljs.core.str(" times over the last "),cljs.core.str(gadjett.core.timeslot_function_calls_msec),cljs.core.str(" msec.")].join('');
});

//# sourceMappingURL=core.js.map