// Compiled by ClojureScript 1.7.228 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__18202__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__18202__auto__){
return or__18202__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__18202__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__23236_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__23236_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__23241 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__23242 = null;
var count__23243 = (0);
var i__23244 = (0);
while(true){
if((i__23244 < count__23243)){
var n = cljs.core._nth.call(null,chunk__23242,i__23244);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__23245 = seq__23241;
var G__23246 = chunk__23242;
var G__23247 = count__23243;
var G__23248 = (i__23244 + (1));
seq__23241 = G__23245;
chunk__23242 = G__23246;
count__23243 = G__23247;
i__23244 = G__23248;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__23241);
if(temp__4425__auto__){
var seq__23241__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23241__$1)){
var c__19005__auto__ = cljs.core.chunk_first.call(null,seq__23241__$1);
var G__23249 = cljs.core.chunk_rest.call(null,seq__23241__$1);
var G__23250 = c__19005__auto__;
var G__23251 = cljs.core.count.call(null,c__19005__auto__);
var G__23252 = (0);
seq__23241 = G__23249;
chunk__23242 = G__23250;
count__23243 = G__23251;
i__23244 = G__23252;
continue;
} else {
var n = cljs.core.first.call(null,seq__23241__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__23253 = cljs.core.next.call(null,seq__23241__$1);
var G__23254 = null;
var G__23255 = (0);
var G__23256 = (0);
seq__23241 = G__23253;
chunk__23242 = G__23254;
count__23243 = G__23255;
i__23244 = G__23256;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__23295_23302 = cljs.core.seq.call(null,deps);
var chunk__23296_23303 = null;
var count__23297_23304 = (0);
var i__23298_23305 = (0);
while(true){
if((i__23298_23305 < count__23297_23304)){
var dep_23306 = cljs.core._nth.call(null,chunk__23296_23303,i__23298_23305);
topo_sort_helper_STAR_.call(null,dep_23306,(depth + (1)),state);

var G__23307 = seq__23295_23302;
var G__23308 = chunk__23296_23303;
var G__23309 = count__23297_23304;
var G__23310 = (i__23298_23305 + (1));
seq__23295_23302 = G__23307;
chunk__23296_23303 = G__23308;
count__23297_23304 = G__23309;
i__23298_23305 = G__23310;
continue;
} else {
var temp__4425__auto___23311 = cljs.core.seq.call(null,seq__23295_23302);
if(temp__4425__auto___23311){
var seq__23295_23312__$1 = temp__4425__auto___23311;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23295_23312__$1)){
var c__19005__auto___23313 = cljs.core.chunk_first.call(null,seq__23295_23312__$1);
var G__23314 = cljs.core.chunk_rest.call(null,seq__23295_23312__$1);
var G__23315 = c__19005__auto___23313;
var G__23316 = cljs.core.count.call(null,c__19005__auto___23313);
var G__23317 = (0);
seq__23295_23302 = G__23314;
chunk__23296_23303 = G__23315;
count__23297_23304 = G__23316;
i__23298_23305 = G__23317;
continue;
} else {
var dep_23318 = cljs.core.first.call(null,seq__23295_23312__$1);
topo_sort_helper_STAR_.call(null,dep_23318,(depth + (1)),state);

var G__23319 = cljs.core.next.call(null,seq__23295_23312__$1);
var G__23320 = null;
var G__23321 = (0);
var G__23322 = (0);
seq__23295_23302 = G__23319;
chunk__23296_23303 = G__23320;
count__23297_23304 = G__23321;
i__23298_23305 = G__23322;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__23299){
var vec__23301 = p__23299;
var x = cljs.core.nth.call(null,vec__23301,(0),null);
var xs = cljs.core.nthnext.call(null,vec__23301,(1));
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__23301,x,xs,get_deps__$1){
return (function (p1__23257_SHARP_){
return clojure.set.difference.call(null,p1__23257_SHARP_,x);
});})(vec__23301,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__23335 = cljs.core.seq.call(null,provides);
var chunk__23336 = null;
var count__23337 = (0);
var i__23338 = (0);
while(true){
if((i__23338 < count__23337)){
var prov = cljs.core._nth.call(null,chunk__23336,i__23338);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__23339_23347 = cljs.core.seq.call(null,requires);
var chunk__23340_23348 = null;
var count__23341_23349 = (0);
var i__23342_23350 = (0);
while(true){
if((i__23342_23350 < count__23341_23349)){
var req_23351 = cljs.core._nth.call(null,chunk__23340_23348,i__23342_23350);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_23351,prov);

var G__23352 = seq__23339_23347;
var G__23353 = chunk__23340_23348;
var G__23354 = count__23341_23349;
var G__23355 = (i__23342_23350 + (1));
seq__23339_23347 = G__23352;
chunk__23340_23348 = G__23353;
count__23341_23349 = G__23354;
i__23342_23350 = G__23355;
continue;
} else {
var temp__4425__auto___23356 = cljs.core.seq.call(null,seq__23339_23347);
if(temp__4425__auto___23356){
var seq__23339_23357__$1 = temp__4425__auto___23356;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23339_23357__$1)){
var c__19005__auto___23358 = cljs.core.chunk_first.call(null,seq__23339_23357__$1);
var G__23359 = cljs.core.chunk_rest.call(null,seq__23339_23357__$1);
var G__23360 = c__19005__auto___23358;
var G__23361 = cljs.core.count.call(null,c__19005__auto___23358);
var G__23362 = (0);
seq__23339_23347 = G__23359;
chunk__23340_23348 = G__23360;
count__23341_23349 = G__23361;
i__23342_23350 = G__23362;
continue;
} else {
var req_23363 = cljs.core.first.call(null,seq__23339_23357__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_23363,prov);

var G__23364 = cljs.core.next.call(null,seq__23339_23357__$1);
var G__23365 = null;
var G__23366 = (0);
var G__23367 = (0);
seq__23339_23347 = G__23364;
chunk__23340_23348 = G__23365;
count__23341_23349 = G__23366;
i__23342_23350 = G__23367;
continue;
}
} else {
}
}
break;
}

var G__23368 = seq__23335;
var G__23369 = chunk__23336;
var G__23370 = count__23337;
var G__23371 = (i__23338 + (1));
seq__23335 = G__23368;
chunk__23336 = G__23369;
count__23337 = G__23370;
i__23338 = G__23371;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__23335);
if(temp__4425__auto__){
var seq__23335__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23335__$1)){
var c__19005__auto__ = cljs.core.chunk_first.call(null,seq__23335__$1);
var G__23372 = cljs.core.chunk_rest.call(null,seq__23335__$1);
var G__23373 = c__19005__auto__;
var G__23374 = cljs.core.count.call(null,c__19005__auto__);
var G__23375 = (0);
seq__23335 = G__23372;
chunk__23336 = G__23373;
count__23337 = G__23374;
i__23338 = G__23375;
continue;
} else {
var prov = cljs.core.first.call(null,seq__23335__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__23343_23376 = cljs.core.seq.call(null,requires);
var chunk__23344_23377 = null;
var count__23345_23378 = (0);
var i__23346_23379 = (0);
while(true){
if((i__23346_23379 < count__23345_23378)){
var req_23380 = cljs.core._nth.call(null,chunk__23344_23377,i__23346_23379);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_23380,prov);

var G__23381 = seq__23343_23376;
var G__23382 = chunk__23344_23377;
var G__23383 = count__23345_23378;
var G__23384 = (i__23346_23379 + (1));
seq__23343_23376 = G__23381;
chunk__23344_23377 = G__23382;
count__23345_23378 = G__23383;
i__23346_23379 = G__23384;
continue;
} else {
var temp__4425__auto___23385__$1 = cljs.core.seq.call(null,seq__23343_23376);
if(temp__4425__auto___23385__$1){
var seq__23343_23386__$1 = temp__4425__auto___23385__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23343_23386__$1)){
var c__19005__auto___23387 = cljs.core.chunk_first.call(null,seq__23343_23386__$1);
var G__23388 = cljs.core.chunk_rest.call(null,seq__23343_23386__$1);
var G__23389 = c__19005__auto___23387;
var G__23390 = cljs.core.count.call(null,c__19005__auto___23387);
var G__23391 = (0);
seq__23343_23376 = G__23388;
chunk__23344_23377 = G__23389;
count__23345_23378 = G__23390;
i__23346_23379 = G__23391;
continue;
} else {
var req_23392 = cljs.core.first.call(null,seq__23343_23386__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_23392,prov);

var G__23393 = cljs.core.next.call(null,seq__23343_23386__$1);
var G__23394 = null;
var G__23395 = (0);
var G__23396 = (0);
seq__23343_23376 = G__23393;
chunk__23344_23377 = G__23394;
count__23345_23378 = G__23395;
i__23346_23379 = G__23396;
continue;
}
} else {
}
}
break;
}

var G__23397 = cljs.core.next.call(null,seq__23335__$1);
var G__23398 = null;
var G__23399 = (0);
var G__23400 = (0);
seq__23335 = G__23397;
chunk__23336 = G__23398;
count__23337 = G__23399;
i__23338 = G__23400;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel$client$file_reloading$figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__23405_23409 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__23406_23410 = null;
var count__23407_23411 = (0);
var i__23408_23412 = (0);
while(true){
if((i__23408_23412 < count__23407_23411)){
var ns_23413 = cljs.core._nth.call(null,chunk__23406_23410,i__23408_23412);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_23413);

var G__23414 = seq__23405_23409;
var G__23415 = chunk__23406_23410;
var G__23416 = count__23407_23411;
var G__23417 = (i__23408_23412 + (1));
seq__23405_23409 = G__23414;
chunk__23406_23410 = G__23415;
count__23407_23411 = G__23416;
i__23408_23412 = G__23417;
continue;
} else {
var temp__4425__auto___23418 = cljs.core.seq.call(null,seq__23405_23409);
if(temp__4425__auto___23418){
var seq__23405_23419__$1 = temp__4425__auto___23418;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23405_23419__$1)){
var c__19005__auto___23420 = cljs.core.chunk_first.call(null,seq__23405_23419__$1);
var G__23421 = cljs.core.chunk_rest.call(null,seq__23405_23419__$1);
var G__23422 = c__19005__auto___23420;
var G__23423 = cljs.core.count.call(null,c__19005__auto___23420);
var G__23424 = (0);
seq__23405_23409 = G__23421;
chunk__23406_23410 = G__23422;
count__23407_23411 = G__23423;
i__23408_23412 = G__23424;
continue;
} else {
var ns_23425 = cljs.core.first.call(null,seq__23405_23419__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_23425);

var G__23426 = cljs.core.next.call(null,seq__23405_23419__$1);
var G__23427 = null;
var G__23428 = (0);
var G__23429 = (0);
seq__23405_23409 = G__23426;
chunk__23406_23410 = G__23427;
count__23407_23411 = G__23428;
i__23408_23412 = G__23429;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__18202__auto__ = goog.require__;
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__23430__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__23430 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__23431__i = 0, G__23431__a = new Array(arguments.length -  0);
while (G__23431__i < G__23431__a.length) {G__23431__a[G__23431__i] = arguments[G__23431__i + 0]; ++G__23431__i;}
  args = new cljs.core.IndexedSeq(G__23431__a,0);
} 
return G__23430__delegate.call(this,args);};
G__23430.cljs$lang$maxFixedArity = 0;
G__23430.cljs$lang$applyTo = (function (arglist__23432){
var args = cljs.core.seq(arglist__23432);
return G__23430__delegate(args);
});
G__23430.cljs$core$IFn$_invoke$arity$variadic = G__23430__delegate;
return G__23430;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__23434 = cljs.core._EQ_;
var expr__23435 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__23434.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__23435))){
var path_parts = ((function (pred__23434,expr__23435){
return (function (p1__23433_SHARP_){
return clojure.string.split.call(null,p1__23433_SHARP_,/[\/\\]/);
});})(pred__23434,expr__23435))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__23434,expr__23435){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e23437){if((e23437 instanceof Error)){
var e = e23437;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e23437;

}
}})());
});
;})(path_parts,sep,root,pred__23434,expr__23435))
} else {
if(cljs.core.truth_(pred__23434.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__23435))){
return ((function (pred__23434,expr__23435){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),{"cleanupWhenDone": true});
deferred.addCallback(((function (deferred,pred__23434,expr__23435){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__23434,expr__23435))
);

return deferred.addErrback(((function (deferred,pred__23434,expr__23435){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__23434,expr__23435))
);
});
;})(pred__23434,expr__23435))
} else {
return ((function (pred__23434,expr__23435){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__23434,expr__23435))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__23438,callback){
var map__23441 = p__23438;
var map__23441__$1 = ((((!((map__23441 == null)))?((((map__23441.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23441.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23441):map__23441);
var file_msg = map__23441__$1;
var request_url = cljs.core.get.call(null,map__23441__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__23441,map__23441__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__23441,map__23441__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__20367__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto__){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto__){
return (function (state_23465){
var state_val_23466 = (state_23465[(1)]);
if((state_val_23466 === (7))){
var inst_23461 = (state_23465[(2)]);
var state_23465__$1 = state_23465;
var statearr_23467_23487 = state_23465__$1;
(statearr_23467_23487[(2)] = inst_23461);

(statearr_23467_23487[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23466 === (1))){
var state_23465__$1 = state_23465;
var statearr_23468_23488 = state_23465__$1;
(statearr_23468_23488[(2)] = null);

(statearr_23468_23488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23466 === (4))){
var inst_23445 = (state_23465[(7)]);
var inst_23445__$1 = (state_23465[(2)]);
var state_23465__$1 = (function (){var statearr_23469 = state_23465;
(statearr_23469[(7)] = inst_23445__$1);

return statearr_23469;
})();
if(cljs.core.truth_(inst_23445__$1)){
var statearr_23470_23489 = state_23465__$1;
(statearr_23470_23489[(1)] = (5));

} else {
var statearr_23471_23490 = state_23465__$1;
(statearr_23471_23490[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23466 === (6))){
var state_23465__$1 = state_23465;
var statearr_23472_23491 = state_23465__$1;
(statearr_23472_23491[(2)] = null);

(statearr_23472_23491[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23466 === (3))){
var inst_23463 = (state_23465[(2)]);
var state_23465__$1 = state_23465;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23465__$1,inst_23463);
} else {
if((state_val_23466 === (2))){
var state_23465__$1 = state_23465;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23465__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_23466 === (11))){
var inst_23457 = (state_23465[(2)]);
var state_23465__$1 = (function (){var statearr_23473 = state_23465;
(statearr_23473[(8)] = inst_23457);

return statearr_23473;
})();
var statearr_23474_23492 = state_23465__$1;
(statearr_23474_23492[(2)] = null);

(statearr_23474_23492[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23466 === (9))){
var inst_23451 = (state_23465[(9)]);
var inst_23449 = (state_23465[(10)]);
var inst_23453 = inst_23451.call(null,inst_23449);
var state_23465__$1 = state_23465;
var statearr_23475_23493 = state_23465__$1;
(statearr_23475_23493[(2)] = inst_23453);

(statearr_23475_23493[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23466 === (5))){
var inst_23445 = (state_23465[(7)]);
var inst_23447 = figwheel.client.file_reloading.blocking_load.call(null,inst_23445);
var state_23465__$1 = state_23465;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23465__$1,(8),inst_23447);
} else {
if((state_val_23466 === (10))){
var inst_23449 = (state_23465[(10)]);
var inst_23455 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_23449);
var state_23465__$1 = state_23465;
var statearr_23476_23494 = state_23465__$1;
(statearr_23476_23494[(2)] = inst_23455);

(statearr_23476_23494[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23466 === (8))){
var inst_23451 = (state_23465[(9)]);
var inst_23445 = (state_23465[(7)]);
var inst_23449 = (state_23465[(2)]);
var inst_23450 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_23451__$1 = cljs.core.get.call(null,inst_23450,inst_23445);
var state_23465__$1 = (function (){var statearr_23477 = state_23465;
(statearr_23477[(9)] = inst_23451__$1);

(statearr_23477[(10)] = inst_23449);

return statearr_23477;
})();
if(cljs.core.truth_(inst_23451__$1)){
var statearr_23478_23495 = state_23465__$1;
(statearr_23478_23495[(1)] = (9));

} else {
var statearr_23479_23496 = state_23465__$1;
(statearr_23479_23496[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto__))
;
return ((function (switch__20255__auto__,c__20367__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__20256__auto__ = null;
var figwheel$client$file_reloading$state_machine__20256__auto____0 = (function (){
var statearr_23483 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23483[(0)] = figwheel$client$file_reloading$state_machine__20256__auto__);

(statearr_23483[(1)] = (1));

return statearr_23483;
});
var figwheel$client$file_reloading$state_machine__20256__auto____1 = (function (state_23465){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_23465);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e23484){if((e23484 instanceof Object)){
var ex__20259__auto__ = e23484;
var statearr_23485_23497 = state_23465;
(statearr_23485_23497[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23465);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23484;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23498 = state_23465;
state_23465 = G__23498;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__20256__auto__ = function(state_23465){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__20256__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__20256__auto____1.call(this,state_23465);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__20256__auto____0;
figwheel$client$file_reloading$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__20256__auto____1;
return figwheel$client$file_reloading$state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto__))
})();
var state__20369__auto__ = (function (){var statearr_23486 = f__20368__auto__.call(null);
(statearr_23486[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto__);

return statearr_23486;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto__))
);

return c__20367__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__23499,callback){
var map__23502 = p__23499;
var map__23502__$1 = ((((!((map__23502 == null)))?((((map__23502.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23502.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23502):map__23502);
var file_msg = map__23502__$1;
var namespace = cljs.core.get.call(null,map__23502__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__23502,map__23502__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__23502,map__23502__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__23504){
var map__23507 = p__23504;
var map__23507__$1 = ((((!((map__23507 == null)))?((((map__23507.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23507.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23507):map__23507);
var file_msg = map__23507__$1;
var namespace = cljs.core.get.call(null,map__23507__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__18190__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__18190__auto__){
var or__18202__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
var or__18202__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__18202__auto____$1)){
return or__18202__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__18190__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__23509,callback){
var map__23512 = p__23509;
var map__23512__$1 = ((((!((map__23512 == null)))?((((map__23512.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23512.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23512):map__23512);
var file_msg = map__23512__$1;
var request_url = cljs.core.get.call(null,map__23512__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__23512__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__20367__auto___23600 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto___23600,out){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto___23600,out){
return (function (state_23582){
var state_val_23583 = (state_23582[(1)]);
if((state_val_23583 === (1))){
var inst_23560 = cljs.core.nth.call(null,files,(0),null);
var inst_23561 = cljs.core.nthnext.call(null,files,(1));
var inst_23562 = files;
var state_23582__$1 = (function (){var statearr_23584 = state_23582;
(statearr_23584[(7)] = inst_23560);

(statearr_23584[(8)] = inst_23562);

(statearr_23584[(9)] = inst_23561);

return statearr_23584;
})();
var statearr_23585_23601 = state_23582__$1;
(statearr_23585_23601[(2)] = null);

(statearr_23585_23601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23583 === (2))){
var inst_23562 = (state_23582[(8)]);
var inst_23565 = (state_23582[(10)]);
var inst_23565__$1 = cljs.core.nth.call(null,inst_23562,(0),null);
var inst_23566 = cljs.core.nthnext.call(null,inst_23562,(1));
var inst_23567 = (inst_23565__$1 == null);
var inst_23568 = cljs.core.not.call(null,inst_23567);
var state_23582__$1 = (function (){var statearr_23586 = state_23582;
(statearr_23586[(11)] = inst_23566);

(statearr_23586[(10)] = inst_23565__$1);

return statearr_23586;
})();
if(inst_23568){
var statearr_23587_23602 = state_23582__$1;
(statearr_23587_23602[(1)] = (4));

} else {
var statearr_23588_23603 = state_23582__$1;
(statearr_23588_23603[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23583 === (3))){
var inst_23580 = (state_23582[(2)]);
var state_23582__$1 = state_23582;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23582__$1,inst_23580);
} else {
if((state_val_23583 === (4))){
var inst_23565 = (state_23582[(10)]);
var inst_23570 = figwheel.client.file_reloading.reload_js_file.call(null,inst_23565);
var state_23582__$1 = state_23582;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23582__$1,(7),inst_23570);
} else {
if((state_val_23583 === (5))){
var inst_23576 = cljs.core.async.close_BANG_.call(null,out);
var state_23582__$1 = state_23582;
var statearr_23589_23604 = state_23582__$1;
(statearr_23589_23604[(2)] = inst_23576);

(statearr_23589_23604[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23583 === (6))){
var inst_23578 = (state_23582[(2)]);
var state_23582__$1 = state_23582;
var statearr_23590_23605 = state_23582__$1;
(statearr_23590_23605[(2)] = inst_23578);

(statearr_23590_23605[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23583 === (7))){
var inst_23566 = (state_23582[(11)]);
var inst_23572 = (state_23582[(2)]);
var inst_23573 = cljs.core.async.put_BANG_.call(null,out,inst_23572);
var inst_23562 = inst_23566;
var state_23582__$1 = (function (){var statearr_23591 = state_23582;
(statearr_23591[(8)] = inst_23562);

(statearr_23591[(12)] = inst_23573);

return statearr_23591;
})();
var statearr_23592_23606 = state_23582__$1;
(statearr_23592_23606[(2)] = null);

(statearr_23592_23606[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__20367__auto___23600,out))
;
return ((function (switch__20255__auto__,c__20367__auto___23600,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20256__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20256__auto____0 = (function (){
var statearr_23596 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23596[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20256__auto__);

(statearr_23596[(1)] = (1));

return statearr_23596;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20256__auto____1 = (function (state_23582){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_23582);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e23597){if((e23597 instanceof Object)){
var ex__20259__auto__ = e23597;
var statearr_23598_23607 = state_23582;
(statearr_23598_23607[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23582);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23597;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23608 = state_23582;
state_23582 = G__23608;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20256__auto__ = function(state_23582){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20256__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20256__auto____1.call(this,state_23582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20256__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20256__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto___23600,out))
})();
var state__20369__auto__ = (function (){var statearr_23599 = f__20368__auto__.call(null);
(statearr_23599[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto___23600);

return statearr_23599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto___23600,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__23609,opts){
var map__23613 = p__23609;
var map__23613__$1 = ((((!((map__23613 == null)))?((((map__23613.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23613.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23613):map__23613);
var eval_body__$1 = cljs.core.get.call(null,map__23613__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__23613__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__18190__auto__ = eval_body__$1;
if(cljs.core.truth_(and__18190__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__18190__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e23615){var e = e23615;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4423__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__23616_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__23616_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4423__auto__)){
var file_msg = temp__4423__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__23621){
var vec__23622 = p__23621;
var k = cljs.core.nth.call(null,vec__23622,(0),null);
var v = cljs.core.nth.call(null,vec__23622,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__23623){
var vec__23624 = p__23623;
var k = cljs.core.nth.call(null,vec__23624,(0),null);
var v = cljs.core.nth.call(null,vec__23624,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__23628,p__23629){
var map__23876 = p__23628;
var map__23876__$1 = ((((!((map__23876 == null)))?((((map__23876.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23876.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23876):map__23876);
var opts = map__23876__$1;
var before_jsload = cljs.core.get.call(null,map__23876__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__23876__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__23876__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__23877 = p__23629;
var map__23877__$1 = ((((!((map__23877 == null)))?((((map__23877.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23877.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23877):map__23877);
var msg = map__23877__$1;
var files = cljs.core.get.call(null,map__23877__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__23877__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__23877__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__20367__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_24030){
var state_val_24031 = (state_24030[(1)]);
if((state_val_24031 === (7))){
var inst_23891 = (state_24030[(7)]);
var inst_23894 = (state_24030[(8)]);
var inst_23892 = (state_24030[(9)]);
var inst_23893 = (state_24030[(10)]);
var inst_23899 = cljs.core._nth.call(null,inst_23892,inst_23894);
var inst_23900 = figwheel.client.file_reloading.eval_body.call(null,inst_23899,opts);
var inst_23901 = (inst_23894 + (1));
var tmp24032 = inst_23891;
var tmp24033 = inst_23892;
var tmp24034 = inst_23893;
var inst_23891__$1 = tmp24032;
var inst_23892__$1 = tmp24033;
var inst_23893__$1 = tmp24034;
var inst_23894__$1 = inst_23901;
var state_24030__$1 = (function (){var statearr_24035 = state_24030;
(statearr_24035[(7)] = inst_23891__$1);

(statearr_24035[(8)] = inst_23894__$1);

(statearr_24035[(11)] = inst_23900);

(statearr_24035[(9)] = inst_23892__$1);

(statearr_24035[(10)] = inst_23893__$1);

return statearr_24035;
})();
var statearr_24036_24122 = state_24030__$1;
(statearr_24036_24122[(2)] = null);

(statearr_24036_24122[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (20))){
var inst_23934 = (state_24030[(12)]);
var inst_23942 = figwheel.client.file_reloading.sort_files.call(null,inst_23934);
var state_24030__$1 = state_24030;
var statearr_24037_24123 = state_24030__$1;
(statearr_24037_24123[(2)] = inst_23942);

(statearr_24037_24123[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (27))){
var state_24030__$1 = state_24030;
var statearr_24038_24124 = state_24030__$1;
(statearr_24038_24124[(2)] = null);

(statearr_24038_24124[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (1))){
var inst_23883 = (state_24030[(13)]);
var inst_23880 = before_jsload.call(null,files);
var inst_23881 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_23882 = (function (){return ((function (inst_23883,inst_23880,inst_23881,state_val_24031,c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__23625_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__23625_SHARP_);
});
;})(inst_23883,inst_23880,inst_23881,state_val_24031,c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_23883__$1 = cljs.core.filter.call(null,inst_23882,files);
var inst_23884 = cljs.core.not_empty.call(null,inst_23883__$1);
var state_24030__$1 = (function (){var statearr_24039 = state_24030;
(statearr_24039[(14)] = inst_23880);

(statearr_24039[(15)] = inst_23881);

(statearr_24039[(13)] = inst_23883__$1);

return statearr_24039;
})();
if(cljs.core.truth_(inst_23884)){
var statearr_24040_24125 = state_24030__$1;
(statearr_24040_24125[(1)] = (2));

} else {
var statearr_24041_24126 = state_24030__$1;
(statearr_24041_24126[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (24))){
var state_24030__$1 = state_24030;
var statearr_24042_24127 = state_24030__$1;
(statearr_24042_24127[(2)] = null);

(statearr_24042_24127[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (39))){
var inst_23984 = (state_24030[(16)]);
var state_24030__$1 = state_24030;
var statearr_24043_24128 = state_24030__$1;
(statearr_24043_24128[(2)] = inst_23984);

(statearr_24043_24128[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (46))){
var inst_24025 = (state_24030[(2)]);
var state_24030__$1 = state_24030;
var statearr_24044_24129 = state_24030__$1;
(statearr_24044_24129[(2)] = inst_24025);

(statearr_24044_24129[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (4))){
var inst_23928 = (state_24030[(2)]);
var inst_23929 = cljs.core.List.EMPTY;
var inst_23930 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_23929);
var inst_23931 = (function (){return ((function (inst_23928,inst_23929,inst_23930,state_val_24031,c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__23626_SHARP_){
var and__18190__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__23626_SHARP_);
if(cljs.core.truth_(and__18190__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__23626_SHARP_));
} else {
return and__18190__auto__;
}
});
;})(inst_23928,inst_23929,inst_23930,state_val_24031,c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_23932 = cljs.core.filter.call(null,inst_23931,files);
var inst_23933 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_23934 = cljs.core.concat.call(null,inst_23932,inst_23933);
var state_24030__$1 = (function (){var statearr_24045 = state_24030;
(statearr_24045[(17)] = inst_23930);

(statearr_24045[(12)] = inst_23934);

(statearr_24045[(18)] = inst_23928);

return statearr_24045;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_24046_24130 = state_24030__$1;
(statearr_24046_24130[(1)] = (16));

} else {
var statearr_24047_24131 = state_24030__$1;
(statearr_24047_24131[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (15))){
var inst_23918 = (state_24030[(2)]);
var state_24030__$1 = state_24030;
var statearr_24048_24132 = state_24030__$1;
(statearr_24048_24132[(2)] = inst_23918);

(statearr_24048_24132[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (21))){
var inst_23944 = (state_24030[(19)]);
var inst_23944__$1 = (state_24030[(2)]);
var inst_23945 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_23944__$1);
var state_24030__$1 = (function (){var statearr_24049 = state_24030;
(statearr_24049[(19)] = inst_23944__$1);

return statearr_24049;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24030__$1,(22),inst_23945);
} else {
if((state_val_24031 === (31))){
var inst_24028 = (state_24030[(2)]);
var state_24030__$1 = state_24030;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24030__$1,inst_24028);
} else {
if((state_val_24031 === (32))){
var inst_23984 = (state_24030[(16)]);
var inst_23989 = inst_23984.cljs$lang$protocol_mask$partition0$;
var inst_23990 = (inst_23989 & (64));
var inst_23991 = inst_23984.cljs$core$ISeq$;
var inst_23992 = (inst_23990) || (inst_23991);
var state_24030__$1 = state_24030;
if(cljs.core.truth_(inst_23992)){
var statearr_24050_24133 = state_24030__$1;
(statearr_24050_24133[(1)] = (35));

} else {
var statearr_24051_24134 = state_24030__$1;
(statearr_24051_24134[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (40))){
var inst_24005 = (state_24030[(20)]);
var inst_24004 = (state_24030[(2)]);
var inst_24005__$1 = cljs.core.get.call(null,inst_24004,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_24006 = cljs.core.get.call(null,inst_24004,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_24007 = cljs.core.not_empty.call(null,inst_24005__$1);
var state_24030__$1 = (function (){var statearr_24052 = state_24030;
(statearr_24052[(21)] = inst_24006);

(statearr_24052[(20)] = inst_24005__$1);

return statearr_24052;
})();
if(cljs.core.truth_(inst_24007)){
var statearr_24053_24135 = state_24030__$1;
(statearr_24053_24135[(1)] = (41));

} else {
var statearr_24054_24136 = state_24030__$1;
(statearr_24054_24136[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (33))){
var state_24030__$1 = state_24030;
var statearr_24055_24137 = state_24030__$1;
(statearr_24055_24137[(2)] = false);

(statearr_24055_24137[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (13))){
var inst_23904 = (state_24030[(22)]);
var inst_23908 = cljs.core.chunk_first.call(null,inst_23904);
var inst_23909 = cljs.core.chunk_rest.call(null,inst_23904);
var inst_23910 = cljs.core.count.call(null,inst_23908);
var inst_23891 = inst_23909;
var inst_23892 = inst_23908;
var inst_23893 = inst_23910;
var inst_23894 = (0);
var state_24030__$1 = (function (){var statearr_24056 = state_24030;
(statearr_24056[(7)] = inst_23891);

(statearr_24056[(8)] = inst_23894);

(statearr_24056[(9)] = inst_23892);

(statearr_24056[(10)] = inst_23893);

return statearr_24056;
})();
var statearr_24057_24138 = state_24030__$1;
(statearr_24057_24138[(2)] = null);

(statearr_24057_24138[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (22))){
var inst_23947 = (state_24030[(23)]);
var inst_23952 = (state_24030[(24)]);
var inst_23948 = (state_24030[(25)]);
var inst_23944 = (state_24030[(19)]);
var inst_23947__$1 = (state_24030[(2)]);
var inst_23948__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_23947__$1);
var inst_23949 = (function (){var all_files = inst_23944;
var res_SINGLEQUOTE_ = inst_23947__$1;
var res = inst_23948__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_23947,inst_23952,inst_23948,inst_23944,inst_23947__$1,inst_23948__$1,state_val_24031,c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__23627_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__23627_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_23947,inst_23952,inst_23948,inst_23944,inst_23947__$1,inst_23948__$1,state_val_24031,c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_23950 = cljs.core.filter.call(null,inst_23949,inst_23947__$1);
var inst_23951 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_23952__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_23951);
var inst_23953 = cljs.core.not_empty.call(null,inst_23952__$1);
var state_24030__$1 = (function (){var statearr_24058 = state_24030;
(statearr_24058[(23)] = inst_23947__$1);

(statearr_24058[(26)] = inst_23950);

(statearr_24058[(24)] = inst_23952__$1);

(statearr_24058[(25)] = inst_23948__$1);

return statearr_24058;
})();
if(cljs.core.truth_(inst_23953)){
var statearr_24059_24139 = state_24030__$1;
(statearr_24059_24139[(1)] = (23));

} else {
var statearr_24060_24140 = state_24030__$1;
(statearr_24060_24140[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (36))){
var state_24030__$1 = state_24030;
var statearr_24061_24141 = state_24030__$1;
(statearr_24061_24141[(2)] = false);

(statearr_24061_24141[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (41))){
var inst_24005 = (state_24030[(20)]);
var inst_24009 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_24010 = cljs.core.map.call(null,inst_24009,inst_24005);
var inst_24011 = cljs.core.pr_str.call(null,inst_24010);
var inst_24012 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_24011)].join('');
var inst_24013 = figwheel.client.utils.log.call(null,inst_24012);
var state_24030__$1 = state_24030;
var statearr_24062_24142 = state_24030__$1;
(statearr_24062_24142[(2)] = inst_24013);

(statearr_24062_24142[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (43))){
var inst_24006 = (state_24030[(21)]);
var inst_24016 = (state_24030[(2)]);
var inst_24017 = cljs.core.not_empty.call(null,inst_24006);
var state_24030__$1 = (function (){var statearr_24063 = state_24030;
(statearr_24063[(27)] = inst_24016);

return statearr_24063;
})();
if(cljs.core.truth_(inst_24017)){
var statearr_24064_24143 = state_24030__$1;
(statearr_24064_24143[(1)] = (44));

} else {
var statearr_24065_24144 = state_24030__$1;
(statearr_24065_24144[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (29))){
var inst_23947 = (state_24030[(23)]);
var inst_23984 = (state_24030[(16)]);
var inst_23950 = (state_24030[(26)]);
var inst_23952 = (state_24030[(24)]);
var inst_23948 = (state_24030[(25)]);
var inst_23944 = (state_24030[(19)]);
var inst_23980 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_23983 = (function (){var all_files = inst_23944;
var res_SINGLEQUOTE_ = inst_23947;
var res = inst_23948;
var files_not_loaded = inst_23950;
var dependencies_that_loaded = inst_23952;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_23947,inst_23984,inst_23950,inst_23952,inst_23948,inst_23944,inst_23980,state_val_24031,c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__23982){
var map__24066 = p__23982;
var map__24066__$1 = ((((!((map__24066 == null)))?((((map__24066.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24066.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24066):map__24066);
var namespace = cljs.core.get.call(null,map__24066__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_23947,inst_23984,inst_23950,inst_23952,inst_23948,inst_23944,inst_23980,state_val_24031,c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_23984__$1 = cljs.core.group_by.call(null,inst_23983,inst_23950);
var inst_23986 = (inst_23984__$1 == null);
var inst_23987 = cljs.core.not.call(null,inst_23986);
var state_24030__$1 = (function (){var statearr_24068 = state_24030;
(statearr_24068[(28)] = inst_23980);

(statearr_24068[(16)] = inst_23984__$1);

return statearr_24068;
})();
if(inst_23987){
var statearr_24069_24145 = state_24030__$1;
(statearr_24069_24145[(1)] = (32));

} else {
var statearr_24070_24146 = state_24030__$1;
(statearr_24070_24146[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (44))){
var inst_24006 = (state_24030[(21)]);
var inst_24019 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_24006);
var inst_24020 = cljs.core.pr_str.call(null,inst_24019);
var inst_24021 = [cljs.core.str("not required: "),cljs.core.str(inst_24020)].join('');
var inst_24022 = figwheel.client.utils.log.call(null,inst_24021);
var state_24030__$1 = state_24030;
var statearr_24071_24147 = state_24030__$1;
(statearr_24071_24147[(2)] = inst_24022);

(statearr_24071_24147[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (6))){
var inst_23925 = (state_24030[(2)]);
var state_24030__$1 = state_24030;
var statearr_24072_24148 = state_24030__$1;
(statearr_24072_24148[(2)] = inst_23925);

(statearr_24072_24148[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (28))){
var inst_23950 = (state_24030[(26)]);
var inst_23977 = (state_24030[(2)]);
var inst_23978 = cljs.core.not_empty.call(null,inst_23950);
var state_24030__$1 = (function (){var statearr_24073 = state_24030;
(statearr_24073[(29)] = inst_23977);

return statearr_24073;
})();
if(cljs.core.truth_(inst_23978)){
var statearr_24074_24149 = state_24030__$1;
(statearr_24074_24149[(1)] = (29));

} else {
var statearr_24075_24150 = state_24030__$1;
(statearr_24075_24150[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (25))){
var inst_23948 = (state_24030[(25)]);
var inst_23964 = (state_24030[(2)]);
var inst_23965 = cljs.core.not_empty.call(null,inst_23948);
var state_24030__$1 = (function (){var statearr_24076 = state_24030;
(statearr_24076[(30)] = inst_23964);

return statearr_24076;
})();
if(cljs.core.truth_(inst_23965)){
var statearr_24077_24151 = state_24030__$1;
(statearr_24077_24151[(1)] = (26));

} else {
var statearr_24078_24152 = state_24030__$1;
(statearr_24078_24152[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (34))){
var inst_23999 = (state_24030[(2)]);
var state_24030__$1 = state_24030;
if(cljs.core.truth_(inst_23999)){
var statearr_24079_24153 = state_24030__$1;
(statearr_24079_24153[(1)] = (38));

} else {
var statearr_24080_24154 = state_24030__$1;
(statearr_24080_24154[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (17))){
var state_24030__$1 = state_24030;
var statearr_24081_24155 = state_24030__$1;
(statearr_24081_24155[(2)] = recompile_dependents);

(statearr_24081_24155[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (3))){
var state_24030__$1 = state_24030;
var statearr_24082_24156 = state_24030__$1;
(statearr_24082_24156[(2)] = null);

(statearr_24082_24156[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (12))){
var inst_23921 = (state_24030[(2)]);
var state_24030__$1 = state_24030;
var statearr_24083_24157 = state_24030__$1;
(statearr_24083_24157[(2)] = inst_23921);

(statearr_24083_24157[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (2))){
var inst_23883 = (state_24030[(13)]);
var inst_23890 = cljs.core.seq.call(null,inst_23883);
var inst_23891 = inst_23890;
var inst_23892 = null;
var inst_23893 = (0);
var inst_23894 = (0);
var state_24030__$1 = (function (){var statearr_24084 = state_24030;
(statearr_24084[(7)] = inst_23891);

(statearr_24084[(8)] = inst_23894);

(statearr_24084[(9)] = inst_23892);

(statearr_24084[(10)] = inst_23893);

return statearr_24084;
})();
var statearr_24085_24158 = state_24030__$1;
(statearr_24085_24158[(2)] = null);

(statearr_24085_24158[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (23))){
var inst_23947 = (state_24030[(23)]);
var inst_23950 = (state_24030[(26)]);
var inst_23952 = (state_24030[(24)]);
var inst_23948 = (state_24030[(25)]);
var inst_23944 = (state_24030[(19)]);
var inst_23955 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_23957 = (function (){var all_files = inst_23944;
var res_SINGLEQUOTE_ = inst_23947;
var res = inst_23948;
var files_not_loaded = inst_23950;
var dependencies_that_loaded = inst_23952;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_23947,inst_23950,inst_23952,inst_23948,inst_23944,inst_23955,state_val_24031,c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__23956){
var map__24086 = p__23956;
var map__24086__$1 = ((((!((map__24086 == null)))?((((map__24086.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24086.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24086):map__24086);
var request_url = cljs.core.get.call(null,map__24086__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_23947,inst_23950,inst_23952,inst_23948,inst_23944,inst_23955,state_val_24031,c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_23958 = cljs.core.reverse.call(null,inst_23952);
var inst_23959 = cljs.core.map.call(null,inst_23957,inst_23958);
var inst_23960 = cljs.core.pr_str.call(null,inst_23959);
var inst_23961 = figwheel.client.utils.log.call(null,inst_23960);
var state_24030__$1 = (function (){var statearr_24088 = state_24030;
(statearr_24088[(31)] = inst_23955);

return statearr_24088;
})();
var statearr_24089_24159 = state_24030__$1;
(statearr_24089_24159[(2)] = inst_23961);

(statearr_24089_24159[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (35))){
var state_24030__$1 = state_24030;
var statearr_24090_24160 = state_24030__$1;
(statearr_24090_24160[(2)] = true);

(statearr_24090_24160[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (19))){
var inst_23934 = (state_24030[(12)]);
var inst_23940 = figwheel.client.file_reloading.expand_files.call(null,inst_23934);
var state_24030__$1 = state_24030;
var statearr_24091_24161 = state_24030__$1;
(statearr_24091_24161[(2)] = inst_23940);

(statearr_24091_24161[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (11))){
var state_24030__$1 = state_24030;
var statearr_24092_24162 = state_24030__$1;
(statearr_24092_24162[(2)] = null);

(statearr_24092_24162[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (9))){
var inst_23923 = (state_24030[(2)]);
var state_24030__$1 = state_24030;
var statearr_24093_24163 = state_24030__$1;
(statearr_24093_24163[(2)] = inst_23923);

(statearr_24093_24163[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (5))){
var inst_23894 = (state_24030[(8)]);
var inst_23893 = (state_24030[(10)]);
var inst_23896 = (inst_23894 < inst_23893);
var inst_23897 = inst_23896;
var state_24030__$1 = state_24030;
if(cljs.core.truth_(inst_23897)){
var statearr_24094_24164 = state_24030__$1;
(statearr_24094_24164[(1)] = (7));

} else {
var statearr_24095_24165 = state_24030__$1;
(statearr_24095_24165[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (14))){
var inst_23904 = (state_24030[(22)]);
var inst_23913 = cljs.core.first.call(null,inst_23904);
var inst_23914 = figwheel.client.file_reloading.eval_body.call(null,inst_23913,opts);
var inst_23915 = cljs.core.next.call(null,inst_23904);
var inst_23891 = inst_23915;
var inst_23892 = null;
var inst_23893 = (0);
var inst_23894 = (0);
var state_24030__$1 = (function (){var statearr_24096 = state_24030;
(statearr_24096[(7)] = inst_23891);

(statearr_24096[(32)] = inst_23914);

(statearr_24096[(8)] = inst_23894);

(statearr_24096[(9)] = inst_23892);

(statearr_24096[(10)] = inst_23893);

return statearr_24096;
})();
var statearr_24097_24166 = state_24030__$1;
(statearr_24097_24166[(2)] = null);

(statearr_24097_24166[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (45))){
var state_24030__$1 = state_24030;
var statearr_24098_24167 = state_24030__$1;
(statearr_24098_24167[(2)] = null);

(statearr_24098_24167[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (26))){
var inst_23947 = (state_24030[(23)]);
var inst_23950 = (state_24030[(26)]);
var inst_23952 = (state_24030[(24)]);
var inst_23948 = (state_24030[(25)]);
var inst_23944 = (state_24030[(19)]);
var inst_23967 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_23969 = (function (){var all_files = inst_23944;
var res_SINGLEQUOTE_ = inst_23947;
var res = inst_23948;
var files_not_loaded = inst_23950;
var dependencies_that_loaded = inst_23952;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_23947,inst_23950,inst_23952,inst_23948,inst_23944,inst_23967,state_val_24031,c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__23968){
var map__24099 = p__23968;
var map__24099__$1 = ((((!((map__24099 == null)))?((((map__24099.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24099.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24099):map__24099);
var namespace = cljs.core.get.call(null,map__24099__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__24099__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_23947,inst_23950,inst_23952,inst_23948,inst_23944,inst_23967,state_val_24031,c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_23970 = cljs.core.map.call(null,inst_23969,inst_23948);
var inst_23971 = cljs.core.pr_str.call(null,inst_23970);
var inst_23972 = figwheel.client.utils.log.call(null,inst_23971);
var inst_23973 = (function (){var all_files = inst_23944;
var res_SINGLEQUOTE_ = inst_23947;
var res = inst_23948;
var files_not_loaded = inst_23950;
var dependencies_that_loaded = inst_23952;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_23947,inst_23950,inst_23952,inst_23948,inst_23944,inst_23967,inst_23969,inst_23970,inst_23971,inst_23972,state_val_24031,c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_23947,inst_23950,inst_23952,inst_23948,inst_23944,inst_23967,inst_23969,inst_23970,inst_23971,inst_23972,state_val_24031,c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_23974 = setTimeout(inst_23973,(10));
var state_24030__$1 = (function (){var statearr_24101 = state_24030;
(statearr_24101[(33)] = inst_23972);

(statearr_24101[(34)] = inst_23967);

return statearr_24101;
})();
var statearr_24102_24168 = state_24030__$1;
(statearr_24102_24168[(2)] = inst_23974);

(statearr_24102_24168[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (16))){
var state_24030__$1 = state_24030;
var statearr_24103_24169 = state_24030__$1;
(statearr_24103_24169[(2)] = reload_dependents);

(statearr_24103_24169[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (38))){
var inst_23984 = (state_24030[(16)]);
var inst_24001 = cljs.core.apply.call(null,cljs.core.hash_map,inst_23984);
var state_24030__$1 = state_24030;
var statearr_24104_24170 = state_24030__$1;
(statearr_24104_24170[(2)] = inst_24001);

(statearr_24104_24170[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (30))){
var state_24030__$1 = state_24030;
var statearr_24105_24171 = state_24030__$1;
(statearr_24105_24171[(2)] = null);

(statearr_24105_24171[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (10))){
var inst_23904 = (state_24030[(22)]);
var inst_23906 = cljs.core.chunked_seq_QMARK_.call(null,inst_23904);
var state_24030__$1 = state_24030;
if(inst_23906){
var statearr_24106_24172 = state_24030__$1;
(statearr_24106_24172[(1)] = (13));

} else {
var statearr_24107_24173 = state_24030__$1;
(statearr_24107_24173[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (18))){
var inst_23938 = (state_24030[(2)]);
var state_24030__$1 = state_24030;
if(cljs.core.truth_(inst_23938)){
var statearr_24108_24174 = state_24030__$1;
(statearr_24108_24174[(1)] = (19));

} else {
var statearr_24109_24175 = state_24030__$1;
(statearr_24109_24175[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (42))){
var state_24030__$1 = state_24030;
var statearr_24110_24176 = state_24030__$1;
(statearr_24110_24176[(2)] = null);

(statearr_24110_24176[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (37))){
var inst_23996 = (state_24030[(2)]);
var state_24030__$1 = state_24030;
var statearr_24111_24177 = state_24030__$1;
(statearr_24111_24177[(2)] = inst_23996);

(statearr_24111_24177[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24031 === (8))){
var inst_23891 = (state_24030[(7)]);
var inst_23904 = (state_24030[(22)]);
var inst_23904__$1 = cljs.core.seq.call(null,inst_23891);
var state_24030__$1 = (function (){var statearr_24112 = state_24030;
(statearr_24112[(22)] = inst_23904__$1);

return statearr_24112;
})();
if(inst_23904__$1){
var statearr_24113_24178 = state_24030__$1;
(statearr_24113_24178[(1)] = (10));

} else {
var statearr_24114_24179 = state_24030__$1;
(statearr_24114_24179[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__20255__auto__,c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20256__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20256__auto____0 = (function (){
var statearr_24118 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24118[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__20256__auto__);

(statearr_24118[(1)] = (1));

return statearr_24118;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20256__auto____1 = (function (state_24030){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_24030);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e24119){if((e24119 instanceof Object)){
var ex__20259__auto__ = e24119;
var statearr_24120_24180 = state_24030;
(statearr_24120_24180[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24030);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24119;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24181 = state_24030;
state_24030 = G__24181;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__20256__auto__ = function(state_24030){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20256__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20256__auto____1.call(this,state_24030);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__20256__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__20256__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__20369__auto__ = (function (){var statearr_24121 = f__20368__auto__.call(null);
(statearr_24121[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto__);

return statearr_24121;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto__,map__23876,map__23876__$1,opts,before_jsload,on_jsload,reload_dependents,map__23877,map__23877__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__20367__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__24184,link){
var map__24187 = p__24184;
var map__24187__$1 = ((((!((map__24187 == null)))?((((map__24187.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24187.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24187):map__24187);
var file = cljs.core.get.call(null,map__24187__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = link.href;
if(cljs.core.truth_(temp__4425__auto__)){
var link_href = temp__4425__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4425__auto__,map__24187,map__24187__$1,file){
return (function (p1__24182_SHARP_,p2__24183_SHARP_){
if(cljs.core._EQ_.call(null,p1__24182_SHARP_,p2__24183_SHARP_)){
return p1__24182_SHARP_;
} else {
return false;
}
});})(link_href,temp__4425__auto__,map__24187,map__24187__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4425__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__24193){
var map__24194 = p__24193;
var map__24194__$1 = ((((!((map__24194 == null)))?((((map__24194.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24194.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24194):map__24194);
var match_length = cljs.core.get.call(null,map__24194__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__24194__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__24189_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__24189_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4425__auto__)){
var res = temp__4425__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args24196 = [];
var len__19260__auto___24199 = arguments.length;
var i__19261__auto___24200 = (0);
while(true){
if((i__19261__auto___24200 < len__19260__auto___24199)){
args24196.push((arguments[i__19261__auto___24200]));

var G__24201 = (i__19261__auto___24200 + (1));
i__19261__auto___24200 = G__24201;
continue;
} else {
}
break;
}

var G__24198 = args24196.length;
switch (G__24198) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24196.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__24203_SHARP_,p2__24204_SHARP_){
return cljs.core.assoc.call(null,p1__24203_SHARP_,cljs.core.get.call(null,p2__24204_SHARP_,key),p2__24204_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__24205){
var map__24208 = p__24205;
var map__24208__$1 = ((((!((map__24208 == null)))?((((map__24208.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24208.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24208):map__24208);
var f_data = map__24208__$1;
var file = cljs.core.get.call(null,map__24208__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4425__auto__)){
var link = temp__4425__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__24210,files_msg){
var map__24217 = p__24210;
var map__24217__$1 = ((((!((map__24217 == null)))?((((map__24217.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24217.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24217):map__24217);
var opts = map__24217__$1;
var on_cssload = cljs.core.get.call(null,map__24217__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__24219_24223 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__24220_24224 = null;
var count__24221_24225 = (0);
var i__24222_24226 = (0);
while(true){
if((i__24222_24226 < count__24221_24225)){
var f_24227 = cljs.core._nth.call(null,chunk__24220_24224,i__24222_24226);
figwheel.client.file_reloading.reload_css_file.call(null,f_24227);

var G__24228 = seq__24219_24223;
var G__24229 = chunk__24220_24224;
var G__24230 = count__24221_24225;
var G__24231 = (i__24222_24226 + (1));
seq__24219_24223 = G__24228;
chunk__24220_24224 = G__24229;
count__24221_24225 = G__24230;
i__24222_24226 = G__24231;
continue;
} else {
var temp__4425__auto___24232 = cljs.core.seq.call(null,seq__24219_24223);
if(temp__4425__auto___24232){
var seq__24219_24233__$1 = temp__4425__auto___24232;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24219_24233__$1)){
var c__19005__auto___24234 = cljs.core.chunk_first.call(null,seq__24219_24233__$1);
var G__24235 = cljs.core.chunk_rest.call(null,seq__24219_24233__$1);
var G__24236 = c__19005__auto___24234;
var G__24237 = cljs.core.count.call(null,c__19005__auto___24234);
var G__24238 = (0);
seq__24219_24223 = G__24235;
chunk__24220_24224 = G__24236;
count__24221_24225 = G__24237;
i__24222_24226 = G__24238;
continue;
} else {
var f_24239 = cljs.core.first.call(null,seq__24219_24233__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_24239);

var G__24240 = cljs.core.next.call(null,seq__24219_24233__$1);
var G__24241 = null;
var G__24242 = (0);
var G__24243 = (0);
seq__24219_24223 = G__24240;
chunk__24220_24224 = G__24241;
count__24221_24225 = G__24242;
i__24222_24226 = G__24243;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__24217,map__24217__$1,opts,on_cssload){
return (function (){
return on_cssload.call(null,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg));
});})(map__24217,map__24217__$1,opts,on_cssload))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map