// Compiled by ClojureScript 1.7.228 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
goog.require('cljs.repl');
goog.require('figwheel.client.heads_up');
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),args], null));

return args;
});
figwheel.client.autoload_QMARK_ = (cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?(function (){
var pred__24555 = cljs.core._EQ_;
var expr__24556 = (function (){var or__18202__auto__ = localStorage.getItem("figwheel_autoload");
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
return "true";
}
})();
if(cljs.core.truth_(pred__24555.call(null,"true",expr__24556))){
return true;
} else {
if(cljs.core.truth_(pred__24555.call(null,"false",expr__24556))){
return false;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__24556)].join('')));
}
}
}):(function (){
return true;
}));
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
localStorage.setItem("figwheel_autoload",cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));

return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Figwheel autoloading "),cljs.core.str((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));
} else {
return null;
}
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
figwheel.client.console_print = (function figwheel$client$console_print(args){
console.log.apply(console,cljs.core.into_array.call(null,args));

return args;
});
figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

return cljs.core._STAR_print_fn_STAR_ = (function() { 
var G__24558__delegate = function (args){
return figwheel.client.figwheel_repl_print.call(null,figwheel.client.console_print.call(null,args));
};
var G__24558 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__24559__i = 0, G__24559__a = new Array(arguments.length -  0);
while (G__24559__i < G__24559__a.length) {G__24559__a[G__24559__i] = arguments[G__24559__i + 0]; ++G__24559__i;}
  args = new cljs.core.IndexedSeq(G__24559__a,0);
} 
return G__24558__delegate.call(this,args);};
G__24558.cljs$lang$maxFixedArity = 0;
G__24558.cljs$lang$applyTo = (function (arglist__24560){
var args = cljs.core.seq(arglist__24560);
return G__24558__delegate(args);
});
G__24558.cljs$core$IFn$_invoke$arity$variadic = G__24558__delegate;
return G__24558;
})()
;
});
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel$client$get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__24561){
var map__24564 = p__24561;
var map__24564__$1 = ((((!((map__24564 == null)))?((((map__24564.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24564.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24564):map__24564);
var message = cljs.core.get.call(null,map__24564__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__24564__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str(class$),cljs.core.str(" : "),cljs.core.str(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__18202__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__18190__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__18190__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__18190__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__20367__auto___24726 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto___24726,ch){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto___24726,ch){
return (function (state_24695){
var state_val_24696 = (state_24695[(1)]);
if((state_val_24696 === (7))){
var inst_24691 = (state_24695[(2)]);
var state_24695__$1 = state_24695;
var statearr_24697_24727 = state_24695__$1;
(statearr_24697_24727[(2)] = inst_24691);

(statearr_24697_24727[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24696 === (1))){
var state_24695__$1 = state_24695;
var statearr_24698_24728 = state_24695__$1;
(statearr_24698_24728[(2)] = null);

(statearr_24698_24728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24696 === (4))){
var inst_24648 = (state_24695[(7)]);
var inst_24648__$1 = (state_24695[(2)]);
var state_24695__$1 = (function (){var statearr_24699 = state_24695;
(statearr_24699[(7)] = inst_24648__$1);

return statearr_24699;
})();
if(cljs.core.truth_(inst_24648__$1)){
var statearr_24700_24729 = state_24695__$1;
(statearr_24700_24729[(1)] = (5));

} else {
var statearr_24701_24730 = state_24695__$1;
(statearr_24701_24730[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24696 === (15))){
var inst_24655 = (state_24695[(8)]);
var inst_24670 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_24655);
var inst_24671 = cljs.core.first.call(null,inst_24670);
var inst_24672 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_24671);
var inst_24673 = [cljs.core.str("Figwheel: Not loading code with warnings - "),cljs.core.str(inst_24672)].join('');
var inst_24674 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_24673);
var state_24695__$1 = state_24695;
var statearr_24702_24731 = state_24695__$1;
(statearr_24702_24731[(2)] = inst_24674);

(statearr_24702_24731[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24696 === (13))){
var inst_24679 = (state_24695[(2)]);
var state_24695__$1 = state_24695;
var statearr_24703_24732 = state_24695__$1;
(statearr_24703_24732[(2)] = inst_24679);

(statearr_24703_24732[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24696 === (6))){
var state_24695__$1 = state_24695;
var statearr_24704_24733 = state_24695__$1;
(statearr_24704_24733[(2)] = null);

(statearr_24704_24733[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24696 === (17))){
var inst_24677 = (state_24695[(2)]);
var state_24695__$1 = state_24695;
var statearr_24705_24734 = state_24695__$1;
(statearr_24705_24734[(2)] = inst_24677);

(statearr_24705_24734[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24696 === (3))){
var inst_24693 = (state_24695[(2)]);
var state_24695__$1 = state_24695;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24695__$1,inst_24693);
} else {
if((state_val_24696 === (12))){
var inst_24654 = (state_24695[(9)]);
var inst_24668 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_24654,opts);
var state_24695__$1 = state_24695;
if(cljs.core.truth_(inst_24668)){
var statearr_24706_24735 = state_24695__$1;
(statearr_24706_24735[(1)] = (15));

} else {
var statearr_24707_24736 = state_24695__$1;
(statearr_24707_24736[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24696 === (2))){
var state_24695__$1 = state_24695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24695__$1,(4),ch);
} else {
if((state_val_24696 === (11))){
var inst_24655 = (state_24695[(8)]);
var inst_24660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24661 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_24655);
var inst_24662 = cljs.core.async.timeout.call(null,(1000));
var inst_24663 = [inst_24661,inst_24662];
var inst_24664 = (new cljs.core.PersistentVector(null,2,(5),inst_24660,inst_24663,null));
var state_24695__$1 = state_24695;
return cljs.core.async.ioc_alts_BANG_.call(null,state_24695__$1,(14),inst_24664);
} else {
if((state_val_24696 === (9))){
var inst_24655 = (state_24695[(8)]);
var inst_24681 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_24682 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_24655);
var inst_24683 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_24682);
var inst_24684 = [cljs.core.str("Not loading: "),cljs.core.str(inst_24683)].join('');
var inst_24685 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_24684);
var state_24695__$1 = (function (){var statearr_24708 = state_24695;
(statearr_24708[(10)] = inst_24681);

return statearr_24708;
})();
var statearr_24709_24737 = state_24695__$1;
(statearr_24709_24737[(2)] = inst_24685);

(statearr_24709_24737[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24696 === (5))){
var inst_24648 = (state_24695[(7)]);
var inst_24650 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_24651 = (new cljs.core.PersistentArrayMap(null,2,inst_24650,null));
var inst_24652 = (new cljs.core.PersistentHashSet(null,inst_24651,null));
var inst_24653 = figwheel.client.focus_msgs.call(null,inst_24652,inst_24648);
var inst_24654 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_24653);
var inst_24655 = cljs.core.first.call(null,inst_24653);
var inst_24656 = figwheel.client.autoload_QMARK_.call(null);
var state_24695__$1 = (function (){var statearr_24710 = state_24695;
(statearr_24710[(9)] = inst_24654);

(statearr_24710[(8)] = inst_24655);

return statearr_24710;
})();
if(cljs.core.truth_(inst_24656)){
var statearr_24711_24738 = state_24695__$1;
(statearr_24711_24738[(1)] = (8));

} else {
var statearr_24712_24739 = state_24695__$1;
(statearr_24712_24739[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24696 === (14))){
var inst_24666 = (state_24695[(2)]);
var state_24695__$1 = state_24695;
var statearr_24713_24740 = state_24695__$1;
(statearr_24713_24740[(2)] = inst_24666);

(statearr_24713_24740[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24696 === (16))){
var state_24695__$1 = state_24695;
var statearr_24714_24741 = state_24695__$1;
(statearr_24714_24741[(2)] = null);

(statearr_24714_24741[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24696 === (10))){
var inst_24687 = (state_24695[(2)]);
var state_24695__$1 = (function (){var statearr_24715 = state_24695;
(statearr_24715[(11)] = inst_24687);

return statearr_24715;
})();
var statearr_24716_24742 = state_24695__$1;
(statearr_24716_24742[(2)] = null);

(statearr_24716_24742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24696 === (8))){
var inst_24654 = (state_24695[(9)]);
var inst_24658 = figwheel.client.reload_file_state_QMARK_.call(null,inst_24654,opts);
var state_24695__$1 = state_24695;
if(cljs.core.truth_(inst_24658)){
var statearr_24717_24743 = state_24695__$1;
(statearr_24717_24743[(1)] = (11));

} else {
var statearr_24718_24744 = state_24695__$1;
(statearr_24718_24744[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto___24726,ch))
;
return ((function (switch__20255__auto__,c__20367__auto___24726,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__20256__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__20256__auto____0 = (function (){
var statearr_24722 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24722[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__20256__auto__);

(statearr_24722[(1)] = (1));

return statearr_24722;
});
var figwheel$client$file_reloader_plugin_$_state_machine__20256__auto____1 = (function (state_24695){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_24695);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e24723){if((e24723 instanceof Object)){
var ex__20259__auto__ = e24723;
var statearr_24724_24745 = state_24695;
(statearr_24724_24745[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24695);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24723;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24746 = state_24695;
state_24695 = G__24746;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__20256__auto__ = function(state_24695){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__20256__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__20256__auto____1.call(this,state_24695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__20256__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__20256__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto___24726,ch))
})();
var state__20369__auto__ = (function (){var statearr_24725 = f__20368__auto__.call(null);
(statearr_24725[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto___24726);

return statearr_24725;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto___24726,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__24747_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__24747_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_24754 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_24754){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var _STAR_print_fn_STAR_24752 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR_24753 = cljs.core._STAR_print_newline_STAR_;
cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_fn_STAR_24752,_STAR_print_newline_STAR_24753,base_path_24754){
return (function() { 
var G__24755__delegate = function (args){
return figwheel.client.figwheel_repl_print.call(null,figwheel.client.console_print.call(null,args));
};
var G__24755 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__24756__i = 0, G__24756__a = new Array(arguments.length -  0);
while (G__24756__i < G__24756__a.length) {G__24756__a[G__24756__i] = arguments[G__24756__i + 0]; ++G__24756__i;}
  args = new cljs.core.IndexedSeq(G__24756__a,0);
} 
return G__24755__delegate.call(this,args);};
G__24755.cljs$lang$maxFixedArity = 0;
G__24755.cljs$lang$applyTo = (function (arglist__24757){
var args = cljs.core.seq(arglist__24757);
return G__24755__delegate(args);
});
G__24755.cljs$core$IFn$_invoke$arity$variadic = G__24755__delegate;
return G__24755;
})()
;})(_STAR_print_fn_STAR_24752,_STAR_print_newline_STAR_24753,base_path_24754))
;

cljs.core._STAR_print_newline_STAR_ = false;

try{return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),[cljs.core.str(figwheel.client.utils.eval_helper.call(null,code,opts))].join('')], null));
}finally {cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_24753;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_24752;
}}catch (e24751){if((e24751 instanceof Error)){
var e = e24751;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_24754], null));
} else {
var e = e24751;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}});})(base_path_24754))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = {};
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__24758){
var map__24765 = p__24758;
var map__24765__$1 = ((((!((map__24765 == null)))?((((map__24765.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24765.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24765):map__24765);
var opts = map__24765__$1;
var build_id = cljs.core.get.call(null,map__24765__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__24765,map__24765__$1,opts,build_id){
return (function (p__24767){
var vec__24768 = p__24767;
var map__24769 = cljs.core.nth.call(null,vec__24768,(0),null);
var map__24769__$1 = ((((!((map__24769 == null)))?((((map__24769.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24769.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24769):map__24769);
var msg = map__24769__$1;
var msg_name = cljs.core.get.call(null,map__24769__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__24768,(1));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__24768,map__24769,map__24769__$1,msg,msg_name,_,map__24765,map__24765__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__24768,map__24769,map__24769__$1,msg,msg_name,_,map__24765,map__24765__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__24765,map__24765__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__24775){
var vec__24776 = p__24775;
var map__24777 = cljs.core.nth.call(null,vec__24776,(0),null);
var map__24777__$1 = ((((!((map__24777 == null)))?((((map__24777.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24777.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24777):map__24777);
var msg = map__24777__$1;
var msg_name = cljs.core.get.call(null,map__24777__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__24776,(1));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__24779){
var map__24789 = p__24779;
var map__24789__$1 = ((((!((map__24789 == null)))?((((map__24789.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24789.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24789):map__24789);
var on_compile_warning = cljs.core.get.call(null,map__24789__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__24789__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__24789,map__24789__$1,on_compile_warning,on_compile_fail){
return (function (p__24791){
var vec__24792 = p__24791;
var map__24793 = cljs.core.nth.call(null,vec__24792,(0),null);
var map__24793__$1 = ((((!((map__24793 == null)))?((((map__24793.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24793.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24793):map__24793);
var msg = map__24793__$1;
var msg_name = cljs.core.get.call(null,map__24793__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__24792,(1));
var pred__24795 = cljs.core._EQ_;
var expr__24796 = msg_name;
if(cljs.core.truth_(pred__24795.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__24796))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__24795.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__24796))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__24789,map__24789__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__20367__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto__,msg_hist,msg_names,msg){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto__,msg_hist,msg_names,msg){
return (function (state_25012){
var state_val_25013 = (state_25012[(1)]);
if((state_val_25013 === (7))){
var inst_24936 = (state_25012[(2)]);
var state_25012__$1 = state_25012;
if(cljs.core.truth_(inst_24936)){
var statearr_25014_25060 = state_25012__$1;
(statearr_25014_25060[(1)] = (8));

} else {
var statearr_25015_25061 = state_25012__$1;
(statearr_25015_25061[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (20))){
var inst_25006 = (state_25012[(2)]);
var state_25012__$1 = state_25012;
var statearr_25016_25062 = state_25012__$1;
(statearr_25016_25062[(2)] = inst_25006);

(statearr_25016_25062[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (27))){
var inst_25002 = (state_25012[(2)]);
var state_25012__$1 = state_25012;
var statearr_25017_25063 = state_25012__$1;
(statearr_25017_25063[(2)] = inst_25002);

(statearr_25017_25063[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (1))){
var inst_24929 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_25012__$1 = state_25012;
if(cljs.core.truth_(inst_24929)){
var statearr_25018_25064 = state_25012__$1;
(statearr_25018_25064[(1)] = (2));

} else {
var statearr_25019_25065 = state_25012__$1;
(statearr_25019_25065[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (24))){
var inst_25004 = (state_25012[(2)]);
var state_25012__$1 = state_25012;
var statearr_25020_25066 = state_25012__$1;
(statearr_25020_25066[(2)] = inst_25004);

(statearr_25020_25066[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (4))){
var inst_25010 = (state_25012[(2)]);
var state_25012__$1 = state_25012;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25012__$1,inst_25010);
} else {
if((state_val_25013 === (15))){
var inst_25008 = (state_25012[(2)]);
var state_25012__$1 = state_25012;
var statearr_25021_25067 = state_25012__$1;
(statearr_25021_25067[(2)] = inst_25008);

(statearr_25021_25067[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (21))){
var inst_24967 = (state_25012[(2)]);
var state_25012__$1 = state_25012;
var statearr_25022_25068 = state_25012__$1;
(statearr_25022_25068[(2)] = inst_24967);

(statearr_25022_25068[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (31))){
var inst_24991 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_25012__$1 = state_25012;
if(cljs.core.truth_(inst_24991)){
var statearr_25023_25069 = state_25012__$1;
(statearr_25023_25069[(1)] = (34));

} else {
var statearr_25024_25070 = state_25012__$1;
(statearr_25024_25070[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (32))){
var inst_25000 = (state_25012[(2)]);
var state_25012__$1 = state_25012;
var statearr_25025_25071 = state_25012__$1;
(statearr_25025_25071[(2)] = inst_25000);

(statearr_25025_25071[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (33))){
var inst_24989 = (state_25012[(2)]);
var state_25012__$1 = state_25012;
var statearr_25026_25072 = state_25012__$1;
(statearr_25026_25072[(2)] = inst_24989);

(statearr_25026_25072[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (13))){
var inst_24950 = figwheel.client.heads_up.clear.call(null);
var state_25012__$1 = state_25012;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25012__$1,(16),inst_24950);
} else {
if((state_val_25013 === (22))){
var inst_24971 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_24972 = figwheel.client.heads_up.append_message.call(null,inst_24971);
var state_25012__$1 = state_25012;
var statearr_25027_25073 = state_25012__$1;
(statearr_25027_25073[(2)] = inst_24972);

(statearr_25027_25073[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (36))){
var inst_24998 = (state_25012[(2)]);
var state_25012__$1 = state_25012;
var statearr_25028_25074 = state_25012__$1;
(statearr_25028_25074[(2)] = inst_24998);

(statearr_25028_25074[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (29))){
var inst_24982 = (state_25012[(2)]);
var state_25012__$1 = state_25012;
var statearr_25029_25075 = state_25012__$1;
(statearr_25029_25075[(2)] = inst_24982);

(statearr_25029_25075[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (6))){
var inst_24931 = (state_25012[(7)]);
var state_25012__$1 = state_25012;
var statearr_25030_25076 = state_25012__$1;
(statearr_25030_25076[(2)] = inst_24931);

(statearr_25030_25076[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (28))){
var inst_24978 = (state_25012[(2)]);
var inst_24979 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_24980 = figwheel.client.heads_up.display_warning.call(null,inst_24979);
var state_25012__$1 = (function (){var statearr_25031 = state_25012;
(statearr_25031[(8)] = inst_24978);

return statearr_25031;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25012__$1,(29),inst_24980);
} else {
if((state_val_25013 === (25))){
var inst_24976 = figwheel.client.heads_up.clear.call(null);
var state_25012__$1 = state_25012;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25012__$1,(28),inst_24976);
} else {
if((state_val_25013 === (34))){
var inst_24993 = figwheel.client.heads_up.flash_loaded.call(null);
var state_25012__$1 = state_25012;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25012__$1,(37),inst_24993);
} else {
if((state_val_25013 === (17))){
var inst_24958 = (state_25012[(2)]);
var state_25012__$1 = state_25012;
var statearr_25032_25077 = state_25012__$1;
(statearr_25032_25077[(2)] = inst_24958);

(statearr_25032_25077[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (3))){
var inst_24948 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_25012__$1 = state_25012;
if(cljs.core.truth_(inst_24948)){
var statearr_25033_25078 = state_25012__$1;
(statearr_25033_25078[(1)] = (13));

} else {
var statearr_25034_25079 = state_25012__$1;
(statearr_25034_25079[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (12))){
var inst_24944 = (state_25012[(2)]);
var state_25012__$1 = state_25012;
var statearr_25035_25080 = state_25012__$1;
(statearr_25035_25080[(2)] = inst_24944);

(statearr_25035_25080[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (2))){
var inst_24931 = (state_25012[(7)]);
var inst_24931__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_25012__$1 = (function (){var statearr_25036 = state_25012;
(statearr_25036[(7)] = inst_24931__$1);

return statearr_25036;
})();
if(cljs.core.truth_(inst_24931__$1)){
var statearr_25037_25081 = state_25012__$1;
(statearr_25037_25081[(1)] = (5));

} else {
var statearr_25038_25082 = state_25012__$1;
(statearr_25038_25082[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (23))){
var inst_24974 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_25012__$1 = state_25012;
if(cljs.core.truth_(inst_24974)){
var statearr_25039_25083 = state_25012__$1;
(statearr_25039_25083[(1)] = (25));

} else {
var statearr_25040_25084 = state_25012__$1;
(statearr_25040_25084[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (35))){
var state_25012__$1 = state_25012;
var statearr_25041_25085 = state_25012__$1;
(statearr_25041_25085[(2)] = null);

(statearr_25041_25085[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (19))){
var inst_24969 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_25012__$1 = state_25012;
if(cljs.core.truth_(inst_24969)){
var statearr_25042_25086 = state_25012__$1;
(statearr_25042_25086[(1)] = (22));

} else {
var statearr_25043_25087 = state_25012__$1;
(statearr_25043_25087[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (11))){
var inst_24940 = (state_25012[(2)]);
var state_25012__$1 = state_25012;
var statearr_25044_25088 = state_25012__$1;
(statearr_25044_25088[(2)] = inst_24940);

(statearr_25044_25088[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (9))){
var inst_24942 = figwheel.client.heads_up.clear.call(null);
var state_25012__$1 = state_25012;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25012__$1,(12),inst_24942);
} else {
if((state_val_25013 === (5))){
var inst_24933 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_25012__$1 = state_25012;
var statearr_25045_25089 = state_25012__$1;
(statearr_25045_25089[(2)] = inst_24933);

(statearr_25045_25089[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (14))){
var inst_24960 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_25012__$1 = state_25012;
if(cljs.core.truth_(inst_24960)){
var statearr_25046_25090 = state_25012__$1;
(statearr_25046_25090[(1)] = (18));

} else {
var statearr_25047_25091 = state_25012__$1;
(statearr_25047_25091[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (26))){
var inst_24984 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_25012__$1 = state_25012;
if(cljs.core.truth_(inst_24984)){
var statearr_25048_25092 = state_25012__$1;
(statearr_25048_25092[(1)] = (30));

} else {
var statearr_25049_25093 = state_25012__$1;
(statearr_25049_25093[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (16))){
var inst_24952 = (state_25012[(2)]);
var inst_24953 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_24954 = figwheel.client.format_messages.call(null,inst_24953);
var inst_24955 = new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(msg);
var inst_24956 = figwheel.client.heads_up.display_error.call(null,inst_24954,inst_24955);
var state_25012__$1 = (function (){var statearr_25050 = state_25012;
(statearr_25050[(9)] = inst_24952);

return statearr_25050;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25012__$1,(17),inst_24956);
} else {
if((state_val_25013 === (30))){
var inst_24986 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_24987 = figwheel.client.heads_up.display_warning.call(null,inst_24986);
var state_25012__$1 = state_25012;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25012__$1,(33),inst_24987);
} else {
if((state_val_25013 === (10))){
var inst_24946 = (state_25012[(2)]);
var state_25012__$1 = state_25012;
var statearr_25051_25094 = state_25012__$1;
(statearr_25051_25094[(2)] = inst_24946);

(statearr_25051_25094[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (18))){
var inst_24962 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_24963 = figwheel.client.format_messages.call(null,inst_24962);
var inst_24964 = new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(msg);
var inst_24965 = figwheel.client.heads_up.display_error.call(null,inst_24963,inst_24964);
var state_25012__$1 = state_25012;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25012__$1,(21),inst_24965);
} else {
if((state_val_25013 === (37))){
var inst_24995 = (state_25012[(2)]);
var state_25012__$1 = state_25012;
var statearr_25052_25095 = state_25012__$1;
(statearr_25052_25095[(2)] = inst_24995);

(statearr_25052_25095[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25013 === (8))){
var inst_24938 = figwheel.client.heads_up.flash_loaded.call(null);
var state_25012__$1 = state_25012;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25012__$1,(11),inst_24938);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__20255__auto__,c__20367__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20256__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20256__auto____0 = (function (){
var statearr_25056 = [null,null,null,null,null,null,null,null,null,null];
(statearr_25056[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20256__auto__);

(statearr_25056[(1)] = (1));

return statearr_25056;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20256__auto____1 = (function (state_25012){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_25012);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e25057){if((e25057 instanceof Object)){
var ex__20259__auto__ = e25057;
var statearr_25058_25096 = state_25012;
(statearr_25058_25096[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25012);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25057;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25097 = state_25012;
state_25012 = G__25097;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20256__auto__ = function(state_25012){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20256__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20256__auto____1.call(this,state_25012);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20256__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20256__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto__,msg_hist,msg_names,msg))
})();
var state__20369__auto__ = (function (){var statearr_25059 = f__20368__auto__.call(null);
(statearr_25059[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto__);

return statearr_25059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto__,msg_hist,msg_names,msg))
);

return c__20367__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__20367__auto___25160 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto___25160,ch){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto___25160,ch){
return (function (state_25143){
var state_val_25144 = (state_25143[(1)]);
if((state_val_25144 === (1))){
var state_25143__$1 = state_25143;
var statearr_25145_25161 = state_25143__$1;
(statearr_25145_25161[(2)] = null);

(statearr_25145_25161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25144 === (2))){
var state_25143__$1 = state_25143;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25143__$1,(4),ch);
} else {
if((state_val_25144 === (3))){
var inst_25141 = (state_25143[(2)]);
var state_25143__$1 = state_25143;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25143__$1,inst_25141);
} else {
if((state_val_25144 === (4))){
var inst_25131 = (state_25143[(7)]);
var inst_25131__$1 = (state_25143[(2)]);
var state_25143__$1 = (function (){var statearr_25146 = state_25143;
(statearr_25146[(7)] = inst_25131__$1);

return statearr_25146;
})();
if(cljs.core.truth_(inst_25131__$1)){
var statearr_25147_25162 = state_25143__$1;
(statearr_25147_25162[(1)] = (5));

} else {
var statearr_25148_25163 = state_25143__$1;
(statearr_25148_25163[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25144 === (5))){
var inst_25131 = (state_25143[(7)]);
var inst_25133 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_25131);
var state_25143__$1 = state_25143;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25143__$1,(8),inst_25133);
} else {
if((state_val_25144 === (6))){
var state_25143__$1 = state_25143;
var statearr_25149_25164 = state_25143__$1;
(statearr_25149_25164[(2)] = null);

(statearr_25149_25164[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25144 === (7))){
var inst_25139 = (state_25143[(2)]);
var state_25143__$1 = state_25143;
var statearr_25150_25165 = state_25143__$1;
(statearr_25150_25165[(2)] = inst_25139);

(statearr_25150_25165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25144 === (8))){
var inst_25135 = (state_25143[(2)]);
var state_25143__$1 = (function (){var statearr_25151 = state_25143;
(statearr_25151[(8)] = inst_25135);

return statearr_25151;
})();
var statearr_25152_25166 = state_25143__$1;
(statearr_25152_25166[(2)] = null);

(statearr_25152_25166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__20367__auto___25160,ch))
;
return ((function (switch__20255__auto__,c__20367__auto___25160,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__20256__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__20256__auto____0 = (function (){
var statearr_25156 = [null,null,null,null,null,null,null,null,null];
(statearr_25156[(0)] = figwheel$client$heads_up_plugin_$_state_machine__20256__auto__);

(statearr_25156[(1)] = (1));

return statearr_25156;
});
var figwheel$client$heads_up_plugin_$_state_machine__20256__auto____1 = (function (state_25143){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_25143);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e25157){if((e25157 instanceof Object)){
var ex__20259__auto__ = e25157;
var statearr_25158_25167 = state_25143;
(statearr_25158_25167[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25143);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25157;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25168 = state_25143;
state_25143 = G__25168;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__20256__auto__ = function(state_25143){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__20256__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__20256__auto____1.call(this,state_25143);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__20256__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__20256__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto___25160,ch))
})();
var state__20369__auto__ = (function (){var statearr_25159 = f__20368__auto__.call(null);
(statearr_25159[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto___25160);

return statearr_25159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto___25160,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__20367__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto__){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto__){
return (function (state_25189){
var state_val_25190 = (state_25189[(1)]);
if((state_val_25190 === (1))){
var inst_25184 = cljs.core.async.timeout.call(null,(3000));
var state_25189__$1 = state_25189;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25189__$1,(2),inst_25184);
} else {
if((state_val_25190 === (2))){
var inst_25186 = (state_25189[(2)]);
var inst_25187 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_25189__$1 = (function (){var statearr_25191 = state_25189;
(statearr_25191[(7)] = inst_25186);

return statearr_25191;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25189__$1,inst_25187);
} else {
return null;
}
}
});})(c__20367__auto__))
;
return ((function (switch__20255__auto__,c__20367__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__20256__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__20256__auto____0 = (function (){
var statearr_25195 = [null,null,null,null,null,null,null,null];
(statearr_25195[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__20256__auto__);

(statearr_25195[(1)] = (1));

return statearr_25195;
});
var figwheel$client$enforce_project_plugin_$_state_machine__20256__auto____1 = (function (state_25189){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_25189);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e25196){if((e25196 instanceof Object)){
var ex__20259__auto__ = e25196;
var statearr_25197_25199 = state_25189;
(statearr_25197_25199[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25189);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25196;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25200 = state_25189;
state_25189 = G__25200;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__20256__auto__ = function(state_25189){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__20256__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__20256__auto____1.call(this,state_25189);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__20256__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__20256__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto__))
})();
var state__20369__auto__ = (function (){var statearr_25198 = f__20368__auto__.call(null);
(statearr_25198[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto__);

return statearr_25198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto__))
);

return c__20367__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__25201){
var map__25208 = p__25201;
var map__25208__$1 = ((((!((map__25208 == null)))?((((map__25208.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25208.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25208):map__25208);
var ed = map__25208__$1;
var formatted_exception = cljs.core.get.call(null,map__25208__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__25208__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__25208__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__25210_25214 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__25211_25215 = null;
var count__25212_25216 = (0);
var i__25213_25217 = (0);
while(true){
if((i__25213_25217 < count__25212_25216)){
var msg_25218 = cljs.core._nth.call(null,chunk__25211_25215,i__25213_25217);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_25218);

var G__25219 = seq__25210_25214;
var G__25220 = chunk__25211_25215;
var G__25221 = count__25212_25216;
var G__25222 = (i__25213_25217 + (1));
seq__25210_25214 = G__25219;
chunk__25211_25215 = G__25220;
count__25212_25216 = G__25221;
i__25213_25217 = G__25222;
continue;
} else {
var temp__4425__auto___25223 = cljs.core.seq.call(null,seq__25210_25214);
if(temp__4425__auto___25223){
var seq__25210_25224__$1 = temp__4425__auto___25223;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25210_25224__$1)){
var c__19005__auto___25225 = cljs.core.chunk_first.call(null,seq__25210_25224__$1);
var G__25226 = cljs.core.chunk_rest.call(null,seq__25210_25224__$1);
var G__25227 = c__19005__auto___25225;
var G__25228 = cljs.core.count.call(null,c__19005__auto___25225);
var G__25229 = (0);
seq__25210_25214 = G__25226;
chunk__25211_25215 = G__25227;
count__25212_25216 = G__25228;
i__25213_25217 = G__25229;
continue;
} else {
var msg_25230 = cljs.core.first.call(null,seq__25210_25224__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_25230);

var G__25231 = cljs.core.next.call(null,seq__25210_25224__$1);
var G__25232 = null;
var G__25233 = (0);
var G__25234 = (0);
seq__25210_25214 = G__25231;
chunk__25211_25215 = G__25232;
count__25212_25216 = G__25233;
i__25213_25217 = G__25234;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Error on file "),cljs.core.str(new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(cause)),cljs.core.str(", line "),cljs.core.str(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(cause)),cljs.core.str(", column "),cljs.core.str(new cljs.core.Keyword(null,"column","column",2078222095).cljs$core$IFn$_invoke$arity$1(cause))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__25235){
var map__25238 = p__25235;
var map__25238__$1 = ((((!((map__25238 == null)))?((((map__25238.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25238.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25238):map__25238);
var w = map__25238__$1;
var message = cljs.core.get.call(null,map__25238__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str("Figwheel: Compile Warning - "),cljs.core.str(message)].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[figwheel.client.default_on_compile_warning,figwheel.client.default_on_jsload,true,figwheel.client.default_on_compile_fail,false,true,[cljs.core.str("ws://"),cljs.core.str((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str("/figwheel-ws")].join(''),figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__18190__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__18190__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__18190__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__25246 = cljs.core.seq.call(null,plugins);
var chunk__25247 = null;
var count__25248 = (0);
var i__25249 = (0);
while(true){
if((i__25249 < count__25248)){
var vec__25250 = cljs.core._nth.call(null,chunk__25247,i__25249);
var k = cljs.core.nth.call(null,vec__25250,(0),null);
var plugin = cljs.core.nth.call(null,vec__25250,(1),null);
if(cljs.core.truth_(plugin)){
var pl_25252 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__25246,chunk__25247,count__25248,i__25249,pl_25252,vec__25250,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_25252.call(null,msg_hist);
});})(seq__25246,chunk__25247,count__25248,i__25249,pl_25252,vec__25250,k,plugin))
);
} else {
}

var G__25253 = seq__25246;
var G__25254 = chunk__25247;
var G__25255 = count__25248;
var G__25256 = (i__25249 + (1));
seq__25246 = G__25253;
chunk__25247 = G__25254;
count__25248 = G__25255;
i__25249 = G__25256;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__25246);
if(temp__4425__auto__){
var seq__25246__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25246__$1)){
var c__19005__auto__ = cljs.core.chunk_first.call(null,seq__25246__$1);
var G__25257 = cljs.core.chunk_rest.call(null,seq__25246__$1);
var G__25258 = c__19005__auto__;
var G__25259 = cljs.core.count.call(null,c__19005__auto__);
var G__25260 = (0);
seq__25246 = G__25257;
chunk__25247 = G__25258;
count__25248 = G__25259;
i__25249 = G__25260;
continue;
} else {
var vec__25251 = cljs.core.first.call(null,seq__25246__$1);
var k = cljs.core.nth.call(null,vec__25251,(0),null);
var plugin = cljs.core.nth.call(null,vec__25251,(1),null);
if(cljs.core.truth_(plugin)){
var pl_25261 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__25246,chunk__25247,count__25248,i__25249,pl_25261,vec__25251,k,plugin,seq__25246__$1,temp__4425__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_25261.call(null,msg_hist);
});})(seq__25246,chunk__25247,count__25248,i__25249,pl_25261,vec__25251,k,plugin,seq__25246__$1,temp__4425__auto__))
);
} else {
}

var G__25262 = cljs.core.next.call(null,seq__25246__$1);
var G__25263 = null;
var G__25264 = (0);
var G__25265 = (0);
seq__25246 = G__25262;
chunk__25247 = G__25263;
count__25248 = G__25264;
i__25249 = G__25265;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var args25266 = [];
var len__19260__auto___25269 = arguments.length;
var i__19261__auto___25270 = (0);
while(true){
if((i__19261__auto___25270 < len__19260__auto___25269)){
args25266.push((arguments[i__19261__auto___25270]));

var G__25271 = (i__19261__auto___25270 + (1));
i__19261__auto___25270 = G__25271;
continue;
} else {
}
break;
}

var G__25268 = args25266.length;
switch (G__25268) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25266.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

return figwheel.client.socket.open.call(null,system_options);
}));
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;
figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__19267__auto__ = [];
var len__19260__auto___25277 = arguments.length;
var i__19261__auto___25278 = (0);
while(true){
if((i__19261__auto___25278 < len__19260__auto___25277)){
args__19267__auto__.push((arguments[i__19261__auto___25278]));

var G__25279 = (i__19261__auto___25278 + (1));
i__19261__auto___25278 = G__25279;
continue;
} else {
}
break;
}

var argseq__19268__auto__ = ((((0) < args__19267__auto__.length))?(new cljs.core.IndexedSeq(args__19267__auto__.slice((0)),(0))):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__19268__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__25274){
var map__25275 = p__25274;
var map__25275__$1 = ((((!((map__25275 == null)))?((((map__25275.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25275.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25275):map__25275);
var opts = map__25275__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq25273){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq25273));
});

//# sourceMappingURL=client.js.map