// Compiled by ClojureScript 1.7.228 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args20412 = [];
var len__19260__auto___20418 = arguments.length;
var i__19261__auto___20419 = (0);
while(true){
if((i__19261__auto___20419 < len__19260__auto___20418)){
args20412.push((arguments[i__19261__auto___20419]));

var G__20420 = (i__19261__auto___20419 + (1));
i__19261__auto___20419 = G__20420;
continue;
} else {
}
break;
}

var G__20414 = args20412.length;
switch (G__20414) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20412.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async20415 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20415 = (function (f,blockable,meta20416){
this.f = f;
this.blockable = blockable;
this.meta20416 = meta20416;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20415.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20417,meta20416__$1){
var self__ = this;
var _20417__$1 = this;
return (new cljs.core.async.t_cljs$core$async20415(self__.f,self__.blockable,meta20416__$1));
});

cljs.core.async.t_cljs$core$async20415.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20417){
var self__ = this;
var _20417__$1 = this;
return self__.meta20416;
});

cljs.core.async.t_cljs$core$async20415.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20415.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async20415.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async20415.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async20415.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta20416","meta20416",1512664735,null)], null);
});

cljs.core.async.t_cljs$core$async20415.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20415.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20415";

cljs.core.async.t_cljs$core$async20415.cljs$lang$ctorPrWriter = (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async20415");
});

cljs.core.async.__GT_t_cljs$core$async20415 = (function cljs$core$async$__GT_t_cljs$core$async20415(f__$1,blockable__$1,meta20416){
return (new cljs.core.async.t_cljs$core$async20415(f__$1,blockable__$1,meta20416));
});

}

return (new cljs.core.async.t_cljs$core$async20415(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args20424 = [];
var len__19260__auto___20427 = arguments.length;
var i__19261__auto___20428 = (0);
while(true){
if((i__19261__auto___20428 < len__19260__auto___20427)){
args20424.push((arguments[i__19261__auto___20428]));

var G__20429 = (i__19261__auto___20428 + (1));
i__19261__auto___20428 = G__20429;
continue;
} else {
}
break;
}

var G__20426 = args20424.length;
switch (G__20426) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20424.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args20431 = [];
var len__19260__auto___20434 = arguments.length;
var i__19261__auto___20435 = (0);
while(true){
if((i__19261__auto___20435 < len__19260__auto___20434)){
args20431.push((arguments[i__19261__auto___20435]));

var G__20436 = (i__19261__auto___20435 + (1));
i__19261__auto___20435 = G__20436;
continue;
} else {
}
break;
}

var G__20433 = args20431.length;
switch (G__20433) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20431.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args20438 = [];
var len__19260__auto___20441 = arguments.length;
var i__19261__auto___20442 = (0);
while(true){
if((i__19261__auto___20442 < len__19260__auto___20441)){
args20438.push((arguments[i__19261__auto___20442]));

var G__20443 = (i__19261__auto___20442 + (1));
i__19261__auto___20442 = G__20443;
continue;
} else {
}
break;
}

var G__20440 = args20438.length;
switch (G__20440) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20438.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_20445 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_20445);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_20445,ret){
return (function (){
return fn1.call(null,val_20445);
});})(val_20445,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args20446 = [];
var len__19260__auto___20449 = arguments.length;
var i__19261__auto___20450 = (0);
while(true){
if((i__19261__auto___20450 < len__19260__auto___20449)){
args20446.push((arguments[i__19261__auto___20450]));

var G__20451 = (i__19261__auto___20450 + (1));
i__19261__auto___20450 = G__20451;
continue;
} else {
}
break;
}

var G__20448 = args20446.length;
switch (G__20448) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20446.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__19105__auto___20453 = n;
var x_20454 = (0);
while(true){
if((x_20454 < n__19105__auto___20453)){
(a[x_20454] = (0));

var G__20455 = (x_20454 + (1));
x_20454 = G__20455;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__20456 = (i + (1));
i = G__20456;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async20460 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20460 = (function (alt_flag,flag,meta20461){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta20461 = meta20461;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20460.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_20462,meta20461__$1){
var self__ = this;
var _20462__$1 = this;
return (new cljs.core.async.t_cljs$core$async20460(self__.alt_flag,self__.flag,meta20461__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async20460.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_20462){
var self__ = this;
var _20462__$1 = this;
return self__.meta20461;
});})(flag))
;

cljs.core.async.t_cljs$core$async20460.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20460.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async20460.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async20460.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async20460.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta20461","meta20461",1070691675,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async20460.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20460.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20460";

cljs.core.async.t_cljs$core$async20460.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async20460");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async20460 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async20460(alt_flag__$1,flag__$1,meta20461){
return (new cljs.core.async.t_cljs$core$async20460(alt_flag__$1,flag__$1,meta20461));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async20460(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async20466 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20466 = (function (alt_handler,flag,cb,meta20467){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta20467 = meta20467;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20466.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20468,meta20467__$1){
var self__ = this;
var _20468__$1 = this;
return (new cljs.core.async.t_cljs$core$async20466(self__.alt_handler,self__.flag,self__.cb,meta20467__$1));
});

cljs.core.async.t_cljs$core$async20466.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20468){
var self__ = this;
var _20468__$1 = this;
return self__.meta20467;
});

cljs.core.async.t_cljs$core$async20466.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20466.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async20466.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async20466.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async20466.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta20467","meta20467",10860716,null)], null);
});

cljs.core.async.t_cljs$core$async20466.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20466.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20466";

cljs.core.async.t_cljs$core$async20466.cljs$lang$ctorPrWriter = (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async20466");
});

cljs.core.async.__GT_t_cljs$core$async20466 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async20466(alt_handler__$1,flag__$1,cb__$1,meta20467){
return (new cljs.core.async.t_cljs$core$async20466(alt_handler__$1,flag__$1,cb__$1,meta20467));
});

}

return (new cljs.core.async.t_cljs$core$async20466(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20469_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20469_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20470_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20470_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__18202__auto__ = wport;
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
return port;
}
})()], null));
} else {
var G__20471 = (i + (1));
i = G__20471;
continue;
}
} else {
return null;
}
break;
}
})();
var or__18202__auto__ = ret;
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__18190__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__18190__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__18190__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__19267__auto__ = [];
var len__19260__auto___20477 = arguments.length;
var i__19261__auto___20478 = (0);
while(true){
if((i__19261__auto___20478 < len__19260__auto___20477)){
args__19267__auto__.push((arguments[i__19261__auto___20478]));

var G__20479 = (i__19261__auto___20478 + (1));
i__19261__auto___20478 = G__20479;
continue;
} else {
}
break;
}

var argseq__19268__auto__ = ((((1) < args__19267__auto__.length))?(new cljs.core.IndexedSeq(args__19267__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__19268__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__20474){
var map__20475 = p__20474;
var map__20475__$1 = ((((!((map__20475 == null)))?((((map__20475.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20475.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20475):map__20475);
var opts = map__20475__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq20472){
var G__20473 = cljs.core.first.call(null,seq20472);
var seq20472__$1 = cljs.core.next.call(null,seq20472);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20473,seq20472__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args20480 = [];
var len__19260__auto___20530 = arguments.length;
var i__19261__auto___20531 = (0);
while(true){
if((i__19261__auto___20531 < len__19260__auto___20530)){
args20480.push((arguments[i__19261__auto___20531]));

var G__20532 = (i__19261__auto___20531 + (1));
i__19261__auto___20531 = G__20532;
continue;
} else {
}
break;
}

var G__20482 = args20480.length;
switch (G__20482) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20480.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__20367__auto___20534 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto___20534){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto___20534){
return (function (state_20506){
var state_val_20507 = (state_20506[(1)]);
if((state_val_20507 === (7))){
var inst_20502 = (state_20506[(2)]);
var state_20506__$1 = state_20506;
var statearr_20508_20535 = state_20506__$1;
(statearr_20508_20535[(2)] = inst_20502);

(statearr_20508_20535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20507 === (1))){
var state_20506__$1 = state_20506;
var statearr_20509_20536 = state_20506__$1;
(statearr_20509_20536[(2)] = null);

(statearr_20509_20536[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20507 === (4))){
var inst_20485 = (state_20506[(7)]);
var inst_20485__$1 = (state_20506[(2)]);
var inst_20486 = (inst_20485__$1 == null);
var state_20506__$1 = (function (){var statearr_20510 = state_20506;
(statearr_20510[(7)] = inst_20485__$1);

return statearr_20510;
})();
if(cljs.core.truth_(inst_20486)){
var statearr_20511_20537 = state_20506__$1;
(statearr_20511_20537[(1)] = (5));

} else {
var statearr_20512_20538 = state_20506__$1;
(statearr_20512_20538[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20507 === (13))){
var state_20506__$1 = state_20506;
var statearr_20513_20539 = state_20506__$1;
(statearr_20513_20539[(2)] = null);

(statearr_20513_20539[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20507 === (6))){
var inst_20485 = (state_20506[(7)]);
var state_20506__$1 = state_20506;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20506__$1,(11),to,inst_20485);
} else {
if((state_val_20507 === (3))){
var inst_20504 = (state_20506[(2)]);
var state_20506__$1 = state_20506;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20506__$1,inst_20504);
} else {
if((state_val_20507 === (12))){
var state_20506__$1 = state_20506;
var statearr_20514_20540 = state_20506__$1;
(statearr_20514_20540[(2)] = null);

(statearr_20514_20540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20507 === (2))){
var state_20506__$1 = state_20506;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20506__$1,(4),from);
} else {
if((state_val_20507 === (11))){
var inst_20495 = (state_20506[(2)]);
var state_20506__$1 = state_20506;
if(cljs.core.truth_(inst_20495)){
var statearr_20515_20541 = state_20506__$1;
(statearr_20515_20541[(1)] = (12));

} else {
var statearr_20516_20542 = state_20506__$1;
(statearr_20516_20542[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20507 === (9))){
var state_20506__$1 = state_20506;
var statearr_20517_20543 = state_20506__$1;
(statearr_20517_20543[(2)] = null);

(statearr_20517_20543[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20507 === (5))){
var state_20506__$1 = state_20506;
if(cljs.core.truth_(close_QMARK_)){
var statearr_20518_20544 = state_20506__$1;
(statearr_20518_20544[(1)] = (8));

} else {
var statearr_20519_20545 = state_20506__$1;
(statearr_20519_20545[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20507 === (14))){
var inst_20500 = (state_20506[(2)]);
var state_20506__$1 = state_20506;
var statearr_20520_20546 = state_20506__$1;
(statearr_20520_20546[(2)] = inst_20500);

(statearr_20520_20546[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20507 === (10))){
var inst_20492 = (state_20506[(2)]);
var state_20506__$1 = state_20506;
var statearr_20521_20547 = state_20506__$1;
(statearr_20521_20547[(2)] = inst_20492);

(statearr_20521_20547[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20507 === (8))){
var inst_20489 = cljs.core.async.close_BANG_.call(null,to);
var state_20506__$1 = state_20506;
var statearr_20522_20548 = state_20506__$1;
(statearr_20522_20548[(2)] = inst_20489);

(statearr_20522_20548[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto___20534))
;
return ((function (switch__20255__auto__,c__20367__auto___20534){
return (function() {
var cljs$core$async$state_machine__20256__auto__ = null;
var cljs$core$async$state_machine__20256__auto____0 = (function (){
var statearr_20526 = [null,null,null,null,null,null,null,null];
(statearr_20526[(0)] = cljs$core$async$state_machine__20256__auto__);

(statearr_20526[(1)] = (1));

return statearr_20526;
});
var cljs$core$async$state_machine__20256__auto____1 = (function (state_20506){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_20506);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e20527){if((e20527 instanceof Object)){
var ex__20259__auto__ = e20527;
var statearr_20528_20549 = state_20506;
(statearr_20528_20549[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20506);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20527;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20550 = state_20506;
state_20506 = G__20550;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$state_machine__20256__auto__ = function(state_20506){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20256__auto____1.call(this,state_20506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20256__auto____0;
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20256__auto____1;
return cljs$core$async$state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto___20534))
})();
var state__20369__auto__ = (function (){var statearr_20529 = f__20368__auto__.call(null);
(statearr_20529[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto___20534);

return statearr_20529;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto___20534))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__20734){
var vec__20735 = p__20734;
var v = cljs.core.nth.call(null,vec__20735,(0),null);
var p = cljs.core.nth.call(null,vec__20735,(1),null);
var job = vec__20735;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__20367__auto___20917 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto___20917,res,vec__20735,v,p,job,jobs,results){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto___20917,res,vec__20735,v,p,job,jobs,results){
return (function (state_20740){
var state_val_20741 = (state_20740[(1)]);
if((state_val_20741 === (1))){
var state_20740__$1 = state_20740;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20740__$1,(2),res,v);
} else {
if((state_val_20741 === (2))){
var inst_20737 = (state_20740[(2)]);
var inst_20738 = cljs.core.async.close_BANG_.call(null,res);
var state_20740__$1 = (function (){var statearr_20742 = state_20740;
(statearr_20742[(7)] = inst_20737);

return statearr_20742;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20740__$1,inst_20738);
} else {
return null;
}
}
});})(c__20367__auto___20917,res,vec__20735,v,p,job,jobs,results))
;
return ((function (switch__20255__auto__,c__20367__auto___20917,res,vec__20735,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____0 = (function (){
var statearr_20746 = [null,null,null,null,null,null,null,null];
(statearr_20746[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__);

(statearr_20746[(1)] = (1));

return statearr_20746;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____1 = (function (state_20740){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_20740);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e20747){if((e20747 instanceof Object)){
var ex__20259__auto__ = e20747;
var statearr_20748_20918 = state_20740;
(statearr_20748_20918[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20740);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20747;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20919 = state_20740;
state_20740 = G__20919;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__ = function(state_20740){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____1.call(this,state_20740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto___20917,res,vec__20735,v,p,job,jobs,results))
})();
var state__20369__auto__ = (function (){var statearr_20749 = f__20368__auto__.call(null);
(statearr_20749[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto___20917);

return statearr_20749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto___20917,res,vec__20735,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__20750){
var vec__20751 = p__20750;
var v = cljs.core.nth.call(null,vec__20751,(0),null);
var p = cljs.core.nth.call(null,vec__20751,(1),null);
var job = vec__20751;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__19105__auto___20920 = n;
var __20921 = (0);
while(true){
if((__20921 < n__19105__auto___20920)){
var G__20752_20922 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__20752_20922) {
case "compute":
var c__20367__auto___20924 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__20921,c__20367__auto___20924,G__20752_20922,n__19105__auto___20920,jobs,results,process,async){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (__20921,c__20367__auto___20924,G__20752_20922,n__19105__auto___20920,jobs,results,process,async){
return (function (state_20765){
var state_val_20766 = (state_20765[(1)]);
if((state_val_20766 === (1))){
var state_20765__$1 = state_20765;
var statearr_20767_20925 = state_20765__$1;
(statearr_20767_20925[(2)] = null);

(statearr_20767_20925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20766 === (2))){
var state_20765__$1 = state_20765;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20765__$1,(4),jobs);
} else {
if((state_val_20766 === (3))){
var inst_20763 = (state_20765[(2)]);
var state_20765__$1 = state_20765;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20765__$1,inst_20763);
} else {
if((state_val_20766 === (4))){
var inst_20755 = (state_20765[(2)]);
var inst_20756 = process.call(null,inst_20755);
var state_20765__$1 = state_20765;
if(cljs.core.truth_(inst_20756)){
var statearr_20768_20926 = state_20765__$1;
(statearr_20768_20926[(1)] = (5));

} else {
var statearr_20769_20927 = state_20765__$1;
(statearr_20769_20927[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20766 === (5))){
var state_20765__$1 = state_20765;
var statearr_20770_20928 = state_20765__$1;
(statearr_20770_20928[(2)] = null);

(statearr_20770_20928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20766 === (6))){
var state_20765__$1 = state_20765;
var statearr_20771_20929 = state_20765__$1;
(statearr_20771_20929[(2)] = null);

(statearr_20771_20929[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20766 === (7))){
var inst_20761 = (state_20765[(2)]);
var state_20765__$1 = state_20765;
var statearr_20772_20930 = state_20765__$1;
(statearr_20772_20930[(2)] = inst_20761);

(statearr_20772_20930[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__20921,c__20367__auto___20924,G__20752_20922,n__19105__auto___20920,jobs,results,process,async))
;
return ((function (__20921,switch__20255__auto__,c__20367__auto___20924,G__20752_20922,n__19105__auto___20920,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____0 = (function (){
var statearr_20776 = [null,null,null,null,null,null,null];
(statearr_20776[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__);

(statearr_20776[(1)] = (1));

return statearr_20776;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____1 = (function (state_20765){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_20765);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e20777){if((e20777 instanceof Object)){
var ex__20259__auto__ = e20777;
var statearr_20778_20931 = state_20765;
(statearr_20778_20931[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20765);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20777;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20932 = state_20765;
state_20765 = G__20932;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__ = function(state_20765){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____1.call(this,state_20765);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__;
})()
;})(__20921,switch__20255__auto__,c__20367__auto___20924,G__20752_20922,n__19105__auto___20920,jobs,results,process,async))
})();
var state__20369__auto__ = (function (){var statearr_20779 = f__20368__auto__.call(null);
(statearr_20779[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto___20924);

return statearr_20779;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(__20921,c__20367__auto___20924,G__20752_20922,n__19105__auto___20920,jobs,results,process,async))
);


break;
case "async":
var c__20367__auto___20933 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__20921,c__20367__auto___20933,G__20752_20922,n__19105__auto___20920,jobs,results,process,async){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (__20921,c__20367__auto___20933,G__20752_20922,n__19105__auto___20920,jobs,results,process,async){
return (function (state_20792){
var state_val_20793 = (state_20792[(1)]);
if((state_val_20793 === (1))){
var state_20792__$1 = state_20792;
var statearr_20794_20934 = state_20792__$1;
(statearr_20794_20934[(2)] = null);

(statearr_20794_20934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20793 === (2))){
var state_20792__$1 = state_20792;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20792__$1,(4),jobs);
} else {
if((state_val_20793 === (3))){
var inst_20790 = (state_20792[(2)]);
var state_20792__$1 = state_20792;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20792__$1,inst_20790);
} else {
if((state_val_20793 === (4))){
var inst_20782 = (state_20792[(2)]);
var inst_20783 = async.call(null,inst_20782);
var state_20792__$1 = state_20792;
if(cljs.core.truth_(inst_20783)){
var statearr_20795_20935 = state_20792__$1;
(statearr_20795_20935[(1)] = (5));

} else {
var statearr_20796_20936 = state_20792__$1;
(statearr_20796_20936[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20793 === (5))){
var state_20792__$1 = state_20792;
var statearr_20797_20937 = state_20792__$1;
(statearr_20797_20937[(2)] = null);

(statearr_20797_20937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20793 === (6))){
var state_20792__$1 = state_20792;
var statearr_20798_20938 = state_20792__$1;
(statearr_20798_20938[(2)] = null);

(statearr_20798_20938[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20793 === (7))){
var inst_20788 = (state_20792[(2)]);
var state_20792__$1 = state_20792;
var statearr_20799_20939 = state_20792__$1;
(statearr_20799_20939[(2)] = inst_20788);

(statearr_20799_20939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__20921,c__20367__auto___20933,G__20752_20922,n__19105__auto___20920,jobs,results,process,async))
;
return ((function (__20921,switch__20255__auto__,c__20367__auto___20933,G__20752_20922,n__19105__auto___20920,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____0 = (function (){
var statearr_20803 = [null,null,null,null,null,null,null];
(statearr_20803[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__);

(statearr_20803[(1)] = (1));

return statearr_20803;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____1 = (function (state_20792){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_20792);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e20804){if((e20804 instanceof Object)){
var ex__20259__auto__ = e20804;
var statearr_20805_20940 = state_20792;
(statearr_20805_20940[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20792);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20804;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20941 = state_20792;
state_20792 = G__20941;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__ = function(state_20792){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____1.call(this,state_20792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__;
})()
;})(__20921,switch__20255__auto__,c__20367__auto___20933,G__20752_20922,n__19105__auto___20920,jobs,results,process,async))
})();
var state__20369__auto__ = (function (){var statearr_20806 = f__20368__auto__.call(null);
(statearr_20806[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto___20933);

return statearr_20806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(__20921,c__20367__auto___20933,G__20752_20922,n__19105__auto___20920,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__20942 = (__20921 + (1));
__20921 = G__20942;
continue;
} else {
}
break;
}

var c__20367__auto___20943 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto___20943,jobs,results,process,async){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto___20943,jobs,results,process,async){
return (function (state_20828){
var state_val_20829 = (state_20828[(1)]);
if((state_val_20829 === (1))){
var state_20828__$1 = state_20828;
var statearr_20830_20944 = state_20828__$1;
(statearr_20830_20944[(2)] = null);

(statearr_20830_20944[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20829 === (2))){
var state_20828__$1 = state_20828;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20828__$1,(4),from);
} else {
if((state_val_20829 === (3))){
var inst_20826 = (state_20828[(2)]);
var state_20828__$1 = state_20828;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20828__$1,inst_20826);
} else {
if((state_val_20829 === (4))){
var inst_20809 = (state_20828[(7)]);
var inst_20809__$1 = (state_20828[(2)]);
var inst_20810 = (inst_20809__$1 == null);
var state_20828__$1 = (function (){var statearr_20831 = state_20828;
(statearr_20831[(7)] = inst_20809__$1);

return statearr_20831;
})();
if(cljs.core.truth_(inst_20810)){
var statearr_20832_20945 = state_20828__$1;
(statearr_20832_20945[(1)] = (5));

} else {
var statearr_20833_20946 = state_20828__$1;
(statearr_20833_20946[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20829 === (5))){
var inst_20812 = cljs.core.async.close_BANG_.call(null,jobs);
var state_20828__$1 = state_20828;
var statearr_20834_20947 = state_20828__$1;
(statearr_20834_20947[(2)] = inst_20812);

(statearr_20834_20947[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20829 === (6))){
var inst_20814 = (state_20828[(8)]);
var inst_20809 = (state_20828[(7)]);
var inst_20814__$1 = cljs.core.async.chan.call(null,(1));
var inst_20815 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20816 = [inst_20809,inst_20814__$1];
var inst_20817 = (new cljs.core.PersistentVector(null,2,(5),inst_20815,inst_20816,null));
var state_20828__$1 = (function (){var statearr_20835 = state_20828;
(statearr_20835[(8)] = inst_20814__$1);

return statearr_20835;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20828__$1,(8),jobs,inst_20817);
} else {
if((state_val_20829 === (7))){
var inst_20824 = (state_20828[(2)]);
var state_20828__$1 = state_20828;
var statearr_20836_20948 = state_20828__$1;
(statearr_20836_20948[(2)] = inst_20824);

(statearr_20836_20948[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20829 === (8))){
var inst_20814 = (state_20828[(8)]);
var inst_20819 = (state_20828[(2)]);
var state_20828__$1 = (function (){var statearr_20837 = state_20828;
(statearr_20837[(9)] = inst_20819);

return statearr_20837;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20828__$1,(9),results,inst_20814);
} else {
if((state_val_20829 === (9))){
var inst_20821 = (state_20828[(2)]);
var state_20828__$1 = (function (){var statearr_20838 = state_20828;
(statearr_20838[(10)] = inst_20821);

return statearr_20838;
})();
var statearr_20839_20949 = state_20828__$1;
(statearr_20839_20949[(2)] = null);

(statearr_20839_20949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__20367__auto___20943,jobs,results,process,async))
;
return ((function (switch__20255__auto__,c__20367__auto___20943,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____0 = (function (){
var statearr_20843 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20843[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__);

(statearr_20843[(1)] = (1));

return statearr_20843;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____1 = (function (state_20828){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_20828);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e20844){if((e20844 instanceof Object)){
var ex__20259__auto__ = e20844;
var statearr_20845_20950 = state_20828;
(statearr_20845_20950[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20828);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20844;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20951 = state_20828;
state_20828 = G__20951;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__ = function(state_20828){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____1.call(this,state_20828);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto___20943,jobs,results,process,async))
})();
var state__20369__auto__ = (function (){var statearr_20846 = f__20368__auto__.call(null);
(statearr_20846[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto___20943);

return statearr_20846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto___20943,jobs,results,process,async))
);


var c__20367__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto__,jobs,results,process,async){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto__,jobs,results,process,async){
return (function (state_20884){
var state_val_20885 = (state_20884[(1)]);
if((state_val_20885 === (7))){
var inst_20880 = (state_20884[(2)]);
var state_20884__$1 = state_20884;
var statearr_20886_20952 = state_20884__$1;
(statearr_20886_20952[(2)] = inst_20880);

(statearr_20886_20952[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20885 === (20))){
var state_20884__$1 = state_20884;
var statearr_20887_20953 = state_20884__$1;
(statearr_20887_20953[(2)] = null);

(statearr_20887_20953[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20885 === (1))){
var state_20884__$1 = state_20884;
var statearr_20888_20954 = state_20884__$1;
(statearr_20888_20954[(2)] = null);

(statearr_20888_20954[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20885 === (4))){
var inst_20849 = (state_20884[(7)]);
var inst_20849__$1 = (state_20884[(2)]);
var inst_20850 = (inst_20849__$1 == null);
var state_20884__$1 = (function (){var statearr_20889 = state_20884;
(statearr_20889[(7)] = inst_20849__$1);

return statearr_20889;
})();
if(cljs.core.truth_(inst_20850)){
var statearr_20890_20955 = state_20884__$1;
(statearr_20890_20955[(1)] = (5));

} else {
var statearr_20891_20956 = state_20884__$1;
(statearr_20891_20956[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20885 === (15))){
var inst_20862 = (state_20884[(8)]);
var state_20884__$1 = state_20884;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20884__$1,(18),to,inst_20862);
} else {
if((state_val_20885 === (21))){
var inst_20875 = (state_20884[(2)]);
var state_20884__$1 = state_20884;
var statearr_20892_20957 = state_20884__$1;
(statearr_20892_20957[(2)] = inst_20875);

(statearr_20892_20957[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20885 === (13))){
var inst_20877 = (state_20884[(2)]);
var state_20884__$1 = (function (){var statearr_20893 = state_20884;
(statearr_20893[(9)] = inst_20877);

return statearr_20893;
})();
var statearr_20894_20958 = state_20884__$1;
(statearr_20894_20958[(2)] = null);

(statearr_20894_20958[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20885 === (6))){
var inst_20849 = (state_20884[(7)]);
var state_20884__$1 = state_20884;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20884__$1,(11),inst_20849);
} else {
if((state_val_20885 === (17))){
var inst_20870 = (state_20884[(2)]);
var state_20884__$1 = state_20884;
if(cljs.core.truth_(inst_20870)){
var statearr_20895_20959 = state_20884__$1;
(statearr_20895_20959[(1)] = (19));

} else {
var statearr_20896_20960 = state_20884__$1;
(statearr_20896_20960[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20885 === (3))){
var inst_20882 = (state_20884[(2)]);
var state_20884__$1 = state_20884;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20884__$1,inst_20882);
} else {
if((state_val_20885 === (12))){
var inst_20859 = (state_20884[(10)]);
var state_20884__$1 = state_20884;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20884__$1,(14),inst_20859);
} else {
if((state_val_20885 === (2))){
var state_20884__$1 = state_20884;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20884__$1,(4),results);
} else {
if((state_val_20885 === (19))){
var state_20884__$1 = state_20884;
var statearr_20897_20961 = state_20884__$1;
(statearr_20897_20961[(2)] = null);

(statearr_20897_20961[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20885 === (11))){
var inst_20859 = (state_20884[(2)]);
var state_20884__$1 = (function (){var statearr_20898 = state_20884;
(statearr_20898[(10)] = inst_20859);

return statearr_20898;
})();
var statearr_20899_20962 = state_20884__$1;
(statearr_20899_20962[(2)] = null);

(statearr_20899_20962[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20885 === (9))){
var state_20884__$1 = state_20884;
var statearr_20900_20963 = state_20884__$1;
(statearr_20900_20963[(2)] = null);

(statearr_20900_20963[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20885 === (5))){
var state_20884__$1 = state_20884;
if(cljs.core.truth_(close_QMARK_)){
var statearr_20901_20964 = state_20884__$1;
(statearr_20901_20964[(1)] = (8));

} else {
var statearr_20902_20965 = state_20884__$1;
(statearr_20902_20965[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20885 === (14))){
var inst_20862 = (state_20884[(8)]);
var inst_20864 = (state_20884[(11)]);
var inst_20862__$1 = (state_20884[(2)]);
var inst_20863 = (inst_20862__$1 == null);
var inst_20864__$1 = cljs.core.not.call(null,inst_20863);
var state_20884__$1 = (function (){var statearr_20903 = state_20884;
(statearr_20903[(8)] = inst_20862__$1);

(statearr_20903[(11)] = inst_20864__$1);

return statearr_20903;
})();
if(inst_20864__$1){
var statearr_20904_20966 = state_20884__$1;
(statearr_20904_20966[(1)] = (15));

} else {
var statearr_20905_20967 = state_20884__$1;
(statearr_20905_20967[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20885 === (16))){
var inst_20864 = (state_20884[(11)]);
var state_20884__$1 = state_20884;
var statearr_20906_20968 = state_20884__$1;
(statearr_20906_20968[(2)] = inst_20864);

(statearr_20906_20968[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20885 === (10))){
var inst_20856 = (state_20884[(2)]);
var state_20884__$1 = state_20884;
var statearr_20907_20969 = state_20884__$1;
(statearr_20907_20969[(2)] = inst_20856);

(statearr_20907_20969[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20885 === (18))){
var inst_20867 = (state_20884[(2)]);
var state_20884__$1 = state_20884;
var statearr_20908_20970 = state_20884__$1;
(statearr_20908_20970[(2)] = inst_20867);

(statearr_20908_20970[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20885 === (8))){
var inst_20853 = cljs.core.async.close_BANG_.call(null,to);
var state_20884__$1 = state_20884;
var statearr_20909_20971 = state_20884__$1;
(statearr_20909_20971[(2)] = inst_20853);

(statearr_20909_20971[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto__,jobs,results,process,async))
;
return ((function (switch__20255__auto__,c__20367__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____0 = (function (){
var statearr_20913 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20913[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__);

(statearr_20913[(1)] = (1));

return statearr_20913;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____1 = (function (state_20884){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_20884);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e20914){if((e20914 instanceof Object)){
var ex__20259__auto__ = e20914;
var statearr_20915_20972 = state_20884;
(statearr_20915_20972[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20884);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20914;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20973 = state_20884;
state_20884 = G__20973;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__ = function(state_20884){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____1.call(this,state_20884);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20256__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto__,jobs,results,process,async))
})();
var state__20369__auto__ = (function (){var statearr_20916 = f__20368__auto__.call(null);
(statearr_20916[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto__);

return statearr_20916;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto__,jobs,results,process,async))
);

return c__20367__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args20974 = [];
var len__19260__auto___20977 = arguments.length;
var i__19261__auto___20978 = (0);
while(true){
if((i__19261__auto___20978 < len__19260__auto___20977)){
args20974.push((arguments[i__19261__auto___20978]));

var G__20979 = (i__19261__auto___20978 + (1));
i__19261__auto___20978 = G__20979;
continue;
} else {
}
break;
}

var G__20976 = args20974.length;
switch (G__20976) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20974.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args20981 = [];
var len__19260__auto___20984 = arguments.length;
var i__19261__auto___20985 = (0);
while(true){
if((i__19261__auto___20985 < len__19260__auto___20984)){
args20981.push((arguments[i__19261__auto___20985]));

var G__20986 = (i__19261__auto___20985 + (1));
i__19261__auto___20985 = G__20986;
continue;
} else {
}
break;
}

var G__20983 = args20981.length;
switch (G__20983) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20981.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args20988 = [];
var len__19260__auto___21041 = arguments.length;
var i__19261__auto___21042 = (0);
while(true){
if((i__19261__auto___21042 < len__19260__auto___21041)){
args20988.push((arguments[i__19261__auto___21042]));

var G__21043 = (i__19261__auto___21042 + (1));
i__19261__auto___21042 = G__21043;
continue;
} else {
}
break;
}

var G__20990 = args20988.length;
switch (G__20990) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20988.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__20367__auto___21045 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto___21045,tc,fc){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto___21045,tc,fc){
return (function (state_21016){
var state_val_21017 = (state_21016[(1)]);
if((state_val_21017 === (7))){
var inst_21012 = (state_21016[(2)]);
var state_21016__$1 = state_21016;
var statearr_21018_21046 = state_21016__$1;
(statearr_21018_21046[(2)] = inst_21012);

(statearr_21018_21046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21017 === (1))){
var state_21016__$1 = state_21016;
var statearr_21019_21047 = state_21016__$1;
(statearr_21019_21047[(2)] = null);

(statearr_21019_21047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21017 === (4))){
var inst_20993 = (state_21016[(7)]);
var inst_20993__$1 = (state_21016[(2)]);
var inst_20994 = (inst_20993__$1 == null);
var state_21016__$1 = (function (){var statearr_21020 = state_21016;
(statearr_21020[(7)] = inst_20993__$1);

return statearr_21020;
})();
if(cljs.core.truth_(inst_20994)){
var statearr_21021_21048 = state_21016__$1;
(statearr_21021_21048[(1)] = (5));

} else {
var statearr_21022_21049 = state_21016__$1;
(statearr_21022_21049[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21017 === (13))){
var state_21016__$1 = state_21016;
var statearr_21023_21050 = state_21016__$1;
(statearr_21023_21050[(2)] = null);

(statearr_21023_21050[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21017 === (6))){
var inst_20993 = (state_21016[(7)]);
var inst_20999 = p.call(null,inst_20993);
var state_21016__$1 = state_21016;
if(cljs.core.truth_(inst_20999)){
var statearr_21024_21051 = state_21016__$1;
(statearr_21024_21051[(1)] = (9));

} else {
var statearr_21025_21052 = state_21016__$1;
(statearr_21025_21052[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21017 === (3))){
var inst_21014 = (state_21016[(2)]);
var state_21016__$1 = state_21016;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21016__$1,inst_21014);
} else {
if((state_val_21017 === (12))){
var state_21016__$1 = state_21016;
var statearr_21026_21053 = state_21016__$1;
(statearr_21026_21053[(2)] = null);

(statearr_21026_21053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21017 === (2))){
var state_21016__$1 = state_21016;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21016__$1,(4),ch);
} else {
if((state_val_21017 === (11))){
var inst_20993 = (state_21016[(7)]);
var inst_21003 = (state_21016[(2)]);
var state_21016__$1 = state_21016;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21016__$1,(8),inst_21003,inst_20993);
} else {
if((state_val_21017 === (9))){
var state_21016__$1 = state_21016;
var statearr_21027_21054 = state_21016__$1;
(statearr_21027_21054[(2)] = tc);

(statearr_21027_21054[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21017 === (5))){
var inst_20996 = cljs.core.async.close_BANG_.call(null,tc);
var inst_20997 = cljs.core.async.close_BANG_.call(null,fc);
var state_21016__$1 = (function (){var statearr_21028 = state_21016;
(statearr_21028[(8)] = inst_20996);

return statearr_21028;
})();
var statearr_21029_21055 = state_21016__$1;
(statearr_21029_21055[(2)] = inst_20997);

(statearr_21029_21055[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21017 === (14))){
var inst_21010 = (state_21016[(2)]);
var state_21016__$1 = state_21016;
var statearr_21030_21056 = state_21016__$1;
(statearr_21030_21056[(2)] = inst_21010);

(statearr_21030_21056[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21017 === (10))){
var state_21016__$1 = state_21016;
var statearr_21031_21057 = state_21016__$1;
(statearr_21031_21057[(2)] = fc);

(statearr_21031_21057[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21017 === (8))){
var inst_21005 = (state_21016[(2)]);
var state_21016__$1 = state_21016;
if(cljs.core.truth_(inst_21005)){
var statearr_21032_21058 = state_21016__$1;
(statearr_21032_21058[(1)] = (12));

} else {
var statearr_21033_21059 = state_21016__$1;
(statearr_21033_21059[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto___21045,tc,fc))
;
return ((function (switch__20255__auto__,c__20367__auto___21045,tc,fc){
return (function() {
var cljs$core$async$state_machine__20256__auto__ = null;
var cljs$core$async$state_machine__20256__auto____0 = (function (){
var statearr_21037 = [null,null,null,null,null,null,null,null,null];
(statearr_21037[(0)] = cljs$core$async$state_machine__20256__auto__);

(statearr_21037[(1)] = (1));

return statearr_21037;
});
var cljs$core$async$state_machine__20256__auto____1 = (function (state_21016){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_21016);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e21038){if((e21038 instanceof Object)){
var ex__20259__auto__ = e21038;
var statearr_21039_21060 = state_21016;
(statearr_21039_21060[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21016);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21038;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21061 = state_21016;
state_21016 = G__21061;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$state_machine__20256__auto__ = function(state_21016){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20256__auto____1.call(this,state_21016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20256__auto____0;
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20256__auto____1;
return cljs$core$async$state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto___21045,tc,fc))
})();
var state__20369__auto__ = (function (){var statearr_21040 = f__20368__auto__.call(null);
(statearr_21040[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto___21045);

return statearr_21040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto___21045,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__20367__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto__){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto__){
return (function (state_21125){
var state_val_21126 = (state_21125[(1)]);
if((state_val_21126 === (7))){
var inst_21121 = (state_21125[(2)]);
var state_21125__$1 = state_21125;
var statearr_21127_21148 = state_21125__$1;
(statearr_21127_21148[(2)] = inst_21121);

(statearr_21127_21148[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21126 === (1))){
var inst_21105 = init;
var state_21125__$1 = (function (){var statearr_21128 = state_21125;
(statearr_21128[(7)] = inst_21105);

return statearr_21128;
})();
var statearr_21129_21149 = state_21125__$1;
(statearr_21129_21149[(2)] = null);

(statearr_21129_21149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21126 === (4))){
var inst_21108 = (state_21125[(8)]);
var inst_21108__$1 = (state_21125[(2)]);
var inst_21109 = (inst_21108__$1 == null);
var state_21125__$1 = (function (){var statearr_21130 = state_21125;
(statearr_21130[(8)] = inst_21108__$1);

return statearr_21130;
})();
if(cljs.core.truth_(inst_21109)){
var statearr_21131_21150 = state_21125__$1;
(statearr_21131_21150[(1)] = (5));

} else {
var statearr_21132_21151 = state_21125__$1;
(statearr_21132_21151[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21126 === (6))){
var inst_21108 = (state_21125[(8)]);
var inst_21112 = (state_21125[(9)]);
var inst_21105 = (state_21125[(7)]);
var inst_21112__$1 = f.call(null,inst_21105,inst_21108);
var inst_21113 = cljs.core.reduced_QMARK_.call(null,inst_21112__$1);
var state_21125__$1 = (function (){var statearr_21133 = state_21125;
(statearr_21133[(9)] = inst_21112__$1);

return statearr_21133;
})();
if(inst_21113){
var statearr_21134_21152 = state_21125__$1;
(statearr_21134_21152[(1)] = (8));

} else {
var statearr_21135_21153 = state_21125__$1;
(statearr_21135_21153[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21126 === (3))){
var inst_21123 = (state_21125[(2)]);
var state_21125__$1 = state_21125;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21125__$1,inst_21123);
} else {
if((state_val_21126 === (2))){
var state_21125__$1 = state_21125;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21125__$1,(4),ch);
} else {
if((state_val_21126 === (9))){
var inst_21112 = (state_21125[(9)]);
var inst_21105 = inst_21112;
var state_21125__$1 = (function (){var statearr_21136 = state_21125;
(statearr_21136[(7)] = inst_21105);

return statearr_21136;
})();
var statearr_21137_21154 = state_21125__$1;
(statearr_21137_21154[(2)] = null);

(statearr_21137_21154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21126 === (5))){
var inst_21105 = (state_21125[(7)]);
var state_21125__$1 = state_21125;
var statearr_21138_21155 = state_21125__$1;
(statearr_21138_21155[(2)] = inst_21105);

(statearr_21138_21155[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21126 === (10))){
var inst_21119 = (state_21125[(2)]);
var state_21125__$1 = state_21125;
var statearr_21139_21156 = state_21125__$1;
(statearr_21139_21156[(2)] = inst_21119);

(statearr_21139_21156[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21126 === (8))){
var inst_21112 = (state_21125[(9)]);
var inst_21115 = cljs.core.deref.call(null,inst_21112);
var state_21125__$1 = state_21125;
var statearr_21140_21157 = state_21125__$1;
(statearr_21140_21157[(2)] = inst_21115);

(statearr_21140_21157[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto__))
;
return ((function (switch__20255__auto__,c__20367__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__20256__auto__ = null;
var cljs$core$async$reduce_$_state_machine__20256__auto____0 = (function (){
var statearr_21144 = [null,null,null,null,null,null,null,null,null,null];
(statearr_21144[(0)] = cljs$core$async$reduce_$_state_machine__20256__auto__);

(statearr_21144[(1)] = (1));

return statearr_21144;
});
var cljs$core$async$reduce_$_state_machine__20256__auto____1 = (function (state_21125){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_21125);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e21145){if((e21145 instanceof Object)){
var ex__20259__auto__ = e21145;
var statearr_21146_21158 = state_21125;
(statearr_21146_21158[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21125);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21145;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21159 = state_21125;
state_21125 = G__21159;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__20256__auto__ = function(state_21125){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__20256__auto____1.call(this,state_21125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__20256__auto____0;
cljs$core$async$reduce_$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__20256__auto____1;
return cljs$core$async$reduce_$_state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto__))
})();
var state__20369__auto__ = (function (){var statearr_21147 = f__20368__auto__.call(null);
(statearr_21147[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto__);

return statearr_21147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto__))
);

return c__20367__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args21160 = [];
var len__19260__auto___21212 = arguments.length;
var i__19261__auto___21213 = (0);
while(true){
if((i__19261__auto___21213 < len__19260__auto___21212)){
args21160.push((arguments[i__19261__auto___21213]));

var G__21214 = (i__19261__auto___21213 + (1));
i__19261__auto___21213 = G__21214;
continue;
} else {
}
break;
}

var G__21162 = args21160.length;
switch (G__21162) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21160.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__20367__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto__){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto__){
return (function (state_21187){
var state_val_21188 = (state_21187[(1)]);
if((state_val_21188 === (7))){
var inst_21169 = (state_21187[(2)]);
var state_21187__$1 = state_21187;
var statearr_21189_21216 = state_21187__$1;
(statearr_21189_21216[(2)] = inst_21169);

(statearr_21189_21216[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21188 === (1))){
var inst_21163 = cljs.core.seq.call(null,coll);
var inst_21164 = inst_21163;
var state_21187__$1 = (function (){var statearr_21190 = state_21187;
(statearr_21190[(7)] = inst_21164);

return statearr_21190;
})();
var statearr_21191_21217 = state_21187__$1;
(statearr_21191_21217[(2)] = null);

(statearr_21191_21217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21188 === (4))){
var inst_21164 = (state_21187[(7)]);
var inst_21167 = cljs.core.first.call(null,inst_21164);
var state_21187__$1 = state_21187;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21187__$1,(7),ch,inst_21167);
} else {
if((state_val_21188 === (13))){
var inst_21181 = (state_21187[(2)]);
var state_21187__$1 = state_21187;
var statearr_21192_21218 = state_21187__$1;
(statearr_21192_21218[(2)] = inst_21181);

(statearr_21192_21218[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21188 === (6))){
var inst_21172 = (state_21187[(2)]);
var state_21187__$1 = state_21187;
if(cljs.core.truth_(inst_21172)){
var statearr_21193_21219 = state_21187__$1;
(statearr_21193_21219[(1)] = (8));

} else {
var statearr_21194_21220 = state_21187__$1;
(statearr_21194_21220[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21188 === (3))){
var inst_21185 = (state_21187[(2)]);
var state_21187__$1 = state_21187;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21187__$1,inst_21185);
} else {
if((state_val_21188 === (12))){
var state_21187__$1 = state_21187;
var statearr_21195_21221 = state_21187__$1;
(statearr_21195_21221[(2)] = null);

(statearr_21195_21221[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21188 === (2))){
var inst_21164 = (state_21187[(7)]);
var state_21187__$1 = state_21187;
if(cljs.core.truth_(inst_21164)){
var statearr_21196_21222 = state_21187__$1;
(statearr_21196_21222[(1)] = (4));

} else {
var statearr_21197_21223 = state_21187__$1;
(statearr_21197_21223[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21188 === (11))){
var inst_21178 = cljs.core.async.close_BANG_.call(null,ch);
var state_21187__$1 = state_21187;
var statearr_21198_21224 = state_21187__$1;
(statearr_21198_21224[(2)] = inst_21178);

(statearr_21198_21224[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21188 === (9))){
var state_21187__$1 = state_21187;
if(cljs.core.truth_(close_QMARK_)){
var statearr_21199_21225 = state_21187__$1;
(statearr_21199_21225[(1)] = (11));

} else {
var statearr_21200_21226 = state_21187__$1;
(statearr_21200_21226[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21188 === (5))){
var inst_21164 = (state_21187[(7)]);
var state_21187__$1 = state_21187;
var statearr_21201_21227 = state_21187__$1;
(statearr_21201_21227[(2)] = inst_21164);

(statearr_21201_21227[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21188 === (10))){
var inst_21183 = (state_21187[(2)]);
var state_21187__$1 = state_21187;
var statearr_21202_21228 = state_21187__$1;
(statearr_21202_21228[(2)] = inst_21183);

(statearr_21202_21228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21188 === (8))){
var inst_21164 = (state_21187[(7)]);
var inst_21174 = cljs.core.next.call(null,inst_21164);
var inst_21164__$1 = inst_21174;
var state_21187__$1 = (function (){var statearr_21203 = state_21187;
(statearr_21203[(7)] = inst_21164__$1);

return statearr_21203;
})();
var statearr_21204_21229 = state_21187__$1;
(statearr_21204_21229[(2)] = null);

(statearr_21204_21229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto__))
;
return ((function (switch__20255__auto__,c__20367__auto__){
return (function() {
var cljs$core$async$state_machine__20256__auto__ = null;
var cljs$core$async$state_machine__20256__auto____0 = (function (){
var statearr_21208 = [null,null,null,null,null,null,null,null];
(statearr_21208[(0)] = cljs$core$async$state_machine__20256__auto__);

(statearr_21208[(1)] = (1));

return statearr_21208;
});
var cljs$core$async$state_machine__20256__auto____1 = (function (state_21187){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_21187);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e21209){if((e21209 instanceof Object)){
var ex__20259__auto__ = e21209;
var statearr_21210_21230 = state_21187;
(statearr_21210_21230[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21187);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21209;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21231 = state_21187;
state_21187 = G__21231;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$state_machine__20256__auto__ = function(state_21187){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20256__auto____1.call(this,state_21187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20256__auto____0;
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20256__auto____1;
return cljs$core$async$state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto__))
})();
var state__20369__auto__ = (function (){var statearr_21211 = f__20368__auto__.call(null);
(statearr_21211[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto__);

return statearr_21211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto__))
);

return c__20367__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__18857__auto__ = (((_ == null))?null:_);
var m__18858__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,_);
} else {
var m__18858__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__18857__auto__ = (((m == null))?null:m);
var m__18858__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__18858__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__18857__auto__ = (((m == null))?null:m);
var m__18858__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,m,ch);
} else {
var m__18858__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__18857__auto__ = (((m == null))?null:m);
var m__18858__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,m);
} else {
var m__18858__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async21453 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21453 = (function (mult,ch,cs,meta21454){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta21454 = meta21454;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21453.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_21455,meta21454__$1){
var self__ = this;
var _21455__$1 = this;
return (new cljs.core.async.t_cljs$core$async21453(self__.mult,self__.ch,self__.cs,meta21454__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async21453.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_21455){
var self__ = this;
var _21455__$1 = this;
return self__.meta21454;
});})(cs))
;

cljs.core.async.t_cljs$core$async21453.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async21453.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async21453.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async21453.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21453.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21453.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async21453.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta21454","meta21454",-427195558,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async21453.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21453.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21453";

cljs.core.async.t_cljs$core$async21453.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async21453");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async21453 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async21453(mult__$1,ch__$1,cs__$1,meta21454){
return (new cljs.core.async.t_cljs$core$async21453(mult__$1,ch__$1,cs__$1,meta21454));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async21453(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__20367__auto___21674 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto___21674,cs,m,dchan,dctr,done){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto___21674,cs,m,dchan,dctr,done){
return (function (state_21586){
var state_val_21587 = (state_21586[(1)]);
if((state_val_21587 === (7))){
var inst_21582 = (state_21586[(2)]);
var state_21586__$1 = state_21586;
var statearr_21588_21675 = state_21586__$1;
(statearr_21588_21675[(2)] = inst_21582);

(statearr_21588_21675[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (20))){
var inst_21487 = (state_21586[(7)]);
var inst_21497 = cljs.core.first.call(null,inst_21487);
var inst_21498 = cljs.core.nth.call(null,inst_21497,(0),null);
var inst_21499 = cljs.core.nth.call(null,inst_21497,(1),null);
var state_21586__$1 = (function (){var statearr_21589 = state_21586;
(statearr_21589[(8)] = inst_21498);

return statearr_21589;
})();
if(cljs.core.truth_(inst_21499)){
var statearr_21590_21676 = state_21586__$1;
(statearr_21590_21676[(1)] = (22));

} else {
var statearr_21591_21677 = state_21586__$1;
(statearr_21591_21677[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (27))){
var inst_21527 = (state_21586[(9)]);
var inst_21529 = (state_21586[(10)]);
var inst_21458 = (state_21586[(11)]);
var inst_21534 = (state_21586[(12)]);
var inst_21534__$1 = cljs.core._nth.call(null,inst_21527,inst_21529);
var inst_21535 = cljs.core.async.put_BANG_.call(null,inst_21534__$1,inst_21458,done);
var state_21586__$1 = (function (){var statearr_21592 = state_21586;
(statearr_21592[(12)] = inst_21534__$1);

return statearr_21592;
})();
if(cljs.core.truth_(inst_21535)){
var statearr_21593_21678 = state_21586__$1;
(statearr_21593_21678[(1)] = (30));

} else {
var statearr_21594_21679 = state_21586__$1;
(statearr_21594_21679[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (1))){
var state_21586__$1 = state_21586;
var statearr_21595_21680 = state_21586__$1;
(statearr_21595_21680[(2)] = null);

(statearr_21595_21680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (24))){
var inst_21487 = (state_21586[(7)]);
var inst_21504 = (state_21586[(2)]);
var inst_21505 = cljs.core.next.call(null,inst_21487);
var inst_21467 = inst_21505;
var inst_21468 = null;
var inst_21469 = (0);
var inst_21470 = (0);
var state_21586__$1 = (function (){var statearr_21596 = state_21586;
(statearr_21596[(13)] = inst_21469);

(statearr_21596[(14)] = inst_21470);

(statearr_21596[(15)] = inst_21504);

(statearr_21596[(16)] = inst_21468);

(statearr_21596[(17)] = inst_21467);

return statearr_21596;
})();
var statearr_21597_21681 = state_21586__$1;
(statearr_21597_21681[(2)] = null);

(statearr_21597_21681[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (39))){
var state_21586__$1 = state_21586;
var statearr_21601_21682 = state_21586__$1;
(statearr_21601_21682[(2)] = null);

(statearr_21601_21682[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (4))){
var inst_21458 = (state_21586[(11)]);
var inst_21458__$1 = (state_21586[(2)]);
var inst_21459 = (inst_21458__$1 == null);
var state_21586__$1 = (function (){var statearr_21602 = state_21586;
(statearr_21602[(11)] = inst_21458__$1);

return statearr_21602;
})();
if(cljs.core.truth_(inst_21459)){
var statearr_21603_21683 = state_21586__$1;
(statearr_21603_21683[(1)] = (5));

} else {
var statearr_21604_21684 = state_21586__$1;
(statearr_21604_21684[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (15))){
var inst_21469 = (state_21586[(13)]);
var inst_21470 = (state_21586[(14)]);
var inst_21468 = (state_21586[(16)]);
var inst_21467 = (state_21586[(17)]);
var inst_21483 = (state_21586[(2)]);
var inst_21484 = (inst_21470 + (1));
var tmp21598 = inst_21469;
var tmp21599 = inst_21468;
var tmp21600 = inst_21467;
var inst_21467__$1 = tmp21600;
var inst_21468__$1 = tmp21599;
var inst_21469__$1 = tmp21598;
var inst_21470__$1 = inst_21484;
var state_21586__$1 = (function (){var statearr_21605 = state_21586;
(statearr_21605[(13)] = inst_21469__$1);

(statearr_21605[(14)] = inst_21470__$1);

(statearr_21605[(18)] = inst_21483);

(statearr_21605[(16)] = inst_21468__$1);

(statearr_21605[(17)] = inst_21467__$1);

return statearr_21605;
})();
var statearr_21606_21685 = state_21586__$1;
(statearr_21606_21685[(2)] = null);

(statearr_21606_21685[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (21))){
var inst_21508 = (state_21586[(2)]);
var state_21586__$1 = state_21586;
var statearr_21610_21686 = state_21586__$1;
(statearr_21610_21686[(2)] = inst_21508);

(statearr_21610_21686[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (31))){
var inst_21534 = (state_21586[(12)]);
var inst_21538 = done.call(null,null);
var inst_21539 = cljs.core.async.untap_STAR_.call(null,m,inst_21534);
var state_21586__$1 = (function (){var statearr_21611 = state_21586;
(statearr_21611[(19)] = inst_21538);

return statearr_21611;
})();
var statearr_21612_21687 = state_21586__$1;
(statearr_21612_21687[(2)] = inst_21539);

(statearr_21612_21687[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (32))){
var inst_21527 = (state_21586[(9)]);
var inst_21529 = (state_21586[(10)]);
var inst_21528 = (state_21586[(20)]);
var inst_21526 = (state_21586[(21)]);
var inst_21541 = (state_21586[(2)]);
var inst_21542 = (inst_21529 + (1));
var tmp21607 = inst_21527;
var tmp21608 = inst_21528;
var tmp21609 = inst_21526;
var inst_21526__$1 = tmp21609;
var inst_21527__$1 = tmp21607;
var inst_21528__$1 = tmp21608;
var inst_21529__$1 = inst_21542;
var state_21586__$1 = (function (){var statearr_21613 = state_21586;
(statearr_21613[(9)] = inst_21527__$1);

(statearr_21613[(10)] = inst_21529__$1);

(statearr_21613[(22)] = inst_21541);

(statearr_21613[(20)] = inst_21528__$1);

(statearr_21613[(21)] = inst_21526__$1);

return statearr_21613;
})();
var statearr_21614_21688 = state_21586__$1;
(statearr_21614_21688[(2)] = null);

(statearr_21614_21688[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (40))){
var inst_21554 = (state_21586[(23)]);
var inst_21558 = done.call(null,null);
var inst_21559 = cljs.core.async.untap_STAR_.call(null,m,inst_21554);
var state_21586__$1 = (function (){var statearr_21615 = state_21586;
(statearr_21615[(24)] = inst_21558);

return statearr_21615;
})();
var statearr_21616_21689 = state_21586__$1;
(statearr_21616_21689[(2)] = inst_21559);

(statearr_21616_21689[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (33))){
var inst_21545 = (state_21586[(25)]);
var inst_21547 = cljs.core.chunked_seq_QMARK_.call(null,inst_21545);
var state_21586__$1 = state_21586;
if(inst_21547){
var statearr_21617_21690 = state_21586__$1;
(statearr_21617_21690[(1)] = (36));

} else {
var statearr_21618_21691 = state_21586__$1;
(statearr_21618_21691[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (13))){
var inst_21477 = (state_21586[(26)]);
var inst_21480 = cljs.core.async.close_BANG_.call(null,inst_21477);
var state_21586__$1 = state_21586;
var statearr_21619_21692 = state_21586__$1;
(statearr_21619_21692[(2)] = inst_21480);

(statearr_21619_21692[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (22))){
var inst_21498 = (state_21586[(8)]);
var inst_21501 = cljs.core.async.close_BANG_.call(null,inst_21498);
var state_21586__$1 = state_21586;
var statearr_21620_21693 = state_21586__$1;
(statearr_21620_21693[(2)] = inst_21501);

(statearr_21620_21693[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (36))){
var inst_21545 = (state_21586[(25)]);
var inst_21549 = cljs.core.chunk_first.call(null,inst_21545);
var inst_21550 = cljs.core.chunk_rest.call(null,inst_21545);
var inst_21551 = cljs.core.count.call(null,inst_21549);
var inst_21526 = inst_21550;
var inst_21527 = inst_21549;
var inst_21528 = inst_21551;
var inst_21529 = (0);
var state_21586__$1 = (function (){var statearr_21621 = state_21586;
(statearr_21621[(9)] = inst_21527);

(statearr_21621[(10)] = inst_21529);

(statearr_21621[(20)] = inst_21528);

(statearr_21621[(21)] = inst_21526);

return statearr_21621;
})();
var statearr_21622_21694 = state_21586__$1;
(statearr_21622_21694[(2)] = null);

(statearr_21622_21694[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (41))){
var inst_21545 = (state_21586[(25)]);
var inst_21561 = (state_21586[(2)]);
var inst_21562 = cljs.core.next.call(null,inst_21545);
var inst_21526 = inst_21562;
var inst_21527 = null;
var inst_21528 = (0);
var inst_21529 = (0);
var state_21586__$1 = (function (){var statearr_21623 = state_21586;
(statearr_21623[(9)] = inst_21527);

(statearr_21623[(10)] = inst_21529);

(statearr_21623[(27)] = inst_21561);

(statearr_21623[(20)] = inst_21528);

(statearr_21623[(21)] = inst_21526);

return statearr_21623;
})();
var statearr_21624_21695 = state_21586__$1;
(statearr_21624_21695[(2)] = null);

(statearr_21624_21695[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (43))){
var state_21586__$1 = state_21586;
var statearr_21625_21696 = state_21586__$1;
(statearr_21625_21696[(2)] = null);

(statearr_21625_21696[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (29))){
var inst_21570 = (state_21586[(2)]);
var state_21586__$1 = state_21586;
var statearr_21626_21697 = state_21586__$1;
(statearr_21626_21697[(2)] = inst_21570);

(statearr_21626_21697[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (44))){
var inst_21579 = (state_21586[(2)]);
var state_21586__$1 = (function (){var statearr_21627 = state_21586;
(statearr_21627[(28)] = inst_21579);

return statearr_21627;
})();
var statearr_21628_21698 = state_21586__$1;
(statearr_21628_21698[(2)] = null);

(statearr_21628_21698[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (6))){
var inst_21518 = (state_21586[(29)]);
var inst_21517 = cljs.core.deref.call(null,cs);
var inst_21518__$1 = cljs.core.keys.call(null,inst_21517);
var inst_21519 = cljs.core.count.call(null,inst_21518__$1);
var inst_21520 = cljs.core.reset_BANG_.call(null,dctr,inst_21519);
var inst_21525 = cljs.core.seq.call(null,inst_21518__$1);
var inst_21526 = inst_21525;
var inst_21527 = null;
var inst_21528 = (0);
var inst_21529 = (0);
var state_21586__$1 = (function (){var statearr_21629 = state_21586;
(statearr_21629[(9)] = inst_21527);

(statearr_21629[(10)] = inst_21529);

(statearr_21629[(30)] = inst_21520);

(statearr_21629[(20)] = inst_21528);

(statearr_21629[(29)] = inst_21518__$1);

(statearr_21629[(21)] = inst_21526);

return statearr_21629;
})();
var statearr_21630_21699 = state_21586__$1;
(statearr_21630_21699[(2)] = null);

(statearr_21630_21699[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (28))){
var inst_21545 = (state_21586[(25)]);
var inst_21526 = (state_21586[(21)]);
var inst_21545__$1 = cljs.core.seq.call(null,inst_21526);
var state_21586__$1 = (function (){var statearr_21631 = state_21586;
(statearr_21631[(25)] = inst_21545__$1);

return statearr_21631;
})();
if(inst_21545__$1){
var statearr_21632_21700 = state_21586__$1;
(statearr_21632_21700[(1)] = (33));

} else {
var statearr_21633_21701 = state_21586__$1;
(statearr_21633_21701[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (25))){
var inst_21529 = (state_21586[(10)]);
var inst_21528 = (state_21586[(20)]);
var inst_21531 = (inst_21529 < inst_21528);
var inst_21532 = inst_21531;
var state_21586__$1 = state_21586;
if(cljs.core.truth_(inst_21532)){
var statearr_21634_21702 = state_21586__$1;
(statearr_21634_21702[(1)] = (27));

} else {
var statearr_21635_21703 = state_21586__$1;
(statearr_21635_21703[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (34))){
var state_21586__$1 = state_21586;
var statearr_21636_21704 = state_21586__$1;
(statearr_21636_21704[(2)] = null);

(statearr_21636_21704[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (17))){
var state_21586__$1 = state_21586;
var statearr_21637_21705 = state_21586__$1;
(statearr_21637_21705[(2)] = null);

(statearr_21637_21705[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (3))){
var inst_21584 = (state_21586[(2)]);
var state_21586__$1 = state_21586;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21586__$1,inst_21584);
} else {
if((state_val_21587 === (12))){
var inst_21513 = (state_21586[(2)]);
var state_21586__$1 = state_21586;
var statearr_21638_21706 = state_21586__$1;
(statearr_21638_21706[(2)] = inst_21513);

(statearr_21638_21706[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (2))){
var state_21586__$1 = state_21586;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21586__$1,(4),ch);
} else {
if((state_val_21587 === (23))){
var state_21586__$1 = state_21586;
var statearr_21639_21707 = state_21586__$1;
(statearr_21639_21707[(2)] = null);

(statearr_21639_21707[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (35))){
var inst_21568 = (state_21586[(2)]);
var state_21586__$1 = state_21586;
var statearr_21640_21708 = state_21586__$1;
(statearr_21640_21708[(2)] = inst_21568);

(statearr_21640_21708[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (19))){
var inst_21487 = (state_21586[(7)]);
var inst_21491 = cljs.core.chunk_first.call(null,inst_21487);
var inst_21492 = cljs.core.chunk_rest.call(null,inst_21487);
var inst_21493 = cljs.core.count.call(null,inst_21491);
var inst_21467 = inst_21492;
var inst_21468 = inst_21491;
var inst_21469 = inst_21493;
var inst_21470 = (0);
var state_21586__$1 = (function (){var statearr_21641 = state_21586;
(statearr_21641[(13)] = inst_21469);

(statearr_21641[(14)] = inst_21470);

(statearr_21641[(16)] = inst_21468);

(statearr_21641[(17)] = inst_21467);

return statearr_21641;
})();
var statearr_21642_21709 = state_21586__$1;
(statearr_21642_21709[(2)] = null);

(statearr_21642_21709[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (11))){
var inst_21487 = (state_21586[(7)]);
var inst_21467 = (state_21586[(17)]);
var inst_21487__$1 = cljs.core.seq.call(null,inst_21467);
var state_21586__$1 = (function (){var statearr_21643 = state_21586;
(statearr_21643[(7)] = inst_21487__$1);

return statearr_21643;
})();
if(inst_21487__$1){
var statearr_21644_21710 = state_21586__$1;
(statearr_21644_21710[(1)] = (16));

} else {
var statearr_21645_21711 = state_21586__$1;
(statearr_21645_21711[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (9))){
var inst_21515 = (state_21586[(2)]);
var state_21586__$1 = state_21586;
var statearr_21646_21712 = state_21586__$1;
(statearr_21646_21712[(2)] = inst_21515);

(statearr_21646_21712[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (5))){
var inst_21465 = cljs.core.deref.call(null,cs);
var inst_21466 = cljs.core.seq.call(null,inst_21465);
var inst_21467 = inst_21466;
var inst_21468 = null;
var inst_21469 = (0);
var inst_21470 = (0);
var state_21586__$1 = (function (){var statearr_21647 = state_21586;
(statearr_21647[(13)] = inst_21469);

(statearr_21647[(14)] = inst_21470);

(statearr_21647[(16)] = inst_21468);

(statearr_21647[(17)] = inst_21467);

return statearr_21647;
})();
var statearr_21648_21713 = state_21586__$1;
(statearr_21648_21713[(2)] = null);

(statearr_21648_21713[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (14))){
var state_21586__$1 = state_21586;
var statearr_21649_21714 = state_21586__$1;
(statearr_21649_21714[(2)] = null);

(statearr_21649_21714[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (45))){
var inst_21576 = (state_21586[(2)]);
var state_21586__$1 = state_21586;
var statearr_21650_21715 = state_21586__$1;
(statearr_21650_21715[(2)] = inst_21576);

(statearr_21650_21715[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (26))){
var inst_21518 = (state_21586[(29)]);
var inst_21572 = (state_21586[(2)]);
var inst_21573 = cljs.core.seq.call(null,inst_21518);
var state_21586__$1 = (function (){var statearr_21651 = state_21586;
(statearr_21651[(31)] = inst_21572);

return statearr_21651;
})();
if(inst_21573){
var statearr_21652_21716 = state_21586__$1;
(statearr_21652_21716[(1)] = (42));

} else {
var statearr_21653_21717 = state_21586__$1;
(statearr_21653_21717[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (16))){
var inst_21487 = (state_21586[(7)]);
var inst_21489 = cljs.core.chunked_seq_QMARK_.call(null,inst_21487);
var state_21586__$1 = state_21586;
if(inst_21489){
var statearr_21654_21718 = state_21586__$1;
(statearr_21654_21718[(1)] = (19));

} else {
var statearr_21655_21719 = state_21586__$1;
(statearr_21655_21719[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (38))){
var inst_21565 = (state_21586[(2)]);
var state_21586__$1 = state_21586;
var statearr_21656_21720 = state_21586__$1;
(statearr_21656_21720[(2)] = inst_21565);

(statearr_21656_21720[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (30))){
var state_21586__$1 = state_21586;
var statearr_21657_21721 = state_21586__$1;
(statearr_21657_21721[(2)] = null);

(statearr_21657_21721[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (10))){
var inst_21470 = (state_21586[(14)]);
var inst_21468 = (state_21586[(16)]);
var inst_21476 = cljs.core._nth.call(null,inst_21468,inst_21470);
var inst_21477 = cljs.core.nth.call(null,inst_21476,(0),null);
var inst_21478 = cljs.core.nth.call(null,inst_21476,(1),null);
var state_21586__$1 = (function (){var statearr_21658 = state_21586;
(statearr_21658[(26)] = inst_21477);

return statearr_21658;
})();
if(cljs.core.truth_(inst_21478)){
var statearr_21659_21722 = state_21586__$1;
(statearr_21659_21722[(1)] = (13));

} else {
var statearr_21660_21723 = state_21586__$1;
(statearr_21660_21723[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (18))){
var inst_21511 = (state_21586[(2)]);
var state_21586__$1 = state_21586;
var statearr_21661_21724 = state_21586__$1;
(statearr_21661_21724[(2)] = inst_21511);

(statearr_21661_21724[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (42))){
var state_21586__$1 = state_21586;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21586__$1,(45),dchan);
} else {
if((state_val_21587 === (37))){
var inst_21458 = (state_21586[(11)]);
var inst_21545 = (state_21586[(25)]);
var inst_21554 = (state_21586[(23)]);
var inst_21554__$1 = cljs.core.first.call(null,inst_21545);
var inst_21555 = cljs.core.async.put_BANG_.call(null,inst_21554__$1,inst_21458,done);
var state_21586__$1 = (function (){var statearr_21662 = state_21586;
(statearr_21662[(23)] = inst_21554__$1);

return statearr_21662;
})();
if(cljs.core.truth_(inst_21555)){
var statearr_21663_21725 = state_21586__$1;
(statearr_21663_21725[(1)] = (39));

} else {
var statearr_21664_21726 = state_21586__$1;
(statearr_21664_21726[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21587 === (8))){
var inst_21469 = (state_21586[(13)]);
var inst_21470 = (state_21586[(14)]);
var inst_21472 = (inst_21470 < inst_21469);
var inst_21473 = inst_21472;
var state_21586__$1 = state_21586;
if(cljs.core.truth_(inst_21473)){
var statearr_21665_21727 = state_21586__$1;
(statearr_21665_21727[(1)] = (10));

} else {
var statearr_21666_21728 = state_21586__$1;
(statearr_21666_21728[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto___21674,cs,m,dchan,dctr,done))
;
return ((function (switch__20255__auto__,c__20367__auto___21674,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__20256__auto__ = null;
var cljs$core$async$mult_$_state_machine__20256__auto____0 = (function (){
var statearr_21670 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21670[(0)] = cljs$core$async$mult_$_state_machine__20256__auto__);

(statearr_21670[(1)] = (1));

return statearr_21670;
});
var cljs$core$async$mult_$_state_machine__20256__auto____1 = (function (state_21586){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_21586);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e21671){if((e21671 instanceof Object)){
var ex__20259__auto__ = e21671;
var statearr_21672_21729 = state_21586;
(statearr_21672_21729[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21586);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21671;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21730 = state_21586;
state_21586 = G__21730;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__20256__auto__ = function(state_21586){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__20256__auto____1.call(this,state_21586);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__20256__auto____0;
cljs$core$async$mult_$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__20256__auto____1;
return cljs$core$async$mult_$_state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto___21674,cs,m,dchan,dctr,done))
})();
var state__20369__auto__ = (function (){var statearr_21673 = f__20368__auto__.call(null);
(statearr_21673[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto___21674);

return statearr_21673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto___21674,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args21731 = [];
var len__19260__auto___21734 = arguments.length;
var i__19261__auto___21735 = (0);
while(true){
if((i__19261__auto___21735 < len__19260__auto___21734)){
args21731.push((arguments[i__19261__auto___21735]));

var G__21736 = (i__19261__auto___21735 + (1));
i__19261__auto___21735 = G__21736;
continue;
} else {
}
break;
}

var G__21733 = args21731.length;
switch (G__21733) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21731.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__18857__auto__ = (((m == null))?null:m);
var m__18858__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,m,ch);
} else {
var m__18858__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__18857__auto__ = (((m == null))?null:m);
var m__18858__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,m,ch);
} else {
var m__18858__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__18857__auto__ = (((m == null))?null:m);
var m__18858__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,m);
} else {
var m__18858__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__18857__auto__ = (((m == null))?null:m);
var m__18858__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,m,state_map);
} else {
var m__18858__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__18857__auto__ = (((m == null))?null:m);
var m__18858__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,m,mode);
} else {
var m__18858__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__19267__auto__ = [];
var len__19260__auto___21748 = arguments.length;
var i__19261__auto___21749 = (0);
while(true){
if((i__19261__auto___21749 < len__19260__auto___21748)){
args__19267__auto__.push((arguments[i__19261__auto___21749]));

var G__21750 = (i__19261__auto___21749 + (1));
i__19261__auto___21749 = G__21750;
continue;
} else {
}
break;
}

var argseq__19268__auto__ = ((((3) < args__19267__auto__.length))?(new cljs.core.IndexedSeq(args__19267__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__19268__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__21742){
var map__21743 = p__21742;
var map__21743__$1 = ((((!((map__21743 == null)))?((((map__21743.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21743.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21743):map__21743);
var opts = map__21743__$1;
var statearr_21745_21751 = state;
(statearr_21745_21751[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__21743,map__21743__$1,opts){
return (function (val){
var statearr_21746_21752 = state;
(statearr_21746_21752[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__21743,map__21743__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_21747_21753 = state;
(statearr_21747_21753[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq21738){
var G__21739 = cljs.core.first.call(null,seq21738);
var seq21738__$1 = cljs.core.next.call(null,seq21738);
var G__21740 = cljs.core.first.call(null,seq21738__$1);
var seq21738__$2 = cljs.core.next.call(null,seq21738__$1);
var G__21741 = cljs.core.first.call(null,seq21738__$2);
var seq21738__$3 = cljs.core.next.call(null,seq21738__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21739,G__21740,G__21741,seq21738__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async21917 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21917 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta21918){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta21918 = meta21918;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21917.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_21919,meta21918__$1){
var self__ = this;
var _21919__$1 = this;
return (new cljs.core.async.t_cljs$core$async21917(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta21918__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21917.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_21919){
var self__ = this;
var _21919__$1 = this;
return self__.meta21918;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21917.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async21917.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21917.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async21917.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21917.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21917.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21917.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21917.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21917.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta21918","meta21918",-1984892735,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async21917.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21917.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21917";

cljs.core.async.t_cljs$core$async21917.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async21917");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async21917 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async21917(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta21918){
return (new cljs.core.async.t_cljs$core$async21917(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta21918));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async21917(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20367__auto___22080 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto___22080,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto___22080,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_22017){
var state_val_22018 = (state_22017[(1)]);
if((state_val_22018 === (7))){
var inst_21935 = (state_22017[(2)]);
var state_22017__$1 = state_22017;
var statearr_22019_22081 = state_22017__$1;
(statearr_22019_22081[(2)] = inst_21935);

(statearr_22019_22081[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (20))){
var inst_21947 = (state_22017[(7)]);
var state_22017__$1 = state_22017;
var statearr_22020_22082 = state_22017__$1;
(statearr_22020_22082[(2)] = inst_21947);

(statearr_22020_22082[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (27))){
var state_22017__$1 = state_22017;
var statearr_22021_22083 = state_22017__$1;
(statearr_22021_22083[(2)] = null);

(statearr_22021_22083[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (1))){
var inst_21923 = (state_22017[(8)]);
var inst_21923__$1 = calc_state.call(null);
var inst_21925 = (inst_21923__$1 == null);
var inst_21926 = cljs.core.not.call(null,inst_21925);
var state_22017__$1 = (function (){var statearr_22022 = state_22017;
(statearr_22022[(8)] = inst_21923__$1);

return statearr_22022;
})();
if(inst_21926){
var statearr_22023_22084 = state_22017__$1;
(statearr_22023_22084[(1)] = (2));

} else {
var statearr_22024_22085 = state_22017__$1;
(statearr_22024_22085[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (24))){
var inst_21991 = (state_22017[(9)]);
var inst_21970 = (state_22017[(10)]);
var inst_21977 = (state_22017[(11)]);
var inst_21991__$1 = inst_21970.call(null,inst_21977);
var state_22017__$1 = (function (){var statearr_22025 = state_22017;
(statearr_22025[(9)] = inst_21991__$1);

return statearr_22025;
})();
if(cljs.core.truth_(inst_21991__$1)){
var statearr_22026_22086 = state_22017__$1;
(statearr_22026_22086[(1)] = (29));

} else {
var statearr_22027_22087 = state_22017__$1;
(statearr_22027_22087[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (4))){
var inst_21938 = (state_22017[(2)]);
var state_22017__$1 = state_22017;
if(cljs.core.truth_(inst_21938)){
var statearr_22028_22088 = state_22017__$1;
(statearr_22028_22088[(1)] = (8));

} else {
var statearr_22029_22089 = state_22017__$1;
(statearr_22029_22089[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (15))){
var inst_21964 = (state_22017[(2)]);
var state_22017__$1 = state_22017;
if(cljs.core.truth_(inst_21964)){
var statearr_22030_22090 = state_22017__$1;
(statearr_22030_22090[(1)] = (19));

} else {
var statearr_22031_22091 = state_22017__$1;
(statearr_22031_22091[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (21))){
var inst_21969 = (state_22017[(12)]);
var inst_21969__$1 = (state_22017[(2)]);
var inst_21970 = cljs.core.get.call(null,inst_21969__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_21971 = cljs.core.get.call(null,inst_21969__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_21972 = cljs.core.get.call(null,inst_21969__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_22017__$1 = (function (){var statearr_22032 = state_22017;
(statearr_22032[(12)] = inst_21969__$1);

(statearr_22032[(13)] = inst_21971);

(statearr_22032[(10)] = inst_21970);

return statearr_22032;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_22017__$1,(22),inst_21972);
} else {
if((state_val_22018 === (31))){
var inst_21999 = (state_22017[(2)]);
var state_22017__$1 = state_22017;
if(cljs.core.truth_(inst_21999)){
var statearr_22033_22092 = state_22017__$1;
(statearr_22033_22092[(1)] = (32));

} else {
var statearr_22034_22093 = state_22017__$1;
(statearr_22034_22093[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (32))){
var inst_21976 = (state_22017[(14)]);
var state_22017__$1 = state_22017;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22017__$1,(35),out,inst_21976);
} else {
if((state_val_22018 === (33))){
var inst_21969 = (state_22017[(12)]);
var inst_21947 = inst_21969;
var state_22017__$1 = (function (){var statearr_22035 = state_22017;
(statearr_22035[(7)] = inst_21947);

return statearr_22035;
})();
var statearr_22036_22094 = state_22017__$1;
(statearr_22036_22094[(2)] = null);

(statearr_22036_22094[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (13))){
var inst_21947 = (state_22017[(7)]);
var inst_21954 = inst_21947.cljs$lang$protocol_mask$partition0$;
var inst_21955 = (inst_21954 & (64));
var inst_21956 = inst_21947.cljs$core$ISeq$;
var inst_21957 = (inst_21955) || (inst_21956);
var state_22017__$1 = state_22017;
if(cljs.core.truth_(inst_21957)){
var statearr_22037_22095 = state_22017__$1;
(statearr_22037_22095[(1)] = (16));

} else {
var statearr_22038_22096 = state_22017__$1;
(statearr_22038_22096[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (22))){
var inst_21976 = (state_22017[(14)]);
var inst_21977 = (state_22017[(11)]);
var inst_21975 = (state_22017[(2)]);
var inst_21976__$1 = cljs.core.nth.call(null,inst_21975,(0),null);
var inst_21977__$1 = cljs.core.nth.call(null,inst_21975,(1),null);
var inst_21978 = (inst_21976__$1 == null);
var inst_21979 = cljs.core._EQ_.call(null,inst_21977__$1,change);
var inst_21980 = (inst_21978) || (inst_21979);
var state_22017__$1 = (function (){var statearr_22039 = state_22017;
(statearr_22039[(14)] = inst_21976__$1);

(statearr_22039[(11)] = inst_21977__$1);

return statearr_22039;
})();
if(cljs.core.truth_(inst_21980)){
var statearr_22040_22097 = state_22017__$1;
(statearr_22040_22097[(1)] = (23));

} else {
var statearr_22041_22098 = state_22017__$1;
(statearr_22041_22098[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (36))){
var inst_21969 = (state_22017[(12)]);
var inst_21947 = inst_21969;
var state_22017__$1 = (function (){var statearr_22042 = state_22017;
(statearr_22042[(7)] = inst_21947);

return statearr_22042;
})();
var statearr_22043_22099 = state_22017__$1;
(statearr_22043_22099[(2)] = null);

(statearr_22043_22099[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (29))){
var inst_21991 = (state_22017[(9)]);
var state_22017__$1 = state_22017;
var statearr_22044_22100 = state_22017__$1;
(statearr_22044_22100[(2)] = inst_21991);

(statearr_22044_22100[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (6))){
var state_22017__$1 = state_22017;
var statearr_22045_22101 = state_22017__$1;
(statearr_22045_22101[(2)] = false);

(statearr_22045_22101[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (28))){
var inst_21987 = (state_22017[(2)]);
var inst_21988 = calc_state.call(null);
var inst_21947 = inst_21988;
var state_22017__$1 = (function (){var statearr_22046 = state_22017;
(statearr_22046[(15)] = inst_21987);

(statearr_22046[(7)] = inst_21947);

return statearr_22046;
})();
var statearr_22047_22102 = state_22017__$1;
(statearr_22047_22102[(2)] = null);

(statearr_22047_22102[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (25))){
var inst_22013 = (state_22017[(2)]);
var state_22017__$1 = state_22017;
var statearr_22048_22103 = state_22017__$1;
(statearr_22048_22103[(2)] = inst_22013);

(statearr_22048_22103[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (34))){
var inst_22011 = (state_22017[(2)]);
var state_22017__$1 = state_22017;
var statearr_22049_22104 = state_22017__$1;
(statearr_22049_22104[(2)] = inst_22011);

(statearr_22049_22104[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (17))){
var state_22017__$1 = state_22017;
var statearr_22050_22105 = state_22017__$1;
(statearr_22050_22105[(2)] = false);

(statearr_22050_22105[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (3))){
var state_22017__$1 = state_22017;
var statearr_22051_22106 = state_22017__$1;
(statearr_22051_22106[(2)] = false);

(statearr_22051_22106[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (12))){
var inst_22015 = (state_22017[(2)]);
var state_22017__$1 = state_22017;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22017__$1,inst_22015);
} else {
if((state_val_22018 === (2))){
var inst_21923 = (state_22017[(8)]);
var inst_21928 = inst_21923.cljs$lang$protocol_mask$partition0$;
var inst_21929 = (inst_21928 & (64));
var inst_21930 = inst_21923.cljs$core$ISeq$;
var inst_21931 = (inst_21929) || (inst_21930);
var state_22017__$1 = state_22017;
if(cljs.core.truth_(inst_21931)){
var statearr_22052_22107 = state_22017__$1;
(statearr_22052_22107[(1)] = (5));

} else {
var statearr_22053_22108 = state_22017__$1;
(statearr_22053_22108[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (23))){
var inst_21976 = (state_22017[(14)]);
var inst_21982 = (inst_21976 == null);
var state_22017__$1 = state_22017;
if(cljs.core.truth_(inst_21982)){
var statearr_22054_22109 = state_22017__$1;
(statearr_22054_22109[(1)] = (26));

} else {
var statearr_22055_22110 = state_22017__$1;
(statearr_22055_22110[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (35))){
var inst_22002 = (state_22017[(2)]);
var state_22017__$1 = state_22017;
if(cljs.core.truth_(inst_22002)){
var statearr_22056_22111 = state_22017__$1;
(statearr_22056_22111[(1)] = (36));

} else {
var statearr_22057_22112 = state_22017__$1;
(statearr_22057_22112[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (19))){
var inst_21947 = (state_22017[(7)]);
var inst_21966 = cljs.core.apply.call(null,cljs.core.hash_map,inst_21947);
var state_22017__$1 = state_22017;
var statearr_22058_22113 = state_22017__$1;
(statearr_22058_22113[(2)] = inst_21966);

(statearr_22058_22113[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (11))){
var inst_21947 = (state_22017[(7)]);
var inst_21951 = (inst_21947 == null);
var inst_21952 = cljs.core.not.call(null,inst_21951);
var state_22017__$1 = state_22017;
if(inst_21952){
var statearr_22059_22114 = state_22017__$1;
(statearr_22059_22114[(1)] = (13));

} else {
var statearr_22060_22115 = state_22017__$1;
(statearr_22060_22115[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (9))){
var inst_21923 = (state_22017[(8)]);
var state_22017__$1 = state_22017;
var statearr_22061_22116 = state_22017__$1;
(statearr_22061_22116[(2)] = inst_21923);

(statearr_22061_22116[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (5))){
var state_22017__$1 = state_22017;
var statearr_22062_22117 = state_22017__$1;
(statearr_22062_22117[(2)] = true);

(statearr_22062_22117[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (14))){
var state_22017__$1 = state_22017;
var statearr_22063_22118 = state_22017__$1;
(statearr_22063_22118[(2)] = false);

(statearr_22063_22118[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (26))){
var inst_21977 = (state_22017[(11)]);
var inst_21984 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_21977);
var state_22017__$1 = state_22017;
var statearr_22064_22119 = state_22017__$1;
(statearr_22064_22119[(2)] = inst_21984);

(statearr_22064_22119[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (16))){
var state_22017__$1 = state_22017;
var statearr_22065_22120 = state_22017__$1;
(statearr_22065_22120[(2)] = true);

(statearr_22065_22120[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (38))){
var inst_22007 = (state_22017[(2)]);
var state_22017__$1 = state_22017;
var statearr_22066_22121 = state_22017__$1;
(statearr_22066_22121[(2)] = inst_22007);

(statearr_22066_22121[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (30))){
var inst_21971 = (state_22017[(13)]);
var inst_21970 = (state_22017[(10)]);
var inst_21977 = (state_22017[(11)]);
var inst_21994 = cljs.core.empty_QMARK_.call(null,inst_21970);
var inst_21995 = inst_21971.call(null,inst_21977);
var inst_21996 = cljs.core.not.call(null,inst_21995);
var inst_21997 = (inst_21994) && (inst_21996);
var state_22017__$1 = state_22017;
var statearr_22067_22122 = state_22017__$1;
(statearr_22067_22122[(2)] = inst_21997);

(statearr_22067_22122[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (10))){
var inst_21923 = (state_22017[(8)]);
var inst_21943 = (state_22017[(2)]);
var inst_21944 = cljs.core.get.call(null,inst_21943,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_21945 = cljs.core.get.call(null,inst_21943,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_21946 = cljs.core.get.call(null,inst_21943,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_21947 = inst_21923;
var state_22017__$1 = (function (){var statearr_22068 = state_22017;
(statearr_22068[(16)] = inst_21945);

(statearr_22068[(17)] = inst_21946);

(statearr_22068[(18)] = inst_21944);

(statearr_22068[(7)] = inst_21947);

return statearr_22068;
})();
var statearr_22069_22123 = state_22017__$1;
(statearr_22069_22123[(2)] = null);

(statearr_22069_22123[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (18))){
var inst_21961 = (state_22017[(2)]);
var state_22017__$1 = state_22017;
var statearr_22070_22124 = state_22017__$1;
(statearr_22070_22124[(2)] = inst_21961);

(statearr_22070_22124[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (37))){
var state_22017__$1 = state_22017;
var statearr_22071_22125 = state_22017__$1;
(statearr_22071_22125[(2)] = null);

(statearr_22071_22125[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22018 === (8))){
var inst_21923 = (state_22017[(8)]);
var inst_21940 = cljs.core.apply.call(null,cljs.core.hash_map,inst_21923);
var state_22017__$1 = state_22017;
var statearr_22072_22126 = state_22017__$1;
(statearr_22072_22126[(2)] = inst_21940);

(statearr_22072_22126[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto___22080,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__20255__auto__,c__20367__auto___22080,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__20256__auto__ = null;
var cljs$core$async$mix_$_state_machine__20256__auto____0 = (function (){
var statearr_22076 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22076[(0)] = cljs$core$async$mix_$_state_machine__20256__auto__);

(statearr_22076[(1)] = (1));

return statearr_22076;
});
var cljs$core$async$mix_$_state_machine__20256__auto____1 = (function (state_22017){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_22017);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e22077){if((e22077 instanceof Object)){
var ex__20259__auto__ = e22077;
var statearr_22078_22127 = state_22017;
(statearr_22078_22127[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22017);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22077;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22128 = state_22017;
state_22017 = G__22128;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__20256__auto__ = function(state_22017){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__20256__auto____1.call(this,state_22017);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__20256__auto____0;
cljs$core$async$mix_$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__20256__auto____1;
return cljs$core$async$mix_$_state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto___22080,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__20369__auto__ = (function (){var statearr_22079 = f__20368__auto__.call(null);
(statearr_22079[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto___22080);

return statearr_22079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto___22080,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__18857__auto__ = (((p == null))?null:p);
var m__18858__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__18858__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__18857__auto__ = (((p == null))?null:p);
var m__18858__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,p,v,ch);
} else {
var m__18858__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args22129 = [];
var len__19260__auto___22132 = arguments.length;
var i__19261__auto___22133 = (0);
while(true){
if((i__19261__auto___22133 < len__19260__auto___22132)){
args22129.push((arguments[i__19261__auto___22133]));

var G__22134 = (i__19261__auto___22133 + (1));
i__19261__auto___22133 = G__22134;
continue;
} else {
}
break;
}

var G__22131 = args22129.length;
switch (G__22131) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22129.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__18857__auto__ = (((p == null))?null:p);
var m__18858__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,p);
} else {
var m__18858__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__18857__auto__ = (((p == null))?null:p);
var m__18858__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__18857__auto__)]);
if(!((m__18858__auto__ == null))){
return m__18858__auto__.call(null,p,v);
} else {
var m__18858__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__18858__auto____$1 == null))){
return m__18858__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args22137 = [];
var len__19260__auto___22262 = arguments.length;
var i__19261__auto___22263 = (0);
while(true){
if((i__19261__auto___22263 < len__19260__auto___22262)){
args22137.push((arguments[i__19261__auto___22263]));

var G__22264 = (i__19261__auto___22263 + (1));
i__19261__auto___22263 = G__22264;
continue;
} else {
}
break;
}

var G__22139 = args22137.length;
switch (G__22139) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22137.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__18202__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__18202__auto__)){
return or__18202__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__18202__auto__,mults){
return (function (p1__22136_SHARP_){
if(cljs.core.truth_(p1__22136_SHARP_.call(null,topic))){
return p1__22136_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__22136_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__18202__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async22140 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22140 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta22141){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta22141 = meta22141;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22140.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_22142,meta22141__$1){
var self__ = this;
var _22142__$1 = this;
return (new cljs.core.async.t_cljs$core$async22140(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta22141__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22140.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_22142){
var self__ = this;
var _22142__$1 = this;
return self__.meta22141;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22140.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async22140.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22140.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async22140.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22140.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22140.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22140.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22140.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta22141","meta22141",843215160,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async22140.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22140.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22140";

cljs.core.async.t_cljs$core$async22140.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async22140");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async22140 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async22140(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta22141){
return (new cljs.core.async.t_cljs$core$async22140(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta22141));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async22140(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20367__auto___22266 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto___22266,mults,ensure_mult,p){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto___22266,mults,ensure_mult,p){
return (function (state_22214){
var state_val_22215 = (state_22214[(1)]);
if((state_val_22215 === (7))){
var inst_22210 = (state_22214[(2)]);
var state_22214__$1 = state_22214;
var statearr_22216_22267 = state_22214__$1;
(statearr_22216_22267[(2)] = inst_22210);

(statearr_22216_22267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (20))){
var state_22214__$1 = state_22214;
var statearr_22217_22268 = state_22214__$1;
(statearr_22217_22268[(2)] = null);

(statearr_22217_22268[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (1))){
var state_22214__$1 = state_22214;
var statearr_22218_22269 = state_22214__$1;
(statearr_22218_22269[(2)] = null);

(statearr_22218_22269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (24))){
var inst_22193 = (state_22214[(7)]);
var inst_22202 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_22193);
var state_22214__$1 = state_22214;
var statearr_22219_22270 = state_22214__$1;
(statearr_22219_22270[(2)] = inst_22202);

(statearr_22219_22270[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (4))){
var inst_22145 = (state_22214[(8)]);
var inst_22145__$1 = (state_22214[(2)]);
var inst_22146 = (inst_22145__$1 == null);
var state_22214__$1 = (function (){var statearr_22220 = state_22214;
(statearr_22220[(8)] = inst_22145__$1);

return statearr_22220;
})();
if(cljs.core.truth_(inst_22146)){
var statearr_22221_22271 = state_22214__$1;
(statearr_22221_22271[(1)] = (5));

} else {
var statearr_22222_22272 = state_22214__$1;
(statearr_22222_22272[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (15))){
var inst_22187 = (state_22214[(2)]);
var state_22214__$1 = state_22214;
var statearr_22223_22273 = state_22214__$1;
(statearr_22223_22273[(2)] = inst_22187);

(statearr_22223_22273[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (21))){
var inst_22207 = (state_22214[(2)]);
var state_22214__$1 = (function (){var statearr_22224 = state_22214;
(statearr_22224[(9)] = inst_22207);

return statearr_22224;
})();
var statearr_22225_22274 = state_22214__$1;
(statearr_22225_22274[(2)] = null);

(statearr_22225_22274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (13))){
var inst_22169 = (state_22214[(10)]);
var inst_22171 = cljs.core.chunked_seq_QMARK_.call(null,inst_22169);
var state_22214__$1 = state_22214;
if(inst_22171){
var statearr_22226_22275 = state_22214__$1;
(statearr_22226_22275[(1)] = (16));

} else {
var statearr_22227_22276 = state_22214__$1;
(statearr_22227_22276[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (22))){
var inst_22199 = (state_22214[(2)]);
var state_22214__$1 = state_22214;
if(cljs.core.truth_(inst_22199)){
var statearr_22228_22277 = state_22214__$1;
(statearr_22228_22277[(1)] = (23));

} else {
var statearr_22229_22278 = state_22214__$1;
(statearr_22229_22278[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (6))){
var inst_22193 = (state_22214[(7)]);
var inst_22195 = (state_22214[(11)]);
var inst_22145 = (state_22214[(8)]);
var inst_22193__$1 = topic_fn.call(null,inst_22145);
var inst_22194 = cljs.core.deref.call(null,mults);
var inst_22195__$1 = cljs.core.get.call(null,inst_22194,inst_22193__$1);
var state_22214__$1 = (function (){var statearr_22230 = state_22214;
(statearr_22230[(7)] = inst_22193__$1);

(statearr_22230[(11)] = inst_22195__$1);

return statearr_22230;
})();
if(cljs.core.truth_(inst_22195__$1)){
var statearr_22231_22279 = state_22214__$1;
(statearr_22231_22279[(1)] = (19));

} else {
var statearr_22232_22280 = state_22214__$1;
(statearr_22232_22280[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (25))){
var inst_22204 = (state_22214[(2)]);
var state_22214__$1 = state_22214;
var statearr_22233_22281 = state_22214__$1;
(statearr_22233_22281[(2)] = inst_22204);

(statearr_22233_22281[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (17))){
var inst_22169 = (state_22214[(10)]);
var inst_22178 = cljs.core.first.call(null,inst_22169);
var inst_22179 = cljs.core.async.muxch_STAR_.call(null,inst_22178);
var inst_22180 = cljs.core.async.close_BANG_.call(null,inst_22179);
var inst_22181 = cljs.core.next.call(null,inst_22169);
var inst_22155 = inst_22181;
var inst_22156 = null;
var inst_22157 = (0);
var inst_22158 = (0);
var state_22214__$1 = (function (){var statearr_22234 = state_22214;
(statearr_22234[(12)] = inst_22156);

(statearr_22234[(13)] = inst_22180);

(statearr_22234[(14)] = inst_22158);

(statearr_22234[(15)] = inst_22155);

(statearr_22234[(16)] = inst_22157);

return statearr_22234;
})();
var statearr_22235_22282 = state_22214__$1;
(statearr_22235_22282[(2)] = null);

(statearr_22235_22282[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (3))){
var inst_22212 = (state_22214[(2)]);
var state_22214__$1 = state_22214;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22214__$1,inst_22212);
} else {
if((state_val_22215 === (12))){
var inst_22189 = (state_22214[(2)]);
var state_22214__$1 = state_22214;
var statearr_22236_22283 = state_22214__$1;
(statearr_22236_22283[(2)] = inst_22189);

(statearr_22236_22283[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (2))){
var state_22214__$1 = state_22214;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22214__$1,(4),ch);
} else {
if((state_val_22215 === (23))){
var state_22214__$1 = state_22214;
var statearr_22237_22284 = state_22214__$1;
(statearr_22237_22284[(2)] = null);

(statearr_22237_22284[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (19))){
var inst_22195 = (state_22214[(11)]);
var inst_22145 = (state_22214[(8)]);
var inst_22197 = cljs.core.async.muxch_STAR_.call(null,inst_22195);
var state_22214__$1 = state_22214;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22214__$1,(22),inst_22197,inst_22145);
} else {
if((state_val_22215 === (11))){
var inst_22155 = (state_22214[(15)]);
var inst_22169 = (state_22214[(10)]);
var inst_22169__$1 = cljs.core.seq.call(null,inst_22155);
var state_22214__$1 = (function (){var statearr_22238 = state_22214;
(statearr_22238[(10)] = inst_22169__$1);

return statearr_22238;
})();
if(inst_22169__$1){
var statearr_22239_22285 = state_22214__$1;
(statearr_22239_22285[(1)] = (13));

} else {
var statearr_22240_22286 = state_22214__$1;
(statearr_22240_22286[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (9))){
var inst_22191 = (state_22214[(2)]);
var state_22214__$1 = state_22214;
var statearr_22241_22287 = state_22214__$1;
(statearr_22241_22287[(2)] = inst_22191);

(statearr_22241_22287[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (5))){
var inst_22152 = cljs.core.deref.call(null,mults);
var inst_22153 = cljs.core.vals.call(null,inst_22152);
var inst_22154 = cljs.core.seq.call(null,inst_22153);
var inst_22155 = inst_22154;
var inst_22156 = null;
var inst_22157 = (0);
var inst_22158 = (0);
var state_22214__$1 = (function (){var statearr_22242 = state_22214;
(statearr_22242[(12)] = inst_22156);

(statearr_22242[(14)] = inst_22158);

(statearr_22242[(15)] = inst_22155);

(statearr_22242[(16)] = inst_22157);

return statearr_22242;
})();
var statearr_22243_22288 = state_22214__$1;
(statearr_22243_22288[(2)] = null);

(statearr_22243_22288[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (14))){
var state_22214__$1 = state_22214;
var statearr_22247_22289 = state_22214__$1;
(statearr_22247_22289[(2)] = null);

(statearr_22247_22289[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (16))){
var inst_22169 = (state_22214[(10)]);
var inst_22173 = cljs.core.chunk_first.call(null,inst_22169);
var inst_22174 = cljs.core.chunk_rest.call(null,inst_22169);
var inst_22175 = cljs.core.count.call(null,inst_22173);
var inst_22155 = inst_22174;
var inst_22156 = inst_22173;
var inst_22157 = inst_22175;
var inst_22158 = (0);
var state_22214__$1 = (function (){var statearr_22248 = state_22214;
(statearr_22248[(12)] = inst_22156);

(statearr_22248[(14)] = inst_22158);

(statearr_22248[(15)] = inst_22155);

(statearr_22248[(16)] = inst_22157);

return statearr_22248;
})();
var statearr_22249_22290 = state_22214__$1;
(statearr_22249_22290[(2)] = null);

(statearr_22249_22290[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (10))){
var inst_22156 = (state_22214[(12)]);
var inst_22158 = (state_22214[(14)]);
var inst_22155 = (state_22214[(15)]);
var inst_22157 = (state_22214[(16)]);
var inst_22163 = cljs.core._nth.call(null,inst_22156,inst_22158);
var inst_22164 = cljs.core.async.muxch_STAR_.call(null,inst_22163);
var inst_22165 = cljs.core.async.close_BANG_.call(null,inst_22164);
var inst_22166 = (inst_22158 + (1));
var tmp22244 = inst_22156;
var tmp22245 = inst_22155;
var tmp22246 = inst_22157;
var inst_22155__$1 = tmp22245;
var inst_22156__$1 = tmp22244;
var inst_22157__$1 = tmp22246;
var inst_22158__$1 = inst_22166;
var state_22214__$1 = (function (){var statearr_22250 = state_22214;
(statearr_22250[(12)] = inst_22156__$1);

(statearr_22250[(14)] = inst_22158__$1);

(statearr_22250[(15)] = inst_22155__$1);

(statearr_22250[(16)] = inst_22157__$1);

(statearr_22250[(17)] = inst_22165);

return statearr_22250;
})();
var statearr_22251_22291 = state_22214__$1;
(statearr_22251_22291[(2)] = null);

(statearr_22251_22291[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (18))){
var inst_22184 = (state_22214[(2)]);
var state_22214__$1 = state_22214;
var statearr_22252_22292 = state_22214__$1;
(statearr_22252_22292[(2)] = inst_22184);

(statearr_22252_22292[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22215 === (8))){
var inst_22158 = (state_22214[(14)]);
var inst_22157 = (state_22214[(16)]);
var inst_22160 = (inst_22158 < inst_22157);
var inst_22161 = inst_22160;
var state_22214__$1 = state_22214;
if(cljs.core.truth_(inst_22161)){
var statearr_22253_22293 = state_22214__$1;
(statearr_22253_22293[(1)] = (10));

} else {
var statearr_22254_22294 = state_22214__$1;
(statearr_22254_22294[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto___22266,mults,ensure_mult,p))
;
return ((function (switch__20255__auto__,c__20367__auto___22266,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__20256__auto__ = null;
var cljs$core$async$state_machine__20256__auto____0 = (function (){
var statearr_22258 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22258[(0)] = cljs$core$async$state_machine__20256__auto__);

(statearr_22258[(1)] = (1));

return statearr_22258;
});
var cljs$core$async$state_machine__20256__auto____1 = (function (state_22214){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_22214);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e22259){if((e22259 instanceof Object)){
var ex__20259__auto__ = e22259;
var statearr_22260_22295 = state_22214;
(statearr_22260_22295[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22214);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22259;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22296 = state_22214;
state_22214 = G__22296;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$state_machine__20256__auto__ = function(state_22214){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20256__auto____1.call(this,state_22214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20256__auto____0;
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20256__auto____1;
return cljs$core$async$state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto___22266,mults,ensure_mult,p))
})();
var state__20369__auto__ = (function (){var statearr_22261 = f__20368__auto__.call(null);
(statearr_22261[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto___22266);

return statearr_22261;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto___22266,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args22297 = [];
var len__19260__auto___22300 = arguments.length;
var i__19261__auto___22301 = (0);
while(true){
if((i__19261__auto___22301 < len__19260__auto___22300)){
args22297.push((arguments[i__19261__auto___22301]));

var G__22302 = (i__19261__auto___22301 + (1));
i__19261__auto___22301 = G__22302;
continue;
} else {
}
break;
}

var G__22299 = args22297.length;
switch (G__22299) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22297.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args22304 = [];
var len__19260__auto___22307 = arguments.length;
var i__19261__auto___22308 = (0);
while(true){
if((i__19261__auto___22308 < len__19260__auto___22307)){
args22304.push((arguments[i__19261__auto___22308]));

var G__22309 = (i__19261__auto___22308 + (1));
i__19261__auto___22308 = G__22309;
continue;
} else {
}
break;
}

var G__22306 = args22304.length;
switch (G__22306) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22304.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args22311 = [];
var len__19260__auto___22382 = arguments.length;
var i__19261__auto___22383 = (0);
while(true){
if((i__19261__auto___22383 < len__19260__auto___22382)){
args22311.push((arguments[i__19261__auto___22383]));

var G__22384 = (i__19261__auto___22383 + (1));
i__19261__auto___22383 = G__22384;
continue;
} else {
}
break;
}

var G__22313 = args22311.length;
switch (G__22313) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22311.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__20367__auto___22386 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto___22386,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto___22386,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_22352){
var state_val_22353 = (state_22352[(1)]);
if((state_val_22353 === (7))){
var state_22352__$1 = state_22352;
var statearr_22354_22387 = state_22352__$1;
(statearr_22354_22387[(2)] = null);

(statearr_22354_22387[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (1))){
var state_22352__$1 = state_22352;
var statearr_22355_22388 = state_22352__$1;
(statearr_22355_22388[(2)] = null);

(statearr_22355_22388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (4))){
var inst_22316 = (state_22352[(7)]);
var inst_22318 = (inst_22316 < cnt);
var state_22352__$1 = state_22352;
if(cljs.core.truth_(inst_22318)){
var statearr_22356_22389 = state_22352__$1;
(statearr_22356_22389[(1)] = (6));

} else {
var statearr_22357_22390 = state_22352__$1;
(statearr_22357_22390[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (15))){
var inst_22348 = (state_22352[(2)]);
var state_22352__$1 = state_22352;
var statearr_22358_22391 = state_22352__$1;
(statearr_22358_22391[(2)] = inst_22348);

(statearr_22358_22391[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (13))){
var inst_22341 = cljs.core.async.close_BANG_.call(null,out);
var state_22352__$1 = state_22352;
var statearr_22359_22392 = state_22352__$1;
(statearr_22359_22392[(2)] = inst_22341);

(statearr_22359_22392[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (6))){
var state_22352__$1 = state_22352;
var statearr_22360_22393 = state_22352__$1;
(statearr_22360_22393[(2)] = null);

(statearr_22360_22393[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (3))){
var inst_22350 = (state_22352[(2)]);
var state_22352__$1 = state_22352;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22352__$1,inst_22350);
} else {
if((state_val_22353 === (12))){
var inst_22338 = (state_22352[(8)]);
var inst_22338__$1 = (state_22352[(2)]);
var inst_22339 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_22338__$1);
var state_22352__$1 = (function (){var statearr_22361 = state_22352;
(statearr_22361[(8)] = inst_22338__$1);

return statearr_22361;
})();
if(cljs.core.truth_(inst_22339)){
var statearr_22362_22394 = state_22352__$1;
(statearr_22362_22394[(1)] = (13));

} else {
var statearr_22363_22395 = state_22352__$1;
(statearr_22363_22395[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (2))){
var inst_22315 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_22316 = (0);
var state_22352__$1 = (function (){var statearr_22364 = state_22352;
(statearr_22364[(7)] = inst_22316);

(statearr_22364[(9)] = inst_22315);

return statearr_22364;
})();
var statearr_22365_22396 = state_22352__$1;
(statearr_22365_22396[(2)] = null);

(statearr_22365_22396[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (11))){
var inst_22316 = (state_22352[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_22352,(10),Object,null,(9));
var inst_22325 = chs__$1.call(null,inst_22316);
var inst_22326 = done.call(null,inst_22316);
var inst_22327 = cljs.core.async.take_BANG_.call(null,inst_22325,inst_22326);
var state_22352__$1 = state_22352;
var statearr_22366_22397 = state_22352__$1;
(statearr_22366_22397[(2)] = inst_22327);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22352__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (9))){
var inst_22316 = (state_22352[(7)]);
var inst_22329 = (state_22352[(2)]);
var inst_22330 = (inst_22316 + (1));
var inst_22316__$1 = inst_22330;
var state_22352__$1 = (function (){var statearr_22367 = state_22352;
(statearr_22367[(7)] = inst_22316__$1);

(statearr_22367[(10)] = inst_22329);

return statearr_22367;
})();
var statearr_22368_22398 = state_22352__$1;
(statearr_22368_22398[(2)] = null);

(statearr_22368_22398[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (5))){
var inst_22336 = (state_22352[(2)]);
var state_22352__$1 = (function (){var statearr_22369 = state_22352;
(statearr_22369[(11)] = inst_22336);

return statearr_22369;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22352__$1,(12),dchan);
} else {
if((state_val_22353 === (14))){
var inst_22338 = (state_22352[(8)]);
var inst_22343 = cljs.core.apply.call(null,f,inst_22338);
var state_22352__$1 = state_22352;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22352__$1,(16),out,inst_22343);
} else {
if((state_val_22353 === (16))){
var inst_22345 = (state_22352[(2)]);
var state_22352__$1 = (function (){var statearr_22370 = state_22352;
(statearr_22370[(12)] = inst_22345);

return statearr_22370;
})();
var statearr_22371_22399 = state_22352__$1;
(statearr_22371_22399[(2)] = null);

(statearr_22371_22399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (10))){
var inst_22320 = (state_22352[(2)]);
var inst_22321 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_22352__$1 = (function (){var statearr_22372 = state_22352;
(statearr_22372[(13)] = inst_22320);

return statearr_22372;
})();
var statearr_22373_22400 = state_22352__$1;
(statearr_22373_22400[(2)] = inst_22321);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22352__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22353 === (8))){
var inst_22334 = (state_22352[(2)]);
var state_22352__$1 = state_22352;
var statearr_22374_22401 = state_22352__$1;
(statearr_22374_22401[(2)] = inst_22334);

(statearr_22374_22401[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto___22386,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__20255__auto__,c__20367__auto___22386,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__20256__auto__ = null;
var cljs$core$async$state_machine__20256__auto____0 = (function (){
var statearr_22378 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22378[(0)] = cljs$core$async$state_machine__20256__auto__);

(statearr_22378[(1)] = (1));

return statearr_22378;
});
var cljs$core$async$state_machine__20256__auto____1 = (function (state_22352){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_22352);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e22379){if((e22379 instanceof Object)){
var ex__20259__auto__ = e22379;
var statearr_22380_22402 = state_22352;
(statearr_22380_22402[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22352);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22379;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22403 = state_22352;
state_22352 = G__22403;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$state_machine__20256__auto__ = function(state_22352){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20256__auto____1.call(this,state_22352);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20256__auto____0;
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20256__auto____1;
return cljs$core$async$state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto___22386,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__20369__auto__ = (function (){var statearr_22381 = f__20368__auto__.call(null);
(statearr_22381[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto___22386);

return statearr_22381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto___22386,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args22405 = [];
var len__19260__auto___22461 = arguments.length;
var i__19261__auto___22462 = (0);
while(true){
if((i__19261__auto___22462 < len__19260__auto___22461)){
args22405.push((arguments[i__19261__auto___22462]));

var G__22463 = (i__19261__auto___22462 + (1));
i__19261__auto___22462 = G__22463;
continue;
} else {
}
break;
}

var G__22407 = args22405.length;
switch (G__22407) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22405.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20367__auto___22465 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto___22465,out){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto___22465,out){
return (function (state_22437){
var state_val_22438 = (state_22437[(1)]);
if((state_val_22438 === (7))){
var inst_22416 = (state_22437[(7)]);
var inst_22417 = (state_22437[(8)]);
var inst_22416__$1 = (state_22437[(2)]);
var inst_22417__$1 = cljs.core.nth.call(null,inst_22416__$1,(0),null);
var inst_22418 = cljs.core.nth.call(null,inst_22416__$1,(1),null);
var inst_22419 = (inst_22417__$1 == null);
var state_22437__$1 = (function (){var statearr_22439 = state_22437;
(statearr_22439[(7)] = inst_22416__$1);

(statearr_22439[(8)] = inst_22417__$1);

(statearr_22439[(9)] = inst_22418);

return statearr_22439;
})();
if(cljs.core.truth_(inst_22419)){
var statearr_22440_22466 = state_22437__$1;
(statearr_22440_22466[(1)] = (8));

} else {
var statearr_22441_22467 = state_22437__$1;
(statearr_22441_22467[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22438 === (1))){
var inst_22408 = cljs.core.vec.call(null,chs);
var inst_22409 = inst_22408;
var state_22437__$1 = (function (){var statearr_22442 = state_22437;
(statearr_22442[(10)] = inst_22409);

return statearr_22442;
})();
var statearr_22443_22468 = state_22437__$1;
(statearr_22443_22468[(2)] = null);

(statearr_22443_22468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22438 === (4))){
var inst_22409 = (state_22437[(10)]);
var state_22437__$1 = state_22437;
return cljs.core.async.ioc_alts_BANG_.call(null,state_22437__$1,(7),inst_22409);
} else {
if((state_val_22438 === (6))){
var inst_22433 = (state_22437[(2)]);
var state_22437__$1 = state_22437;
var statearr_22444_22469 = state_22437__$1;
(statearr_22444_22469[(2)] = inst_22433);

(statearr_22444_22469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22438 === (3))){
var inst_22435 = (state_22437[(2)]);
var state_22437__$1 = state_22437;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22437__$1,inst_22435);
} else {
if((state_val_22438 === (2))){
var inst_22409 = (state_22437[(10)]);
var inst_22411 = cljs.core.count.call(null,inst_22409);
var inst_22412 = (inst_22411 > (0));
var state_22437__$1 = state_22437;
if(cljs.core.truth_(inst_22412)){
var statearr_22446_22470 = state_22437__$1;
(statearr_22446_22470[(1)] = (4));

} else {
var statearr_22447_22471 = state_22437__$1;
(statearr_22447_22471[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22438 === (11))){
var inst_22409 = (state_22437[(10)]);
var inst_22426 = (state_22437[(2)]);
var tmp22445 = inst_22409;
var inst_22409__$1 = tmp22445;
var state_22437__$1 = (function (){var statearr_22448 = state_22437;
(statearr_22448[(10)] = inst_22409__$1);

(statearr_22448[(11)] = inst_22426);

return statearr_22448;
})();
var statearr_22449_22472 = state_22437__$1;
(statearr_22449_22472[(2)] = null);

(statearr_22449_22472[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22438 === (9))){
var inst_22417 = (state_22437[(8)]);
var state_22437__$1 = state_22437;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22437__$1,(11),out,inst_22417);
} else {
if((state_val_22438 === (5))){
var inst_22431 = cljs.core.async.close_BANG_.call(null,out);
var state_22437__$1 = state_22437;
var statearr_22450_22473 = state_22437__$1;
(statearr_22450_22473[(2)] = inst_22431);

(statearr_22450_22473[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22438 === (10))){
var inst_22429 = (state_22437[(2)]);
var state_22437__$1 = state_22437;
var statearr_22451_22474 = state_22437__$1;
(statearr_22451_22474[(2)] = inst_22429);

(statearr_22451_22474[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22438 === (8))){
var inst_22416 = (state_22437[(7)]);
var inst_22417 = (state_22437[(8)]);
var inst_22409 = (state_22437[(10)]);
var inst_22418 = (state_22437[(9)]);
var inst_22421 = (function (){var cs = inst_22409;
var vec__22414 = inst_22416;
var v = inst_22417;
var c = inst_22418;
return ((function (cs,vec__22414,v,c,inst_22416,inst_22417,inst_22409,inst_22418,state_val_22438,c__20367__auto___22465,out){
return (function (p1__22404_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__22404_SHARP_);
});
;})(cs,vec__22414,v,c,inst_22416,inst_22417,inst_22409,inst_22418,state_val_22438,c__20367__auto___22465,out))
})();
var inst_22422 = cljs.core.filterv.call(null,inst_22421,inst_22409);
var inst_22409__$1 = inst_22422;
var state_22437__$1 = (function (){var statearr_22452 = state_22437;
(statearr_22452[(10)] = inst_22409__$1);

return statearr_22452;
})();
var statearr_22453_22475 = state_22437__$1;
(statearr_22453_22475[(2)] = null);

(statearr_22453_22475[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto___22465,out))
;
return ((function (switch__20255__auto__,c__20367__auto___22465,out){
return (function() {
var cljs$core$async$state_machine__20256__auto__ = null;
var cljs$core$async$state_machine__20256__auto____0 = (function (){
var statearr_22457 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22457[(0)] = cljs$core$async$state_machine__20256__auto__);

(statearr_22457[(1)] = (1));

return statearr_22457;
});
var cljs$core$async$state_machine__20256__auto____1 = (function (state_22437){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_22437);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e22458){if((e22458 instanceof Object)){
var ex__20259__auto__ = e22458;
var statearr_22459_22476 = state_22437;
(statearr_22459_22476[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22437);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22458;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22477 = state_22437;
state_22437 = G__22477;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$state_machine__20256__auto__ = function(state_22437){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20256__auto____1.call(this,state_22437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20256__auto____0;
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20256__auto____1;
return cljs$core$async$state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto___22465,out))
})();
var state__20369__auto__ = (function (){var statearr_22460 = f__20368__auto__.call(null);
(statearr_22460[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto___22465);

return statearr_22460;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto___22465,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args22478 = [];
var len__19260__auto___22527 = arguments.length;
var i__19261__auto___22528 = (0);
while(true){
if((i__19261__auto___22528 < len__19260__auto___22527)){
args22478.push((arguments[i__19261__auto___22528]));

var G__22529 = (i__19261__auto___22528 + (1));
i__19261__auto___22528 = G__22529;
continue;
} else {
}
break;
}

var G__22480 = args22478.length;
switch (G__22480) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22478.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20367__auto___22531 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto___22531,out){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto___22531,out){
return (function (state_22504){
var state_val_22505 = (state_22504[(1)]);
if((state_val_22505 === (7))){
var inst_22486 = (state_22504[(7)]);
var inst_22486__$1 = (state_22504[(2)]);
var inst_22487 = (inst_22486__$1 == null);
var inst_22488 = cljs.core.not.call(null,inst_22487);
var state_22504__$1 = (function (){var statearr_22506 = state_22504;
(statearr_22506[(7)] = inst_22486__$1);

return statearr_22506;
})();
if(inst_22488){
var statearr_22507_22532 = state_22504__$1;
(statearr_22507_22532[(1)] = (8));

} else {
var statearr_22508_22533 = state_22504__$1;
(statearr_22508_22533[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22505 === (1))){
var inst_22481 = (0);
var state_22504__$1 = (function (){var statearr_22509 = state_22504;
(statearr_22509[(8)] = inst_22481);

return statearr_22509;
})();
var statearr_22510_22534 = state_22504__$1;
(statearr_22510_22534[(2)] = null);

(statearr_22510_22534[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22505 === (4))){
var state_22504__$1 = state_22504;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22504__$1,(7),ch);
} else {
if((state_val_22505 === (6))){
var inst_22499 = (state_22504[(2)]);
var state_22504__$1 = state_22504;
var statearr_22511_22535 = state_22504__$1;
(statearr_22511_22535[(2)] = inst_22499);

(statearr_22511_22535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22505 === (3))){
var inst_22501 = (state_22504[(2)]);
var inst_22502 = cljs.core.async.close_BANG_.call(null,out);
var state_22504__$1 = (function (){var statearr_22512 = state_22504;
(statearr_22512[(9)] = inst_22501);

return statearr_22512;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22504__$1,inst_22502);
} else {
if((state_val_22505 === (2))){
var inst_22481 = (state_22504[(8)]);
var inst_22483 = (inst_22481 < n);
var state_22504__$1 = state_22504;
if(cljs.core.truth_(inst_22483)){
var statearr_22513_22536 = state_22504__$1;
(statearr_22513_22536[(1)] = (4));

} else {
var statearr_22514_22537 = state_22504__$1;
(statearr_22514_22537[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22505 === (11))){
var inst_22481 = (state_22504[(8)]);
var inst_22491 = (state_22504[(2)]);
var inst_22492 = (inst_22481 + (1));
var inst_22481__$1 = inst_22492;
var state_22504__$1 = (function (){var statearr_22515 = state_22504;
(statearr_22515[(8)] = inst_22481__$1);

(statearr_22515[(10)] = inst_22491);

return statearr_22515;
})();
var statearr_22516_22538 = state_22504__$1;
(statearr_22516_22538[(2)] = null);

(statearr_22516_22538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22505 === (9))){
var state_22504__$1 = state_22504;
var statearr_22517_22539 = state_22504__$1;
(statearr_22517_22539[(2)] = null);

(statearr_22517_22539[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22505 === (5))){
var state_22504__$1 = state_22504;
var statearr_22518_22540 = state_22504__$1;
(statearr_22518_22540[(2)] = null);

(statearr_22518_22540[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22505 === (10))){
var inst_22496 = (state_22504[(2)]);
var state_22504__$1 = state_22504;
var statearr_22519_22541 = state_22504__$1;
(statearr_22519_22541[(2)] = inst_22496);

(statearr_22519_22541[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22505 === (8))){
var inst_22486 = (state_22504[(7)]);
var state_22504__$1 = state_22504;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22504__$1,(11),out,inst_22486);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto___22531,out))
;
return ((function (switch__20255__auto__,c__20367__auto___22531,out){
return (function() {
var cljs$core$async$state_machine__20256__auto__ = null;
var cljs$core$async$state_machine__20256__auto____0 = (function (){
var statearr_22523 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22523[(0)] = cljs$core$async$state_machine__20256__auto__);

(statearr_22523[(1)] = (1));

return statearr_22523;
});
var cljs$core$async$state_machine__20256__auto____1 = (function (state_22504){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_22504);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e22524){if((e22524 instanceof Object)){
var ex__20259__auto__ = e22524;
var statearr_22525_22542 = state_22504;
(statearr_22525_22542[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22504);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22524;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22543 = state_22504;
state_22504 = G__22543;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$state_machine__20256__auto__ = function(state_22504){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20256__auto____1.call(this,state_22504);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20256__auto____0;
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20256__auto____1;
return cljs$core$async$state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto___22531,out))
})();
var state__20369__auto__ = (function (){var statearr_22526 = f__20368__auto__.call(null);
(statearr_22526[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto___22531);

return statearr_22526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto___22531,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async22551 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22551 = (function (map_LT_,f,ch,meta22552){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta22552 = meta22552;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22551.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22553,meta22552__$1){
var self__ = this;
var _22553__$1 = this;
return (new cljs.core.async.t_cljs$core$async22551(self__.map_LT_,self__.f,self__.ch,meta22552__$1));
});

cljs.core.async.t_cljs$core$async22551.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22553){
var self__ = this;
var _22553__$1 = this;
return self__.meta22552;
});

cljs.core.async.t_cljs$core$async22551.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22551.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22551.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22551.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22551.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async22554 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22554 = (function (map_LT_,f,ch,meta22552,_,fn1,meta22555){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta22552 = meta22552;
this._ = _;
this.fn1 = fn1;
this.meta22555 = meta22555;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22554.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_22556,meta22555__$1){
var self__ = this;
var _22556__$1 = this;
return (new cljs.core.async.t_cljs$core$async22554(self__.map_LT_,self__.f,self__.ch,self__.meta22552,self__._,self__.fn1,meta22555__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async22554.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_22556){
var self__ = this;
var _22556__$1 = this;
return self__.meta22555;
});})(___$1))
;

cljs.core.async.t_cljs$core$async22554.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async22554.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async22554.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async22554.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__22544_SHARP_){
return f1.call(null,(((p1__22544_SHARP_ == null))?null:self__.f.call(null,p1__22544_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async22554.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22552","meta22552",1265056205,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async22551","cljs.core.async/t_cljs$core$async22551",-1600095618,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta22555","meta22555",1126490996,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async22554.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22554.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22554";

cljs.core.async.t_cljs$core$async22554.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async22554");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async22554 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async22554(map_LT___$1,f__$1,ch__$1,meta22552__$1,___$2,fn1__$1,meta22555){
return (new cljs.core.async.t_cljs$core$async22554(map_LT___$1,f__$1,ch__$1,meta22552__$1,___$2,fn1__$1,meta22555));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async22554(self__.map_LT_,self__.f,self__.ch,self__.meta22552,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__18190__auto__ = ret;
if(cljs.core.truth_(and__18190__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__18190__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async22551.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22551.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async22551.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22552","meta22552",1265056205,null)], null);
});

cljs.core.async.t_cljs$core$async22551.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22551.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22551";

cljs.core.async.t_cljs$core$async22551.cljs$lang$ctorPrWriter = (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async22551");
});

cljs.core.async.__GT_t_cljs$core$async22551 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async22551(map_LT___$1,f__$1,ch__$1,meta22552){
return (new cljs.core.async.t_cljs$core$async22551(map_LT___$1,f__$1,ch__$1,meta22552));
});

}

return (new cljs.core.async.t_cljs$core$async22551(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async22560 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22560 = (function (map_GT_,f,ch,meta22561){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta22561 = meta22561;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22560.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22562,meta22561__$1){
var self__ = this;
var _22562__$1 = this;
return (new cljs.core.async.t_cljs$core$async22560(self__.map_GT_,self__.f,self__.ch,meta22561__$1));
});

cljs.core.async.t_cljs$core$async22560.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22562){
var self__ = this;
var _22562__$1 = this;
return self__.meta22561;
});

cljs.core.async.t_cljs$core$async22560.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22560.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22560.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22560.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async22560.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22560.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async22560.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22561","meta22561",-2010027231,null)], null);
});

cljs.core.async.t_cljs$core$async22560.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22560.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22560";

cljs.core.async.t_cljs$core$async22560.cljs$lang$ctorPrWriter = (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async22560");
});

cljs.core.async.__GT_t_cljs$core$async22560 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async22560(map_GT___$1,f__$1,ch__$1,meta22561){
return (new cljs.core.async.t_cljs$core$async22560(map_GT___$1,f__$1,ch__$1,meta22561));
});

}

return (new cljs.core.async.t_cljs$core$async22560(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async22566 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22566 = (function (filter_GT_,p,ch,meta22567){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta22567 = meta22567;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async22566.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22568,meta22567__$1){
var self__ = this;
var _22568__$1 = this;
return (new cljs.core.async.t_cljs$core$async22566(self__.filter_GT_,self__.p,self__.ch,meta22567__$1));
});

cljs.core.async.t_cljs$core$async22566.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22568){
var self__ = this;
var _22568__$1 = this;
return self__.meta22567;
});

cljs.core.async.t_cljs$core$async22566.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async22566.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22566.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async22566.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async22566.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async22566.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async22566.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async22566.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta22567","meta22567",-61352483,null)], null);
});

cljs.core.async.t_cljs$core$async22566.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22566.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22566";

cljs.core.async.t_cljs$core$async22566.cljs$lang$ctorPrWriter = (function (this__18800__auto__,writer__18801__auto__,opt__18802__auto__){
return cljs.core._write.call(null,writer__18801__auto__,"cljs.core.async/t_cljs$core$async22566");
});

cljs.core.async.__GT_t_cljs$core$async22566 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async22566(filter_GT___$1,p__$1,ch__$1,meta22567){
return (new cljs.core.async.t_cljs$core$async22566(filter_GT___$1,p__$1,ch__$1,meta22567));
});

}

return (new cljs.core.async.t_cljs$core$async22566(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args22569 = [];
var len__19260__auto___22613 = arguments.length;
var i__19261__auto___22614 = (0);
while(true){
if((i__19261__auto___22614 < len__19260__auto___22613)){
args22569.push((arguments[i__19261__auto___22614]));

var G__22615 = (i__19261__auto___22614 + (1));
i__19261__auto___22614 = G__22615;
continue;
} else {
}
break;
}

var G__22571 = args22569.length;
switch (G__22571) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22569.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20367__auto___22617 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto___22617,out){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto___22617,out){
return (function (state_22592){
var state_val_22593 = (state_22592[(1)]);
if((state_val_22593 === (7))){
var inst_22588 = (state_22592[(2)]);
var state_22592__$1 = state_22592;
var statearr_22594_22618 = state_22592__$1;
(statearr_22594_22618[(2)] = inst_22588);

(statearr_22594_22618[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22593 === (1))){
var state_22592__$1 = state_22592;
var statearr_22595_22619 = state_22592__$1;
(statearr_22595_22619[(2)] = null);

(statearr_22595_22619[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22593 === (4))){
var inst_22574 = (state_22592[(7)]);
var inst_22574__$1 = (state_22592[(2)]);
var inst_22575 = (inst_22574__$1 == null);
var state_22592__$1 = (function (){var statearr_22596 = state_22592;
(statearr_22596[(7)] = inst_22574__$1);

return statearr_22596;
})();
if(cljs.core.truth_(inst_22575)){
var statearr_22597_22620 = state_22592__$1;
(statearr_22597_22620[(1)] = (5));

} else {
var statearr_22598_22621 = state_22592__$1;
(statearr_22598_22621[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22593 === (6))){
var inst_22574 = (state_22592[(7)]);
var inst_22579 = p.call(null,inst_22574);
var state_22592__$1 = state_22592;
if(cljs.core.truth_(inst_22579)){
var statearr_22599_22622 = state_22592__$1;
(statearr_22599_22622[(1)] = (8));

} else {
var statearr_22600_22623 = state_22592__$1;
(statearr_22600_22623[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22593 === (3))){
var inst_22590 = (state_22592[(2)]);
var state_22592__$1 = state_22592;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22592__$1,inst_22590);
} else {
if((state_val_22593 === (2))){
var state_22592__$1 = state_22592;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22592__$1,(4),ch);
} else {
if((state_val_22593 === (11))){
var inst_22582 = (state_22592[(2)]);
var state_22592__$1 = state_22592;
var statearr_22601_22624 = state_22592__$1;
(statearr_22601_22624[(2)] = inst_22582);

(statearr_22601_22624[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22593 === (9))){
var state_22592__$1 = state_22592;
var statearr_22602_22625 = state_22592__$1;
(statearr_22602_22625[(2)] = null);

(statearr_22602_22625[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22593 === (5))){
var inst_22577 = cljs.core.async.close_BANG_.call(null,out);
var state_22592__$1 = state_22592;
var statearr_22603_22626 = state_22592__$1;
(statearr_22603_22626[(2)] = inst_22577);

(statearr_22603_22626[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22593 === (10))){
var inst_22585 = (state_22592[(2)]);
var state_22592__$1 = (function (){var statearr_22604 = state_22592;
(statearr_22604[(8)] = inst_22585);

return statearr_22604;
})();
var statearr_22605_22627 = state_22592__$1;
(statearr_22605_22627[(2)] = null);

(statearr_22605_22627[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22593 === (8))){
var inst_22574 = (state_22592[(7)]);
var state_22592__$1 = state_22592;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22592__$1,(11),out,inst_22574);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto___22617,out))
;
return ((function (switch__20255__auto__,c__20367__auto___22617,out){
return (function() {
var cljs$core$async$state_machine__20256__auto__ = null;
var cljs$core$async$state_machine__20256__auto____0 = (function (){
var statearr_22609 = [null,null,null,null,null,null,null,null,null];
(statearr_22609[(0)] = cljs$core$async$state_machine__20256__auto__);

(statearr_22609[(1)] = (1));

return statearr_22609;
});
var cljs$core$async$state_machine__20256__auto____1 = (function (state_22592){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_22592);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e22610){if((e22610 instanceof Object)){
var ex__20259__auto__ = e22610;
var statearr_22611_22628 = state_22592;
(statearr_22611_22628[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22592);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22610;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22629 = state_22592;
state_22592 = G__22629;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$state_machine__20256__auto__ = function(state_22592){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20256__auto____1.call(this,state_22592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20256__auto____0;
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20256__auto____1;
return cljs$core$async$state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto___22617,out))
})();
var state__20369__auto__ = (function (){var statearr_22612 = f__20368__auto__.call(null);
(statearr_22612[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto___22617);

return statearr_22612;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto___22617,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args22630 = [];
var len__19260__auto___22633 = arguments.length;
var i__19261__auto___22634 = (0);
while(true){
if((i__19261__auto___22634 < len__19260__auto___22633)){
args22630.push((arguments[i__19261__auto___22634]));

var G__22635 = (i__19261__auto___22634 + (1));
i__19261__auto___22634 = G__22635;
continue;
} else {
}
break;
}

var G__22632 = args22630.length;
switch (G__22632) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22630.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__20367__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto__){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto__){
return (function (state_22802){
var state_val_22803 = (state_22802[(1)]);
if((state_val_22803 === (7))){
var inst_22798 = (state_22802[(2)]);
var state_22802__$1 = state_22802;
var statearr_22804_22845 = state_22802__$1;
(statearr_22804_22845[(2)] = inst_22798);

(statearr_22804_22845[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22803 === (20))){
var inst_22768 = (state_22802[(7)]);
var inst_22779 = (state_22802[(2)]);
var inst_22780 = cljs.core.next.call(null,inst_22768);
var inst_22754 = inst_22780;
var inst_22755 = null;
var inst_22756 = (0);
var inst_22757 = (0);
var state_22802__$1 = (function (){var statearr_22805 = state_22802;
(statearr_22805[(8)] = inst_22754);

(statearr_22805[(9)] = inst_22779);

(statearr_22805[(10)] = inst_22756);

(statearr_22805[(11)] = inst_22755);

(statearr_22805[(12)] = inst_22757);

return statearr_22805;
})();
var statearr_22806_22846 = state_22802__$1;
(statearr_22806_22846[(2)] = null);

(statearr_22806_22846[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22803 === (1))){
var state_22802__$1 = state_22802;
var statearr_22807_22847 = state_22802__$1;
(statearr_22807_22847[(2)] = null);

(statearr_22807_22847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22803 === (4))){
var inst_22743 = (state_22802[(13)]);
var inst_22743__$1 = (state_22802[(2)]);
var inst_22744 = (inst_22743__$1 == null);
var state_22802__$1 = (function (){var statearr_22808 = state_22802;
(statearr_22808[(13)] = inst_22743__$1);

return statearr_22808;
})();
if(cljs.core.truth_(inst_22744)){
var statearr_22809_22848 = state_22802__$1;
(statearr_22809_22848[(1)] = (5));

} else {
var statearr_22810_22849 = state_22802__$1;
(statearr_22810_22849[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22803 === (15))){
var state_22802__$1 = state_22802;
var statearr_22814_22850 = state_22802__$1;
(statearr_22814_22850[(2)] = null);

(statearr_22814_22850[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22803 === (21))){
var state_22802__$1 = state_22802;
var statearr_22815_22851 = state_22802__$1;
(statearr_22815_22851[(2)] = null);

(statearr_22815_22851[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22803 === (13))){
var inst_22754 = (state_22802[(8)]);
var inst_22756 = (state_22802[(10)]);
var inst_22755 = (state_22802[(11)]);
var inst_22757 = (state_22802[(12)]);
var inst_22764 = (state_22802[(2)]);
var inst_22765 = (inst_22757 + (1));
var tmp22811 = inst_22754;
var tmp22812 = inst_22756;
var tmp22813 = inst_22755;
var inst_22754__$1 = tmp22811;
var inst_22755__$1 = tmp22813;
var inst_22756__$1 = tmp22812;
var inst_22757__$1 = inst_22765;
var state_22802__$1 = (function (){var statearr_22816 = state_22802;
(statearr_22816[(8)] = inst_22754__$1);

(statearr_22816[(14)] = inst_22764);

(statearr_22816[(10)] = inst_22756__$1);

(statearr_22816[(11)] = inst_22755__$1);

(statearr_22816[(12)] = inst_22757__$1);

return statearr_22816;
})();
var statearr_22817_22852 = state_22802__$1;
(statearr_22817_22852[(2)] = null);

(statearr_22817_22852[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22803 === (22))){
var state_22802__$1 = state_22802;
var statearr_22818_22853 = state_22802__$1;
(statearr_22818_22853[(2)] = null);

(statearr_22818_22853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22803 === (6))){
var inst_22743 = (state_22802[(13)]);
var inst_22752 = f.call(null,inst_22743);
var inst_22753 = cljs.core.seq.call(null,inst_22752);
var inst_22754 = inst_22753;
var inst_22755 = null;
var inst_22756 = (0);
var inst_22757 = (0);
var state_22802__$1 = (function (){var statearr_22819 = state_22802;
(statearr_22819[(8)] = inst_22754);

(statearr_22819[(10)] = inst_22756);

(statearr_22819[(11)] = inst_22755);

(statearr_22819[(12)] = inst_22757);

return statearr_22819;
})();
var statearr_22820_22854 = state_22802__$1;
(statearr_22820_22854[(2)] = null);

(statearr_22820_22854[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22803 === (17))){
var inst_22768 = (state_22802[(7)]);
var inst_22772 = cljs.core.chunk_first.call(null,inst_22768);
var inst_22773 = cljs.core.chunk_rest.call(null,inst_22768);
var inst_22774 = cljs.core.count.call(null,inst_22772);
var inst_22754 = inst_22773;
var inst_22755 = inst_22772;
var inst_22756 = inst_22774;
var inst_22757 = (0);
var state_22802__$1 = (function (){var statearr_22821 = state_22802;
(statearr_22821[(8)] = inst_22754);

(statearr_22821[(10)] = inst_22756);

(statearr_22821[(11)] = inst_22755);

(statearr_22821[(12)] = inst_22757);

return statearr_22821;
})();
var statearr_22822_22855 = state_22802__$1;
(statearr_22822_22855[(2)] = null);

(statearr_22822_22855[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22803 === (3))){
var inst_22800 = (state_22802[(2)]);
var state_22802__$1 = state_22802;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22802__$1,inst_22800);
} else {
if((state_val_22803 === (12))){
var inst_22788 = (state_22802[(2)]);
var state_22802__$1 = state_22802;
var statearr_22823_22856 = state_22802__$1;
(statearr_22823_22856[(2)] = inst_22788);

(statearr_22823_22856[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22803 === (2))){
var state_22802__$1 = state_22802;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22802__$1,(4),in$);
} else {
if((state_val_22803 === (23))){
var inst_22796 = (state_22802[(2)]);
var state_22802__$1 = state_22802;
var statearr_22824_22857 = state_22802__$1;
(statearr_22824_22857[(2)] = inst_22796);

(statearr_22824_22857[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22803 === (19))){
var inst_22783 = (state_22802[(2)]);
var state_22802__$1 = state_22802;
var statearr_22825_22858 = state_22802__$1;
(statearr_22825_22858[(2)] = inst_22783);

(statearr_22825_22858[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22803 === (11))){
var inst_22754 = (state_22802[(8)]);
var inst_22768 = (state_22802[(7)]);
var inst_22768__$1 = cljs.core.seq.call(null,inst_22754);
var state_22802__$1 = (function (){var statearr_22826 = state_22802;
(statearr_22826[(7)] = inst_22768__$1);

return statearr_22826;
})();
if(inst_22768__$1){
var statearr_22827_22859 = state_22802__$1;
(statearr_22827_22859[(1)] = (14));

} else {
var statearr_22828_22860 = state_22802__$1;
(statearr_22828_22860[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22803 === (9))){
var inst_22790 = (state_22802[(2)]);
var inst_22791 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_22802__$1 = (function (){var statearr_22829 = state_22802;
(statearr_22829[(15)] = inst_22790);

return statearr_22829;
})();
if(cljs.core.truth_(inst_22791)){
var statearr_22830_22861 = state_22802__$1;
(statearr_22830_22861[(1)] = (21));

} else {
var statearr_22831_22862 = state_22802__$1;
(statearr_22831_22862[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22803 === (5))){
var inst_22746 = cljs.core.async.close_BANG_.call(null,out);
var state_22802__$1 = state_22802;
var statearr_22832_22863 = state_22802__$1;
(statearr_22832_22863[(2)] = inst_22746);

(statearr_22832_22863[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22803 === (14))){
var inst_22768 = (state_22802[(7)]);
var inst_22770 = cljs.core.chunked_seq_QMARK_.call(null,inst_22768);
var state_22802__$1 = state_22802;
if(inst_22770){
var statearr_22833_22864 = state_22802__$1;
(statearr_22833_22864[(1)] = (17));

} else {
var statearr_22834_22865 = state_22802__$1;
(statearr_22834_22865[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22803 === (16))){
var inst_22786 = (state_22802[(2)]);
var state_22802__$1 = state_22802;
var statearr_22835_22866 = state_22802__$1;
(statearr_22835_22866[(2)] = inst_22786);

(statearr_22835_22866[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22803 === (10))){
var inst_22755 = (state_22802[(11)]);
var inst_22757 = (state_22802[(12)]);
var inst_22762 = cljs.core._nth.call(null,inst_22755,inst_22757);
var state_22802__$1 = state_22802;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22802__$1,(13),out,inst_22762);
} else {
if((state_val_22803 === (18))){
var inst_22768 = (state_22802[(7)]);
var inst_22777 = cljs.core.first.call(null,inst_22768);
var state_22802__$1 = state_22802;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22802__$1,(20),out,inst_22777);
} else {
if((state_val_22803 === (8))){
var inst_22756 = (state_22802[(10)]);
var inst_22757 = (state_22802[(12)]);
var inst_22759 = (inst_22757 < inst_22756);
var inst_22760 = inst_22759;
var state_22802__$1 = state_22802;
if(cljs.core.truth_(inst_22760)){
var statearr_22836_22867 = state_22802__$1;
(statearr_22836_22867[(1)] = (10));

} else {
var statearr_22837_22868 = state_22802__$1;
(statearr_22837_22868[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto__))
;
return ((function (switch__20255__auto__,c__20367__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__20256__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__20256__auto____0 = (function (){
var statearr_22841 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22841[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__20256__auto__);

(statearr_22841[(1)] = (1));

return statearr_22841;
});
var cljs$core$async$mapcat_STAR__$_state_machine__20256__auto____1 = (function (state_22802){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_22802);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e22842){if((e22842 instanceof Object)){
var ex__20259__auto__ = e22842;
var statearr_22843_22869 = state_22802;
(statearr_22843_22869[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22802);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22842;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22870 = state_22802;
state_22802 = G__22870;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__20256__auto__ = function(state_22802){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__20256__auto____1.call(this,state_22802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__20256__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__20256__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto__))
})();
var state__20369__auto__ = (function (){var statearr_22844 = f__20368__auto__.call(null);
(statearr_22844[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto__);

return statearr_22844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto__))
);

return c__20367__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args22871 = [];
var len__19260__auto___22874 = arguments.length;
var i__19261__auto___22875 = (0);
while(true){
if((i__19261__auto___22875 < len__19260__auto___22874)){
args22871.push((arguments[i__19261__auto___22875]));

var G__22876 = (i__19261__auto___22875 + (1));
i__19261__auto___22875 = G__22876;
continue;
} else {
}
break;
}

var G__22873 = args22871.length;
switch (G__22873) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22871.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args22878 = [];
var len__19260__auto___22881 = arguments.length;
var i__19261__auto___22882 = (0);
while(true){
if((i__19261__auto___22882 < len__19260__auto___22881)){
args22878.push((arguments[i__19261__auto___22882]));

var G__22883 = (i__19261__auto___22882 + (1));
i__19261__auto___22882 = G__22883;
continue;
} else {
}
break;
}

var G__22880 = args22878.length;
switch (G__22880) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22878.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args22885 = [];
var len__19260__auto___22936 = arguments.length;
var i__19261__auto___22937 = (0);
while(true){
if((i__19261__auto___22937 < len__19260__auto___22936)){
args22885.push((arguments[i__19261__auto___22937]));

var G__22938 = (i__19261__auto___22937 + (1));
i__19261__auto___22937 = G__22938;
continue;
} else {
}
break;
}

var G__22887 = args22885.length;
switch (G__22887) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22885.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20367__auto___22940 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto___22940,out){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto___22940,out){
return (function (state_22911){
var state_val_22912 = (state_22911[(1)]);
if((state_val_22912 === (7))){
var inst_22906 = (state_22911[(2)]);
var state_22911__$1 = state_22911;
var statearr_22913_22941 = state_22911__$1;
(statearr_22913_22941[(2)] = inst_22906);

(statearr_22913_22941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22912 === (1))){
var inst_22888 = null;
var state_22911__$1 = (function (){var statearr_22914 = state_22911;
(statearr_22914[(7)] = inst_22888);

return statearr_22914;
})();
var statearr_22915_22942 = state_22911__$1;
(statearr_22915_22942[(2)] = null);

(statearr_22915_22942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22912 === (4))){
var inst_22891 = (state_22911[(8)]);
var inst_22891__$1 = (state_22911[(2)]);
var inst_22892 = (inst_22891__$1 == null);
var inst_22893 = cljs.core.not.call(null,inst_22892);
var state_22911__$1 = (function (){var statearr_22916 = state_22911;
(statearr_22916[(8)] = inst_22891__$1);

return statearr_22916;
})();
if(inst_22893){
var statearr_22917_22943 = state_22911__$1;
(statearr_22917_22943[(1)] = (5));

} else {
var statearr_22918_22944 = state_22911__$1;
(statearr_22918_22944[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22912 === (6))){
var state_22911__$1 = state_22911;
var statearr_22919_22945 = state_22911__$1;
(statearr_22919_22945[(2)] = null);

(statearr_22919_22945[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22912 === (3))){
var inst_22908 = (state_22911[(2)]);
var inst_22909 = cljs.core.async.close_BANG_.call(null,out);
var state_22911__$1 = (function (){var statearr_22920 = state_22911;
(statearr_22920[(9)] = inst_22908);

return statearr_22920;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22911__$1,inst_22909);
} else {
if((state_val_22912 === (2))){
var state_22911__$1 = state_22911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22911__$1,(4),ch);
} else {
if((state_val_22912 === (11))){
var inst_22891 = (state_22911[(8)]);
var inst_22900 = (state_22911[(2)]);
var inst_22888 = inst_22891;
var state_22911__$1 = (function (){var statearr_22921 = state_22911;
(statearr_22921[(10)] = inst_22900);

(statearr_22921[(7)] = inst_22888);

return statearr_22921;
})();
var statearr_22922_22946 = state_22911__$1;
(statearr_22922_22946[(2)] = null);

(statearr_22922_22946[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22912 === (9))){
var inst_22891 = (state_22911[(8)]);
var state_22911__$1 = state_22911;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22911__$1,(11),out,inst_22891);
} else {
if((state_val_22912 === (5))){
var inst_22891 = (state_22911[(8)]);
var inst_22888 = (state_22911[(7)]);
var inst_22895 = cljs.core._EQ_.call(null,inst_22891,inst_22888);
var state_22911__$1 = state_22911;
if(inst_22895){
var statearr_22924_22947 = state_22911__$1;
(statearr_22924_22947[(1)] = (8));

} else {
var statearr_22925_22948 = state_22911__$1;
(statearr_22925_22948[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22912 === (10))){
var inst_22903 = (state_22911[(2)]);
var state_22911__$1 = state_22911;
var statearr_22926_22949 = state_22911__$1;
(statearr_22926_22949[(2)] = inst_22903);

(statearr_22926_22949[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22912 === (8))){
var inst_22888 = (state_22911[(7)]);
var tmp22923 = inst_22888;
var inst_22888__$1 = tmp22923;
var state_22911__$1 = (function (){var statearr_22927 = state_22911;
(statearr_22927[(7)] = inst_22888__$1);

return statearr_22927;
})();
var statearr_22928_22950 = state_22911__$1;
(statearr_22928_22950[(2)] = null);

(statearr_22928_22950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto___22940,out))
;
return ((function (switch__20255__auto__,c__20367__auto___22940,out){
return (function() {
var cljs$core$async$state_machine__20256__auto__ = null;
var cljs$core$async$state_machine__20256__auto____0 = (function (){
var statearr_22932 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22932[(0)] = cljs$core$async$state_machine__20256__auto__);

(statearr_22932[(1)] = (1));

return statearr_22932;
});
var cljs$core$async$state_machine__20256__auto____1 = (function (state_22911){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_22911);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e22933){if((e22933 instanceof Object)){
var ex__20259__auto__ = e22933;
var statearr_22934_22951 = state_22911;
(statearr_22934_22951[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22911);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22933;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22952 = state_22911;
state_22911 = G__22952;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$state_machine__20256__auto__ = function(state_22911){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20256__auto____1.call(this,state_22911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20256__auto____0;
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20256__auto____1;
return cljs$core$async$state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto___22940,out))
})();
var state__20369__auto__ = (function (){var statearr_22935 = f__20368__auto__.call(null);
(statearr_22935[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto___22940);

return statearr_22935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto___22940,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args22953 = [];
var len__19260__auto___23023 = arguments.length;
var i__19261__auto___23024 = (0);
while(true){
if((i__19261__auto___23024 < len__19260__auto___23023)){
args22953.push((arguments[i__19261__auto___23024]));

var G__23025 = (i__19261__auto___23024 + (1));
i__19261__auto___23024 = G__23025;
continue;
} else {
}
break;
}

var G__22955 = args22953.length;
switch (G__22955) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22953.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20367__auto___23027 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto___23027,out){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto___23027,out){
return (function (state_22993){
var state_val_22994 = (state_22993[(1)]);
if((state_val_22994 === (7))){
var inst_22989 = (state_22993[(2)]);
var state_22993__$1 = state_22993;
var statearr_22995_23028 = state_22993__$1;
(statearr_22995_23028[(2)] = inst_22989);

(statearr_22995_23028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (1))){
var inst_22956 = (new Array(n));
var inst_22957 = inst_22956;
var inst_22958 = (0);
var state_22993__$1 = (function (){var statearr_22996 = state_22993;
(statearr_22996[(7)] = inst_22957);

(statearr_22996[(8)] = inst_22958);

return statearr_22996;
})();
var statearr_22997_23029 = state_22993__$1;
(statearr_22997_23029[(2)] = null);

(statearr_22997_23029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (4))){
var inst_22961 = (state_22993[(9)]);
var inst_22961__$1 = (state_22993[(2)]);
var inst_22962 = (inst_22961__$1 == null);
var inst_22963 = cljs.core.not.call(null,inst_22962);
var state_22993__$1 = (function (){var statearr_22998 = state_22993;
(statearr_22998[(9)] = inst_22961__$1);

return statearr_22998;
})();
if(inst_22963){
var statearr_22999_23030 = state_22993__$1;
(statearr_22999_23030[(1)] = (5));

} else {
var statearr_23000_23031 = state_22993__$1;
(statearr_23000_23031[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (15))){
var inst_22983 = (state_22993[(2)]);
var state_22993__$1 = state_22993;
var statearr_23001_23032 = state_22993__$1;
(statearr_23001_23032[(2)] = inst_22983);

(statearr_23001_23032[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (13))){
var state_22993__$1 = state_22993;
var statearr_23002_23033 = state_22993__$1;
(statearr_23002_23033[(2)] = null);

(statearr_23002_23033[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (6))){
var inst_22958 = (state_22993[(8)]);
var inst_22979 = (inst_22958 > (0));
var state_22993__$1 = state_22993;
if(cljs.core.truth_(inst_22979)){
var statearr_23003_23034 = state_22993__$1;
(statearr_23003_23034[(1)] = (12));

} else {
var statearr_23004_23035 = state_22993__$1;
(statearr_23004_23035[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (3))){
var inst_22991 = (state_22993[(2)]);
var state_22993__$1 = state_22993;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22993__$1,inst_22991);
} else {
if((state_val_22994 === (12))){
var inst_22957 = (state_22993[(7)]);
var inst_22981 = cljs.core.vec.call(null,inst_22957);
var state_22993__$1 = state_22993;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22993__$1,(15),out,inst_22981);
} else {
if((state_val_22994 === (2))){
var state_22993__$1 = state_22993;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22993__$1,(4),ch);
} else {
if((state_val_22994 === (11))){
var inst_22973 = (state_22993[(2)]);
var inst_22974 = (new Array(n));
var inst_22957 = inst_22974;
var inst_22958 = (0);
var state_22993__$1 = (function (){var statearr_23005 = state_22993;
(statearr_23005[(10)] = inst_22973);

(statearr_23005[(7)] = inst_22957);

(statearr_23005[(8)] = inst_22958);

return statearr_23005;
})();
var statearr_23006_23036 = state_22993__$1;
(statearr_23006_23036[(2)] = null);

(statearr_23006_23036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (9))){
var inst_22957 = (state_22993[(7)]);
var inst_22971 = cljs.core.vec.call(null,inst_22957);
var state_22993__$1 = state_22993;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22993__$1,(11),out,inst_22971);
} else {
if((state_val_22994 === (5))){
var inst_22961 = (state_22993[(9)]);
var inst_22957 = (state_22993[(7)]);
var inst_22958 = (state_22993[(8)]);
var inst_22966 = (state_22993[(11)]);
var inst_22965 = (inst_22957[inst_22958] = inst_22961);
var inst_22966__$1 = (inst_22958 + (1));
var inst_22967 = (inst_22966__$1 < n);
var state_22993__$1 = (function (){var statearr_23007 = state_22993;
(statearr_23007[(12)] = inst_22965);

(statearr_23007[(11)] = inst_22966__$1);

return statearr_23007;
})();
if(cljs.core.truth_(inst_22967)){
var statearr_23008_23037 = state_22993__$1;
(statearr_23008_23037[(1)] = (8));

} else {
var statearr_23009_23038 = state_22993__$1;
(statearr_23009_23038[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (14))){
var inst_22986 = (state_22993[(2)]);
var inst_22987 = cljs.core.async.close_BANG_.call(null,out);
var state_22993__$1 = (function (){var statearr_23011 = state_22993;
(statearr_23011[(13)] = inst_22986);

return statearr_23011;
})();
var statearr_23012_23039 = state_22993__$1;
(statearr_23012_23039[(2)] = inst_22987);

(statearr_23012_23039[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (10))){
var inst_22977 = (state_22993[(2)]);
var state_22993__$1 = state_22993;
var statearr_23013_23040 = state_22993__$1;
(statearr_23013_23040[(2)] = inst_22977);

(statearr_23013_23040[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22994 === (8))){
var inst_22957 = (state_22993[(7)]);
var inst_22966 = (state_22993[(11)]);
var tmp23010 = inst_22957;
var inst_22957__$1 = tmp23010;
var inst_22958 = inst_22966;
var state_22993__$1 = (function (){var statearr_23014 = state_22993;
(statearr_23014[(7)] = inst_22957__$1);

(statearr_23014[(8)] = inst_22958);

return statearr_23014;
})();
var statearr_23015_23041 = state_22993__$1;
(statearr_23015_23041[(2)] = null);

(statearr_23015_23041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto___23027,out))
;
return ((function (switch__20255__auto__,c__20367__auto___23027,out){
return (function() {
var cljs$core$async$state_machine__20256__auto__ = null;
var cljs$core$async$state_machine__20256__auto____0 = (function (){
var statearr_23019 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23019[(0)] = cljs$core$async$state_machine__20256__auto__);

(statearr_23019[(1)] = (1));

return statearr_23019;
});
var cljs$core$async$state_machine__20256__auto____1 = (function (state_22993){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_22993);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e23020){if((e23020 instanceof Object)){
var ex__20259__auto__ = e23020;
var statearr_23021_23042 = state_22993;
(statearr_23021_23042[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22993);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23020;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23043 = state_22993;
state_22993 = G__23043;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$state_machine__20256__auto__ = function(state_22993){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20256__auto____1.call(this,state_22993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20256__auto____0;
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20256__auto____1;
return cljs$core$async$state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto___23027,out))
})();
var state__20369__auto__ = (function (){var statearr_23022 = f__20368__auto__.call(null);
(statearr_23022[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto___23027);

return statearr_23022;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto___23027,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args23044 = [];
var len__19260__auto___23118 = arguments.length;
var i__19261__auto___23119 = (0);
while(true){
if((i__19261__auto___23119 < len__19260__auto___23118)){
args23044.push((arguments[i__19261__auto___23119]));

var G__23120 = (i__19261__auto___23119 + (1));
i__19261__auto___23119 = G__23120;
continue;
} else {
}
break;
}

var G__23046 = args23044.length;
switch (G__23046) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23044.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20367__auto___23122 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20367__auto___23122,out){
return (function (){
var f__20368__auto__ = (function (){var switch__20255__auto__ = ((function (c__20367__auto___23122,out){
return (function (state_23088){
var state_val_23089 = (state_23088[(1)]);
if((state_val_23089 === (7))){
var inst_23084 = (state_23088[(2)]);
var state_23088__$1 = state_23088;
var statearr_23090_23123 = state_23088__$1;
(statearr_23090_23123[(2)] = inst_23084);

(statearr_23090_23123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23089 === (1))){
var inst_23047 = [];
var inst_23048 = inst_23047;
var inst_23049 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_23088__$1 = (function (){var statearr_23091 = state_23088;
(statearr_23091[(7)] = inst_23049);

(statearr_23091[(8)] = inst_23048);

return statearr_23091;
})();
var statearr_23092_23124 = state_23088__$1;
(statearr_23092_23124[(2)] = null);

(statearr_23092_23124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23089 === (4))){
var inst_23052 = (state_23088[(9)]);
var inst_23052__$1 = (state_23088[(2)]);
var inst_23053 = (inst_23052__$1 == null);
var inst_23054 = cljs.core.not.call(null,inst_23053);
var state_23088__$1 = (function (){var statearr_23093 = state_23088;
(statearr_23093[(9)] = inst_23052__$1);

return statearr_23093;
})();
if(inst_23054){
var statearr_23094_23125 = state_23088__$1;
(statearr_23094_23125[(1)] = (5));

} else {
var statearr_23095_23126 = state_23088__$1;
(statearr_23095_23126[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23089 === (15))){
var inst_23078 = (state_23088[(2)]);
var state_23088__$1 = state_23088;
var statearr_23096_23127 = state_23088__$1;
(statearr_23096_23127[(2)] = inst_23078);

(statearr_23096_23127[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23089 === (13))){
var state_23088__$1 = state_23088;
var statearr_23097_23128 = state_23088__$1;
(statearr_23097_23128[(2)] = null);

(statearr_23097_23128[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23089 === (6))){
var inst_23048 = (state_23088[(8)]);
var inst_23073 = inst_23048.length;
var inst_23074 = (inst_23073 > (0));
var state_23088__$1 = state_23088;
if(cljs.core.truth_(inst_23074)){
var statearr_23098_23129 = state_23088__$1;
(statearr_23098_23129[(1)] = (12));

} else {
var statearr_23099_23130 = state_23088__$1;
(statearr_23099_23130[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23089 === (3))){
var inst_23086 = (state_23088[(2)]);
var state_23088__$1 = state_23088;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23088__$1,inst_23086);
} else {
if((state_val_23089 === (12))){
var inst_23048 = (state_23088[(8)]);
var inst_23076 = cljs.core.vec.call(null,inst_23048);
var state_23088__$1 = state_23088;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23088__$1,(15),out,inst_23076);
} else {
if((state_val_23089 === (2))){
var state_23088__$1 = state_23088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23088__$1,(4),ch);
} else {
if((state_val_23089 === (11))){
var inst_23056 = (state_23088[(10)]);
var inst_23052 = (state_23088[(9)]);
var inst_23066 = (state_23088[(2)]);
var inst_23067 = [];
var inst_23068 = inst_23067.push(inst_23052);
var inst_23048 = inst_23067;
var inst_23049 = inst_23056;
var state_23088__$1 = (function (){var statearr_23100 = state_23088;
(statearr_23100[(11)] = inst_23066);

(statearr_23100[(12)] = inst_23068);

(statearr_23100[(7)] = inst_23049);

(statearr_23100[(8)] = inst_23048);

return statearr_23100;
})();
var statearr_23101_23131 = state_23088__$1;
(statearr_23101_23131[(2)] = null);

(statearr_23101_23131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23089 === (9))){
var inst_23048 = (state_23088[(8)]);
var inst_23064 = cljs.core.vec.call(null,inst_23048);
var state_23088__$1 = state_23088;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23088__$1,(11),out,inst_23064);
} else {
if((state_val_23089 === (5))){
var inst_23056 = (state_23088[(10)]);
var inst_23049 = (state_23088[(7)]);
var inst_23052 = (state_23088[(9)]);
var inst_23056__$1 = f.call(null,inst_23052);
var inst_23057 = cljs.core._EQ_.call(null,inst_23056__$1,inst_23049);
var inst_23058 = cljs.core.keyword_identical_QMARK_.call(null,inst_23049,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_23059 = (inst_23057) || (inst_23058);
var state_23088__$1 = (function (){var statearr_23102 = state_23088;
(statearr_23102[(10)] = inst_23056__$1);

return statearr_23102;
})();
if(cljs.core.truth_(inst_23059)){
var statearr_23103_23132 = state_23088__$1;
(statearr_23103_23132[(1)] = (8));

} else {
var statearr_23104_23133 = state_23088__$1;
(statearr_23104_23133[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23089 === (14))){
var inst_23081 = (state_23088[(2)]);
var inst_23082 = cljs.core.async.close_BANG_.call(null,out);
var state_23088__$1 = (function (){var statearr_23106 = state_23088;
(statearr_23106[(13)] = inst_23081);

return statearr_23106;
})();
var statearr_23107_23134 = state_23088__$1;
(statearr_23107_23134[(2)] = inst_23082);

(statearr_23107_23134[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23089 === (10))){
var inst_23071 = (state_23088[(2)]);
var state_23088__$1 = state_23088;
var statearr_23108_23135 = state_23088__$1;
(statearr_23108_23135[(2)] = inst_23071);

(statearr_23108_23135[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23089 === (8))){
var inst_23056 = (state_23088[(10)]);
var inst_23048 = (state_23088[(8)]);
var inst_23052 = (state_23088[(9)]);
var inst_23061 = inst_23048.push(inst_23052);
var tmp23105 = inst_23048;
var inst_23048__$1 = tmp23105;
var inst_23049 = inst_23056;
var state_23088__$1 = (function (){var statearr_23109 = state_23088;
(statearr_23109[(7)] = inst_23049);

(statearr_23109[(8)] = inst_23048__$1);

(statearr_23109[(14)] = inst_23061);

return statearr_23109;
})();
var statearr_23110_23136 = state_23088__$1;
(statearr_23110_23136[(2)] = null);

(statearr_23110_23136[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20367__auto___23122,out))
;
return ((function (switch__20255__auto__,c__20367__auto___23122,out){
return (function() {
var cljs$core$async$state_machine__20256__auto__ = null;
var cljs$core$async$state_machine__20256__auto____0 = (function (){
var statearr_23114 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23114[(0)] = cljs$core$async$state_machine__20256__auto__);

(statearr_23114[(1)] = (1));

return statearr_23114;
});
var cljs$core$async$state_machine__20256__auto____1 = (function (state_23088){
while(true){
var ret_value__20257__auto__ = (function (){try{while(true){
var result__20258__auto__ = switch__20255__auto__.call(null,state_23088);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20258__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20258__auto__;
}
break;
}
}catch (e23115){if((e23115 instanceof Object)){
var ex__20259__auto__ = e23115;
var statearr_23116_23137 = state_23088;
(statearr_23116_23137[(5)] = ex__20259__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23088);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23115;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20257__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23138 = state_23088;
state_23088 = G__23138;
continue;
} else {
return ret_value__20257__auto__;
}
break;
}
});
cljs$core$async$state_machine__20256__auto__ = function(state_23088){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20256__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20256__auto____1.call(this,state_23088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20256__auto____0;
cljs$core$async$state_machine__20256__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20256__auto____1;
return cljs$core$async$state_machine__20256__auto__;
})()
;})(switch__20255__auto__,c__20367__auto___23122,out))
})();
var state__20369__auto__ = (function (){var statearr_23117 = f__20368__auto__.call(null);
(statearr_23117[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20367__auto___23122);

return statearr_23117;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20369__auto__);
});})(c__20367__auto___23122,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map