goog.provide('shadow.cljs.devtools.client.browser');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.dom');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('goog.net.XhrIo');
goog.require('shadow.cljs.devtools.client.env');
goog.require('shadow.cljs.devtools.client.console');
goog.require('shadow.cljs.devtools.client.hud');
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.active_modules_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.active_modules_ref = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
}
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.repl_ns_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.repl_ns_ref = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
}
shadow.cljs.devtools.client.browser.module_loaded = (function shadow$cljs$devtools$client$browser$module_loaded(name){
return cljs.core._vreset_BANG_(shadow.cljs.devtools.client.browser.active_modules_ref,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core._deref(shadow.cljs.devtools.client.browser.active_modules_ref),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(name)));
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.socket_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.socket_ref = cljs.core.volatile_BANG_(null);
}
shadow.cljs.devtools.client.browser.devtools_msg = (function shadow$cljs$devtools$client$browser$devtools_msg(var_args){
var args__4534__auto__ = [];
var len__4531__auto___35432 = arguments.length;
var i__4532__auto___35433 = (0);
while(true){
if((i__4532__auto___35433 < len__4531__auto___35432)){
args__4534__auto__.push((arguments[i__4532__auto___35433]));

var G__35434 = (i__4532__auto___35433 + (1));
i__4532__auto___35433 = G__35434;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic = (function (msg,args){
return console.log.apply(null,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [["%cshadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join(''),"color: blue;"], null),args)));
});

shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$applyTo = (function (seq35430){
var G__35431 = cljs.core.first(seq35430);
var seq35430__$1 = cljs.core.next(seq35430);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__35431,seq35430__$1);
});

shadow.cljs.devtools.client.browser.ws_msg = (function shadow$cljs$devtools$client$browser$ws_msg(msg){
var temp__5455__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5455__auto__)){
var s = temp__5455__auto__;
return s.send(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([msg], 0)));
} else {
return console.warn("WEBSOCKET NOT CONNECTED",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([msg], 0)));
}
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.scripts_to_load !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.scripts_to_load = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
shadow.cljs.devtools.client.browser.loaded_QMARK_ = goog.isProvided_;
shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$goog_is_loaded_QMARK_(name){
return $CLJS.SHADOW_ENV.isLoaded(name);
});
shadow.cljs.devtools.client.browser.goog_base_rc = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.build.classpath","resource","shadow.build.classpath/resource",-879517823),"goog/base.js"], null);
shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$src_is_loaded_QMARK_(p__35435){
var map__35436 = p__35435;
var map__35436__$1 = ((((!((map__35436 == null)))?(((((map__35436.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35436.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35436):map__35436);
var src = map__35436__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35436__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35436__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var or__3949__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.browser.goog_base_rc,resource_id);
if(or__3949__auto__){
return or__3949__auto__;
} else {
return shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_(output_name);
}
});
shadow.cljs.devtools.client.browser.module_is_active_QMARK_ = (function shadow$cljs$devtools$client$browser$module_is_active_QMARK_(module){
return cljs.core.contains_QMARK_(cljs.core.deref(shadow.cljs.devtools.client.browser.active_modules_ref),module);
});
shadow.cljs.devtools.client.browser.script_eval = (function shadow$cljs$devtools$client$browser$script_eval(code){
return goog.globalEval(code);
});
shadow.cljs.devtools.client.browser.do_js_load = (function shadow$cljs$devtools$client$browser$do_js_load(sources){
var seq__35438 = cljs.core.seq(sources);
var chunk__35439 = null;
var count__35440 = (0);
var i__35441 = (0);
while(true){
if((i__35441 < count__35440)){
var map__35442 = chunk__35439.cljs$core$IIndexed$_nth$arity$2(null,i__35441);
var map__35442__$1 = ((((!((map__35442 == null)))?(((((map__35442.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35442.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35442):map__35442);
var src = map__35442__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35442__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35442__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35442__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35442__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));


var G__35446 = seq__35438;
var G__35447 = chunk__35439;
var G__35448 = count__35440;
var G__35449 = (i__35441 + (1));
seq__35438 = G__35446;
chunk__35439 = G__35447;
count__35440 = G__35448;
i__35441 = G__35449;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__35438);
if(temp__5457__auto__){
var seq__35438__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35438__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__35438__$1);
var G__35450 = cljs.core.chunk_rest(seq__35438__$1);
var G__35451 = c__4351__auto__;
var G__35452 = cljs.core.count(c__4351__auto__);
var G__35453 = (0);
seq__35438 = G__35450;
chunk__35439 = G__35451;
count__35440 = G__35452;
i__35441 = G__35453;
continue;
} else {
var map__35444 = cljs.core.first(seq__35438__$1);
var map__35444__$1 = ((((!((map__35444 == null)))?(((((map__35444.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35444.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35444):map__35444);
var src = map__35444__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35444__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35444__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35444__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35444__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));


var G__35454 = cljs.core.next(seq__35438__$1);
var G__35455 = null;
var G__35456 = (0);
var G__35457 = (0);
seq__35438 = G__35454;
chunk__35439 = G__35455;
count__35440 = G__35456;
i__35441 = G__35457;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.do_js_reload = (function shadow$cljs$devtools$client$browser$do_js_reload(msg,sources,complete_fn,failure_fn){
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$4(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(msg,new cljs.core.Keyword(null,"log-missing-fn","log-missing-fn",732676765),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["can't find fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"log-call-async","log-call-async",183826192),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call async ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call","log-call",412404391),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
})], 0)),(function (){
return shadow.cljs.devtools.client.browser.do_js_load(sources);
}),complete_fn,failure_fn);
});
/**
 * when (require '["some-str" :as x]) is done at the REPL we need to manually call the shadow.js.require for it
 * since the file only adds the shadow$provide. only need to do this for shadow-js.
 */
shadow.cljs.devtools.client.browser.do_js_requires = (function shadow$cljs$devtools$client$browser$do_js_requires(js_requires){
var seq__35458 = cljs.core.seq(js_requires);
var chunk__35459 = null;
var count__35460 = (0);
var i__35461 = (0);
while(true){
if((i__35461 < count__35460)){
var js_ns = chunk__35459.cljs$core$IIndexed$_nth$arity$2(null,i__35461);
var require_str_35462 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_35462);


var G__35463 = seq__35458;
var G__35464 = chunk__35459;
var G__35465 = count__35460;
var G__35466 = (i__35461 + (1));
seq__35458 = G__35463;
chunk__35459 = G__35464;
count__35460 = G__35465;
i__35461 = G__35466;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__35458);
if(temp__5457__auto__){
var seq__35458__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35458__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__35458__$1);
var G__35467 = cljs.core.chunk_rest(seq__35458__$1);
var G__35468 = c__4351__auto__;
var G__35469 = cljs.core.count(c__4351__auto__);
var G__35470 = (0);
seq__35458 = G__35467;
chunk__35459 = G__35468;
count__35460 = G__35469;
i__35461 = G__35470;
continue;
} else {
var js_ns = cljs.core.first(seq__35458__$1);
var require_str_35471 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_35471);


var G__35472 = cljs.core.next(seq__35458__$1);
var G__35473 = null;
var G__35474 = (0);
var G__35475 = (0);
seq__35458 = G__35472;
chunk__35459 = G__35473;
count__35460 = G__35474;
i__35461 = G__35475;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.load_sources = (function shadow$cljs$devtools$client$browser$load_sources(sources,callback){
if(cljs.core.empty_QMARK_(sources)){
var G__35476 = cljs.core.PersistentVector.EMPTY;
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__35476) : callback.call(null,G__35476));
} else {
var G__35477 = shadow.cljs.devtools.client.env.files_url();
var G__35478 = ((function (G__35477){
return (function (res){
var req = this;
var content = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(req.getResponseText());
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(content) : callback.call(null,content));
});})(G__35477))
;
var G__35479 = "POST";
var G__35480 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"client","client",-1323448117),new cljs.core.Keyword(null,"browser","browser",828191719),new cljs.core.Keyword(null,"sources","sources",-321166424),cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582)),sources)], null)], 0));
var G__35481 = ({"content-type": "application/edn; charset=utf-8"});
return goog.net.XhrIo.send(G__35477,G__35478,G__35479,G__35480,G__35481);
}
});
shadow.cljs.devtools.client.browser.handle_build_complete = (function shadow$cljs$devtools$client$browser$handle_build_complete(p__35483){
var map__35484 = p__35483;
var map__35484__$1 = ((((!((map__35484 == null)))?(((((map__35484.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35484.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35484):map__35484);
var msg = map__35484__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35484__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var reload_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35484__$1,new cljs.core.Keyword(null,"reload-info","reload-info",1648088086));
var map__35486 = info;
var map__35486__$1 = ((((!((map__35486 == null)))?(((((map__35486.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35486.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35486):map__35486);
var sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35486__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var compiled = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35486__$1,new cljs.core.Keyword(null,"compiled","compiled",850043082));
var warnings = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((function (){var iter__4324__auto__ = ((function (map__35486,map__35486__$1,sources,compiled,map__35484,map__35484__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__35488(s__35489){
return (new cljs.core.LazySeq(null,((function (map__35486,map__35486__$1,sources,compiled,map__35484,map__35484__$1,msg,info,reload_info){
return (function (){
var s__35489__$1 = s__35489;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__35489__$1);
if(temp__5457__auto__){
var xs__6012__auto__ = temp__5457__auto__;
var map__35494 = cljs.core.first(xs__6012__auto__);
var map__35494__$1 = ((((!((map__35494 == null)))?(((((map__35494.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35494.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35494):map__35494);
var src = map__35494__$1;
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35494__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var warnings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35494__$1,new cljs.core.Keyword(null,"warnings","warnings",-735437651));
if(cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))){
var iterys__4320__auto__ = ((function (s__35489__$1,map__35494,map__35494__$1,src,resource_name,warnings,xs__6012__auto__,temp__5457__auto__,map__35486,map__35486__$1,sources,compiled,map__35484,map__35484__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__35488_$_iter__35490(s__35491){
return (new cljs.core.LazySeq(null,((function (s__35489__$1,map__35494,map__35494__$1,src,resource_name,warnings,xs__6012__auto__,temp__5457__auto__,map__35486,map__35486__$1,sources,compiled,map__35484,map__35484__$1,msg,info,reload_info){
return (function (){
var s__35491__$1 = s__35491;
while(true){
var temp__5457__auto____$1 = cljs.core.seq(s__35491__$1);
if(temp__5457__auto____$1){
var s__35491__$2 = temp__5457__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__35491__$2)){
var c__4322__auto__ = cljs.core.chunk_first(s__35491__$2);
var size__4323__auto__ = cljs.core.count(c__4322__auto__);
var b__35493 = cljs.core.chunk_buffer(size__4323__auto__);
if((function (){var i__35492 = (0);
while(true){
if((i__35492 < size__4323__auto__)){
var warning = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4322__auto__,i__35492);
cljs.core.chunk_append(b__35493,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name));

var G__35513 = (i__35492 + (1));
i__35492 = G__35513;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35493),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__35488_$_iter__35490(cljs.core.chunk_rest(s__35491__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35493),null);
}
} else {
var warning = cljs.core.first(s__35491__$2);
return cljs.core.cons(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__35488_$_iter__35490(cljs.core.rest(s__35491__$2)));
}
} else {
return null;
}
break;
}
});})(s__35489__$1,map__35494,map__35494__$1,src,resource_name,warnings,xs__6012__auto__,temp__5457__auto__,map__35486,map__35486__$1,sources,compiled,map__35484,map__35484__$1,msg,info,reload_info))
,null,null));
});})(s__35489__$1,map__35494,map__35494__$1,src,resource_name,warnings,xs__6012__auto__,temp__5457__auto__,map__35486,map__35486__$1,sources,compiled,map__35484,map__35484__$1,msg,info,reload_info))
;
var fs__4321__auto__ = cljs.core.seq(iterys__4320__auto__(warnings));
if(fs__4321__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4321__auto__,shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__35488(cljs.core.rest(s__35489__$1)));
} else {
var G__35514 = cljs.core.rest(s__35489__$1);
s__35489__$1 = G__35514;
continue;
}
} else {
var G__35515 = cljs.core.rest(s__35489__$1);
s__35489__$1 = G__35515;
continue;
}
} else {
return null;
}
break;
}
});})(map__35486,map__35486__$1,sources,compiled,map__35484,map__35484__$1,msg,info,reload_info))
,null,null));
});})(map__35486,map__35486__$1,sources,compiled,map__35484,map__35484__$1,msg,info,reload_info))
;
return iter__4324__auto__(sources);
})()));
var seq__35496_35516 = cljs.core.seq(warnings);
var chunk__35497_35517 = null;
var count__35498_35518 = (0);
var i__35499_35519 = (0);
while(true){
if((i__35499_35519 < count__35498_35518)){
var map__35500_35520 = chunk__35497_35517.cljs$core$IIndexed$_nth$arity$2(null,i__35499_35519);
var map__35500_35521__$1 = ((((!((map__35500_35520 == null)))?(((((map__35500_35520.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35500_35520.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35500_35520):map__35500_35520);
var w_35522 = map__35500_35521__$1;
var msg_35523__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35500_35521__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_35524 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35500_35521__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_35525 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35500_35521__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_35526 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35500_35521__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_35526)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_35524),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_35525),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_35523__$1)].join(''));


var G__35527 = seq__35496_35516;
var G__35528 = chunk__35497_35517;
var G__35529 = count__35498_35518;
var G__35530 = (i__35499_35519 + (1));
seq__35496_35516 = G__35527;
chunk__35497_35517 = G__35528;
count__35498_35518 = G__35529;
i__35499_35519 = G__35530;
continue;
} else {
var temp__5457__auto___35531 = cljs.core.seq(seq__35496_35516);
if(temp__5457__auto___35531){
var seq__35496_35532__$1 = temp__5457__auto___35531;
if(cljs.core.chunked_seq_QMARK_(seq__35496_35532__$1)){
var c__4351__auto___35533 = cljs.core.chunk_first(seq__35496_35532__$1);
var G__35534 = cljs.core.chunk_rest(seq__35496_35532__$1);
var G__35535 = c__4351__auto___35533;
var G__35536 = cljs.core.count(c__4351__auto___35533);
var G__35537 = (0);
seq__35496_35516 = G__35534;
chunk__35497_35517 = G__35535;
count__35498_35518 = G__35536;
i__35499_35519 = G__35537;
continue;
} else {
var map__35502_35538 = cljs.core.first(seq__35496_35532__$1);
var map__35502_35539__$1 = ((((!((map__35502_35538 == null)))?(((((map__35502_35538.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35502_35538.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35502_35538):map__35502_35538);
var w_35540 = map__35502_35539__$1;
var msg_35541__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35502_35539__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_35542 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35502_35539__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_35543 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35502_35539__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_35544 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35502_35539__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_35544)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_35542),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_35543),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_35541__$1)].join(''));


var G__35545 = cljs.core.next(seq__35496_35532__$1);
var G__35546 = null;
var G__35547 = (0);
var G__35548 = (0);
seq__35496_35516 = G__35545;
chunk__35497_35517 = G__35546;
count__35498_35518 = G__35547;
i__35499_35519 = G__35548;
continue;
}
} else {
}
}
break;
}

if(!(shadow.cljs.devtools.client.env.autoload)){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
if(((cljs.core.empty_QMARK_(warnings)) || (shadow.cljs.devtools.client.env.ignore_warnings))){
var sources_to_get = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__35486,map__35486__$1,sources,compiled,warnings,map__35484,map__35484__$1,msg,info,reload_info){
return (function (p__35504){
var map__35505 = p__35504;
var map__35505__$1 = ((((!((map__35505 == null)))?(((((map__35505.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35505.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35505):map__35505);
var src = map__35505__$1;
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35505__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35505__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
return ((cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"always-load","always-load",66405637).cljs$core$IFn$_invoke$arity$1(reload_info),ns)) || (cljs.core.not(shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_(src))) || (((cljs.core.contains_QMARK_(compiled,resource_id)) && (cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))))));
});})(map__35486,map__35486__$1,sources,compiled,warnings,map__35484,map__35484__$1,msg,info,reload_info))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (map__35486,map__35486__$1,sources,compiled,warnings,map__35484,map__35484__$1,msg,info,reload_info){
return (function (p__35507){
var map__35508 = p__35507;
var map__35508__$1 = ((((!((map__35508 == null)))?(((((map__35508.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35508.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35508):map__35508);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35508__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"never-load","never-load",1300896819).cljs$core$IFn$_invoke$arity$1(reload_info),ns);
});})(map__35486,map__35486__$1,sources,compiled,warnings,map__35484,map__35484__$1,msg,info,reload_info))
,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__35486,map__35486__$1,sources,compiled,warnings,map__35484,map__35484__$1,msg,info,reload_info){
return (function (p__35510){
var map__35511 = p__35510;
var map__35511__$1 = ((((!((map__35511 == null)))?(((((map__35511.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35511.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35511):map__35511);
var rc = map__35511__$1;
var module = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35511__$1,new cljs.core.Keyword(null,"module","module",1424618191));
var or__3949__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("js",shadow.cljs.devtools.client.env.module_format);
if(or__3949__auto__){
return or__3949__auto__;
} else {
return shadow.cljs.devtools.client.browser.module_is_active_QMARK_(module);
}
});})(map__35486,map__35486__$1,sources,compiled,warnings,map__35484,map__35484__$1,msg,info,reload_info))
,sources))));
if(cljs.core.not(cljs.core.seq(sources_to_get))){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
return shadow.cljs.devtools.client.browser.load_sources(sources_to_get,((function (sources_to_get,map__35486,map__35486__$1,sources,compiled,warnings,map__35484,map__35484__$1,msg,info,reload_info){
return (function (p1__35482_SHARP_){
return shadow.cljs.devtools.client.browser.do_js_reload(msg,p1__35482_SHARP_,shadow.cljs.devtools.client.hud.load_end_success,shadow.cljs.devtools.client.hud.load_failure);
});})(sources_to_get,map__35486,map__35486__$1,sources,compiled,warnings,map__35484,map__35484__$1,msg,info,reload_info))
);
}
} else {
return null;
}
}
});
shadow.cljs.devtools.client.browser.page_load_uri = (cljs.core.truth_(goog.global.document)?goog.Uri.parse(document.location.href):null);
shadow.cljs.devtools.client.browser.handle_asset_watch = (function shadow$cljs$devtools$client$browser$handle_asset_watch(p__35549){
var map__35550 = p__35549;
var map__35550__$1 = ((((!((map__35550 == null)))?(((((map__35550.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35550.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35550):map__35550);
var msg = map__35550__$1;
var updates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35550__$1,new cljs.core.Keyword(null,"updates","updates",2013983452));
var seq__35552 = cljs.core.seq(updates);
var chunk__35554 = null;
var count__35555 = (0);
var i__35556 = (0);
while(true){
if((i__35556 < count__35555)){
var path = chunk__35554.cljs$core$IIndexed$_nth$arity$2(null,i__35556);
if(clojure.string.ends_with_QMARK_(path,"css")){
var seq__35558_35582 = cljs.core.seq(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__35561_35583 = null;
var count__35562_35584 = (0);
var i__35563_35585 = (0);
while(true){
if((i__35563_35585 < count__35562_35584)){
var node_35586 = chunk__35561_35583.cljs$core$IIndexed$_nth$arity$2(null,i__35563_35585);
var node_uri_35587 = (function (){var G__35566 = node_35586.getAttribute("href");
return goog.Uri.parse(G__35566);
})();
var node_uri_resolved_35588 = shadow.cljs.devtools.client.browser.page_load_uri.resolve(node_uri_35587);
var node_abs_35589 = node_uri_resolved_35588.getPath();
if(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.browser.page_load_uri.hasSameDomainAs(node_uri_35587))) || (cljs.core.not(node_uri_35587.hasDomain())))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(node_abs_35589,path)))){
var new_link_35590 = (function (){var G__35567 = node_35586.cloneNode(true);
G__35567.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__35567;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path], 0));

goog.dom.insertSiblingAfter(new_link_35590,node_35586);

goog.dom.removeNode(node_35586);


var G__35591 = seq__35558_35582;
var G__35592 = chunk__35561_35583;
var G__35593 = count__35562_35584;
var G__35594 = (i__35563_35585 + (1));
seq__35558_35582 = G__35591;
chunk__35561_35583 = G__35592;
count__35562_35584 = G__35593;
i__35563_35585 = G__35594;
continue;
} else {
var G__35595 = seq__35558_35582;
var G__35596 = chunk__35561_35583;
var G__35597 = count__35562_35584;
var G__35598 = (i__35563_35585 + (1));
seq__35558_35582 = G__35595;
chunk__35561_35583 = G__35596;
count__35562_35584 = G__35597;
i__35563_35585 = G__35598;
continue;
}
} else {
var temp__5457__auto___35599 = cljs.core.seq(seq__35558_35582);
if(temp__5457__auto___35599){
var seq__35558_35600__$1 = temp__5457__auto___35599;
if(cljs.core.chunked_seq_QMARK_(seq__35558_35600__$1)){
var c__4351__auto___35601 = cljs.core.chunk_first(seq__35558_35600__$1);
var G__35602 = cljs.core.chunk_rest(seq__35558_35600__$1);
var G__35603 = c__4351__auto___35601;
var G__35604 = cljs.core.count(c__4351__auto___35601);
var G__35605 = (0);
seq__35558_35582 = G__35602;
chunk__35561_35583 = G__35603;
count__35562_35584 = G__35604;
i__35563_35585 = G__35605;
continue;
} else {
var node_35606 = cljs.core.first(seq__35558_35600__$1);
var node_uri_35607 = (function (){var G__35568 = node_35606.getAttribute("href");
return goog.Uri.parse(G__35568);
})();
var node_uri_resolved_35608 = shadow.cljs.devtools.client.browser.page_load_uri.resolve(node_uri_35607);
var node_abs_35609 = node_uri_resolved_35608.getPath();
if(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.browser.page_load_uri.hasSameDomainAs(node_uri_35607))) || (cljs.core.not(node_uri_35607.hasDomain())))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(node_abs_35609,path)))){
var new_link_35610 = (function (){var G__35569 = node_35606.cloneNode(true);
G__35569.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__35569;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path], 0));

goog.dom.insertSiblingAfter(new_link_35610,node_35606);

goog.dom.removeNode(node_35606);


var G__35611 = cljs.core.next(seq__35558_35600__$1);
var G__35612 = null;
var G__35613 = (0);
var G__35614 = (0);
seq__35558_35582 = G__35611;
chunk__35561_35583 = G__35612;
count__35562_35584 = G__35613;
i__35563_35585 = G__35614;
continue;
} else {
var G__35615 = cljs.core.next(seq__35558_35600__$1);
var G__35616 = null;
var G__35617 = (0);
var G__35618 = (0);
seq__35558_35582 = G__35615;
chunk__35561_35583 = G__35616;
count__35562_35584 = G__35617;
i__35563_35585 = G__35618;
continue;
}
}
} else {
}
}
break;
}


var G__35619 = seq__35552;
var G__35620 = chunk__35554;
var G__35621 = count__35555;
var G__35622 = (i__35556 + (1));
seq__35552 = G__35619;
chunk__35554 = G__35620;
count__35555 = G__35621;
i__35556 = G__35622;
continue;
} else {
var G__35623 = seq__35552;
var G__35624 = chunk__35554;
var G__35625 = count__35555;
var G__35626 = (i__35556 + (1));
seq__35552 = G__35623;
chunk__35554 = G__35624;
count__35555 = G__35625;
i__35556 = G__35626;
continue;
}
} else {
var temp__5457__auto__ = cljs.core.seq(seq__35552);
if(temp__5457__auto__){
var seq__35552__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35552__$1)){
var c__4351__auto__ = cljs.core.chunk_first(seq__35552__$1);
var G__35627 = cljs.core.chunk_rest(seq__35552__$1);
var G__35628 = c__4351__auto__;
var G__35629 = cljs.core.count(c__4351__auto__);
var G__35630 = (0);
seq__35552 = G__35627;
chunk__35554 = G__35628;
count__35555 = G__35629;
i__35556 = G__35630;
continue;
} else {
var path = cljs.core.first(seq__35552__$1);
if(clojure.string.ends_with_QMARK_(path,"css")){
var seq__35570_35631 = cljs.core.seq(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__35573_35632 = null;
var count__35574_35633 = (0);
var i__35575_35634 = (0);
while(true){
if((i__35575_35634 < count__35574_35633)){
var node_35635 = chunk__35573_35632.cljs$core$IIndexed$_nth$arity$2(null,i__35575_35634);
var node_uri_35636 = (function (){var G__35578 = node_35635.getAttribute("href");
return goog.Uri.parse(G__35578);
})();
var node_uri_resolved_35637 = shadow.cljs.devtools.client.browser.page_load_uri.resolve(node_uri_35636);
var node_abs_35638 = node_uri_resolved_35637.getPath();
if(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.browser.page_load_uri.hasSameDomainAs(node_uri_35636))) || (cljs.core.not(node_uri_35636.hasDomain())))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(node_abs_35638,path)))){
var new_link_35639 = (function (){var G__35579 = node_35635.cloneNode(true);
G__35579.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__35579;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path], 0));

goog.dom.insertSiblingAfter(new_link_35639,node_35635);

goog.dom.removeNode(node_35635);


var G__35640 = seq__35570_35631;
var G__35641 = chunk__35573_35632;
var G__35642 = count__35574_35633;
var G__35643 = (i__35575_35634 + (1));
seq__35570_35631 = G__35640;
chunk__35573_35632 = G__35641;
count__35574_35633 = G__35642;
i__35575_35634 = G__35643;
continue;
} else {
var G__35644 = seq__35570_35631;
var G__35645 = chunk__35573_35632;
var G__35646 = count__35574_35633;
var G__35647 = (i__35575_35634 + (1));
seq__35570_35631 = G__35644;
chunk__35573_35632 = G__35645;
count__35574_35633 = G__35646;
i__35575_35634 = G__35647;
continue;
}
} else {
var temp__5457__auto___35648__$1 = cljs.core.seq(seq__35570_35631);
if(temp__5457__auto___35648__$1){
var seq__35570_35649__$1 = temp__5457__auto___35648__$1;
if(cljs.core.chunked_seq_QMARK_(seq__35570_35649__$1)){
var c__4351__auto___35650 = cljs.core.chunk_first(seq__35570_35649__$1);
var G__35651 = cljs.core.chunk_rest(seq__35570_35649__$1);
var G__35652 = c__4351__auto___35650;
var G__35653 = cljs.core.count(c__4351__auto___35650);
var G__35654 = (0);
seq__35570_35631 = G__35651;
chunk__35573_35632 = G__35652;
count__35574_35633 = G__35653;
i__35575_35634 = G__35654;
continue;
} else {
var node_35655 = cljs.core.first(seq__35570_35649__$1);
var node_uri_35656 = (function (){var G__35580 = node_35655.getAttribute("href");
return goog.Uri.parse(G__35580);
})();
var node_uri_resolved_35657 = shadow.cljs.devtools.client.browser.page_load_uri.resolve(node_uri_35656);
var node_abs_35658 = node_uri_resolved_35657.getPath();
if(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.browser.page_load_uri.hasSameDomainAs(node_uri_35656))) || (cljs.core.not(node_uri_35656.hasDomain())))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(node_abs_35658,path)))){
var new_link_35659 = (function (){var G__35581 = node_35655.cloneNode(true);
G__35581.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__35581;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path], 0));

goog.dom.insertSiblingAfter(new_link_35659,node_35655);

goog.dom.removeNode(node_35655);


var G__35660 = cljs.core.next(seq__35570_35649__$1);
var G__35661 = null;
var G__35662 = (0);
var G__35663 = (0);
seq__35570_35631 = G__35660;
chunk__35573_35632 = G__35661;
count__35574_35633 = G__35662;
i__35575_35634 = G__35663;
continue;
} else {
var G__35664 = cljs.core.next(seq__35570_35649__$1);
var G__35665 = null;
var G__35666 = (0);
var G__35667 = (0);
seq__35570_35631 = G__35664;
chunk__35573_35632 = G__35665;
count__35574_35633 = G__35666;
i__35575_35634 = G__35667;
continue;
}
}
} else {
}
}
break;
}


var G__35668 = cljs.core.next(seq__35552__$1);
var G__35669 = null;
var G__35670 = (0);
var G__35671 = (0);
seq__35552 = G__35668;
chunk__35554 = G__35669;
count__35555 = G__35670;
i__35556 = G__35671;
continue;
} else {
var G__35672 = cljs.core.next(seq__35552__$1);
var G__35673 = null;
var G__35674 = (0);
var G__35675 = (0);
seq__35552 = G__35672;
chunk__35554 = G__35673;
count__35555 = G__35674;
i__35556 = G__35675;
continue;
}
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.get_ua_product = (function shadow$cljs$devtools$client$browser$get_ua_product(){
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
});
shadow.cljs.devtools.client.browser.get_asset_root = (function shadow$cljs$devtools$client$browser$get_asset_root(){
var loc = (new goog.Uri(document.location.href));
var cbp = (new goog.Uri(CLOSURE_BASE_PATH));
var s = loc.resolve(cbp).toString();
return clojure.string.replace(s,/^file:\//,"file:///");
});
shadow.cljs.devtools.client.browser.repl_error = (function shadow$cljs$devtools$client$browser$repl_error(e){
console.error("repl/invoke error",e);

return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(shadow.cljs.devtools.client.env.repl_error(e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),shadow.cljs.devtools.client.browser.get_ua_product(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"asset-root","asset-root",1771735072),shadow.cljs.devtools.client.browser.get_asset_root()], 0));
});
shadow.cljs.devtools.client.browser.repl_invoke = (function shadow$cljs$devtools$client$browser$repl_invoke(p__35676){
var map__35677 = p__35676;
var map__35677__$1 = ((((!((map__35677 == null)))?(((((map__35677.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35677.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35677):map__35677);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35677__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35677__$1,new cljs.core.Keyword(null,"js","js",1768080579));
var result = shadow.cljs.devtools.client.env.repl_call(((function (map__35677,map__35677__$1,id,js){
return (function (){
return eval(js);
});})(map__35677,map__35677__$1,id,js))
,shadow.cljs.devtools.client.browser.repl_error);
return shadow.cljs.devtools.client.browser.ws_msg(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.Keyword(null,"id","id",-1388402092),id));
});
shadow.cljs.devtools.client.browser.repl_require = (function shadow$cljs$devtools$client$browser$repl_require(p__35679){
var map__35680 = p__35679;
var map__35680__$1 = ((((!((map__35680 == null)))?(((((map__35680.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35680.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35680):map__35680);
var msg = map__35680__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35680__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35680__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var reload_namespaces = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35680__$1,new cljs.core.Keyword(null,"reload-namespaces","reload-namespaces",250210134));
var js_requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35680__$1,new cljs.core.Keyword(null,"js-requires","js-requires",-1311472051));
var sources_to_load = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (map__35680,map__35680__$1,msg,id,sources,reload_namespaces,js_requires){
return (function (p__35682){
var map__35683 = p__35682;
var map__35683__$1 = ((((!((map__35683 == null)))?(((((map__35683.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35683.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35683):map__35683);
var src = map__35683__$1;
var provides = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35683__$1,new cljs.core.Keyword(null,"provides","provides",-1634397992));
var and__3938__auto__ = shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_(src);
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.not(cljs.core.some(reload_namespaces,provides));
} else {
return and__3938__auto__;
}
});})(map__35680,map__35680__$1,msg,id,sources,reload_namespaces,js_requires))
,sources));
return shadow.cljs.devtools.client.browser.load_sources(sources_to_load,((function (sources_to_load,map__35680,map__35680__$1,msg,id,sources,reload_namespaces,js_requires){
return (function (sources__$1){
shadow.cljs.devtools.client.browser.do_js_load(sources__$1);

if(cljs.core.seq(js_requires)){
shadow.cljs.devtools.client.browser.do_js_requires(js_requires);
} else {
}

return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-complete","repl/require-complete",-2140254719),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));
});})(sources_to_load,map__35680,map__35680__$1,msg,id,sources,reload_namespaces,js_requires))
);
});
shadow.cljs.devtools.client.browser.repl_init = (function shadow$cljs$devtools$client$browser$repl_init(p__35685){
var map__35686 = p__35685;
var map__35686__$1 = ((((!((map__35686 == null)))?(((((map__35686.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35686.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35686):map__35686);
var repl_state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35686__$1,new cljs.core.Keyword(null,"repl-state","repl-state",-1733780387));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35686__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
cljs.core.reset_BANG_(shadow.cljs.devtools.client.browser.repl_ns_ref,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(repl_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current","current",-1088038603),new cljs.core.Keyword(null,"ns","ns",441598760)], null)));

return shadow.cljs.devtools.client.browser.load_sources(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_,new cljs.core.Keyword(null,"repl-sources","repl-sources",723867535).cljs$core$IFn$_invoke$arity$1(repl_state))),((function (map__35686,map__35686__$1,repl_state,id){
return (function (sources){
shadow.cljs.devtools.client.browser.do_js_load(sources);

shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","init-complete","repl/init-complete",-162252879),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));

return shadow.cljs.devtools.client.browser.devtools_msg("REPL init successful");
});})(map__35686,map__35686__$1,repl_state,id))
);
});
shadow.cljs.devtools.client.browser.repl_set_ns = (function shadow$cljs$devtools$client$browser$repl_set_ns(p__35688){
var map__35689 = p__35688;
var map__35689__$1 = ((((!((map__35689 == null)))?(((((map__35689.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35689.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35689):map__35689);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35689__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35689__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
cljs.core.reset_BANG_(shadow.cljs.devtools.client.browser.repl_ns_ref,ns);

return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","set-ns-complete","repl/set-ns-complete",680944662),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
});
shadow.cljs.devtools.client.browser.close_reason_ref = cljs.core.volatile_BANG_(null);
shadow.cljs.devtools.client.browser.handle_message = (function shadow$cljs$devtools$client$browser$handle_message(p__35691){
var map__35692 = p__35691;
var map__35692__$1 = ((((!((map__35692 == null)))?(((((map__35692.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35692.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35692):map__35692);
var msg = map__35692__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35692__$1,new cljs.core.Keyword(null,"type","type",1174270348));
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

var G__35694 = type;
var G__35694__$1 = (((G__35694 instanceof cljs.core.Keyword))?G__35694.fqn:null);
switch (G__35694__$1) {
case "asset-watch":
return shadow.cljs.devtools.client.browser.handle_asset_watch(msg);

break;
case "repl/invoke":
return shadow.cljs.devtools.client.browser.repl_invoke(msg);

break;
case "repl/require":
return shadow.cljs.devtools.client.browser.repl_require(msg);

break;
case "repl/set-ns":
return shadow.cljs.devtools.client.browser.repl_set_ns(msg);

break;
case "repl/init":
return shadow.cljs.devtools.client.browser.repl_init(msg);

break;
case "build-complete":
shadow.cljs.devtools.client.hud.hud_warnings(msg);

return shadow.cljs.devtools.client.browser.handle_build_complete(msg);

break;
case "build-failure":
shadow.cljs.devtools.client.hud.load_end();

return shadow.cljs.devtools.client.hud.hud_error(msg);

break;
case "build-init":
return shadow.cljs.devtools.client.hud.hud_warnings(msg);

break;
case "build-start":
shadow.cljs.devtools.client.hud.hud_hide();

return shadow.cljs.devtools.client.hud.load_start();

break;
case "pong":
return null;

break;
case "client/stale":
return cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,"Stale Client! You are not using the latest compilation output!");

break;
case "client/no-worker":
return cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,["watch for build \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.build_id),"\" not running"].join(''));

break;
default:
return new cljs.core.Keyword(null,"ignored","ignored",1227374526);

}
});
shadow.cljs.devtools.client.browser.compile = (function shadow$cljs$devtools$client$browser$compile(text,callback){
var G__35696 = ["http",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((shadow.cljs.devtools.client.env.ssl)?"s":null)),"://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_host),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_port),"/worker/compile/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.build_id),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.proc_id),"/browser"].join('');
var G__35697 = ((function (G__35696){
return (function (res){
var req = this;
var actions = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(req.getResponseText());
if(cljs.core.truth_(callback)){
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(actions) : callback.call(null,actions));
} else {
return null;
}
});})(G__35696))
;
var G__35698 = "POST";
var G__35699 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input","input",556931961),text], null)], 0));
var G__35700 = ({"content-type": "application/edn; charset=utf-8"});
return goog.net.XhrIo.send(G__35696,G__35697,G__35698,G__35699,G__35700);
});
shadow.cljs.devtools.client.browser.heartbeat_BANG_ = (function shadow$cljs$devtools$client$browser$heartbeat_BANG_(){
var temp__5457__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5457__auto__)){
var s = temp__5457__auto__;
s.send(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ping","ping",-1670114784),new cljs.core.Keyword(null,"v","v",21465059),Date.now()], null)], 0)));

return setTimeout(shadow.cljs.devtools.client.browser.heartbeat_BANG_,(30000));
} else {
return null;
}
});
shadow.cljs.devtools.client.browser.ws_connect = (function shadow$cljs$devtools$client$browser$ws_connect(){
var print_fn = cljs.core._STAR_print_fn_STAR_;
var ws_url = shadow.cljs.devtools.client.env.ws_url(new cljs.core.Keyword(null,"browser","browser",828191719));
var socket = (new WebSocket(ws_url));
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,socket);

socket.onmessage = ((function (print_fn,ws_url,socket){
return (function (e){
return shadow.cljs.devtools.client.env.process_ws_msg(e.data,shadow.cljs.devtools.client.browser.handle_message);
});})(print_fn,ws_url,socket))
;

socket.onopen = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,null);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("goog",shadow.cljs.devtools.client.env.module_format)){
goog.provide = goog.constructNamespace_;
} else {
}

shadow.cljs.devtools.client.env.set_print_fns_BANG_(shadow.cljs.devtools.client.browser.ws_msg);

return shadow.cljs.devtools.client.browser.devtools_msg("WebSocket connected!");
});})(print_fn,ws_url,socket))
;

socket.onclose = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.browser.devtools_msg("WebSocket disconnected!");

shadow.cljs.devtools.client.hud.connection_error((function (){var or__3949__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.close_reason_ref);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return "Connection closed!";
}
})());

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,null);

return shadow.cljs.devtools.client.env.reset_print_fns_BANG_();
});})(print_fn,ws_url,socket))
;

socket.onerror = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.hud.connection_error("Connection failed!");

return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("websocket error",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
});})(print_fn,ws_url,socket))
;

return setTimeout(shadow.cljs.devtools.client.browser.heartbeat_BANG_,(30000));
});
if(shadow.cljs.devtools.client.env.enabled){
var temp__5457__auto___35701 = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5457__auto___35701)){
var s_35702 = temp__5457__auto___35701;
shadow.cljs.devtools.client.browser.devtools_msg("connection reset!");

s_35702.onclose = ((function (s_35702,temp__5457__auto___35701){
return (function (e){
return null;
});})(s_35702,temp__5457__auto___35701))
;

s_35702.close();

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,null);
} else {
}

window.addEventListener("beforeunload",(function (){
var temp__5457__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5457__auto__)){
var s = temp__5457__auto__;
return s.close();
} else {
return null;
}
}));

shadow.cljs.devtools.client.browser.ws_connect();
} else {
}

//# sourceMappingURL=shadow.cljs.devtools.client.browser.js.map
