goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__31464 = arguments.length;
switch (G__31464) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31469 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31469 = (function (f,blockable,meta31470){
this.f = f;
this.blockable = blockable;
this.meta31470 = meta31470;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31469.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31471,meta31470__$1){
var self__ = this;
var _31471__$1 = this;
return (new cljs.core.async.t_cljs$core$async31469(self__.f,self__.blockable,meta31470__$1));
});

cljs.core.async.t_cljs$core$async31469.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31471){
var self__ = this;
var _31471__$1 = this;
return self__.meta31470;
});

cljs.core.async.t_cljs$core$async31469.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31469.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31469.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async31469.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async31469.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta31470","meta31470",-895257945,null)], null);
});

cljs.core.async.t_cljs$core$async31469.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31469.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31469";

cljs.core.async.t_cljs$core$async31469.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async31469");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31469.
 */
cljs.core.async.__GT_t_cljs$core$async31469 = (function cljs$core$async$__GT_t_cljs$core$async31469(f__$1,blockable__$1,meta31470){
return (new cljs.core.async.t_cljs$core$async31469(f__$1,blockable__$1,meta31470));
});

}

return (new cljs.core.async.t_cljs$core$async31469(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__31494 = arguments.length;
switch (G__31494) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__31502 = arguments.length;
switch (G__31502) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__31506 = arguments.length;
switch (G__31506) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_31523 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_31523) : fn1.call(null,val_31523));
} else {
cljs.core.async.impl.dispatch.run(((function (val_31523,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_31523) : fn1.call(null,val_31523));
});})(val_31523,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__31552 = arguments.length;
switch (G__31552) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5455__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4408__auto___31619 = n;
var x_31620 = (0);
while(true){
if((x_31620 < n__4408__auto___31619)){
(a[x_31620] = (0));

var G__31621 = (x_31620 + (1));
x_31620 = G__31621;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__31625 = (i + (1));
i = G__31625;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31628 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31628 = (function (flag,meta31629){
this.flag = flag;
this.meta31629 = meta31629;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31628.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_31630,meta31629__$1){
var self__ = this;
var _31630__$1 = this;
return (new cljs.core.async.t_cljs$core$async31628(self__.flag,meta31629__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async31628.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_31630){
var self__ = this;
var _31630__$1 = this;
return self__.meta31629;
});})(flag))
;

cljs.core.async.t_cljs$core$async31628.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31628.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async31628.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31628.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31628.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta31629","meta31629",-961524432,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async31628.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31628.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31628";

cljs.core.async.t_cljs$core$async31628.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async31628");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31628.
 */
cljs.core.async.__GT_t_cljs$core$async31628 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31628(flag__$1,meta31629){
return (new cljs.core.async.t_cljs$core$async31628(flag__$1,meta31629));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async31628(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31640 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31640 = (function (flag,cb,meta31641){
this.flag = flag;
this.cb = cb;
this.meta31641 = meta31641;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31640.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31642,meta31641__$1){
var self__ = this;
var _31642__$1 = this;
return (new cljs.core.async.t_cljs$core$async31640(self__.flag,self__.cb,meta31641__$1));
});

cljs.core.async.t_cljs$core$async31640.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31642){
var self__ = this;
var _31642__$1 = this;
return self__.meta31641;
});

cljs.core.async.t_cljs$core$async31640.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31640.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async31640.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31640.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async31640.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta31641","meta31641",-1940793710,null)], null);
});

cljs.core.async.t_cljs$core$async31640.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31640.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31640";

cljs.core.async.t_cljs$core$async31640.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async31640");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31640.
 */
cljs.core.async.__GT_t_cljs$core$async31640 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31640(flag__$1,cb__$1,meta31641){
return (new cljs.core.async.t_cljs$core$async31640(flag__$1,cb__$1,meta31641));
});

}

return (new cljs.core.async.t_cljs$core$async31640(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31665_SHARP_){
var G__31670 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31665_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31670) : fret.call(null,G__31670));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31667_SHARP_){
var G__31672 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31667_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31672) : fret.call(null,G__31672));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__3949__auto__ = wport;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return port;
}
})()], null));
} else {
var G__31680 = (i + (1));
i = G__31680;
continue;
}
} else {
return null;
}
break;
}
})();
var or__3949__auto__ = ret;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__3938__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__3938__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4534__auto__ = [];
var len__4531__auto___31697 = arguments.length;
var i__4532__auto___31698 = (0);
while(true){
if((i__4532__auto___31698 < len__4531__auto___31697)){
args__4534__auto__.push((arguments[i__4532__auto___31698]));

var G__31700 = (i__4532__auto___31698 + (1));
i__4532__auto___31698 = G__31700;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31692){
var map__31693 = p__31692;
var map__31693__$1 = ((((!((map__31693 == null)))?(((((map__31693.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31693.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31693):map__31693);
var opts = map__31693__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31681){
var G__31682 = cljs.core.first(seq31681);
var seq31681__$1 = cljs.core.next(seq31681);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31682,seq31681__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__31706 = arguments.length;
switch (G__31706) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__31383__auto___31807 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto___31807){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto___31807){
return (function (state_31760){
var state_val_31762 = (state_31760[(1)]);
if((state_val_31762 === (7))){
var inst_31751 = (state_31760[(2)]);
var state_31760__$1 = state_31760;
var statearr_31770_31808 = state_31760__$1;
(statearr_31770_31808[(2)] = inst_31751);

(statearr_31770_31808[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31762 === (1))){
var state_31760__$1 = state_31760;
var statearr_31771_31809 = state_31760__$1;
(statearr_31771_31809[(2)] = null);

(statearr_31771_31809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31762 === (4))){
var inst_31732 = (state_31760[(7)]);
var inst_31732__$1 = (state_31760[(2)]);
var inst_31733 = (inst_31732__$1 == null);
var state_31760__$1 = (function (){var statearr_31772 = state_31760;
(statearr_31772[(7)] = inst_31732__$1);

return statearr_31772;
})();
if(cljs.core.truth_(inst_31733)){
var statearr_31773_31812 = state_31760__$1;
(statearr_31773_31812[(1)] = (5));

} else {
var statearr_31775_31813 = state_31760__$1;
(statearr_31775_31813[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31762 === (13))){
var state_31760__$1 = state_31760;
var statearr_31778_31814 = state_31760__$1;
(statearr_31778_31814[(2)] = null);

(statearr_31778_31814[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31762 === (6))){
var inst_31732 = (state_31760[(7)]);
var state_31760__$1 = state_31760;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31760__$1,(11),to,inst_31732);
} else {
if((state_val_31762 === (3))){
var inst_31754 = (state_31760[(2)]);
var state_31760__$1 = state_31760;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31760__$1,inst_31754);
} else {
if((state_val_31762 === (12))){
var state_31760__$1 = state_31760;
var statearr_31782_31816 = state_31760__$1;
(statearr_31782_31816[(2)] = null);

(statearr_31782_31816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31762 === (2))){
var state_31760__$1 = state_31760;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31760__$1,(4),from);
} else {
if((state_val_31762 === (11))){
var inst_31743 = (state_31760[(2)]);
var state_31760__$1 = state_31760;
if(cljs.core.truth_(inst_31743)){
var statearr_31789_31819 = state_31760__$1;
(statearr_31789_31819[(1)] = (12));

} else {
var statearr_31790_31821 = state_31760__$1;
(statearr_31790_31821[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31762 === (9))){
var state_31760__$1 = state_31760;
var statearr_31793_31822 = state_31760__$1;
(statearr_31793_31822[(2)] = null);

(statearr_31793_31822[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31762 === (5))){
var state_31760__$1 = state_31760;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31794_31824 = state_31760__$1;
(statearr_31794_31824[(1)] = (8));

} else {
var statearr_31795_31825 = state_31760__$1;
(statearr_31795_31825[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31762 === (14))){
var inst_31749 = (state_31760[(2)]);
var state_31760__$1 = state_31760;
var statearr_31797_31826 = state_31760__$1;
(statearr_31797_31826[(2)] = inst_31749);

(statearr_31797_31826[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31762 === (10))){
var inst_31740 = (state_31760[(2)]);
var state_31760__$1 = state_31760;
var statearr_31798_31827 = state_31760__$1;
(statearr_31798_31827[(2)] = inst_31740);

(statearr_31798_31827[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31762 === (8))){
var inst_31737 = cljs.core.async.close_BANG_(to);
var state_31760__$1 = state_31760;
var statearr_31799_31829 = state_31760__$1;
(statearr_31799_31829[(2)] = inst_31737);

(statearr_31799_31829[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31383__auto___31807))
;
return ((function (switch__31021__auto__,c__31383__auto___31807){
return (function() {
var cljs$core$async$state_machine__31022__auto__ = null;
var cljs$core$async$state_machine__31022__auto____0 = (function (){
var statearr_31801 = [null,null,null,null,null,null,null,null];
(statearr_31801[(0)] = cljs$core$async$state_machine__31022__auto__);

(statearr_31801[(1)] = (1));

return statearr_31801;
});
var cljs$core$async$state_machine__31022__auto____1 = (function (state_31760){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_31760);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e31802){if((e31802 instanceof Object)){
var ex__31025__auto__ = e31802;
var statearr_31803_31833 = state_31760;
(statearr_31803_31833[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31760);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31802;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31834 = state_31760;
state_31760 = G__31834;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$state_machine__31022__auto__ = function(state_31760){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31022__auto____1.call(this,state_31760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31022__auto____0;
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31022__auto____1;
return cljs$core$async$state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto___31807))
})();
var state__31385__auto__ = (function (){var statearr_31805 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_31805[(6)] = c__31383__auto___31807);

return statearr_31805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto___31807))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__31838){
var vec__31839 = p__31838;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31839,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31839,(1),null);
var job = vec__31839;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__31383__auto___32075 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto___32075,res,vec__31839,v,p,job,jobs,results){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto___32075,res,vec__31839,v,p,job,jobs,results){
return (function (state_31846){
var state_val_31847 = (state_31846[(1)]);
if((state_val_31847 === (1))){
var state_31846__$1 = state_31846;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31846__$1,(2),res,v);
} else {
if((state_val_31847 === (2))){
var inst_31843 = (state_31846[(2)]);
var inst_31844 = cljs.core.async.close_BANG_(res);
var state_31846__$1 = (function (){var statearr_31851 = state_31846;
(statearr_31851[(7)] = inst_31843);

return statearr_31851;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31846__$1,inst_31844);
} else {
return null;
}
}
});})(c__31383__auto___32075,res,vec__31839,v,p,job,jobs,results))
;
return ((function (switch__31021__auto__,c__31383__auto___32075,res,vec__31839,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____0 = (function (){
var statearr_31854 = [null,null,null,null,null,null,null,null];
(statearr_31854[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__);

(statearr_31854[(1)] = (1));

return statearr_31854;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____1 = (function (state_31846){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_31846);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e31855){if((e31855 instanceof Object)){
var ex__31025__auto__ = e31855;
var statearr_31856_32079 = state_31846;
(statearr_31856_32079[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31846);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31855;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32080 = state_31846;
state_31846 = G__32080;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__ = function(state_31846){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____1.call(this,state_31846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto___32075,res,vec__31839,v,p,job,jobs,results))
})();
var state__31385__auto__ = (function (){var statearr_31857 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_31857[(6)] = c__31383__auto___32075);

return statearr_31857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto___32075,res,vec__31839,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__31858){
var vec__31859 = p__31858;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31859,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31859,(1),null);
var job = vec__31859;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__4408__auto___32084 = n;
var __32085 = (0);
while(true){
if((__32085 < n__4408__auto___32084)){
var G__31865_32086 = type;
var G__31865_32087__$1 = (((G__31865_32086 instanceof cljs.core.Keyword))?G__31865_32086.fqn:null);
switch (G__31865_32087__$1) {
case "compute":
var c__31383__auto___32089 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__32085,c__31383__auto___32089,G__31865_32086,G__31865_32087__$1,n__4408__auto___32084,jobs,results,process,async){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (__32085,c__31383__auto___32089,G__31865_32086,G__31865_32087__$1,n__4408__auto___32084,jobs,results,process,async){
return (function (state_31881){
var state_val_31882 = (state_31881[(1)]);
if((state_val_31882 === (1))){
var state_31881__$1 = state_31881;
var statearr_31883_32094 = state_31881__$1;
(statearr_31883_32094[(2)] = null);

(statearr_31883_32094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31882 === (2))){
var state_31881__$1 = state_31881;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31881__$1,(4),jobs);
} else {
if((state_val_31882 === (3))){
var inst_31879 = (state_31881[(2)]);
var state_31881__$1 = state_31881;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31881__$1,inst_31879);
} else {
if((state_val_31882 === (4))){
var inst_31871 = (state_31881[(2)]);
var inst_31872 = process(inst_31871);
var state_31881__$1 = state_31881;
if(cljs.core.truth_(inst_31872)){
var statearr_31886_32097 = state_31881__$1;
(statearr_31886_32097[(1)] = (5));

} else {
var statearr_31887_32098 = state_31881__$1;
(statearr_31887_32098[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31882 === (5))){
var state_31881__$1 = state_31881;
var statearr_31888_32099 = state_31881__$1;
(statearr_31888_32099[(2)] = null);

(statearr_31888_32099[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31882 === (6))){
var state_31881__$1 = state_31881;
var statearr_31889_32100 = state_31881__$1;
(statearr_31889_32100[(2)] = null);

(statearr_31889_32100[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31882 === (7))){
var inst_31877 = (state_31881[(2)]);
var state_31881__$1 = state_31881;
var statearr_31890_32101 = state_31881__$1;
(statearr_31890_32101[(2)] = inst_31877);

(statearr_31890_32101[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__32085,c__31383__auto___32089,G__31865_32086,G__31865_32087__$1,n__4408__auto___32084,jobs,results,process,async))
;
return ((function (__32085,switch__31021__auto__,c__31383__auto___32089,G__31865_32086,G__31865_32087__$1,n__4408__auto___32084,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____0 = (function (){
var statearr_31891 = [null,null,null,null,null,null,null];
(statearr_31891[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__);

(statearr_31891[(1)] = (1));

return statearr_31891;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____1 = (function (state_31881){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_31881);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e31892){if((e31892 instanceof Object)){
var ex__31025__auto__ = e31892;
var statearr_31893_32106 = state_31881;
(statearr_31893_32106[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31881);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31892;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32107 = state_31881;
state_31881 = G__32107;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__ = function(state_31881){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____1.call(this,state_31881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__;
})()
;})(__32085,switch__31021__auto__,c__31383__auto___32089,G__31865_32086,G__31865_32087__$1,n__4408__auto___32084,jobs,results,process,async))
})();
var state__31385__auto__ = (function (){var statearr_31896 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_31896[(6)] = c__31383__auto___32089);

return statearr_31896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(__32085,c__31383__auto___32089,G__31865_32086,G__31865_32087__$1,n__4408__auto___32084,jobs,results,process,async))
);


break;
case "async":
var c__31383__auto___32108 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__32085,c__31383__auto___32108,G__31865_32086,G__31865_32087__$1,n__4408__auto___32084,jobs,results,process,async){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (__32085,c__31383__auto___32108,G__31865_32086,G__31865_32087__$1,n__4408__auto___32084,jobs,results,process,async){
return (function (state_31909){
var state_val_31910 = (state_31909[(1)]);
if((state_val_31910 === (1))){
var state_31909__$1 = state_31909;
var statearr_31912_32109 = state_31909__$1;
(statearr_31912_32109[(2)] = null);

(statearr_31912_32109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31910 === (2))){
var state_31909__$1 = state_31909;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31909__$1,(4),jobs);
} else {
if((state_val_31910 === (3))){
var inst_31907 = (state_31909[(2)]);
var state_31909__$1 = state_31909;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31909__$1,inst_31907);
} else {
if((state_val_31910 === (4))){
var inst_31899 = (state_31909[(2)]);
var inst_31900 = async(inst_31899);
var state_31909__$1 = state_31909;
if(cljs.core.truth_(inst_31900)){
var statearr_31913_32111 = state_31909__$1;
(statearr_31913_32111[(1)] = (5));

} else {
var statearr_31916_32112 = state_31909__$1;
(statearr_31916_32112[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31910 === (5))){
var state_31909__$1 = state_31909;
var statearr_31917_32113 = state_31909__$1;
(statearr_31917_32113[(2)] = null);

(statearr_31917_32113[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31910 === (6))){
var state_31909__$1 = state_31909;
var statearr_31918_32114 = state_31909__$1;
(statearr_31918_32114[(2)] = null);

(statearr_31918_32114[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31910 === (7))){
var inst_31905 = (state_31909[(2)]);
var state_31909__$1 = state_31909;
var statearr_31919_32115 = state_31909__$1;
(statearr_31919_32115[(2)] = inst_31905);

(statearr_31919_32115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__32085,c__31383__auto___32108,G__31865_32086,G__31865_32087__$1,n__4408__auto___32084,jobs,results,process,async))
;
return ((function (__32085,switch__31021__auto__,c__31383__auto___32108,G__31865_32086,G__31865_32087__$1,n__4408__auto___32084,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____0 = (function (){
var statearr_31920 = [null,null,null,null,null,null,null];
(statearr_31920[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__);

(statearr_31920[(1)] = (1));

return statearr_31920;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____1 = (function (state_31909){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_31909);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e31921){if((e31921 instanceof Object)){
var ex__31025__auto__ = e31921;
var statearr_31924_32117 = state_31909;
(statearr_31924_32117[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31909);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31921;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32118 = state_31909;
state_31909 = G__32118;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__ = function(state_31909){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____1.call(this,state_31909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__;
})()
;})(__32085,switch__31021__auto__,c__31383__auto___32108,G__31865_32086,G__31865_32087__$1,n__4408__auto___32084,jobs,results,process,async))
})();
var state__31385__auto__ = (function (){var statearr_31925 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_31925[(6)] = c__31383__auto___32108);

return statearr_31925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(__32085,c__31383__auto___32108,G__31865_32086,G__31865_32087__$1,n__4408__auto___32084,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31865_32087__$1)].join('')));

}

var G__32119 = (__32085 + (1));
__32085 = G__32119;
continue;
} else {
}
break;
}

var c__31383__auto___32123 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto___32123,jobs,results,process,async){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto___32123,jobs,results,process,async){
return (function (state_31956){
var state_val_31957 = (state_31956[(1)]);
if((state_val_31957 === (1))){
var state_31956__$1 = state_31956;
var statearr_31958_32124 = state_31956__$1;
(statearr_31958_32124[(2)] = null);

(statearr_31958_32124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (2))){
var state_31956__$1 = state_31956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31956__$1,(4),from);
} else {
if((state_val_31957 === (3))){
var inst_31952 = (state_31956[(2)]);
var state_31956__$1 = state_31956;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31956__$1,inst_31952);
} else {
if((state_val_31957 === (4))){
var inst_31929 = (state_31956[(7)]);
var inst_31929__$1 = (state_31956[(2)]);
var inst_31931 = (inst_31929__$1 == null);
var state_31956__$1 = (function (){var statearr_31962 = state_31956;
(statearr_31962[(7)] = inst_31929__$1);

return statearr_31962;
})();
if(cljs.core.truth_(inst_31931)){
var statearr_31963_32125 = state_31956__$1;
(statearr_31963_32125[(1)] = (5));

} else {
var statearr_31964_32126 = state_31956__$1;
(statearr_31964_32126[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (5))){
var inst_31933 = cljs.core.async.close_BANG_(jobs);
var state_31956__$1 = state_31956;
var statearr_31967_32127 = state_31956__$1;
(statearr_31967_32127[(2)] = inst_31933);

(statearr_31967_32127[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (6))){
var inst_31929 = (state_31956[(7)]);
var inst_31935 = (state_31956[(8)]);
var inst_31935__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_31938 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31941 = [inst_31929,inst_31935__$1];
var inst_31942 = (new cljs.core.PersistentVector(null,2,(5),inst_31938,inst_31941,null));
var state_31956__$1 = (function (){var statearr_31971 = state_31956;
(statearr_31971[(8)] = inst_31935__$1);

return statearr_31971;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31956__$1,(8),jobs,inst_31942);
} else {
if((state_val_31957 === (7))){
var inst_31950 = (state_31956[(2)]);
var state_31956__$1 = state_31956;
var statearr_31972_32128 = state_31956__$1;
(statearr_31972_32128[(2)] = inst_31950);

(statearr_31972_32128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (8))){
var inst_31935 = (state_31956[(8)]);
var inst_31944 = (state_31956[(2)]);
var state_31956__$1 = (function (){var statearr_31973 = state_31956;
(statearr_31973[(9)] = inst_31944);

return statearr_31973;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31956__$1,(9),results,inst_31935);
} else {
if((state_val_31957 === (9))){
var inst_31946 = (state_31956[(2)]);
var state_31956__$1 = (function (){var statearr_31976 = state_31956;
(statearr_31976[(10)] = inst_31946);

return statearr_31976;
})();
var statearr_31977_32129 = state_31956__$1;
(statearr_31977_32129[(2)] = null);

(statearr_31977_32129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__31383__auto___32123,jobs,results,process,async))
;
return ((function (switch__31021__auto__,c__31383__auto___32123,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____0 = (function (){
var statearr_31980 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31980[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__);

(statearr_31980[(1)] = (1));

return statearr_31980;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____1 = (function (state_31956){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_31956);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e31983){if((e31983 instanceof Object)){
var ex__31025__auto__ = e31983;
var statearr_31984_32130 = state_31956;
(statearr_31984_32130[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31956);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31983;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32131 = state_31956;
state_31956 = G__32131;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__ = function(state_31956){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____1.call(this,state_31956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto___32123,jobs,results,process,async))
})();
var state__31385__auto__ = (function (){var statearr_31987 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_31987[(6)] = c__31383__auto___32123);

return statearr_31987;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto___32123,jobs,results,process,async))
);


var c__31383__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto__,jobs,results,process,async){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto__,jobs,results,process,async){
return (function (state_32027){
var state_val_32028 = (state_32027[(1)]);
if((state_val_32028 === (7))){
var inst_32023 = (state_32027[(2)]);
var state_32027__$1 = state_32027;
var statearr_32032_32132 = state_32027__$1;
(statearr_32032_32132[(2)] = inst_32023);

(statearr_32032_32132[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (20))){
var state_32027__$1 = state_32027;
var statearr_32033_32134 = state_32027__$1;
(statearr_32033_32134[(2)] = null);

(statearr_32033_32134[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (1))){
var state_32027__$1 = state_32027;
var statearr_32034_32135 = state_32027__$1;
(statearr_32034_32135[(2)] = null);

(statearr_32034_32135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (4))){
var inst_31990 = (state_32027[(7)]);
var inst_31990__$1 = (state_32027[(2)]);
var inst_31991 = (inst_31990__$1 == null);
var state_32027__$1 = (function (){var statearr_32035 = state_32027;
(statearr_32035[(7)] = inst_31990__$1);

return statearr_32035;
})();
if(cljs.core.truth_(inst_31991)){
var statearr_32036_32136 = state_32027__$1;
(statearr_32036_32136[(1)] = (5));

} else {
var statearr_32037_32137 = state_32027__$1;
(statearr_32037_32137[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (15))){
var inst_32003 = (state_32027[(8)]);
var state_32027__$1 = state_32027;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32027__$1,(18),to,inst_32003);
} else {
if((state_val_32028 === (21))){
var inst_32018 = (state_32027[(2)]);
var state_32027__$1 = state_32027;
var statearr_32038_32138 = state_32027__$1;
(statearr_32038_32138[(2)] = inst_32018);

(statearr_32038_32138[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (13))){
var inst_32020 = (state_32027[(2)]);
var state_32027__$1 = (function (){var statearr_32039 = state_32027;
(statearr_32039[(9)] = inst_32020);

return statearr_32039;
})();
var statearr_32042_32139 = state_32027__$1;
(statearr_32042_32139[(2)] = null);

(statearr_32042_32139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (6))){
var inst_31990 = (state_32027[(7)]);
var state_32027__$1 = state_32027;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32027__$1,(11),inst_31990);
} else {
if((state_val_32028 === (17))){
var inst_32013 = (state_32027[(2)]);
var state_32027__$1 = state_32027;
if(cljs.core.truth_(inst_32013)){
var statearr_32043_32140 = state_32027__$1;
(statearr_32043_32140[(1)] = (19));

} else {
var statearr_32044_32141 = state_32027__$1;
(statearr_32044_32141[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (3))){
var inst_32025 = (state_32027[(2)]);
var state_32027__$1 = state_32027;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32027__$1,inst_32025);
} else {
if((state_val_32028 === (12))){
var inst_32000 = (state_32027[(10)]);
var state_32027__$1 = state_32027;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32027__$1,(14),inst_32000);
} else {
if((state_val_32028 === (2))){
var state_32027__$1 = state_32027;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32027__$1,(4),results);
} else {
if((state_val_32028 === (19))){
var state_32027__$1 = state_32027;
var statearr_32050_32142 = state_32027__$1;
(statearr_32050_32142[(2)] = null);

(statearr_32050_32142[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (11))){
var inst_32000 = (state_32027[(2)]);
var state_32027__$1 = (function (){var statearr_32053 = state_32027;
(statearr_32053[(10)] = inst_32000);

return statearr_32053;
})();
var statearr_32054_32143 = state_32027__$1;
(statearr_32054_32143[(2)] = null);

(statearr_32054_32143[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (9))){
var state_32027__$1 = state_32027;
var statearr_32055_32144 = state_32027__$1;
(statearr_32055_32144[(2)] = null);

(statearr_32055_32144[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (5))){
var state_32027__$1 = state_32027;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32056_32145 = state_32027__$1;
(statearr_32056_32145[(1)] = (8));

} else {
var statearr_32059_32146 = state_32027__$1;
(statearr_32059_32146[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (14))){
var inst_32003 = (state_32027[(8)]);
var inst_32007 = (state_32027[(11)]);
var inst_32003__$1 = (state_32027[(2)]);
var inst_32006 = (inst_32003__$1 == null);
var inst_32007__$1 = cljs.core.not(inst_32006);
var state_32027__$1 = (function (){var statearr_32060 = state_32027;
(statearr_32060[(8)] = inst_32003__$1);

(statearr_32060[(11)] = inst_32007__$1);

return statearr_32060;
})();
if(inst_32007__$1){
var statearr_32061_32147 = state_32027__$1;
(statearr_32061_32147[(1)] = (15));

} else {
var statearr_32062_32148 = state_32027__$1;
(statearr_32062_32148[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (16))){
var inst_32007 = (state_32027[(11)]);
var state_32027__$1 = state_32027;
var statearr_32063_32149 = state_32027__$1;
(statearr_32063_32149[(2)] = inst_32007);

(statearr_32063_32149[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (10))){
var inst_31997 = (state_32027[(2)]);
var state_32027__$1 = state_32027;
var statearr_32064_32150 = state_32027__$1;
(statearr_32064_32150[(2)] = inst_31997);

(statearr_32064_32150[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (18))){
var inst_32010 = (state_32027[(2)]);
var state_32027__$1 = state_32027;
var statearr_32065_32151 = state_32027__$1;
(statearr_32065_32151[(2)] = inst_32010);

(statearr_32065_32151[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32028 === (8))){
var inst_31994 = cljs.core.async.close_BANG_(to);
var state_32027__$1 = state_32027;
var statearr_32066_32152 = state_32027__$1;
(statearr_32066_32152[(2)] = inst_31994);

(statearr_32066_32152[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31383__auto__,jobs,results,process,async))
;
return ((function (switch__31021__auto__,c__31383__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____0 = (function (){
var statearr_32069 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32069[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__);

(statearr_32069[(1)] = (1));

return statearr_32069;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____1 = (function (state_32027){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_32027);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e32070){if((e32070 instanceof Object)){
var ex__31025__auto__ = e32070;
var statearr_32072_32153 = state_32027;
(statearr_32072_32153[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32027);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32070;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32154 = state_32027;
state_32027 = G__32154;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__ = function(state_32027){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____1.call(this,state_32027);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31022__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto__,jobs,results,process,async))
})();
var state__31385__auto__ = (function (){var statearr_32073 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_32073[(6)] = c__31383__auto__);

return statearr_32073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto__,jobs,results,process,async))
);

return c__31383__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__32156 = arguments.length;
switch (G__32156) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__32159 = arguments.length;
switch (G__32159) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__32162 = arguments.length;
switch (G__32162) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__31383__auto___32232 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto___32232,tc,fc){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto___32232,tc,fc){
return (function (state_32191){
var state_val_32192 = (state_32191[(1)]);
if((state_val_32192 === (7))){
var inst_32187 = (state_32191[(2)]);
var state_32191__$1 = state_32191;
var statearr_32195_32233 = state_32191__$1;
(statearr_32195_32233[(2)] = inst_32187);

(statearr_32195_32233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32192 === (1))){
var state_32191__$1 = state_32191;
var statearr_32196_32234 = state_32191__$1;
(statearr_32196_32234[(2)] = null);

(statearr_32196_32234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32192 === (4))){
var inst_32166 = (state_32191[(7)]);
var inst_32166__$1 = (state_32191[(2)]);
var inst_32168 = (inst_32166__$1 == null);
var state_32191__$1 = (function (){var statearr_32198 = state_32191;
(statearr_32198[(7)] = inst_32166__$1);

return statearr_32198;
})();
if(cljs.core.truth_(inst_32168)){
var statearr_32199_32235 = state_32191__$1;
(statearr_32199_32235[(1)] = (5));

} else {
var statearr_32200_32236 = state_32191__$1;
(statearr_32200_32236[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32192 === (13))){
var state_32191__$1 = state_32191;
var statearr_32201_32237 = state_32191__$1;
(statearr_32201_32237[(2)] = null);

(statearr_32201_32237[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32192 === (6))){
var inst_32166 = (state_32191[(7)]);
var inst_32174 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_32166) : p.call(null,inst_32166));
var state_32191__$1 = state_32191;
if(cljs.core.truth_(inst_32174)){
var statearr_32202_32238 = state_32191__$1;
(statearr_32202_32238[(1)] = (9));

} else {
var statearr_32203_32239 = state_32191__$1;
(statearr_32203_32239[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32192 === (3))){
var inst_32189 = (state_32191[(2)]);
var state_32191__$1 = state_32191;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32191__$1,inst_32189);
} else {
if((state_val_32192 === (12))){
var state_32191__$1 = state_32191;
var statearr_32208_32241 = state_32191__$1;
(statearr_32208_32241[(2)] = null);

(statearr_32208_32241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32192 === (2))){
var state_32191__$1 = state_32191;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32191__$1,(4),ch);
} else {
if((state_val_32192 === (11))){
var inst_32166 = (state_32191[(7)]);
var inst_32178 = (state_32191[(2)]);
var state_32191__$1 = state_32191;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32191__$1,(8),inst_32178,inst_32166);
} else {
if((state_val_32192 === (9))){
var state_32191__$1 = state_32191;
var statearr_32209_32242 = state_32191__$1;
(statearr_32209_32242[(2)] = tc);

(statearr_32209_32242[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32192 === (5))){
var inst_32171 = cljs.core.async.close_BANG_(tc);
var inst_32172 = cljs.core.async.close_BANG_(fc);
var state_32191__$1 = (function (){var statearr_32210 = state_32191;
(statearr_32210[(8)] = inst_32171);

return statearr_32210;
})();
var statearr_32211_32243 = state_32191__$1;
(statearr_32211_32243[(2)] = inst_32172);

(statearr_32211_32243[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32192 === (14))){
var inst_32185 = (state_32191[(2)]);
var state_32191__$1 = state_32191;
var statearr_32215_32244 = state_32191__$1;
(statearr_32215_32244[(2)] = inst_32185);

(statearr_32215_32244[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32192 === (10))){
var state_32191__$1 = state_32191;
var statearr_32216_32245 = state_32191__$1;
(statearr_32216_32245[(2)] = fc);

(statearr_32216_32245[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32192 === (8))){
var inst_32180 = (state_32191[(2)]);
var state_32191__$1 = state_32191;
if(cljs.core.truth_(inst_32180)){
var statearr_32217_32246 = state_32191__$1;
(statearr_32217_32246[(1)] = (12));

} else {
var statearr_32221_32247 = state_32191__$1;
(statearr_32221_32247[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31383__auto___32232,tc,fc))
;
return ((function (switch__31021__auto__,c__31383__auto___32232,tc,fc){
return (function() {
var cljs$core$async$state_machine__31022__auto__ = null;
var cljs$core$async$state_machine__31022__auto____0 = (function (){
var statearr_32222 = [null,null,null,null,null,null,null,null,null];
(statearr_32222[(0)] = cljs$core$async$state_machine__31022__auto__);

(statearr_32222[(1)] = (1));

return statearr_32222;
});
var cljs$core$async$state_machine__31022__auto____1 = (function (state_32191){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_32191);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e32223){if((e32223 instanceof Object)){
var ex__31025__auto__ = e32223;
var statearr_32228_32252 = state_32191;
(statearr_32228_32252[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32191);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32223;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32253 = state_32191;
state_32191 = G__32253;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$state_machine__31022__auto__ = function(state_32191){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31022__auto____1.call(this,state_32191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31022__auto____0;
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31022__auto____1;
return cljs$core$async$state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto___32232,tc,fc))
})();
var state__31385__auto__ = (function (){var statearr_32229 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_32229[(6)] = c__31383__auto___32232);

return statearr_32229;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto___32232,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__31383__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto__){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto__){
return (function (state_32282){
var state_val_32283 = (state_32282[(1)]);
if((state_val_32283 === (7))){
var inst_32278 = (state_32282[(2)]);
var state_32282__$1 = state_32282;
var statearr_32284_32302 = state_32282__$1;
(statearr_32284_32302[(2)] = inst_32278);

(statearr_32284_32302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32283 === (1))){
var inst_32262 = init;
var state_32282__$1 = (function (){var statearr_32285 = state_32282;
(statearr_32285[(7)] = inst_32262);

return statearr_32285;
})();
var statearr_32286_32303 = state_32282__$1;
(statearr_32286_32303[(2)] = null);

(statearr_32286_32303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32283 === (4))){
var inst_32265 = (state_32282[(8)]);
var inst_32265__$1 = (state_32282[(2)]);
var inst_32266 = (inst_32265__$1 == null);
var state_32282__$1 = (function (){var statearr_32287 = state_32282;
(statearr_32287[(8)] = inst_32265__$1);

return statearr_32287;
})();
if(cljs.core.truth_(inst_32266)){
var statearr_32288_32304 = state_32282__$1;
(statearr_32288_32304[(1)] = (5));

} else {
var statearr_32289_32305 = state_32282__$1;
(statearr_32289_32305[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32283 === (6))){
var inst_32262 = (state_32282[(7)]);
var inst_32269 = (state_32282[(9)]);
var inst_32265 = (state_32282[(8)]);
var inst_32269__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_32262,inst_32265) : f.call(null,inst_32262,inst_32265));
var inst_32270 = cljs.core.reduced_QMARK_(inst_32269__$1);
var state_32282__$1 = (function (){var statearr_32290 = state_32282;
(statearr_32290[(9)] = inst_32269__$1);

return statearr_32290;
})();
if(inst_32270){
var statearr_32291_32306 = state_32282__$1;
(statearr_32291_32306[(1)] = (8));

} else {
var statearr_32292_32307 = state_32282__$1;
(statearr_32292_32307[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32283 === (3))){
var inst_32280 = (state_32282[(2)]);
var state_32282__$1 = state_32282;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32282__$1,inst_32280);
} else {
if((state_val_32283 === (2))){
var state_32282__$1 = state_32282;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32282__$1,(4),ch);
} else {
if((state_val_32283 === (9))){
var inst_32269 = (state_32282[(9)]);
var inst_32262 = inst_32269;
var state_32282__$1 = (function (){var statearr_32293 = state_32282;
(statearr_32293[(7)] = inst_32262);

return statearr_32293;
})();
var statearr_32294_32308 = state_32282__$1;
(statearr_32294_32308[(2)] = null);

(statearr_32294_32308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32283 === (5))){
var inst_32262 = (state_32282[(7)]);
var state_32282__$1 = state_32282;
var statearr_32295_32309 = state_32282__$1;
(statearr_32295_32309[(2)] = inst_32262);

(statearr_32295_32309[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32283 === (10))){
var inst_32276 = (state_32282[(2)]);
var state_32282__$1 = state_32282;
var statearr_32296_32310 = state_32282__$1;
(statearr_32296_32310[(2)] = inst_32276);

(statearr_32296_32310[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32283 === (8))){
var inst_32269 = (state_32282[(9)]);
var inst_32272 = cljs.core.deref(inst_32269);
var state_32282__$1 = state_32282;
var statearr_32297_32311 = state_32282__$1;
(statearr_32297_32311[(2)] = inst_32272);

(statearr_32297_32311[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__31383__auto__))
;
return ((function (switch__31021__auto__,c__31383__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__31022__auto__ = null;
var cljs$core$async$reduce_$_state_machine__31022__auto____0 = (function (){
var statearr_32298 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32298[(0)] = cljs$core$async$reduce_$_state_machine__31022__auto__);

(statearr_32298[(1)] = (1));

return statearr_32298;
});
var cljs$core$async$reduce_$_state_machine__31022__auto____1 = (function (state_32282){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_32282);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e32299){if((e32299 instanceof Object)){
var ex__31025__auto__ = e32299;
var statearr_32300_32312 = state_32282;
(statearr_32300_32312[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32282);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32299;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32313 = state_32282;
state_32282 = G__32313;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__31022__auto__ = function(state_32282){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__31022__auto____1.call(this,state_32282);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__31022__auto____0;
cljs$core$async$reduce_$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__31022__auto____1;
return cljs$core$async$reduce_$_state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto__))
})();
var state__31385__auto__ = (function (){var statearr_32301 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_32301[(6)] = c__31383__auto__);

return statearr_32301;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto__))
);

return c__31383__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__31383__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto__,f__$1){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto__,f__$1){
return (function (state_32319){
var state_val_32320 = (state_32319[(1)]);
if((state_val_32320 === (1))){
var inst_32314 = cljs.core.async.reduce(f__$1,init,ch);
var state_32319__$1 = state_32319;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32319__$1,(2),inst_32314);
} else {
if((state_val_32320 === (2))){
var inst_32316 = (state_32319[(2)]);
var inst_32317 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_32316) : f__$1.call(null,inst_32316));
var state_32319__$1 = state_32319;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32319__$1,inst_32317);
} else {
return null;
}
}
});})(c__31383__auto__,f__$1))
;
return ((function (switch__31021__auto__,c__31383__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__31022__auto__ = null;
var cljs$core$async$transduce_$_state_machine__31022__auto____0 = (function (){
var statearr_32323 = [null,null,null,null,null,null,null];
(statearr_32323[(0)] = cljs$core$async$transduce_$_state_machine__31022__auto__);

(statearr_32323[(1)] = (1));

return statearr_32323;
});
var cljs$core$async$transduce_$_state_machine__31022__auto____1 = (function (state_32319){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_32319);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e32324){if((e32324 instanceof Object)){
var ex__31025__auto__ = e32324;
var statearr_32325_32331 = state_32319;
(statearr_32325_32331[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32319);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32324;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32332 = state_32319;
state_32319 = G__32332;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__31022__auto__ = function(state_32319){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__31022__auto____1.call(this,state_32319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__31022__auto____0;
cljs$core$async$transduce_$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__31022__auto____1;
return cljs$core$async$transduce_$_state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto__,f__$1))
})();
var state__31385__auto__ = (function (){var statearr_32328 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_32328[(6)] = c__31383__auto__);

return statearr_32328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto__,f__$1))
);

return c__31383__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__32335 = arguments.length;
switch (G__32335) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__31383__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto__){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto__){
return (function (state_32360){
var state_val_32361 = (state_32360[(1)]);
if((state_val_32361 === (7))){
var inst_32342 = (state_32360[(2)]);
var state_32360__$1 = state_32360;
var statearr_32363_32393 = state_32360__$1;
(statearr_32363_32393[(2)] = inst_32342);

(statearr_32363_32393[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32361 === (1))){
var inst_32336 = cljs.core.seq(coll);
var inst_32337 = inst_32336;
var state_32360__$1 = (function (){var statearr_32364 = state_32360;
(statearr_32364[(7)] = inst_32337);

return statearr_32364;
})();
var statearr_32366_32396 = state_32360__$1;
(statearr_32366_32396[(2)] = null);

(statearr_32366_32396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32361 === (4))){
var inst_32337 = (state_32360[(7)]);
var inst_32340 = cljs.core.first(inst_32337);
var state_32360__$1 = state_32360;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32360__$1,(7),ch,inst_32340);
} else {
if((state_val_32361 === (13))){
var inst_32354 = (state_32360[(2)]);
var state_32360__$1 = state_32360;
var statearr_32367_32400 = state_32360__$1;
(statearr_32367_32400[(2)] = inst_32354);

(statearr_32367_32400[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32361 === (6))){
var inst_32345 = (state_32360[(2)]);
var state_32360__$1 = state_32360;
if(cljs.core.truth_(inst_32345)){
var statearr_32368_32402 = state_32360__$1;
(statearr_32368_32402[(1)] = (8));

} else {
var statearr_32369_32403 = state_32360__$1;
(statearr_32369_32403[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32361 === (3))){
var inst_32358 = (state_32360[(2)]);
var state_32360__$1 = state_32360;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32360__$1,inst_32358);
} else {
if((state_val_32361 === (12))){
var state_32360__$1 = state_32360;
var statearr_32371_32404 = state_32360__$1;
(statearr_32371_32404[(2)] = null);

(statearr_32371_32404[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32361 === (2))){
var inst_32337 = (state_32360[(7)]);
var state_32360__$1 = state_32360;
if(cljs.core.truth_(inst_32337)){
var statearr_32373_32406 = state_32360__$1;
(statearr_32373_32406[(1)] = (4));

} else {
var statearr_32375_32407 = state_32360__$1;
(statearr_32375_32407[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32361 === (11))){
var inst_32351 = cljs.core.async.close_BANG_(ch);
var state_32360__$1 = state_32360;
var statearr_32377_32408 = state_32360__$1;
(statearr_32377_32408[(2)] = inst_32351);

(statearr_32377_32408[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32361 === (9))){
var state_32360__$1 = state_32360;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32378_32409 = state_32360__$1;
(statearr_32378_32409[(1)] = (11));

} else {
var statearr_32380_32410 = state_32360__$1;
(statearr_32380_32410[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32361 === (5))){
var inst_32337 = (state_32360[(7)]);
var state_32360__$1 = state_32360;
var statearr_32382_32411 = state_32360__$1;
(statearr_32382_32411[(2)] = inst_32337);

(statearr_32382_32411[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32361 === (10))){
var inst_32356 = (state_32360[(2)]);
var state_32360__$1 = state_32360;
var statearr_32383_32412 = state_32360__$1;
(statearr_32383_32412[(2)] = inst_32356);

(statearr_32383_32412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32361 === (8))){
var inst_32337 = (state_32360[(7)]);
var inst_32347 = cljs.core.next(inst_32337);
var inst_32337__$1 = inst_32347;
var state_32360__$1 = (function (){var statearr_32384 = state_32360;
(statearr_32384[(7)] = inst_32337__$1);

return statearr_32384;
})();
var statearr_32385_32413 = state_32360__$1;
(statearr_32385_32413[(2)] = null);

(statearr_32385_32413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31383__auto__))
;
return ((function (switch__31021__auto__,c__31383__auto__){
return (function() {
var cljs$core$async$state_machine__31022__auto__ = null;
var cljs$core$async$state_machine__31022__auto____0 = (function (){
var statearr_32386 = [null,null,null,null,null,null,null,null];
(statearr_32386[(0)] = cljs$core$async$state_machine__31022__auto__);

(statearr_32386[(1)] = (1));

return statearr_32386;
});
var cljs$core$async$state_machine__31022__auto____1 = (function (state_32360){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_32360);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e32387){if((e32387 instanceof Object)){
var ex__31025__auto__ = e32387;
var statearr_32388_32414 = state_32360;
(statearr_32388_32414[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32360);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32387;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32415 = state_32360;
state_32360 = G__32415;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$state_machine__31022__auto__ = function(state_32360){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31022__auto____1.call(this,state_32360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31022__auto____0;
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31022__auto____1;
return cljs$core$async$state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto__))
})();
var state__31385__auto__ = (function (){var statearr_32390 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_32390[(6)] = c__31383__auto__);

return statearr_32390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto__))
);

return c__31383__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if(((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto__.call(null,_));
} else {
var m__4244__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4244__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4244__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4244__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4244__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto__.call(null,m,ch));
} else {
var m__4244__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4244__auto__.call(null,m));
} else {
var m__4244__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__4244__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32430 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32430 = (function (ch,cs,meta32431){
this.ch = ch;
this.cs = cs;
this.meta32431 = meta32431;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32430.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_32432,meta32431__$1){
var self__ = this;
var _32432__$1 = this;
return (new cljs.core.async.t_cljs$core$async32430(self__.ch,self__.cs,meta32431__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async32430.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_32432){
var self__ = this;
var _32432__$1 = this;
return self__.meta32431;
});})(cs))
;

cljs.core.async.t_cljs$core$async32430.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32430.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async32430.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32430.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32430.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32430.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32430.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta32431","meta32431",1370769961,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async32430.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32430.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32430";

cljs.core.async.t_cljs$core$async32430.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async32430");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32430.
 */
cljs.core.async.__GT_t_cljs$core$async32430 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async32430(ch__$1,cs__$1,meta32431){
return (new cljs.core.async.t_cljs$core$async32430(ch__$1,cs__$1,meta32431));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async32430(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__31383__auto___32671 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto___32671,cs,m,dchan,dctr,done){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto___32671,cs,m,dchan,dctr,done){
return (function (state_32586){
var state_val_32587 = (state_32586[(1)]);
if((state_val_32587 === (7))){
var inst_32582 = (state_32586[(2)]);
var state_32586__$1 = state_32586;
var statearr_32588_32672 = state_32586__$1;
(statearr_32588_32672[(2)] = inst_32582);

(statearr_32588_32672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (20))){
var inst_32473 = (state_32586[(7)]);
var inst_32489 = cljs.core.first(inst_32473);
var inst_32490 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32489,(0),null);
var inst_32491 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32489,(1),null);
var state_32586__$1 = (function (){var statearr_32589 = state_32586;
(statearr_32589[(8)] = inst_32490);

return statearr_32589;
})();
if(cljs.core.truth_(inst_32491)){
var statearr_32590_32673 = state_32586__$1;
(statearr_32590_32673[(1)] = (22));

} else {
var statearr_32591_32674 = state_32586__$1;
(statearr_32591_32674[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (27))){
var inst_32527 = (state_32586[(9)]);
var inst_32442 = (state_32586[(10)]);
var inst_32534 = (state_32586[(11)]);
var inst_32529 = (state_32586[(12)]);
var inst_32534__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32527,inst_32529);
var inst_32535 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32534__$1,inst_32442,done);
var state_32586__$1 = (function (){var statearr_32592 = state_32586;
(statearr_32592[(11)] = inst_32534__$1);

return statearr_32592;
})();
if(cljs.core.truth_(inst_32535)){
var statearr_32593_32675 = state_32586__$1;
(statearr_32593_32675[(1)] = (30));

} else {
var statearr_32594_32676 = state_32586__$1;
(statearr_32594_32676[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (1))){
var state_32586__$1 = state_32586;
var statearr_32595_32677 = state_32586__$1;
(statearr_32595_32677[(2)] = null);

(statearr_32595_32677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (24))){
var inst_32473 = (state_32586[(7)]);
var inst_32500 = (state_32586[(2)]);
var inst_32505 = cljs.core.next(inst_32473);
var inst_32451 = inst_32505;
var inst_32452 = null;
var inst_32453 = (0);
var inst_32454 = (0);
var state_32586__$1 = (function (){var statearr_32596 = state_32586;
(statearr_32596[(13)] = inst_32454);

(statearr_32596[(14)] = inst_32453);

(statearr_32596[(15)] = inst_32500);

(statearr_32596[(16)] = inst_32451);

(statearr_32596[(17)] = inst_32452);

return statearr_32596;
})();
var statearr_32597_32678 = state_32586__$1;
(statearr_32597_32678[(2)] = null);

(statearr_32597_32678[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (39))){
var state_32586__$1 = state_32586;
var statearr_32601_32679 = state_32586__$1;
(statearr_32601_32679[(2)] = null);

(statearr_32601_32679[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (4))){
var inst_32442 = (state_32586[(10)]);
var inst_32442__$1 = (state_32586[(2)]);
var inst_32443 = (inst_32442__$1 == null);
var state_32586__$1 = (function (){var statearr_32602 = state_32586;
(statearr_32602[(10)] = inst_32442__$1);

return statearr_32602;
})();
if(cljs.core.truth_(inst_32443)){
var statearr_32603_32680 = state_32586__$1;
(statearr_32603_32680[(1)] = (5));

} else {
var statearr_32604_32681 = state_32586__$1;
(statearr_32604_32681[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (15))){
var inst_32454 = (state_32586[(13)]);
var inst_32453 = (state_32586[(14)]);
var inst_32451 = (state_32586[(16)]);
var inst_32452 = (state_32586[(17)]);
var inst_32469 = (state_32586[(2)]);
var inst_32470 = (inst_32454 + (1));
var tmp32598 = inst_32453;
var tmp32599 = inst_32451;
var tmp32600 = inst_32452;
var inst_32451__$1 = tmp32599;
var inst_32452__$1 = tmp32600;
var inst_32453__$1 = tmp32598;
var inst_32454__$1 = inst_32470;
var state_32586__$1 = (function (){var statearr_32605 = state_32586;
(statearr_32605[(13)] = inst_32454__$1);

(statearr_32605[(14)] = inst_32453__$1);

(statearr_32605[(16)] = inst_32451__$1);

(statearr_32605[(17)] = inst_32452__$1);

(statearr_32605[(18)] = inst_32469);

return statearr_32605;
})();
var statearr_32606_32682 = state_32586__$1;
(statearr_32606_32682[(2)] = null);

(statearr_32606_32682[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (21))){
var inst_32508 = (state_32586[(2)]);
var state_32586__$1 = state_32586;
var statearr_32610_32683 = state_32586__$1;
(statearr_32610_32683[(2)] = inst_32508);

(statearr_32610_32683[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (31))){
var inst_32534 = (state_32586[(11)]);
var inst_32538 = done(null);
var inst_32539 = cljs.core.async.untap_STAR_(m,inst_32534);
var state_32586__$1 = (function (){var statearr_32611 = state_32586;
(statearr_32611[(19)] = inst_32538);

return statearr_32611;
})();
var statearr_32612_32684 = state_32586__$1;
(statearr_32612_32684[(2)] = inst_32539);

(statearr_32612_32684[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (32))){
var inst_32526 = (state_32586[(20)]);
var inst_32527 = (state_32586[(9)]);
var inst_32528 = (state_32586[(21)]);
var inst_32529 = (state_32586[(12)]);
var inst_32541 = (state_32586[(2)]);
var inst_32542 = (inst_32529 + (1));
var tmp32607 = inst_32526;
var tmp32608 = inst_32527;
var tmp32609 = inst_32528;
var inst_32526__$1 = tmp32607;
var inst_32527__$1 = tmp32608;
var inst_32528__$1 = tmp32609;
var inst_32529__$1 = inst_32542;
var state_32586__$1 = (function (){var statearr_32613 = state_32586;
(statearr_32613[(20)] = inst_32526__$1);

(statearr_32613[(9)] = inst_32527__$1);

(statearr_32613[(21)] = inst_32528__$1);

(statearr_32613[(22)] = inst_32541);

(statearr_32613[(12)] = inst_32529__$1);

return statearr_32613;
})();
var statearr_32614_32685 = state_32586__$1;
(statearr_32614_32685[(2)] = null);

(statearr_32614_32685[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (40))){
var inst_32554 = (state_32586[(23)]);
var inst_32558 = done(null);
var inst_32559 = cljs.core.async.untap_STAR_(m,inst_32554);
var state_32586__$1 = (function (){var statearr_32615 = state_32586;
(statearr_32615[(24)] = inst_32558);

return statearr_32615;
})();
var statearr_32616_32686 = state_32586__$1;
(statearr_32616_32686[(2)] = inst_32559);

(statearr_32616_32686[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (33))){
var inst_32545 = (state_32586[(25)]);
var inst_32547 = cljs.core.chunked_seq_QMARK_(inst_32545);
var state_32586__$1 = state_32586;
if(inst_32547){
var statearr_32617_32687 = state_32586__$1;
(statearr_32617_32687[(1)] = (36));

} else {
var statearr_32618_32688 = state_32586__$1;
(statearr_32618_32688[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (13))){
var inst_32463 = (state_32586[(26)]);
var inst_32466 = cljs.core.async.close_BANG_(inst_32463);
var state_32586__$1 = state_32586;
var statearr_32619_32689 = state_32586__$1;
(statearr_32619_32689[(2)] = inst_32466);

(statearr_32619_32689[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (22))){
var inst_32490 = (state_32586[(8)]);
var inst_32497 = cljs.core.async.close_BANG_(inst_32490);
var state_32586__$1 = state_32586;
var statearr_32620_32690 = state_32586__$1;
(statearr_32620_32690[(2)] = inst_32497);

(statearr_32620_32690[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (36))){
var inst_32545 = (state_32586[(25)]);
var inst_32549 = cljs.core.chunk_first(inst_32545);
var inst_32550 = cljs.core.chunk_rest(inst_32545);
var inst_32551 = cljs.core.count(inst_32549);
var inst_32526 = inst_32550;
var inst_32527 = inst_32549;
var inst_32528 = inst_32551;
var inst_32529 = (0);
var state_32586__$1 = (function (){var statearr_32621 = state_32586;
(statearr_32621[(20)] = inst_32526);

(statearr_32621[(9)] = inst_32527);

(statearr_32621[(21)] = inst_32528);

(statearr_32621[(12)] = inst_32529);

return statearr_32621;
})();
var statearr_32622_32691 = state_32586__$1;
(statearr_32622_32691[(2)] = null);

(statearr_32622_32691[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (41))){
var inst_32545 = (state_32586[(25)]);
var inst_32561 = (state_32586[(2)]);
var inst_32562 = cljs.core.next(inst_32545);
var inst_32526 = inst_32562;
var inst_32527 = null;
var inst_32528 = (0);
var inst_32529 = (0);
var state_32586__$1 = (function (){var statearr_32623 = state_32586;
(statearr_32623[(20)] = inst_32526);

(statearr_32623[(9)] = inst_32527);

(statearr_32623[(21)] = inst_32528);

(statearr_32623[(27)] = inst_32561);

(statearr_32623[(12)] = inst_32529);

return statearr_32623;
})();
var statearr_32624_32692 = state_32586__$1;
(statearr_32624_32692[(2)] = null);

(statearr_32624_32692[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (43))){
var state_32586__$1 = state_32586;
var statearr_32625_32693 = state_32586__$1;
(statearr_32625_32693[(2)] = null);

(statearr_32625_32693[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (29))){
var inst_32570 = (state_32586[(2)]);
var state_32586__$1 = state_32586;
var statearr_32626_32694 = state_32586__$1;
(statearr_32626_32694[(2)] = inst_32570);

(statearr_32626_32694[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (44))){
var inst_32579 = (state_32586[(2)]);
var state_32586__$1 = (function (){var statearr_32627 = state_32586;
(statearr_32627[(28)] = inst_32579);

return statearr_32627;
})();
var statearr_32628_32695 = state_32586__$1;
(statearr_32628_32695[(2)] = null);

(statearr_32628_32695[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (6))){
var inst_32518 = (state_32586[(29)]);
var inst_32517 = cljs.core.deref(cs);
var inst_32518__$1 = cljs.core.keys(inst_32517);
var inst_32519 = cljs.core.count(inst_32518__$1);
var inst_32520 = cljs.core.reset_BANG_(dctr,inst_32519);
var inst_32525 = cljs.core.seq(inst_32518__$1);
var inst_32526 = inst_32525;
var inst_32527 = null;
var inst_32528 = (0);
var inst_32529 = (0);
var state_32586__$1 = (function (){var statearr_32629 = state_32586;
(statearr_32629[(20)] = inst_32526);

(statearr_32629[(9)] = inst_32527);

(statearr_32629[(29)] = inst_32518__$1);

(statearr_32629[(21)] = inst_32528);

(statearr_32629[(30)] = inst_32520);

(statearr_32629[(12)] = inst_32529);

return statearr_32629;
})();
var statearr_32630_32696 = state_32586__$1;
(statearr_32630_32696[(2)] = null);

(statearr_32630_32696[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (28))){
var inst_32526 = (state_32586[(20)]);
var inst_32545 = (state_32586[(25)]);
var inst_32545__$1 = cljs.core.seq(inst_32526);
var state_32586__$1 = (function (){var statearr_32631 = state_32586;
(statearr_32631[(25)] = inst_32545__$1);

return statearr_32631;
})();
if(inst_32545__$1){
var statearr_32632_32697 = state_32586__$1;
(statearr_32632_32697[(1)] = (33));

} else {
var statearr_32633_32698 = state_32586__$1;
(statearr_32633_32698[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (25))){
var inst_32528 = (state_32586[(21)]);
var inst_32529 = (state_32586[(12)]);
var inst_32531 = (inst_32529 < inst_32528);
var inst_32532 = inst_32531;
var state_32586__$1 = state_32586;
if(cljs.core.truth_(inst_32532)){
var statearr_32634_32699 = state_32586__$1;
(statearr_32634_32699[(1)] = (27));

} else {
var statearr_32635_32700 = state_32586__$1;
(statearr_32635_32700[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (34))){
var state_32586__$1 = state_32586;
var statearr_32636_32701 = state_32586__$1;
(statearr_32636_32701[(2)] = null);

(statearr_32636_32701[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (17))){
var state_32586__$1 = state_32586;
var statearr_32637_32702 = state_32586__$1;
(statearr_32637_32702[(2)] = null);

(statearr_32637_32702[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (3))){
var inst_32584 = (state_32586[(2)]);
var state_32586__$1 = state_32586;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32586__$1,inst_32584);
} else {
if((state_val_32587 === (12))){
var inst_32513 = (state_32586[(2)]);
var state_32586__$1 = state_32586;
var statearr_32638_32703 = state_32586__$1;
(statearr_32638_32703[(2)] = inst_32513);

(statearr_32638_32703[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (2))){
var state_32586__$1 = state_32586;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32586__$1,(4),ch);
} else {
if((state_val_32587 === (23))){
var state_32586__$1 = state_32586;
var statearr_32639_32704 = state_32586__$1;
(statearr_32639_32704[(2)] = null);

(statearr_32639_32704[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (35))){
var inst_32568 = (state_32586[(2)]);
var state_32586__$1 = state_32586;
var statearr_32640_32705 = state_32586__$1;
(statearr_32640_32705[(2)] = inst_32568);

(statearr_32640_32705[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (19))){
var inst_32473 = (state_32586[(7)]);
var inst_32477 = cljs.core.chunk_first(inst_32473);
var inst_32478 = cljs.core.chunk_rest(inst_32473);
var inst_32479 = cljs.core.count(inst_32477);
var inst_32451 = inst_32478;
var inst_32452 = inst_32477;
var inst_32453 = inst_32479;
var inst_32454 = (0);
var state_32586__$1 = (function (){var statearr_32641 = state_32586;
(statearr_32641[(13)] = inst_32454);

(statearr_32641[(14)] = inst_32453);

(statearr_32641[(16)] = inst_32451);

(statearr_32641[(17)] = inst_32452);

return statearr_32641;
})();
var statearr_32642_32706 = state_32586__$1;
(statearr_32642_32706[(2)] = null);

(statearr_32642_32706[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (11))){
var inst_32473 = (state_32586[(7)]);
var inst_32451 = (state_32586[(16)]);
var inst_32473__$1 = cljs.core.seq(inst_32451);
var state_32586__$1 = (function (){var statearr_32643 = state_32586;
(statearr_32643[(7)] = inst_32473__$1);

return statearr_32643;
})();
if(inst_32473__$1){
var statearr_32644_32707 = state_32586__$1;
(statearr_32644_32707[(1)] = (16));

} else {
var statearr_32645_32708 = state_32586__$1;
(statearr_32645_32708[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (9))){
var inst_32515 = (state_32586[(2)]);
var state_32586__$1 = state_32586;
var statearr_32646_32709 = state_32586__$1;
(statearr_32646_32709[(2)] = inst_32515);

(statearr_32646_32709[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (5))){
var inst_32449 = cljs.core.deref(cs);
var inst_32450 = cljs.core.seq(inst_32449);
var inst_32451 = inst_32450;
var inst_32452 = null;
var inst_32453 = (0);
var inst_32454 = (0);
var state_32586__$1 = (function (){var statearr_32647 = state_32586;
(statearr_32647[(13)] = inst_32454);

(statearr_32647[(14)] = inst_32453);

(statearr_32647[(16)] = inst_32451);

(statearr_32647[(17)] = inst_32452);

return statearr_32647;
})();
var statearr_32648_32710 = state_32586__$1;
(statearr_32648_32710[(2)] = null);

(statearr_32648_32710[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (14))){
var state_32586__$1 = state_32586;
var statearr_32649_32711 = state_32586__$1;
(statearr_32649_32711[(2)] = null);

(statearr_32649_32711[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (45))){
var inst_32576 = (state_32586[(2)]);
var state_32586__$1 = state_32586;
var statearr_32650_32712 = state_32586__$1;
(statearr_32650_32712[(2)] = inst_32576);

(statearr_32650_32712[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (26))){
var inst_32518 = (state_32586[(29)]);
var inst_32572 = (state_32586[(2)]);
var inst_32573 = cljs.core.seq(inst_32518);
var state_32586__$1 = (function (){var statearr_32651 = state_32586;
(statearr_32651[(31)] = inst_32572);

return statearr_32651;
})();
if(inst_32573){
var statearr_32652_32713 = state_32586__$1;
(statearr_32652_32713[(1)] = (42));

} else {
var statearr_32653_32714 = state_32586__$1;
(statearr_32653_32714[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (16))){
var inst_32473 = (state_32586[(7)]);
var inst_32475 = cljs.core.chunked_seq_QMARK_(inst_32473);
var state_32586__$1 = state_32586;
if(inst_32475){
var statearr_32654_32715 = state_32586__$1;
(statearr_32654_32715[(1)] = (19));

} else {
var statearr_32655_32716 = state_32586__$1;
(statearr_32655_32716[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (38))){
var inst_32565 = (state_32586[(2)]);
var state_32586__$1 = state_32586;
var statearr_32656_32717 = state_32586__$1;
(statearr_32656_32717[(2)] = inst_32565);

(statearr_32656_32717[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (30))){
var state_32586__$1 = state_32586;
var statearr_32657_32718 = state_32586__$1;
(statearr_32657_32718[(2)] = null);

(statearr_32657_32718[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (10))){
var inst_32454 = (state_32586[(13)]);
var inst_32452 = (state_32586[(17)]);
var inst_32462 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32452,inst_32454);
var inst_32463 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32462,(0),null);
var inst_32464 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32462,(1),null);
var state_32586__$1 = (function (){var statearr_32658 = state_32586;
(statearr_32658[(26)] = inst_32463);

return statearr_32658;
})();
if(cljs.core.truth_(inst_32464)){
var statearr_32659_32719 = state_32586__$1;
(statearr_32659_32719[(1)] = (13));

} else {
var statearr_32660_32720 = state_32586__$1;
(statearr_32660_32720[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (18))){
var inst_32511 = (state_32586[(2)]);
var state_32586__$1 = state_32586;
var statearr_32661_32721 = state_32586__$1;
(statearr_32661_32721[(2)] = inst_32511);

(statearr_32661_32721[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (42))){
var state_32586__$1 = state_32586;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32586__$1,(45),dchan);
} else {
if((state_val_32587 === (37))){
var inst_32442 = (state_32586[(10)]);
var inst_32545 = (state_32586[(25)]);
var inst_32554 = (state_32586[(23)]);
var inst_32554__$1 = cljs.core.first(inst_32545);
var inst_32555 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32554__$1,inst_32442,done);
var state_32586__$1 = (function (){var statearr_32662 = state_32586;
(statearr_32662[(23)] = inst_32554__$1);

return statearr_32662;
})();
if(cljs.core.truth_(inst_32555)){
var statearr_32663_32722 = state_32586__$1;
(statearr_32663_32722[(1)] = (39));

} else {
var statearr_32664_32723 = state_32586__$1;
(statearr_32664_32723[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32587 === (8))){
var inst_32454 = (state_32586[(13)]);
var inst_32453 = (state_32586[(14)]);
var inst_32456 = (inst_32454 < inst_32453);
var inst_32457 = inst_32456;
var state_32586__$1 = state_32586;
if(cljs.core.truth_(inst_32457)){
var statearr_32665_32724 = state_32586__$1;
(statearr_32665_32724[(1)] = (10));

} else {
var statearr_32666_32725 = state_32586__$1;
(statearr_32666_32725[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31383__auto___32671,cs,m,dchan,dctr,done))
;
return ((function (switch__31021__auto__,c__31383__auto___32671,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__31022__auto__ = null;
var cljs$core$async$mult_$_state_machine__31022__auto____0 = (function (){
var statearr_32667 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32667[(0)] = cljs$core$async$mult_$_state_machine__31022__auto__);

(statearr_32667[(1)] = (1));

return statearr_32667;
});
var cljs$core$async$mult_$_state_machine__31022__auto____1 = (function (state_32586){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_32586);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e32668){if((e32668 instanceof Object)){
var ex__31025__auto__ = e32668;
var statearr_32669_32726 = state_32586;
(statearr_32669_32726[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32586);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32668;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32727 = state_32586;
state_32586 = G__32727;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__31022__auto__ = function(state_32586){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__31022__auto____1.call(this,state_32586);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__31022__auto____0;
cljs$core$async$mult_$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__31022__auto____1;
return cljs$core$async$mult_$_state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto___32671,cs,m,dchan,dctr,done))
})();
var state__31385__auto__ = (function (){var statearr_32670 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_32670[(6)] = c__31383__auto___32671);

return statearr_32670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto___32671,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__32729 = arguments.length;
switch (G__32729) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto__.call(null,m,ch));
} else {
var m__4244__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto__.call(null,m,ch));
} else {
var m__4244__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4244__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4244__auto__.call(null,m));
} else {
var m__4244__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__4244__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4244__auto__.call(null,m,state_map));
} else {
var m__4244__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4244__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4244__auto__.call(null,m,mode));
} else {
var m__4244__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4244__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4534__auto__ = [];
var len__4531__auto___32741 = arguments.length;
var i__4532__auto___32742 = (0);
while(true){
if((i__4532__auto___32742 < len__4531__auto___32741)){
args__4534__auto__.push((arguments[i__4532__auto___32742]));

var G__32743 = (i__4532__auto___32742 + (1));
i__4532__auto___32742 = G__32743;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__32735){
var map__32736 = p__32735;
var map__32736__$1 = ((((!((map__32736 == null)))?(((((map__32736.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32736.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32736):map__32736);
var opts = map__32736__$1;
var statearr_32738_32744 = state;
(statearr_32738_32744[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts(((function (map__32736,map__32736__$1,opts){
return (function (val){
var statearr_32739_32745 = state;
(statearr_32739_32745[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__32736,map__32736__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_32740_32746 = state;
(statearr_32740_32746[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq32731){
var G__32732 = cljs.core.first(seq32731);
var seq32731__$1 = cljs.core.next(seq32731);
var G__32733 = cljs.core.first(seq32731__$1);
var seq32731__$2 = cljs.core.next(seq32731__$1);
var G__32734 = cljs.core.first(seq32731__$2);
var seq32731__$3 = cljs.core.next(seq32731__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32732,G__32733,G__32734,seq32731__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_(solos)))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32747 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32747 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta32748){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta32748 = meta32748;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32747.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32749,meta32748__$1){
var self__ = this;
var _32749__$1 = this;
return (new cljs.core.async.t_cljs$core$async32747(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta32748__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32747.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32749){
var self__ = this;
var _32749__$1 = this;
return self__.meta32748;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32747.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32747.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32747.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32747.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32747.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32747.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32747.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32747.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32747.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta32748","meta32748",-893142376,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32747.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32747.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32747";

cljs.core.async.t_cljs$core$async32747.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async32747");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32747.
 */
cljs.core.async.__GT_t_cljs$core$async32747 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async32747(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta32748){
return (new cljs.core.async.t_cljs$core$async32747(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta32748));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async32747(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__31383__auto___32911 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto___32911,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto___32911,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_32851){
var state_val_32852 = (state_32851[(1)]);
if((state_val_32852 === (7))){
var inst_32766 = (state_32851[(2)]);
var state_32851__$1 = state_32851;
var statearr_32853_32912 = state_32851__$1;
(statearr_32853_32912[(2)] = inst_32766);

(statearr_32853_32912[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (20))){
var inst_32778 = (state_32851[(7)]);
var state_32851__$1 = state_32851;
var statearr_32854_32913 = state_32851__$1;
(statearr_32854_32913[(2)] = inst_32778);

(statearr_32854_32913[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (27))){
var state_32851__$1 = state_32851;
var statearr_32855_32914 = state_32851__$1;
(statearr_32855_32914[(2)] = null);

(statearr_32855_32914[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (1))){
var inst_32753 = (state_32851[(8)]);
var inst_32753__$1 = calc_state();
var inst_32755 = (inst_32753__$1 == null);
var inst_32756 = cljs.core.not(inst_32755);
var state_32851__$1 = (function (){var statearr_32856 = state_32851;
(statearr_32856[(8)] = inst_32753__$1);

return statearr_32856;
})();
if(inst_32756){
var statearr_32857_32915 = state_32851__$1;
(statearr_32857_32915[(1)] = (2));

} else {
var statearr_32858_32916 = state_32851__$1;
(statearr_32858_32916[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (24))){
var inst_32802 = (state_32851[(9)]);
var inst_32811 = (state_32851[(10)]);
var inst_32825 = (state_32851[(11)]);
var inst_32825__$1 = (inst_32802.cljs$core$IFn$_invoke$arity$1 ? inst_32802.cljs$core$IFn$_invoke$arity$1(inst_32811) : inst_32802.call(null,inst_32811));
var state_32851__$1 = (function (){var statearr_32859 = state_32851;
(statearr_32859[(11)] = inst_32825__$1);

return statearr_32859;
})();
if(cljs.core.truth_(inst_32825__$1)){
var statearr_32860_32917 = state_32851__$1;
(statearr_32860_32917[(1)] = (29));

} else {
var statearr_32861_32918 = state_32851__$1;
(statearr_32861_32918[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (4))){
var inst_32769 = (state_32851[(2)]);
var state_32851__$1 = state_32851;
if(cljs.core.truth_(inst_32769)){
var statearr_32862_32919 = state_32851__$1;
(statearr_32862_32919[(1)] = (8));

} else {
var statearr_32863_32920 = state_32851__$1;
(statearr_32863_32920[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (15))){
var inst_32796 = (state_32851[(2)]);
var state_32851__$1 = state_32851;
if(cljs.core.truth_(inst_32796)){
var statearr_32864_32921 = state_32851__$1;
(statearr_32864_32921[(1)] = (19));

} else {
var statearr_32865_32922 = state_32851__$1;
(statearr_32865_32922[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (21))){
var inst_32801 = (state_32851[(12)]);
var inst_32801__$1 = (state_32851[(2)]);
var inst_32802 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32801__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32803 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32801__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32804 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32801__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_32851__$1 = (function (){var statearr_32866 = state_32851;
(statearr_32866[(13)] = inst_32803);

(statearr_32866[(9)] = inst_32802);

(statearr_32866[(12)] = inst_32801__$1);

return statearr_32866;
})();
return cljs.core.async.ioc_alts_BANG_(state_32851__$1,(22),inst_32804);
} else {
if((state_val_32852 === (31))){
var inst_32833 = (state_32851[(2)]);
var state_32851__$1 = state_32851;
if(cljs.core.truth_(inst_32833)){
var statearr_32867_32923 = state_32851__$1;
(statearr_32867_32923[(1)] = (32));

} else {
var statearr_32868_32924 = state_32851__$1;
(statearr_32868_32924[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (32))){
var inst_32810 = (state_32851[(14)]);
var state_32851__$1 = state_32851;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32851__$1,(35),out,inst_32810);
} else {
if((state_val_32852 === (33))){
var inst_32801 = (state_32851[(12)]);
var inst_32778 = inst_32801;
var state_32851__$1 = (function (){var statearr_32869 = state_32851;
(statearr_32869[(7)] = inst_32778);

return statearr_32869;
})();
var statearr_32870_32925 = state_32851__$1;
(statearr_32870_32925[(2)] = null);

(statearr_32870_32925[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (13))){
var inst_32778 = (state_32851[(7)]);
var inst_32785 = inst_32778.cljs$lang$protocol_mask$partition0$;
var inst_32786 = (inst_32785 & (64));
var inst_32787 = inst_32778.cljs$core$ISeq$;
var inst_32788 = (cljs.core.PROTOCOL_SENTINEL === inst_32787);
var inst_32789 = ((inst_32786) || (inst_32788));
var state_32851__$1 = state_32851;
if(cljs.core.truth_(inst_32789)){
var statearr_32871_32926 = state_32851__$1;
(statearr_32871_32926[(1)] = (16));

} else {
var statearr_32872_32927 = state_32851__$1;
(statearr_32872_32927[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (22))){
var inst_32811 = (state_32851[(10)]);
var inst_32810 = (state_32851[(14)]);
var inst_32809 = (state_32851[(2)]);
var inst_32810__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32809,(0),null);
var inst_32811__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32809,(1),null);
var inst_32812 = (inst_32810__$1 == null);
var inst_32813 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32811__$1,change);
var inst_32814 = ((inst_32812) || (inst_32813));
var state_32851__$1 = (function (){var statearr_32873 = state_32851;
(statearr_32873[(10)] = inst_32811__$1);

(statearr_32873[(14)] = inst_32810__$1);

return statearr_32873;
})();
if(cljs.core.truth_(inst_32814)){
var statearr_32874_32928 = state_32851__$1;
(statearr_32874_32928[(1)] = (23));

} else {
var statearr_32875_32929 = state_32851__$1;
(statearr_32875_32929[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (36))){
var inst_32801 = (state_32851[(12)]);
var inst_32778 = inst_32801;
var state_32851__$1 = (function (){var statearr_32876 = state_32851;
(statearr_32876[(7)] = inst_32778);

return statearr_32876;
})();
var statearr_32877_32930 = state_32851__$1;
(statearr_32877_32930[(2)] = null);

(statearr_32877_32930[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (29))){
var inst_32825 = (state_32851[(11)]);
var state_32851__$1 = state_32851;
var statearr_32878_32931 = state_32851__$1;
(statearr_32878_32931[(2)] = inst_32825);

(statearr_32878_32931[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (6))){
var state_32851__$1 = state_32851;
var statearr_32879_32932 = state_32851__$1;
(statearr_32879_32932[(2)] = false);

(statearr_32879_32932[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (28))){
var inst_32821 = (state_32851[(2)]);
var inst_32822 = calc_state();
var inst_32778 = inst_32822;
var state_32851__$1 = (function (){var statearr_32880 = state_32851;
(statearr_32880[(15)] = inst_32821);

(statearr_32880[(7)] = inst_32778);

return statearr_32880;
})();
var statearr_32881_32933 = state_32851__$1;
(statearr_32881_32933[(2)] = null);

(statearr_32881_32933[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (25))){
var inst_32847 = (state_32851[(2)]);
var state_32851__$1 = state_32851;
var statearr_32882_32934 = state_32851__$1;
(statearr_32882_32934[(2)] = inst_32847);

(statearr_32882_32934[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (34))){
var inst_32845 = (state_32851[(2)]);
var state_32851__$1 = state_32851;
var statearr_32883_32935 = state_32851__$1;
(statearr_32883_32935[(2)] = inst_32845);

(statearr_32883_32935[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (17))){
var state_32851__$1 = state_32851;
var statearr_32884_32936 = state_32851__$1;
(statearr_32884_32936[(2)] = false);

(statearr_32884_32936[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (3))){
var state_32851__$1 = state_32851;
var statearr_32885_32937 = state_32851__$1;
(statearr_32885_32937[(2)] = false);

(statearr_32885_32937[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (12))){
var inst_32849 = (state_32851[(2)]);
var state_32851__$1 = state_32851;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32851__$1,inst_32849);
} else {
if((state_val_32852 === (2))){
var inst_32753 = (state_32851[(8)]);
var inst_32758 = inst_32753.cljs$lang$protocol_mask$partition0$;
var inst_32759 = (inst_32758 & (64));
var inst_32760 = inst_32753.cljs$core$ISeq$;
var inst_32761 = (cljs.core.PROTOCOL_SENTINEL === inst_32760);
var inst_32762 = ((inst_32759) || (inst_32761));
var state_32851__$1 = state_32851;
if(cljs.core.truth_(inst_32762)){
var statearr_32886_32938 = state_32851__$1;
(statearr_32886_32938[(1)] = (5));

} else {
var statearr_32887_32939 = state_32851__$1;
(statearr_32887_32939[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (23))){
var inst_32810 = (state_32851[(14)]);
var inst_32816 = (inst_32810 == null);
var state_32851__$1 = state_32851;
if(cljs.core.truth_(inst_32816)){
var statearr_32888_32940 = state_32851__$1;
(statearr_32888_32940[(1)] = (26));

} else {
var statearr_32889_32941 = state_32851__$1;
(statearr_32889_32941[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (35))){
var inst_32836 = (state_32851[(2)]);
var state_32851__$1 = state_32851;
if(cljs.core.truth_(inst_32836)){
var statearr_32890_32942 = state_32851__$1;
(statearr_32890_32942[(1)] = (36));

} else {
var statearr_32891_32943 = state_32851__$1;
(statearr_32891_32943[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (19))){
var inst_32778 = (state_32851[(7)]);
var inst_32798 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32778);
var state_32851__$1 = state_32851;
var statearr_32892_32944 = state_32851__$1;
(statearr_32892_32944[(2)] = inst_32798);

(statearr_32892_32944[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (11))){
var inst_32778 = (state_32851[(7)]);
var inst_32782 = (inst_32778 == null);
var inst_32783 = cljs.core.not(inst_32782);
var state_32851__$1 = state_32851;
if(inst_32783){
var statearr_32893_32945 = state_32851__$1;
(statearr_32893_32945[(1)] = (13));

} else {
var statearr_32894_32946 = state_32851__$1;
(statearr_32894_32946[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (9))){
var inst_32753 = (state_32851[(8)]);
var state_32851__$1 = state_32851;
var statearr_32895_32947 = state_32851__$1;
(statearr_32895_32947[(2)] = inst_32753);

(statearr_32895_32947[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (5))){
var state_32851__$1 = state_32851;
var statearr_32896_32948 = state_32851__$1;
(statearr_32896_32948[(2)] = true);

(statearr_32896_32948[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (14))){
var state_32851__$1 = state_32851;
var statearr_32897_32949 = state_32851__$1;
(statearr_32897_32949[(2)] = false);

(statearr_32897_32949[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (26))){
var inst_32811 = (state_32851[(10)]);
var inst_32818 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_32811);
var state_32851__$1 = state_32851;
var statearr_32898_32950 = state_32851__$1;
(statearr_32898_32950[(2)] = inst_32818);

(statearr_32898_32950[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (16))){
var state_32851__$1 = state_32851;
var statearr_32899_32951 = state_32851__$1;
(statearr_32899_32951[(2)] = true);

(statearr_32899_32951[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (38))){
var inst_32841 = (state_32851[(2)]);
var state_32851__$1 = state_32851;
var statearr_32900_32952 = state_32851__$1;
(statearr_32900_32952[(2)] = inst_32841);

(statearr_32900_32952[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (30))){
var inst_32803 = (state_32851[(13)]);
var inst_32802 = (state_32851[(9)]);
var inst_32811 = (state_32851[(10)]);
var inst_32828 = cljs.core.empty_QMARK_(inst_32802);
var inst_32829 = (inst_32803.cljs$core$IFn$_invoke$arity$1 ? inst_32803.cljs$core$IFn$_invoke$arity$1(inst_32811) : inst_32803.call(null,inst_32811));
var inst_32830 = cljs.core.not(inst_32829);
var inst_32831 = ((inst_32828) && (inst_32830));
var state_32851__$1 = state_32851;
var statearr_32901_32953 = state_32851__$1;
(statearr_32901_32953[(2)] = inst_32831);

(statearr_32901_32953[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (10))){
var inst_32753 = (state_32851[(8)]);
var inst_32774 = (state_32851[(2)]);
var inst_32775 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32774,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32776 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32774,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32777 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32774,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_32778 = inst_32753;
var state_32851__$1 = (function (){var statearr_32902 = state_32851;
(statearr_32902[(16)] = inst_32777);

(statearr_32902[(7)] = inst_32778);

(statearr_32902[(17)] = inst_32776);

(statearr_32902[(18)] = inst_32775);

return statearr_32902;
})();
var statearr_32903_32954 = state_32851__$1;
(statearr_32903_32954[(2)] = null);

(statearr_32903_32954[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (18))){
var inst_32793 = (state_32851[(2)]);
var state_32851__$1 = state_32851;
var statearr_32904_32955 = state_32851__$1;
(statearr_32904_32955[(2)] = inst_32793);

(statearr_32904_32955[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (37))){
var state_32851__$1 = state_32851;
var statearr_32905_32956 = state_32851__$1;
(statearr_32905_32956[(2)] = null);

(statearr_32905_32956[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32852 === (8))){
var inst_32753 = (state_32851[(8)]);
var inst_32771 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32753);
var state_32851__$1 = state_32851;
var statearr_32906_32957 = state_32851__$1;
(statearr_32906_32957[(2)] = inst_32771);

(statearr_32906_32957[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31383__auto___32911,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__31021__auto__,c__31383__auto___32911,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__31022__auto__ = null;
var cljs$core$async$mix_$_state_machine__31022__auto____0 = (function (){
var statearr_32907 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32907[(0)] = cljs$core$async$mix_$_state_machine__31022__auto__);

(statearr_32907[(1)] = (1));

return statearr_32907;
});
var cljs$core$async$mix_$_state_machine__31022__auto____1 = (function (state_32851){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_32851);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e32908){if((e32908 instanceof Object)){
var ex__31025__auto__ = e32908;
var statearr_32909_32958 = state_32851;
(statearr_32909_32958[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32851);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32908;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32959 = state_32851;
state_32851 = G__32959;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__31022__auto__ = function(state_32851){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__31022__auto____1.call(this,state_32851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__31022__auto____0;
cljs$core$async$mix_$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__31022__auto____1;
return cljs$core$async$mix_$_state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto___32911,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__31385__auto__ = (function (){var statearr_32910 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_32910[(6)] = c__31383__auto___32911);

return statearr_32910;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto___32911,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4244__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4244__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4244__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4244__auto__.call(null,p,v,ch));
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4244__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__32961 = arguments.length;
switch (G__32961) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4244__auto__.call(null,p));
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__4244__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return (m__4244__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4244__auto__.call(null,p,v));
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return (m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4244__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__4244__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__32965 = arguments.length;
switch (G__32965) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__3949__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__3949__auto__,mults){
return (function (p1__32963_SHARP_){
if(cljs.core.truth_((p1__32963_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__32963_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__32963_SHARP_.call(null,topic)))){
return p1__32963_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32963_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__3949__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32966 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32966 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32967){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32967 = meta32967;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32966.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_32968,meta32967__$1){
var self__ = this;
var _32968__$1 = this;
return (new cljs.core.async.t_cljs$core$async32966(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32967__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32966.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_32968){
var self__ = this;
var _32968__$1 = this;
return self__.meta32967;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32966.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32966.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32966.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32966.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32966.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32966.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32966.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32966.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta32967","meta32967",1444993773,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32966.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32966.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32966";

cljs.core.async.t_cljs$core$async32966.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async32966");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32966.
 */
cljs.core.async.__GT_t_cljs$core$async32966 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async32966(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32967){
return (new cljs.core.async.t_cljs$core$async32966(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32967));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async32966(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__31383__auto___33086 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto___33086,mults,ensure_mult,p){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto___33086,mults,ensure_mult,p){
return (function (state_33040){
var state_val_33041 = (state_33040[(1)]);
if((state_val_33041 === (7))){
var inst_33036 = (state_33040[(2)]);
var state_33040__$1 = state_33040;
var statearr_33042_33087 = state_33040__$1;
(statearr_33042_33087[(2)] = inst_33036);

(statearr_33042_33087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (20))){
var state_33040__$1 = state_33040;
var statearr_33043_33088 = state_33040__$1;
(statearr_33043_33088[(2)] = null);

(statearr_33043_33088[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (1))){
var state_33040__$1 = state_33040;
var statearr_33044_33089 = state_33040__$1;
(statearr_33044_33089[(2)] = null);

(statearr_33044_33089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (24))){
var inst_33019 = (state_33040[(7)]);
var inst_33028 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_33019);
var state_33040__$1 = state_33040;
var statearr_33045_33090 = state_33040__$1;
(statearr_33045_33090[(2)] = inst_33028);

(statearr_33045_33090[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (4))){
var inst_32971 = (state_33040[(8)]);
var inst_32971__$1 = (state_33040[(2)]);
var inst_32972 = (inst_32971__$1 == null);
var state_33040__$1 = (function (){var statearr_33046 = state_33040;
(statearr_33046[(8)] = inst_32971__$1);

return statearr_33046;
})();
if(cljs.core.truth_(inst_32972)){
var statearr_33047_33091 = state_33040__$1;
(statearr_33047_33091[(1)] = (5));

} else {
var statearr_33048_33092 = state_33040__$1;
(statearr_33048_33092[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (15))){
var inst_33013 = (state_33040[(2)]);
var state_33040__$1 = state_33040;
var statearr_33049_33093 = state_33040__$1;
(statearr_33049_33093[(2)] = inst_33013);

(statearr_33049_33093[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (21))){
var inst_33033 = (state_33040[(2)]);
var state_33040__$1 = (function (){var statearr_33050 = state_33040;
(statearr_33050[(9)] = inst_33033);

return statearr_33050;
})();
var statearr_33051_33094 = state_33040__$1;
(statearr_33051_33094[(2)] = null);

(statearr_33051_33094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (13))){
var inst_32995 = (state_33040[(10)]);
var inst_32997 = cljs.core.chunked_seq_QMARK_(inst_32995);
var state_33040__$1 = state_33040;
if(inst_32997){
var statearr_33052_33095 = state_33040__$1;
(statearr_33052_33095[(1)] = (16));

} else {
var statearr_33053_33096 = state_33040__$1;
(statearr_33053_33096[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (22))){
var inst_33025 = (state_33040[(2)]);
var state_33040__$1 = state_33040;
if(cljs.core.truth_(inst_33025)){
var statearr_33054_33097 = state_33040__$1;
(statearr_33054_33097[(1)] = (23));

} else {
var statearr_33055_33098 = state_33040__$1;
(statearr_33055_33098[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (6))){
var inst_33019 = (state_33040[(7)]);
var inst_32971 = (state_33040[(8)]);
var inst_33021 = (state_33040[(11)]);
var inst_33019__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_32971) : topic_fn.call(null,inst_32971));
var inst_33020 = cljs.core.deref(mults);
var inst_33021__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33020,inst_33019__$1);
var state_33040__$1 = (function (){var statearr_33056 = state_33040;
(statearr_33056[(7)] = inst_33019__$1);

(statearr_33056[(11)] = inst_33021__$1);

return statearr_33056;
})();
if(cljs.core.truth_(inst_33021__$1)){
var statearr_33057_33099 = state_33040__$1;
(statearr_33057_33099[(1)] = (19));

} else {
var statearr_33058_33100 = state_33040__$1;
(statearr_33058_33100[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (25))){
var inst_33030 = (state_33040[(2)]);
var state_33040__$1 = state_33040;
var statearr_33059_33101 = state_33040__$1;
(statearr_33059_33101[(2)] = inst_33030);

(statearr_33059_33101[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (17))){
var inst_32995 = (state_33040[(10)]);
var inst_33004 = cljs.core.first(inst_32995);
var inst_33005 = cljs.core.async.muxch_STAR_(inst_33004);
var inst_33006 = cljs.core.async.close_BANG_(inst_33005);
var inst_33007 = cljs.core.next(inst_32995);
var inst_32981 = inst_33007;
var inst_32982 = null;
var inst_32983 = (0);
var inst_32984 = (0);
var state_33040__$1 = (function (){var statearr_33060 = state_33040;
(statearr_33060[(12)] = inst_33006);

(statearr_33060[(13)] = inst_32982);

(statearr_33060[(14)] = inst_32984);

(statearr_33060[(15)] = inst_32981);

(statearr_33060[(16)] = inst_32983);

return statearr_33060;
})();
var statearr_33061_33102 = state_33040__$1;
(statearr_33061_33102[(2)] = null);

(statearr_33061_33102[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (3))){
var inst_33038 = (state_33040[(2)]);
var state_33040__$1 = state_33040;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33040__$1,inst_33038);
} else {
if((state_val_33041 === (12))){
var inst_33015 = (state_33040[(2)]);
var state_33040__$1 = state_33040;
var statearr_33062_33103 = state_33040__$1;
(statearr_33062_33103[(2)] = inst_33015);

(statearr_33062_33103[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (2))){
var state_33040__$1 = state_33040;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33040__$1,(4),ch);
} else {
if((state_val_33041 === (23))){
var state_33040__$1 = state_33040;
var statearr_33063_33104 = state_33040__$1;
(statearr_33063_33104[(2)] = null);

(statearr_33063_33104[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (19))){
var inst_32971 = (state_33040[(8)]);
var inst_33021 = (state_33040[(11)]);
var inst_33023 = cljs.core.async.muxch_STAR_(inst_33021);
var state_33040__$1 = state_33040;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33040__$1,(22),inst_33023,inst_32971);
} else {
if((state_val_33041 === (11))){
var inst_32995 = (state_33040[(10)]);
var inst_32981 = (state_33040[(15)]);
var inst_32995__$1 = cljs.core.seq(inst_32981);
var state_33040__$1 = (function (){var statearr_33064 = state_33040;
(statearr_33064[(10)] = inst_32995__$1);

return statearr_33064;
})();
if(inst_32995__$1){
var statearr_33065_33105 = state_33040__$1;
(statearr_33065_33105[(1)] = (13));

} else {
var statearr_33066_33106 = state_33040__$1;
(statearr_33066_33106[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (9))){
var inst_33017 = (state_33040[(2)]);
var state_33040__$1 = state_33040;
var statearr_33067_33107 = state_33040__$1;
(statearr_33067_33107[(2)] = inst_33017);

(statearr_33067_33107[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (5))){
var inst_32978 = cljs.core.deref(mults);
var inst_32979 = cljs.core.vals(inst_32978);
var inst_32980 = cljs.core.seq(inst_32979);
var inst_32981 = inst_32980;
var inst_32982 = null;
var inst_32983 = (0);
var inst_32984 = (0);
var state_33040__$1 = (function (){var statearr_33068 = state_33040;
(statearr_33068[(13)] = inst_32982);

(statearr_33068[(14)] = inst_32984);

(statearr_33068[(15)] = inst_32981);

(statearr_33068[(16)] = inst_32983);

return statearr_33068;
})();
var statearr_33069_33108 = state_33040__$1;
(statearr_33069_33108[(2)] = null);

(statearr_33069_33108[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (14))){
var state_33040__$1 = state_33040;
var statearr_33073_33109 = state_33040__$1;
(statearr_33073_33109[(2)] = null);

(statearr_33073_33109[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (16))){
var inst_32995 = (state_33040[(10)]);
var inst_32999 = cljs.core.chunk_first(inst_32995);
var inst_33000 = cljs.core.chunk_rest(inst_32995);
var inst_33001 = cljs.core.count(inst_32999);
var inst_32981 = inst_33000;
var inst_32982 = inst_32999;
var inst_32983 = inst_33001;
var inst_32984 = (0);
var state_33040__$1 = (function (){var statearr_33074 = state_33040;
(statearr_33074[(13)] = inst_32982);

(statearr_33074[(14)] = inst_32984);

(statearr_33074[(15)] = inst_32981);

(statearr_33074[(16)] = inst_32983);

return statearr_33074;
})();
var statearr_33075_33110 = state_33040__$1;
(statearr_33075_33110[(2)] = null);

(statearr_33075_33110[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (10))){
var inst_32982 = (state_33040[(13)]);
var inst_32984 = (state_33040[(14)]);
var inst_32981 = (state_33040[(15)]);
var inst_32983 = (state_33040[(16)]);
var inst_32989 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32982,inst_32984);
var inst_32990 = cljs.core.async.muxch_STAR_(inst_32989);
var inst_32991 = cljs.core.async.close_BANG_(inst_32990);
var inst_32992 = (inst_32984 + (1));
var tmp33070 = inst_32982;
var tmp33071 = inst_32981;
var tmp33072 = inst_32983;
var inst_32981__$1 = tmp33071;
var inst_32982__$1 = tmp33070;
var inst_32983__$1 = tmp33072;
var inst_32984__$1 = inst_32992;
var state_33040__$1 = (function (){var statearr_33076 = state_33040;
(statearr_33076[(13)] = inst_32982__$1);

(statearr_33076[(17)] = inst_32991);

(statearr_33076[(14)] = inst_32984__$1);

(statearr_33076[(15)] = inst_32981__$1);

(statearr_33076[(16)] = inst_32983__$1);

return statearr_33076;
})();
var statearr_33077_33111 = state_33040__$1;
(statearr_33077_33111[(2)] = null);

(statearr_33077_33111[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (18))){
var inst_33010 = (state_33040[(2)]);
var state_33040__$1 = state_33040;
var statearr_33078_33112 = state_33040__$1;
(statearr_33078_33112[(2)] = inst_33010);

(statearr_33078_33112[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33041 === (8))){
var inst_32984 = (state_33040[(14)]);
var inst_32983 = (state_33040[(16)]);
var inst_32986 = (inst_32984 < inst_32983);
var inst_32987 = inst_32986;
var state_33040__$1 = state_33040;
if(cljs.core.truth_(inst_32987)){
var statearr_33079_33113 = state_33040__$1;
(statearr_33079_33113[(1)] = (10));

} else {
var statearr_33080_33114 = state_33040__$1;
(statearr_33080_33114[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31383__auto___33086,mults,ensure_mult,p))
;
return ((function (switch__31021__auto__,c__31383__auto___33086,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__31022__auto__ = null;
var cljs$core$async$state_machine__31022__auto____0 = (function (){
var statearr_33081 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33081[(0)] = cljs$core$async$state_machine__31022__auto__);

(statearr_33081[(1)] = (1));

return statearr_33081;
});
var cljs$core$async$state_machine__31022__auto____1 = (function (state_33040){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_33040);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e33082){if((e33082 instanceof Object)){
var ex__31025__auto__ = e33082;
var statearr_33083_33115 = state_33040;
(statearr_33083_33115[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33040);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33082;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33116 = state_33040;
state_33040 = G__33116;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$state_machine__31022__auto__ = function(state_33040){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31022__auto____1.call(this,state_33040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31022__auto____0;
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31022__auto____1;
return cljs$core$async$state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto___33086,mults,ensure_mult,p))
})();
var state__31385__auto__ = (function (){var statearr_33084 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_33084[(6)] = c__31383__auto___33086);

return statearr_33084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto___33086,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__33118 = arguments.length;
switch (G__33118) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__33121 = arguments.length;
switch (G__33121) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__33124 = arguments.length;
switch (G__33124) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__31383__auto___33191 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto___33191,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto___33191,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_33163){
var state_val_33164 = (state_33163[(1)]);
if((state_val_33164 === (7))){
var state_33163__$1 = state_33163;
var statearr_33165_33192 = state_33163__$1;
(statearr_33165_33192[(2)] = null);

(statearr_33165_33192[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33164 === (1))){
var state_33163__$1 = state_33163;
var statearr_33166_33193 = state_33163__$1;
(statearr_33166_33193[(2)] = null);

(statearr_33166_33193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33164 === (4))){
var inst_33127 = (state_33163[(7)]);
var inst_33129 = (inst_33127 < cnt);
var state_33163__$1 = state_33163;
if(cljs.core.truth_(inst_33129)){
var statearr_33167_33194 = state_33163__$1;
(statearr_33167_33194[(1)] = (6));

} else {
var statearr_33168_33195 = state_33163__$1;
(statearr_33168_33195[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33164 === (15))){
var inst_33159 = (state_33163[(2)]);
var state_33163__$1 = state_33163;
var statearr_33169_33196 = state_33163__$1;
(statearr_33169_33196[(2)] = inst_33159);

(statearr_33169_33196[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33164 === (13))){
var inst_33152 = cljs.core.async.close_BANG_(out);
var state_33163__$1 = state_33163;
var statearr_33170_33197 = state_33163__$1;
(statearr_33170_33197[(2)] = inst_33152);

(statearr_33170_33197[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33164 === (6))){
var state_33163__$1 = state_33163;
var statearr_33171_33198 = state_33163__$1;
(statearr_33171_33198[(2)] = null);

(statearr_33171_33198[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33164 === (3))){
var inst_33161 = (state_33163[(2)]);
var state_33163__$1 = state_33163;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33163__$1,inst_33161);
} else {
if((state_val_33164 === (12))){
var inst_33149 = (state_33163[(8)]);
var inst_33149__$1 = (state_33163[(2)]);
var inst_33150 = cljs.core.some(cljs.core.nil_QMARK_,inst_33149__$1);
var state_33163__$1 = (function (){var statearr_33172 = state_33163;
(statearr_33172[(8)] = inst_33149__$1);

return statearr_33172;
})();
if(cljs.core.truth_(inst_33150)){
var statearr_33173_33199 = state_33163__$1;
(statearr_33173_33199[(1)] = (13));

} else {
var statearr_33174_33200 = state_33163__$1;
(statearr_33174_33200[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33164 === (2))){
var inst_33126 = cljs.core.reset_BANG_(dctr,cnt);
var inst_33127 = (0);
var state_33163__$1 = (function (){var statearr_33175 = state_33163;
(statearr_33175[(9)] = inst_33126);

(statearr_33175[(7)] = inst_33127);

return statearr_33175;
})();
var statearr_33176_33201 = state_33163__$1;
(statearr_33176_33201[(2)] = null);

(statearr_33176_33201[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33164 === (11))){
var inst_33127 = (state_33163[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_33163,(10),Object,null,(9));
var inst_33136 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_33127) : chs__$1.call(null,inst_33127));
var inst_33137 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_33127) : done.call(null,inst_33127));
var inst_33138 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33136,inst_33137);
var state_33163__$1 = state_33163;
var statearr_33177_33202 = state_33163__$1;
(statearr_33177_33202[(2)] = inst_33138);


cljs.core.async.impl.ioc_helpers.process_exception(state_33163__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33164 === (9))){
var inst_33127 = (state_33163[(7)]);
var inst_33140 = (state_33163[(2)]);
var inst_33141 = (inst_33127 + (1));
var inst_33127__$1 = inst_33141;
var state_33163__$1 = (function (){var statearr_33178 = state_33163;
(statearr_33178[(10)] = inst_33140);

(statearr_33178[(7)] = inst_33127__$1);

return statearr_33178;
})();
var statearr_33179_33203 = state_33163__$1;
(statearr_33179_33203[(2)] = null);

(statearr_33179_33203[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33164 === (5))){
var inst_33147 = (state_33163[(2)]);
var state_33163__$1 = (function (){var statearr_33180 = state_33163;
(statearr_33180[(11)] = inst_33147);

return statearr_33180;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33163__$1,(12),dchan);
} else {
if((state_val_33164 === (14))){
var inst_33149 = (state_33163[(8)]);
var inst_33154 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_33149);
var state_33163__$1 = state_33163;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33163__$1,(16),out,inst_33154);
} else {
if((state_val_33164 === (16))){
var inst_33156 = (state_33163[(2)]);
var state_33163__$1 = (function (){var statearr_33181 = state_33163;
(statearr_33181[(12)] = inst_33156);

return statearr_33181;
})();
var statearr_33182_33204 = state_33163__$1;
(statearr_33182_33204[(2)] = null);

(statearr_33182_33204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33164 === (10))){
var inst_33131 = (state_33163[(2)]);
var inst_33132 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_33163__$1 = (function (){var statearr_33183 = state_33163;
(statearr_33183[(13)] = inst_33131);

return statearr_33183;
})();
var statearr_33184_33205 = state_33163__$1;
(statearr_33184_33205[(2)] = inst_33132);


cljs.core.async.impl.ioc_helpers.process_exception(state_33163__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33164 === (8))){
var inst_33145 = (state_33163[(2)]);
var state_33163__$1 = state_33163;
var statearr_33185_33206 = state_33163__$1;
(statearr_33185_33206[(2)] = inst_33145);

(statearr_33185_33206[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31383__auto___33191,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__31021__auto__,c__31383__auto___33191,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__31022__auto__ = null;
var cljs$core$async$state_machine__31022__auto____0 = (function (){
var statearr_33186 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33186[(0)] = cljs$core$async$state_machine__31022__auto__);

(statearr_33186[(1)] = (1));

return statearr_33186;
});
var cljs$core$async$state_machine__31022__auto____1 = (function (state_33163){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_33163);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e33187){if((e33187 instanceof Object)){
var ex__31025__auto__ = e33187;
var statearr_33188_33207 = state_33163;
(statearr_33188_33207[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33163);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33187;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33208 = state_33163;
state_33163 = G__33208;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$state_machine__31022__auto__ = function(state_33163){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31022__auto____1.call(this,state_33163);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31022__auto____0;
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31022__auto____1;
return cljs$core$async$state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto___33191,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__31385__auto__ = (function (){var statearr_33189 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_33189[(6)] = c__31383__auto___33191);

return statearr_33189;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto___33191,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__33211 = arguments.length;
switch (G__33211) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31383__auto___33265 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto___33265,out){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto___33265,out){
return (function (state_33243){
var state_val_33244 = (state_33243[(1)]);
if((state_val_33244 === (7))){
var inst_33223 = (state_33243[(7)]);
var inst_33222 = (state_33243[(8)]);
var inst_33222__$1 = (state_33243[(2)]);
var inst_33223__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33222__$1,(0),null);
var inst_33224 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33222__$1,(1),null);
var inst_33225 = (inst_33223__$1 == null);
var state_33243__$1 = (function (){var statearr_33245 = state_33243;
(statearr_33245[(9)] = inst_33224);

(statearr_33245[(7)] = inst_33223__$1);

(statearr_33245[(8)] = inst_33222__$1);

return statearr_33245;
})();
if(cljs.core.truth_(inst_33225)){
var statearr_33246_33266 = state_33243__$1;
(statearr_33246_33266[(1)] = (8));

} else {
var statearr_33247_33267 = state_33243__$1;
(statearr_33247_33267[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33244 === (1))){
var inst_33212 = cljs.core.vec(chs);
var inst_33213 = inst_33212;
var state_33243__$1 = (function (){var statearr_33248 = state_33243;
(statearr_33248[(10)] = inst_33213);

return statearr_33248;
})();
var statearr_33249_33268 = state_33243__$1;
(statearr_33249_33268[(2)] = null);

(statearr_33249_33268[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33244 === (4))){
var inst_33213 = (state_33243[(10)]);
var state_33243__$1 = state_33243;
return cljs.core.async.ioc_alts_BANG_(state_33243__$1,(7),inst_33213);
} else {
if((state_val_33244 === (6))){
var inst_33239 = (state_33243[(2)]);
var state_33243__$1 = state_33243;
var statearr_33250_33269 = state_33243__$1;
(statearr_33250_33269[(2)] = inst_33239);

(statearr_33250_33269[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33244 === (3))){
var inst_33241 = (state_33243[(2)]);
var state_33243__$1 = state_33243;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33243__$1,inst_33241);
} else {
if((state_val_33244 === (2))){
var inst_33213 = (state_33243[(10)]);
var inst_33215 = cljs.core.count(inst_33213);
var inst_33216 = (inst_33215 > (0));
var state_33243__$1 = state_33243;
if(cljs.core.truth_(inst_33216)){
var statearr_33252_33270 = state_33243__$1;
(statearr_33252_33270[(1)] = (4));

} else {
var statearr_33253_33271 = state_33243__$1;
(statearr_33253_33271[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33244 === (11))){
var inst_33213 = (state_33243[(10)]);
var inst_33232 = (state_33243[(2)]);
var tmp33251 = inst_33213;
var inst_33213__$1 = tmp33251;
var state_33243__$1 = (function (){var statearr_33254 = state_33243;
(statearr_33254[(10)] = inst_33213__$1);

(statearr_33254[(11)] = inst_33232);

return statearr_33254;
})();
var statearr_33255_33272 = state_33243__$1;
(statearr_33255_33272[(2)] = null);

(statearr_33255_33272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33244 === (9))){
var inst_33223 = (state_33243[(7)]);
var state_33243__$1 = state_33243;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33243__$1,(11),out,inst_33223);
} else {
if((state_val_33244 === (5))){
var inst_33237 = cljs.core.async.close_BANG_(out);
var state_33243__$1 = state_33243;
var statearr_33256_33273 = state_33243__$1;
(statearr_33256_33273[(2)] = inst_33237);

(statearr_33256_33273[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33244 === (10))){
var inst_33235 = (state_33243[(2)]);
var state_33243__$1 = state_33243;
var statearr_33257_33274 = state_33243__$1;
(statearr_33257_33274[(2)] = inst_33235);

(statearr_33257_33274[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33244 === (8))){
var inst_33224 = (state_33243[(9)]);
var inst_33223 = (state_33243[(7)]);
var inst_33213 = (state_33243[(10)]);
var inst_33222 = (state_33243[(8)]);
var inst_33227 = (function (){var cs = inst_33213;
var vec__33218 = inst_33222;
var v = inst_33223;
var c = inst_33224;
return ((function (cs,vec__33218,v,c,inst_33224,inst_33223,inst_33213,inst_33222,state_val_33244,c__31383__auto___33265,out){
return (function (p1__33209_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__33209_SHARP_);
});
;})(cs,vec__33218,v,c,inst_33224,inst_33223,inst_33213,inst_33222,state_val_33244,c__31383__auto___33265,out))
})();
var inst_33228 = cljs.core.filterv(inst_33227,inst_33213);
var inst_33213__$1 = inst_33228;
var state_33243__$1 = (function (){var statearr_33258 = state_33243;
(statearr_33258[(10)] = inst_33213__$1);

return statearr_33258;
})();
var statearr_33259_33275 = state_33243__$1;
(statearr_33259_33275[(2)] = null);

(statearr_33259_33275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31383__auto___33265,out))
;
return ((function (switch__31021__auto__,c__31383__auto___33265,out){
return (function() {
var cljs$core$async$state_machine__31022__auto__ = null;
var cljs$core$async$state_machine__31022__auto____0 = (function (){
var statearr_33260 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33260[(0)] = cljs$core$async$state_machine__31022__auto__);

(statearr_33260[(1)] = (1));

return statearr_33260;
});
var cljs$core$async$state_machine__31022__auto____1 = (function (state_33243){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_33243);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e33261){if((e33261 instanceof Object)){
var ex__31025__auto__ = e33261;
var statearr_33262_33276 = state_33243;
(statearr_33262_33276[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33243);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33261;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33277 = state_33243;
state_33243 = G__33277;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$state_machine__31022__auto__ = function(state_33243){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31022__auto____1.call(this,state_33243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31022__auto____0;
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31022__auto____1;
return cljs$core$async$state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto___33265,out))
})();
var state__31385__auto__ = (function (){var statearr_33263 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_33263[(6)] = c__31383__auto___33265);

return statearr_33263;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto___33265,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__33279 = arguments.length;
switch (G__33279) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31383__auto___33324 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto___33324,out){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto___33324,out){
return (function (state_33303){
var state_val_33304 = (state_33303[(1)]);
if((state_val_33304 === (7))){
var inst_33285 = (state_33303[(7)]);
var inst_33285__$1 = (state_33303[(2)]);
var inst_33286 = (inst_33285__$1 == null);
var inst_33287 = cljs.core.not(inst_33286);
var state_33303__$1 = (function (){var statearr_33305 = state_33303;
(statearr_33305[(7)] = inst_33285__$1);

return statearr_33305;
})();
if(inst_33287){
var statearr_33306_33325 = state_33303__$1;
(statearr_33306_33325[(1)] = (8));

} else {
var statearr_33307_33326 = state_33303__$1;
(statearr_33307_33326[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33304 === (1))){
var inst_33280 = (0);
var state_33303__$1 = (function (){var statearr_33308 = state_33303;
(statearr_33308[(8)] = inst_33280);

return statearr_33308;
})();
var statearr_33309_33327 = state_33303__$1;
(statearr_33309_33327[(2)] = null);

(statearr_33309_33327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33304 === (4))){
var state_33303__$1 = state_33303;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33303__$1,(7),ch);
} else {
if((state_val_33304 === (6))){
var inst_33298 = (state_33303[(2)]);
var state_33303__$1 = state_33303;
var statearr_33310_33328 = state_33303__$1;
(statearr_33310_33328[(2)] = inst_33298);

(statearr_33310_33328[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33304 === (3))){
var inst_33300 = (state_33303[(2)]);
var inst_33301 = cljs.core.async.close_BANG_(out);
var state_33303__$1 = (function (){var statearr_33311 = state_33303;
(statearr_33311[(9)] = inst_33300);

return statearr_33311;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33303__$1,inst_33301);
} else {
if((state_val_33304 === (2))){
var inst_33280 = (state_33303[(8)]);
var inst_33282 = (inst_33280 < n);
var state_33303__$1 = state_33303;
if(cljs.core.truth_(inst_33282)){
var statearr_33312_33329 = state_33303__$1;
(statearr_33312_33329[(1)] = (4));

} else {
var statearr_33313_33330 = state_33303__$1;
(statearr_33313_33330[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33304 === (11))){
var inst_33280 = (state_33303[(8)]);
var inst_33290 = (state_33303[(2)]);
var inst_33291 = (inst_33280 + (1));
var inst_33280__$1 = inst_33291;
var state_33303__$1 = (function (){var statearr_33314 = state_33303;
(statearr_33314[(8)] = inst_33280__$1);

(statearr_33314[(10)] = inst_33290);

return statearr_33314;
})();
var statearr_33315_33331 = state_33303__$1;
(statearr_33315_33331[(2)] = null);

(statearr_33315_33331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33304 === (9))){
var state_33303__$1 = state_33303;
var statearr_33316_33332 = state_33303__$1;
(statearr_33316_33332[(2)] = null);

(statearr_33316_33332[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33304 === (5))){
var state_33303__$1 = state_33303;
var statearr_33317_33333 = state_33303__$1;
(statearr_33317_33333[(2)] = null);

(statearr_33317_33333[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33304 === (10))){
var inst_33295 = (state_33303[(2)]);
var state_33303__$1 = state_33303;
var statearr_33318_33334 = state_33303__$1;
(statearr_33318_33334[(2)] = inst_33295);

(statearr_33318_33334[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33304 === (8))){
var inst_33285 = (state_33303[(7)]);
var state_33303__$1 = state_33303;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33303__$1,(11),out,inst_33285);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31383__auto___33324,out))
;
return ((function (switch__31021__auto__,c__31383__auto___33324,out){
return (function() {
var cljs$core$async$state_machine__31022__auto__ = null;
var cljs$core$async$state_machine__31022__auto____0 = (function (){
var statearr_33319 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33319[(0)] = cljs$core$async$state_machine__31022__auto__);

(statearr_33319[(1)] = (1));

return statearr_33319;
});
var cljs$core$async$state_machine__31022__auto____1 = (function (state_33303){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_33303);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e33320){if((e33320 instanceof Object)){
var ex__31025__auto__ = e33320;
var statearr_33321_33335 = state_33303;
(statearr_33321_33335[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33303);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33320;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33336 = state_33303;
state_33303 = G__33336;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$state_machine__31022__auto__ = function(state_33303){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31022__auto____1.call(this,state_33303);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31022__auto____0;
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31022__auto____1;
return cljs$core$async$state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto___33324,out))
})();
var state__31385__auto__ = (function (){var statearr_33322 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_33322[(6)] = c__31383__auto___33324);

return statearr_33322;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto___33324,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33338 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33338 = (function (f,ch,meta33339){
this.f = f;
this.ch = ch;
this.meta33339 = meta33339;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33338.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33340,meta33339__$1){
var self__ = this;
var _33340__$1 = this;
return (new cljs.core.async.t_cljs$core$async33338(self__.f,self__.ch,meta33339__$1));
});

cljs.core.async.t_cljs$core$async33338.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33340){
var self__ = this;
var _33340__$1 = this;
return self__.meta33339;
});

cljs.core.async.t_cljs$core$async33338.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33338.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33338.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async33338.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33338.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33341 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33341 = (function (f,ch,meta33339,_,fn1,meta33342){
this.f = f;
this.ch = ch;
this.meta33339 = meta33339;
this._ = _;
this.fn1 = fn1;
this.meta33342 = meta33342;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33341.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_33343,meta33342__$1){
var self__ = this;
var _33343__$1 = this;
return (new cljs.core.async.t_cljs$core$async33341(self__.f,self__.ch,self__.meta33339,self__._,self__.fn1,meta33342__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async33341.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_33343){
var self__ = this;
var _33343__$1 = this;
return self__.meta33342;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33341.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33341.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33341.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33341.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__33337_SHARP_){
var G__33344 = (((p1__33337_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__33337_SHARP_) : self__.f.call(null,p1__33337_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__33344) : f1.call(null,G__33344));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async33341.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33339","meta33339",-2089071992,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async33338","cljs.core.async/t_cljs$core$async33338",198266170,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta33342","meta33342",-940646323,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33341.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33341.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33341";

cljs.core.async.t_cljs$core$async33341.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async33341");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33341.
 */
cljs.core.async.__GT_t_cljs$core$async33341 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33341(f__$1,ch__$1,meta33339__$1,___$2,fn1__$1,meta33342){
return (new cljs.core.async.t_cljs$core$async33341(f__$1,ch__$1,meta33339__$1,___$2,fn1__$1,meta33342));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async33341(self__.f,self__.ch,self__.meta33339,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__3938__auto__ = ret;
if(cljs.core.truth_(and__3938__auto__)){
return !((cljs.core.deref(ret) == null));
} else {
return and__3938__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__33345 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__33345) : self__.f.call(null,G__33345));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async33338.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33338.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async33338.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33339","meta33339",-2089071992,null)], null);
});

cljs.core.async.t_cljs$core$async33338.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33338.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33338";

cljs.core.async.t_cljs$core$async33338.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async33338");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33338.
 */
cljs.core.async.__GT_t_cljs$core$async33338 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33338(f__$1,ch__$1,meta33339){
return (new cljs.core.async.t_cljs$core$async33338(f__$1,ch__$1,meta33339));
});

}

return (new cljs.core.async.t_cljs$core$async33338(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33346 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33346 = (function (f,ch,meta33347){
this.f = f;
this.ch = ch;
this.meta33347 = meta33347;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33346.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33348,meta33347__$1){
var self__ = this;
var _33348__$1 = this;
return (new cljs.core.async.t_cljs$core$async33346(self__.f,self__.ch,meta33347__$1));
});

cljs.core.async.t_cljs$core$async33346.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33348){
var self__ = this;
var _33348__$1 = this;
return self__.meta33347;
});

cljs.core.async.t_cljs$core$async33346.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33346.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33346.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33346.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33346.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33346.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async33346.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33347","meta33347",-317149357,null)], null);
});

cljs.core.async.t_cljs$core$async33346.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33346.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33346";

cljs.core.async.t_cljs$core$async33346.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async33346");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33346.
 */
cljs.core.async.__GT_t_cljs$core$async33346 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async33346(f__$1,ch__$1,meta33347){
return (new cljs.core.async.t_cljs$core$async33346(f__$1,ch__$1,meta33347));
});

}

return (new cljs.core.async.t_cljs$core$async33346(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33349 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33349 = (function (p,ch,meta33350){
this.p = p;
this.ch = ch;
this.meta33350 = meta33350;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33349.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33351,meta33350__$1){
var self__ = this;
var _33351__$1 = this;
return (new cljs.core.async.t_cljs$core$async33349(self__.p,self__.ch,meta33350__$1));
});

cljs.core.async.t_cljs$core$async33349.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33351){
var self__ = this;
var _33351__$1 = this;
return self__.meta33350;
});

cljs.core.async.t_cljs$core$async33349.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33349.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33349.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async33349.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33349.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33349.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33349.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async33349.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33350","meta33350",2055807511,null)], null);
});

cljs.core.async.t_cljs$core$async33349.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33349.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33349";

cljs.core.async.t_cljs$core$async33349.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write(writer__4193__auto__,"cljs.core.async/t_cljs$core$async33349");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33349.
 */
cljs.core.async.__GT_t_cljs$core$async33349 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async33349(p__$1,ch__$1,meta33350){
return (new cljs.core.async.t_cljs$core$async33349(p__$1,ch__$1,meta33350));
});

}

return (new cljs.core.async.t_cljs$core$async33349(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__33353 = arguments.length;
switch (G__33353) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31383__auto___33393 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto___33393,out){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto___33393,out){
return (function (state_33374){
var state_val_33375 = (state_33374[(1)]);
if((state_val_33375 === (7))){
var inst_33370 = (state_33374[(2)]);
var state_33374__$1 = state_33374;
var statearr_33376_33394 = state_33374__$1;
(statearr_33376_33394[(2)] = inst_33370);

(statearr_33376_33394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33375 === (1))){
var state_33374__$1 = state_33374;
var statearr_33377_33395 = state_33374__$1;
(statearr_33377_33395[(2)] = null);

(statearr_33377_33395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33375 === (4))){
var inst_33356 = (state_33374[(7)]);
var inst_33356__$1 = (state_33374[(2)]);
var inst_33357 = (inst_33356__$1 == null);
var state_33374__$1 = (function (){var statearr_33378 = state_33374;
(statearr_33378[(7)] = inst_33356__$1);

return statearr_33378;
})();
if(cljs.core.truth_(inst_33357)){
var statearr_33379_33396 = state_33374__$1;
(statearr_33379_33396[(1)] = (5));

} else {
var statearr_33380_33397 = state_33374__$1;
(statearr_33380_33397[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33375 === (6))){
var inst_33356 = (state_33374[(7)]);
var inst_33361 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_33356) : p.call(null,inst_33356));
var state_33374__$1 = state_33374;
if(cljs.core.truth_(inst_33361)){
var statearr_33381_33398 = state_33374__$1;
(statearr_33381_33398[(1)] = (8));

} else {
var statearr_33382_33399 = state_33374__$1;
(statearr_33382_33399[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33375 === (3))){
var inst_33372 = (state_33374[(2)]);
var state_33374__$1 = state_33374;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33374__$1,inst_33372);
} else {
if((state_val_33375 === (2))){
var state_33374__$1 = state_33374;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33374__$1,(4),ch);
} else {
if((state_val_33375 === (11))){
var inst_33364 = (state_33374[(2)]);
var state_33374__$1 = state_33374;
var statearr_33383_33400 = state_33374__$1;
(statearr_33383_33400[(2)] = inst_33364);

(statearr_33383_33400[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33375 === (9))){
var state_33374__$1 = state_33374;
var statearr_33384_33401 = state_33374__$1;
(statearr_33384_33401[(2)] = null);

(statearr_33384_33401[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33375 === (5))){
var inst_33359 = cljs.core.async.close_BANG_(out);
var state_33374__$1 = state_33374;
var statearr_33385_33402 = state_33374__$1;
(statearr_33385_33402[(2)] = inst_33359);

(statearr_33385_33402[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33375 === (10))){
var inst_33367 = (state_33374[(2)]);
var state_33374__$1 = (function (){var statearr_33386 = state_33374;
(statearr_33386[(8)] = inst_33367);

return statearr_33386;
})();
var statearr_33387_33403 = state_33374__$1;
(statearr_33387_33403[(2)] = null);

(statearr_33387_33403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33375 === (8))){
var inst_33356 = (state_33374[(7)]);
var state_33374__$1 = state_33374;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33374__$1,(11),out,inst_33356);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31383__auto___33393,out))
;
return ((function (switch__31021__auto__,c__31383__auto___33393,out){
return (function() {
var cljs$core$async$state_machine__31022__auto__ = null;
var cljs$core$async$state_machine__31022__auto____0 = (function (){
var statearr_33388 = [null,null,null,null,null,null,null,null,null];
(statearr_33388[(0)] = cljs$core$async$state_machine__31022__auto__);

(statearr_33388[(1)] = (1));

return statearr_33388;
});
var cljs$core$async$state_machine__31022__auto____1 = (function (state_33374){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_33374);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e33389){if((e33389 instanceof Object)){
var ex__31025__auto__ = e33389;
var statearr_33390_33404 = state_33374;
(statearr_33390_33404[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33374);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33389;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33405 = state_33374;
state_33374 = G__33405;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$state_machine__31022__auto__ = function(state_33374){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31022__auto____1.call(this,state_33374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31022__auto____0;
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31022__auto____1;
return cljs$core$async$state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto___33393,out))
})();
var state__31385__auto__ = (function (){var statearr_33391 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_33391[(6)] = c__31383__auto___33393);

return statearr_33391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto___33393,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__33407 = arguments.length;
switch (G__33407) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__31383__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto__){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto__){
return (function (state_33470){
var state_val_33471 = (state_33470[(1)]);
if((state_val_33471 === (7))){
var inst_33466 = (state_33470[(2)]);
var state_33470__$1 = state_33470;
var statearr_33472_33510 = state_33470__$1;
(statearr_33472_33510[(2)] = inst_33466);

(statearr_33472_33510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (20))){
var inst_33436 = (state_33470[(7)]);
var inst_33447 = (state_33470[(2)]);
var inst_33448 = cljs.core.next(inst_33436);
var inst_33422 = inst_33448;
var inst_33423 = null;
var inst_33424 = (0);
var inst_33425 = (0);
var state_33470__$1 = (function (){var statearr_33473 = state_33470;
(statearr_33473[(8)] = inst_33425);

(statearr_33473[(9)] = inst_33422);

(statearr_33473[(10)] = inst_33447);

(statearr_33473[(11)] = inst_33424);

(statearr_33473[(12)] = inst_33423);

return statearr_33473;
})();
var statearr_33474_33511 = state_33470__$1;
(statearr_33474_33511[(2)] = null);

(statearr_33474_33511[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (1))){
var state_33470__$1 = state_33470;
var statearr_33475_33512 = state_33470__$1;
(statearr_33475_33512[(2)] = null);

(statearr_33475_33512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (4))){
var inst_33411 = (state_33470[(13)]);
var inst_33411__$1 = (state_33470[(2)]);
var inst_33412 = (inst_33411__$1 == null);
var state_33470__$1 = (function (){var statearr_33476 = state_33470;
(statearr_33476[(13)] = inst_33411__$1);

return statearr_33476;
})();
if(cljs.core.truth_(inst_33412)){
var statearr_33477_33513 = state_33470__$1;
(statearr_33477_33513[(1)] = (5));

} else {
var statearr_33478_33514 = state_33470__$1;
(statearr_33478_33514[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (15))){
var state_33470__$1 = state_33470;
var statearr_33482_33515 = state_33470__$1;
(statearr_33482_33515[(2)] = null);

(statearr_33482_33515[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (21))){
var state_33470__$1 = state_33470;
var statearr_33483_33516 = state_33470__$1;
(statearr_33483_33516[(2)] = null);

(statearr_33483_33516[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (13))){
var inst_33425 = (state_33470[(8)]);
var inst_33422 = (state_33470[(9)]);
var inst_33424 = (state_33470[(11)]);
var inst_33423 = (state_33470[(12)]);
var inst_33432 = (state_33470[(2)]);
var inst_33433 = (inst_33425 + (1));
var tmp33479 = inst_33422;
var tmp33480 = inst_33424;
var tmp33481 = inst_33423;
var inst_33422__$1 = tmp33479;
var inst_33423__$1 = tmp33481;
var inst_33424__$1 = tmp33480;
var inst_33425__$1 = inst_33433;
var state_33470__$1 = (function (){var statearr_33484 = state_33470;
(statearr_33484[(8)] = inst_33425__$1);

(statearr_33484[(9)] = inst_33422__$1);

(statearr_33484[(14)] = inst_33432);

(statearr_33484[(11)] = inst_33424__$1);

(statearr_33484[(12)] = inst_33423__$1);

return statearr_33484;
})();
var statearr_33485_33517 = state_33470__$1;
(statearr_33485_33517[(2)] = null);

(statearr_33485_33517[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (22))){
var state_33470__$1 = state_33470;
var statearr_33486_33518 = state_33470__$1;
(statearr_33486_33518[(2)] = null);

(statearr_33486_33518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (6))){
var inst_33411 = (state_33470[(13)]);
var inst_33420 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33411) : f.call(null,inst_33411));
var inst_33421 = cljs.core.seq(inst_33420);
var inst_33422 = inst_33421;
var inst_33423 = null;
var inst_33424 = (0);
var inst_33425 = (0);
var state_33470__$1 = (function (){var statearr_33487 = state_33470;
(statearr_33487[(8)] = inst_33425);

(statearr_33487[(9)] = inst_33422);

(statearr_33487[(11)] = inst_33424);

(statearr_33487[(12)] = inst_33423);

return statearr_33487;
})();
var statearr_33488_33519 = state_33470__$1;
(statearr_33488_33519[(2)] = null);

(statearr_33488_33519[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (17))){
var inst_33436 = (state_33470[(7)]);
var inst_33440 = cljs.core.chunk_first(inst_33436);
var inst_33441 = cljs.core.chunk_rest(inst_33436);
var inst_33442 = cljs.core.count(inst_33440);
var inst_33422 = inst_33441;
var inst_33423 = inst_33440;
var inst_33424 = inst_33442;
var inst_33425 = (0);
var state_33470__$1 = (function (){var statearr_33489 = state_33470;
(statearr_33489[(8)] = inst_33425);

(statearr_33489[(9)] = inst_33422);

(statearr_33489[(11)] = inst_33424);

(statearr_33489[(12)] = inst_33423);

return statearr_33489;
})();
var statearr_33490_33520 = state_33470__$1;
(statearr_33490_33520[(2)] = null);

(statearr_33490_33520[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (3))){
var inst_33468 = (state_33470[(2)]);
var state_33470__$1 = state_33470;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33470__$1,inst_33468);
} else {
if((state_val_33471 === (12))){
var inst_33456 = (state_33470[(2)]);
var state_33470__$1 = state_33470;
var statearr_33491_33521 = state_33470__$1;
(statearr_33491_33521[(2)] = inst_33456);

(statearr_33491_33521[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (2))){
var state_33470__$1 = state_33470;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33470__$1,(4),in$);
} else {
if((state_val_33471 === (23))){
var inst_33464 = (state_33470[(2)]);
var state_33470__$1 = state_33470;
var statearr_33492_33522 = state_33470__$1;
(statearr_33492_33522[(2)] = inst_33464);

(statearr_33492_33522[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (19))){
var inst_33451 = (state_33470[(2)]);
var state_33470__$1 = state_33470;
var statearr_33493_33523 = state_33470__$1;
(statearr_33493_33523[(2)] = inst_33451);

(statearr_33493_33523[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (11))){
var inst_33436 = (state_33470[(7)]);
var inst_33422 = (state_33470[(9)]);
var inst_33436__$1 = cljs.core.seq(inst_33422);
var state_33470__$1 = (function (){var statearr_33494 = state_33470;
(statearr_33494[(7)] = inst_33436__$1);

return statearr_33494;
})();
if(inst_33436__$1){
var statearr_33495_33524 = state_33470__$1;
(statearr_33495_33524[(1)] = (14));

} else {
var statearr_33496_33525 = state_33470__$1;
(statearr_33496_33525[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (9))){
var inst_33458 = (state_33470[(2)]);
var inst_33459 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_33470__$1 = (function (){var statearr_33497 = state_33470;
(statearr_33497[(15)] = inst_33458);

return statearr_33497;
})();
if(cljs.core.truth_(inst_33459)){
var statearr_33498_33526 = state_33470__$1;
(statearr_33498_33526[(1)] = (21));

} else {
var statearr_33499_33527 = state_33470__$1;
(statearr_33499_33527[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (5))){
var inst_33414 = cljs.core.async.close_BANG_(out);
var state_33470__$1 = state_33470;
var statearr_33500_33528 = state_33470__$1;
(statearr_33500_33528[(2)] = inst_33414);

(statearr_33500_33528[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (14))){
var inst_33436 = (state_33470[(7)]);
var inst_33438 = cljs.core.chunked_seq_QMARK_(inst_33436);
var state_33470__$1 = state_33470;
if(inst_33438){
var statearr_33501_33529 = state_33470__$1;
(statearr_33501_33529[(1)] = (17));

} else {
var statearr_33502_33530 = state_33470__$1;
(statearr_33502_33530[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (16))){
var inst_33454 = (state_33470[(2)]);
var state_33470__$1 = state_33470;
var statearr_33503_33531 = state_33470__$1;
(statearr_33503_33531[(2)] = inst_33454);

(statearr_33503_33531[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (10))){
var inst_33425 = (state_33470[(8)]);
var inst_33423 = (state_33470[(12)]);
var inst_33430 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_33423,inst_33425);
var state_33470__$1 = state_33470;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33470__$1,(13),out,inst_33430);
} else {
if((state_val_33471 === (18))){
var inst_33436 = (state_33470[(7)]);
var inst_33445 = cljs.core.first(inst_33436);
var state_33470__$1 = state_33470;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33470__$1,(20),out,inst_33445);
} else {
if((state_val_33471 === (8))){
var inst_33425 = (state_33470[(8)]);
var inst_33424 = (state_33470[(11)]);
var inst_33427 = (inst_33425 < inst_33424);
var inst_33428 = inst_33427;
var state_33470__$1 = state_33470;
if(cljs.core.truth_(inst_33428)){
var statearr_33504_33532 = state_33470__$1;
(statearr_33504_33532[(1)] = (10));

} else {
var statearr_33505_33533 = state_33470__$1;
(statearr_33505_33533[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31383__auto__))
;
return ((function (switch__31021__auto__,c__31383__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__31022__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__31022__auto____0 = (function (){
var statearr_33506 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33506[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__31022__auto__);

(statearr_33506[(1)] = (1));

return statearr_33506;
});
var cljs$core$async$mapcat_STAR__$_state_machine__31022__auto____1 = (function (state_33470){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_33470);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e33507){if((e33507 instanceof Object)){
var ex__31025__auto__ = e33507;
var statearr_33508_33534 = state_33470;
(statearr_33508_33534[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33470);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33507;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33535 = state_33470;
state_33470 = G__33535;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__31022__auto__ = function(state_33470){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__31022__auto____1.call(this,state_33470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__31022__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__31022__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto__))
})();
var state__31385__auto__ = (function (){var statearr_33509 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_33509[(6)] = c__31383__auto__);

return statearr_33509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto__))
);

return c__31383__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__33537 = arguments.length;
switch (G__33537) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__33540 = arguments.length;
switch (G__33540) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__33543 = arguments.length;
switch (G__33543) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31383__auto___33590 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto___33590,out){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto___33590,out){
return (function (state_33567){
var state_val_33568 = (state_33567[(1)]);
if((state_val_33568 === (7))){
var inst_33562 = (state_33567[(2)]);
var state_33567__$1 = state_33567;
var statearr_33569_33591 = state_33567__$1;
(statearr_33569_33591[(2)] = inst_33562);

(statearr_33569_33591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33568 === (1))){
var inst_33544 = null;
var state_33567__$1 = (function (){var statearr_33570 = state_33567;
(statearr_33570[(7)] = inst_33544);

return statearr_33570;
})();
var statearr_33571_33592 = state_33567__$1;
(statearr_33571_33592[(2)] = null);

(statearr_33571_33592[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33568 === (4))){
var inst_33547 = (state_33567[(8)]);
var inst_33547__$1 = (state_33567[(2)]);
var inst_33548 = (inst_33547__$1 == null);
var inst_33549 = cljs.core.not(inst_33548);
var state_33567__$1 = (function (){var statearr_33572 = state_33567;
(statearr_33572[(8)] = inst_33547__$1);

return statearr_33572;
})();
if(inst_33549){
var statearr_33573_33593 = state_33567__$1;
(statearr_33573_33593[(1)] = (5));

} else {
var statearr_33574_33594 = state_33567__$1;
(statearr_33574_33594[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33568 === (6))){
var state_33567__$1 = state_33567;
var statearr_33575_33595 = state_33567__$1;
(statearr_33575_33595[(2)] = null);

(statearr_33575_33595[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33568 === (3))){
var inst_33564 = (state_33567[(2)]);
var inst_33565 = cljs.core.async.close_BANG_(out);
var state_33567__$1 = (function (){var statearr_33576 = state_33567;
(statearr_33576[(9)] = inst_33564);

return statearr_33576;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33567__$1,inst_33565);
} else {
if((state_val_33568 === (2))){
var state_33567__$1 = state_33567;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33567__$1,(4),ch);
} else {
if((state_val_33568 === (11))){
var inst_33547 = (state_33567[(8)]);
var inst_33556 = (state_33567[(2)]);
var inst_33544 = inst_33547;
var state_33567__$1 = (function (){var statearr_33577 = state_33567;
(statearr_33577[(7)] = inst_33544);

(statearr_33577[(10)] = inst_33556);

return statearr_33577;
})();
var statearr_33578_33596 = state_33567__$1;
(statearr_33578_33596[(2)] = null);

(statearr_33578_33596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33568 === (9))){
var inst_33547 = (state_33567[(8)]);
var state_33567__$1 = state_33567;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33567__$1,(11),out,inst_33547);
} else {
if((state_val_33568 === (5))){
var inst_33544 = (state_33567[(7)]);
var inst_33547 = (state_33567[(8)]);
var inst_33551 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33547,inst_33544);
var state_33567__$1 = state_33567;
if(inst_33551){
var statearr_33580_33597 = state_33567__$1;
(statearr_33580_33597[(1)] = (8));

} else {
var statearr_33581_33598 = state_33567__$1;
(statearr_33581_33598[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33568 === (10))){
var inst_33559 = (state_33567[(2)]);
var state_33567__$1 = state_33567;
var statearr_33582_33599 = state_33567__$1;
(statearr_33582_33599[(2)] = inst_33559);

(statearr_33582_33599[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33568 === (8))){
var inst_33544 = (state_33567[(7)]);
var tmp33579 = inst_33544;
var inst_33544__$1 = tmp33579;
var state_33567__$1 = (function (){var statearr_33583 = state_33567;
(statearr_33583[(7)] = inst_33544__$1);

return statearr_33583;
})();
var statearr_33584_33600 = state_33567__$1;
(statearr_33584_33600[(2)] = null);

(statearr_33584_33600[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31383__auto___33590,out))
;
return ((function (switch__31021__auto__,c__31383__auto___33590,out){
return (function() {
var cljs$core$async$state_machine__31022__auto__ = null;
var cljs$core$async$state_machine__31022__auto____0 = (function (){
var statearr_33585 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33585[(0)] = cljs$core$async$state_machine__31022__auto__);

(statearr_33585[(1)] = (1));

return statearr_33585;
});
var cljs$core$async$state_machine__31022__auto____1 = (function (state_33567){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_33567);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e33586){if((e33586 instanceof Object)){
var ex__31025__auto__ = e33586;
var statearr_33587_33601 = state_33567;
(statearr_33587_33601[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33567);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33586;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33602 = state_33567;
state_33567 = G__33602;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$state_machine__31022__auto__ = function(state_33567){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31022__auto____1.call(this,state_33567);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31022__auto____0;
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31022__auto____1;
return cljs$core$async$state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto___33590,out))
})();
var state__31385__auto__ = (function (){var statearr_33588 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_33588[(6)] = c__31383__auto___33590);

return statearr_33588;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto___33590,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__33604 = arguments.length;
switch (G__33604) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31383__auto___33670 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto___33670,out){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto___33670,out){
return (function (state_33642){
var state_val_33643 = (state_33642[(1)]);
if((state_val_33643 === (7))){
var inst_33638 = (state_33642[(2)]);
var state_33642__$1 = state_33642;
var statearr_33644_33671 = state_33642__$1;
(statearr_33644_33671[(2)] = inst_33638);

(statearr_33644_33671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33643 === (1))){
var inst_33605 = (new Array(n));
var inst_33606 = inst_33605;
var inst_33607 = (0);
var state_33642__$1 = (function (){var statearr_33645 = state_33642;
(statearr_33645[(7)] = inst_33606);

(statearr_33645[(8)] = inst_33607);

return statearr_33645;
})();
var statearr_33646_33672 = state_33642__$1;
(statearr_33646_33672[(2)] = null);

(statearr_33646_33672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33643 === (4))){
var inst_33610 = (state_33642[(9)]);
var inst_33610__$1 = (state_33642[(2)]);
var inst_33611 = (inst_33610__$1 == null);
var inst_33612 = cljs.core.not(inst_33611);
var state_33642__$1 = (function (){var statearr_33647 = state_33642;
(statearr_33647[(9)] = inst_33610__$1);

return statearr_33647;
})();
if(inst_33612){
var statearr_33648_33673 = state_33642__$1;
(statearr_33648_33673[(1)] = (5));

} else {
var statearr_33649_33674 = state_33642__$1;
(statearr_33649_33674[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33643 === (15))){
var inst_33632 = (state_33642[(2)]);
var state_33642__$1 = state_33642;
var statearr_33650_33675 = state_33642__$1;
(statearr_33650_33675[(2)] = inst_33632);

(statearr_33650_33675[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33643 === (13))){
var state_33642__$1 = state_33642;
var statearr_33651_33676 = state_33642__$1;
(statearr_33651_33676[(2)] = null);

(statearr_33651_33676[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33643 === (6))){
var inst_33607 = (state_33642[(8)]);
var inst_33628 = (inst_33607 > (0));
var state_33642__$1 = state_33642;
if(cljs.core.truth_(inst_33628)){
var statearr_33652_33677 = state_33642__$1;
(statearr_33652_33677[(1)] = (12));

} else {
var statearr_33653_33678 = state_33642__$1;
(statearr_33653_33678[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33643 === (3))){
var inst_33640 = (state_33642[(2)]);
var state_33642__$1 = state_33642;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33642__$1,inst_33640);
} else {
if((state_val_33643 === (12))){
var inst_33606 = (state_33642[(7)]);
var inst_33630 = cljs.core.vec(inst_33606);
var state_33642__$1 = state_33642;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33642__$1,(15),out,inst_33630);
} else {
if((state_val_33643 === (2))){
var state_33642__$1 = state_33642;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33642__$1,(4),ch);
} else {
if((state_val_33643 === (11))){
var inst_33622 = (state_33642[(2)]);
var inst_33623 = (new Array(n));
var inst_33606 = inst_33623;
var inst_33607 = (0);
var state_33642__$1 = (function (){var statearr_33654 = state_33642;
(statearr_33654[(10)] = inst_33622);

(statearr_33654[(7)] = inst_33606);

(statearr_33654[(8)] = inst_33607);

return statearr_33654;
})();
var statearr_33655_33679 = state_33642__$1;
(statearr_33655_33679[(2)] = null);

(statearr_33655_33679[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33643 === (9))){
var inst_33606 = (state_33642[(7)]);
var inst_33620 = cljs.core.vec(inst_33606);
var state_33642__$1 = state_33642;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33642__$1,(11),out,inst_33620);
} else {
if((state_val_33643 === (5))){
var inst_33610 = (state_33642[(9)]);
var inst_33615 = (state_33642[(11)]);
var inst_33606 = (state_33642[(7)]);
var inst_33607 = (state_33642[(8)]);
var inst_33614 = (inst_33606[inst_33607] = inst_33610);
var inst_33615__$1 = (inst_33607 + (1));
var inst_33616 = (inst_33615__$1 < n);
var state_33642__$1 = (function (){var statearr_33656 = state_33642;
(statearr_33656[(12)] = inst_33614);

(statearr_33656[(11)] = inst_33615__$1);

return statearr_33656;
})();
if(cljs.core.truth_(inst_33616)){
var statearr_33657_33680 = state_33642__$1;
(statearr_33657_33680[(1)] = (8));

} else {
var statearr_33658_33681 = state_33642__$1;
(statearr_33658_33681[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33643 === (14))){
var inst_33635 = (state_33642[(2)]);
var inst_33636 = cljs.core.async.close_BANG_(out);
var state_33642__$1 = (function (){var statearr_33660 = state_33642;
(statearr_33660[(13)] = inst_33635);

return statearr_33660;
})();
var statearr_33661_33682 = state_33642__$1;
(statearr_33661_33682[(2)] = inst_33636);

(statearr_33661_33682[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33643 === (10))){
var inst_33626 = (state_33642[(2)]);
var state_33642__$1 = state_33642;
var statearr_33662_33683 = state_33642__$1;
(statearr_33662_33683[(2)] = inst_33626);

(statearr_33662_33683[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33643 === (8))){
var inst_33615 = (state_33642[(11)]);
var inst_33606 = (state_33642[(7)]);
var tmp33659 = inst_33606;
var inst_33606__$1 = tmp33659;
var inst_33607 = inst_33615;
var state_33642__$1 = (function (){var statearr_33663 = state_33642;
(statearr_33663[(7)] = inst_33606__$1);

(statearr_33663[(8)] = inst_33607);

return statearr_33663;
})();
var statearr_33664_33684 = state_33642__$1;
(statearr_33664_33684[(2)] = null);

(statearr_33664_33684[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31383__auto___33670,out))
;
return ((function (switch__31021__auto__,c__31383__auto___33670,out){
return (function() {
var cljs$core$async$state_machine__31022__auto__ = null;
var cljs$core$async$state_machine__31022__auto____0 = (function (){
var statearr_33665 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33665[(0)] = cljs$core$async$state_machine__31022__auto__);

(statearr_33665[(1)] = (1));

return statearr_33665;
});
var cljs$core$async$state_machine__31022__auto____1 = (function (state_33642){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_33642);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e33666){if((e33666 instanceof Object)){
var ex__31025__auto__ = e33666;
var statearr_33667_33685 = state_33642;
(statearr_33667_33685[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33642);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33666;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33686 = state_33642;
state_33642 = G__33686;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$state_machine__31022__auto__ = function(state_33642){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31022__auto____1.call(this,state_33642);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31022__auto____0;
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31022__auto____1;
return cljs$core$async$state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto___33670,out))
})();
var state__31385__auto__ = (function (){var statearr_33668 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_33668[(6)] = c__31383__auto___33670);

return statearr_33668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto___33670,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__33688 = arguments.length;
switch (G__33688) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31383__auto___33758 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__31383__auto___33758,out){
return (function (){
var f__31384__auto__ = (function (){var switch__31021__auto__ = ((function (c__31383__auto___33758,out){
return (function (state_33730){
var state_val_33731 = (state_33730[(1)]);
if((state_val_33731 === (7))){
var inst_33726 = (state_33730[(2)]);
var state_33730__$1 = state_33730;
var statearr_33732_33759 = state_33730__$1;
(statearr_33732_33759[(2)] = inst_33726);

(statearr_33732_33759[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33731 === (1))){
var inst_33689 = [];
var inst_33690 = inst_33689;
var inst_33691 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_33730__$1 = (function (){var statearr_33733 = state_33730;
(statearr_33733[(7)] = inst_33691);

(statearr_33733[(8)] = inst_33690);

return statearr_33733;
})();
var statearr_33734_33760 = state_33730__$1;
(statearr_33734_33760[(2)] = null);

(statearr_33734_33760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33731 === (4))){
var inst_33694 = (state_33730[(9)]);
var inst_33694__$1 = (state_33730[(2)]);
var inst_33695 = (inst_33694__$1 == null);
var inst_33696 = cljs.core.not(inst_33695);
var state_33730__$1 = (function (){var statearr_33735 = state_33730;
(statearr_33735[(9)] = inst_33694__$1);

return statearr_33735;
})();
if(inst_33696){
var statearr_33736_33761 = state_33730__$1;
(statearr_33736_33761[(1)] = (5));

} else {
var statearr_33737_33762 = state_33730__$1;
(statearr_33737_33762[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33731 === (15))){
var inst_33720 = (state_33730[(2)]);
var state_33730__$1 = state_33730;
var statearr_33738_33763 = state_33730__$1;
(statearr_33738_33763[(2)] = inst_33720);

(statearr_33738_33763[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33731 === (13))){
var state_33730__$1 = state_33730;
var statearr_33739_33764 = state_33730__$1;
(statearr_33739_33764[(2)] = null);

(statearr_33739_33764[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33731 === (6))){
var inst_33690 = (state_33730[(8)]);
var inst_33715 = inst_33690.length;
var inst_33716 = (inst_33715 > (0));
var state_33730__$1 = state_33730;
if(cljs.core.truth_(inst_33716)){
var statearr_33740_33765 = state_33730__$1;
(statearr_33740_33765[(1)] = (12));

} else {
var statearr_33741_33766 = state_33730__$1;
(statearr_33741_33766[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33731 === (3))){
var inst_33728 = (state_33730[(2)]);
var state_33730__$1 = state_33730;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33730__$1,inst_33728);
} else {
if((state_val_33731 === (12))){
var inst_33690 = (state_33730[(8)]);
var inst_33718 = cljs.core.vec(inst_33690);
var state_33730__$1 = state_33730;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33730__$1,(15),out,inst_33718);
} else {
if((state_val_33731 === (2))){
var state_33730__$1 = state_33730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33730__$1,(4),ch);
} else {
if((state_val_33731 === (11))){
var inst_33698 = (state_33730[(10)]);
var inst_33694 = (state_33730[(9)]);
var inst_33708 = (state_33730[(2)]);
var inst_33709 = [];
var inst_33710 = inst_33709.push(inst_33694);
var inst_33690 = inst_33709;
var inst_33691 = inst_33698;
var state_33730__$1 = (function (){var statearr_33742 = state_33730;
(statearr_33742[(11)] = inst_33708);

(statearr_33742[(7)] = inst_33691);

(statearr_33742[(12)] = inst_33710);

(statearr_33742[(8)] = inst_33690);

return statearr_33742;
})();
var statearr_33743_33767 = state_33730__$1;
(statearr_33743_33767[(2)] = null);

(statearr_33743_33767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33731 === (9))){
var inst_33690 = (state_33730[(8)]);
var inst_33706 = cljs.core.vec(inst_33690);
var state_33730__$1 = state_33730;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33730__$1,(11),out,inst_33706);
} else {
if((state_val_33731 === (5))){
var inst_33691 = (state_33730[(7)]);
var inst_33698 = (state_33730[(10)]);
var inst_33694 = (state_33730[(9)]);
var inst_33698__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33694) : f.call(null,inst_33694));
var inst_33699 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33698__$1,inst_33691);
var inst_33700 = cljs.core.keyword_identical_QMARK_(inst_33691,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_33701 = ((inst_33699) || (inst_33700));
var state_33730__$1 = (function (){var statearr_33744 = state_33730;
(statearr_33744[(10)] = inst_33698__$1);

return statearr_33744;
})();
if(cljs.core.truth_(inst_33701)){
var statearr_33745_33768 = state_33730__$1;
(statearr_33745_33768[(1)] = (8));

} else {
var statearr_33746_33769 = state_33730__$1;
(statearr_33746_33769[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33731 === (14))){
var inst_33723 = (state_33730[(2)]);
var inst_33724 = cljs.core.async.close_BANG_(out);
var state_33730__$1 = (function (){var statearr_33748 = state_33730;
(statearr_33748[(13)] = inst_33723);

return statearr_33748;
})();
var statearr_33749_33770 = state_33730__$1;
(statearr_33749_33770[(2)] = inst_33724);

(statearr_33749_33770[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33731 === (10))){
var inst_33713 = (state_33730[(2)]);
var state_33730__$1 = state_33730;
var statearr_33750_33771 = state_33730__$1;
(statearr_33750_33771[(2)] = inst_33713);

(statearr_33750_33771[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33731 === (8))){
var inst_33690 = (state_33730[(8)]);
var inst_33698 = (state_33730[(10)]);
var inst_33694 = (state_33730[(9)]);
var inst_33703 = inst_33690.push(inst_33694);
var tmp33747 = inst_33690;
var inst_33690__$1 = tmp33747;
var inst_33691 = inst_33698;
var state_33730__$1 = (function (){var statearr_33751 = state_33730;
(statearr_33751[(7)] = inst_33691);

(statearr_33751[(8)] = inst_33690__$1);

(statearr_33751[(14)] = inst_33703);

return statearr_33751;
})();
var statearr_33752_33772 = state_33730__$1;
(statearr_33752_33772[(2)] = null);

(statearr_33752_33772[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31383__auto___33758,out))
;
return ((function (switch__31021__auto__,c__31383__auto___33758,out){
return (function() {
var cljs$core$async$state_machine__31022__auto__ = null;
var cljs$core$async$state_machine__31022__auto____0 = (function (){
var statearr_33753 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33753[(0)] = cljs$core$async$state_machine__31022__auto__);

(statearr_33753[(1)] = (1));

return statearr_33753;
});
var cljs$core$async$state_machine__31022__auto____1 = (function (state_33730){
while(true){
var ret_value__31023__auto__ = (function (){try{while(true){
var result__31024__auto__ = switch__31021__auto__(state_33730);
if(cljs.core.keyword_identical_QMARK_(result__31024__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31024__auto__;
}
break;
}
}catch (e33754){if((e33754 instanceof Object)){
var ex__31025__auto__ = e33754;
var statearr_33755_33773 = state_33730;
(statearr_33755_33773[(5)] = ex__31025__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33730);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33754;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__31023__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33774 = state_33730;
state_33730 = G__33774;
continue;
} else {
return ret_value__31023__auto__;
}
break;
}
});
cljs$core$async$state_machine__31022__auto__ = function(state_33730){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31022__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31022__auto____1.call(this,state_33730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31022__auto____0;
cljs$core$async$state_machine__31022__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31022__auto____1;
return cljs$core$async$state_machine__31022__auto__;
})()
;})(switch__31021__auto__,c__31383__auto___33758,out))
})();
var state__31385__auto__ = (function (){var statearr_33756 = (f__31384__auto__.cljs$core$IFn$_invoke$arity$0 ? f__31384__auto__.cljs$core$IFn$_invoke$arity$0() : f__31384__auto__.call(null));
(statearr_33756[(6)] = c__31383__auto___33758);

return statearr_33756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31385__auto__);
});})(c__31383__auto___33758,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=cljs.core.async.js.map
