(ns leiningen.new.ventas
  "ventas template"
  (:require
   [clojure.string :as str]
   [leiningen.new.templates :as templates]
   [leiningen.core.main :as main]))

(defn ventas
  "ventas template"
  [name]
  (let [render (templates/renderer "ventas")
        main-ns (templates/multi-segment (templates/sanitize-ns name))
        data {:raw-name name
              :underscored-raw-name (str/replace name "-" "_")
              :name (templates/project-name name)
              :namespace main-ns
              :nested-dirs (templates/name-to-path main-ns)
              :year (templates/year)
              :date (templates/date)
              :theme "{{theme}}"
              :rendered-db-script "{{rendered-db-script}}"
              :rendered-html "{{rendered-html}}"}]
    (main/info "Generating a project called" name "based on the 'ventas' template.")
    (templates/->files data
                       ["dev/repl.clj" (render "dev/repl.clj" data)]
                       ["resources/config.edn" (render "resources/config.edn" data)]
                       ["src/clj/{{underscored-raw-name}}/core.clj" (render "src/clj/core.clj" data)]
                       ["src/clj/{{underscored-raw-name}}/example_plugin.clj" (render "src/clj/example_plugin.clj" data)]
                       ["src/clj/{{underscored-raw-name}}/example_theme.clj" (render "src/clj/example_theme.clj" data)]
                       ["src/cljs/{{underscored-raw-name}}/core.cljs" (render "src/cljs/core.cljs" data)]
                       ["src/cljs/{{underscored-raw-name}}/example_theme.cljs" (render "src/cljs/example_theme.cljs" data)]
                       ["src/scss/themes/example/main.scss" (render "src/scss/themes/example/main.scss" data)]
                       [".gitignore" (render "gitignore" data)]
                       [".hgignore" (render "hgignore" data)]
                       ["docker-compose.yml" (render "docker-compose.yml" data)]
                       ["datomic/Dockerfile" (render "datomic/Dockerfile" data)]
                       ["datomic/.credentials.example" (render "datomic/credentials.example")]
                       ["datomic/config/transactor.example.properties" (render "datomic/config/transactor.example.properties")]
                       ["LICENSE" (render "LICENSE" data)]
                       ["project.clj" (render "project.clj" data)]
                       ["README.md" (render "README.md" data)]
                       "resources")))
