(ns {{raw-name}}.example-plugin
  (:require
   [clojure.spec.alpha :as spec]
   [ventas.database.entity :as entity]
   [ventas.server.api :as api]
   [ventas.plugin :as plugin]))

(spec/def :example-entity/greeting string?)

(spec/def :schema.type/example-entity
  (spec/keys :req [:example-entity/greeting]))

(entity/register-type!
 :example-entity
 {:attributes
  [{:db/ident :example-entity/greeting
    :db/valueType :db.type/string
    :db/cardinality :db.cardinality/one}]

  :fixtures
  (fn []
    [{:example-entity/greeting "Hi, "}])})

(api/register-endpoint!
 :example-plugin.greet
 (fn [{:keys [params]} {:keys [session]}]
   (let [greeting (entity/query-one :example-entity)]
     (str (:example-entity/greeting greeting)
          (:name params)
          "!"))))

(plugin/register!
 :example-plugin
 {:name "Example plugin"
  :endpoints [:example-plugin.greet]
  :entity-types [:example-entity]})