# ventas-lein-template

[![Clojars Project](https://img.shields.io/clojars/v/ventas/lein-template.svg)](https://clojars.org/ventas/lein-template)

Leiningen template for creating [ventas](https://github.com/JoelSanchez/ventas)-based projects.

It simplifies running ventas with plugins and themes of your choice.



## Getting started

You need to have Datomic and Elasticsearch running for this to work. Also, you'll probably need to change the configuration to suit your local environment. You'll find it under `resources/config.edn`.

```bash
$ lein new ventas my-project
Generating a project called my-project based on the 'ventas' template.
$ cd my-project
$ lein repl
> (init)
:reloading (my-project.example-plugin my-project.core user)
INFO [ventas.config:24] - Loading configuration
DEBUG [ventas.config:25] - {:embed-figwheel? true,
                            :cljs-port 3001,
                            :server {:port 3450, :host "localhost"},
                            :debug true,
                            :nrepl {:port 4001, :host "localhost"},
                            :auth-secret "CHANGEME",
                            :elasticsearch {:index "ventas", :port 9200, :host "127.0.0.1"},
                            :database {:url "datomic:dev://localhost:4334/ventas"},
                            :strict-classloading false}
INFO [user:45] - Starting Figwheel
Figwheel: Starting server at http://0.0.0.0:3449
Figwheel: Watching build - app
Figwheel: Cleaning build - app
Compiling "resources/public/files/js/compiled/my-project.js" from ["src/cljs"]...
Successfully compiled "resources/public/files/js/compiled/my-project.js" in 20.934 seconds.
Figwheel: Starting CSS Watcher for paths  ["resources/public/files/css"]
INFO [user:62] - Starting SASS
INFO [ventas.database:27] - Starting database, URL: datomic:dev://localhost:4334/ventas
INFO [ventas.search:22] - Connecting to Elasticsearch at http://127.0.0.1:9200
INFO [ventas.search:241] - Starting indexer
INFO [ventas.server:119] - Starting server
INFO [ventas.server:121] - Starting server on localhost:3450
:ready
user=>
```

Now you can visit `localhost:3450`to see the frontend.



## Purpose / how to use

This template is good for:

- Developing plugins or themes for a fixed version of ventas, without having to compile the whole source code. Kind of like a "playground" but safer than cloning the whole ventas repository.
- Customizing ventas to run stores. You can include themes and plugins by including them in `project.clj` and then requiring their namespaces in `ventas.core`. You can use the ventas API to add endpoints, entity types, frontend components, or whatever.

## License

Copyright © 2018 Joel Sánchez

Distributed under the Eclipse Public License either version 1.0 or (at your option) any later version.
