(def aot-namespaces
  ['clojure.tools.logging.impl
   'ventas.core])

(defproject {{raw-name}} "0.0.1-SNAPSHOT"
  :description "A ventas-based project"

  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}

  :dependencies [[org.clojure/clojure "1.9.0"]
                 [org.clojure/clojurescript "1.9.946" :scope "provided"]
                 [org.clojure/tools.namespace "0.3.0-alpha4"]
                 [org.clojure/spec.alpha "0.1.143" :scope "provided"]
                 [mount "0.1.11"]
                 [ventas "0.0.10" :exclusions [com.datomic/datomic-pro com.datomic/datomic-free]]]

  :plugins [[lein-auto "0.1.3"]
            [lein-cljfmt "0.5.6"]
            [lein-cljsbuild "1.1.7"]
            [lein-sassc "0.10.4" :exclusions [org.apache.commons/commons-compress org.clojure/clojure]]]

  :source-paths ["src/clj" "src/cljs"]

  :jvm-opts ["-XX:-OmitStackTraceInFastThrow"
             "-Dapple.awt.UIElement=true" ;; Disable empty/useless menu item in OSX
             ]

  :clean-targets ^{:protect false} [:target-path :compile-path "resources/public/files/js"]

  :uberjar-name "ventas.jar"

  :main ^:skip-aot {{raw-name}}.core

  :repl-options {:init-ns repl
                 :port 4001
                 :nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]
                 :timeout 120000}

  :aliases {"nrepl" ["repl" ":connect" "localhost:4001"]
            "release-install" ["with-profile" "release" "install"]}

  :target-path "target/%s"

  :cljsbuild {:builds
              [{:id "app"
                :source-paths ["src/cljs"]
                :figwheel {:on-jsload "ventas.core/on-figwheel-reload"}
                :compiler {:main '{{raw-name}}.core
                           :asset-path "files/js/compiled/out"
                           :closure-defines {"clairvoyant.core.devmode" true}
                           :output-to "resources/public/files/js/compiled/{{raw-name}}.js"
                           :output-dir "resources/public/files/js/compiled/out"
                           :source-map-timestamp true
                           :devcards true
                           :preloads [devtools.preload]
                           :parallel-build true}}

               {:id "min"
                :source-paths ["src/cljs" "src/cljc" "custom-lib"]
                :compiler {:main '{{raw-name}}.example-theme
                           :output-to "resources/public/files/js/compiled/example.js"
                           :output-dir "resources/public/files/js/compiled/example"
                           :source-map-timestamp true
                           :optimizations :advanced
                           :pretty-print false
                           :externs ["externs.js"]
                           :parallel-build true}}

               {:id "test"
                :source-paths ["src/cljs" "src/cljc" "test/cljs" "test/cljc" "test/doo" "custom-lib"]
                :compiler {:output-to "resources/public/files/js/compiled/testable.js"
                           :main ventas.test-runner
                           :optimizations :none
                           :parallel-build true}}]}

  :figwheel {:css-dirs ["resources/public/files/css"]
             :server-logfile "log/figwheel.log"
             :repl false}

  :doo {:build "test"}

  :sassc [{:src "src/scss/themes/example/main.scss"
           :output-to "resources/public/files/css/themes/example.css"
           :style "nested"
           :import-path "src/scss"}]

  :auto {"sassc" {:file-pattern  #"\.(scss)$"
                  :paths ["src/scss"]}}

  :profiles {:datomic-pro ^:leaky {:dependencies [[com.datomic/datomic-pro "0.9.5561.56" :exclusions [org.slf4j/slf4j-nop org.slf4j/slf4j-log4j12]]]}
             :datomic-free ^:leaky {:dependencies [[com.datomic/datomic-free "0.9.5561.56" :exclusions [org.slf4j/slf4j-nop org.slf4j/slf4j-log4j12]]]}
             :fmt {:source-paths ^:replace ["dev" "src/clj" "src/cljc" "src/cljs"]}
             :build-themes ^:leaky {:prep-tasks ["compile" ["cljsbuild" "once" "min"]]}
             :development {:dependencies [[org.codehaus.plexus/plexus-utils "3.0.15"]
                                          [ventas/devtools "0.0.9"]
                                          ;; CLJS
                                          [figwheel "0.5.15"]
                                          [figwheel-sidecar "0.5.15"]
                                          [com.cemerick/piggieback "0.2.2"]
                                          [binaryage/devtools "0.9.10"]]
                           :plugins [[lein-figwheel "0.5.15"]
                                     [cider/cider-nrepl "0.17.0-SNAPSHOT" :exclusions [org.clojure/tools.nrepl]]
                                     [refactor-nrepl "2.4.0-SNAPSHOT"]]
                           :source-paths ["dev"]}
             :repl ^:repl [:datomic-pro :development {:plugins [[venantius/ultra "0.5.2"]]}]
             :uberjar [:datomic-pro :build-themes {:source-paths ^:replace ["src/clj" "src/cljc" "custom-lib"]
                                                   :main ventas.core
                                                   :hooks [leiningen.sassc]
                                                   :omit-source true
                                                   :aot ~aot-namespaces}]})