(defproject ventas/devtools "0.0.10-SNAPSHOT"
  :description "Devtools for ventas"
  :url "https://github.com/JoelSanchez/ventas-devtools"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :repositories {"releases"
                 {:url "https://repo.clojars.org"
                  :creds :gpg}
                 "snapshots"
                 {:url "https://repo.clojars.org"
                  :creds :gpg}}
  :dependencies [[org.clojure/clojure "1.9.0"]
                 [org.clojure/tools.namespace "0.3.0-alpha4"]
                 [mount "0.1.12"]
                 [com.taoensso/timbre "4.10.0"]
                 [me.raynes/fs "1.4.6"]
                 [com.cemerick/pomegranate "0.3.1"]
                 [figwheel-sidecar "0.5.15"]]
  ;; This profile includes ventas as a dependency, to help IDEs with var resolution
  :profiles {:ide {:dependencies [[ventas "0.0.11-SNAPSHOT"]]}}
  :repl-options {:init-ns ventas-devtools.repl}
  :jvm-opts ["-XX:-OmitStackTraceInFastThrow"])
