(ns leiningen.new.nedap-lib
  "Generate a library project."
  (:require
   [leiningen.new.templates :refer [renderer year date project-name ->files sanitize-ns name-to-path multi-segment]]
   [leiningen.core.main :as main]))

(defn vemv-lib [name]
  (let [lib-prefix (or (System/getenv "NEDAP_CLJ_TEMPLATE_LIB_PREFIX")
                       "nedap")
        group-id (or (System/getenv "NEDAP_CLJ_TEMPLATE_GROUP_ID")
                     "com.nedap.staffing-solutions")
        render (renderer "nedap-lib")
        prefix (str lib-prefix "." name)
        main-ns (str prefix ".api")
        data {:raw-name        name
              :name            (project-name name)
              :namespace       main-ns
              :prefix          prefix
              :initial-release "0.1.0-alpha1"
              :group-id        group-id
              :prefix-dir      (name-to-path prefix)
              :nested-dirs     (name-to-path main-ns)
              :year            (year)
              :date            (date)}]
    (->files data
             ["project.clj" (render "project.clj" data)]
             ["README.md" (render "README.md" data)]
             [".gitignore" (render "gitignore" data)]
             [".github/pull_request_template.md" (render "pull_request_template.md" data)]
             ["src/{{nested-dirs}}.cljc" (render "api.cljc" data)]
             ["test/unit/{{nested-dirs}}.cljc" (render "test.cljc" data)]
             ["test/{{prefix-dir}}/test_runner.cljs" (render "test_runner.cljs" data)]
             ["LICENSE" (render "LICENSE" data)]
             ;; no `data` arg passed to the yml - would break the templating engine:
             [".circleci/config.yml" (render "config.yml")]
             "resources")))
