(ns vds.utils
  "Utility functions required to implement `VDS` components")

(defn extract-args
  "Given a vector of arguments, checks to see if the first argument is a map of options.
  Returns a 2-element vector containing the options (if any) and a vector of remaining
  arguments"
  [args]
  (if (map? (first args))
    [(first args) (rest args)]
    [nil args]))

(defn deep-merge [& maps]
  (apply merge-with (fn [& args]
                      (if (every? map? args)
                        (apply deep-merge args)
                        (last args)))
         maps))

(defn node-slurp [path]
  (let [fs (js/require "fs")]
    (.readFileSync fs path "utf8")))