(ns vds.ions.colors)

(def WHITE "#FFFFFF")
(def BLACK "#000000")

(defn colors
  [primitives]
  {; Primary Palette
   :primary    (:primary primitives)
   :primary50  (:primary50 primitives)
   :primary100 (:primary100 primitives)
   :primary200 (:primary200 primitives)
   :primary300 (:primary300 primitives)
   :primary400 (:primary400 primitives)
   :primary500 (:primary500 primitives)
   :primary600 (:primary600 primitives)
   :primary700 (:primary700 primitives)

   ; Accent Palette
   :accent    (:accent primitives)
   :accent50  (:accent50 primitives)
   :accent100 (:accent100 primitives)
   :accent200 (:accent200 primitives)
   :accent300 (:accent300 primitives)
   :accent400 (:accent400 primitives)
   :accent500 (:accent500 primitives)
   :accent600 (:accent600 primitives)
   :accent700 (:accent700 primitives)

   ; Negative Palette
   :negative    (:negative primitives)
   :negative50  (:negative50 primitives)
   :negative100 (:negative100 primitives)
   :negative200 (:negative200 primitives)
   :negative300 (:negative300 primitives)
   :negative400 (:negative400 primitives)
   :negative500 (:negative500 primitives)
   :negative600 (:negative600 primitives)
   :negative700 (:negative700 primitives)

   ; Warning Palette
   :warning    (:warning primitives)
   :warning50  (:warning50 primitives)
   :warning100 (:warning100 primitives)
   :warning200 (:warning200 primitives)
   :warning300 (:warning300 primitives)
   :warning400 (:warning400 primitives)
   :warning500 (:warning500 primitives)
   :warning600 (:warning600 primitives)
   :warning700 (:warning700 primitives)

   ; Positive Palette
   :positive    (:positive primitives)
   :positive50  (:positive50 primitives)
   :positive100 (:positive100 primitives)
   :positive200 (:positive200 primitives)
   :positive300 (:positive300 primitives)
   :positive400 (:positive400 primitives)
   :positive500 (:positive500 primitives)
   :positive600 (:positive600 primitives)
   :positive700 (:positive700 primitives)

   ; Monochrome Palette
   :white WHITE
   :mono     (:mono primitives)
   :mono50   (:mono50 primitives)
   :mono100  (:mono100 primitives)
   :mono200  (:mono200 primitives)
   :mono300  (:mono300 primitives)
   :mono400  (:mono400 primitives)
   :mono500  (:mono500 primitives)
   :mono600  (:mono600 primitives)
   :mono700  (:mono700 primitives)
   :mono800  (:mono800 primitives)
   :mono900  (:mono900 primitives)
   :mono1000 (:mono1000 primitives)
   :black BLACK

   ; Rating Palette
   :rating200 (:rating200 primitives)
   :rating400 (:rating400 primitives)

   ; Semantic Colors

   ; Font Color
   :color-primary (:mono1000 primitives)
   :color-secondary (:mono800 primitives)

   ; Background
   :background (:mono100 primitives)
   :background-alt (:mono100 primitives)
   :background-inv (:mono1000 primitives)

   ; Foreground
   :foreground (:mono1000 primitives)
   :foreground-alt (:mono800 primitives)
   :foreground-inv (:mono100 primitives)

   ; Borders
   :border (:mono500 primitives)
   :border-alt (:mono600 primitives)
   :border-focus (:primary primitives)
   :border-error (:negative primitives)})
