(ns vadelabs.fds.demo.core
  (:require [re-frame.core :refer [dispatch dispatch-sync]]
            [reagent.core :as reagent]
            [vadelabs.fds.demo.events :as events]
            [vadelabs.fds.demo.router :as router]
            [vadelabs.fds.demo.views :as views]))

(defn mount
  []
  (reagent/render-component
   [views/fds-app]
   (.getElementById js/document "app")))

(defn ^:export init
  []
  ;; Router config can be found with `./router.cljs`.
  ;; Here we are just hooking up the router on start
  (router/start)

  ;; Put an initial value into app-db.
  ;; The event handler for `:initialize-db` can be found in `events.cljs`
  ;; Using the sync version of dispatch means that value is in place
  ;; bfore we go onto the next step.
  (dispatch-sync [:initialize-db])

  ;; Render the UI into the HTML's <div id="app" /> element
  ;; The view function `conduit.views/fds-app` is the root
  ;; view for the entire UI.
  (mount))