(ns com.vadelabs.fds.demo.db
  (:require [cljs.reader]
            [re-frame.core :refer [reg-cofx]]))


;; -- Default app-db value
(def default-db 
  "When the application first starts, this will be the value put in app-db"
  {:active-page :home}) ;; What gets put in app-db by default


;; -- Local Storage --------
(def fds-user-key
  "fds-user")

(defn set-user-ls
  [user]
  (.setItem js/localStorage fds-user-key (str user)))

(defn remove-user-ls
  []
  (.removeItem js/localStorage fds-user-key))

;; -- cofx Registrations -------

;; User `reg-cofx` to register a "coeffect handler" which will inject the user 
;; stored in localStorage.
;; To see it used, look in `events.cljs` at the event handler for `:initialize-db`.
;; That event handler has the interceptor `(inject-cofx :local-store-user)`
;; The function registered below will be used to fulfill that request.
;;
;; We must supply a `sorted-map` but in localStorage it is sortedmap as a `map`.

(reg-cofx
 :local-store-user
 (fn [cofx _]
   (assoc cofx :local-store-user
          (into (sorted-map)
                (some->> (.getItem js/localStorage fds-user-key)
                         (cljs.reader/read-string))))))