(ns com.vadelabs.fds.atoms.block
  (:require 
   [com.stuartsierra.component :as component]
   [stylefy.core :refer [use-style]]
   [re-frame.core :refer [subscribe]]
   [com.vadelabs.fds.utils :as vdu]
   [com.vadelabs.fds.atoms.styles.block :as styles]))

(defn fda-block
  [& args]
  (let [[props] (vdu/extract-args args)
        theme @(subscribe [:theme])]
    (fn [& args]
      (let [[_ children] (vdu/extract-args args)]
        (into [:div (use-style (styles/fda-block props theme))] children)))))
