# riemann-java-heap

A Clojure library designed to monitor java heap usage in a separate
thread and report the stats to a Riemann server.

## Usage

Lein dependency:

![Version](https://clojars.org/uswitch/riemann-java-heap/latest-version.svg)

In the service or app you want to monitor, simply invoke
`start-observer`. The function takes four arguments:

- `client-opts` -  a map of options that will be used to construct the
  Clojure Riemann client. Besides any options understood by the client
  function, the following keys can be specified:
  - `:protocol`: can be used to control the protocol used. Can be
    either `:tcp` or `:udp`, default is `:tcp`.
  - `:ack`: `true` or `false`, require request to be acknowledged or not.

- `process-name` - the name of the process we are monitoring - used to
  construct the service name in the Riemann event.

- `interval` - the number of milliseconds between events.

- `ttl` - the time to live for each Riemann event. Should be more than
  `interval`, otherwise the events will expire.

Example:

```clj
(ns your-namespace
  (:require [uswitch.riemann-java-heap]))

(def observer
  (atom nil))

(defn start-system
  []
  (let [riemann-host "my-monitor.company.com"
        process-name "awesome service"
        interval 5000 ;; seconds
        ttl     15000 ;; seconds
        ]
    (reset! observer
            (uswitch.riemann-java-heap/start-observer
             {:host riemann-host} process-name interval ttl))))
```

`start-observer` returns a `HeapObserver` which can be stopped by
invoking `stop` on it.

```clj
(defn stop-system
  []
  (uswitch.riemann-java-heap/stop @observer))
```

## License

Copyright © 2013 uSwitch

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
