# riemann-java-heap

A Clojure library designed to monitor java heap usage in a separate
thread and report the stats to a Riemann server.

## Usage

Lein dependency:

    [uswitch/riemann-java-heap "0.1.0"]

In the service or app you want to monitor, simply invoke
`riemann-java-heap/start-observer`

```
(ns your-namespace
  (:require [riemann-java-heap]))

(def observer
  (atom nil))

(defn start-system
  []
  (let [riemann-host "my-monitor.company.com"
        process-name "awesome service"
        interval 5000 ;; seconds
        ttl     15000 ;; seconds]
    (reset! observer
            (riemann-java-heap/start-observer riemann-host process-name interval ttl))))
```

`start-observer` returns a `HeapObserver` which can be stopped by
invoking `riemann-java-heap/stop` on it.

```
(defn stop-system
  []
  (riemann-java-heap/stop @observer))
```

## License

Copyright © 2013 FIXME

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
