(ns {{name}}.views
  (:require [hiccup.core :refer [html]]
            [ring.util.anti-forgery :refer [anti-forgery-field]]))

(defn upload-page []
  (html
   [:head
    [:title "{{name}}"]]
   [:body
    [:h1 "Uploadatron needs a file"]
    [:form {:action "/upload" :method :post :enctype "multipart/form-data"}
     (anti-forgery-field)
     [:input {:name :file :type :file}]
     [:input {:name :submit :type :submit }]]]))

(defn success-page [msg]
  (html
   [:head
    [:title "{{name}}: success"]]
   [:body
    [:h1 "Upload successful"]
    [:p "Uploadatron says, \"" msg "\""]]))


(defn error-page [errors]
  (html
   [:head
    [:title "{{name}}: failure"]]
   [:body
    [:h1 "Upload failed"]
    [:p "Something happened, Uploadatron says, \"" errors "\""]]))
