(ns {{name}}.server
    (:require [compojure.core :refer :all]
            [compojure.route :as route]
            [{{name}}.views :as views]
            [ring.adapter.jetty :as jetty]
            [ring.middleware.defaults :refer [wrap-defaults site-defaults]]
            [ring.util.response :refer [response]]))

(def default-port 8080)
(def site-config (assoc-in site-defaults [:security :anti-forgery] false))

(defn process-upload [{:keys [:size :filename :tempfile] :as params}]
  (if false
    (views/error-page "An error has occured.")
    (views/success-page "That went well, it seems.")))

(defroutes app-routes
  (GET "/" []  (views/upload-page))
  (POST "/upload" [file :as params] (process-upload file))
  (route/not-found "Not Found"))

(def app
  (->
   app-routes
   (wrap-defaults site-config)))

(defn -main
  [& args]
  (jetty/run-jetty app {:port default-port}))
