# {{name}}

{{name}} is a simple Ring application that accepts a file upload. You can use the HTML form, or use [Curl]: from the command line.

## Goals

1. Get a file ingested, providing an entry point to more interesting dataflow.
1. Make it easier to build a prototype system of type P.
1. Be composed of nice S expressions.

## Development

### Setup a database
Start a REPL and create a new database with some default tables.

    (require '[{{name}}/db] :as db)
    (db/setup!)

This should give you a table called `file-uploads` or something. You can examine the file upload activity by querying this table.

### Running Tests
{{name}} uses [Leiningen 2](https://github.com/technomancy/leiningen/blob/master/doc/TUTORIAL.md).
Make sure you have it installed and then run tests against all supported Clojure versions using

    lein all test

### Running the application
1. Use =lein ring server= for a more interactive development experience.
2. Use =lein run= to spin up a server for a more production-like experience.

You should be able to post a file like:

curl -F "userid=1" -F "filecomment=This is an image file" -F "image=@/Users/sean/Dropbox/Public/sean-moustache.jpg" localhost:8080/upload
"<head><title>Uploadatron: success</title></head><body><h1>Upload successful</h1><p>Uploadatron says, "That went well, it seems."</p></body>"
