(defproject uniui.react "0.1.0-SNAPSHOT"
  :description "A React backend for uniui"
  :url "https://oss.conduitim.pl/uniui"
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url "https://www.eclipse.org/legal/epl-2.0/"}
  :dependencies [[org.clojure/clojurescript "1.10.597"]
                 [cljsjs/react "16.12.0-2"]
                 [cljsjs/react-dom "16.12.0-2"]]
  :repl-options {:init-ns uniui.core}
  :plugins [[lein-cljsbuild "1.1.7"]
            [lein-doo "0.1.10"]
            [lein-codox "0.10.7"]]
  :profiles {:dev {:dependencies [[eftest "0.5.9"]
                                  [doo "0.1.11"]
                                  [codox "0.10.7"]
                                  [viebel/codox-klipse-theme "0.0.5"]]}
             :ci  [:dev]}
  :deploy-repositories [["clojars" {:url "https://clojars.org/repo"
                                    :username :env/clojars_username
                                    :password :env/clojars_password}]
                        ["github" {:url "https://maven.pkg.github.com/conduitimpl/uniui.react"
                                   :username :env/github_username
                                   :password :env/github_password}]]
  :cljsbuild {:builds [{:id "test"
                        :source-paths ["src" "test"]
                        :compiler {:output-to "target/uniui.react-test.js"
                                   :main uniui.react.runner
                                   :optimizations :none
                                   :target :nodejs}}]}
  :codox {:language :clojurescript
          :source-uri "https://github.com/conduitimpl/uniui.react/blob/{git-commit}/{filepath}#L{line}"
          :metadata {:doc/format :markdown}
          :output-path "target/doc"
          :themes [:default [:klipse
                             {:klipse/external-libs
                              "https://oss.conduitim.pl/uniui.react/src"
                              :klipse/require-statement
                              "(ns uniui.react.user
                                 (:require [uniui.react.core :as react]))"}]]}
  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "v" "--no-sign"]
                  ["vcs" "push"]
                  ["vcs" "push" "--tags"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]])