(ns uniui.react.core
  (:require [uniui.react.react :as react]
            [uniui.react.react-dom :as react-dom])  )

(defn render
  "Similar to ReactDOM.render; renders a component to a DOM node"
  [component env node]
  (react-dom/render (react/create-element :h1 {} "Hello, world!") node))

(defn render-str
  "Similar to ReactDOMServer.render; renders a component to an HTML string"
  [component env]
  (react-dom/render-to-static-markup (react/create-element :h1 {} "Hello, world!")))