/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.nativelib;

import java.io.File;
import java.io.IOException;
import org.scijava.nativelib.DefaultJniExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeLibraryUtil {
    private static Architecture architecture = Architecture.UNKNOWN;
    private static final String DELIM = "/";
    private static final String JAVA_TMPDIR = "java.io.tmpdir";
    private static final Logger LOGGER = LoggerFactory.getLogger("org.scijava.nativelib.NativeLibraryUtil");

    public static Architecture getArchitecture() {
        Processor processor;
        if (Architecture.UNKNOWN == architecture && Processor.UNKNOWN != (processor = NativeLibraryUtil.getProcessor())) {
            String name = System.getProperty("os.name").toLowerCase();
            if (name.contains("nix") || name.contains("nux")) {
                if (Processor.INTEL_32 == processor) {
                    architecture = Architecture.LINUX_32;
                } else if (Processor.INTEL_64 == processor) {
                    architecture = Architecture.LINUX_64;
                } else if (Processor.ARM == processor) {
                    architecture = Architecture.LINUX_ARM;
                } else if (Processor.AARCH_64 == processor) {
                    architecture = Architecture.LINUX_ARM64;
                }
            } else if (name.contains("win")) {
                if (Processor.INTEL_32 == processor) {
                    architecture = Architecture.WINDOWS_32;
                } else if (Processor.INTEL_64 == processor) {
                    architecture = Architecture.WINDOWS_64;
                }
            } else if (name.contains("mac")) {
                if (Processor.INTEL_32 == processor) {
                    architecture = Architecture.OSX_32;
                } else if (Processor.INTEL_64 == processor) {
                    architecture = Architecture.OSX_64;
                } else if (Processor.PPC == processor) {
                    architecture = Architecture.OSX_PPC;
                }
            }
        }
        LOGGER.debug("architecture is " + (Object)((Object)architecture) + " os.name is " + System.getProperty("os.name").toLowerCase());
        return architecture;
    }

    private static Processor getProcessor() {
        Processor processor = Processor.UNKNOWN;
        String arch = System.getProperty("os.arch").toLowerCase();
        if (arch.contains("arm")) {
            processor = Processor.ARM;
        } else if (arch.contains("aarch64")) {
            processor = Processor.AARCH_64;
        } else if (arch.contains("ppc")) {
            processor = Processor.PPC;
        } else if (arch.contains("86") || arch.contains("amd")) {
            int bits = 32;
            if (arch.contains("64")) {
                bits = 64;
            }
            processor = 32 == bits ? Processor.INTEL_32 : Processor.INTEL_64;
        }
        LOGGER.debug("processor is " + (Object)((Object)processor) + " os.arch is " + System.getProperty("os.arch").toLowerCase());
        return processor;
    }

    public static String getPlatformLibraryPath() {
        String path = "META-INF/lib/";
        path = path + NativeLibraryUtil.getArchitecture().name().toLowerCase() + DELIM;
        LOGGER.debug("platform specific path is " + path);
        return path;
    }

    public static String getPlatformLibraryName(String libName) {
        String name = null;
        switch (NativeLibraryUtil.getArchitecture()) {
            case LINUX_32: 
            case LINUX_64: 
            case LINUX_ARM: 
            case LINUX_ARM64: {
                name = libName + ".so";
                break;
            }
            case WINDOWS_32: 
            case WINDOWS_64: {
                name = libName + ".dll";
                break;
            }
            case OSX_32: 
            case OSX_64: {
                name = "lib" + libName + ".dylib";
            }
        }
        LOGGER.debug("native library name " + name);
        return name;
    }

    public static String getVersionedLibraryName(Class<?> libraryJarClass, String libName) {
        String version = libraryJarClass.getPackage().getImplementationVersion();
        if (null != version && version.length() > 0) {
            libName = libName + "-" + version;
        }
        return libName;
    }

    public static boolean loadVersionedNativeLibrary(Class<?> libraryJarClass, String libName) {
        libName = NativeLibraryUtil.getVersionedLibraryName(libraryJarClass, libName);
        return NativeLibraryUtil.loadNativeLibrary(libraryJarClass, libName);
    }

    public static boolean loadNativeLibrary(Class<?> libraryJarClass, String libName) {
        boolean success = false;
        if (Architecture.UNKNOWN == NativeLibraryUtil.getArchitecture()) {
            LOGGER.warn("No native library available for this platform.");
        } else {
            try {
                String tmpDirectory = System.getProperty(JAVA_TMPDIR);
                DefaultJniExtractor jniExtractor = new DefaultJniExtractor(libraryJarClass, tmpDirectory);
                File extractedFile = jniExtractor.extractJni(NativeLibraryUtil.getPlatformLibraryPath(), libName);
                System.load(extractedFile.getPath());
                success = true;
            }
            catch (IOException e) {
                LOGGER.debug("IOException creating DefaultJniExtractor", e);
            }
            catch (SecurityException e) {
                LOGGER.debug("Can't load dynamic library", e);
            }
            catch (UnsatisfiedLinkError e) {
                LOGGER.debug("Problem with library", e);
            }
        }
        return success;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Processor {
        UNKNOWN,
        INTEL_32,
        INTEL_64,
        PPC,
        ARM,
        AARCH_64;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Architecture {
        UNKNOWN,
        LINUX_32,
        LINUX_64,
        LINUX_ARM,
        LINUX_ARM64,
        WINDOWS_32,
        WINDOWS_64,
        OSX_32,
        OSX_64,
        OSX_PPC;

    }
}

