(ns tawny.flatten)


;; So I want a function that will remove lists which only have lists in them,
;; and replace them with the lists. This will make my rendered output nicer in
;; the as-form bit. It shouldn't affect general rendering because that goes
;; through form.

(defn semi-flatten [coll]
  (tree-seq sequential? seq coll))


;; unchanged
(semi-flatten
 '(1 2 3 4))

;; unchanged
(semi-flatten
 '(1 2 [3 4]))


;; (1 2 3 4)
(semi-flatten
 '(1 2 3 4 []))

(semi-flatten
 '([] 1 2 3 4))

;; (1 2 [3 4])
(semi-flatten
 '(1 2 [[3 4]]))

;; (1 [2 3] 4)
(semi-flatten
 '(1 [[2 3]] 4))

;; (1 [2] [3] [4])
(semi-flatten
 '(1 [2] [[3]] [[[4]]]))

;; (1 [2 3] [4 5] 6)
(semi-flatten
 '(1 [[2 3] [4 5]] 6)
 )


(concat [2 3] [4 5])
(concat 1 [[2 3]])

;; this does the right thing
(list* 1 [[2 3]])


