(ns tawny.testreify
  (:use [tawny.owl]))


;; -------------------------
;; clojure.core/reify
;; ([& opts+specs])
;; Macro
;;   reify is a macro with the following structure:

;;  (reify options* specs*)
  
;;   Currently there are no options.

;;   Each spec consists of the protocol or interface name followed by zero
;;   or more method bodies:

;;   protocol-or-interface-or-Object
;;   (methodName [args+] body)*

;;   Methods should be supplied for all methods of the desired
;;   protocol(s) and interface(s). You can also define overrides for
;;   methods of Object. Note that the first parameter must be supplied to
;;   correspond to the target object ('this' in Java parlance). Thus
;;   methods for interfaces will take one more argument than do the
;;   interface declarations.  Note also that recur calls to the method
;;   head should *not* pass the target object, it will be supplied
;;   automatically and can not be substituted.

;;   The return type can be indicated by a type hint on the method name,
;;   and arg types can be indicated by a type hint on arg names. If you
;;   leave out all hints, reify will try to match on same name/arity
;;   method in the protocol(s)/interface(s) - this is preferred. If you
;;   supply any hints at all, no inference is done, so all hints (or
;;   default of Object) must be correct, for both arguments and return
;;   type. If a method is overloaded in a protocol/interface, multiple
;;   independent method definitions must be supplied.  If overloaded with
;;   same arity in an interface you must specify complete hints to
;;   disambiguate - a missing hint implies Object.

;;   recur works to method heads The method bodies of reify are lexical
;;   closures, and can refer to the surrounding local scope:

;;   (str (let [f "foo"]
;;        (reify Object
;;          (toString [this] f))))
;;   == "foo"

;;   (seq (let [f "foo"]
;;        (reify clojure.lang.Seqable
;;          (seq [this] (seq f)))))
;;   == (\f \o \o))

;;   reify always implements clojure.lang.IObj and transfers meta
;;   data of the form to the created object.

;;   (meta ^{:k :v} (reify Object (toString [this] "foo")))
;; ;;   == {:k :v}
;; (defn ontology-visitor []
;;   (reify org.semanticweb.owlapi.model.OWLObjectVisitor
;;     (^void visit [this
;;                   ^org.semanticweb.owlapi.model.OWLOntology o]
;;       (println "v ontology" o))))



;; (defontology ont)
;; (.visit (ontology-visitor) ont)

;; ;; so this is working, but with a void return type from visit, how do get
;; ;; anything out? We could create a visitor for every invocation, then we can
;; ;; set something in the lexical environment and get the return type of the
;; ;; invocation out.
;; (defn visit-entity [entity]
;;   (let [r (atom nil)]
;;     (.visit
;;      (reify org.semanticweb.owlapi.model.OWLObjectVisitor
;;        (^void visit [this
;;                      ^org.semanticweb.owlapi.model.OWLOntology o]
;;          (reset! r
;;                  (str "visit o" o)))

;;        (^void visit [this
;;                      ^org.semanticweb.owlapi.model.OWLClass c]
;;          (reset! r
;;                  (str "visit class" c))))
;;      entity)
;;     @r))

;; (visit-entity ont)

;; (defclass A)
;; (visit-entity A)

;; ;; this seems fairly sucky to me. We are create a new atom *and* a new visit
;; ;; for every entity.
;; ;; we can create a new form visitor, stick it in the options and pass it down.

;; (use 'criterium.core)

;; ;; 220 us -- slow, slow, slow
;; (quick-bench (visit-entity A))

;; ;; 150 ns -- so quick enough
;; (quick-bench (atom nil))

;; ;; 200 ns -- so object creation doesn't seem slow
;; (quick-bench
;;  (let [r (atom nil)]
;;    (reify org.semanticweb.owlapi.model.OWLObjectVisitor
;;      (^void visit [this
;;                    ^org.semanticweb.owlapi.model.OWLOntology o]
;;        (reset! r
;;                (str "visit o" o)))

;;      (^void visit [this
;;                    ^org.semanticweb.owlapi.model.OWLClass c]
;;        (reset! r
;;                (str "visit class" c))))))

;; ;; what about this, without doing anything in the class
;; ;; 230us which is pretty sucky -- I guess the reified proxy is invoking by
;; ;; doing lots of clever instance? calls which is what we are trying to avoid.
;; ;; 230us is pretty close to what we were getting from multi-method invocation,
;; ;; which tends to make me think we are dead in the water.
;; (quick-bench
;;  (.visit
;;   (let [r (atom nil)]
;;     (reify org.semanticweb.owlapi.model.OWLObjectVisitor
;;       (^void visit [this
;;                     ^org.semanticweb.owlapi.model.OWLOntology o])

;;       (^void visit [this
;;                     ^org.semanticweb.owlapi.model.OWLClass c])))
;;   A))


